
/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
DROP TABLE IF EXISTS `account_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `account_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(11) NOT NULL,
  `type` enum('debit','credit') COLLATE utf8mb4_unicode_ci NOT NULL,
  `sub_type` enum('opening_balance','fund_transfer','deposit') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(22,4) NOT NULL,
  `reff_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `operation_date` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `transaction_payment_id` int(11) DEFAULT NULL,
  `transfer_transaction_id` int(11) DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `account_transactions_account_id_index` (`account_id`) USING BTREE,
  KEY `account_transactions_transaction_id_index` (`transaction_id`) USING BTREE,
  KEY `account_transactions_transaction_payment_id_index` (`transaction_payment_id`) USING BTREE,
  KEY `account_transactions_transfer_transaction_id_index` (`transfer_transaction_id`) USING BTREE,
  KEY `account_transactions_created_by_index` (`created_by`) USING BTREE,
  KEY `account_transactions_type_index` (`type`) USING BTREE,
  KEY `account_transactions_sub_type_index` (`sub_type`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_transactions` WRITE;
/*!40000 ALTER TABLE `account_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `account_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `account_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_account_type_id` int(11) DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `account_types_parent_account_type_id_index` (`parent_account_type_id`) USING BTREE,
  KEY `account_types_business_id_index` (`business_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_types` WRITE;
/*!40000 ALTER TABLE `account_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_number` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_type_id` int(11) DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `created_by` int(11) NOT NULL,
  `is_closed` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `accounts_business_id_index` (`business_id`) USING BTREE,
  KEY `accounts_account_type_id_index` (`account_type_id`) USING BTREE,
  KEY `accounts_created_by_index` (`created_by`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `activity_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `log_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject_id` int(11) DEFAULT NULL,
  `subject_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `causer_id` int(11) DEFAULT NULL,
  `causer_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `properties` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `activity_log_log_name_index` (`log_name`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2390 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `activity_log` WRITE;
/*!40000 ALTER TABLE `activity_log` DISABLE KEYS */;
INSERT INTO `activity_log` VALUES (1,'default','login',1,'App\\User',1,'App\\User','[]','2021-08-06 01:22:17','2021-08-06 01:22:17'),(2,'default','added',2,'App\\User',1,'App\\User','[]','2021-08-05 22:07:52','2021-08-05 22:07:52'),(3,'default','edited',2,'App\\User',1,'App\\User','[]','2021-08-05 22:20:08','2021-08-05 22:20:08'),(4,'default','status_changed',1,'Modules\\Repair\\Entities\\JobSheet',1,'App\\User','{\"update_note\":null,\"updated_status\":\"Finished\"}','2021-08-05 22:23:51','2021-08-05 22:23:51'),(5,'default','added',1,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-08-05 22:27:36','2021-08-05 22:27:36'),(6,'default','edited',1,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"500.0000\"}}','2021-08-05 22:47:14','2021-08-05 22:47:14'),(7,'default','status_changed',2,'Modules\\Repair\\Entities\\JobSheet',1,'App\\User','{\"update_note\":null,\"updated_status\":\"Finished\"}','2021-08-06 02:01:30','2021-08-06 02:01:30'),(8,'default','added',2,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-08-06 02:03:33','2021-08-06 02:03:33'),(9,'default','added',2,'App\\Contact',1,'App\\User','[]','2021-08-06 02:28:33','2021-08-06 02:28:33'),(10,'default','added',3,'App\\Transaction',1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-08-06 02:32:45','2021-08-06 02:32:45'),(11,'default','payment_edited',3,'App\\Transaction',1,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"},\"old\":{\"payment_status\":\"due\"}}','2021-08-06 02:32:58','2021-08-06 02:32:58'),(12,'default','added',4,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":500}}','2021-08-06 02:33:53','2021-08-06 02:33:53'),(13,'default','added',5,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":250}}','2021-08-06 02:37:57','2021-08-06 02:37:57'),(14,'default','payment_edited',5,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"250.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"250.0000\"}}','2021-08-06 02:38:34','2021-08-06 02:38:34'),(15,'default','login',1,'App\\User',1,'App\\User','[]','2021-08-06 03:37:23','2021-08-06 03:37:23'),(16,'default','login',1,'App\\User',1,'App\\User','[]','2021-08-06 04:53:37','2021-08-06 04:53:37'),(17,'default','login',1,'App\\User',1,'App\\User','[]','2021-08-07 01:06:07','2021-08-07 01:06:07'),(18,'default','login',1,'App\\User',1,'App\\User','[]','2021-08-07 13:44:31','2021-08-07 13:44:31'),(19,'default','login',1,'App\\User',1,'App\\User','[]','2021-08-07 13:57:04','2021-08-07 13:57:04'),(20,'default','login',1,'App\\User',1,'App\\User','[]','2021-08-07 14:37:43','2021-08-07 14:37:43'),(21,'default','added',3,'App\\User',1,'App\\User','[]','2021-08-07 14:41:42','2021-08-07 14:41:42'),(22,'default','status_changed',5,'Modules\\Repair\\Entities\\JobSheet',1,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating\"}','2021-08-07 17:02:30','2021-08-07 17:02:30'),(23,'default','added',7,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250}}','2021-08-07 17:17:18','2021-08-07 17:17:18'),(24,'default','status_changed',5,'Modules\\Repair\\Entities\\JobSheet',1,'App\\User','{\"update_note\":null,\"updated_status\":\"Finished\"}','2021-08-07 17:31:46','2021-08-07 17:31:46'),(25,'default','status_changed',7,'App\\Transaction',1,'App\\User','{\"update_note\":\"done\",\"updated_status\":\"Finished\"}','2021-08-07 17:33:00','2021-08-07 17:33:00'),(26,'default','added',8,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250}}','2021-08-07 17:35:13','2021-08-07 17:35:13'),(27,'default','status_changed',6,'Modules\\Repair\\Entities\\JobSheet',1,'App\\User','{\"update_note\":\"waiting check\",\"updated_status\":\"In Progress\"}','2021-08-07 18:08:40','2021-08-07 18:08:40'),(28,'default','status_changed',6,'Modules\\Repair\\Entities\\JobSheet',1,'App\\User','{\"update_note\":\"Done\",\"updated_status\":\"Finished\"}','2021-08-07 18:10:04','2021-08-07 18:10:04'),(29,'default','added',9,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1750}}','2021-08-07 18:11:33','2021-08-07 18:11:33'),(30,'default','added',4,'App\\User',1,'App\\User','[]','2021-08-07 18:55:22','2021-08-07 18:55:22'),(31,'default','added',10,'App\\Transaction',1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-08-07 19:05:02','2021-08-07 19:05:02'),(32,'default','added',3,'App\\Contact',1,'App\\User','[]','2021-08-08 00:57:35','2021-08-08 00:57:35'),(33,'default','login',1,'App\\User',1,'App\\User','[]','2021-08-08 14:58:33','2021-08-08 14:58:33'),(34,'default','added',4,'App\\Contact',1,'App\\User','[]','2021-08-08 14:59:47','2021-08-08 14:59:47'),(35,'default','status_changed',8,'Modules\\Repair\\Entities\\JobSheet',1,'App\\User','{\"update_note\":null,\"updated_status\":\"Finished\"}','2021-08-08 15:06:57','2021-08-08 15:06:57'),(36,'default','added',11,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250}}','2021-08-08 20:11:51','2021-08-08 20:11:51'),(37,'default','added',12,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250}}','2021-08-08 22:37:49','2021-08-08 22:37:49'),(38,'default','added',13,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250}}','2021-08-08 22:37:55','2021-08-08 22:37:55'),(39,'default','added',14,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-08-08 22:38:24','2021-08-08 22:38:24'),(40,'default','added',5,'App\\User',1,'App\\User','[]','2021-08-09 14:46:04','2021-08-09 14:46:04'),(41,'default','login',1,'App\\User',1,'App\\User','[]','2021-08-09 18:25:23','2021-08-09 18:25:23'),(42,'default','status_changed',10,'Modules\\Repair\\Entities\\JobSheet',1,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-09 18:33:25','2021-08-09 18:33:25'),(43,'default','status_changed',11,'Modules\\Repair\\Entities\\JobSheet',1,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-09 18:33:37','2021-08-09 18:33:37'),(44,'default','added',15,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1}}','2021-08-09 18:35:30','2021-08-09 18:35:30'),(45,'default','login',1,'App\\User',1,'App\\User','[]','2021-08-12 15:20:59','2021-08-12 15:20:59'),(46,'default','login',1,'App\\User',1,'App\\User','[]','2021-08-12 18:49:45','2021-08-12 18:49:45'),(47,'default','login',1,'App\\User',1,'App\\User','[]','2021-08-13 01:14:35','2021-08-13 01:14:35'),(48,'default','login',1,'App\\User',1,'App\\User','[]','2021-08-13 21:19:26','2021-08-13 21:19:26'),(49,'default','added',5,'App\\Contact',1,'App\\User','[]','2021-08-13 21:20:53','2021-08-13 21:20:53'),(50,'default','login',1,'App\\User',1,'App\\User','[]','2021-08-13 21:25:46','2021-08-13 21:25:46'),(51,'default','login',1,'App\\User',1,'App\\User','[]','2021-08-16 14:16:18','2021-08-16 14:16:18'),(52,'default','edited',4,'App\\User',1,'App\\User','[]','2021-08-16 14:18:59','2021-08-16 14:18:59'),(53,'default','added',6,'App\\User',1,'App\\User','[]','2021-08-16 14:32:31','2021-08-16 14:32:31'),(54,'default','added',7,'App\\User',1,'App\\User','[]','2021-08-16 14:33:47','2021-08-16 14:33:47'),(55,'default','edited',7,'App\\User',1,'App\\User','[]','2021-08-16 14:34:18','2021-08-16 14:34:18'),(56,'default','added',8,'App\\User',1,'App\\User','[]','2021-08-16 14:35:54','2021-08-16 14:35:54'),(57,'default','added',9,'App\\User',1,'App\\User','[]','2021-08-16 15:05:05','2021-08-16 15:05:05'),(58,'default','added',6,'App\\Contact',1,'App\\User','[]','2021-08-16 15:08:07','2021-08-16 15:08:07'),(59,'default','status_changed',12,'Modules\\Repair\\Entities\\JobSheet',1,'App\\User','{\"update_note\":null,\"updated_status\":\"Finished\"}','2021-08-16 15:30:00','2021-08-16 15:30:00'),(60,'default','status_changed',12,'Modules\\Repair\\Entities\\JobSheet',1,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-16 15:30:10','2021-08-16 15:30:10'),(61,'default','status_changed',12,'Modules\\Repair\\Entities\\JobSheet',1,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-08-16 15:31:02','2021-08-16 15:31:02'),(62,'default','added',16,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":1000}}','2021-08-16 15:34:31','2021-08-16 15:34:31'),(63,'default','added',17,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":500}}','2021-08-16 15:39:16','2021-08-16 15:39:16'),(64,'default','status_changed',12,'Modules\\Repair\\Entities\\JobSheet',1,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-08-16 15:46:14','2021-08-16 15:46:14'),(65,'default','added',18,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":200}}','2021-08-16 15:52:14','2021-08-16 15:52:14'),(66,'default','logout',1,'App\\User',1,'App\\User','[]','2021-08-16 15:56:13','2021-08-16 15:56:13'),(67,'default','login',9,'App\\User',9,'App\\User','[]','2021-08-16 15:56:37','2021-08-16 15:56:37'),(68,'default','added',7,'App\\Contact',9,'App\\User','[]','2021-08-16 16:00:28','2021-08-16 16:00:28'),(69,'default','added',19,'App\\Transaction',9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":1000}}','2021-08-16 16:00:37','2021-08-16 16:00:37'),(70,'default','added',20,'App\\Transaction',9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":200}}','2021-08-16 16:04:31','2021-08-16 16:04:31'),(71,'default','logout',9,'App\\User',9,'App\\User','[]','2021-08-16 16:13:24','2021-08-16 16:13:24'),(72,'default','login',1,'App\\User',1,'App\\User','[]','2021-08-16 16:13:33','2021-08-16 16:13:33'),(73,'default','edited',6,'App\\User',1,'App\\User','[]','2021-08-16 16:14:13','2021-08-16 16:14:13'),(74,'default','added',10,'App\\User',1,'App\\User','[]','2021-08-16 16:15:56','2021-08-16 16:15:56'),(75,'default','added',8,'App\\Contact',1,'App\\User','[]','2021-08-16 16:20:18','2021-08-16 16:20:18'),(76,'default','login',4,'App\\User',4,'App\\User','[]','2021-08-16 16:20:37','2021-08-16 16:20:37'),(77,'default','added',9,'App\\Contact',4,'App\\User','[]','2021-08-16 16:34:33','2021-08-16 16:34:33'),(78,'default','logout',1,'App\\User',1,'App\\User','[]','2021-08-16 16:37:12','2021-08-16 16:37:12'),(79,'default','login',9,'App\\User',9,'App\\User','[]','2021-08-16 16:37:19','2021-08-16 16:37:19'),(80,'default','status_changed',14,'Modules\\Repair\\Entities\\JobSheet',9,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-08-16 16:38:47','2021-08-16 16:38:47'),(81,'default','status_changed',13,'Modules\\Repair\\Entities\\JobSheet',9,'App\\User','{\"update_note\":null,\"updated_status\":\"Can\'t be repaired\"}','2021-08-16 16:39:01','2021-08-16 16:39:01'),(82,'default','added',21,'App\\Transaction',9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3000}}','2021-08-16 16:46:21','2021-08-16 16:46:21'),(83,'default','added',22,'App\\Transaction',9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":1200}}','2021-08-16 16:47:23','2021-08-16 16:47:23'),(84,'default','logout',9,'App\\User',9,'App\\User','[]','2021-08-16 17:11:06','2021-08-16 17:11:06'),(85,'default','login',1,'App\\User',1,'App\\User','[]','2021-08-16 17:11:13','2021-08-16 17:11:13'),(86,'default','logout',1,'App\\User',1,'App\\User','[]','2021-08-16 17:11:49','2021-08-16 17:11:49'),(87,'default','login',9,'App\\User',9,'App\\User','[]','2021-08-16 17:11:54','2021-08-16 17:11:54'),(88,'default','logout',9,'App\\User',9,'App\\User','[]','2021-08-16 17:15:09','2021-08-16 17:15:09'),(89,'default','login',1,'App\\User',1,'App\\User','[]','2021-08-16 17:15:20','2021-08-16 17:15:20'),(90,'default','logout',1,'App\\User',1,'App\\User','[]','2021-08-16 17:18:57','2021-08-16 17:18:57'),(91,'default','login',9,'App\\User',9,'App\\User','[]','2021-08-16 17:19:06','2021-08-16 17:19:06'),(92,'default','logout',9,'App\\User',9,'App\\User','[]','2021-08-16 17:23:37','2021-08-16 17:23:37'),(93,'default','login',1,'App\\User',1,'App\\User','[]','2021-08-16 17:23:44','2021-08-16 17:23:44'),(94,'default','logout',1,'App\\User',1,'App\\User','[]','2021-08-16 17:33:06','2021-08-16 17:33:06'),(95,'default','login',9,'App\\User',9,'App\\User','[]','2021-08-16 17:33:19','2021-08-16 17:33:19'),(96,'default','logout',9,'App\\User',9,'App\\User','[]','2021-08-16 17:35:57','2021-08-16 17:35:57'),(97,'default','login',1,'App\\User',1,'App\\User','[]','2021-08-16 17:36:06','2021-08-16 17:36:06'),(98,'default','login',9,'App\\User',9,'App\\User','[]','2021-08-16 17:37:59','2021-08-16 17:37:59'),(99,'default','login',9,'App\\User',9,'App\\User','[]','2021-08-16 17:40:28','2021-08-16 17:40:28'),(100,'default','logout',9,'App\\User',9,'App\\User','[]','2021-08-16 17:45:59','2021-08-16 17:45:59'),(101,'default','login',4,'App\\User',4,'App\\User','[]','2021-08-16 17:46:11','2021-08-16 17:46:11'),(102,'default','edited',4,'App\\User',1,'App\\User','[]','2021-08-16 17:51:44','2021-08-16 17:51:44'),(103,'default','added',10,'App\\Contact',9,'App\\User','[]','2021-08-16 17:53:18','2021-08-16 17:53:18'),(104,'default','added',23,'App\\Transaction',9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}','2021-08-16 17:55:06','2021-08-16 17:55:06'),(105,'default','status_changed',17,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Check In Progress\"}','2021-08-16 17:55:12','2021-08-16 17:55:12'),(106,'default','added',24,'App\\Transaction',9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}','2021-08-16 17:57:07','2021-08-16 17:57:07'),(107,'default','logout',9,'App\\User',9,'App\\User','[]','2021-08-16 18:04:15','2021-08-16 18:04:15'),(108,'default','login',9,'App\\User',9,'App\\User','[]','2021-08-16 18:04:22','2021-08-16 18:04:22'),(109,'default','added',25,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-08-16 18:06:54','2021-08-16 18:06:54'),(110,'default','edited',9,'App\\User',1,'App\\User','[]','2021-08-16 18:16:40','2021-08-16 18:16:40'),(111,'default','added',26,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5000}}','2021-08-16 18:26:32','2021-08-16 18:26:32'),(112,'default','added',27,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5000}}','2021-08-16 18:30:19','2021-08-16 18:30:19'),(113,'default','added',28,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-08-16 18:34:48','2021-08-16 18:34:48'),(114,'default','added',29,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250}}','2021-08-16 18:35:39','2021-08-16 18:35:39'),(115,'default','logout',1,'App\\User',1,'App\\User','[]','2021-08-16 18:38:29','2021-08-16 18:38:29'),(116,'default','login',9,'App\\User',9,'App\\User','[]','2021-08-16 18:38:33','2021-08-16 18:38:33'),(117,'default','added',11,'App\\Contact',9,'App\\User','[]','2021-08-16 18:40:14','2021-08-16 18:40:14'),(118,'default','added',30,'App\\Transaction',9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-08-16 18:41:14','2021-08-16 18:41:14'),(119,'default','logout',9,'App\\User',9,'App\\User','[]','2021-08-16 19:08:59','2021-08-16 19:08:59'),(120,'default','login',4,'App\\User',4,'App\\User','[]','2021-08-16 19:09:13','2021-08-16 19:09:13'),(121,'default','added',31,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-08-16 19:13:15','2021-08-16 19:13:15'),(122,'default','added',32,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":500}}','2021-08-16 19:18:28','2021-08-16 19:18:28'),(123,'default','logout',4,'App\\User',4,'App\\User','[]','2021-08-16 19:37:36','2021-08-16 19:37:36'),(124,'default','login',1,'App\\User',1,'App\\User','[]','2021-08-16 19:37:47','2021-08-16 19:37:47'),(125,'default','logout',1,'App\\User',1,'App\\User','[]','2021-08-16 20:10:39','2021-08-16 20:10:39'),(126,'default','login',9,'App\\User',9,'App\\User','[]','2021-08-16 20:10:47','2021-08-16 20:10:47'),(127,'default','login',1,'App\\User',1,'App\\User','[]','2021-08-16 21:10:38','2021-08-16 21:10:38'),(128,'default','login',9,'App\\User',9,'App\\User','[]','2021-08-16 22:34:33','2021-08-16 22:34:33'),(129,'default','login',9,'App\\User',9,'App\\User','[]','2021-08-16 22:35:23','2021-08-16 22:35:23'),(130,'default','login',9,'App\\User',9,'App\\User','[]','2021-08-16 22:43:24','2021-08-16 22:43:24'),(131,'default','login',9,'App\\User',9,'App\\User','[]','2021-08-16 23:24:30','2021-08-16 23:24:30'),(132,'default','login',9,'App\\User',9,'App\\User','[]','2021-08-17 14:48:07','2021-08-17 14:48:07'),(133,'default','login',4,'App\\User',4,'App\\User','[]','2021-08-17 14:51:10','2021-08-17 14:51:10'),(134,'default','login',1,'App\\User',1,'App\\User','[]','2021-08-17 15:10:01','2021-08-17 15:10:01'),(135,'default','login',4,'App\\User',4,'App\\User','[]','2021-08-17 19:35:34','2021-08-17 19:35:34'),(136,'default','login',9,'App\\User',9,'App\\User','[]','2021-08-18 00:38:31','2021-08-18 00:38:31'),(137,'default','login',1,'App\\User',1,'App\\User','[]','2021-08-19 14:38:56','2021-08-19 14:38:56'),(138,'default','login',1,'App\\User',1,'App\\User','[]','2021-08-19 18:09:51','2021-08-19 18:09:51'),(139,'default','login',4,'App\\User',4,'App\\User','[]','2021-08-19 18:34:39','2021-08-19 18:34:39'),(140,'default','added',12,'App\\Contact',4,'App\\User','[]','2021-08-19 18:36:43','2021-08-19 18:36:43'),(141,'default','login',4,'App\\User',4,'App\\User','[]','2021-08-19 19:22:48','2021-08-19 19:22:48'),(142,'default','login',1,'App\\User',1,'App\\User','[]','2021-08-19 19:25:02','2021-08-19 19:25:02'),(143,'default','added',13,'App\\Contact',4,'App\\User','[]','2021-08-19 21:35:34','2021-08-19 21:35:34'),(144,'default','login',4,'App\\User',4,'App\\User','[]','2021-08-19 22:12:41','2021-08-19 22:12:41'),(145,'default','login',1,'App\\User',1,'App\\User','[]','2021-08-21 14:16:34','2021-08-21 14:16:34'),(146,'default','logout',1,'App\\User',1,'App\\User','[]','2021-08-21 14:18:38','2021-08-21 14:18:38'),(147,'default','login',4,'App\\User',4,'App\\User','[]','2021-08-21 14:18:44','2021-08-21 14:18:44'),(148,'default','added',14,'App\\Contact',4,'App\\User','[]','2021-08-21 14:19:52','2021-08-21 14:19:52'),(149,'default','added',33,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":200}}','2021-08-21 14:22:49','2021-08-21 14:22:49'),(150,'default','login',1,'App\\User',1,'App\\User','[]','2021-08-21 15:16:03','2021-08-21 15:16:03'),(151,'default','logout',1,'App\\User',1,'App\\User','[]','2021-08-21 15:20:06','2021-08-21 15:20:06'),(152,'default','login',4,'App\\User',4,'App\\User','[]','2021-08-21 15:20:16','2021-08-21 15:20:16'),(153,'default','logout',4,'App\\User',4,'App\\User','[]','2021-08-21 15:21:21','2021-08-21 15:21:21'),(154,'default','login',1,'App\\User',1,'App\\User','[]','2021-08-21 15:21:45','2021-08-21 15:21:45'),(155,'default','logout',1,'App\\User',1,'App\\User','[]','2021-08-21 15:47:01','2021-08-21 15:47:01'),(156,'default','login',4,'App\\User',4,'App\\User','[]','2021-08-21 15:47:13','2021-08-21 15:47:13'),(157,'default','logout',4,'App\\User',4,'App\\User','[]','2021-08-21 15:48:30','2021-08-21 15:48:30'),(158,'default','login',1,'App\\User',1,'App\\User','[]','2021-08-21 15:48:47','2021-08-21 15:48:47'),(159,'default','login',4,'App\\User',4,'App\\User','[]','2021-08-21 17:15:48','2021-08-21 17:15:48'),(160,'default','added',15,'App\\Contact',4,'App\\User','[]','2021-08-21 17:17:07','2021-08-21 17:17:07'),(161,'default','logout',4,'App\\User',4,'App\\User','[]','2021-08-21 17:53:27','2021-08-21 17:53:27'),(162,'default','login',1,'App\\User',1,'App\\User','[]','2021-08-21 17:53:40','2021-08-21 17:53:40'),(163,'default','added',11,'App\\User',1,'App\\User','[]','2021-08-21 17:56:35','2021-08-21 17:56:35'),(164,'default','logout',1,'App\\User',1,'App\\User','[]','2021-08-21 18:02:02','2021-08-21 18:02:02'),(165,'default','login',11,'App\\User',11,'App\\User','[]','2021-08-21 18:02:26','2021-08-21 18:02:26'),(166,'default','logout',11,'App\\User',11,'App\\User','[]','2021-08-21 23:48:14','2021-08-21 23:48:14'),(167,'default','login',11,'App\\User',11,'App\\User','[]','2021-08-22 14:20:28','2021-08-22 14:20:28'),(168,'default','added',16,'App\\Contact',11,'App\\User','[]','2021-08-22 14:21:41','2021-08-22 14:21:41'),(169,'default','added',17,'App\\Contact',11,'App\\User','[]','2021-08-22 14:30:13','2021-08-22 14:30:13'),(170,'default','added',18,'App\\Contact',11,'App\\User','[]','2021-08-22 14:44:55','2021-08-22 14:44:55'),(171,'default','login',1,'App\\User',1,'App\\User','[]','2021-08-22 15:02:11','2021-08-22 15:02:11'),(172,'default','login',4,'App\\User',4,'App\\User','[]','2021-08-22 15:51:27','2021-08-22 15:51:27'),(173,'default','logout',1,'App\\User',1,'App\\User','[]','2021-08-22 15:54:47','2021-08-22 15:54:47'),(174,'default','login',1,'App\\User',1,'App\\User','[]','2021-08-22 15:54:55','2021-08-22 15:54:55'),(175,'default','added',19,'App\\Contact',4,'App\\User','[]','2021-08-22 17:27:08','2021-08-22 17:27:08'),(176,'default','added',20,'App\\Contact',4,'App\\User','[]','2021-08-22 18:11:41','2021-08-22 18:11:41'),(177,'default','added',21,'App\\Contact',4,'App\\User','[]','2021-08-22 19:57:38','2021-08-22 19:57:38'),(178,'default','added',22,'App\\Contact',4,'App\\User','[]','2021-08-22 21:04:50','2021-08-22 21:04:50'),(179,'default','added',34,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1}}','2021-08-22 21:11:41','2021-08-22 21:11:41'),(180,'default','added',35,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":1850}}','2021-08-22 21:12:56','2021-08-22 21:12:56'),(181,'default','added',23,'App\\Contact',4,'App\\User','[]','2021-08-22 22:03:02','2021-08-22 22:03:02'),(182,'default','login',1,'App\\User',1,'App\\User','[]','2021-08-22 22:15:21','2021-08-22 22:15:21'),(183,'default','login',4,'App\\User',4,'App\\User','[]','2021-08-23 12:47:34','2021-08-23 12:47:34'),(184,'default','added',24,'App\\Contact',4,'App\\User','[]','2021-08-23 12:48:38','2021-08-23 12:48:38'),(185,'default','status_changed',30,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-08-23 13:08:56','2021-08-23 13:08:56'),(186,'default','status_changed',31,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-23 13:09:32','2021-08-23 13:09:32'),(187,'default','added',25,'App\\Contact',4,'App\\User','[]','2021-08-23 13:17:54','2021-08-23 13:17:54'),(188,'default','login',11,'App\\User',11,'App\\User','[]','2021-08-23 13:38:47','2021-08-23 13:38:47'),(189,'default','status_changed',32,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Finished\"}','2021-08-23 13:40:24','2021-08-23 13:40:24'),(190,'default','status_changed',33,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Finished\"}','2021-08-23 13:40:51','2021-08-23 13:40:51'),(191,'default','added',26,'App\\Contact',4,'App\\User','[]','2021-08-23 14:42:46','2021-08-23 14:42:46'),(192,'default','added',27,'App\\Contact',11,'App\\User','[]','2021-08-23 14:43:24','2021-08-23 14:43:24'),(193,'default','added',28,'App\\Contact',4,'App\\User','[]','2021-08-23 15:06:23','2021-08-23 15:06:23'),(194,'default','added',29,'App\\Contact',11,'App\\User','[]','2021-08-23 15:13:10','2021-08-23 15:13:10'),(195,'default','added',30,'App\\Contact',4,'App\\User','[]','2021-08-23 16:39:58','2021-08-23 16:39:58'),(196,'default','added',31,'App\\Contact',11,'App\\User','[]','2021-08-23 16:51:07','2021-08-23 16:51:07'),(197,'default','added',32,'App\\Contact',4,'App\\User','[]','2021-08-23 17:06:27','2021-08-23 17:06:27'),(198,'default','status_changed',40,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Finished\"}','2021-08-23 18:28:18','2021-08-23 18:28:18'),(199,'default','status_changed',39,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Finished\"}','2021-08-23 18:29:01','2021-08-23 18:29:01'),(200,'default','login',1,'App\\User',1,'App\\User','[]','2021-08-23 18:30:51','2021-08-23 18:30:51'),(201,'default','edited',4,'App\\User',1,'App\\User','[]','2021-08-23 18:32:24','2021-08-23 18:32:24'),(202,'default','login',1,'App\\User',1,'App\\User','[]','2021-08-23 18:42:22','2021-08-23 18:42:22'),(203,'default','edited',10,'App\\User',1,'App\\User','[]','2021-08-23 18:47:13','2021-08-23 18:47:13'),(204,'default','edited',9,'App\\User',1,'App\\User','[]','2021-08-23 18:54:24','2021-08-23 18:54:24'),(205,'default','added',15,'App\\User',1,'App\\User','[]','2021-08-23 18:56:51','2021-08-23 18:56:51'),(206,'default','login',15,'App\\User',15,'App\\User','[]','2021-08-23 18:59:47','2021-08-23 18:59:47'),(207,'default','added',33,'App\\Contact',4,'App\\User','[]','2021-08-23 19:00:04','2021-08-23 19:00:04'),(208,'default','login',1,'App\\User',1,'App\\User','[]','2021-08-23 19:01:03','2021-08-23 19:01:03'),(209,'default','login',15,'App\\User',15,'App\\User','[]','2021-08-23 19:05:33','2021-08-23 19:05:33'),(210,'default','added',34,'App\\Contact',4,'App\\User','[]','2021-08-23 19:21:12','2021-08-23 19:21:12'),(211,'default','added',35,'App\\Contact',11,'App\\User','[]','2021-08-23 19:55:43','2021-08-23 19:55:43'),(212,'default','status_changed',42,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Finished\"}','2021-08-23 20:12:25','2021-08-23 20:12:25'),(213,'default','status_changed',41,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Finished\"}','2021-08-23 20:12:55','2021-08-23 20:12:55'),(214,'default','login',1,'App\\User',1,'App\\User','[]','2021-08-23 20:13:18','2021-08-23 20:13:18'),(215,'default','status_changed',44,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Finished\"}','2021-08-23 20:16:40','2021-08-23 20:16:40'),(216,'default','status_changed',43,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Finished\"}','2021-08-23 20:17:55','2021-08-23 20:17:55'),(217,'default','status_changed',29,'Modules\\Repair\\Entities\\JobSheet',1,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-23 20:19:09','2021-08-23 20:19:09'),(218,'default','status_changed',44,'Modules\\Repair\\Entities\\JobSheet',1,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-23 20:20:44','2021-08-23 20:20:44'),(219,'default','status_changed',30,'Modules\\Repair\\Entities\\JobSheet',1,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-23 20:21:11','2021-08-23 20:21:11'),(220,'default','status_changed',45,'Modules\\Repair\\Entities\\JobSheet',1,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-08-23 20:21:32','2021-08-23 20:21:32'),(221,'default','status_changed',38,'Modules\\Repair\\Entities\\JobSheet',1,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-23 20:21:48','2021-08-23 20:21:48'),(222,'default','status_changed',46,'Modules\\Repair\\Entities\\JobSheet',1,'App\\User','{\"update_note\":null,\"updated_status\":\"Check In Progress\"}','2021-08-23 20:29:31','2021-08-23 20:29:31'),(223,'default','status_changed',44,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-23 20:36:45','2021-08-23 20:36:45'),(224,'default','added',36,'App\\Contact',1,'App\\User','[]','2021-08-23 20:37:11','2021-08-23 20:37:11'),(225,'default','added',37,'App\\Contact',4,'App\\User','[]','2021-08-23 20:51:29','2021-08-23 20:51:29'),(226,'default','added',38,'App\\Contact',4,'App\\User','[]','2021-08-23 20:55:49','2021-08-23 20:55:49'),(227,'default','added',36,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":1100}}','2021-08-23 20:58:07','2021-08-23 20:58:07'),(228,'default','status_changed',35,'App\\Transaction',1,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-08-23 21:24:18','2021-08-23 21:24:18'),(229,'default','status_changed',45,'Modules\\Repair\\Entities\\JobSheet',1,'App\\User','{\"update_note\":null,\"updated_status\":\"Finished\"}','2021-08-23 21:45:11','2021-08-23 21:45:11'),(230,'default','status_changed',44,'Modules\\Repair\\Entities\\JobSheet',1,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-23 21:48:32','2021-08-23 21:48:32'),(231,'default','status_changed',31,'Modules\\Repair\\Entities\\JobSheet',1,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-23 21:48:42','2021-08-23 21:48:42'),(232,'default','added',37,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-08-23 21:50:22','2021-08-23 21:50:22'),(233,'default','added',38,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-08-23 22:02:05','2021-08-23 22:02:05'),(234,'default','status_changed',37,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-23 22:02:33','2021-08-23 22:02:33'),(235,'default','status_changed',34,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-23 22:12:55','2021-08-23 22:12:55'),(236,'default','added',39,'App\\Contact',4,'App\\User','[]','2021-08-23 22:18:21','2021-08-23 22:18:21'),(237,'default','added',40,'App\\Contact',4,'App\\User','[]','2021-08-23 22:46:36','2021-08-23 22:46:36'),(238,'default','added',41,'App\\Contact',4,'App\\User','[]','2021-08-23 23:03:49','2021-08-23 23:03:49'),(239,'default','login',4,'App\\User',4,'App\\User','[]','2021-08-24 12:04:12','2021-08-24 12:04:12'),(240,'default','added',39,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-08-24 12:07:52','2021-08-24 12:07:52'),(241,'default','status_changed',41,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-24 12:08:19','2021-08-24 12:08:19'),(242,'default','added',40,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":650}}','2021-08-24 12:12:20','2021-08-24 12:12:20'),(243,'default','added',41,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-08-24 12:15:51','2021-08-24 12:15:51'),(244,'default','added',42,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-08-24 12:21:09','2021-08-24 12:21:09'),(245,'default','status_changed',32,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-24 12:22:47','2021-08-24 12:22:47'),(246,'default','status_changed',33,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-24 12:23:04','2021-08-24 12:23:04'),(247,'default','added',43,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1}}','2021-08-24 12:24:48','2021-08-24 12:24:48'),(248,'default','added',44,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-08-24 12:25:45','2021-08-24 12:25:45'),(249,'default','added',45,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-08-24 12:27:51','2021-08-24 12:27:51'),(250,'default','added',42,'App\\Contact',4,'App\\User','[]','2021-08-24 12:30:22','2021-08-24 12:30:22'),(251,'default','status_changed',38,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-24 12:57:50','2021-08-24 12:57:50'),(252,'default','added',46,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-08-24 12:58:30','2021-08-24 12:58:30'),(253,'default','added',43,'App\\Contact',4,'App\\User','[]','2021-08-24 13:40:01','2021-08-24 13:40:01'),(254,'default','added',44,'App\\Contact',11,'App\\User','[]','2021-08-24 13:50:01','2021-08-24 13:50:01'),(255,'default','added',45,'App\\Contact',4,'App\\User','[]','2021-08-24 13:52:41','2021-08-24 13:52:41'),(256,'default','added',46,'App\\Contact',4,'App\\User','[]','2021-08-24 14:39:12','2021-08-24 14:39:12'),(257,'default','added',47,'App\\Contact',11,'App\\User','[]','2021-08-24 14:48:08','2021-08-24 14:48:08'),(258,'default','added',48,'App\\Contact',4,'App\\User','[]','2021-08-24 14:48:50','2021-08-24 14:48:50'),(259,'default','added',49,'App\\Contact',4,'App\\User','[]','2021-08-24 14:53:39','2021-08-24 14:53:39'),(260,'default','status_changed',38,'App\\Transaction',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-24 15:06:04','2021-08-24 15:06:04'),(261,'default','status_changed',39,'App\\Transaction',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-24 15:07:09','2021-08-24 15:07:09'),(262,'default','status_changed',45,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-24 15:10:11','2021-08-24 15:10:11'),(263,'default','status_changed',39,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-24 15:10:24','2021-08-24 15:10:24'),(264,'default','status_changed',40,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-24 15:10:48','2021-08-24 15:10:48'),(265,'default','status_changed',42,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-24 15:11:00','2021-08-24 15:11:00'),(266,'default','status_changed',43,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-24 15:11:15','2021-08-24 15:11:15'),(267,'default','added',50,'App\\Contact',4,'App\\User','[]','2021-08-24 15:37:40','2021-08-24 15:37:40'),(268,'default','added',51,'App\\Contact',4,'App\\User','[]','2021-08-24 15:37:40','2021-08-24 15:37:40'),(269,'default','status_changed',53,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-24 15:57:47','2021-08-24 15:57:47'),(270,'default','added',47,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":125}}','2021-08-24 16:24:45','2021-08-24 16:24:45'),(271,'default','added',52,'App\\Contact',4,'App\\User','[]','2021-08-24 16:41:38','2021-08-24 16:41:38'),(272,'default','added',53,'App\\Contact',4,'App\\User','[]','2021-08-24 16:57:52','2021-08-24 16:57:52'),(273,'default','added',54,'App\\Contact',4,'App\\User','[]','2021-08-24 17:02:17','2021-08-24 17:02:17'),(274,'default','added',55,'App\\Contact',4,'App\\User','[]','2021-08-24 17:06:25','2021-08-24 17:06:25'),(275,'default','added',56,'App\\Contact',4,'App\\User','[]','2021-08-24 17:08:23','2021-08-24 17:08:23'),(276,'default','added',57,'App\\Contact',11,'App\\User','[]','2021-08-24 17:17:55','2021-08-24 17:17:55'),(277,'default','added',58,'App\\Contact',11,'App\\User','[]','2021-08-24 17:20:51','2021-08-24 17:20:51'),(278,'default','added',48,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-08-24 17:50:38','2021-08-24 17:50:38'),(279,'default','status_changed',57,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Can\'t be repaired\"}','2021-08-24 17:59:13','2021-08-24 17:59:13'),(280,'default','status_changed',58,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Can\'t be repaired\"}','2021-08-24 17:59:28','2021-08-24 17:59:28'),(281,'default','status_changed',49,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-24 18:00:35','2021-08-24 18:00:35'),(282,'default','status_changed',54,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-24 18:01:45','2021-08-24 18:01:45'),(283,'default','added',59,'App\\Contact',4,'App\\User','[]','2021-08-24 18:23:33','2021-08-24 18:23:33'),(284,'default','added',60,'App\\Contact',4,'App\\User','[]','2021-08-24 18:25:08','2021-08-24 18:25:08'),(285,'default','added',61,'App\\Contact',4,'App\\User','[]','2021-08-24 18:37:52','2021-08-24 18:37:52'),(286,'default','added',62,'App\\Contact',4,'App\\User','[]','2021-08-24 18:43:48','2021-08-24 18:43:48'),(287,'default','status_changed',56,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-24 18:54:19','2021-08-24 18:54:19'),(288,'default','status_changed',51,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-24 18:54:55','2021-08-24 18:54:55'),(289,'default','status_changed',49,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-24 19:04:50','2021-08-24 19:04:50'),(290,'default','added',49,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-08-24 19:05:27','2021-08-24 19:05:27'),(291,'default','added',50,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-08-24 19:13:28','2021-08-24 19:13:28'),(292,'default','added',63,'App\\Contact',4,'App\\User','[]','2021-08-24 19:22:06','2021-08-24 19:22:06'),(293,'default','added',64,'App\\Contact',4,'App\\User','[]','2021-08-24 19:28:09','2021-08-24 19:28:09'),(294,'default','added',51,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-08-24 19:38:33','2021-08-24 19:38:33'),(295,'default','status_changed',60,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-24 19:38:59','2021-08-24 19:38:59'),(296,'default','status_changed',55,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-24 19:40:18','2021-08-24 19:40:18'),(297,'default','status_changed',43,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-24 20:11:54','2021-08-24 20:11:54'),(298,'default','added',52,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-08-24 20:13:06','2021-08-24 20:13:06'),(299,'default','added',65,'App\\Contact',4,'App\\User','[]','2021-08-24 20:52:16','2021-08-24 20:52:16'),(300,'default','added',66,'App\\Contact',4,'App\\User','[]','2021-08-24 21:39:16','2021-08-24 21:39:16'),(301,'default','added',67,'App\\Contact',11,'App\\User','[]','2021-08-24 21:42:54','2021-08-24 21:42:54'),(302,'default','status_changed',61,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-24 22:02:15','2021-08-24 22:02:15'),(303,'default','added',53,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-08-24 22:03:40','2021-08-24 22:03:40'),(304,'default','added',54,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-08-24 22:10:36','2021-08-24 22:10:36'),(305,'default','status_changed',51,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-24 22:11:28','2021-08-24 22:11:28'),(306,'default','added',68,'App\\Contact',11,'App\\User','[]','2021-08-24 23:29:14','2021-08-24 23:29:14'),(307,'default','added',55,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-08-24 23:32:46','2021-08-24 23:32:46'),(308,'default','added',56,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":1000}}','2021-08-24 23:35:47','2021-08-24 23:35:47'),(309,'default','login',4,'App\\User',4,'App\\User','[]','2021-08-25 12:26:34','2021-08-25 12:26:34'),(310,'default','status_changed',53,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-25 12:55:35','2021-08-25 12:55:35'),(311,'default','status_changed',54,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-25 12:55:46','2021-08-25 12:55:46'),(312,'default','added',57,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-08-25 12:56:15','2021-08-25 12:56:15'),(313,'default','added',58,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-08-25 12:58:28','2021-08-25 12:58:28'),(314,'default','added',69,'App\\Contact',4,'App\\User','[]','2021-08-25 13:26:45','2021-08-25 13:26:45'),(315,'default','added',70,'App\\Contact',4,'App\\User','[]','2021-08-25 14:02:35','2021-08-25 14:02:35'),(316,'default','added',71,'App\\Contact',4,'App\\User','[]','2021-08-25 14:11:14','2021-08-25 14:11:14'),(317,'default','added',59,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-08-25 14:20:21','2021-08-25 14:20:21'),(318,'default','status_changed',67,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-25 14:26:09','2021-08-25 14:26:09'),(319,'default','added',72,'App\\Contact',4,'App\\User','[]','2021-08-25 15:01:49','2021-08-25 15:01:49'),(320,'default','added',73,'App\\Contact',4,'App\\User','[]','2021-08-25 15:06:53','2021-08-25 15:06:53'),(321,'default','added',60,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-08-25 15:08:46','2021-08-25 15:08:46'),(322,'default','added',74,'App\\Contact',11,'App\\User','[]','2021-08-25 15:13:34','2021-08-25 15:13:34'),(323,'default','added',61,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-08-25 15:25:53','2021-08-25 15:25:53'),(324,'default','added',75,'App\\Contact',4,'App\\User','[]','2021-08-25 15:37:42','2021-08-25 15:37:42'),(325,'default','added',76,'App\\Contact',4,'App\\User','[]','2021-08-25 15:47:32','2021-08-25 15:47:32'),(326,'default','added',77,'App\\Contact',4,'App\\User','[]','2021-08-25 16:09:37','2021-08-25 16:09:37'),(327,'default','status_changed',39,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-25 16:21:27','2021-08-25 16:21:27'),(328,'default','status_changed',40,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-25 16:21:59','2021-08-25 16:21:59'),(329,'default','status_changed',64,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-25 16:22:52','2021-08-25 16:22:52'),(330,'default','status_changed',50,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-25 16:23:12','2021-08-25 16:23:12'),(331,'default','added',78,'App\\Contact',4,'App\\User','[]','2021-08-25 16:33:00','2021-08-25 16:33:00'),(332,'default','added',79,'App\\Contact',4,'App\\User','[]','2021-08-25 16:45:21','2021-08-25 16:45:21'),(333,'default','added',80,'App\\Contact',4,'App\\User','[]','2021-08-25 17:12:05','2021-08-25 17:12:05'),(334,'default','status_changed',79,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-25 18:41:56','2021-08-25 18:41:56'),(335,'default','added',62,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-08-25 18:42:55','2021-08-25 18:42:55'),(336,'default','added',81,'App\\Contact',4,'App\\User','[]','2021-08-25 19:06:19','2021-08-25 19:06:19'),(337,'default','added',82,'App\\Contact',4,'App\\User','[]','2021-08-25 19:59:05','2021-08-25 19:59:05'),(338,'default','added',83,'App\\Contact',4,'App\\User','[]','2021-08-25 20:07:55','2021-08-25 20:07:55'),(339,'default','added',84,'App\\Contact',4,'App\\User','[]','2021-08-25 20:12:44','2021-08-25 20:12:44'),(340,'default','added',85,'App\\Contact',4,'App\\User','[]','2021-08-25 20:21:17','2021-08-25 20:21:17'),(341,'default','added',63,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-08-25 20:47:15','2021-08-25 20:47:15'),(342,'default','status_changed',52,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-25 21:33:07','2021-08-25 21:33:07'),(343,'default','added',64,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-08-25 21:34:49','2021-08-25 21:34:49'),(344,'default','added',65,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":375}}','2021-08-25 21:38:02','2021-08-25 21:38:02'),(345,'default','status_changed',59,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":\"\\u0631\\u0641\\u0636 \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644 \\u0627\\u0644\\u0627\\u0635\\u0644\\u0627\\u062d \\u0627\\u0644\\u062a\\u0643\\u0644\\u0641\\u0647 \\u0643\\u0628\\u064a\\u0631\\u0647\",\"updated_status\":\"Ready for client\"}','2021-08-25 21:42:11','2021-08-25 21:42:11'),(346,'default','status_changed',83,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-25 21:57:35','2021-08-25 21:57:35'),(347,'default','added',66,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-08-25 21:58:32','2021-08-25 21:58:32'),(348,'default','added',67,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-08-25 22:04:37','2021-08-25 22:04:37'),(349,'default','status_changed',72,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-25 22:05:12','2021-08-25 22:05:12'),(350,'default','added',68,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-08-25 22:26:02','2021-08-25 22:26:02'),(351,'default','status_changed',81,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-25 22:27:28','2021-08-25 22:27:28'),(352,'default','login',1,'App\\User',1,'App\\User','[]','2021-08-25 22:46:34','2021-08-25 22:46:34'),(353,'default','status_changed',35,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-25 22:49:59','2021-08-25 22:49:59'),(354,'default','added',69,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":850}}','2021-08-25 22:54:17','2021-08-25 22:54:17'),(355,'default','login',4,'App\\User',4,'App\\User','[]','2021-08-26 13:18:28','2021-08-26 13:18:28'),(356,'default','added',86,'App\\Contact',4,'App\\User','[]','2021-08-26 14:02:13','2021-08-26 14:02:13'),(357,'default','added',87,'App\\Contact',4,'App\\User','[]','2021-08-26 14:16:51','2021-08-26 14:16:51'),(358,'default','added',88,'App\\Contact',4,'App\\User','[]','2021-08-26 15:32:48','2021-08-26 15:32:48'),(359,'default','added',70,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":175}}','2021-08-26 15:58:01','2021-08-26 15:58:01'),(360,'default','status_changed',80,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-26 15:58:31','2021-08-26 15:58:31'),(361,'default','added',89,'App\\Contact',4,'App\\User','[]','2021-08-26 17:32:42','2021-08-26 17:32:42'),(362,'default','login',4,'App\\User',4,'App\\User','[]','2021-08-27 14:28:52','2021-08-27 14:28:52'),(363,'default','added',90,'App\\Contact',4,'App\\User','[]','2021-08-27 14:29:39','2021-08-27 14:29:39'),(364,'default','added',91,'App\\Contact',4,'App\\User','[]','2021-08-27 14:43:40','2021-08-27 14:43:40'),(365,'default','added',92,'App\\Contact',4,'App\\User','[]','2021-08-27 14:45:49','2021-08-27 14:45:49'),(366,'default','added',93,'App\\Contact',4,'App\\User','[]','2021-08-27 19:29:39','2021-08-27 19:29:39'),(367,'default','added',94,'App\\Contact',4,'App\\User','[]','2021-08-27 20:35:02','2021-08-27 20:35:02'),(368,'default','added',95,'App\\Contact',4,'App\\User','[]','2021-08-27 21:17:17','2021-08-27 21:17:17'),(369,'default','added',96,'App\\Contact',4,'App\\User','[]','2021-08-27 21:17:59','2021-08-27 21:17:59'),(370,'default','added',97,'App\\Contact',4,'App\\User','[]','2021-08-27 21:22:39','2021-08-27 21:22:39'),(371,'default','added',98,'App\\Contact',4,'App\\User','[]','2021-08-27 22:01:09','2021-08-27 22:01:09'),(372,'default','added',99,'App\\Contact',4,'App\\User','[]','2021-08-27 22:38:02','2021-08-27 22:38:02'),(373,'default','login',4,'App\\User',4,'App\\User','[]','2021-08-28 13:59:15','2021-08-28 13:59:15'),(374,'default','added',100,'App\\Contact',4,'App\\User','[]','2021-08-28 14:00:11','2021-08-28 14:00:11'),(375,'default','added',101,'App\\Contact',4,'App\\User','[]','2021-08-28 15:20:51','2021-08-28 15:20:51'),(376,'default','added',102,'App\\Contact',4,'App\\User','[]','2021-08-28 15:29:49','2021-08-28 15:29:49'),(377,'default','added',103,'App\\Contact',11,'App\\User','[]','2021-08-28 15:51:36','2021-08-28 15:51:36'),(378,'default','added',104,'App\\Contact',4,'App\\User','[]','2021-08-28 16:22:28','2021-08-28 16:22:28'),(379,'default','added',105,'App\\Contact',4,'App\\User','[]','2021-08-28 17:11:43','2021-08-28 17:11:43'),(380,'default','added',106,'App\\Contact',4,'App\\User','[]','2021-08-28 17:43:04','2021-08-28 17:43:04'),(381,'default','added',107,'App\\Contact',11,'App\\User','[]','2021-08-28 17:43:23','2021-08-28 17:43:23'),(382,'default','added',108,'App\\Contact',4,'App\\User','[]','2021-08-28 17:50:26','2021-08-28 17:50:26'),(383,'default','added',109,'App\\Contact',4,'App\\User','[]','2021-08-28 18:13:09','2021-08-28 18:13:09'),(384,'default','added',71,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-08-28 18:39:46','2021-08-28 18:39:46'),(385,'default','status_changed',101,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-28 18:41:42','2021-08-28 18:41:42'),(386,'default','added',110,'App\\Contact',4,'App\\User','[]','2021-08-28 19:06:51','2021-08-28 19:06:51'),(387,'default','added',111,'App\\Contact',11,'App\\User','[]','2021-08-28 19:25:55','2021-08-28 19:25:55'),(388,'default','added',112,'App\\Contact',4,'App\\User','[]','2021-08-28 20:53:07','2021-08-28 20:53:07'),(389,'default','added',113,'App\\Contact',4,'App\\User','[]','2021-08-28 21:02:39','2021-08-28 21:02:39'),(390,'default','added',114,'App\\Contact',4,'App\\User','[]','2021-08-28 21:22:11','2021-08-28 21:22:11'),(391,'default','added',115,'App\\Contact',4,'App\\User','[]','2021-08-28 21:28:21','2021-08-28 21:28:21'),(392,'default','added',116,'App\\Contact',4,'App\\User','[]','2021-08-28 22:13:21','2021-08-28 22:13:21'),(393,'default','status_changed',109,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-28 22:46:45','2021-08-28 22:46:45'),(394,'default','added',117,'App\\Contact',4,'App\\User','[]','2021-08-28 22:55:04','2021-08-28 22:55:04'),(395,'default','login',4,'App\\User',4,'App\\User','[]','2021-08-29 12:08:25','2021-08-29 12:08:25'),(396,'default','added',118,'App\\Contact',4,'App\\User','[]','2021-08-29 12:09:38','2021-08-29 12:09:38'),(397,'default','added',119,'App\\Contact',4,'App\\User','[]','2021-08-29 12:58:14','2021-08-29 12:58:14'),(398,'default','added',120,'App\\Contact',4,'App\\User','[]','2021-08-29 13:02:45','2021-08-29 13:02:45'),(399,'default','status_changed',42,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-29 15:17:10','2021-08-29 15:17:10'),(400,'default','added',72,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1100}}','2021-08-29 15:18:38','2021-08-29 15:18:38'),(401,'default','added',73,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}','2021-08-29 16:28:16','2021-08-29 16:28:16'),(402,'default','status_changed',71,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-29 16:28:35','2021-08-29 16:28:35'),(403,'default','added',74,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}','2021-08-29 16:29:05','2021-08-29 16:29:05'),(404,'default','status_changed',36,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-29 16:29:20','2021-08-29 16:29:20'),(405,'default','added',75,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-08-29 16:30:52','2021-08-29 16:30:52'),(406,'default','status_changed',55,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-29 16:31:08','2021-08-29 16:31:08'),(407,'default','status_changed',63,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-29 16:32:39','2021-08-29 16:32:39'),(408,'default','status_changed',65,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-29 16:32:55','2021-08-29 16:32:55'),(409,'default','added',76,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-08-29 16:35:03','2021-08-29 16:35:03'),(410,'default','status_changed',75,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-29 16:35:35','2021-08-29 16:35:35'),(411,'default','status_changed',66,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-29 16:37:25','2021-08-29 16:37:25'),(412,'default','status_changed',74,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-29 16:37:39','2021-08-29 16:37:39'),(413,'default','added',77,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-08-29 16:38:09','2021-08-29 16:38:09'),(414,'default','status_changed',68,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-29 16:38:37','2021-08-29 16:38:37'),(415,'default','status_changed',88,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-29 16:42:14','2021-08-29 16:42:14'),(416,'default','added',78,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-08-29 16:45:03','2021-08-29 16:45:03'),(417,'default','added',79,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-08-29 16:47:59','2021-08-29 16:47:59'),(418,'default','status_changed',92,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-29 16:48:41','2021-08-29 16:48:41'),(419,'default','status_changed',78,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-29 16:49:17','2021-08-29 16:49:17'),(420,'default','added',80,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-08-29 16:51:06','2021-08-29 16:51:06'),(421,'default','status_changed',84,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-29 16:52:34','2021-08-29 16:52:34'),(422,'default','added',81,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-08-29 16:54:19','2021-08-29 16:54:19'),(423,'default','status_changed',102,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-29 16:54:44','2021-08-29 16:54:44'),(424,'default','status_changed',99,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-29 16:58:33','2021-08-29 16:58:33'),(425,'default','added',121,'App\\Contact',11,'App\\User','[]','2021-08-29 17:15:29','2021-08-29 17:15:29'),(426,'default','status_changed',100,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":\"\\u0628\\u0648\\u0631\\u062f\\u0647\",\"updated_status\":\"DELIVERED\"}','2021-08-29 17:28:04','2021-08-29 17:28:04'),(427,'default','status_changed',59,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":\"\\u0631\\u0641\\u0636 \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644 \\u0627\\u0644\\u0627\\u0635\\u0644\\u0627\\u062d\",\"updated_status\":\"Ready for client\"}','2021-08-29 17:28:55','2021-08-29 17:28:55'),(428,'default','status_changed',59,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-29 17:29:03','2021-08-29 17:29:03'),(429,'default','added',122,'App\\Contact',4,'App\\User','[]','2021-08-29 17:49:30','2021-08-29 17:49:30'),(430,'default','added',123,'App\\Contact',4,'App\\User','[]','2021-08-29 18:04:10','2021-08-29 18:04:10'),(431,'default','status_changed',41,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-08-29 18:12:40','2021-08-29 18:12:40'),(432,'default','added',124,'App\\Contact',4,'App\\User','[]','2021-08-29 18:48:13','2021-08-29 18:48:13'),(433,'default','status_changed',117,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-29 18:56:49','2021-08-29 18:56:49'),(434,'default','added',82,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-08-29 18:59:03','2021-08-29 18:59:03'),(435,'default','added',125,'App\\Contact',11,'App\\User','[]','2021-08-29 19:39:35','2021-08-29 19:39:35'),(436,'default','added',126,'App\\Contact',11,'App\\User','[]','2021-08-29 20:04:15','2021-08-29 20:04:15'),(437,'default','added',127,'App\\Contact',11,'App\\User','[]','2021-08-29 20:15:05','2021-08-29 20:15:05'),(438,'default','status_changed',122,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-29 20:22:39','2021-08-29 20:22:39'),(439,'default','status_changed',116,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Can\'t be repaired\"}','2021-08-29 20:36:15','2021-08-29 20:36:15'),(440,'default','added',128,'App\\Contact',4,'App\\User','[]','2021-08-29 20:38:39','2021-08-29 20:38:39'),(441,'default','status_changed',114,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-29 20:49:03','2021-08-29 20:49:03'),(442,'default','added',83,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-08-29 20:51:06','2021-08-29 20:51:06'),(443,'default','status_changed',85,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-29 20:54:24','2021-08-29 20:54:24'),(444,'default','added',84,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-08-29 20:55:13','2021-08-29 20:55:13'),(445,'default','logout',11,'App\\User',11,'App\\User','[]','2021-08-29 20:57:38','2021-08-29 20:57:38'),(446,'default','login',11,'App\\User',11,'App\\User','[]','2021-08-29 20:58:00','2021-08-29 20:58:00'),(447,'default','added',129,'App\\Contact',4,'App\\User','[]','2021-08-29 21:07:11','2021-08-29 21:07:11'),(448,'default','added',130,'App\\Contact',4,'App\\User','[]','2021-08-29 21:10:04','2021-08-29 21:10:04'),(449,'default','added',131,'App\\Contact',11,'App\\User','[]','2021-08-29 21:15:45','2021-08-29 21:15:45'),(450,'default','added',132,'App\\Contact',4,'App\\User','[]','2021-08-29 21:21:52','2021-08-29 21:21:52'),(451,'default','added',133,'App\\Contact',11,'App\\User','[]','2021-08-29 21:23:19','2021-08-29 21:23:19'),(452,'default','added',134,'App\\Contact',11,'App\\User','[]','2021-08-29 21:29:04','2021-08-29 21:29:04'),(453,'default','status_changed',120,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-29 21:41:00','2021-08-29 21:41:00'),(454,'default','added',85,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-08-29 21:41:38','2021-08-29 21:41:38'),(455,'default','login',4,'App\\User',4,'App\\User','[]','2021-08-30 13:04:36','2021-08-30 13:04:36'),(456,'default','added',86,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-08-30 13:29:09','2021-08-30 13:29:09'),(457,'default','status_changed',103,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-30 13:29:36','2021-08-30 13:29:36'),(458,'default','added',87,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":175}}','2021-08-30 15:07:25','2021-08-30 15:07:25'),(459,'default','status_changed',111,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-30 15:07:43','2021-08-30 15:07:43'),(460,'default','added',88,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-08-30 15:33:23','2021-08-30 15:33:23'),(461,'default','status_changed',70,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-30 15:41:48','2021-08-30 15:41:48'),(462,'default','added',89,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-08-30 15:48:08','2021-08-30 15:48:08'),(463,'default','status_changed',89,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-30 15:48:53','2021-08-30 15:48:53'),(464,'default','status_changed',57,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-30 15:53:29','2021-08-30 15:53:29'),(465,'default','status_changed',58,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-30 15:53:37','2021-08-30 15:53:37'),(466,'default','status_changed',110,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-30 15:54:39','2021-08-30 15:54:39'),(467,'default','status_changed',123,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-08-30 16:02:44','2021-08-30 16:02:44'),(468,'default','status_changed',113,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-08-30 16:02:59','2021-08-30 16:02:59'),(469,'default','status_changed',127,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-08-30 16:03:21','2021-08-30 16:03:21'),(470,'default','added',135,'App\\Contact',4,'App\\User','[]','2021-08-30 16:21:36','2021-08-30 16:21:36'),(471,'default','added',136,'App\\Contact',4,'App\\User','[]','2021-08-30 17:11:41','2021-08-30 17:11:41'),(472,'default','added',90,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-08-30 17:29:06','2021-08-30 17:29:06'),(473,'default','status_changed',93,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-30 17:29:30','2021-08-30 17:29:30'),(474,'default','added',137,'App\\Contact',4,'App\\User','[]','2021-08-30 17:49:40','2021-08-30 17:49:40'),(475,'default','added',138,'App\\Contact',4,'App\\User','[]','2021-08-30 18:23:10','2021-08-30 18:23:10'),(476,'default','added',139,'App\\Contact',4,'App\\User','[]','2021-08-30 19:07:07','2021-08-30 19:07:07'),(477,'default','added',140,'App\\Contact',4,'App\\User','[]','2021-08-30 19:27:42','2021-08-30 19:27:42'),(478,'default','added',141,'App\\Contact',4,'App\\User','[]','2021-08-30 19:37:04','2021-08-30 19:37:04'),(479,'default','login',11,'App\\User',11,'App\\User','[]','2021-08-30 20:14:07','2021-08-30 20:14:07'),(480,'default','added',142,'App\\Contact',11,'App\\User','[]','2021-08-30 20:16:18','2021-08-30 20:16:18'),(481,'default','added',91,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}','2021-08-30 20:39:44','2021-08-30 20:39:44'),(482,'default','status_changed',128,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-30 20:40:39','2021-08-30 20:40:39'),(483,'default','added',92,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-08-30 20:42:00','2021-08-30 20:42:00'),(484,'default','status_changed',115,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-30 20:42:23','2021-08-30 20:42:23'),(485,'default','added',93,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-08-30 20:43:02','2021-08-30 20:43:02'),(486,'default','status_changed',129,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-30 20:43:30','2021-08-30 20:43:30'),(487,'default','added',94,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-08-30 20:44:33','2021-08-30 20:44:33'),(488,'default','status_changed',121,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-30 20:45:24','2021-08-30 20:45:24'),(489,'default','added',95,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-08-30 20:46:11','2021-08-30 20:46:11'),(490,'default','status_changed',135,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-30 20:46:36','2021-08-30 20:46:36'),(491,'default','added',143,'App\\Contact',11,'App\\User','[]','2021-08-30 21:21:54','2021-08-30 21:21:54'),(492,'default','added',144,'App\\Contact',4,'App\\User','[]','2021-08-30 22:01:04','2021-08-30 22:01:04'),(493,'default','added',145,'App\\Contact',4,'App\\User','[]','2021-08-30 22:32:05','2021-08-30 22:32:05'),(494,'default','added',146,'App\\Contact',4,'App\\User','[]','2021-08-30 22:36:12','2021-08-30 22:36:12'),(495,'default','login',4,'App\\User',4,'App\\User','[]','2021-08-31 12:11:15','2021-08-31 12:11:15'),(496,'default','added',147,'App\\Contact',4,'App\\User','[]','2021-08-31 12:59:08','2021-08-31 12:59:08'),(497,'default','added',148,'App\\Contact',4,'App\\User','[]','2021-08-31 13:10:18','2021-08-31 13:10:18'),(498,'default','added',96,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-08-31 14:13:45','2021-08-31 14:13:45'),(499,'default','status_changed',137,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-31 14:13:58','2021-08-31 14:13:58'),(500,'default','status_changed',46,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-31 14:16:44','2021-08-31 14:16:44'),(501,'default','status_changed',41,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-31 14:18:29','2021-08-31 14:18:29'),(502,'default','status_changed',119,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-31 14:20:24','2021-08-31 14:20:24'),(503,'default','added',97,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-08-31 14:21:26','2021-08-31 14:21:26'),(504,'default','status_changed',104,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-31 14:21:48','2021-08-31 14:21:48'),(505,'default','added',98,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-08-31 14:23:26','2021-08-31 14:23:26'),(506,'default','status_changed',105,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-31 14:23:40','2021-08-31 14:23:40'),(507,'default','status_changed',106,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Can\'t be repaired\"}','2021-08-31 14:24:00','2021-08-31 14:24:00'),(508,'default','status_changed',107,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-31 14:24:17','2021-08-31 14:24:17'),(509,'default','added',99,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-08-31 14:25:10','2021-08-31 14:25:10'),(510,'default','status_changed',108,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-31 14:25:23','2021-08-31 14:25:23'),(511,'default','status_changed',124,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-08-31 14:25:44','2021-08-31 14:25:44'),(512,'default','status_changed',126,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-08-31 14:26:01','2021-08-31 14:26:01'),(513,'default','status_changed',94,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-31 14:26:13','2021-08-31 14:26:13'),(514,'default','added',100,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-08-31 14:31:39','2021-08-31 14:31:39'),(515,'default','status_changed',97,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-31 14:32:08','2021-08-31 14:32:08'),(516,'default','added',101,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-08-31 14:33:48','2021-08-31 14:33:48'),(517,'default','status_changed',95,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-31 14:34:14','2021-08-31 14:34:14'),(518,'default','status_changed',98,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-31 14:39:38','2021-08-31 14:39:38'),(519,'default','login',11,'App\\User',11,'App\\User','[]','2021-08-31 14:39:40','2021-08-31 14:39:40'),(520,'default','added',149,'App\\Contact',11,'App\\User','[]','2021-08-31 14:40:25','2021-08-31 14:40:25'),(521,'default','status_changed',134,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-31 14:40:35','2021-08-31 14:40:35'),(522,'default','added',102,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-08-31 14:41:23','2021-08-31 14:41:23'),(523,'default','status_changed',145,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-31 14:41:58','2021-08-31 14:41:58'),(524,'default','status_changed',147,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-08-31 14:43:17','2021-08-31 14:43:17'),(525,'default','status_changed',138,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-31 14:51:18','2021-08-31 14:51:18'),(526,'default','status_changed',113,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-31 16:46:15','2021-08-31 16:46:15'),(527,'default','added',150,'App\\Contact',11,'App\\User','[]','2021-08-31 16:46:46','2021-08-31 16:46:46'),(528,'default','added',151,'App\\Contact',4,'App\\User','[]','2021-08-31 17:09:05','2021-08-31 17:09:05'),(529,'default','added',152,'App\\Contact',4,'App\\User','[]','2021-08-31 17:29:52','2021-08-31 17:29:52'),(530,'default','added',153,'App\\Contact',4,'App\\User','[]','2021-08-31 17:55:07','2021-08-31 17:55:07'),(531,'default','added',154,'App\\Contact',4,'App\\User','[]','2021-08-31 18:54:03','2021-08-31 18:54:03'),(532,'default','added',155,'App\\Contact',11,'App\\User','[]','2021-08-31 18:54:05','2021-08-31 18:54:05'),(533,'default','added',103,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-08-31 19:19:32','2021-08-31 19:19:32'),(534,'default','added',104,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1}}','2021-08-31 20:17:11','2021-08-31 20:17:11'),(535,'default','added',105,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-08-31 20:25:21','2021-08-31 20:25:21'),(536,'default','status_changed',150,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-31 20:26:38','2021-08-31 20:26:38'),(537,'default','status_changed',127,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-31 20:28:59','2021-08-31 20:28:59'),(538,'default','status_changed',151,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-31 20:29:36','2021-08-31 20:29:36'),(539,'default','added',156,'App\\Contact',11,'App\\User','[]','2021-08-31 20:36:39','2021-08-31 20:36:39'),(540,'default','added',106,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-08-31 20:49:36','2021-08-31 20:49:36'),(541,'default','added',157,'App\\Contact',11,'App\\User','[]','2021-08-31 21:02:27','2021-08-31 21:02:27'),(542,'default','status_changed',127,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-31 21:04:04','2021-08-31 21:04:04'),(543,'default','status_changed',154,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-31 21:19:23','2021-08-31 21:19:23'),(544,'default','added',158,'App\\Contact',11,'App\\User','[]','2021-08-31 21:20:15','2021-08-31 21:20:15'),(545,'default','added',107,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-08-31 21:26:51','2021-08-31 21:26:51'),(546,'default','status_changed',142,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-31 21:31:29','2021-08-31 21:31:29'),(547,'default','added',159,'App\\Contact',4,'App\\User','[]','2021-08-31 21:32:06','2021-08-31 21:32:06'),(548,'default','added',160,'App\\Contact',11,'App\\User','[]','2021-08-31 21:39:54','2021-08-31 21:39:54'),(549,'default','added',108,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}','2021-08-31 21:49:10','2021-08-31 21:49:10'),(550,'default','added',109,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-08-31 22:16:51','2021-08-31 22:16:51'),(551,'default','status_changed',151,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-31 22:17:25','2021-08-31 22:17:25'),(552,'default','added',110,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-08-31 22:49:20','2021-08-31 22:49:20'),(553,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-01 12:43:33','2021-09-01 12:43:33'),(554,'default','added',161,'App\\Contact',4,'App\\User','[]','2021-09-01 14:00:23','2021-09-01 14:00:23'),(555,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-01 14:37:41','2021-09-01 14:37:41'),(556,'default','added',162,'App\\Contact',11,'App\\User','[]','2021-09-01 14:38:16','2021-09-01 14:38:16'),(557,'default','added',163,'App\\Contact',11,'App\\User','[]','2021-09-01 14:43:55','2021-09-01 14:43:55'),(558,'default','added',164,'App\\Contact',11,'App\\User','[]','2021-09-01 15:06:49','2021-09-01 15:06:49'),(559,'default','added',165,'App\\Contact',4,'App\\User','[]','2021-09-01 15:32:01','2021-09-01 15:32:01'),(560,'default','added',166,'App\\Contact',4,'App\\User','[]','2021-09-01 15:47:18','2021-09-01 15:47:18'),(561,'default','added',111,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-01 15:49:48','2021-09-01 15:49:48'),(562,'default','added',112,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-01 15:51:41','2021-09-01 15:51:41'),(563,'default','status_changed',165,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-01 15:52:11','2021-09-01 15:52:11'),(564,'default','added',113,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-09-01 15:52:56','2021-09-01 15:52:56'),(565,'default','added',167,'App\\Contact',11,'App\\User','[]','2021-09-01 15:53:08','2021-09-01 15:53:08'),(566,'default','status_changed',164,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-01 15:53:16','2021-09-01 15:53:16'),(567,'default','added',168,'App\\Contact',4,'App\\User','[]','2021-09-01 15:58:50','2021-09-01 15:58:50'),(568,'default','added',114,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":800}}','2021-09-01 16:02:17','2021-09-01 16:02:17'),(569,'default','added',169,'App\\Contact',4,'App\\User','[]','2021-09-01 16:04:46','2021-09-01 16:04:46'),(570,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-01 16:06:57','2021-09-01 16:06:57'),(571,'default','added',115,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":700}}','2021-09-01 16:07:54','2021-09-01 16:07:54'),(572,'default','status_changed',106,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-01 16:09:20','2021-09-01 16:09:20'),(573,'default','added',170,'App\\Contact',4,'App\\User','[]','2021-09-01 16:12:21','2021-09-01 16:12:21'),(574,'default','status_changed',130,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-01 16:16:54','2021-09-01 16:16:54'),(575,'default','status_changed',125,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-01 16:19:27','2021-09-01 16:19:27'),(576,'default','status_changed',143,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-01 16:19:39','2021-09-01 16:19:39'),(577,'default','status_changed',144,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-09-01 16:20:02','2021-09-01 16:20:02'),(578,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-01 16:23:28','2021-09-01 16:23:28'),(579,'default','status_changed',148,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-09-01 16:24:25','2021-09-01 16:24:25'),(580,'default','added',171,'App\\Contact',4,'App\\User','[]','2021-09-01 16:26:27','2021-09-01 16:26:27'),(581,'default','status_changed',136,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-01 16:32:33','2021-09-01 16:32:33'),(582,'default','status_changed',152,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-01 16:33:22','2021-09-01 16:33:22'),(583,'default','status_changed',156,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-09-01 16:35:53','2021-09-01 16:35:53'),(584,'default','status_changed',141,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-01 16:36:06','2021-09-01 16:36:06'),(585,'default','status_changed',160,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-09-01 16:36:18','2021-09-01 16:36:18'),(586,'default','status_changed',162,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-09-01 16:37:02','2021-09-01 16:37:02'),(587,'default','status_changed',163,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-09-01 16:44:24','2021-09-01 16:44:24'),(588,'default','status_changed',169,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-09-01 16:44:37','2021-09-01 16:44:37'),(589,'default','status_changed',155,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-09-01 16:44:58','2021-09-01 16:44:58'),(590,'default','status_changed',159,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-09-01 16:45:06','2021-09-01 16:45:06'),(591,'default','added',116,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}','2021-09-01 16:55:00','2021-09-01 16:55:00'),(592,'default','status_changed',136,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-01 16:55:22','2021-09-01 16:55:22'),(593,'default','status_changed',158,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-01 16:56:15','2021-09-01 16:56:15'),(594,'default','added',172,'App\\Contact',4,'App\\User','[]','2021-09-01 17:07:20','2021-09-01 17:07:20'),(595,'default','status_changed',96,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-01 17:11:07','2021-09-01 17:11:07'),(596,'default','added',173,'App\\Contact',4,'App\\User','[]','2021-09-01 17:33:14','2021-09-01 17:33:14'),(597,'default','added',174,'App\\Contact',4,'App\\User','[]','2021-09-01 17:36:20','2021-09-01 17:36:20'),(598,'default','added',175,'App\\Contact',4,'App\\User','[]','2021-09-01 17:40:33','2021-09-01 17:40:33'),(599,'default','added',117,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-01 17:45:18','2021-09-01 17:45:18'),(600,'default','status_changed',156,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-01 17:45:41','2021-09-01 17:45:41'),(601,'default','added',118,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-09-01 17:48:40','2021-09-01 17:48:40'),(602,'default','status_changed',155,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-01 17:48:53','2021-09-01 17:48:53'),(603,'default','status_changed',41,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-01 18:21:50','2021-09-01 18:21:50'),(604,'default','added',119,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-09-01 18:22:51','2021-09-01 18:22:51'),(605,'default','added',120,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-01 19:05:20','2021-09-01 19:05:20'),(606,'default','added',176,'App\\Contact',4,'App\\User','[]','2021-09-01 19:25:19','2021-09-01 19:25:19'),(607,'default','added',121,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-01 19:28:04','2021-09-01 19:28:04'),(608,'default','added',122,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-09-01 19:40:05','2021-09-01 19:40:05'),(609,'default','status_changed',143,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-01 19:40:30','2021-09-01 19:40:30'),(610,'default','added',177,'App\\Contact',4,'App\\User','[]','2021-09-01 19:56:20','2021-09-01 19:56:20'),(611,'default','status_changed',158,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Finished\"}','2021-09-01 20:22:45','2021-09-01 20:22:45'),(612,'default','status_changed',158,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-01 20:24:10','2021-09-01 20:24:10'),(613,'default','status_changed',159,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-01 20:24:25','2021-09-01 20:24:25'),(614,'default','added',123,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-01 20:26:41','2021-09-01 20:26:41'),(615,'default','status_changed',167,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-01 20:27:01','2021-09-01 20:27:01'),(616,'default','added',178,'App\\Contact',4,'App\\User','[]','2021-09-01 20:34:40','2021-09-01 20:34:40'),(617,'default','status_changed',177,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-01 20:35:47','2021-09-01 20:35:47'),(618,'default','added',179,'App\\Contact',4,'App\\User','[]','2021-09-01 20:40:19','2021-09-01 20:40:19'),(619,'default','added',180,'App\\Contact',4,'App\\User','[]','2021-09-01 20:44:15','2021-09-01 20:44:15'),(620,'default','added',181,'App\\Contact',4,'App\\User','[]','2021-09-01 21:00:52','2021-09-01 21:00:52'),(621,'default','added',182,'App\\Contact',4,'App\\User','[]','2021-09-01 21:11:28','2021-09-01 21:11:28'),(622,'default','added',183,'App\\Contact',11,'App\\User','[]','2021-09-01 21:39:04','2021-09-01 21:39:04'),(623,'default','status_changed',161,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-01 21:39:40','2021-09-01 21:39:40'),(624,'default','added',184,'App\\Contact',11,'App\\User','[]','2021-09-01 21:45:25','2021-09-01 21:45:25'),(625,'default','added',124,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-09-01 21:54:40','2021-09-01 21:54:40'),(626,'default','status_changed',177,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-01 21:55:58','2021-09-01 21:55:58'),(627,'default','added',125,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-01 21:56:43','2021-09-01 21:56:43'),(628,'default','status_changed',176,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-01 21:57:05','2021-09-01 21:57:05'),(629,'default','added',126,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}','2021-09-01 22:00:53','2021-09-01 22:00:53'),(630,'default','status_changed',163,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-01 22:02:07','2021-09-01 22:02:07'),(631,'default','added',185,'App\\Contact',11,'App\\User','[]','2021-09-01 22:02:08','2021-09-01 22:02:08'),(632,'default','added',127,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}','2021-09-01 22:03:29','2021-09-01 22:03:29'),(633,'default','status_changed',162,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-01 22:03:52','2021-09-01 22:03:52'),(634,'default','added',128,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":950}}','2021-09-01 22:04:28','2021-09-01 22:04:28'),(635,'default','status_changed',159,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-01 22:04:53','2021-09-01 22:04:53'),(636,'default','added',186,'App\\Contact',11,'App\\User','[]','2021-09-01 22:39:00','2021-09-01 22:39:00'),(637,'default','status_changed',179,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-01 23:02:43','2021-09-01 23:02:43'),(638,'default','added',187,'App\\Contact',4,'App\\User','[]','2021-09-01 23:03:19','2021-09-01 23:03:19'),(639,'default','added',129,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":950}}','2021-09-01 23:06:57','2021-09-01 23:06:57'),(640,'default','status_changed',173,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-01 23:07:18','2021-09-01 23:07:18'),(641,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-02 12:26:38','2021-09-02 12:26:38'),(642,'default','added',188,'App\\Contact',4,'App\\User','[]','2021-09-02 13:02:38','2021-09-02 13:02:38'),(643,'default','added',189,'App\\Contact',4,'App\\User','[]','2021-09-02 13:21:23','2021-09-02 13:21:23'),(644,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-02 13:57:12','2021-09-02 13:57:12'),(645,'default','added',130,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-02 14:06:44','2021-09-02 14:06:44'),(646,'default','status_changed',189,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-02 14:06:58','2021-09-02 14:06:58'),(647,'default','added',190,'App\\Contact',4,'App\\User','[]','2021-09-02 15:21:07','2021-09-02 15:21:07'),(648,'default','status_changed',166,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-02 15:26:37','2021-09-02 15:26:37'),(649,'default','status_changed',172,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-02 15:26:46','2021-09-02 15:26:46'),(650,'default','added',191,'App\\Contact',11,'App\\User','[]','2021-09-02 16:01:13','2021-09-02 16:01:13'),(651,'default','status_changed',191,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-02 16:05:43','2021-09-02 16:05:43'),(652,'default','added',192,'App\\Contact',4,'App\\User','[]','2021-09-02 16:30:16','2021-09-02 16:30:16'),(653,'default','status_changed',185,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-02 16:41:54','2021-09-02 16:41:54'),(654,'default','status_changed',182,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-02 16:42:04','2021-09-02 16:42:04'),(655,'default','status_changed',181,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-02 16:42:16','2021-09-02 16:42:16'),(656,'default','status_changed',186,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-02 16:42:27','2021-09-02 16:42:27'),(657,'default','added',193,'App\\Contact',4,'App\\User','[]','2021-09-02 16:47:41','2021-09-02 16:47:41'),(658,'default','status_changed',138,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-02 16:48:25','2021-09-02 16:48:25'),(659,'default','status_changed',194,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Can\'t be repaired\"}','2021-09-02 18:34:26','2021-09-02 18:34:26'),(660,'default','added',194,'App\\Contact',4,'App\\User','[]','2021-09-02 18:52:02','2021-09-02 18:52:02'),(661,'default','added',195,'App\\Contact',4,'App\\User','[]','2021-09-02 18:57:06','2021-09-02 18:57:06'),(662,'default','added',196,'App\\Contact',4,'App\\User','[]','2021-09-02 19:07:49','2021-09-02 19:07:49'),(663,'default','added',197,'App\\Contact',4,'App\\User','[]','2021-09-02 19:08:37','2021-09-02 19:08:37'),(664,'default','status_changed',182,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-02 19:14:40','2021-09-02 19:14:40'),(665,'default','status_changed',181,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-02 19:15:20','2021-09-02 19:15:20'),(666,'default','status_changed',188,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-02 19:17:49','2021-09-02 19:17:49'),(667,'default','status_changed',180,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-02 19:18:04','2021-09-02 19:18:04'),(668,'default','status_changed',190,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-02 19:18:20','2021-09-02 19:18:20'),(669,'default','status_changed',186,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-02 19:21:48','2021-09-02 19:21:48'),(670,'default','status_changed',185,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-02 19:35:46','2021-09-02 19:35:46'),(671,'default','added',198,'App\\Contact',4,'App\\User','[]','2021-09-02 20:24:40','2021-09-02 20:24:40'),(672,'default','added',199,'App\\Contact',4,'App\\User','[]','2021-09-02 20:37:28','2021-09-02 20:37:28'),(673,'default','added',200,'App\\Contact',4,'App\\User','[]','2021-09-02 20:41:03','2021-09-02 20:41:03'),(674,'default','added',201,'App\\Contact',4,'App\\User','[]','2021-09-02 20:46:20','2021-09-02 20:46:20'),(675,'default','added',131,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-09-02 20:57:12','2021-09-02 20:57:12'),(676,'default','added',132,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-09-02 20:58:02','2021-09-02 20:58:02'),(677,'default','status_changed',125,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-02 21:07:29','2021-09-02 21:07:29'),(678,'default','status_changed',186,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-02 21:08:02','2021-09-02 21:08:02'),(679,'default','status_changed',182,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-02 21:08:45','2021-09-02 21:08:45'),(680,'default','added',133,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-02 21:09:48','2021-09-02 21:09:48'),(681,'default','status_changed',198,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-02 21:10:07','2021-09-02 21:10:07'),(682,'default','added',202,'App\\Contact',4,'App\\User','[]','2021-09-02 21:19:46','2021-09-02 21:19:46'),(683,'default','added',134,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}','2021-09-02 21:21:42','2021-09-02 21:21:42'),(684,'default','status_changed',158,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-02 21:22:12','2021-09-02 21:22:12'),(685,'default','status_changed',197,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-02 21:48:57','2021-09-02 21:48:57'),(686,'default','added',203,'App\\Contact',4,'App\\User','[]','2021-09-02 21:53:32','2021-09-02 21:53:32'),(687,'default','added',135,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-09-02 21:58:02','2021-09-02 21:58:02'),(688,'default','status_changed',185,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-02 21:58:48','2021-09-02 21:58:48'),(689,'default','added',204,'App\\Contact',4,'App\\User','[]','2021-09-02 22:35:23','2021-09-02 22:35:23'),(690,'default','added',136,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}','2021-09-02 22:41:38','2021-09-02 22:41:38'),(691,'default','status_changed',188,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-02 22:41:55','2021-09-02 22:41:55'),(692,'default','added',205,'App\\Contact',4,'App\\User','[]','2021-09-02 23:12:14','2021-09-02 23:12:14'),(693,'default','added',137,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-02 23:14:00','2021-09-02 23:14:00'),(694,'default','status_changed',207,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-02 23:14:28','2021-09-02 23:14:28'),(695,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-03 15:02:59','2021-09-03 15:02:59'),(696,'default','added',206,'App\\Contact',4,'App\\User','[]','2021-09-03 15:03:55','2021-09-03 15:03:55'),(697,'default','added',207,'App\\Contact',4,'App\\User','[]','2021-09-03 15:10:06','2021-09-03 15:10:06'),(698,'default','added',208,'App\\Contact',4,'App\\User','[]','2021-09-03 16:15:48','2021-09-03 16:15:48'),(699,'default','added',209,'App\\Contact',4,'App\\User','[]','2021-09-03 19:57:18','2021-09-03 19:57:18'),(700,'default','added',138,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}','2021-09-03 20:11:41','2021-09-03 20:11:41'),(701,'default','status_changed',200,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-03 20:12:20','2021-09-03 20:12:20'),(702,'default','added',210,'App\\Contact',4,'App\\User','[]','2021-09-03 21:31:51','2021-09-03 21:31:51'),(703,'default','login',1,'App\\User',1,'App\\User','[]','2021-09-03 23:32:49','2021-09-03 23:32:49'),(704,'default','added',211,'App\\Contact',1,'App\\User','[]','2021-09-03 23:33:41','2021-09-03 23:33:41'),(705,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-04 11:59:33','2021-09-04 11:59:33'),(706,'default','added',212,'App\\Contact',4,'App\\User','[]','2021-09-04 13:43:04','2021-09-04 13:43:04'),(707,'default','added',213,'App\\Contact',4,'App\\User','[]','2021-09-04 14:00:56','2021-09-04 14:00:56'),(708,'default','status_changed',210,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-04 14:33:08','2021-09-04 14:33:08'),(709,'default','status_changed',206,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-04 14:33:21','2021-09-04 14:33:21'),(710,'default','status_changed',214,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-04 14:33:37','2021-09-04 14:33:37'),(711,'default','status_changed',187,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-04 14:35:26','2021-09-04 14:35:26'),(712,'default','status_changed',183,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-04 14:36:18','2021-09-04 14:36:18'),(713,'default','status_changed',192,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-04 14:37:09','2021-09-04 14:37:09'),(714,'default','status_changed',201,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-04 14:41:49','2021-09-04 14:41:49'),(715,'default','status_changed',196,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-04 14:45:15','2021-09-04 14:45:15'),(716,'default','status_changed',195,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-04 14:45:31','2021-09-04 14:45:31'),(717,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-04 14:51:35','2021-09-04 14:51:35'),(718,'default','status_changed',124,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-04 14:52:14','2021-09-04 14:52:14'),(719,'default','status_changed',126,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-04 14:53:03','2021-09-04 14:53:03'),(720,'default','status_changed',144,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-04 14:53:25','2021-09-04 14:53:25'),(721,'default','status_changed',148,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-09-04 14:53:49','2021-09-04 14:53:49'),(722,'default','status_changed',139,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-04 14:56:11','2021-09-04 14:56:11'),(723,'default','status_changed',160,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-04 14:57:45','2021-09-04 14:57:45'),(724,'default','added',139,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-04 15:04:55','2021-09-04 15:04:55'),(725,'default','status_changed',191,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-04 15:05:25','2021-09-04 15:05:25'),(726,'default','added',214,'App\\Contact',11,'App\\User','[]','2021-09-04 15:19:24','2021-09-04 15:19:24'),(727,'default','added',140,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-09-04 16:29:44','2021-09-04 16:29:44'),(728,'default','status_changed',195,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-04 16:30:02','2021-09-04 16:30:02'),(729,'default','added',215,'App\\Contact',4,'App\\User','[]','2021-09-04 16:55:09','2021-09-04 16:55:09'),(730,'default','added',216,'App\\Contact',4,'App\\User','[]','2021-09-04 16:59:46','2021-09-04 16:59:46'),(731,'default','added',217,'App\\Contact',4,'App\\User','[]','2021-09-04 17:38:47','2021-09-04 17:38:47'),(732,'default','added',218,'App\\Contact',4,'App\\User','[]','2021-09-04 18:10:48','2021-09-04 18:10:48'),(733,'default','status_changed',206,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-04 18:17:16','2021-09-04 18:17:16'),(734,'default','status_changed',214,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-04 18:21:07','2021-09-04 18:21:07'),(735,'default','status_changed',209,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-04 18:25:29','2021-09-04 18:25:29'),(736,'default','added',141,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-09-04 18:25:44','2021-09-04 18:25:44'),(737,'default','status_changed',212,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-04 18:26:20','2021-09-04 18:26:20'),(738,'default','status_changed',215,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-04 18:26:20','2021-09-04 18:26:20'),(739,'default','status_changed',217,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-04 18:34:29','2021-09-04 18:34:29'),(740,'default','status_changed',205,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-04 18:34:55','2021-09-04 18:34:55'),(741,'default','status_changed',216,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-04 18:36:00','2021-09-04 18:36:00'),(742,'default','added',142,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-04 18:36:16','2021-09-04 18:36:16'),(743,'default','status_changed',203,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-04 18:36:25','2021-09-04 18:36:25'),(744,'default','status_changed',220,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-04 18:36:34','2021-09-04 18:36:34'),(745,'default','status_changed',196,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-04 18:36:36','2021-09-04 18:36:36'),(746,'default','status_changed',216,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-04 18:37:28','2021-09-04 18:37:28'),(747,'default','status_changed',204,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-04 18:39:57','2021-09-04 18:39:57'),(748,'default','added',143,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-04 19:04:03','2021-09-04 19:04:03'),(749,'default','status_changed',216,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-04 19:07:11','2021-09-04 19:07:11'),(750,'default','status_changed',209,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-04 19:11:16','2021-09-04 19:11:16'),(751,'default','added',219,'App\\Contact',4,'App\\User','[]','2021-09-04 19:12:43','2021-09-04 19:12:43'),(752,'default','added',220,'App\\Contact',4,'App\\User','[]','2021-09-04 19:14:22','2021-09-04 19:14:22'),(753,'default','added',221,'App\\Contact',4,'App\\User','[]','2021-09-04 19:19:25','2021-09-04 19:19:25'),(754,'default','added',222,'App\\Contact',4,'App\\User','[]','2021-09-04 19:24:56','2021-09-04 19:24:56'),(755,'default','added',223,'App\\Contact',4,'App\\User','[]','2021-09-04 19:33:24','2021-09-04 19:33:24'),(756,'default','added',144,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-09-04 19:44:05','2021-09-04 19:44:05'),(757,'default','status_changed',221,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-04 19:44:21','2021-09-04 19:44:21'),(758,'default','added',224,'App\\Contact',4,'App\\User','[]','2021-09-04 19:46:33','2021-09-04 19:46:33'),(759,'default','added',225,'App\\Contact',4,'App\\User','[]','2021-09-04 19:46:33','2021-09-04 19:46:33'),(760,'default','added',226,'App\\Contact',11,'App\\User','[]','2021-09-04 19:51:15','2021-09-04 19:51:15'),(761,'default','added',145,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-04 20:03:32','2021-09-04 20:03:32'),(762,'default','status_changed',160,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Can\'t be repaired\"}','2021-09-04 20:43:08','2021-09-04 20:43:08'),(763,'default','added',227,'App\\Contact',11,'App\\User','[]','2021-09-04 20:54:34','2021-09-04 20:54:34'),(764,'default','status_changed',214,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Can\'t be repaired\"}','2021-09-04 21:29:37','2021-09-04 21:29:37'),(765,'default','added',146,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-04 21:33:03','2021-09-04 21:33:03'),(766,'default','status_changed',226,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-04 21:33:54','2021-09-04 21:33:54'),(767,'default','added',147,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-04 21:51:56','2021-09-04 21:51:56'),(768,'default','status_changed',166,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-04 21:52:16','2021-09-04 21:52:16'),(769,'default','added',148,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-09-04 21:57:30','2021-09-04 21:57:30'),(770,'default','status_changed',227,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-04 21:57:56','2021-09-04 21:57:56'),(771,'default','added',149,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-04 22:31:57','2021-09-04 22:31:57'),(772,'default','status_changed',225,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-04 22:32:15','2021-09-04 22:32:15'),(773,'default','status_changed',139,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-04 22:44:24','2021-09-04 22:44:24'),(774,'default','status_changed',219,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-04 22:53:35','2021-09-04 22:53:35'),(775,'default','status_changed',218,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-04 22:53:52','2021-09-04 22:53:52'),(776,'default','added',150,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}','2021-09-04 23:10:00','2021-09-04 23:10:00'),(777,'default','status_changed',218,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-04 23:10:48','2021-09-04 23:10:48'),(778,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-05 12:04:59','2021-09-05 12:04:59'),(779,'default','added',228,'App\\Contact',4,'App\\User','[]','2021-09-05 13:24:08','2021-09-05 13:24:08'),(780,'default','added',229,'App\\Contact',4,'App\\User','[]','2021-09-05 13:40:07','2021-09-05 13:40:07'),(781,'default','added',230,'App\\Contact',4,'App\\User','[]','2021-09-05 13:48:51','2021-09-05 13:48:51'),(782,'default','added',231,'App\\Contact',4,'App\\User','[]','2021-09-05 13:58:28','2021-09-05 13:58:28'),(783,'default','added',232,'App\\Contact',4,'App\\User','[]','2021-09-05 14:41:51','2021-09-05 14:41:51'),(784,'default','status_changed',232,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-05 14:44:09','2021-09-05 14:44:09'),(785,'default','added',233,'App\\Contact',4,'App\\User','[]','2021-09-05 14:58:45','2021-09-05 14:58:45'),(786,'default','added',234,'App\\Contact',4,'App\\User','[]','2021-09-05 15:39:32','2021-09-05 15:39:32'),(787,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-05 15:39:50','2021-09-05 15:39:50'),(788,'default','added',235,'App\\Contact',4,'App\\User','[]','2021-09-05 15:41:43','2021-09-05 15:41:43'),(789,'default','added',236,'App\\Contact',4,'App\\User','[]','2021-09-05 16:18:10','2021-09-05 16:18:10'),(790,'default','added',151,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-05 16:19:52','2021-09-05 16:19:52'),(791,'default','status_changed',215,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-05 16:21:38','2021-09-05 16:21:38'),(792,'default','added',237,'App\\Contact',4,'App\\User','[]','2021-09-05 16:48:14','2021-09-05 16:48:14'),(793,'default','added',238,'App\\Contact',4,'App\\User','[]','2021-09-05 17:09:20','2021-09-05 17:09:20'),(794,'default','status_changed',230,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-05 17:25:29','2021-09-05 17:25:29'),(795,'default','status_changed',210,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-05 17:29:38','2021-09-05 17:29:38'),(796,'default','added',152,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}','2021-09-05 17:30:08','2021-09-05 17:30:08'),(797,'default','status_changed',174,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-05 17:31:33','2021-09-05 17:31:33'),(798,'default','status_changed',214,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-05 17:35:48','2021-09-05 17:35:48'),(799,'default','status_changed',213,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-05 17:37:43','2021-09-05 17:37:43'),(800,'default','status_changed',234,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-05 17:42:36','2021-09-05 17:42:36'),(801,'default','status_changed',233,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-05 17:44:00','2021-09-05 17:44:00'),(802,'default','added',153,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-05 18:12:52','2021-09-05 18:12:52'),(803,'default','status_changed',236,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-05 18:20:58','2021-09-05 18:20:58'),(804,'default','status_changed',126,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-05 18:30:38','2021-09-05 18:30:38'),(805,'default','added',239,'App\\Contact',4,'App\\User','[]','2021-09-05 18:35:59','2021-09-05 18:35:59'),(806,'default','added',240,'App\\Contact',4,'App\\User','[]','2021-09-05 18:37:00','2021-09-05 18:37:00'),(807,'default','added',154,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-09-05 18:53:59','2021-09-05 18:53:59'),(808,'default','status_changed',197,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-05 19:02:24','2021-09-05 19:02:24'),(809,'default','added',241,'App\\Contact',4,'App\\User','[]','2021-09-05 19:07:19','2021-09-05 19:07:19'),(810,'default','status_changed',211,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-05 19:25:00','2021-09-05 19:25:00'),(811,'default','added',242,'App\\Contact',4,'App\\User','[]','2021-09-05 19:51:35','2021-09-05 19:51:35'),(812,'default','added',155,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-05 20:33:12','2021-09-05 20:33:12'),(813,'default','added',156,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-09-05 20:36:09','2021-09-05 20:36:09'),(814,'default','added',157,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-05 20:38:37','2021-09-05 20:38:37'),(815,'default','status_changed',232,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-05 20:40:06','2021-09-05 20:40:06'),(816,'default','added',243,'App\\Contact',4,'App\\User','[]','2021-09-05 20:50:30','2021-09-05 20:50:30'),(817,'default','added',158,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-09-05 20:56:47','2021-09-05 20:56:47'),(818,'default','status_changed',98,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-05 20:57:05','2021-09-05 20:57:05'),(819,'default','added',159,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}','2021-09-05 21:19:28','2021-09-05 21:19:28'),(820,'default','status_changed',220,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-05 21:20:06','2021-09-05 21:20:06'),(821,'default','added',160,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-09-05 21:20:49','2021-09-05 21:20:49'),(822,'default','status_changed',179,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-05 21:21:11','2021-09-05 21:21:11'),(823,'default','added',161,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-09-05 21:22:08','2021-09-05 21:22:08'),(824,'default','added',162,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-09-05 21:22:52','2021-09-05 21:22:52'),(825,'default','added',244,'App\\Contact',4,'App\\User','[]','2021-09-05 21:48:55','2021-09-05 21:48:55'),(826,'default','added',245,'App\\Contact',4,'App\\User','[]','2021-09-05 21:51:38','2021-09-05 21:51:38'),(827,'default','added',163,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-09-05 21:52:26','2021-09-05 21:52:26'),(828,'default','status_changed',239,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-05 21:57:02','2021-09-05 21:57:02'),(829,'default','status_changed',233,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-05 21:57:43','2021-09-05 21:57:43'),(830,'default','status_changed',237,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-05 21:58:06','2021-09-05 21:58:06'),(831,'default','status_changed',242,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-05 21:58:16','2021-09-05 21:58:16'),(832,'default','status_changed',240,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-05 21:58:27','2021-09-05 21:58:27'),(833,'default','status_changed',231,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-05 21:58:37','2021-09-05 21:58:37'),(834,'default','status_changed',241,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-05 21:59:22','2021-09-05 21:59:22'),(835,'default','added',164,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-05 22:02:23','2021-09-05 22:02:23'),(836,'default','status_changed',238,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-05 22:03:00','2021-09-05 22:03:00'),(837,'default','added',246,'App\\Contact',4,'App\\User','[]','2021-09-05 22:04:06','2021-09-05 22:04:06'),(838,'default','added',165,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-09-05 22:05:45','2021-09-05 22:05:45'),(839,'default','status_changed',244,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-05 22:08:47','2021-09-05 22:08:47'),(840,'default','status_changed',243,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-05 22:08:56','2021-09-05 22:08:56'),(841,'default','status_changed',224,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-05 22:09:05','2021-09-05 22:09:05'),(842,'default','status_changed',229,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-05 22:09:16','2021-09-05 22:09:16'),(843,'default','status_changed',148,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-05 22:09:24','2021-09-05 22:09:24'),(844,'default','status_changed',237,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-05 23:58:14','2021-09-05 23:58:14'),(845,'default','status_changed',236,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-06 00:01:36','2021-09-06 00:01:36'),(846,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-06 12:23:11','2021-09-06 12:23:11'),(847,'default','added',247,'App\\Contact',4,'App\\User','[]','2021-09-06 12:24:08','2021-09-06 12:24:08'),(848,'default','added',166,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":125}}','2021-09-06 13:29:30','2021-09-06 13:29:30'),(849,'default','added',248,'App\\Contact',4,'App\\User','[]','2021-09-06 14:00:22','2021-09-06 14:00:22'),(850,'default','added',249,'App\\Contact',4,'App\\User','[]','2021-09-06 14:14:40','2021-09-06 14:14:40'),(851,'default','added',250,'App\\Contact',4,'App\\User','[]','2021-09-06 14:19:40','2021-09-06 14:19:40'),(852,'default','added',251,'App\\Contact',4,'App\\User','[]','2021-09-06 14:25:15','2021-09-06 14:25:15'),(853,'default','added',252,'App\\Contact',4,'App\\User','[]','2021-09-06 14:28:34','2021-09-06 14:28:34'),(854,'default','added',167,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":800}}','2021-09-06 14:31:04','2021-09-06 14:31:04'),(855,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-06 14:55:49','2021-09-06 14:55:49'),(856,'default','added',253,'App\\Contact',11,'App\\User','[]','2021-09-06 14:57:12','2021-09-06 14:57:12'),(857,'default','added',254,'App\\Contact',4,'App\\User','[]','2021-09-06 15:01:33','2021-09-06 15:01:33'),(858,'default','added',255,'App\\Contact',4,'App\\User','[]','2021-09-06 15:04:01','2021-09-06 15:04:01'),(859,'default','added',256,'App\\Contact',11,'App\\User','[]','2021-09-06 15:05:30','2021-09-06 15:05:30'),(860,'default','added',257,'App\\Contact',11,'App\\User','[]','2021-09-06 15:10:03','2021-09-06 15:10:03'),(861,'default','added',258,'App\\Contact',11,'App\\User','[]','2021-09-06 15:13:29','2021-09-06 15:13:29'),(862,'default','added',259,'App\\Contact',11,'App\\User','[]','2021-09-06 15:15:21','2021-09-06 15:15:21'),(863,'default','added',260,'App\\Contact',11,'App\\User','[]','2021-09-06 15:18:01','2021-09-06 15:18:01'),(864,'default','added',261,'App\\Contact',4,'App\\User','[]','2021-09-06 15:18:06','2021-09-06 15:18:06'),(865,'default','added',262,'App\\Contact',4,'App\\User','[]','2021-09-06 15:18:37','2021-09-06 15:18:37'),(866,'default','added',168,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-06 15:21:19','2021-09-06 15:21:19'),(867,'default','added',169,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-09-06 15:25:49','2021-09-06 15:25:49'),(868,'default','status_changed',231,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-06 15:28:10','2021-09-06 15:28:10'),(869,'default','added',170,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}','2021-09-06 15:29:24','2021-09-06 15:29:24'),(870,'default','status_changed',211,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-06 15:29:46','2021-09-06 15:29:46'),(871,'default','added',171,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":125}}','2021-09-06 15:31:45','2021-09-06 15:31:45'),(872,'default','status_changed',172,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-06 15:32:09','2021-09-06 15:32:09'),(873,'default','added',263,'App\\Contact',4,'App\\User','[]','2021-09-06 16:14:08','2021-09-06 16:14:08'),(874,'default','added',264,'App\\Contact',11,'App\\User','[]','2021-09-06 16:18:15','2021-09-06 16:18:15'),(875,'default','added',265,'App\\Contact',4,'App\\User','[]','2021-09-06 16:27:17','2021-09-06 16:27:17'),(876,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-06 16:30:11','2021-09-06 16:30:11'),(877,'default','added',266,'App\\Contact',4,'App\\User','[]','2021-09-06 16:32:41','2021-09-06 16:32:41'),(878,'default','added',267,'App\\Contact',11,'App\\User','[]','2021-09-06 16:33:22','2021-09-06 16:33:22'),(879,'default','added',268,'App\\Contact',11,'App\\User','[]','2021-09-06 16:36:10','2021-09-06 16:36:10'),(880,'default','added',269,'App\\Contact',11,'App\\User','[]','2021-09-06 16:38:46','2021-09-06 16:38:46'),(881,'default','added',270,'App\\Contact',4,'App\\User','[]','2021-09-06 16:39:03','2021-09-06 16:39:03'),(882,'default','added',271,'App\\Contact',11,'App\\User','[]','2021-09-06 16:43:28','2021-09-06 16:43:28'),(883,'default','status_changed',254,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Finished\"}','2021-09-06 16:50:22','2021-09-06 16:50:22'),(884,'default','added',272,'App\\Contact',4,'App\\User','[]','2021-09-06 16:52:55','2021-09-06 16:52:55'),(885,'default','status_changed',254,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-06 16:55:44','2021-09-06 16:55:44'),(886,'default','added',172,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-06 17:15:12','2021-09-06 17:15:12'),(887,'default','added',173,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-09-06 17:25:00','2021-09-06 17:25:00'),(888,'default','status_changed',237,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-06 17:30:07','2021-09-06 17:30:07'),(889,'default','added',273,'App\\Contact',4,'App\\User','[]','2021-09-06 17:37:00','2021-09-06 17:37:00'),(890,'default','added',274,'App\\Contact',4,'App\\User','[]','2021-09-06 17:39:08','2021-09-06 17:39:08'),(891,'default','added',275,'App\\Contact',4,'App\\User','[]','2021-09-06 17:40:36','2021-09-06 17:40:36'),(892,'default','status_changed',126,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-06 17:53:55','2021-09-06 17:53:55'),(893,'default','status_changed',144,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-06 18:14:28','2021-09-06 18:14:28'),(894,'default','status_changed',243,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-09-06 19:10:51','2021-09-06 19:10:51'),(895,'default','added',276,'App\\Contact',4,'App\\User','[]','2021-09-06 19:13:55','2021-09-06 19:13:55'),(896,'default','added',174,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-06 19:41:24','2021-09-06 19:41:24'),(897,'default','status_changed',241,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-06 19:42:10','2021-09-06 19:42:10'),(898,'default','added',277,'App\\Contact',4,'App\\User','[]','2021-09-06 20:20:14','2021-09-06 20:20:14'),(899,'default','added',278,'App\\Contact',4,'App\\User','[]','2021-09-06 20:41:04','2021-09-06 20:41:04'),(900,'default','added',279,'App\\Contact',11,'App\\User','[]','2021-09-06 21:11:43','2021-09-06 21:11:43'),(901,'default','added',175,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-09-06 21:12:03','2021-09-06 21:12:03'),(902,'default','added',280,'App\\Contact',4,'App\\User','[]','2021-09-06 21:34:09','2021-09-06 21:34:09'),(903,'default','added',176,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}','2021-09-06 21:44:32','2021-09-06 21:44:32'),(904,'default','status_changed',99,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-06 21:44:49','2021-09-06 21:44:49'),(905,'default','added',177,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-09-06 21:45:19','2021-09-06 21:45:19'),(906,'default','status_changed',243,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-06 21:45:41','2021-09-06 21:45:41'),(907,'default','added',178,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-06 21:46:29','2021-09-06 21:46:29'),(908,'default','added',179,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-09-06 21:48:02','2021-09-06 21:48:02'),(909,'default','added',180,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}','2021-09-06 21:49:31','2021-09-06 21:49:31'),(910,'default','added',181,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-06 22:00:18','2021-09-06 22:00:18'),(911,'default','status_changed',206,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-06 22:00:33','2021-09-06 22:00:33'),(912,'default','added',182,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-09-06 22:03:15','2021-09-06 22:03:15'),(913,'default','status_changed',202,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-06 22:05:54','2021-09-06 22:05:54'),(914,'default','added',281,'App\\Contact',4,'App\\User','[]','2021-09-06 22:06:22','2021-09-06 22:06:22'),(915,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-07 13:00:10','2021-09-07 13:00:10'),(916,'default','added',282,'App\\Contact',4,'App\\User','[]','2021-09-07 13:00:49','2021-09-07 13:00:49'),(917,'default','added',16,'App\\User',1,'App\\User','[]','2021-09-07 14:15:41','2021-09-07 14:15:41'),(918,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-07 14:17:12','2021-09-07 14:17:12'),(919,'default','added',283,'App\\Contact',4,'App\\User','[]','2021-09-07 14:18:00','2021-09-07 14:18:00'),(920,'default','added',284,'App\\Contact',4,'App\\User','[]','2021-09-07 14:25:00','2021-09-07 14:25:00'),(921,'default','added',285,'App\\Contact',4,'App\\User','[]','2021-09-07 14:34:20','2021-09-07 14:34:20'),(922,'default','added',286,'App\\Contact',4,'App\\User','[]','2021-09-07 14:39:21','2021-09-07 14:39:21'),(923,'default','status_changed',274,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-07 15:00:02','2021-09-07 15:00:02'),(924,'default','login',16,'App\\User',16,'App\\User','[]','2021-09-07 15:04:33','2021-09-07 15:04:33'),(925,'default','added',287,'App\\Contact',4,'App\\User','[]','2021-09-07 15:04:34','2021-09-07 15:04:34'),(926,'default','added',288,'App\\Contact',4,'App\\User','[]','2021-09-07 15:16:01','2021-09-07 15:16:01'),(927,'default','added',289,'App\\Contact',4,'App\\User','[]','2021-09-07 15:21:21','2021-09-07 15:21:21'),(928,'default','status_changed',160,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-07 15:58:27','2021-09-07 15:58:27'),(929,'default','added',290,'App\\Contact',4,'App\\User','[]','2021-09-07 16:14:51','2021-09-07 16:14:51'),(930,'default','added',291,'App\\Contact',4,'App\\User','[]','2021-09-07 16:22:19','2021-09-07 16:22:19'),(931,'default','logout',16,'App\\User',16,'App\\User','[]','2021-09-07 16:36:09','2021-09-07 16:36:09'),(932,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-07 16:36:56','2021-09-07 16:36:56'),(933,'default','status_changed',280,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-07 16:48:54','2021-09-07 16:48:54'),(934,'default','added',292,'App\\Contact',4,'App\\User','[]','2021-09-07 16:58:47','2021-09-07 16:58:47'),(935,'default','added',183,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-09-07 17:19:35','2021-09-07 17:19:35'),(936,'default','status_changed',210,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-07 17:19:56','2021-09-07 17:19:56'),(937,'default','added',184,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-07 17:20:23','2021-09-07 17:20:23'),(938,'default','status_changed',280,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-07 17:20:50','2021-09-07 17:20:50'),(939,'default','status_changed',275,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-07 17:23:00','2021-09-07 17:23:00'),(940,'default','added',293,'App\\Contact',4,'App\\User','[]','2021-09-07 18:02:20','2021-09-07 18:02:20'),(941,'default','added',294,'App\\Contact',4,'App\\User','[]','2021-09-07 18:04:45','2021-09-07 18:04:45'),(942,'default','added',295,'App\\Contact',4,'App\\User','[]','2021-09-07 18:17:28','2021-09-07 18:17:28'),(943,'default','added',185,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-07 18:28:44','2021-09-07 18:28:44'),(944,'default','status_changed',274,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-07 18:30:54','2021-09-07 18:30:54'),(945,'default','added',186,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-09-07 18:58:24','2021-09-07 18:58:24'),(946,'default','status_changed',240,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-07 18:58:46','2021-09-07 18:58:46'),(947,'default','added',296,'App\\Contact',4,'App\\User','[]','2021-09-07 19:00:49','2021-09-07 19:00:49'),(948,'default','added',297,'App\\Contact',4,'App\\User','[]','2021-09-07 19:11:26','2021-09-07 19:11:26'),(949,'default','status_changed',277,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-07 19:24:09','2021-09-07 19:24:09'),(950,'default','status_changed',288,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-07 19:24:28','2021-09-07 19:24:28'),(951,'default','added',187,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":125}}','2021-09-07 19:28:26','2021-09-07 19:28:26'),(952,'default','status_changed',254,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-07 19:28:51','2021-09-07 19:28:51'),(953,'default','added',188,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-07 19:29:08','2021-09-07 19:29:08'),(954,'default','status_changed',253,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-07 19:30:14','2021-09-07 19:30:14'),(955,'default','added',189,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1200}}','2021-09-07 19:30:38','2021-09-07 19:30:38'),(956,'default','status_changed',219,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-07 19:31:07','2021-09-07 19:31:07'),(957,'default','added',190,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-07 19:31:32','2021-09-07 19:31:32'),(958,'default','status_changed',223,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-07 19:32:03','2021-09-07 19:32:03'),(959,'default','status_changed',275,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-07 19:32:37','2021-09-07 19:32:37'),(960,'default','added',298,'App\\Contact',4,'App\\User','[]','2021-09-07 19:40:00','2021-09-07 19:40:00'),(961,'default','added',299,'App\\Contact',4,'App\\User','[]','2021-09-07 19:44:02','2021-09-07 19:44:02'),(962,'default','added',300,'App\\Contact',4,'App\\User','[]','2021-09-07 20:43:38','2021-09-07 20:43:38'),(963,'default','added',191,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-07 20:47:28','2021-09-07 20:47:28'),(964,'default','added',301,'App\\Contact',4,'App\\User','[]','2021-09-07 20:51:53','2021-09-07 20:51:53'),(965,'default','added',192,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":125}}','2021-09-07 20:59:07','2021-09-07 20:59:07'),(966,'default','status_changed',277,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-07 20:59:44','2021-09-07 20:59:44'),(967,'default','added',193,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-09-07 21:25:37','2021-09-07 21:25:37'),(968,'default','status_changed',180,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-07 21:25:58','2021-09-07 21:25:58'),(969,'default','added',302,'App\\Contact',4,'App\\User','[]','2021-09-07 21:31:12','2021-09-07 21:31:12'),(970,'default','added',194,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-07 21:33:21','2021-09-07 21:33:21'),(971,'default','status_changed',279,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-07 21:35:26','2021-09-07 21:35:26'),(972,'default','added',195,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}','2021-09-07 21:36:03','2021-09-07 21:36:03'),(973,'default','status_changed',294,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-07 21:55:04','2021-09-07 21:55:04'),(974,'default','status_changed',289,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-07 21:56:07','2021-09-07 21:56:07'),(975,'default','added',196,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-07 22:08:51','2021-09-07 22:08:51'),(976,'default','status_changed',295,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-07 22:09:12','2021-09-07 22:09:12'),(977,'default','logout',4,'App\\User',4,'App\\User','[]','2021-09-07 22:44:19','2021-09-07 22:44:19'),(978,'default','added',19,'App\\User',1,'App\\User','[]','2021-09-07 22:47:04','2021-09-07 22:47:04'),(979,'default','added',303,'App\\Contact',4,'App\\User','[]','2021-09-07 23:24:15','2021-09-07 23:24:15'),(980,'default','added',304,'App\\Contact',4,'App\\User','[]','2021-09-07 23:27:34','2021-09-07 23:27:34'),(981,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-08 12:52:52','2021-09-08 12:52:52'),(982,'default','added',305,'App\\Contact',4,'App\\User','[]','2021-09-08 13:06:45','2021-09-08 13:06:45'),(983,'default','added',306,'App\\Contact',4,'App\\User','[]','2021-09-08 13:26:24','2021-09-08 13:26:24'),(984,'default','added',307,'App\\Contact',4,'App\\User','[]','2021-09-08 13:28:42','2021-09-08 13:28:42'),(985,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-08 13:45:58','2021-09-08 13:45:58'),(986,'default','status_changed',291,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-08 13:49:48','2021-09-08 13:49:48'),(987,'default','status_changed',229,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-08 13:50:10','2021-09-08 13:50:10'),(988,'default','status_changed',273,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-08 14:42:05','2021-09-08 14:42:05'),(989,'default','logout',4,'App\\User',4,'App\\User','[]','2021-09-08 14:55:58','2021-09-08 14:55:58'),(990,'default','login',19,'App\\User',19,'App\\User','[]','2021-09-08 14:56:17','2021-09-08 14:56:17'),(991,'default','logout',19,'App\\User',19,'App\\User','[]','2021-09-08 14:58:25','2021-09-08 14:58:25'),(992,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-08 14:58:39','2021-09-08 14:58:39'),(993,'default','added',197,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-08 15:39:28','2021-09-08 15:39:28'),(994,'default','status_changed',230,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-08 15:40:03','2021-09-08 15:40:03'),(995,'default','added',308,'App\\Contact',4,'App\\User','[]','2021-09-08 15:52:09','2021-09-08 15:52:09'),(996,'default','added',198,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-09-08 16:07:15','2021-09-08 16:07:15'),(997,'default','added',309,'App\\Contact',4,'App\\User','[]','2021-09-08 16:11:57','2021-09-08 16:11:57'),(998,'default','status_changed',303,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-08 16:26:22','2021-09-08 16:26:22'),(999,'default','added',310,'App\\Contact',4,'App\\User','[]','2021-09-08 16:41:06','2021-09-08 16:41:06'),(1000,'default','added',311,'App\\Contact',4,'App\\User','[]','2021-09-08 16:43:42','2021-09-08 16:43:42'),(1001,'default','added',199,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-08 17:12:13','2021-09-08 17:12:13'),(1002,'default','status_changed',304,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-08 17:12:31','2021-09-08 17:12:31'),(1003,'default','status_changed',305,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-08 17:23:23','2021-09-08 17:23:23'),(1004,'default','status_changed',307,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-08 17:23:36','2021-09-08 17:23:36'),(1005,'default','added',200,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-09-08 17:28:23','2021-09-08 17:28:23'),(1006,'default','status_changed',294,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-08 17:28:59','2021-09-08 17:28:59'),(1007,'default','added',201,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-09-08 18:20:32','2021-09-08 18:20:32'),(1008,'default','status_changed',278,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-08 18:20:59','2021-09-08 18:20:59'),(1009,'default','added',202,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-08 18:31:53','2021-09-08 18:31:53'),(1010,'default','status_changed',148,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-08 18:32:11','2021-09-08 18:32:11'),(1011,'default','added',312,'App\\Contact',4,'App\\User','[]','2021-09-08 18:32:49','2021-09-08 18:32:49'),(1012,'default','status_changed',308,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-08 18:39:12','2021-09-08 18:39:12'),(1013,'default','status_changed',301,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-08 18:48:00','2021-09-08 18:48:00'),(1014,'default','status_changed',299,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-08 18:48:10','2021-09-08 18:48:10'),(1015,'default','status_changed',302,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-08 18:48:27','2021-09-08 18:48:27'),(1016,'default','status_changed',290,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-08 18:48:46','2021-09-08 18:48:46'),(1017,'default','added',203,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-08 19:12:56','2021-09-08 19:12:56'),(1018,'default','status_changed',306,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-08 19:21:40','2021-09-08 19:21:40'),(1019,'default','status_changed',292,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-08 19:22:26','2021-09-08 19:22:26'),(1020,'default','added',313,'App\\Contact',4,'App\\User','[]','2021-09-08 19:38:22','2021-09-08 19:38:22'),(1021,'default','added',314,'App\\Contact',4,'App\\User','[]','2021-09-08 19:48:57','2021-09-08 19:48:57'),(1022,'default','added',315,'App\\Contact',4,'App\\User','[]','2021-09-08 19:50:32','2021-09-08 19:50:32'),(1023,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-08 19:58:37','2021-09-08 19:58:37'),(1024,'default','added',316,'App\\Contact',4,'App\\User','[]','2021-09-08 20:22:15','2021-09-08 20:22:15'),(1025,'default','added',317,'App\\Contact',4,'App\\User','[]','2021-09-08 20:28:34','2021-09-08 20:28:34'),(1026,'default','status_changed',309,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-08 20:28:57','2021-09-08 20:28:57'),(1027,'default','added',318,'App\\Contact',4,'App\\User','[]','2021-09-08 20:42:15','2021-09-08 20:42:15'),(1028,'default','added',204,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-08 20:56:34','2021-09-08 20:56:34'),(1029,'default','status_changed',312,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-08 20:57:02','2021-09-08 20:57:02'),(1030,'default','added',205,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}','2021-09-08 21:50:37','2021-09-08 21:50:37'),(1031,'default','added',319,'App\\Contact',4,'App\\User','[]','2021-09-08 21:53:30','2021-09-08 21:53:30'),(1032,'default','status_changed',307,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-08 21:59:42','2021-09-08 21:59:42'),(1033,'default','status_changed',213,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-08 22:00:27','2021-09-08 22:00:27'),(1034,'default','added',206,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}','2021-09-08 22:15:04','2021-09-08 22:15:04'),(1035,'default','added',207,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1150}}','2021-09-08 22:18:28','2021-09-08 22:18:28'),(1036,'default','status_changed',291,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-08 22:19:49','2021-09-08 22:19:49'),(1037,'default','added',208,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}','2021-09-09 00:04:58','2021-09-09 00:04:58'),(1038,'default','added',209,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-09 00:06:39','2021-09-09 00:06:39'),(1039,'default','status_changed',209,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-09 00:07:04','2021-09-09 00:07:04'),(1040,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-09 12:43:02','2021-09-09 12:43:02'),(1041,'default','added',210,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-09-09 12:49:50','2021-09-09 12:49:50'),(1042,'default','status_changed',293,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-09 12:51:01','2021-09-09 12:51:01'),(1043,'default','added',211,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-09-09 13:55:26','2021-09-09 13:55:26'),(1044,'default','added',212,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-09-09 13:58:44','2021-09-09 13:58:44'),(1045,'default','status_changed',289,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-09 14:00:45','2021-09-09 14:00:45'),(1046,'default','added',320,'App\\Contact',4,'App\\User','[]','2021-09-09 14:09:59','2021-09-09 14:09:59'),(1047,'default','added',321,'App\\Contact',4,'App\\User','[]','2021-09-09 14:46:32','2021-09-09 14:46:32'),(1048,'default','added',213,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":725}}','2021-09-09 15:00:04','2021-09-09 15:00:04'),(1049,'default','status_changed',305,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-09 15:00:30','2021-09-09 15:00:30'),(1050,'default','added',214,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-09-09 15:53:40','2021-09-09 15:53:40'),(1051,'default','status_changed',300,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-09 15:54:03','2021-09-09 15:54:03'),(1052,'default','status_changed',315,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-09 15:55:12','2021-09-09 15:55:12'),(1053,'default','added',322,'App\\Contact',4,'App\\User','[]','2021-09-09 16:03:22','2021-09-09 16:03:22'),(1054,'default','added',323,'App\\Contact',4,'App\\User','[]','2021-09-09 16:08:00','2021-09-09 16:08:00'),(1055,'default','added',324,'App\\Contact',4,'App\\User','[]','2021-09-09 16:22:32','2021-09-09 16:22:32'),(1056,'default','added',325,'App\\Contact',4,'App\\User','[]','2021-09-09 16:26:50','2021-09-09 16:26:50'),(1057,'default','added',326,'App\\Contact',4,'App\\User','[]','2021-09-09 16:46:55','2021-09-09 16:46:55'),(1058,'default','status_changed',317,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-09 17:11:55','2021-09-09 17:11:55'),(1059,'default','status_changed',316,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-09 17:14:09','2021-09-09 17:14:09'),(1060,'default','status_changed',314,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-09 17:14:19','2021-09-09 17:14:19'),(1061,'default','status_changed',319,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-09 17:14:29','2021-09-09 17:14:29'),(1062,'default','status_changed',313,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-09 17:14:40','2021-09-09 17:14:40'),(1063,'default','added',215,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":125}}','2021-09-09 17:16:52','2021-09-09 17:16:52'),(1064,'default','status_changed',321,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-09 17:17:30','2021-09-09 17:17:30'),(1065,'default','status_changed',309,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":\"\\u0631\\u0641\\u0636 \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644 \\u0627\\u0644\\u0627\\u0635\\u0644\\u0627\\u062d\",\"updated_status\":\"Can\'t be repaired\"}','2021-09-09 17:18:20','2021-09-09 17:18:20'),(1066,'default','added',327,'App\\Contact',4,'App\\User','[]','2021-09-09 18:41:01','2021-09-09 18:41:01'),(1067,'default','status_changed',309,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-09 18:46:00','2021-09-09 18:46:00'),(1068,'default','added',328,'App\\Contact',4,'App\\User','[]','2021-09-09 19:10:12','2021-09-09 19:10:12'),(1069,'default','added',216,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1200}}','2021-09-09 19:12:00','2021-09-09 19:12:00'),(1070,'default','status_changed',324,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-09 19:12:59','2021-09-09 19:12:59'),(1071,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-09 19:43:00','2021-09-09 19:43:00'),(1072,'default','status_changed',322,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-09 19:44:59','2021-09-09 19:44:59'),(1073,'default','status_changed',314,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-09 19:45:47','2021-09-09 19:45:47'),(1074,'default','added',217,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-09 19:47:21','2021-09-09 19:47:21'),(1075,'default','status_changed',319,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-09 19:47:58','2021-09-09 19:47:58'),(1076,'default','added',329,'App\\Contact',4,'App\\User','[]','2021-09-09 20:37:39','2021-09-09 20:37:39'),(1077,'default','added',218,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-09-09 20:41:06','2021-09-09 20:41:06'),(1078,'default','status_changed',314,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-09 20:41:32','2021-09-09 20:41:32'),(1079,'default','added',330,'App\\Contact',4,'App\\User','[]','2021-09-09 20:45:27','2021-09-09 20:45:27'),(1080,'default','added',219,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-09-09 20:48:28','2021-09-09 20:48:28'),(1081,'default','added',331,'App\\Contact',4,'App\\User','[]','2021-09-09 21:05:36','2021-09-09 21:05:36'),(1082,'default','added',332,'App\\Contact',4,'App\\User','[]','2021-09-09 21:05:52','2021-09-09 21:05:52'),(1083,'default','status_changed',313,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-09 21:07:54','2021-09-09 21:07:54'),(1084,'default','status_changed',308,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-09 21:08:08','2021-09-09 21:08:08'),(1085,'default','status_changed',308,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Can\'t be repaired\"}','2021-09-09 21:08:18','2021-09-09 21:08:18'),(1086,'default','status_changed',316,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-09 21:08:34','2021-09-09 21:08:34'),(1087,'default','added',220,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-09 21:09:06','2021-09-09 21:09:06'),(1088,'default','added',221,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-09 21:22:25','2021-09-09 21:22:25'),(1089,'default','status_changed',316,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-09 21:23:07','2021-09-09 21:23:07'),(1090,'default','added',222,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":175}}','2021-09-09 21:37:14','2021-09-09 21:37:14'),(1091,'default','status_changed',302,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-09 21:37:34','2021-09-09 21:37:34'),(1092,'default','added',223,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1100}}','2021-09-09 21:38:00','2021-09-09 21:38:00'),(1093,'default','status_changed',70,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-09 21:38:19','2021-09-09 21:38:19'),(1094,'default','added',333,'App\\Contact',4,'App\\User','[]','2021-09-09 22:01:35','2021-09-09 22:01:35'),(1095,'default','added',334,'App\\Contact',4,'App\\User','[]','2021-09-09 22:03:19','2021-09-09 22:03:19'),(1096,'default','status_changed',325,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-09 22:56:38','2021-09-09 22:56:38'),(1097,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-10 14:13:20','2021-09-10 14:13:20'),(1098,'default','added',335,'App\\Contact',4,'App\\User','[]','2021-09-10 14:16:42','2021-09-10 14:16:42'),(1099,'default','added',336,'App\\Contact',4,'App\\User','[]','2021-09-10 16:24:43','2021-09-10 16:24:43'),(1100,'default','added',337,'App\\Contact',4,'App\\User','[]','2021-09-10 16:48:13','2021-09-10 16:48:13'),(1101,'default','added',338,'App\\Contact',4,'App\\User','[]','2021-09-10 17:23:50','2021-09-10 17:23:50'),(1102,'default','added',339,'App\\Contact',4,'App\\User','[]','2021-09-10 17:27:15','2021-09-10 17:27:15'),(1103,'default','added',340,'App\\Contact',4,'App\\User','[]','2021-09-10 17:40:22','2021-09-10 17:40:22'),(1104,'default','added',341,'App\\Contact',4,'App\\User','[]','2021-09-10 19:11:53','2021-09-10 19:11:53'),(1105,'default','added',342,'App\\Contact',4,'App\\User','[]','2021-09-10 19:45:04','2021-09-10 19:45:04'),(1106,'default','added',343,'App\\Contact',4,'App\\User','[]','2021-09-10 20:36:05','2021-09-10 20:36:05'),(1107,'default','added',344,'App\\Contact',4,'App\\User','[]','2021-09-10 20:41:08','2021-09-10 20:41:08'),(1108,'default','added',224,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-10 22:39:36','2021-09-10 22:39:36'),(1109,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-11 10:33:23','2021-09-11 10:33:23'),(1110,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-11 12:19:36','2021-09-11 12:19:36'),(1111,'default','added',345,'App\\Contact',4,'App\\User','[]','2021-09-11 12:36:48','2021-09-11 12:36:48'),(1112,'default','added',225,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-11 12:39:32','2021-09-11 12:39:32'),(1113,'default','added',346,'App\\Contact',4,'App\\User','[]','2021-09-11 13:15:04','2021-09-11 13:15:04'),(1114,'default','added',226,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-11 13:33:07','2021-09-11 13:33:07'),(1115,'default','status_changed',325,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-11 13:35:31','2021-09-11 13:35:31'),(1116,'default','added',227,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-11 13:37:43','2021-09-11 13:37:43'),(1117,'default','added',228,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-11 13:38:17','2021-09-11 13:38:17'),(1118,'default','status_changed',318,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-11 13:38:39','2021-09-11 13:38:39'),(1119,'default','added',347,'App\\Contact',4,'App\\User','[]','2021-09-11 13:43:27','2021-09-11 13:43:27'),(1120,'default','status_changed',313,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-11 14:18:07','2021-09-11 14:18:07'),(1121,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-11 14:35:04','2021-09-11 14:35:04'),(1122,'default','added',348,'App\\Contact',4,'App\\User','[]','2021-09-11 14:52:46','2021-09-11 14:52:46'),(1123,'default','status_changed',242,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-11 14:58:51','2021-09-11 14:58:51'),(1124,'default','status_changed',144,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-11 15:00:51','2021-09-11 15:00:51'),(1125,'default','status_changed',306,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-11 15:02:24','2021-09-11 15:02:24'),(1126,'default','status_changed',229,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-11 15:07:03','2021-09-11 15:07:03'),(1127,'default','added',349,'App\\Contact',1,'App\\User','[]','2021-09-11 15:16:37','2021-09-11 15:16:37'),(1128,'default','edited',16,'App\\User',1,'App\\User','[]','2021-09-11 15:19:39','2021-09-11 15:19:39'),(1129,'default','status_changed',124,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-11 15:30:18','2021-09-11 15:30:18'),(1130,'default','added',350,'App\\Contact',4,'App\\User','[]','2021-09-11 15:32:29','2021-09-11 15:32:29'),(1131,'default','added',351,'App\\Contact',4,'App\\User','[]','2021-09-11 15:34:54','2021-09-11 15:34:54'),(1132,'default','added',229,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-09-11 15:36:30','2021-09-11 15:36:30'),(1133,'default','status_changed',339,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-11 15:47:48','2021-09-11 15:47:48'),(1134,'default','status_changed',326,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-11 15:50:21','2021-09-11 15:50:21'),(1135,'default','status_changed',344,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-11 15:50:39','2021-09-11 15:50:39'),(1136,'default','status_changed',346,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-11 15:50:51','2021-09-11 15:50:51'),(1137,'default','status_changed',342,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-11 15:51:06','2021-09-11 15:51:06'),(1138,'default','status_changed',331,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-11 15:51:23','2021-09-11 15:51:23'),(1139,'default','status_changed',327,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-11 15:51:35','2021-09-11 15:51:35'),(1140,'default','added',352,'App\\Contact',4,'App\\User','[]','2021-09-11 15:55:38','2021-09-11 15:55:38'),(1141,'default','added',353,'App\\Contact',4,'App\\User','[]','2021-09-11 15:56:44','2021-09-11 15:56:44'),(1142,'default','status_changed',334,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-11 16:01:56','2021-09-11 16:01:56'),(1143,'default','status_changed',335,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-11 16:02:09','2021-09-11 16:02:09'),(1144,'default','added',354,'App\\Contact',4,'App\\User','[]','2021-09-11 16:06:45','2021-09-11 16:06:45'),(1145,'default','added',230,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-09-11 16:11:53','2021-09-11 16:11:53'),(1146,'default','added',355,'App\\Contact',4,'App\\User','[]','2021-09-11 16:24:48','2021-09-11 16:24:48'),(1147,'default','added',356,'App\\Contact',4,'App\\User','[]','2021-09-11 16:28:55','2021-09-11 16:28:55'),(1148,'default','added',231,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-11 16:31:41','2021-09-11 16:31:41'),(1149,'default','added',357,'App\\Contact',4,'App\\User','[]','2021-09-11 17:00:23','2021-09-11 17:00:23'),(1150,'default','status_changed',353,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-11 17:21:59','2021-09-11 17:21:59'),(1151,'default','added',358,'App\\Contact',4,'App\\User','[]','2021-09-11 17:28:17','2021-09-11 17:28:17'),(1152,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-11 18:16:43','2021-09-11 18:16:43'),(1153,'default','added',359,'App\\Contact',11,'App\\User','[]','2021-09-11 18:17:49','2021-09-11 18:17:49'),(1154,'default','added',360,'App\\Contact',4,'App\\User','[]','2021-09-11 18:23:03','2021-09-11 18:23:03'),(1155,'default','added',232,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-09-11 18:28:51','2021-09-11 18:28:51'),(1156,'default','status_changed',56,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-11 18:34:48','2021-09-11 18:34:48'),(1157,'default','added',361,'App\\Contact',4,'App\\User','[]','2021-09-11 18:48:24','2021-09-11 18:48:24'),(1158,'default','added',362,'App\\Contact',11,'App\\User','[]','2021-09-11 18:51:31','2021-09-11 18:51:31'),(1159,'default','added',233,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-11 18:52:34','2021-09-11 18:52:34'),(1160,'default','added',234,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-11 18:55:24','2021-09-11 18:55:24'),(1161,'default','status_changed',348,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-11 18:55:44','2021-09-11 18:55:44'),(1162,'default','added',363,'App\\Contact',11,'App\\User','[]','2021-09-11 19:02:55','2021-09-11 19:02:55'),(1163,'default','added',364,'App\\Contact',4,'App\\User','[]','2021-09-11 19:28:15','2021-09-11 19:28:15'),(1164,'default','added',365,'App\\Contact',4,'App\\User','[]','2021-09-11 19:49:31','2021-09-11 19:49:31'),(1165,'default','added',235,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-09-11 19:53:13','2021-09-11 19:53:13'),(1166,'default','status_changed',331,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-11 19:53:38','2021-09-11 19:53:38'),(1167,'default','added',236,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-09-11 19:57:50','2021-09-11 19:57:50'),(1168,'default','status_changed',344,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-11 19:58:41','2021-09-11 19:58:41'),(1169,'default','added',366,'App\\Contact',4,'App\\User','[]','2021-09-11 20:22:35','2021-09-11 20:22:35'),(1170,'default','added',237,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-09-11 20:26:33','2021-09-11 20:26:33'),(1171,'default','added',238,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}','2021-09-11 20:28:58','2021-09-11 20:28:58'),(1172,'default','added',239,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-11 20:38:17','2021-09-11 20:38:17'),(1173,'default','status_changed',333,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Waiting for customer approve\"}','2021-09-11 21:14:17','2021-09-11 21:14:17'),(1174,'default','status_changed',357,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-11 21:24:36','2021-09-11 21:24:36'),(1175,'default','status_changed',361,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-11 21:24:49','2021-09-11 21:24:49'),(1176,'default','status_changed',356,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-11 21:25:21','2021-09-11 21:25:21'),(1177,'default','added',367,'App\\Contact',4,'App\\User','[]','2021-09-11 21:34:41','2021-09-11 21:34:41'),(1178,'default','added',368,'App\\Contact',4,'App\\User','[]','2021-09-11 21:55:49','2021-09-11 21:55:49'),(1179,'default','added',240,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3500}}','2021-09-11 22:02:08','2021-09-11 22:02:08'),(1180,'default','status_changed',364,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-11 22:02:23','2021-09-11 22:02:23'),(1181,'default','status_changed',357,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-11 22:33:23','2021-09-11 22:33:23'),(1182,'default','added',241,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}','2021-09-11 22:43:04','2021-09-11 22:43:04'),(1183,'default','status_changed',349,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-11 22:43:37','2021-09-11 22:43:37'),(1184,'default','status_changed',351,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-11 23:00:18','2021-09-11 23:00:18'),(1185,'default','added',369,'App\\Contact',4,'App\\User','[]','2021-09-11 23:18:57','2021-09-11 23:18:57'),(1186,'default','status_changed',346,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-11 23:27:55','2021-09-11 23:27:55'),(1187,'default','login',1,'App\\User',1,'App\\User','[]','2021-09-11 23:43:45','2021-09-11 23:43:45'),(1188,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-12 12:59:12','2021-09-12 12:59:12'),(1189,'default','added',370,'App\\Contact',4,'App\\User','[]','2021-09-12 12:59:47','2021-09-12 12:59:47'),(1190,'default','added',371,'App\\Contact',4,'App\\User','[]','2021-09-12 13:07:31','2021-09-12 13:07:31'),(1191,'default','added',242,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-12 13:11:19','2021-09-12 13:11:19'),(1192,'default','status_changed',322,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-12 13:12:32','2021-09-12 13:12:32'),(1193,'default','added',243,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}','2021-09-12 13:16:36','2021-09-12 13:16:36'),(1194,'default','added',372,'App\\Contact',4,'App\\User','[]','2021-09-12 13:51:01','2021-09-12 13:51:01'),(1195,'default','added',244,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-12 13:58:44','2021-09-12 13:58:44'),(1196,'default','status_changed',317,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-12 13:59:44','2021-09-12 13:59:44'),(1197,'default','status_changed',194,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-12 14:01:58','2021-09-12 14:01:58'),(1198,'default','status_changed',361,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-12 14:55:18','2021-09-12 14:55:18'),(1199,'default','status_changed',363,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-12 14:56:27','2021-09-12 14:56:27'),(1200,'default','status_changed',365,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-12 14:56:41','2021-09-12 14:56:41'),(1201,'default','status_changed',367,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-12 14:56:51','2021-09-12 14:56:51'),(1202,'default','status_changed',360,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-12 14:57:05','2021-09-12 14:57:05'),(1203,'default','status_changed',354,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-12 14:57:20','2021-09-12 14:57:20'),(1204,'default','status_changed',362,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-12 14:57:44','2021-09-12 14:57:44'),(1205,'default','status_changed',368,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-12 14:58:15','2021-09-12 14:58:15'),(1206,'default','status_changed',358,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-12 14:58:24','2021-09-12 14:58:24'),(1207,'default','status_changed',350,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-12 14:58:39','2021-09-12 14:58:39'),(1208,'default','status_changed',355,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-12 14:58:58','2021-09-12 14:58:58'),(1209,'default','status_changed',359,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-12 15:00:18','2021-09-12 15:00:18'),(1210,'default','added',373,'App\\Contact',4,'App\\User','[]','2021-09-12 15:05:57','2021-09-12 15:05:57'),(1211,'default','added',374,'App\\Contact',4,'App\\User','[]','2021-09-12 15:34:09','2021-09-12 15:34:09'),(1212,'default','added',375,'App\\Contact',4,'App\\User','[]','2021-09-12 16:01:28','2021-09-12 16:01:28'),(1213,'default','added',376,'App\\Contact',4,'App\\User','[]','2021-09-12 16:08:44','2021-09-12 16:08:44'),(1214,'default','added',377,'App\\Contact',4,'App\\User','[]','2021-09-12 16:15:12','2021-09-12 16:15:12'),(1215,'default','added',245,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1200}}','2021-09-12 16:31:35','2021-09-12 16:31:35'),(1216,'default','status_changed',290,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-12 16:32:02','2021-09-12 16:32:02'),(1217,'default','added',378,'App\\Contact',4,'App\\User','[]','2021-09-12 16:32:57','2021-09-12 16:32:57'),(1218,'default','status_changed',341,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-12 16:33:45','2021-09-12 16:33:45'),(1219,'default','status_changed',370,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-12 16:33:54','2021-09-12 16:33:54'),(1220,'default','status_changed',373,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-12 16:35:16','2021-09-12 16:35:16'),(1221,'default','added',246,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-09-12 16:53:21','2021-09-12 16:53:21'),(1222,'default','status_changed',350,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-12 16:58:00','2021-09-12 16:58:00'),(1223,'default','status_changed',327,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-12 16:58:24','2021-09-12 16:58:24'),(1224,'default','added',379,'App\\Contact',4,'App\\User','[]','2021-09-12 16:59:33','2021-09-12 16:59:33'),(1225,'default','added',247,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-12 17:16:45','2021-09-12 17:16:45'),(1226,'default','added',248,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-09-12 17:39:25','2021-09-12 17:39:25'),(1227,'default','added',249,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-12 17:44:56','2021-09-12 17:44:56'),(1228,'default','status_changed',372,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-12 17:45:10','2021-09-12 17:45:10'),(1229,'default','status_changed',341,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-12 17:45:30','2021-09-12 17:45:30'),(1230,'default','added',250,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-12 17:58:58','2021-09-12 17:58:58'),(1231,'default','status_changed',358,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-12 17:59:14','2021-09-12 17:59:14'),(1232,'default','added',251,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-12 18:09:28','2021-09-12 18:09:28'),(1233,'default','added',380,'App\\Contact',4,'App\\User','[]','2021-09-12 18:10:51','2021-09-12 18:10:51'),(1234,'default','added',381,'App\\Contact',4,'App\\User','[]','2021-09-12 18:26:13','2021-09-12 18:26:13'),(1235,'default','added',382,'App\\Contact',4,'App\\User','[]','2021-09-12 18:35:32','2021-09-12 18:35:32'),(1236,'default','added',383,'App\\Contact',4,'App\\User','[]','2021-09-12 18:39:58','2021-09-12 18:39:58'),(1237,'default','status_changed',332,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-12 19:09:48','2021-09-12 19:09:48'),(1238,'default','added',384,'App\\Contact',4,'App\\User','[]','2021-09-12 19:14:00','2021-09-12 19:14:00'),(1239,'default','added',385,'App\\Contact',4,'App\\User','[]','2021-09-12 19:23:17','2021-09-12 19:23:17'),(1240,'default','added',252,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}','2021-09-12 19:29:51','2021-09-12 19:29:51'),(1241,'default','status_changed',175,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-12 19:30:37','2021-09-12 19:30:37'),(1242,'default','added',253,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":125}}','2021-09-12 19:39:17','2021-09-12 19:39:17'),(1243,'default','status_changed',370,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-12 19:39:40','2021-09-12 19:39:40'),(1244,'default','added',386,'App\\Contact',4,'App\\User','[]','2021-09-12 19:50:57','2021-09-12 19:50:57'),(1245,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-12 20:03:12','2021-09-12 20:03:12'),(1246,'default','status_changed',371,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-12 20:03:47','2021-09-12 20:03:47'),(1247,'default','added',387,'App\\Contact',11,'App\\User','[]','2021-09-12 20:09:12','2021-09-12 20:09:12'),(1248,'default','added',388,'App\\Contact',11,'App\\User','[]','2021-09-12 20:23:54','2021-09-12 20:23:54'),(1249,'default','added',389,'App\\Contact',4,'App\\User','[]','2021-09-12 20:48:46','2021-09-12 20:48:46'),(1250,'default','added',390,'App\\Contact',4,'App\\User','[]','2021-09-12 21:05:26','2021-09-12 21:05:26'),(1251,'default','added',254,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-12 21:10:25','2021-09-12 21:10:25'),(1252,'default','status_changed',360,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-12 21:10:57','2021-09-12 21:10:57'),(1253,'default','added',255,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-09-12 21:18:08','2021-09-12 21:18:08'),(1254,'default','status_changed',367,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-12 21:18:59','2021-09-12 21:18:59'),(1255,'default','added',391,'App\\Contact',4,'App\\User','[]','2021-09-12 21:24:59','2021-09-12 21:24:59'),(1256,'default','added',392,'App\\Contact',4,'App\\User','[]','2021-09-12 21:37:42','2021-09-12 21:37:42'),(1257,'default','added',393,'App\\Contact',4,'App\\User','[]','2021-09-12 21:45:33','2021-09-12 21:45:33'),(1258,'default','added',394,'App\\Contact',4,'App\\User','[]','2021-09-12 21:47:08','2021-09-12 21:47:08'),(1259,'default','added',395,'App\\Contact',4,'App\\User','[]','2021-09-12 21:49:26','2021-09-12 21:49:26'),(1260,'default','added',396,'App\\Contact',4,'App\\User','[]','2021-09-12 21:51:01','2021-09-12 21:51:01'),(1261,'default','added',397,'App\\Contact',11,'App\\User','[]','2021-09-12 21:53:18','2021-09-12 21:53:18'),(1262,'default','added',256,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}','2021-09-12 21:55:48','2021-09-12 21:55:48'),(1263,'default','logout',4,'App\\User',4,'App\\User','[]','2021-09-12 21:56:01','2021-09-12 21:56:01'),(1264,'default','added',257,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-12 21:56:35','2021-09-12 21:56:35'),(1265,'default','status_changed',369,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-12 21:56:56','2021-09-12 21:56:56'),(1266,'default','added',398,'App\\Contact',11,'App\\User','[]','2021-09-12 21:59:24','2021-09-12 21:59:24'),(1267,'default','added',399,'App\\Contact',11,'App\\User','[]','2021-09-12 22:06:03','2021-09-12 22:06:03'),(1268,'default','added',258,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-09-12 22:09:21','2021-09-12 22:09:21'),(1269,'default','added',259,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-12 22:11:47','2021-09-12 22:11:47'),(1270,'default','status_changed',361,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-12 22:11:59','2021-09-12 22:11:59'),(1271,'default','added',260,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-09-12 22:12:32','2021-09-12 22:12:32'),(1272,'default','status_changed',374,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-12 22:12:50','2021-09-12 22:12:50'),(1273,'default','added',261,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-09-12 22:13:30','2021-09-12 22:13:30'),(1274,'default','added',262,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-12 22:14:04','2021-09-12 22:14:04'),(1275,'default','status_changed',376,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-12 22:14:38','2021-09-12 22:14:38'),(1276,'default','added',263,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-09-12 22:18:20','2021-09-12 22:18:20'),(1277,'default','status_changed',335,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-12 22:19:51','2021-09-12 22:19:51'),(1278,'default','added',264,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-09-12 22:31:25','2021-09-12 22:31:25'),(1279,'default','status_changed',363,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-12 22:32:22','2021-09-12 22:32:22'),(1280,'default','status_changed',385,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-12 22:35:04','2021-09-12 22:35:04'),(1281,'default','added',400,'App\\Contact',4,'App\\User','[]','2021-09-12 22:53:52','2021-09-12 22:53:52'),(1282,'default','login',1,'App\\User',1,'App\\User','[]','2021-09-12 23:29:00','2021-09-12 23:29:00'),(1283,'default','edited',6,'App\\User',1,'App\\User','[]','2021-09-13 01:15:34','2021-09-13 01:15:34'),(1284,'default','login',6,'App\\User',6,'App\\User','[]','2021-09-13 01:16:54','2021-09-13 01:16:54'),(1285,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-13 01:24:36','2021-09-13 01:24:36'),(1286,'default','logout',11,'App\\User',11,'App\\User','[]','2021-09-13 01:26:20','2021-09-13 01:26:20'),(1287,'default','added',401,'App\\Contact',1,'App\\User','[]','2021-09-13 01:30:09','2021-09-13 01:30:09'),(1288,'default','added',402,'App\\Contact',1,'App\\User','[]','2021-09-13 01:59:28','2021-09-13 01:59:28'),(1289,'default','edited',334,'App\\Contact',1,'App\\User','[]','2021-09-13 02:02:22','2021-09-13 02:02:22'),(1290,'default','status_changed',399,'Modules\\Repair\\Entities\\JobSheet',1,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-13 02:05:05','2021-09-13 02:05:05'),(1291,'default','added',265,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-13 02:05:31','2021-09-13 02:05:31'),(1292,'default','added',266,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":100}}','2021-09-13 02:09:04','2021-09-13 02:09:04'),(1293,'default','added',267,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-13 02:20:39','2021-09-13 02:20:39'),(1294,'default','added',268,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-13 02:23:38','2021-09-13 02:23:38'),(1295,'default','added',269,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}','2021-09-13 02:40:53','2021-09-13 02:40:53'),(1296,'default','added',270,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}','2021-09-13 02:43:02','2021-09-13 02:43:02'),(1297,'default','added',271,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}','2021-09-13 02:52:50','2021-09-13 02:52:50'),(1298,'default','added',272,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}','2021-09-13 02:57:16','2021-09-13 02:57:16'),(1299,'default','added',273,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}','2021-09-13 02:59:05','2021-09-13 02:59:05'),(1300,'default','added',274,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}','2021-09-13 03:00:35','2021-09-13 03:00:35'),(1301,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-13 12:16:01','2021-09-13 12:16:01'),(1302,'default','added',403,'App\\Contact',4,'App\\User','[]','2021-09-13 12:18:19','2021-09-13 12:18:19'),(1303,'default','added',404,'App\\Contact',4,'App\\User','[]','2021-09-13 12:57:17','2021-09-13 12:57:17'),(1304,'default','added',275,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-13 13:53:57','2021-09-13 13:53:57'),(1305,'default','status_changed',368,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-13 13:54:17','2021-09-13 13:54:17'),(1306,'default','added',276,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-09-13 14:10:11','2021-09-13 14:10:11'),(1307,'default','status_changed',371,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-13 14:10:36','2021-09-13 14:10:36'),(1308,'default','added',405,'App\\Contact',4,'App\\User','[]','2021-09-13 14:22:12','2021-09-13 14:22:12'),(1309,'default','added',406,'App\\Contact',4,'App\\User','[]','2021-09-13 14:38:00','2021-09-13 14:38:00'),(1310,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-13 15:06:04','2021-09-13 15:06:04'),(1311,'default','status_changed',403,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-13 15:08:03','2021-09-13 15:08:03'),(1312,'default','login',16,'App\\User',16,'App\\User','[]','2021-09-13 15:45:14','2021-09-13 15:45:14'),(1313,'default','edited',16,'App\\User',1,'App\\User','[]','2021-09-13 16:11:30','2021-09-13 16:11:30'),(1314,'default','added',20,'App\\User',1,'App\\User','[]','2021-09-13 16:13:10','2021-09-13 16:13:10'),(1315,'default','added',277,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}','2021-09-13 16:30:24','2021-09-13 16:30:24'),(1316,'default','added',278,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}','2021-09-13 16:36:04','2021-09-13 16:36:04'),(1317,'default','added',279,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}','2021-09-13 16:44:19','2021-09-13 16:44:19'),(1318,'default','added',280,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-13 16:56:28','2021-09-13 16:56:28'),(1319,'default','added',281,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":500}}','2021-09-13 17:06:08','2021-09-13 17:06:08'),(1320,'default','added',282,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}','2021-09-13 17:19:48','2021-09-13 17:19:48'),(1321,'default','added',283,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}','2021-09-13 17:21:17','2021-09-13 17:21:17'),(1322,'default','added',284,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}','2021-09-13 17:24:21','2021-09-13 17:24:21'),(1323,'default','added',285,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-13 17:26:18','2021-09-13 17:26:18'),(1324,'default','status_changed',354,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-13 17:26:39','2021-09-13 17:26:39'),(1325,'default','added',286,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}','2021-09-13 17:33:11','2021-09-13 17:33:11'),(1326,'default','added',287,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}','2021-09-13 17:56:27','2021-09-13 17:56:27'),(1327,'default','added',288,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-13 17:59:02','2021-09-13 17:59:02'),(1328,'default','status_changed',386,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-13 17:59:29','2021-09-13 17:59:29'),(1329,'default','added',407,'App\\Contact',4,'App\\User','[]','2021-09-13 18:08:38','2021-09-13 18:08:38'),(1330,'default','added',408,'App\\Contact',4,'App\\User','[]','2021-09-13 18:18:53','2021-09-13 18:18:53'),(1331,'default','added',409,'App\\Contact',4,'App\\User','[]','2021-09-13 18:23:15','2021-09-13 18:23:15'),(1332,'default','added',410,'App\\Contact',4,'App\\User','[]','2021-09-13 18:25:06','2021-09-13 18:25:06'),(1333,'default','added',289,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":125}}','2021-09-13 18:35:17','2021-09-13 18:35:17'),(1334,'default','status_changed',379,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-13 18:35:44','2021-09-13 18:35:44'),(1335,'default','added',290,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2300}}','2021-09-13 18:45:37','2021-09-13 18:45:37'),(1336,'default','status_changed',356,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-13 18:49:03','2021-09-13 18:49:03'),(1337,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-13 19:42:23','2021-09-13 19:42:23'),(1338,'default','added',411,'App\\Contact',4,'App\\User','[]','2021-09-13 19:42:57','2021-09-13 19:42:57'),(1339,'default','added',291,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-13 20:16:23','2021-09-13 20:16:23'),(1340,'default','status_changed',355,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-13 20:16:45','2021-09-13 20:16:45'),(1341,'default','added',292,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-13 20:18:10','2021-09-13 20:18:10'),(1342,'default','status_changed',359,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-13 20:18:30','2021-09-13 20:18:30'),(1343,'default','status_changed',330,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-13 20:21:17','2021-09-13 20:21:17'),(1344,'default','added',412,'App\\Contact',11,'App\\User','[]','2021-09-13 20:25:15','2021-09-13 20:25:15'),(1345,'default','added',413,'App\\Contact',11,'App\\User','[]','2021-09-13 20:27:26','2021-09-13 20:27:26'),(1346,'default','added',414,'App\\Contact',4,'App\\User','[]','2021-09-13 20:31:16','2021-09-13 20:31:16'),(1347,'default','added',293,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-13 20:35:09','2021-09-13 20:35:09'),(1348,'default','status_changed',377,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-13 20:35:37','2021-09-13 20:35:37'),(1349,'default','added',415,'App\\Contact',4,'App\\User','[]','2021-09-13 20:42:43','2021-09-13 20:42:43'),(1350,'default','status_changed',406,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-13 20:47:23','2021-09-13 20:47:23'),(1351,'default','added',294,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}','2021-09-13 21:02:02','2021-09-13 21:02:02'),(1352,'default','added',295,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-13 21:11:16','2021-09-13 21:11:16'),(1353,'default','status_changed',406,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-13 21:11:51','2021-09-13 21:11:51'),(1354,'default','status_changed',405,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-13 21:48:17','2021-09-13 21:48:17'),(1355,'default','added',296,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-09-13 21:59:15','2021-09-13 21:59:15'),(1356,'default','status_changed',402,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-13 21:59:42','2021-09-13 21:59:42'),(1357,'default','added',297,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-09-13 22:03:08','2021-09-13 22:03:08'),(1358,'default','added',298,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-09-13 22:03:56','2021-09-13 22:03:56'),(1359,'default','status_changed',405,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-13 22:05:15','2021-09-13 22:05:15'),(1360,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-13 22:38:37','2021-09-13 22:38:37'),(1361,'default','status_changed',384,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-13 22:39:05','2021-09-13 22:39:05'),(1362,'default','added',299,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}','2021-09-13 23:04:31','2021-09-13 23:04:31'),(1363,'default','added',300,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}','2021-09-13 23:06:54','2021-09-13 23:06:54'),(1364,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-14 12:38:47','2021-09-14 12:38:47'),(1365,'default','added',416,'App\\Contact',4,'App\\User','[]','2021-09-14 12:57:34','2021-09-14 12:57:34'),(1366,'default','status_changed',248,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 14:10:15','2021-09-14 14:10:15'),(1367,'default','status_changed',265,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 14:11:22','2021-09-14 14:11:22'),(1368,'default','status_changed',258,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 14:12:17','2021-09-14 14:12:17'),(1369,'default','status_changed',259,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 14:12:47','2021-09-14 14:12:47'),(1370,'default','status_changed',362,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 14:15:21','2021-09-14 14:15:21'),(1371,'default','status_changed',284,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 14:15:40','2021-09-14 14:15:40'),(1372,'default','status_changed',285,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 14:16:04','2021-09-14 14:16:04'),(1373,'default','status_changed',266,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 14:16:49','2021-09-14 14:16:49'),(1374,'default','status_changed',271,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 14:18:24','2021-09-14 14:18:24'),(1375,'default','status_changed',250,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 14:27:20','2021-09-14 14:27:20'),(1376,'default','status_changed',257,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 14:30:12','2021-09-14 14:30:12'),(1377,'default','status_changed',268,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 14:31:42','2021-09-14 14:31:42'),(1378,'default','status_changed',282,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 14:37:59','2021-09-14 14:37:59'),(1379,'default','status_changed',255,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 14:39:18','2021-09-14 14:39:18'),(1380,'default','status_changed',264,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 14:39:46','2021-09-14 14:39:46'),(1381,'default','status_changed',263,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 14:40:24','2021-09-14 14:40:24'),(1382,'default','status_changed',247,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 14:40:36','2021-09-14 14:40:36'),(1383,'default','added',301,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-09-14 14:43:55','2021-09-14 14:43:55'),(1384,'default','status_changed',337,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 14:44:16','2021-09-14 14:44:16'),(1385,'default','status_changed',256,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 14:54:10','2021-09-14 14:54:10'),(1386,'default','status_changed',392,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 14:55:12','2021-09-14 14:55:12'),(1387,'default','status_changed',272,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 14:55:39','2021-09-14 14:55:39'),(1388,'default','status_changed',404,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 15:01:59','2021-09-14 15:01:59'),(1389,'default','edited',11,'App\\User',4,'App\\User','[]','2021-09-14 15:04:25','2021-09-14 15:04:25'),(1390,'default','added',302,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1100}}','2021-09-14 15:15:38','2021-09-14 15:15:38'),(1391,'default','status_changed',183,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 15:18:01','2021-09-14 15:18:01'),(1392,'default','status_changed',233,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 15:18:25','2021-09-14 15:18:25'),(1393,'default','status_changed',270,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 15:20:42','2021-09-14 15:20:42'),(1394,'default','status_changed',283,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 15:20:54','2021-09-14 15:20:54'),(1395,'default','status_changed',286,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 15:21:13','2021-09-14 15:21:13'),(1396,'default','status_changed',347,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 15:27:58','2021-09-14 15:27:58'),(1397,'default','status_changed',340,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 15:29:33','2021-09-14 15:29:33'),(1398,'default','status_changed',350,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 15:31:03','2021-09-14 15:31:03'),(1399,'default','added',303,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2250}}','2021-09-14 16:05:51','2021-09-14 16:05:51'),(1400,'default','added',417,'App\\Contact',4,'App\\User','[]','2021-09-14 16:12:47','2021-09-14 16:12:47'),(1401,'default','added',418,'App\\Contact',4,'App\\User','[]','2021-09-14 16:17:04','2021-09-14 16:17:04'),(1402,'default','added',419,'App\\Contact',4,'App\\User','[]','2021-09-14 16:24:40','2021-09-14 16:24:40'),(1403,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-14 16:30:57','2021-09-14 16:30:57'),(1404,'default','added',420,'App\\Contact',4,'App\\User','[]','2021-09-14 17:19:42','2021-09-14 17:19:42'),(1405,'default','added',421,'App\\Contact',4,'App\\User','[]','2021-09-14 17:27:21','2021-09-14 17:27:21'),(1406,'default','added',422,'App\\Contact',4,'App\\User','[]','2021-09-14 17:47:57','2021-09-14 17:47:57'),(1407,'default','status_changed',375,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-14 18:18:38','2021-09-14 18:18:38'),(1408,'default','status_changed',415,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-14 18:18:51','2021-09-14 18:18:51'),(1409,'default','added',304,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-14 18:19:03','2021-09-14 18:19:03'),(1410,'default','status_changed',417,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-14 18:19:05','2021-09-14 18:19:05'),(1411,'default','status_changed',417,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-14 18:22:53','2021-09-14 18:22:53'),(1412,'default','status_changed',388,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-14 18:24:27','2021-09-14 18:24:27'),(1413,'default','status_changed',409,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-14 18:24:42','2021-09-14 18:24:42'),(1414,'default','status_changed',414,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 18:24:53','2021-09-14 18:24:53'),(1415,'default','status_changed',412,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-14 18:25:02','2021-09-14 18:25:02'),(1416,'default','status_changed',419,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-14 18:25:14','2021-09-14 18:25:14'),(1417,'default','status_changed',408,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-14 18:27:30','2021-09-14 18:27:30'),(1418,'default','status_changed',366,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 18:31:28','2021-09-14 18:31:28'),(1419,'default','status_changed',329,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-14 18:31:52','2021-09-14 18:31:52'),(1420,'default','status_changed',410,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-14 18:32:06','2021-09-14 18:32:06'),(1421,'default','status_changed',387,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-14 18:32:14','2021-09-14 18:32:14'),(1422,'default','login',19,'App\\User',19,'App\\User','[]','2021-09-14 18:39:19','2021-09-14 18:39:19'),(1423,'default','added',305,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}','2021-09-14 19:01:35','2021-09-14 19:01:35'),(1424,'default','status_changed',395,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 19:01:48','2021-09-14 19:01:48'),(1425,'default','added',306,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}','2021-09-14 19:11:34','2021-09-14 19:11:34'),(1426,'default','status_changed',334,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 19:11:51','2021-09-14 19:11:51'),(1427,'default','added',423,'App\\Contact',4,'App\\User','[]','2021-09-14 19:16:56','2021-09-14 19:16:56'),(1428,'default','added',424,'App\\Contact',4,'App\\User','[]','2021-09-14 19:21:57','2021-09-14 19:21:57'),(1429,'default','status_changed',187,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 19:28:28','2021-09-14 19:28:28'),(1430,'default','added',425,'App\\Contact',4,'App\\User','[]','2021-09-14 19:32:43','2021-09-14 19:32:43'),(1431,'default','added',426,'App\\Contact',19,'App\\User','[]','2021-09-14 19:33:19','2021-09-14 19:33:19'),(1432,'default','added',307,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-14 19:51:04','2021-09-14 19:51:04'),(1433,'default','status_changed',390,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 19:51:20','2021-09-14 19:51:20'),(1434,'default','added',427,'App\\Contact',4,'App\\User','[]','2021-09-14 19:56:05','2021-09-14 19:56:05'),(1435,'default','added',308,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-14 20:04:04','2021-09-14 20:04:04'),(1436,'default','status_changed',417,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 20:04:35','2021-09-14 20:04:35'),(1437,'default','status_changed',422,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-14 20:11:40','2021-09-14 20:11:40'),(1438,'default','status_changed',423,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-14 20:11:56','2021-09-14 20:11:56'),(1439,'default','status_changed',420,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-14 20:12:02','2021-09-14 20:12:02'),(1440,'default','status_changed',421,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-14 20:12:09','2021-09-14 20:12:09'),(1441,'default','added',309,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-09-14 20:27:59','2021-09-14 20:27:59'),(1442,'default','status_changed',412,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 20:28:26','2021-09-14 20:28:26'),(1443,'default','added',428,'App\\Contact',4,'App\\User','[]','2021-09-14 20:28:59','2021-09-14 20:28:59'),(1444,'default','added',429,'App\\Contact',4,'App\\User','[]','2021-09-14 20:32:37','2021-09-14 20:32:37'),(1445,'default','added',310,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-09-14 20:45:00','2021-09-14 20:45:00'),(1446,'default','status_changed',410,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 20:45:20','2021-09-14 20:45:20'),(1447,'default','logout',19,'App\\User',19,'App\\User','[]','2021-09-14 20:56:27','2021-09-14 20:56:27'),(1448,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-14 20:56:36','2021-09-14 20:56:36'),(1449,'default','added',430,'App\\Contact',11,'App\\User','[]','2021-09-14 20:57:37','2021-09-14 20:57:37'),(1450,'default','added',431,'App\\Contact',4,'App\\User','[]','2021-09-14 21:01:05','2021-09-14 21:01:05'),(1451,'default','added',311,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-14 21:15:18','2021-09-14 21:15:18'),(1452,'default','added',312,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-09-14 21:22:58','2021-09-14 21:22:58'),(1453,'default','status_changed',384,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 21:23:45','2021-09-14 21:23:45'),(1454,'default','added',313,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-14 21:28:44','2021-09-14 21:28:44'),(1455,'default','status_changed',401,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 21:29:01','2021-09-14 21:29:01'),(1456,'default','added',314,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-14 21:29:26','2021-09-14 21:29:26'),(1457,'default','status_changed',416,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 21:29:44','2021-09-14 21:29:44'),(1458,'default','added',432,'App\\Contact',11,'App\\User','[]','2021-09-14 21:39:57','2021-09-14 21:39:57'),(1459,'default','added',315,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-14 21:41:13','2021-09-14 21:41:13'),(1460,'default','status_changed',413,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 21:42:44','2021-09-14 21:42:44'),(1461,'default','added',433,'App\\Contact',4,'App\\User','[]','2021-09-14 21:50:39','2021-09-14 21:50:39'),(1462,'default','added',434,'App\\Contact',4,'App\\User','[]','2021-09-14 22:03:31','2021-09-14 22:03:31'),(1463,'default','added',435,'App\\Contact',4,'App\\User','[]','2021-09-14 22:07:01','2021-09-14 22:07:01'),(1464,'default','added',316,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":650}}','2021-09-14 22:19:17','2021-09-14 22:19:17'),(1465,'default','added',436,'App\\Contact',11,'App\\User','[]','2021-09-14 22:26:43','2021-09-14 22:26:43'),(1466,'default','added',437,'App\\Contact',4,'App\\User','[]','2021-09-14 22:35:29','2021-09-14 22:35:29'),(1467,'default','added',317,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-09-14 22:43:37','2021-09-14 22:43:37'),(1468,'default','status_changed',365,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 22:43:54','2021-09-14 22:43:54'),(1469,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-15 13:11:08','2021-09-15 13:11:08'),(1470,'default','added',318,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}','2021-09-15 13:52:49','2021-09-15 13:52:49'),(1471,'default','status_changed',353,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-15 13:53:52','2021-09-15 13:53:52'),(1472,'default','added',438,'App\\Contact',11,'App\\User','[]','2021-09-15 14:20:12','2021-09-15 14:20:12'),(1473,'default','logout',11,'App\\User',11,'App\\User','[]','2021-09-15 14:39:06','2021-09-15 14:39:06'),(1474,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-15 14:40:42','2021-09-15 14:40:42'),(1475,'default','added',319,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-09-15 14:44:42','2021-09-15 14:44:42'),(1476,'default','status_changed',339,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-15 14:45:10','2021-09-15 14:45:10'),(1477,'default','status_changed',433,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-15 15:01:31','2021-09-15 15:01:31'),(1478,'default','status_changed',431,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-15 15:01:39','2021-09-15 15:01:39'),(1479,'default','status_changed',429,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-15 15:01:51','2021-09-15 15:01:51'),(1480,'default','status_changed',427,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-15 15:02:12','2021-09-15 15:02:12'),(1481,'default','status_changed',435,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-15 15:02:23','2021-09-15 15:02:23'),(1482,'default','status_changed',434,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-15 15:02:31','2021-09-15 15:02:31'),(1483,'default','status_changed',430,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-15 15:02:40','2021-09-15 15:02:40'),(1484,'default','status_changed',428,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-15 15:02:48','2021-09-15 15:02:48'),(1485,'default','status_changed',424,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-15 15:02:56','2021-09-15 15:02:56'),(1486,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-15 15:11:58','2021-09-15 15:11:58'),(1487,'default','added',439,'App\\Contact',4,'App\\User','[]','2021-09-15 15:23:32','2021-09-15 15:23:32'),(1488,'default','status_changed',392,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-15 15:40:44','2021-09-15 15:40:44'),(1489,'default','added',320,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-09-15 16:54:41','2021-09-15 16:54:41'),(1490,'default','status_changed',224,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-15 16:55:17','2021-09-15 16:55:17'),(1491,'default','added',440,'App\\Contact',4,'App\\User','[]','2021-09-15 17:05:58','2021-09-15 17:05:58'),(1492,'default','added',441,'App\\Contact',4,'App\\User','[]','2021-09-15 17:23:59','2021-09-15 17:23:59'),(1493,'default','added',442,'App\\Contact',4,'App\\User','[]','2021-09-15 17:36:53','2021-09-15 17:36:53'),(1494,'default','status_changed',432,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-15 18:04:13','2021-09-15 18:04:13'),(1495,'default','status_changed',437,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-15 18:04:21','2021-09-15 18:04:21'),(1496,'default','status_changed',438,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-15 18:04:28','2021-09-15 18:04:28'),(1497,'default','status_changed',439,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-15 18:04:36','2021-09-15 18:04:36'),(1498,'default','status_changed',436,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-15 18:04:48','2021-09-15 18:04:48'),(1499,'default','added',321,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-15 19:10:21','2021-09-15 19:10:21'),(1500,'default','status_changed',387,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-15 19:10:44','2021-09-15 19:10:44'),(1501,'default','added',443,'App\\Contact',4,'App\\User','[]','2021-09-15 19:32:02','2021-09-15 19:32:02'),(1502,'default','added',444,'App\\Contact',4,'App\\User','[]','2021-09-15 19:50:40','2021-09-15 19:50:40'),(1503,'default','status_changed',440,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-15 19:58:41','2021-09-15 19:58:41'),(1504,'default','status_changed',441,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-15 19:58:49','2021-09-15 19:58:49'),(1505,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-15 20:04:28','2021-09-15 20:04:28'),(1506,'default','added',445,'App\\Contact',4,'App\\User','[]','2021-09-15 20:04:54','2021-09-15 20:04:54'),(1507,'default','added',446,'App\\Contact',4,'App\\User','[]','2021-09-15 20:05:08','2021-09-15 20:05:08'),(1508,'default','added',447,'App\\Contact',4,'App\\User','[]','2021-09-15 20:12:14','2021-09-15 20:12:14'),(1509,'default','added',448,'App\\Contact',4,'App\\User','[]','2021-09-15 20:12:31','2021-09-15 20:12:31'),(1510,'default','added',449,'App\\Contact',4,'App\\User','[]','2021-09-15 20:15:16','2021-09-15 20:15:16'),(1511,'default','added',322,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-15 20:38:54','2021-09-15 20:38:54'),(1512,'default','added',323,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-15 20:40:31','2021-09-15 20:40:31'),(1513,'default','added',324,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-15 20:42:26','2021-09-15 20:42:26'),(1514,'default','status_changed',435,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-15 20:43:19','2021-09-15 20:43:19'),(1515,'default','added',325,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-15 20:43:44','2021-09-15 20:43:44'),(1516,'default','status_changed',426,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-15 20:44:26','2021-09-15 20:44:26'),(1517,'default','added',326,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-09-15 20:55:29','2021-09-15 20:55:29'),(1518,'default','status_changed',434,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-15 20:56:29','2021-09-15 20:56:29'),(1519,'default','added',327,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-15 21:02:18','2021-09-15 21:02:18'),(1520,'default','added',450,'App\\Contact',4,'App\\User','[]','2021-09-15 21:08:28','2021-09-15 21:08:28'),(1521,'default','added',328,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-15 21:18:07','2021-09-15 21:18:07'),(1522,'default','added',451,'App\\Contact',4,'App\\User','[]','2021-09-15 21:30:03','2021-09-15 21:30:03'),(1523,'default','status_changed',448,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-15 21:52:07','2021-09-15 21:52:07'),(1524,'default','added',452,'App\\Contact',4,'App\\User','[]','2021-09-15 21:58:28','2021-09-15 21:58:28'),(1525,'default','status_changed',447,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-15 22:01:40','2021-09-15 22:01:40'),(1526,'default','added',453,'App\\Contact',4,'App\\User','[]','2021-09-15 22:05:32','2021-09-15 22:05:32'),(1527,'default','added',329,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-15 22:07:25','2021-09-15 22:07:25'),(1528,'default','status_changed',450,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-15 22:07:43','2021-09-15 22:07:43'),(1529,'default','added',330,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-09-15 22:10:48','2021-09-15 22:10:48'),(1530,'default','added',331,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-15 22:11:51','2021-09-15 22:11:51'),(1531,'default','status_changed',447,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-15 22:13:10','2021-09-15 22:13:10'),(1532,'default','added',332,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-15 22:37:29','2021-09-15 22:37:29'),(1533,'default','status_changed',448,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-15 22:37:43','2021-09-15 22:37:43'),(1534,'default','added',333,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-15 22:55:23','2021-09-15 22:55:23'),(1535,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-16 12:08:09','2021-09-16 12:08:09'),(1536,'default','added',334,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-16 12:48:36','2021-09-16 12:48:36'),(1537,'default','status_changed',389,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-16 12:54:31','2021-09-16 12:54:31'),(1538,'default','status_changed',389,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-16 12:54:37','2021-09-16 12:54:37'),(1539,'default','status_changed',388,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-16 13:03:45','2021-09-16 13:03:45'),(1540,'default','added',454,'App\\Contact',11,'App\\User','[]','2021-09-16 13:17:51','2021-09-16 13:17:51'),(1541,'default','added',455,'App\\Contact',11,'App\\User','[]','2021-09-16 13:18:55','2021-09-16 13:18:55'),(1542,'default','added',456,'App\\Contact',11,'App\\User','[]','2021-09-16 13:19:58','2021-09-16 13:19:58'),(1543,'default','added',335,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}','2021-09-16 14:49:18','2021-09-16 14:49:18'),(1544,'default','added',336,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-16 14:50:32','2021-09-16 14:50:32'),(1545,'default','status_changed',332,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-16 14:50:57','2021-09-16 14:50:57'),(1546,'default','login',1,'App\\User',1,'App\\User','[]','2021-09-16 16:00:10','2021-09-16 16:00:10'),(1547,'default','added',337,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-16 16:01:43','2021-09-16 16:01:43'),(1548,'default','status_changed',423,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-16 16:02:05','2021-09-16 16:02:05'),(1549,'default','logout',1,'App\\User',1,'App\\User','[]','2021-09-16 16:19:19','2021-09-16 16:19:19'),(1550,'default','login',1,'App\\User',1,'App\\User','[]','2021-09-16 16:44:47','2021-09-16 16:44:47'),(1551,'default','added',457,'App\\Contact',11,'App\\User','[]','2021-09-16 16:59:16','2021-09-16 16:59:16'),(1552,'default','added',338,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2800}}','2021-09-16 17:05:27','2021-09-16 17:05:27'),(1553,'default','logout',1,'App\\User',1,'App\\User','[]','2021-09-16 17:12:51','2021-09-16 17:12:51'),(1554,'default','login',1,'App\\User',1,'App\\User','[]','2021-09-16 17:14:10','2021-09-16 17:14:10'),(1555,'default','added',339,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-09-16 17:34:41','2021-09-16 17:34:41'),(1556,'default','edited',4,'App\\User',1,'App\\User','[]','2021-09-16 17:51:26','2021-09-16 17:51:26'),(1557,'default','logout',1,'App\\User',1,'App\\User','[]','2021-09-16 17:51:44','2021-09-16 17:51:44'),(1558,'default','added',458,'App\\Contact',11,'App\\User','[]','2021-09-16 17:52:17','2021-09-16 17:52:17'),(1559,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-16 17:52:22','2021-09-16 17:52:22'),(1560,'default','status_changed',419,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-16 17:56:02','2021-09-16 17:56:02'),(1561,'default','login',1,'App\\User',1,'App\\User','[]','2021-09-16 18:39:59','2021-09-16 18:39:59'),(1562,'default','edited',3,'App\\User',1,'App\\User','[]','2021-09-16 18:40:42','2021-09-16 18:40:42'),(1563,'default','login',1,'App\\User',1,'App\\User','[]','2021-09-16 18:43:03','2021-09-16 18:43:03'),(1564,'default','added',340,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":650}}','2021-09-16 19:38:22','2021-09-16 19:38:22'),(1565,'default','status_changed',433,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-16 19:38:45','2021-09-16 19:38:45'),(1566,'default','added',459,'App\\Contact',11,'App\\User','[]','2021-09-16 19:39:09','2021-09-16 19:39:09'),(1567,'default','logout',11,'App\\User',11,'App\\User','[]','2021-09-16 20:07:45','2021-09-16 20:07:45'),(1568,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-16 20:08:02','2021-09-16 20:08:02'),(1569,'default','logout',1,'App\\User',1,'App\\User','[]','2021-09-16 20:08:04','2021-09-16 20:08:04'),(1570,'default','logout',4,'App\\User',4,'App\\User','[]','2021-09-16 20:08:27','2021-09-16 20:08:27'),(1571,'default','login',1,'App\\User',1,'App\\User','[]','2021-09-16 20:08:30','2021-09-16 20:08:30'),(1572,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-16 20:08:38','2021-09-16 20:08:38'),(1573,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-16 20:08:42','2021-09-16 20:08:42'),(1574,'default','logout',1,'App\\User',1,'App\\User','[]','2021-09-16 20:20:51','2021-09-16 20:20:51'),(1575,'default','added',460,'App\\Contact',11,'App\\User','[]','2021-09-16 20:21:13','2021-09-16 20:21:13'),(1576,'default','logout',1,'App\\User',1,'App\\User','[]','2021-09-16 20:24:57','2021-09-16 20:24:57'),(1577,'default','added',341,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-09-16 20:35:07','2021-09-16 20:35:07'),(1578,'default','login',1,'App\\User',1,'App\\User','[]','2021-09-16 20:36:14','2021-09-16 20:36:14'),(1579,'default','status_changed',396,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-16 20:36:54','2021-09-16 20:36:54'),(1580,'default','logout',4,'App\\User',4,'App\\User','[]','2021-09-16 20:37:00','2021-09-16 20:37:00'),(1581,'default','login',1,'App\\User',1,'App\\User','[]','2021-09-16 20:37:41','2021-09-16 20:37:41'),(1582,'default','logout',1,'App\\User',1,'App\\User','[]','2021-09-16 20:38:06','2021-09-16 20:38:06'),(1583,'default','login',1,'App\\User',1,'App\\User','[]','2021-09-16 20:40:56','2021-09-16 20:40:56'),(1584,'default','added',342,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}','2021-09-16 20:42:49','2021-09-16 20:42:49'),(1585,'default','status_changed',458,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-16 20:54:46','2021-09-16 20:54:46'),(1586,'default','login',1,'App\\User',1,'App\\User','[]','2021-09-16 20:56:59','2021-09-16 20:56:59'),(1587,'default','status_changed',445,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-09-16 20:57:23','2021-09-16 20:57:23'),(1588,'default','status_changed',458,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-09-16 20:57:32','2021-09-16 20:57:32'),(1589,'default','added',343,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-09-16 21:01:54','2021-09-16 21:01:54'),(1590,'default','added',344,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-09-16 21:02:31','2021-09-16 21:02:31'),(1591,'default','added',345,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}','2021-09-16 21:03:14','2021-09-16 21:03:14'),(1592,'default','status_changed',444,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-16 21:03:45','2021-09-16 21:03:45'),(1593,'default','status_changed',446,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-16 21:03:55','2021-09-16 21:03:55'),(1594,'default','status_changed',429,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-16 21:07:46','2021-09-16 21:07:46'),(1595,'default','added',346,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-16 21:11:48','2021-09-16 21:11:48'),(1596,'default','added',347,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}','2021-09-16 21:27:41','2021-09-16 21:27:41'),(1597,'default','logout',1,'App\\User',1,'App\\User','[]','2021-09-16 21:29:04','2021-09-16 21:29:04'),(1598,'default','login',1,'App\\User',1,'App\\User','[]','2021-09-16 21:29:13','2021-09-16 21:29:13'),(1599,'default','logout',1,'App\\User',1,'App\\User','[]','2021-09-16 21:35:01','2021-09-16 21:35:01'),(1600,'default','login',1,'App\\User',1,'App\\User','[]','2021-09-16 21:35:08','2021-09-16 21:35:08'),(1601,'default','added',461,'App\\Contact',4,'App\\User','[]','2021-09-16 21:41:18','2021-09-16 21:41:18'),(1602,'default','added',462,'App\\Contact',4,'App\\User','[]','2021-09-16 22:02:32','2021-09-16 22:02:32'),(1603,'default','added',348,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-09-16 22:04:02','2021-09-16 22:04:02'),(1604,'default','status_changed',415,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-16 22:04:18','2021-09-16 22:04:18'),(1605,'default','added',463,'App\\Contact',4,'App\\User','[]','2021-09-16 22:06:08','2021-09-16 22:06:08'),(1606,'default','added',349,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-16 22:08:44','2021-09-16 22:08:44'),(1607,'default','logout',1,'App\\User',1,'App\\User','[]','2021-09-16 22:11:29','2021-09-16 22:11:29'),(1608,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-16 22:12:00','2021-09-16 22:12:00'),(1609,'default','added',350,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-16 22:17:04','2021-09-16 22:17:04'),(1610,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-16 22:48:28','2021-09-16 22:48:28'),(1611,'default','added',351,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-09-16 23:07:38','2021-09-16 23:07:38'),(1612,'default','logout',4,'App\\User',4,'App\\User','[]','2021-09-16 23:08:57','2021-09-16 23:08:57'),(1613,'default','status_changed',326,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-16 23:09:14','2021-09-16 23:09:14'),(1614,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-16 23:10:13','2021-09-16 23:10:13'),(1615,'default','logout',4,'App\\User',4,'App\\User','[]','2021-09-16 23:10:24','2021-09-16 23:10:24'),(1616,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-16 23:11:23','2021-09-16 23:11:23'),(1617,'default','logout',4,'App\\User',4,'App\\User','[]','2021-09-16 23:14:45','2021-09-16 23:14:45'),(1618,'default','logout',1,'App\\User',1,'App\\User','[]','2021-09-17 00:25:33','2021-09-17 00:25:33'),(1619,'default','login',1,'App\\User',1,'App\\User','[]','2021-09-17 00:30:46','2021-09-17 00:30:46'),(1620,'default','login',20,'App\\User',20,'App\\User','[]','2021-09-17 13:21:54','2021-09-17 13:21:54'),(1621,'default','logout',20,'App\\User',20,'App\\User','[]','2021-09-17 13:23:30','2021-09-17 13:23:30'),(1622,'default','login',20,'App\\User',20,'App\\User','[]','2021-09-17 13:23:54','2021-09-17 13:23:54'),(1623,'default','logout',20,'App\\User',20,'App\\User','[]','2021-09-17 13:25:57','2021-09-17 13:25:57'),(1624,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-17 13:26:08','2021-09-17 13:26:08'),(1625,'default','added',464,'App\\Contact',4,'App\\User','[]','2021-09-17 13:27:00','2021-09-17 13:27:00'),(1626,'default','login',1,'App\\User',1,'App\\User','[]','2021-09-17 13:53:42','2021-09-17 13:53:42'),(1627,'default','edited',20,'App\\User',1,'App\\User','[]','2021-09-17 14:02:33','2021-09-17 14:02:33'),(1628,'default','added',465,'App\\Contact',4,'App\\User','[]','2021-09-17 16:02:25','2021-09-17 16:02:25'),(1629,'default','added',466,'App\\Contact',4,'App\\User','[]','2021-09-17 16:17:46','2021-09-17 16:17:46'),(1630,'default','added',467,'App\\Contact',4,'App\\User','[]','2021-09-17 17:48:17','2021-09-17 17:48:17'),(1631,'default','added',468,'App\\Contact',4,'App\\User','[]','2021-09-17 17:48:45','2021-09-17 17:48:45'),(1632,'default','added',469,'App\\Contact',4,'App\\User','[]','2021-09-17 18:05:21','2021-09-17 18:05:21'),(1633,'default','added',470,'App\\Contact',4,'App\\User','[]','2021-09-17 18:11:50','2021-09-17 18:11:50'),(1634,'default','status_changed',464,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-17 18:19:13','2021-09-17 18:19:13'),(1635,'default','added',352,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-17 18:19:27','2021-09-17 18:19:27'),(1636,'default','status_changed',464,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-17 18:21:17','2021-09-17 18:21:17'),(1637,'default','added',471,'App\\Contact',4,'App\\User','[]','2021-09-17 19:11:28','2021-09-17 19:11:28'),(1638,'default','added',353,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-09-17 19:14:24','2021-09-17 19:14:24'),(1639,'default','status_changed',467,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-17 19:15:01','2021-09-17 19:15:01'),(1640,'default','login',20,'App\\User',20,'App\\User','[]','2021-09-17 20:18:22','2021-09-17 20:18:22'),(1641,'default','added',472,'App\\Contact',20,'App\\User','[]','2021-09-17 20:18:53','2021-09-17 20:18:53'),(1642,'default','login',20,'App\\User',20,'App\\User','[]','2021-09-17 20:34:46','2021-09-17 20:34:46'),(1643,'default','added',473,'App\\Contact',20,'App\\User','[]','2021-09-17 22:34:58','2021-09-17 22:34:58'),(1644,'default','added',474,'App\\Contact',20,'App\\User','[]','2021-09-17 22:53:23','2021-09-17 22:53:23'),(1645,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-18 13:14:43','2021-09-18 13:14:43'),(1646,'default','added',475,'App\\Contact',11,'App\\User','[]','2021-09-18 13:36:41','2021-09-18 13:36:41'),(1647,'default','added',476,'App\\Contact',11,'App\\User','[]','2021-09-18 14:15:04','2021-09-18 14:15:04'),(1648,'default','added',477,'App\\Contact',11,'App\\User','[]','2021-09-18 14:17:18','2021-09-18 14:17:18'),(1649,'default','added',478,'App\\Contact',11,'App\\User','[]','2021-09-18 14:19:16','2021-09-18 14:19:16'),(1650,'default','added',479,'App\\Contact',11,'App\\User','[]','2021-09-18 14:22:28','2021-09-18 14:22:28'),(1651,'default','added',480,'App\\Contact',11,'App\\User','[]','2021-09-18 14:24:57','2021-09-18 14:24:57'),(1652,'default','added',481,'App\\Contact',11,'App\\User','[]','2021-09-18 14:27:59','2021-09-18 14:27:59'),(1653,'default','added',482,'App\\Contact',11,'App\\User','[]','2021-09-18 16:04:29','2021-09-18 16:04:29'),(1654,'default','added',354,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-09-18 16:09:17','2021-09-18 16:09:17'),(1655,'default','status_changed',427,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-18 16:10:11','2021-09-18 16:10:11'),(1656,'default','added',483,'App\\Contact',11,'App\\User','[]','2021-09-18 16:12:59','2021-09-18 16:12:59'),(1657,'default','added',484,'App\\Contact',11,'App\\User','[]','2021-09-18 16:15:38','2021-09-18 16:15:38'),(1658,'default','added',355,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}','2021-09-18 16:24:08','2021-09-18 16:24:08'),(1659,'default','added',485,'App\\Contact',11,'App\\User','[]','2021-09-18 16:30:32','2021-09-18 16:30:32'),(1660,'default','added',356,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-18 16:32:12','2021-09-18 16:32:12'),(1661,'default','added',486,'App\\Contact',11,'App\\User','[]','2021-09-18 16:49:58','2021-09-18 16:49:58'),(1662,'default','added',357,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-18 18:30:37','2021-09-18 18:30:37'),(1663,'default','added',487,'App\\Contact',11,'App\\User','[]','2021-09-18 19:03:24','2021-09-18 19:03:24'),(1664,'default','added',488,'App\\Contact',11,'App\\User','[]','2021-09-18 19:55:38','2021-09-18 19:55:38'),(1665,'default','added',489,'App\\Contact',11,'App\\User','[]','2021-09-18 20:00:32','2021-09-18 20:00:32'),(1666,'default','added',490,'App\\Contact',11,'App\\User','[]','2021-09-18 20:33:09','2021-09-18 20:33:09'),(1667,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-18 20:55:37','2021-09-18 20:55:37'),(1668,'default','added',491,'App\\Contact',11,'App\\User','[]','2021-09-18 21:07:44','2021-09-18 21:07:44'),(1669,'default','added',358,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}','2021-09-18 21:25:50','2021-09-18 21:25:50'),(1670,'default','added',492,'App\\Contact',11,'App\\User','[]','2021-09-18 21:36:04','2021-09-18 21:36:04'),(1671,'default','added',493,'App\\Contact',11,'App\\User','[]','2021-09-18 21:37:00','2021-09-18 21:37:00'),(1672,'default','added',359,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-09-18 21:41:44','2021-09-18 21:41:44'),(1673,'default','added',494,'App\\Contact',11,'App\\User','[]','2021-09-18 21:51:06','2021-09-18 21:51:06'),(1674,'default','added',495,'App\\Contact',11,'App\\User','[]','2021-09-18 21:55:25','2021-09-18 21:55:25'),(1675,'default','added',496,'App\\Contact',11,'App\\User','[]','2021-09-18 22:38:08','2021-09-18 22:38:08'),(1676,'default','added',497,'App\\Contact',11,'App\\User','[]','2021-09-18 22:42:36','2021-09-18 22:42:36'),(1677,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-19 14:04:18','2021-09-19 14:04:18'),(1678,'default','added',498,'App\\Contact',11,'App\\User','[]','2021-09-19 14:05:01','2021-09-19 14:05:01'),(1679,'default','added',499,'App\\Contact',11,'App\\User','[]','2021-09-19 14:11:43','2021-09-19 14:11:43'),(1680,'default','added',500,'App\\Contact',11,'App\\User','[]','2021-09-19 14:13:38','2021-09-19 14:13:38'),(1681,'default','added',501,'App\\Contact',11,'App\\User','[]','2021-09-19 16:10:29','2021-09-19 16:10:29'),(1682,'default','added',360,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-09-19 16:39:10','2021-09-19 16:39:10'),(1683,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-19 16:40:27','2021-09-19 16:40:27'),(1684,'default','status_changed',486,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-19 16:43:49','2021-09-19 16:43:49'),(1685,'default','status_changed',472,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-19 16:44:01','2021-09-19 16:44:01'),(1686,'default','added',502,'App\\Contact',11,'App\\User','[]','2021-09-19 17:17:43','2021-09-19 17:17:43'),(1687,'default','added',503,'App\\Contact',11,'App\\User','[]','2021-09-19 17:46:32','2021-09-19 17:46:32'),(1688,'default','added',504,'App\\Contact',11,'App\\User','[]','2021-09-19 17:55:12','2021-09-19 17:55:12'),(1689,'default','added',505,'App\\Contact',11,'App\\User','[]','2021-09-19 18:26:03','2021-09-19 18:26:03'),(1690,'default','logout',11,'App\\User',11,'App\\User','[]','2021-09-19 18:32:05','2021-09-19 18:32:05'),(1691,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-19 18:32:16','2021-09-19 18:32:16'),(1692,'default','status_changed',490,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-19 18:33:33','2021-09-19 18:33:33'),(1693,'default','added',506,'App\\Contact',4,'App\\User','[]','2021-09-19 18:49:18','2021-09-19 18:49:18'),(1694,'default','added',361,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-19 19:14:51','2021-09-19 19:14:51'),(1695,'default','status_changed',477,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-19 19:16:00','2021-09-19 19:16:00'),(1696,'default','added',507,'App\\Contact',4,'App\\User','[]','2021-09-19 19:40:43','2021-09-19 19:40:43'),(1697,'default','added',508,'App\\Contact',4,'App\\User','[]','2021-09-19 19:52:02','2021-09-19 19:52:02'),(1698,'default','added',509,'App\\Contact',4,'App\\User','[]','2021-09-19 19:59:01','2021-09-19 19:59:01'),(1699,'default','added',510,'App\\Contact',4,'App\\User','[]','2021-09-19 20:02:18','2021-09-19 20:02:18'),(1700,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-19 20:08:01','2021-09-19 20:08:01'),(1701,'default','added',511,'App\\Contact',4,'App\\User','[]','2021-09-19 20:10:00','2021-09-19 20:10:00'),(1702,'default','added',512,'App\\Contact',4,'App\\User','[]','2021-09-19 20:43:17','2021-09-19 20:43:17'),(1703,'default','added',362,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-19 21:21:40','2021-09-19 21:21:40'),(1704,'default','status_changed',473,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-19 21:22:45','2021-09-19 21:22:45'),(1705,'default','added',513,'App\\Contact',4,'App\\User','[]','2021-09-19 21:42:09','2021-09-19 21:42:09'),(1706,'default','added',514,'App\\Contact',4,'App\\User','[]','2021-09-19 21:44:08','2021-09-19 21:44:08'),(1707,'default','added',515,'App\\Contact',4,'App\\User','[]','2021-09-19 21:45:37','2021-09-19 21:45:37'),(1708,'default','added',516,'App\\Contact',4,'App\\User','[]','2021-09-19 21:46:41','2021-09-19 21:46:41'),(1709,'default','status_changed',35,'App\\Transaction',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-19 22:01:38','2021-09-19 22:01:38'),(1710,'default','added',517,'App\\Contact',4,'App\\User','[]','2021-09-19 22:02:30','2021-09-19 22:02:30'),(1711,'default','added',363,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-19 22:21:38','2021-09-19 22:21:38'),(1712,'default','status_changed',489,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-19 22:21:52','2021-09-19 22:21:52'),(1713,'default','status_changed',56,'App\\Transaction',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-19 22:22:56','2021-09-19 22:22:56'),(1714,'default','added',364,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-09-19 22:33:36','2021-09-19 22:33:36'),(1715,'default','status_changed',497,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-19 22:33:56','2021-09-19 22:33:56'),(1716,'default','added',365,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-09-19 22:51:15','2021-09-19 22:51:15'),(1717,'default','status_changed',501,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-19 22:52:21','2021-09-19 22:52:21'),(1718,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-20 12:37:06','2021-09-20 12:37:06'),(1719,'default','added',518,'App\\Contact',11,'App\\User','[]','2021-09-20 12:39:26','2021-09-20 12:39:26'),(1720,'default','added',519,'App\\Contact',11,'App\\User','[]','2021-09-20 12:40:54','2021-09-20 12:40:54'),(1721,'default','added',520,'App\\Contact',11,'App\\User','[]','2021-09-20 12:48:12','2021-09-20 12:48:12'),(1722,'default','added',521,'App\\Contact',11,'App\\User','[]','2021-09-20 12:57:15','2021-09-20 12:57:15'),(1723,'default','added',522,'App\\Contact',11,'App\\User','[]','2021-09-20 12:58:27','2021-09-20 12:58:27'),(1724,'default','added',523,'App\\Contact',11,'App\\User','[]','2021-09-20 13:00:25','2021-09-20 13:00:25'),(1725,'default','added',524,'App\\Contact',11,'App\\User','[]','2021-09-20 13:45:51','2021-09-20 13:45:51'),(1726,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-20 13:50:29','2021-09-20 13:50:29'),(1727,'default','logout',11,'App\\User',11,'App\\User','[]','2021-09-20 13:51:33','2021-09-20 13:51:33'),(1728,'default','logout',4,'App\\User',4,'App\\User','[]','2021-09-20 13:53:42','2021-09-20 13:53:42'),(1729,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-20 14:04:18','2021-09-20 14:04:18'),(1730,'default','added',525,'App\\Contact',4,'App\\User','[]','2021-09-20 14:15:01','2021-09-20 14:15:01'),(1731,'default','added',366,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":325}}','2021-09-20 14:18:16','2021-09-20 14:18:16'),(1732,'default','status_changed',474,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-20 14:18:40','2021-09-20 14:18:40'),(1733,'default','added',526,'App\\Contact',4,'App\\User','[]','2021-09-20 15:24:13','2021-09-20 15:24:13'),(1734,'default','added',527,'App\\Contact',4,'App\\User','[]','2021-09-20 15:50:21','2021-09-20 15:50:21'),(1735,'default','login',1,'App\\User',1,'App\\User','[]','2021-09-20 16:11:34','2021-09-20 16:11:34'),(1736,'default','status_changed',515,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-20 16:39:35','2021-09-20 16:39:35'),(1737,'default','status_changed',484,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-20 16:39:49','2021-09-20 16:39:49'),(1738,'default','added',367,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-20 17:43:27','2021-09-20 17:43:27'),(1739,'default','added',528,'App\\Contact',4,'App\\User','[]','2021-09-20 17:47:52','2021-09-20 17:47:52'),(1740,'default','login',1,'App\\User',1,'App\\User','[]','2021-09-20 18:27:36','2021-09-20 18:27:36'),(1741,'default','logout',1,'App\\User',1,'App\\User','[]','2021-09-20 18:27:46','2021-09-20 18:27:46'),(1742,'default','login',1,'App\\User',1,'App\\User','[]','2021-09-20 18:27:54','2021-09-20 18:27:54'),(1743,'default','logout',1,'App\\User',1,'App\\User','[]','2021-09-20 18:28:03','2021-09-20 18:28:03'),(1744,'default','login',1,'App\\User',1,'App\\User','[]','2021-09-20 18:38:53','2021-09-20 18:38:53'),(1745,'default','added',21,'App\\User',1,'App\\User','[]','2021-09-20 19:12:12','2021-09-20 19:12:12'),(1746,'default','status_changed',488,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-20 19:20:08','2021-09-20 19:20:08'),(1747,'default','status_changed',486,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-20 19:26:27','2021-09-20 19:26:27'),(1748,'default','status_changed',516,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-20 19:27:18','2021-09-20 19:27:18'),(1749,'default','status_changed',506,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-20 19:36:24','2021-09-20 19:36:24'),(1750,'default','added',368,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-20 19:37:17','2021-09-20 19:37:17'),(1751,'default','added',529,'App\\Contact',4,'App\\User','[]','2021-09-20 19:37:44','2021-09-20 19:37:44'),(1752,'default','added',530,'App\\Contact',4,'App\\User','[]','2021-09-20 19:41:56','2021-09-20 19:41:56'),(1753,'default','status_changed',488,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-20 19:42:17','2021-09-20 19:42:17'),(1754,'default','added',531,'App\\Contact',4,'App\\User','[]','2021-09-20 19:49:26','2021-09-20 19:49:26'),(1755,'default','status_changed',480,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":\"\\u0631\\u0641\\u0636 \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644 \\u0627\\u0644\\u0627\\u0635\\u0644\\u0627\\u062d \\u0645\\u062d\\u0627\\u0648\\u0644\\u0629 300\",\"updated_status\":\"reject by customer\"}','2021-09-20 20:04:10','2021-09-20 20:04:10'),(1756,'default','added',532,'App\\Contact',4,'App\\User','[]','2021-09-20 20:12:08','2021-09-20 20:12:08'),(1757,'default','added',533,'App\\Contact',4,'App\\User','[]','2021-09-20 20:14:40','2021-09-20 20:14:40'),(1758,'default','added',534,'App\\Contact',4,'App\\User','[]','2021-09-20 20:15:01','2021-09-20 20:15:01'),(1759,'default','added',535,'App\\Contact',4,'App\\User','[]','2021-09-20 20:35:12','2021-09-20 20:35:12'),(1760,'default','status_changed',504,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-20 20:40:33','2021-09-20 20:40:33'),(1761,'default','added',369,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-20 20:56:22','2021-09-20 20:56:22'),(1762,'default','added',370,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-20 20:57:33','2021-09-20 20:57:33'),(1763,'default','status_changed',515,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-20 21:01:35','2021-09-20 21:01:35'),(1764,'default','added',371,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":175}}','2021-09-20 21:16:18','2021-09-20 21:16:18'),(1765,'default','status_changed',475,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-20 21:16:37','2021-09-20 21:16:37'),(1766,'default','added',372,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-20 21:21:40','2021-09-20 21:21:40'),(1767,'default','status_changed',486,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-20 21:22:19','2021-09-20 21:22:19'),(1768,'default','added',373,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-20 21:24:57','2021-09-20 21:24:57'),(1769,'default','added',374,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-09-20 21:26:11','2021-09-20 21:26:11'),(1770,'default','status_changed',499,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-20 21:27:41','2021-09-20 21:27:41'),(1771,'default','added',375,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-20 21:32:14','2021-09-20 21:32:14'),(1772,'default','added',536,'App\\Contact',11,'App\\User','[]','2021-09-20 21:38:06','2021-09-20 21:38:06'),(1773,'default','status_changed',488,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-20 21:39:04','2021-09-20 21:39:04'),(1774,'default','logout',1,'App\\User',1,'App\\User','[]','2021-09-20 21:45:14','2021-09-20 21:45:14'),(1775,'default','added',376,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}','2021-09-20 22:11:19','2021-09-20 22:11:19'),(1776,'default','status_changed',466,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"reject by customer\"}','2021-09-20 22:28:24','2021-09-20 22:28:24'),(1777,'default','added',377,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2800}}','2021-09-20 22:28:51','2021-09-20 22:28:51'),(1778,'default','status_changed',465,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-20 22:31:13','2021-09-20 22:31:13'),(1779,'default','added',537,'App\\Contact',4,'App\\User','[]','2021-09-20 23:01:32','2021-09-20 23:01:32'),(1780,'default','added',378,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-09-20 23:09:13','2021-09-20 23:09:13'),(1781,'default','added',379,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-20 23:09:51','2021-09-20 23:09:51'),(1782,'default','status_changed',519,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-20 23:10:08','2021-09-20 23:10:08'),(1783,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-21 12:31:31','2021-09-21 12:31:31'),(1784,'default','added',538,'App\\Contact',11,'App\\User','[]','2021-09-21 12:33:23','2021-09-21 12:33:23'),(1785,'default','added',380,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-21 13:03:19','2021-09-21 13:03:19'),(1786,'default','status_changed',516,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-21 13:03:49','2021-09-21 13:03:49'),(1787,'default','added',539,'App\\Contact',11,'App\\User','[]','2021-09-21 13:22:30','2021-09-21 13:22:30'),(1788,'default','added',540,'App\\Contact',11,'App\\User','[]','2021-09-21 13:24:24','2021-09-21 13:24:24'),(1789,'default','status_changed',481,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-21 14:47:51','2021-09-21 14:47:51'),(1790,'default','status_changed',509,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-21 14:48:11','2021-09-21 14:48:11'),(1791,'default','status_changed',514,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-21 14:48:21','2021-09-21 14:48:21'),(1792,'default','status_changed',508,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"reject by customer\"}','2021-09-21 14:49:49','2021-09-21 14:49:49'),(1793,'default','status_changed',513,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-21 14:50:16','2021-09-21 14:50:16'),(1794,'default','status_changed',517,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-21 14:53:01','2021-09-21 14:53:01'),(1795,'default','status_changed',521,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-21 14:54:11','2021-09-21 14:54:11'),(1796,'default','status_changed',522,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-21 14:54:29','2021-09-21 14:54:29'),(1797,'default','status_changed',523,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-21 14:54:56','2021-09-21 14:54:56'),(1798,'default','status_changed',524,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-21 14:55:07','2021-09-21 14:55:07'),(1799,'default','status_changed',530,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-21 14:55:20','2021-09-21 14:55:20'),(1800,'default','status_changed',527,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-21 14:55:32','2021-09-21 14:55:32'),(1801,'default','status_changed',520,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-21 14:56:26','2021-09-21 14:56:26'),(1802,'default','status_changed',458,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-21 14:56:40','2021-09-21 14:56:40'),(1803,'default','status_changed',478,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-21 15:07:57','2021-09-21 15:07:57'),(1804,'default','status_changed',269,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-21 15:32:03','2021-09-21 15:32:03'),(1805,'default','status_changed',217,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-21 15:32:14','2021-09-21 15:32:14'),(1806,'default','status_changed',205,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-21 15:32:52','2021-09-21 15:32:52'),(1807,'default','added',381,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-21 15:36:10','2021-09-21 15:36:10'),(1808,'default','status_changed',373,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-21 15:49:02','2021-09-21 15:49:02'),(1809,'default','logout',11,'App\\User',11,'App\\User','[]','2021-09-21 16:25:20','2021-09-21 16:25:20'),(1810,'default','login',1,'App\\User',1,'App\\User','[]','2021-09-21 16:25:35','2021-09-21 16:25:35'),(1811,'default','payment_edited',167,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"800.0000\"}}','2021-09-21 16:30:41','2021-09-21 16:30:41'),(1812,'default','added',382,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-21 16:37:59','2021-09-21 16:37:59'),(1813,'default','status_changed',440,'Modules\\Repair\\Entities\\JobSheet',1,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-21 16:38:26','2021-09-21 16:38:26'),(1814,'default','added',541,'App\\Contact',1,'App\\User','[]','2021-09-21 16:40:34','2021-09-21 16:40:34'),(1815,'default','login',1,'App\\User',1,'App\\User','[]','2021-09-21 16:47:11','2021-09-21 16:47:11'),(1816,'default','edited',175,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"400.0000\"}}','2021-09-21 17:09:26','2021-09-21 17:09:26'),(1817,'default','status_changed',167,'App\\Transaction',1,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-21 17:10:26','2021-09-21 17:10:26'),(1818,'default','edited',115,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"payment_status\":\"partial\",\"final_total\":800},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"700.0000\"}}','2021-09-21 17:14:03','2021-09-21 17:14:03'),(1819,'default','status_changed',525,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-21 17:18:07','2021-09-21 17:18:07'),(1820,'default','status_changed',500,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-21 17:18:24','2021-09-21 17:18:24'),(1821,'default','added',383,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-21 17:20:26','2021-09-21 17:20:26'),(1822,'default','added',384,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}','2021-09-21 17:22:03','2021-09-21 17:22:03'),(1823,'default','added',385,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-21 17:31:52','2021-09-21 17:31:52'),(1824,'default','status_changed',528,'Modules\\Repair\\Entities\\JobSheet',1,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-21 17:43:27','2021-09-21 17:43:27'),(1825,'default','added',542,'App\\Contact',1,'App\\User','[]','2021-09-21 17:56:17','2021-09-21 17:56:17'),(1826,'default','login',1,'App\\User',1,'App\\User','[]','2021-09-21 18:06:04','2021-09-21 18:06:04'),(1827,'default','login',1,'App\\User',1,'App\\User','[]','2021-09-21 18:32:52','2021-09-21 18:32:52'),(1828,'default','added',543,'App\\Contact',1,'App\\User','[]','2021-09-21 18:46:02','2021-09-21 18:46:02'),(1829,'default','added',386,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-21 18:53:15','2021-09-21 18:53:15'),(1830,'default','status_changed',529,'Modules\\Repair\\Entities\\JobSheet',1,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-21 18:53:53','2021-09-21 18:53:53'),(1831,'default','logout',1,'App\\User',1,'App\\User','[]','2021-09-21 19:03:09','2021-09-21 19:03:09'),(1832,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-21 19:03:23','2021-09-21 19:03:23'),(1833,'default','added',544,'App\\Contact',11,'App\\User','[]','2021-09-21 19:08:46','2021-09-21 19:08:46'),(1834,'default','login',1,'App\\User',1,'App\\User','[]','2021-09-21 19:11:27','2021-09-21 19:11:27'),(1835,'default','added',22,'App\\User',1,'App\\User','[]','2021-09-21 19:12:42','2021-09-21 19:12:42'),(1836,'default','added',545,'App\\Contact',11,'App\\User','[]','2021-09-21 19:18:14','2021-09-21 19:18:14'),(1837,'default','added',387,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-21 19:28:20','2021-09-21 19:28:20'),(1838,'default','status_changed',506,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-21 19:28:44','2021-09-21 19:28:44'),(1839,'default','status_changed',525,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-09-21 19:34:03','2021-09-21 19:34:03'),(1840,'default','added',546,'App\\Contact',4,'App\\User','[]','2021-09-21 19:36:34','2021-09-21 19:36:34'),(1841,'default','status_changed',525,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-21 19:44:16','2021-09-21 19:44:16'),(1842,'default','status_changed',533,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-21 19:44:25','2021-09-21 19:44:25'),(1843,'default','status_changed',531,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-21 19:44:35','2021-09-21 19:44:35'),(1844,'default','status_changed',524,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-21 19:55:37','2021-09-21 19:55:37'),(1845,'default','added',547,'App\\Contact',4,'App\\User','[]','2021-09-21 19:59:17','2021-09-21 19:59:17'),(1846,'default','added',548,'App\\Contact',4,'App\\User','[]','2021-09-21 20:07:20','2021-09-21 20:07:20'),(1847,'default','added',549,'App\\Contact',4,'App\\User','[]','2021-09-21 20:18:47','2021-09-21 20:18:47'),(1848,'default','status_changed',537,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-21 20:39:08','2021-09-21 20:39:08'),(1849,'default','status_changed',539,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-21 20:40:34','2021-09-21 20:40:34'),(1850,'default','status_changed',536,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-21 20:40:50','2021-09-21 20:40:50'),(1851,'default','status_changed',468,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-21 20:41:20','2021-09-21 20:41:20'),(1852,'default','logout',1,'App\\User',1,'App\\User','[]','2021-09-21 20:45:42','2021-09-21 20:45:42'),(1853,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-21 20:46:03','2021-09-21 20:46:03'),(1854,'default','payment_edited',167,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"800.0000\"}}','2021-09-21 20:46:45','2021-09-21 20:46:45'),(1855,'default','added',550,'App\\Contact',4,'App\\User','[]','2021-09-21 20:46:54','2021-09-21 20:46:54'),(1856,'default','logout',4,'App\\User',4,'App\\User','[]','2021-09-21 20:53:47','2021-09-21 20:53:47'),(1857,'default','login',1,'App\\User',1,'App\\User','[]','2021-09-21 20:53:56','2021-09-21 20:53:56'),(1858,'default','added',551,'App\\Contact',4,'App\\User','[]','2021-09-21 20:54:15','2021-09-21 20:54:15'),(1859,'default','added',388,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-09-21 21:01:25','2021-09-21 21:01:25'),(1860,'default','status_changed',496,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-21 21:02:21','2021-09-21 21:02:21'),(1861,'default','logout',1,'App\\User',1,'App\\User','[]','2021-09-21 21:05:20','2021-09-21 21:05:20'),(1862,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-21 21:05:29','2021-09-21 21:05:29'),(1863,'default','logout',4,'App\\User',4,'App\\User','[]','2021-09-21 21:11:18','2021-09-21 21:11:18'),(1864,'default','login',1,'App\\User',1,'App\\User','[]','2021-09-21 21:11:27','2021-09-21 21:11:27'),(1865,'default','payment_edited',35,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1850.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1850.0000\"}}','2021-09-21 21:11:56','2021-09-21 21:11:56'),(1866,'default','payment_edited',56,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1000.0000\"}}','2021-09-21 21:12:36','2021-09-21 21:12:36'),(1867,'default','added',552,'App\\Contact',4,'App\\User','[]','2021-09-21 21:12:43','2021-09-21 21:12:43'),(1868,'default','logout',1,'App\\User',1,'App\\User','[]','2021-09-21 21:13:47','2021-09-21 21:13:47'),(1869,'default','login',1,'App\\User',1,'App\\User','[]','2021-09-21 21:13:52','2021-09-21 21:13:52'),(1870,'default','logout',1,'App\\User',1,'App\\User','[]','2021-09-21 21:13:57','2021-09-21 21:13:57'),(1871,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-21 21:14:03','2021-09-21 21:14:03'),(1872,'default','logout',4,'App\\User',4,'App\\User','[]','2021-09-21 21:16:56','2021-09-21 21:16:56'),(1873,'default','login',1,'App\\User',1,'App\\User','[]','2021-09-21 21:17:05','2021-09-21 21:17:05'),(1874,'default','payment_edited',114,'App\\Transaction',1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"800.0000\"}}','2021-09-21 21:19:32','2021-09-21 21:19:32'),(1875,'default','logout',1,'App\\User',1,'App\\User','[]','2021-09-21 21:19:45','2021-09-21 21:19:45'),(1876,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-21 21:19:55','2021-09-21 21:19:55'),(1877,'default','payment_edited',114,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"800.0000\"}}','2021-09-21 21:20:49','2021-09-21 21:20:49'),(1878,'default','payment_edited',114,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"800.0000\"}}','2021-09-21 21:23:11','2021-09-21 21:23:11'),(1879,'default','payment_edited',114,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"800.0000\"}}','2021-09-21 21:23:49','2021-09-21 21:23:49'),(1880,'default','logout',4,'App\\User',4,'App\\User','[]','2021-09-21 21:24:26','2021-09-21 21:24:26'),(1881,'default','login',1,'App\\User',1,'App\\User','[]','2021-09-21 21:24:33','2021-09-21 21:24:33'),(1882,'default','logout',1,'App\\User',1,'App\\User','[]','2021-09-21 21:27:27','2021-09-21 21:27:27'),(1883,'default','login',1,'App\\User',1,'App\\User','[]','2021-09-21 21:27:31','2021-09-21 21:27:31'),(1884,'default','status_changed',481,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-21 21:43:45','2021-09-21 21:43:45'),(1885,'default','added',389,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-21 21:48:23','2021-09-21 21:48:23'),(1886,'default','status_changed',522,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-21 21:49:47','2021-09-21 21:49:47'),(1887,'default','status_changed',505,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-21 21:49:58','2021-09-21 21:49:58'),(1888,'default','status_changed',472,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-21 21:50:09','2021-09-21 21:50:09'),(1889,'default','logout',1,'App\\User',1,'App\\User','[]','2021-09-21 21:56:04','2021-09-21 21:56:04'),(1890,'default','login',19,'App\\User',19,'App\\User','[]','2021-09-21 21:56:18','2021-09-21 21:56:18'),(1891,'default','status_changed',500,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-09-21 21:56:51','2021-09-21 21:56:51'),(1892,'default','status_changed',539,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-09-21 21:57:28','2021-09-21 21:57:28'),(1893,'default','status_changed',525,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-09-21 21:57:45','2021-09-21 21:57:45'),(1894,'default','status_changed',533,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-09-21 22:00:03','2021-09-21 22:00:03'),(1895,'default','status_changed',538,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-09-21 22:02:43','2021-09-21 22:02:43'),(1896,'default','status_changed',537,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-09-21 22:03:04','2021-09-21 22:03:04'),(1897,'default','status_changed',536,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-21 22:10:33','2021-09-21 22:10:33'),(1898,'default','added',553,'App\\Contact',4,'App\\User','[]','2021-09-21 22:14:52','2021-09-21 22:14:52'),(1899,'default','logout',19,'App\\User',19,'App\\User','[]','2021-09-21 22:20:22','2021-09-21 22:20:22'),(1900,'default','login',1,'App\\User',1,'App\\User','[]','2021-09-21 22:20:34','2021-09-21 22:20:34'),(1901,'default','added',390,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-09-21 22:37:22','2021-09-21 22:37:22'),(1902,'default','status_changed',510,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-21 22:39:20','2021-09-21 22:39:20'),(1903,'default','status_changed',449,'Modules\\Repair\\Entities\\JobSheet',1,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-21 22:56:01','2021-09-21 22:56:01'),(1904,'default','added',391,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":250}}','2021-09-21 22:58:42','2021-09-21 22:58:42'),(1905,'default','added',554,'App\\Contact',4,'App\\User','[]','2021-09-21 23:33:31','2021-09-21 23:33:31'),(1906,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-22 12:32:32','2021-09-22 12:32:32'),(1907,'default','added',392,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-09-22 12:33:14','2021-09-22 12:33:14'),(1908,'default','status_changed',517,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-22 12:33:33','2021-09-22 12:33:33'),(1909,'default','added',555,'App\\Contact',11,'App\\User','[]','2021-09-22 13:57:15','2021-09-22 13:57:15'),(1910,'default','added',556,'App\\Contact',11,'App\\User','[]','2021-09-22 13:58:01','2021-09-22 13:58:01'),(1911,'default','added',557,'App\\Contact',11,'App\\User','[]','2021-09-22 14:11:42','2021-09-22 14:11:42'),(1912,'default','added',558,'App\\Contact',11,'App\\User','[]','2021-09-22 14:26:07','2021-09-22 14:26:07'),(1913,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-22 14:59:03','2021-09-22 14:59:03'),(1914,'default','status_changed',525,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-22 15:01:15','2021-09-22 15:01:15'),(1915,'default','added',559,'App\\Contact',11,'App\\User','[]','2021-09-22 15:31:31','2021-09-22 15:31:31'),(1916,'default','added',560,'App\\Contact',11,'App\\User','[]','2021-09-22 15:58:45','2021-09-22 15:58:45'),(1917,'default','logout',11,'App\\User',11,'App\\User','[]','2021-09-22 16:55:15','2021-09-22 16:55:15'),(1918,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-22 16:55:23','2021-09-22 16:55:23'),(1919,'default','added',393,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":300}}','2021-09-22 17:18:56','2021-09-22 17:18:56'),(1920,'default','added',561,'App\\Contact',4,'App\\User','[]','2021-09-22 17:22:30','2021-09-22 17:22:30'),(1921,'default','added',562,'App\\Contact',4,'App\\User','[]','2021-09-22 18:21:31','2021-09-22 18:21:31'),(1922,'default','added',394,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1100}}','2021-09-22 18:33:45','2021-09-22 18:33:45'),(1923,'default','status_changed',533,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-22 18:34:12','2021-09-22 18:34:12'),(1924,'default','added',395,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}','2021-09-22 18:34:36','2021-09-22 18:34:36'),(1925,'default','status_changed',530,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-22 18:34:54','2021-09-22 18:34:54'),(1926,'default','added',396,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-09-22 19:12:36','2021-09-22 19:12:36'),(1927,'default','status_changed',532,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-22 19:13:12','2021-09-22 19:13:12'),(1928,'default','logout',1,'App\\User',1,'App\\User','[]','2021-09-22 19:23:12','2021-09-22 19:23:12'),(1929,'default','login',19,'App\\User',19,'App\\User','[]','2021-09-22 19:23:41','2021-09-22 19:23:41'),(1930,'default','logout',19,'App\\User',19,'App\\User','[]','2021-09-22 19:44:18','2021-09-22 19:44:18'),(1931,'default','login',1,'App\\User',1,'App\\User','[]','2021-09-22 19:44:23','2021-09-22 19:44:23'),(1932,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-22 20:08:45','2021-09-22 20:08:45'),(1933,'default','added',563,'App\\Contact',4,'App\\User','[]','2021-09-22 20:08:53','2021-09-22 20:08:53'),(1934,'default','added',397,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-09-22 20:09:29','2021-09-22 20:09:29'),(1935,'default','status_changed',538,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-22 20:11:08','2021-09-22 20:11:08'),(1936,'default','logout',11,'App\\User',11,'App\\User','[]','2021-09-22 20:11:18','2021-09-22 20:11:18'),(1937,'default','status_changed',545,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-22 20:18:00','2021-09-22 20:18:00'),(1938,'default','added',398,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-09-22 20:19:13','2021-09-22 20:19:13'),(1939,'default','added',399,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-22 20:21:21','2021-09-22 20:21:21'),(1940,'default','status_changed',542,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-22 20:22:09','2021-09-22 20:22:09'),(1941,'default','added',400,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":850}}','2021-09-22 20:25:01','2021-09-22 20:25:01'),(1942,'default','added',401,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":850}}','2021-09-22 20:27:57','2021-09-22 20:27:57'),(1943,'default','status_changed',521,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-22 20:28:21','2021-09-22 20:28:21'),(1944,'default','added',402,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-22 20:29:00','2021-09-22 20:29:00'),(1945,'default','status_changed',544,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-22 20:29:25','2021-09-22 20:29:25'),(1946,'default','login',19,'App\\User',19,'App\\User','[]','2021-09-22 20:38:48','2021-09-22 20:38:48'),(1947,'default','added',564,'App\\Contact',4,'App\\User','[]','2021-09-22 21:13:08','2021-09-22 21:13:08'),(1948,'default','added',403,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-22 21:25:28','2021-09-22 21:25:28'),(1949,'default','status_changed',536,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-22 21:25:43','2021-09-22 21:25:43'),(1950,'default','added',404,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}','2021-09-22 21:37:50','2021-09-22 21:37:50'),(1951,'default','status_changed',512,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-22 21:38:04','2021-09-22 21:38:04'),(1952,'default','added',405,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-09-22 21:38:48','2021-09-22 21:38:48'),(1953,'default','status_changed',513,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-22 21:39:08','2021-09-22 21:39:08'),(1954,'default','added',406,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}','2021-09-22 21:52:28','2021-09-22 21:52:28'),(1955,'default','added',565,'App\\Contact',4,'App\\User','[]','2021-09-22 21:53:42','2021-09-22 21:53:42'),(1956,'default','status_changed',527,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-22 22:01:46','2021-09-22 22:01:46'),(1957,'default','added',566,'App\\Contact',4,'App\\User','[]','2021-09-22 22:03:17','2021-09-22 22:03:17'),(1958,'default','added',407,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-09-22 22:11:01','2021-09-22 22:11:01'),(1959,'default','added',408,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-09-22 22:24:13','2021-09-22 22:24:13'),(1960,'default','status_changed',547,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-22 22:28:14','2021-09-22 22:28:14'),(1961,'default','added',409,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-22 22:28:47','2021-09-22 22:28:47'),(1962,'default','status_changed',543,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-22 22:29:04','2021-09-22 22:29:04'),(1963,'default','payment_edited',368,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"150.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"150.0000\"}}','2021-09-22 22:53:11','2021-09-22 22:53:11'),(1964,'default','payment_edited',368,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"150.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"150.0000\"}}','2021-09-22 22:54:10','2021-09-22 22:54:10'),(1965,'default','added',410,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-09-22 22:57:13','2021-09-22 22:57:13'),(1966,'default','status_changed',509,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-22 22:57:32','2021-09-22 22:57:32'),(1967,'default','status_changed',511,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-22 22:57:51','2021-09-22 22:57:51'),(1968,'default','added',411,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-22 22:58:52','2021-09-22 22:58:52'),(1969,'default','status_changed',550,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-22 23:00:17','2021-09-22 23:00:17'),(1970,'default','logout',4,'App\\User',4,'App\\User','[]','2021-09-22 23:04:55','2021-09-22 23:04:55'),(1971,'default','login',1,'App\\User',1,'App\\User','[]','2021-09-23 02:08:45','2021-09-23 02:08:45'),(1972,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-23 12:31:17','2021-09-23 12:31:17'),(1973,'default','added',412,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-09-23 12:32:21','2021-09-23 12:32:21'),(1974,'default','status_changed',548,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-23 12:33:20','2021-09-23 12:33:20'),(1975,'default','added',567,'App\\Contact',11,'App\\User','[]','2021-09-23 12:48:25','2021-09-23 12:48:25'),(1976,'default','added',568,'App\\Contact',11,'App\\User','[]','2021-09-23 12:49:51','2021-09-23 12:49:51'),(1977,'default','added',569,'App\\Contact',11,'App\\User','[]','2021-09-23 13:05:23','2021-09-23 13:05:23'),(1978,'default','added',570,'App\\Contact',11,'App\\User','[]','2021-09-23 13:08:13','2021-09-23 13:08:13'),(1979,'default','added',571,'App\\Contact',11,'App\\User','[]','2021-09-23 13:19:00','2021-09-23 13:19:00'),(1980,'default','added',572,'App\\Contact',11,'App\\User','[]','2021-09-23 14:19:44','2021-09-23 14:19:44'),(1981,'default','added',573,'App\\Contact',11,'App\\User','[]','2021-09-23 14:21:53','2021-09-23 14:21:53'),(1982,'default','added',574,'App\\Contact',11,'App\\User','[]','2021-09-23 14:38:35','2021-09-23 14:38:35'),(1983,'default','added',575,'App\\Contact',11,'App\\User','[]','2021-09-23 14:51:52','2021-09-23 14:51:52'),(1984,'default','added',576,'App\\Contact',11,'App\\User','[]','2021-09-23 14:53:55','2021-09-23 14:53:55'),(1985,'default','added',577,'App\\Contact',11,'App\\User','[]','2021-09-23 14:55:03','2021-09-23 14:55:03'),(1986,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-23 15:18:23','2021-09-23 15:18:23'),(1987,'default','added',578,'App\\Contact',11,'App\\User','[]','2021-09-23 16:35:00','2021-09-23 16:35:00'),(1988,'default','status_changed',563,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-23 16:55:49','2021-09-23 16:55:49'),(1989,'default','status_changed',564,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-23 16:56:00','2021-09-23 16:56:00'),(1990,'default','added',23,'App\\User',1,'App\\User','[]','2021-09-23 17:04:51','2021-09-23 17:04:51'),(1991,'default','added',579,'App\\Contact',11,'App\\User','[]','2021-09-23 17:12:29','2021-09-23 17:12:29'),(1992,'default','added',580,'App\\Contact',11,'App\\User','[]','2021-09-23 17:18:33','2021-09-23 17:18:33'),(1993,'default','added',581,'App\\Contact',11,'App\\User','[]','2021-09-23 17:24:46','2021-09-23 17:24:46'),(1994,'default','status_changed',503,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-23 17:35:19','2021-09-23 17:35:19'),(1995,'default','added',413,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-23 17:36:25','2021-09-23 17:36:25'),(1996,'default','status_changed',560,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-23 17:36:50','2021-09-23 17:36:50'),(1997,'default','added',414,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-23 17:37:12','2021-09-23 17:37:12'),(1998,'default','status_changed',561,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-23 17:37:35','2021-09-23 17:37:35'),(1999,'default','added',415,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-09-23 17:39:00','2021-09-23 17:39:00'),(2000,'default','status_changed',539,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-23 17:39:17','2021-09-23 17:39:17'),(2001,'default','status_changed',458,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-23 17:47:36','2021-09-23 17:47:36'),(2002,'default','status_changed',570,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-23 17:59:30','2021-09-23 17:59:30'),(2003,'default','added',416,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-23 18:01:34','2021-09-23 18:01:34'),(2004,'default','added',417,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-23 18:20:33','2021-09-23 18:20:33'),(2005,'default','status_changed',571,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-23 18:21:21','2021-09-23 18:21:21'),(2006,'default','added',582,'App\\Contact',11,'App\\User','[]','2021-09-23 19:23:49','2021-09-23 19:23:49'),(2007,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-23 19:31:51','2021-09-23 19:31:51'),(2008,'default','added',583,'App\\Contact',11,'App\\User','[]','2021-09-23 19:32:51','2021-09-23 19:32:51'),(2009,'default','added',584,'App\\Contact',11,'App\\User','[]','2021-09-23 19:33:35','2021-09-23 19:33:35'),(2010,'default','added',585,'App\\Contact',11,'App\\User','[]','2021-09-23 19:33:59','2021-09-23 19:33:59'),(2011,'default','added',418,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-09-23 19:40:14','2021-09-23 19:40:14'),(2012,'default','added',586,'App\\Contact',11,'App\\User','[]','2021-09-23 19:40:51','2021-09-23 19:40:51'),(2013,'default','status_changed',483,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-23 19:49:21','2021-09-23 19:49:21'),(2014,'default','status_changed',572,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-23 20:08:37','2021-09-23 20:08:37'),(2015,'default','status_changed',556,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-23 20:08:46','2021-09-23 20:08:46'),(2016,'default','status_changed',569,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-23 20:09:08','2021-09-23 20:09:08'),(2017,'default','status_changed',574,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-23 20:09:37','2021-09-23 20:09:37'),(2018,'default','added',419,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-09-23 20:34:14','2021-09-23 20:34:14'),(2019,'default','status_changed',559,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-23 20:34:40','2021-09-23 20:34:40'),(2020,'default','added',420,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-23 21:02:46','2021-09-23 21:02:46'),(2021,'default','status_changed',572,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-23 21:03:12','2021-09-23 21:03:12'),(2022,'default','added',421,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":350}}','2021-09-23 21:12:44','2021-09-23 21:12:44'),(2023,'default','added',422,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":850}}','2021-09-23 21:15:40','2021-09-23 21:15:40'),(2024,'default','status_changed',514,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-23 21:16:09','2021-09-23 21:16:09'),(2025,'default','added',423,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1200}}','2021-09-23 21:16:40','2021-09-23 21:16:40'),(2026,'default','status_changed',261,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-23 21:16:57','2021-09-23 21:16:57'),(2027,'default','added',424,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-23 22:12:30','2021-09-23 22:12:30'),(2028,'default','status_changed',555,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-23 22:14:06','2021-09-23 22:14:06'),(2029,'default','added',425,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4000}}','2021-09-23 22:56:11','2021-09-23 22:56:11'),(2030,'default','login',20,'App\\User',20,'App\\User','[]','2021-09-24 14:44:58','2021-09-24 14:44:58'),(2031,'default','added',587,'App\\Contact',20,'App\\User','[]','2021-09-24 16:32:58','2021-09-24 16:32:58'),(2032,'default','added',588,'App\\Contact',20,'App\\User','[]','2021-09-24 16:42:22','2021-09-24 16:42:22'),(2033,'default','status_changed',534,'Modules\\Repair\\Entities\\JobSheet',20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-24 17:02:14','2021-09-24 17:02:14'),(2034,'default','added',589,'App\\Contact',20,'App\\User','[]','2021-09-24 17:12:02','2021-09-24 17:12:02'),(2035,'default','added',590,'App\\Contact',20,'App\\User','[]','2021-09-24 18:02:04','2021-09-24 18:02:04'),(2036,'default','added',591,'App\\Contact',20,'App\\User','[]','2021-09-24 18:15:46','2021-09-24 18:15:46'),(2037,'default','added',592,'App\\Contact',20,'App\\User','[]','2021-09-24 18:21:15','2021-09-24 18:21:15'),(2038,'default','added',593,'App\\Contact',20,'App\\User','[]','2021-09-24 18:27:18','2021-09-24 18:27:18'),(2039,'default','added',426,'App\\Transaction',20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-09-24 19:04:44','2021-09-24 19:04:44'),(2040,'default','added',594,'App\\Contact',20,'App\\User','[]','2021-09-24 19:25:01','2021-09-24 19:25:01'),(2041,'default','added',595,'App\\Contact',20,'App\\User','[]','2021-09-24 19:27:54','2021-09-24 19:27:54'),(2042,'default','status_changed',552,'Modules\\Repair\\Entities\\JobSheet',20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-24 19:34:15','2021-09-24 19:34:15'),(2043,'default','added',596,'App\\Contact',20,'App\\User','[]','2021-09-24 19:37:34','2021-09-24 19:37:34'),(2044,'default','added',597,'App\\Contact',20,'App\\User','[]','2021-09-24 19:42:37','2021-09-24 19:42:37'),(2045,'default','added',427,'App\\Transaction',20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-09-24 19:49:37','2021-09-24 19:49:37'),(2046,'default','added',598,'App\\Contact',20,'App\\User','[]','2021-09-24 19:53:46','2021-09-24 19:53:46'),(2047,'default','added',599,'App\\Contact',20,'App\\User','[]','2021-09-24 19:56:54','2021-09-24 19:56:54'),(2048,'default','added',428,'App\\Transaction',20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":225}}','2021-09-24 21:21:12','2021-09-24 21:21:12'),(2049,'default','added',429,'App\\Transaction',20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-24 21:21:46','2021-09-24 21:21:46'),(2050,'default','status_changed',566,'Modules\\Repair\\Entities\\JobSheet',20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-24 21:22:14','2021-09-24 21:22:14'),(2051,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-25 14:30:23','2021-09-25 14:30:23'),(2052,'default','added',600,'App\\Contact',4,'App\\User','[]','2021-09-25 14:32:02','2021-09-25 14:32:02'),(2053,'default','added',430,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-09-25 14:36:30','2021-09-25 14:36:30'),(2054,'default','status_changed',500,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-25 14:36:57','2021-09-25 14:36:57'),(2055,'default','status_changed',478,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-25 14:37:31','2021-09-25 14:37:31'),(2056,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-25 14:38:58','2021-09-25 14:38:58'),(2057,'default','login',1,'App\\User',1,'App\\User','[]','2021-09-25 16:12:49','2021-09-25 16:12:49'),(2058,'default','added',601,'App\\Contact',4,'App\\User','[]','2021-09-25 16:43:43','2021-09-25 16:43:43'),(2059,'default','added',602,'App\\Contact',4,'App\\User','[]','2021-09-25 17:01:07','2021-09-25 17:01:07'),(2060,'default','added',431,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-25 17:29:05','2021-09-25 17:29:05'),(2061,'default','status_changed',569,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-25 17:29:27','2021-09-25 17:29:27'),(2062,'default','added',603,'App\\Contact',4,'App\\User','[]','2021-09-25 17:47:13','2021-09-25 17:47:13'),(2063,'default','added',432,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-25 17:51:24','2021-09-25 17:51:24'),(2064,'default','status_changed',588,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-25 17:52:11','2021-09-25 17:52:11'),(2065,'default','added',604,'App\\Contact',4,'App\\User','[]','2021-09-25 17:56:00','2021-09-25 17:56:00'),(2066,'default','added',605,'App\\Contact',4,'App\\User','[]','2021-09-25 18:14:37','2021-09-25 18:14:37'),(2067,'default','added',606,'App\\Contact',4,'App\\User','[]','2021-09-25 18:33:40','2021-09-25 18:33:40'),(2068,'default','added',607,'App\\Contact',4,'App\\User','[]','2021-09-25 19:08:15','2021-09-25 19:08:15'),(2069,'default','added',608,'App\\Contact',4,'App\\User','[]','2021-09-25 19:26:52','2021-09-25 19:26:52'),(2070,'default','added',433,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-09-25 19:56:17','2021-09-25 19:56:17'),(2071,'default','added',434,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-25 19:57:13','2021-09-25 19:57:13'),(2072,'default','added',435,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-25 20:00:29','2021-09-25 20:00:29'),(2073,'default','login',1,'App\\User',1,'App\\User','[]','2021-09-25 20:02:02','2021-09-25 20:02:02'),(2074,'default','status_changed',494,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-25 20:14:50','2021-09-25 20:14:50'),(2075,'default','status_changed',577,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-25 20:35:20','2021-09-25 20:35:20'),(2076,'default','status_changed',582,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-25 20:35:30','2021-09-25 20:35:30'),(2077,'default','status_changed',584,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-25 20:36:37','2021-09-25 20:36:37'),(2078,'default','status_changed',583,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-25 20:36:47','2021-09-25 20:36:47'),(2079,'default','status_changed',580,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-25 20:36:58','2021-09-25 20:36:58'),(2080,'default','status_changed',593,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-25 20:37:08','2021-09-25 20:37:08'),(2081,'default','status_changed',591,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-25 20:39:38','2021-09-25 20:39:38'),(2082,'default','status_changed',596,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-25 20:39:46','2021-09-25 20:39:46'),(2083,'default','added',609,'App\\Contact',4,'App\\User','[]','2021-09-25 20:41:26','2021-09-25 20:41:26'),(2084,'default','added',436,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-25 20:52:17','2021-09-25 20:52:17'),(2085,'default','status_changed',595,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-25 20:52:35','2021-09-25 20:52:35'),(2086,'default','added',610,'App\\Contact',4,'App\\User','[]','2021-09-25 20:53:10','2021-09-25 20:53:10'),(2087,'default','status_changed',458,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-25 21:02:58','2021-09-25 21:02:58'),(2088,'default','status_changed',579,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-25 21:12:02','2021-09-25 21:12:02'),(2089,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-25 21:13:22','2021-09-25 21:13:22'),(2090,'default','added',437,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":125}}','2021-09-25 21:14:12','2021-09-25 21:14:12'),(2091,'default','status_changed',581,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-25 21:14:24','2021-09-25 21:14:24'),(2092,'default','status_changed',525,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-25 21:36:05','2021-09-25 21:36:05'),(2093,'default','added',438,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-09-25 21:52:24','2021-09-25 21:52:24'),(2094,'default','status_changed',585,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-25 21:52:54','2021-09-25 21:52:54'),(2095,'default','status_changed',575,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-25 21:55:02','2021-09-25 21:55:02'),(2096,'default','added',439,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-09-25 21:55:44','2021-09-25 21:55:44'),(2097,'default','added',440,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-25 21:56:23','2021-09-25 21:56:23'),(2098,'default','added',441,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":50}}','2021-09-25 22:09:03','2021-09-25 22:09:03'),(2099,'default','added',442,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-25 22:17:50','2021-09-25 22:17:50'),(2100,'default','status_changed',586,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-25 22:18:21','2021-09-25 22:18:21'),(2101,'default','added',443,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}','2021-09-25 22:19:14','2021-09-25 22:19:14'),(2102,'default','status_changed',582,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-25 22:19:33','2021-09-25 22:19:33'),(2103,'default','added',444,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-09-25 22:22:23','2021-09-25 22:22:23'),(2104,'default','status_changed',570,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-25 22:22:47','2021-09-25 22:22:47'),(2105,'default','added',445,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-09-25 22:51:37','2021-09-25 22:51:37'),(2106,'default','status_changed',593,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-25 22:55:10','2021-09-25 22:55:10'),(2107,'default','added',446,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-25 22:56:39','2021-09-25 22:56:39'),(2108,'default','status_changed',537,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-25 23:27:03','2021-09-25 23:27:03'),(2109,'default','login',19,'App\\User',19,'App\\User','[]','2021-09-26 06:53:25','2021-09-26 06:53:25'),(2110,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-26 12:42:05','2021-09-26 12:42:05'),(2111,'default','added',611,'App\\Contact',11,'App\\User','[]','2021-09-26 12:52:02','2021-09-26 12:52:02'),(2112,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-26 14:26:19','2021-09-26 14:26:19'),(2113,'default','added',447,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-26 14:28:38','2021-09-26 14:28:38'),(2114,'default','added',612,'App\\Contact',4,'App\\User','[]','2021-09-26 14:29:39','2021-09-26 14:29:39'),(2115,'default','added',448,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-09-26 14:33:15','2021-09-26 14:33:15'),(2116,'default','added',613,'App\\Contact',4,'App\\User','[]','2021-09-26 14:41:20','2021-09-26 14:41:20'),(2117,'default','added',449,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-09-26 15:04:53','2021-09-26 15:04:53'),(2118,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-26 15:05:10','2021-09-26 15:05:10'),(2119,'default','status_changed',264,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-26 15:05:52','2021-09-26 15:05:52'),(2120,'default','status_changed',269,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-26 15:07:33','2021-09-26 15:07:33'),(2121,'default','logout',11,'App\\User',11,'App\\User','[]','2021-09-26 15:08:30','2021-09-26 15:08:30'),(2122,'default','added',450,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-09-26 15:13:48','2021-09-26 15:13:48'),(2123,'default','status_changed',589,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-26 15:29:08','2021-09-26 15:29:08'),(2124,'default','added',451,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":175}}','2021-09-26 15:29:49','2021-09-26 15:29:49'),(2125,'default','status_changed',594,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-26 15:30:40','2021-09-26 15:30:40'),(2126,'default','status_changed',454,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-26 15:56:45','2021-09-26 15:56:45'),(2127,'default','status_changed',580,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-26 16:00:07','2021-09-26 16:00:07'),(2128,'default','status_changed',473,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-26 16:39:31','2021-09-26 16:39:31'),(2129,'default','status_changed',373,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-26 16:51:30','2021-09-26 16:51:30'),(2130,'default','added',614,'App\\Contact',4,'App\\User','[]','2021-09-26 17:05:21','2021-09-26 17:05:21'),(2131,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-26 17:31:41','2021-09-26 17:31:41'),(2132,'default','logout',11,'App\\User',11,'App\\User','[]','2021-09-26 17:37:05','2021-09-26 17:37:05'),(2133,'default','added',452,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-26 17:51:26','2021-09-26 17:51:26'),(2134,'default','status_changed',565,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-26 17:51:46','2021-09-26 17:51:46'),(2135,'default','added',615,'App\\Contact',4,'App\\User','[]','2021-09-26 18:03:09','2021-09-26 18:03:09'),(2136,'default','added',453,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-09-26 18:42:33','2021-09-26 18:42:33'),(2137,'default','added',616,'App\\Contact',4,'App\\User','[]','2021-09-26 18:54:39','2021-09-26 18:54:39'),(2138,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-26 19:00:23','2021-09-26 19:00:23'),(2139,'default','added',454,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-26 19:01:01','2021-09-26 19:01:01'),(2140,'default','added',617,'App\\Contact',4,'App\\User','[]','2021-09-26 19:01:09','2021-09-26 19:01:09'),(2141,'default','added',618,'App\\Contact',4,'App\\User','[]','2021-09-26 19:30:57','2021-09-26 19:30:57'),(2142,'default','added',619,'App\\Contact',4,'App\\User','[]','2021-09-26 19:33:07','2021-09-26 19:33:07'),(2143,'default','added',620,'App\\Contact',4,'App\\User','[]','2021-09-26 19:43:41','2021-09-26 19:43:41'),(2144,'default','added',621,'App\\Contact',4,'App\\User','[]','2021-09-26 19:47:01','2021-09-26 19:47:01'),(2145,'default','added',455,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600}}','2021-09-26 19:57:49','2021-09-26 19:57:49'),(2146,'default','status_changed',580,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-26 19:58:22','2021-09-26 19:58:22'),(2147,'default','added',456,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-26 20:04:31','2021-09-26 20:04:31'),(2148,'default','added',457,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2400}}','2021-09-26 20:05:03','2021-09-26 20:05:03'),(2149,'default','status_changed',599,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-26 20:05:26','2021-09-26 20:05:26'),(2150,'default','status_changed',574,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-26 20:05:27','2021-09-26 20:05:27'),(2151,'default','added',622,'App\\Contact',11,'App\\User','[]','2021-09-26 20:26:49','2021-09-26 20:26:49'),(2152,'default','added',458,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":125}}','2021-09-26 21:01:45','2021-09-26 21:01:45'),(2153,'default','status_changed',609,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-26 21:06:30','2021-09-26 21:06:30'),(2154,'default','added',623,'App\\Contact',4,'App\\User','[]','2021-09-26 21:14:53','2021-09-26 21:14:53'),(2155,'default','added',459,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-26 21:23:25','2021-09-26 21:23:25'),(2156,'default','status_changed',590,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-26 21:36:28','2021-09-26 21:36:28'),(2157,'default','logout',11,'App\\User',11,'App\\User','[]','2021-09-26 21:50:43','2021-09-26 21:50:43'),(2158,'default','added',460,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-26 21:56:12','2021-09-26 21:56:12'),(2159,'default','added',461,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-26 21:57:44','2021-09-26 21:57:44'),(2160,'default','status_changed',611,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-26 21:57:58','2021-09-26 21:57:58'),(2161,'default','added',462,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5300}}','2021-09-26 22:12:14','2021-09-26 22:12:14'),(2162,'default','status_changed',554,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-26 22:12:35','2021-09-26 22:12:35'),(2163,'default','added',463,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3300}}','2021-09-26 22:13:00','2021-09-26 22:13:00'),(2164,'default','status_changed',540,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-26 22:13:25','2021-09-26 22:13:25'),(2165,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-27 12:43:21','2021-09-27 12:43:21'),(2166,'default','added',624,'App\\Contact',11,'App\\User','[]','2021-09-27 12:44:11','2021-09-27 12:44:11'),(2167,'default','added',464,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-27 12:55:19','2021-09-27 12:55:19'),(2168,'default','status_changed',610,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-27 12:56:45','2021-09-27 12:56:45'),(2169,'default','added',625,'App\\Contact',11,'App\\User','[]','2021-09-27 14:02:27','2021-09-27 14:02:27'),(2170,'default','login',19,'App\\User',19,'App\\User','[]','2021-09-27 15:13:45','2021-09-27 15:13:45'),(2171,'default','added',626,'App\\Contact',19,'App\\User','[]','2021-09-27 15:15:28','2021-09-27 15:15:28'),(2172,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-27 15:15:35','2021-09-27 15:15:35'),(2173,'default','added',627,'App\\Contact',11,'App\\User','[]','2021-09-27 15:27:21','2021-09-27 15:27:21'),(2174,'default','added',628,'App\\Contact',11,'App\\User','[]','2021-09-27 15:41:17','2021-09-27 15:41:17'),(2175,'default','status_changed',454,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-27 16:00:23','2021-09-27 16:00:23'),(2176,'default','status_changed',577,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Check In Progress\"}','2021-09-27 16:01:47','2021-09-27 16:01:47'),(2177,'default','added',465,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-27 16:58:04','2021-09-27 16:58:04'),(2178,'default','status_changed',502,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-27 16:58:24','2021-09-27 16:58:24'),(2179,'default','added',466,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-09-27 16:58:50','2021-09-27 16:58:50'),(2180,'default','status_changed',602,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-27 16:59:51','2021-09-27 16:59:51'),(2181,'default','logout',19,'App\\User',19,'App\\User','[]','2021-09-27 17:02:37','2021-09-27 17:02:37'),(2182,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-27 17:03:53','2021-09-27 17:03:53'),(2183,'default','added',629,'App\\Contact',11,'App\\User','[]','2021-09-27 17:04:33','2021-09-27 17:04:33'),(2184,'default','added',630,'App\\Contact',11,'App\\User','[]','2021-09-27 17:15:46','2021-09-27 17:15:46'),(2185,'default','added',631,'App\\Contact',11,'App\\User','[]','2021-09-27 17:18:14','2021-09-27 17:18:14'),(2186,'default','added',632,'App\\Contact',11,'App\\User','[]','2021-09-27 17:36:11','2021-09-27 17:36:11'),(2187,'default','logout',11,'App\\User',11,'App\\User','[]','2021-09-27 17:36:41','2021-09-27 17:36:41'),(2188,'default','added',633,'App\\Contact',11,'App\\User','[]','2021-09-27 17:43:29','2021-09-27 17:43:29'),(2189,'default','added',634,'App\\Contact',11,'App\\User','[]','2021-09-27 17:48:07','2021-09-27 17:48:07'),(2190,'default','added',635,'App\\Contact',11,'App\\User','[]','2021-09-27 18:28:16','2021-09-27 18:28:16'),(2191,'default','status_changed',605,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-27 18:41:42','2021-09-27 18:41:42'),(2192,'default','added',467,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}','2021-09-27 18:45:58','2021-09-27 18:45:58'),(2193,'default','status_changed',246,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-27 18:46:18','2021-09-27 18:46:18'),(2194,'default','added',468,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-27 18:52:44','2021-09-27 18:52:44'),(2195,'default','status_changed',607,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-27 18:53:06','2021-09-27 18:53:06'),(2196,'default','added',636,'App\\Contact',11,'App\\User','[]','2021-09-27 18:57:34','2021-09-27 18:57:34'),(2197,'default','status_changed',617,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-27 19:00:31','2021-09-27 19:00:31'),(2198,'default','added',469,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-27 19:49:31','2021-09-27 19:49:31'),(2199,'default','status_changed',458,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-27 19:49:47','2021-09-27 19:49:47'),(2200,'default','added',637,'App\\Contact',11,'App\\User','[]','2021-09-27 20:04:48','2021-09-27 20:04:48'),(2201,'default','added',470,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1150}}','2021-09-27 20:36:14','2021-09-27 20:36:14'),(2202,'default','added',471,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-09-27 20:40:36','2021-09-27 20:40:36'),(2203,'default','status_changed',616,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-27 20:40:49','2021-09-27 20:40:49'),(2204,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-27 21:01:41','2021-09-27 21:01:41'),(2205,'default','added',638,'App\\Contact',11,'App\\User','[]','2021-09-27 21:02:58','2021-09-27 21:02:58'),(2206,'default','added',472,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-09-27 21:03:17','2021-09-27 21:03:17'),(2207,'default','status_changed',584,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-27 21:03:55','2021-09-27 21:03:55'),(2208,'default','added',639,'App\\Contact',11,'App\\User','[]','2021-09-27 21:05:48','2021-09-27 21:05:48'),(2209,'default','added',640,'App\\Contact',11,'App\\User','[]','2021-09-27 21:11:45','2021-09-27 21:11:45'),(2210,'default','added',641,'App\\Contact',11,'App\\User','[]','2021-09-27 21:21:34','2021-09-27 21:21:34'),(2211,'default','added',642,'App\\Contact',11,'App\\User','[]','2021-09-27 21:30:14','2021-09-27 21:30:14'),(2212,'default','added',473,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":175}}','2021-09-27 21:42:36','2021-09-27 21:42:36'),(2213,'default','status_changed',578,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-27 21:43:22','2021-09-27 21:43:22'),(2214,'default','status_changed',629,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-27 22:00:10','2021-09-27 22:00:10'),(2215,'default','status_changed',627,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-27 22:00:23','2021-09-27 22:00:23'),(2216,'default','added',474,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-09-27 22:25:15','2021-09-27 22:25:15'),(2217,'default','status_changed',621,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-27 22:25:33','2021-09-27 22:25:33'),(2218,'default','logout',11,'App\\User',11,'App\\User','[]','2021-09-27 22:29:26','2021-09-27 22:29:26'),(2219,'default','added',475,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-27 22:33:24','2021-09-27 22:33:24'),(2220,'default','status_changed',591,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-27 22:33:41','2021-09-27 22:33:41'),(2221,'default','added',476,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-09-27 22:49:53','2021-09-27 22:49:53'),(2222,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-28 13:34:49','2021-09-28 13:34:49'),(2223,'default','added',643,'App\\Contact',11,'App\\User','[]','2021-09-28 13:35:28','2021-09-28 13:35:28'),(2224,'default','added',644,'App\\Contact',11,'App\\User','[]','2021-09-28 13:36:52','2021-09-28 13:36:52'),(2225,'default','added',645,'App\\Contact',11,'App\\User','[]','2021-09-28 14:14:06','2021-09-28 14:14:06'),(2226,'default','added',646,'App\\Contact',11,'App\\User','[]','2021-09-28 14:19:39','2021-09-28 14:19:39'),(2227,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-28 14:26:32','2021-09-28 14:26:32'),(2228,'default','added',647,'App\\Contact',11,'App\\User','[]','2021-09-28 14:35:16','2021-09-28 14:35:16'),(2229,'default','login',19,'App\\User',19,'App\\User','[]','2021-09-28 14:38:26','2021-09-28 14:38:26'),(2230,'default','added',648,'App\\Contact',19,'App\\User','[]','2021-09-28 14:39:22','2021-09-28 14:39:22'),(2231,'default','status_changed',453,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Finished\"}','2021-09-28 14:51:04','2021-09-28 14:51:04'),(2232,'default','status_changed',345,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-09-28 14:51:18','2021-09-28 14:51:18'),(2233,'default','logout',11,'App\\User',11,'App\\User','[]','2021-09-28 17:01:23','2021-09-28 17:01:23'),(2234,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-28 17:01:31','2021-09-28 17:01:31'),(2235,'default','added',477,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-28 18:11:16','2021-09-28 18:11:16'),(2236,'default','status_changed',623,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-28 18:11:33','2021-09-28 18:11:33'),(2237,'default','added',649,'App\\Contact',19,'App\\User','[]','2021-09-28 18:37:59','2021-09-28 18:37:59'),(2238,'default','added',478,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-28 19:02:25','2021-09-28 19:02:25'),(2239,'default','added',650,'App\\Contact',19,'App\\User','[]','2021-09-28 19:04:52','2021-09-28 19:04:52'),(2240,'default','added',651,'App\\Contact',19,'App\\User','[]','2021-09-28 19:05:18','2021-09-28 19:05:18'),(2241,'default','added',479,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-28 19:10:23','2021-09-28 19:10:23'),(2242,'default','status_changed',612,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-28 19:11:40','2021-09-28 19:11:40'),(2243,'default','added',480,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-28 19:14:09','2021-09-28 19:14:09'),(2244,'default','status_changed',598,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-28 19:14:26','2021-09-28 19:14:26'),(2245,'default','added',481,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-09-28 19:51:22','2021-09-28 19:51:22'),(2246,'default','status_changed',608,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-28 19:51:40','2021-09-28 19:51:40'),(2247,'default','added',652,'App\\Contact',4,'App\\User','[]','2021-09-28 20:22:14','2021-09-28 20:22:14'),(2248,'default','added',482,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-09-28 20:29:23','2021-09-28 20:29:23'),(2249,'default','status_changed',614,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-28 20:29:44','2021-09-28 20:29:44'),(2250,'default','added',653,'App\\Contact',4,'App\\User','[]','2021-09-28 20:47:33','2021-09-28 20:47:33'),(2251,'default','added',654,'App\\Contact',4,'App\\User','[]','2021-09-28 20:54:29','2021-09-28 20:54:29'),(2252,'default','added',483,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-28 21:07:07','2021-09-28 21:07:07'),(2253,'default','status_changed',637,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-28 21:07:28','2021-09-28 21:07:28'),(2254,'default','status_changed',375,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-28 21:18:55','2021-09-28 21:18:55'),(2255,'default','added',655,'App\\Contact',19,'App\\User','[]','2021-09-28 21:40:35','2021-09-28 21:40:35'),(2256,'default','added',656,'App\\Contact',4,'App\\User','[]','2021-09-28 21:41:19','2021-09-28 21:41:19'),(2257,'default','added',657,'App\\Contact',4,'App\\User','[]','2021-09-28 22:10:09','2021-09-28 22:10:09'),(2258,'default','added',484,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-28 22:22:01','2021-09-28 22:22:01'),(2259,'default','added',485,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":950}}','2021-09-28 22:22:41','2021-09-28 22:22:41'),(2260,'default','status_changed',627,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-28 22:23:03','2021-09-28 22:23:03'),(2261,'default','added',486,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}','2021-09-28 22:23:36','2021-09-28 22:23:36'),(2262,'default','added',487,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-28 22:24:24','2021-09-28 22:24:24'),(2263,'default','status_changed',596,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-28 22:24:43','2021-09-28 22:24:43'),(2264,'default','added',488,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-09-28 22:25:09','2021-09-28 22:25:09'),(2265,'default','status_changed',615,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-28 22:25:25','2021-09-28 22:25:25'),(2266,'default','added',489,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-28 22:25:56','2021-09-28 22:25:56'),(2267,'default','status_changed',620,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-28 22:26:31','2021-09-28 22:26:31'),(2268,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-29 12:13:17','2021-09-29 12:13:17'),(2269,'default','added',658,'App\\Contact',11,'App\\User','[]','2021-09-29 12:26:21','2021-09-29 12:26:21'),(2270,'default','added',659,'App\\Contact',11,'App\\User','[]','2021-09-29 13:06:01','2021-09-29 13:06:01'),(2271,'default','added',660,'App\\Contact',11,'App\\User','[]','2021-09-29 13:35:30','2021-09-29 13:35:30'),(2272,'default','added',661,'App\\Contact',11,'App\\User','[]','2021-09-29 13:41:45','2021-09-29 13:41:45'),(2273,'default','added',662,'App\\Contact',11,'App\\User','[]','2021-09-29 13:42:25','2021-09-29 13:42:25'),(2274,'default','added',663,'App\\Contact',11,'App\\User','[]','2021-09-29 13:44:09','2021-09-29 13:44:09'),(2275,'default','added',664,'App\\Contact',11,'App\\User','[]','2021-09-29 13:54:40','2021-09-29 13:54:40'),(2276,'default','added',490,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-29 14:27:41','2021-09-29 14:27:41'),(2277,'default','status_changed',630,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 14:27:54','2021-09-29 14:27:54'),(2278,'default','added',665,'App\\Contact',11,'App\\User','[]','2021-09-29 14:46:52','2021-09-29 14:46:52'),(2279,'default','added',666,'App\\Contact',11,'App\\User','[]','2021-09-29 15:02:56','2021-09-29 15:02:56'),(2280,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-29 15:04:57','2021-09-29 15:04:57'),(2281,'default','added',667,'App\\Contact',11,'App\\User','[]','2021-09-29 15:31:19','2021-09-29 15:31:19'),(2282,'default','added',491,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-09-29 15:53:26','2021-09-29 15:53:26'),(2283,'default','status_changed',638,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"reject by customer\"}','2021-09-29 16:25:02','2021-09-29 16:25:02'),(2284,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-29 16:34:53','2021-09-29 16:34:53'),(2285,'default','status_changed',205,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 16:45:12','2021-09-29 16:45:12'),(2286,'default','status_changed',383,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 16:45:43','2021-09-29 16:45:43'),(2287,'default','status_changed',441,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 16:46:34','2021-09-29 16:46:34'),(2288,'default','status_changed',424,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 16:47:06','2021-09-29 16:47:06'),(2289,'default','status_changed',460,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 16:47:27','2021-09-29 16:47:27'),(2290,'default','status_changed',411,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 16:47:59','2021-09-29 16:47:59'),(2291,'default','status_changed',626,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 16:50:43','2021-09-29 16:50:43'),(2292,'default','added',492,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-29 16:51:48','2021-09-29 16:51:48'),(2293,'default','status_changed',217,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 16:51:49','2021-09-29 16:51:49'),(2294,'default','added',493,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600}}','2021-09-29 16:52:26','2021-09-29 16:52:26'),(2295,'default','status_changed',642,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 16:52:47','2021-09-29 16:52:47'),(2296,'default','added',494,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}','2021-09-29 16:53:14','2021-09-29 16:53:14'),(2297,'default','status_changed',428,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 16:53:30','2021-09-29 16:53:30'),(2298,'default','added',495,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-29 16:54:10','2021-09-29 16:54:10'),(2299,'default','status_changed',562,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 16:54:24','2021-09-29 16:54:24'),(2300,'default','status_changed',558,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 16:57:14','2021-09-29 16:57:14'),(2301,'default','added',496,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1200}}','2021-09-29 16:57:34','2021-09-29 16:57:34'),(2302,'default','status_changed',490,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 16:57:47','2021-09-29 16:57:47'),(2303,'default','logout',11,'App\\User',11,'App\\User','[]','2021-09-29 16:59:27','2021-09-29 16:59:27'),(2304,'default','status_changed',428,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-29 17:08:41','2021-09-29 17:08:41'),(2305,'default','added',497,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-29 17:20:24','2021-09-29 17:20:24'),(2306,'default','status_changed',649,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 17:21:16','2021-09-29 17:21:16'),(2307,'default','status_changed',557,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-09-29 17:24:37','2021-09-29 17:24:37'),(2308,'default','added',668,'App\\Contact',11,'App\\User','[]','2021-09-29 17:28:53','2021-09-29 17:28:53'),(2309,'default','login',1,'App\\User',1,'App\\User','[]','2021-09-29 17:43:38','2021-09-29 17:43:38'),(2310,'default','added',669,'App\\Contact',11,'App\\User','[]','2021-09-29 17:45:54','2021-09-29 17:45:54'),(2311,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-29 17:48:04','2021-09-29 17:48:04'),(2312,'default','added',670,'App\\Contact',11,'App\\User','[]','2021-09-29 17:48:57','2021-09-29 17:48:57'),(2313,'default','added',498,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1100}}','2021-09-29 17:59:00','2021-09-29 17:59:00'),(2314,'default','status_changed',619,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 18:00:19','2021-09-29 18:00:19'),(2315,'default','added',499,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1150}}','2021-09-29 18:03:27','2021-09-29 18:03:27'),(2316,'default','status_changed',618,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 18:04:25','2021-09-29 18:04:25'),(2317,'default','added',671,'App\\Contact',11,'App\\User','[]','2021-09-29 18:09:52','2021-09-29 18:09:52'),(2318,'default','added',672,'App\\Contact',11,'App\\User','[]','2021-09-29 18:30:13','2021-09-29 18:30:13'),(2319,'default','added',673,'App\\Contact',11,'App\\User','[]','2021-09-29 18:40:34','2021-09-29 18:40:34'),(2320,'default','added',500,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-29 18:57:49','2021-09-29 18:57:49'),(2321,'default','status_changed',648,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 18:58:08','2021-09-29 18:58:08'),(2322,'default','added',674,'App\\Contact',11,'App\\User','[]','2021-09-29 19:02:20','2021-09-29 19:02:20'),(2323,'default','added',675,'App\\Contact',11,'App\\User','[]','2021-09-29 19:33:23','2021-09-29 19:33:23'),(2324,'default','added',676,'App\\Contact',11,'App\\User','[]','2021-09-29 19:39:18','2021-09-29 19:39:18'),(2325,'default','added',677,'App\\Contact',11,'App\\User','[]','2021-09-29 19:41:46','2021-09-29 19:41:46'),(2326,'default','added',678,'App\\Contact',11,'App\\User','[]','2021-09-29 19:52:42','2021-09-29 19:52:42'),(2327,'default','status_changed',652,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-29 20:02:20','2021-09-29 20:02:20'),(2328,'default','status_changed',660,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-29 20:05:46','2021-09-29 20:05:46'),(2329,'default','added',679,'App\\Contact',11,'App\\User','[]','2021-09-29 20:18:44','2021-09-29 20:18:44'),(2330,'default','added',680,'App\\Contact',11,'App\\User','[]','2021-09-29 20:26:14','2021-09-29 20:26:14'),(2331,'default','added',681,'App\\Contact',11,'App\\User','[]','2021-09-29 20:31:16','2021-09-29 20:31:16'),(2332,'default','status_changed',636,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-29 20:31:53','2021-09-29 20:31:53'),(2333,'default','status_changed',664,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-29 20:32:04','2021-09-29 20:32:04'),(2334,'default','added',682,'App\\Contact',11,'App\\User','[]','2021-09-29 20:44:37','2021-09-29 20:44:37'),(2335,'default','added',683,'App\\Contact',11,'App\\User','[]','2021-09-29 21:04:03','2021-09-29 21:04:03'),(2336,'default','status_changed',428,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 21:24:37','2021-09-29 21:24:37'),(2337,'default','added',501,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-09-29 21:25:15','2021-09-29 21:25:15'),(2338,'default','added',502,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":175}}','2021-09-29 21:25:55','2021-09-29 21:25:55'),(2339,'default','status_changed',655,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 21:26:20','2021-09-29 21:26:20'),(2340,'default','added',503,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":175}}','2021-09-29 21:28:03','2021-09-29 21:28:03'),(2341,'default','status_changed',644,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 21:28:53','2021-09-29 21:28:53'),(2342,'default','added',504,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-29 21:29:45','2021-09-29 21:29:45'),(2343,'default','status_changed',664,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 21:30:22','2021-09-29 21:30:22'),(2344,'default','added',505,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-29 21:31:05','2021-09-29 21:31:05'),(2345,'default','status_changed',658,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 21:31:37','2021-09-29 21:31:37'),(2346,'default','status_changed',660,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-29 21:34:11','2021-09-29 21:34:11'),(2347,'default','logout',11,'App\\User',11,'App\\User','[]','2021-09-29 21:37:15','2021-09-29 21:37:15'),(2348,'default','logout',11,'App\\User',11,'App\\User','[]','2021-09-29 21:42:53','2021-09-29 21:42:53'),(2349,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-29 21:45:06','2021-09-29 21:45:06'),(2350,'default','added',506,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-09-29 21:47:49','2021-09-29 21:47:49'),(2351,'default','added',507,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-09-29 21:50:22','2021-09-29 21:50:22'),(2352,'default','status_changed',659,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 21:50:35','2021-09-29 21:50:35'),(2353,'default','added',508,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-29 21:51:13','2021-09-29 21:51:13'),(2354,'default','status_changed',639,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 21:51:29','2021-09-29 21:51:29'),(2355,'default','added',509,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-09-29 21:52:04','2021-09-29 21:52:04'),(2356,'default','status_changed',657,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 21:52:21','2021-09-29 21:52:21'),(2357,'default','added',510,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-29 21:52:50','2021-09-29 21:52:50'),(2358,'default','status_changed',641,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 21:53:15','2021-09-29 21:53:15'),(2359,'default','logout',11,'App\\User',11,'App\\User','[]','2021-09-29 22:00:07','2021-09-29 22:00:07'),(2360,'default','added',511,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-09-29 22:02:10','2021-09-29 22:02:10'),(2361,'default','status_changed',652,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 22:02:33','2021-09-29 22:02:33'),(2362,'default','added',684,'App\\Contact',11,'App\\User','[]','2021-09-29 22:30:23','2021-09-29 22:30:23'),(2363,'default','added',512,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1100}}','2021-09-29 22:58:13','2021-09-29 22:58:13'),(2364,'default','status_changed',635,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 22:58:35','2021-09-29 22:58:35'),(2365,'default','added',513,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-09-29 22:59:14','2021-09-29 22:59:14'),(2366,'default','status_changed',640,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 22:59:33','2021-09-29 22:59:33'),(2367,'default','added',514,'App\\Transaction',11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-29 23:00:03','2021-09-29 23:00:03'),(2368,'default','status_changed',668,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 23:00:35','2021-09-29 23:00:35'),(2369,'default','login',4,'App\\User',4,'App\\User','[]','2021-09-30 12:28:43','2021-09-30 12:28:43'),(2370,'default','added',685,'App\\Contact',4,'App\\User','[]','2021-09-30 13:06:47','2021-09-30 13:06:47'),(2371,'default','status_changed',647,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-30 13:29:10','2021-09-30 13:29:10'),(2372,'default','added',686,'App\\Contact',4,'App\\User','[]','2021-09-30 13:45:50','2021-09-30 13:45:50'),(2373,'default','added',687,'App\\Contact',4,'App\\User','[]','2021-09-30 14:03:33','2021-09-30 14:03:33'),(2374,'default','added',515,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-30 14:11:38','2021-09-30 14:11:38'),(2375,'default','status_changed',632,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-30 14:12:02','2021-09-30 14:12:02'),(2376,'default','added',688,'App\\Contact',4,'App\\User','[]','2021-09-30 14:29:11','2021-09-30 14:29:11'),(2377,'default','login',19,'App\\User',19,'App\\User','[]','2021-09-30 14:33:45','2021-09-30 14:33:45'),(2378,'default','added',689,'App\\Contact',19,'App\\User','[]','2021-09-30 14:35:08','2021-09-30 14:35:08'),(2379,'default','login',11,'App\\User',11,'App\\User','[]','2021-09-30 15:24:35','2021-09-30 15:24:35'),(2380,'default','added',690,'App\\Contact',19,'App\\User','[]','2021-09-30 15:43:32','2021-09-30 15:43:32'),(2381,'default','added',691,'App\\Contact',19,'App\\User','[]','2021-09-30 15:48:56','2021-09-30 15:48:56'),(2382,'default','added',516,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-09-30 15:54:42','2021-09-30 15:54:42'),(2383,'default','status_changed',671,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-30 15:55:06','2021-09-30 15:55:06'),(2384,'default','added',692,'App\\Contact',4,'App\\User','[]','2021-09-30 16:59:39','2021-09-30 16:59:39'),(2385,'default','added',517,'App\\Transaction',4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-09-30 17:08:24','2021-09-30 17:08:24'),(2386,'default','status_changed',634,'Modules\\Repair\\Entities\\JobSheet',4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-30 17:08:43','2021-09-30 17:08:43'),(2387,'default','added',693,'App\\Contact',4,'App\\User','[]','2021-09-30 17:34:44','2021-09-30 17:34:44'),(2388,'default','added',24,'App\\User',1,'App\\User','[]','2021-09-30 17:37:18','2021-09-30 17:37:18'),(2389,'default','status_changed',673,'Modules\\Repair\\Entities\\JobSheet',11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-30 17:38:28','2021-09-30 17:38:28');
/*!40000 ALTER TABLE `activity_log` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `barcodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `barcodes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `width` double(22,4) DEFAULT NULL,
  `height` double(22,4) DEFAULT NULL,
  `paper_width` double(22,4) DEFAULT NULL,
  `paper_height` double(22,4) DEFAULT NULL,
  `top_margin` double(22,4) DEFAULT NULL,
  `left_margin` double(22,4) DEFAULT NULL,
  `row_distance` double(22,4) DEFAULT NULL,
  `col_distance` double(22,4) DEFAULT NULL,
  `stickers_in_one_row` int(11) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `is_continuous` tinyint(1) NOT NULL DEFAULT '0',
  `stickers_in_one_sheet` int(11) DEFAULT NULL,
  `business_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `barcodes_business_id_foreign` (`business_id`) USING BTREE,
  CONSTRAINT `barcodes_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `barcodes` WRITE;
/*!40000 ALTER TABLE `barcodes` DISABLE KEYS */;
INSERT INTO `barcodes` VALUES (1,'20 Labels per Sheet','Sheet Size: 8.5\" x 11\", Label Size: 4\" x 1\", Labels per sheet: 20',4.0000,1.0000,8.5000,11.0000,0.5000,0.1250,0.0000,0.1875,2,0,0,20,NULL,'2017-12-18 06:13:44','2017-12-18 06:13:44'),(2,'30 Labels per sheet','Sheet Size: 8.5\" x 11\", Label Size: 2.625\" x 1\", Labels per sheet: 30',2.6250,1.0000,8.5000,11.0000,0.5000,0.1880,0.0000,0.1250,3,0,0,30,NULL,'2017-12-18 06:04:39','2017-12-18 06:10:40'),(3,'32 Labels per sheet','Sheet Size: 8.5\" x 11\", Label Size: 2\" x 1.25\", Labels per sheet: 32',2.0000,1.2500,8.5000,11.0000,0.5000,0.2500,0.0000,0.0000,4,0,0,32,NULL,'2017-12-18 05:55:40','2017-12-18 05:55:40'),(4,'40 Labels per sheet','Sheet Size: 8.5\" x 11\", Label Size: 2\" x 1\", Labels per sheet: 40',2.0000,1.0000,8.5000,11.0000,0.5000,0.2500,0.0000,0.0000,4,0,0,40,NULL,'2017-12-18 05:58:40','2017-12-18 05:58:40'),(5,'50 Labels per Sheet','Sheet Size: 8.5\" x 11\", Label Size: 1.5\" x 1\", Labels per sheet: 50',1.5000,1.0000,8.5000,11.0000,0.5000,0.5000,0.0000,0.0000,5,0,0,50,NULL,'2017-12-18 05:51:10','2017-12-18 05:51:10'),(6,'Continuous Rolls - 31.75mm x 25.4mm','Label Size: 31.75mm x 25.4mm, Gap: 3.18mm',1.2500,1.0000,1.2500,0.0000,0.1250,0.0000,0.1250,0.0000,1,0,1,NULL,NULL,'2017-12-18 05:51:10','2017-12-18 05:51:10');
/*!40000 ALTER TABLE `barcodes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bookings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bookings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` int(10) unsigned NOT NULL,
  `waiter_id` int(10) unsigned DEFAULT NULL,
  `table_id` int(10) unsigned DEFAULT NULL,
  `correspondent_id` int(11) DEFAULT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `booking_start` datetime NOT NULL,
  `booking_end` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `booking_status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `booking_note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `bookings_contact_id_foreign` (`contact_id`) USING BTREE,
  KEY `bookings_business_id_foreign` (`business_id`) USING BTREE,
  KEY `bookings_created_by_foreign` (`created_by`) USING BTREE,
  KEY `bookings_table_id_index` (`table_id`) USING BTREE,
  KEY `bookings_waiter_id_index` (`waiter_id`) USING BTREE,
  KEY `bookings_location_id_index` (`location_id`) USING BTREE,
  KEY `bookings_booking_status_index` (`booking_status`) USING BTREE,
  KEY `bookings_correspondent_id_index` (`correspondent_id`) USING BTREE,
  CONSTRAINT `bookings_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bookings` WRITE;
/*!40000 ALTER TABLE `bookings` DISABLE KEYS */;
/*!40000 ALTER TABLE `bookings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `brands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `brands` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `use_for_repair` int(10) DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `brands_business_id_foreign` (`business_id`) USING BTREE,
  KEY `brands_created_by_foreign` (`created_by`) USING BTREE,
  CONSTRAINT `brands_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `brands_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `brands` WRITE;
/*!40000 ALTER TABLE `brands` DISABLE KEYS */;
INSERT INTO `brands` VALUES (1,1,'APPLE','Apple Mobiles',1,NULL,'2021-08-05 22:01:27','2021-08-07 20:00:07',1),(2,1,'SAMSUNG','Samsung Mobiles',1,NULL,'2021-08-07 14:47:21','2021-08-07 14:48:33',1),(3,1,'OPPO','OPPO Mobiles',1,NULL,'2021-08-07 14:48:53','2021-08-07 14:48:53',0),(4,1,'HTC',NULL,1,NULL,'2021-08-07 19:54:56','2021-08-07 19:54:56',1),(5,1,'SONY',NULL,1,NULL,'2021-08-07 19:55:08','2021-08-07 19:55:08',1),(6,1,'REALME',NULL,1,NULL,'2021-08-07 19:55:23','2021-08-07 19:55:23',1),(7,1,'XIAOMI',NULL,1,NULL,'2021-08-07 19:55:36','2021-08-07 19:55:36',1),(8,1,'INFINIX',NULL,1,NULL,'2021-08-07 19:59:26','2021-08-07 19:59:26',1),(9,1,'HUAWEI',NULL,1,NULL,'2021-08-07 20:00:36','2021-08-07 20:00:36',1),(10,1,'NOKIA',NULL,1,NULL,'2021-08-09 18:26:22','2021-08-09 18:26:22',1),(11,1,'Honor','Honor Mobiles',1,NULL,'2021-08-10 18:31:23','2021-08-10 18:31:23',1),(12,1,'LENOVO',NULL,1,NULL,'2021-08-10 20:15:09','2021-09-20 19:14:59',1),(13,1,'MOTOROLA',NULL,4,NULL,'2021-09-12 17:02:15','2021-09-20 19:14:47',0);
/*!40000 ALTER TABLE `brands` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `business` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency_id` int(10) unsigned NOT NULL,
  `start_date` date DEFAULT NULL,
  `tax_number_1` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_label_1` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_number_2` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_label_2` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_sales_tax` int(10) unsigned DEFAULT NULL,
  `default_profit_percent` double(5,2) NOT NULL DEFAULT '0.00',
  `owner_id` int(10) unsigned NOT NULL,
  `time_zone` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Asia/Kolkata',
  `fy_start_month` tinyint(4) NOT NULL DEFAULT '1',
  `accounting_method` enum('fifo','lifo','avco') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'fifo',
  `default_sales_discount` decimal(5,2) DEFAULT NULL,
  `sell_price_tax` enum('includes','excludes') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'includes',
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sku_prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enable_product_expiry` tinyint(1) NOT NULL DEFAULT '0',
  `expiry_type` enum('add_expiry','add_manufacturing') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'add_expiry',
  `on_product_expiry` enum('keep_selling','stop_selling','auto_delete') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'keep_selling',
  `stop_selling_before` int(11) NOT NULL COMMENT 'Stop selling expied item n days before expiry',
  `enable_tooltip` tinyint(1) NOT NULL DEFAULT '1',
  `purchase_in_diff_currency` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Allow purchase to be in different currency then the business currency',
  `purchase_currency_id` int(10) unsigned DEFAULT NULL,
  `p_exchange_rate` decimal(20,3) NOT NULL DEFAULT '1.000',
  `transaction_edit_days` int(10) unsigned NOT NULL DEFAULT '30',
  `stock_expiry_alert_days` int(10) unsigned NOT NULL DEFAULT '30',
  `keyboard_shortcuts` text COLLATE utf8mb4_unicode_ci,
  `pos_settings` text COLLATE utf8mb4_unicode_ci,
  `weighing_scale_setting` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'used to store the configuration of weighing scale',
  `enable_brand` tinyint(1) NOT NULL DEFAULT '1',
  `enable_category` tinyint(1) NOT NULL DEFAULT '1',
  `enable_sub_category` tinyint(1) NOT NULL DEFAULT '1',
  `enable_price_tax` tinyint(1) NOT NULL DEFAULT '1',
  `enable_purchase_status` tinyint(1) DEFAULT '1',
  `enable_lot_number` tinyint(1) NOT NULL DEFAULT '0',
  `default_unit` int(11) DEFAULT NULL,
  `enable_sub_units` tinyint(1) NOT NULL DEFAULT '0',
  `enable_racks` tinyint(1) NOT NULL DEFAULT '0',
  `enable_row` tinyint(1) NOT NULL DEFAULT '0',
  `enable_position` tinyint(1) NOT NULL DEFAULT '0',
  `enable_editing_product_from_purchase` tinyint(1) NOT NULL DEFAULT '1',
  `sales_cmsn_agnt` enum('logged_in_user','user','cmsn_agnt') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_addition_method` tinyint(1) NOT NULL DEFAULT '1',
  `enable_inline_tax` tinyint(1) NOT NULL DEFAULT '1',
  `currency_symbol_placement` enum('before','after') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'before',
  `enabled_modules` text COLLATE utf8mb4_unicode_ci,
  `date_format` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'm/d/Y',
  `time_format` enum('12','24') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '24',
  `ref_no_prefixes` text COLLATE utf8mb4_unicode_ci,
  `theme_color` char(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `repair_settings` text COLLATE utf8mb4_unicode_ci,
  `enable_rp` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'rp is the short form of reward points',
  `rp_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `amount_for_unit_rp` decimal(22,4) NOT NULL DEFAULT '1.0000' COMMENT 'rp is the short form of reward points',
  `min_order_total_for_rp` decimal(22,4) NOT NULL DEFAULT '1.0000' COMMENT 'rp is the short form of reward points',
  `max_rp_per_order` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `redeem_amount_per_unit_rp` decimal(22,4) NOT NULL DEFAULT '1.0000' COMMENT 'rp is the short form of reward points',
  `min_order_total_for_redeem` decimal(22,4) NOT NULL DEFAULT '1.0000' COMMENT 'rp is the short form of reward points',
  `min_redeem_point` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `max_redeem_point` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `rp_expiry_period` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `rp_expiry_type` enum('month','year') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'year' COMMENT 'rp is the short form of reward points',
  `email_settings` text COLLATE utf8mb4_unicode_ci,
  `sms_settings` text COLLATE utf8mb4_unicode_ci,
  `custom_labels` text COLLATE utf8mb4_unicode_ci,
  `common_settings` text COLLATE utf8mb4_unicode_ci,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `business_owner_id_foreign` (`owner_id`) USING BTREE,
  KEY `business_currency_id_foreign` (`currency_id`) USING BTREE,
  KEY `business_default_sales_tax_foreign` (`default_sales_tax`) USING BTREE,
  CONSTRAINT `business_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`),
  CONSTRAINT `business_default_sales_tax_foreign` FOREIGN KEY (`default_sales_tax`) REFERENCES `tax_rates` (`id`),
  CONSTRAINT `business_owner_id_foreign` FOREIGN KEY (`owner_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business` WRITE;
/*!40000 ALTER TABLE `business` DISABLE KEYS */;
INSERT INTO `business` VALUES (1,'Mobiley Eshtaghal',35,'2021-08-01',NULL,NULL,NULL,NULL,NULL,25.00,1,'Africa/Cairo',1,'fifo',0.00,'includes','1631804483_LOGO MOBILEY ESHTAGHAL NEW SVG.svg',NULL,1,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"weighing_scale\":null,\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"amount_rounding_method\":null,\"disable_pay_checkout\":0,\"disable_draft\":0,\"disable_express_checkout\":0,\"hide_product_suggestion\":0,\"hide_recent_trans\":0,\"disable_discount\":0,\"disable_order_tax\":0,\"is_pos_subtotal_editable\":0}','{\"label_prefix\":null,\"product_sku_length\":\"4\",\"qty_length\":\"3\",\"qty_length_decimal\":\"2\"}',1,1,0,1,1,0,1,0,1,1,1,1,NULL,1,0,'after','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\",\"account\",\"service_staff\"]','d-m-Y','12','{\"purchase\":\"PO\",\"purchase_return\":null,\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"expense_payment\":null,\"business_location\":\"BL\",\"username\":null,\"subscription\":null,\"draft\":null}','black-light',NULL,'{\"repair_tc_condition\":\"<ol>\\r\\n<li>\\u0644\\u0644\\u0634\\u0631\\u0643\\u0647 \\u0627\\u0644\\u062d\\u0642 \\u0641\\u064a \\u0641\\u062a\\u062d \\u0627\\u0644\\u062c\\u0647\\u0627\\u0632 \\u062f\\u0648\\u0646 \\u0627\\u0644\\u0631\\u062c\\u0648\\u0639 \\u0627\\u0644\\u064a \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644.<\\/li>\\r\\n<li>\\u0627\\u0644\\u062c\\u0647\\u0627\\u0632 \\u0644\\u0627 \\u0633\\u0644\\u0645 \\u0627\\u0644\\u0627 \\u0628\\u0647\\u0630\\u0627 \\u0627\\u0644\\u0627\\u064a\\u0635\\u0627\\u0644 \\u0648\\u0641\\u064a \\u062d\\u0627\\u0644\\u0647 \\u0641\\u0642\\u062f\\u0647 \\u0644\\u0627 \\u064a\\u062a\\u0645 \\u062a\\u0633\\u0644\\u064a\\u0645 \\u0627\\u0644\\u062c\\u0647\\u0627\\u0632.<\\/li>\\r\\n<li>\\u0627\\u0644\\u0627\\u062d\\u062a\\u0641\\u0627\\u0638 \\u0628\\u0627\\u0644\\u0628\\u064a\\u0627\\u0646\\u0627\\u062a \\u0627\\u0644\\u0647\\u0627\\u0645\\u0629 \\u0645\\u0633\\u0626\\u0648\\u0644\\u064a\\u0629 \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644 \\u062d\\u064a\\u062b \\u0627\\u0646 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0647 \\u063a\\u064a\\u0631 \\u0645\\u0633\\u0626\\u0648\\u0644\\u0647 \\u0639\\u0646 \\u0627\\u064a \\u0628\\u064a\\u0627\\u0646\\u0627\\u062a \\u0645\\u062e\\u0632\\u0646\\u0629 \\u0639\\u0644\\u064a \\u0627\\u0644\\u0647\\u0627\\u062a\\u0641.<\\/li>\\r\\n<li>\\u064a\\u062c\\u0628 \\u0627\\u0633\\u062a\\u0644\\u0627\\u0645 \\u0627\\u0644\\u062c\\u0647\\u0627\\u0632 \\u0645\\u0646 \\u0642\\u0633\\u0645 \\u0627\\u0644\\u0635\\u064a\\u0627\\u0646\\u0629 \\u0641\\u064a \\u062e\\u0644\\u0627\\u0644 \\u062b\\u0644\\u0627\\u062b \\u0627\\u0634\\u0647\\u0631 \\u0645\\u0646 \\u062a\\u0633\\u0644\\u064a\\u0645\\u0647 \\u0648\\u0641\\u064a \\u062d\\u0627\\u0644\\u0647 \\u0627\\u0644\\u062a\\u0627\\u062e\\u064a\\u0631 \\u064a\\u062a\\u0645 \\u062a\\u062d\\u0635\\u064a\\u0644 \\u0645\\u0628\\u0644\\u063a \\u062e\\u0645\\u0633\\u0648\\u0646 \\u062c\\u0646\\u064a\\u0647\\u0627 \\u0639\\u0644\\u064a \\u0643\\u0644 \\u0634\\u0647\\u0631 \\u0628\\u062f\\u0627 \\u0645\\u0646 \\u0627\\u0644\\u0634\\u0647\\u0631 \\u0627\\u0644\\u0631\\u0627\\u0628\\u0639 \\u0648\\u0627\\u0644\\u0634\\u0631\\u0643\\u0629 \\u063a\\u064a\\u0631 \\u0645\\u0633\\u0626\\u0648\\u0644\\u0629 \\u0639\\u0646 \\u0627\\u0644\\u062c\\u0647\\u0627\\u0632 \\u062a\\u0645\\u0627\\u0645\\u0627 \\u0627\\u0630\\u0627 \\u0645\\u0631 \\u0639\\u0644\\u064a \\u0645\\u064a\\u0639\\u0627\\u062f \\u0627\\u0633\\u062a\\u0644\\u0627\\u0645\\u0647 6 \\u0634\\u0647\\u0631.<\\/li>\\r\\n<li>\\u064a\\u0645\\u0643\\u0646 \\u0644\\u0644\\u0634\\u0631\\u0643\\u0629 \\u062a\\u0627\\u062c\\u064a\\u0644 \\u0645\\u064a\\u0639\\u0627\\u062f \\u0627\\u0644\\u062a\\u0633\\u0644\\u064a\\u0645 \\u0628\\u0633\\u0628\\u0628 \\u0639\\u062f\\u0645 \\u062a\\u0648\\u0641\\u0631 \\u0642\\u0637\\u0639 \\u0627\\u0644\\u063a\\u064a\\u0627\\u0631 \\u0627\\u0644\\u0644\\u0632\\u0645\\u0647 \\u0644\\u0644\\u062c\\u0647\\u0627\\u0632 \\u0627\\u0648 \\u062a\\u063a\\u064a\\u0631 \\u062a\\u0643\\u0644\\u0641\\u0647 \\u0645\\u0628\\u0644\\u063a \\u0627\\u0644\\u0645\\u062a\\u0641\\u0642 \\u0639\\u0644\\u064a\\u0647 \\u0628\\u0634\\u0631\\u0637 \\u0627\\u0644\\u0627\\u062e\\u0637\\u0627\\u0631 \\u0647\\u0627\\u062a\\u0641\\u064a\\u0627.<\\/li>\\r\\n<li>\\u0641\\u064a \\u062d\\u0627\\u0644\\u0629 \\u0639\\u062f\\u0645 \\u0627\\u0645\\u0643\\u0627\\u0646\\u064a\\u0629 \\u0627\\u0644\\u062a\\u0648\\u0627\\u0635\\u0644 \\u0645\\u0639 \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644 \\u0644\\u0633\\u0628\\u0628\\u0627 \\u0645\\u0627 \\u064a\\u062a\\u0645 \\u062a\\u0627\\u062c\\u064a\\u0644 \\u0645\\u064a\\u0639\\u0627\\u062f \\u0627\\u0644\\u062a\\u0633\\u0644\\u064a\\u0645 \\u062d\\u062a\\u064a \\u064a\\u062a\\u0645 \\u0627\\u0644\\u062a\\u0648\\u0627\\u0635\\u0644 \\u0645\\u0639 \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644 \\u0645\\u0631\\u0647 \\u0627\\u062e\\u0631\\u064a.<\\/li>\\r\\n<li>\\u0627\\u0644\\u0634\\u0631\\u0643\\u0629 \\u063a\\u064a\\u0631 \\u0645\\u0633\\u0626\\u0648\\u0644\\u0629 \\u0639\\u0646 \\u0623\\u064a \\u0645\\u0644\\u062d\\u0642\\u0627\\u062a \\u0644\\u0644\\u062c\\u0647\\u0627\\u0632 \\u0645\\u062b\\u0644 (\\u0627\\u0644\\u0628\\u0637\\u0627\\u0631\\u064a\\u0629 &ndash; \\u0643\\u0627\\u0631\\u062a \\u0627\\u0644\\u0630\\u0627\\u0643\\u0631\\u0629 &ndash; \\u062e\\u0637 \\u0627\\u0644\\u0627\\u062a\\u0635\\u0627\\u0644 &ndash; \\u0627\\u0644\\u063a\\u0637\\u0627\\u0621 \\u0627\\u0644\\u062e\\u0644\\u0641\\u064a \\u0644\\u0644\\u062c\\u0647\\u0627\\u0632).<\\/li>\\r\\n<li>\\u0627\\u0644\\u0634\\u0631\\u0643\\u0629 \\u063a\\u064a\\u0631 \\u0645\\u0633\\u0626\\u0648\\u0644\\u0629 \\u0639\\u0646 \\u0627\\u0644\\u0627\\u0639\\u0637\\u0627\\u0644 \\u0627\\u0644\\u0646\\u0627\\u062a\\u062c\\u0629 \\u0639\\u0646 \\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0627\\u0643\\u0633\\u0633\\u0648\\u0627\\u0631\\u0627\\u062a \\u063a\\u064a\\u0631 \\u0627\\u0635\\u0644\\u064a\\u0647 \\u0627\\u0648 \\u062a\\u062d\\u0645\\u064a\\u0644 \\u0628\\u0631\\u0646\\u0627\\u0645\\u062c \\u0645\\u0646 \\u0645\\u0648\\u0627\\u0642\\u0639 \\u063a\\u064a\\u0631 \\u0645\\u0639\\u062a\\u0645\\u062f\\u0647 \\u0648\\u064a\\u0639\\u062a\\u0628\\u0631 \\u0627\\u0644\\u0636\\u0645\\u0627\\u0646 \\u0644\\u0627\\u063a\\u064a\\u0627 \\u0641\\u064a \\u062d\\u0627\\u0644\\u0629 \\u062a\\u0639\\u0631\\u0636 \\u0627\\u0644\\u062c\\u0647\\u0627\\u0632 \\u0633\\u0648\\u0621 \\u0627\\u0644\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0645\\u0646 \\u0642\\u0628\\u0644 \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644<\\/li>\\r\\n<li>\\u0627\\u0644\\u0634\\u0631\\u0643\\u0629 \\u063a\\u064a\\u0631 \\u0645\\u0633\\u0626\\u0648\\u0644\\u0629 \\u0639\\u0646 \\u0623\\u064a \\u062d\\u062f\\u0648\\u062b \\u0643\\u0633\\u0631 \\u0627\\u0648 \\u0634\\u0631\\u062e \\u0641\\u064a \\u0627\\u0644\\u0634\\u0627\\u0634\\u0629 \\u062e\\u0644\\u0627\\u0644 \\u0641\\u062a\\u0631\\u0629 \\u0627\\u0644\\u0636\\u0645\\u0627\\u0646 \\u0648\\u064a\\u0639\\u062a\\u0628\\u0631 \\u0627\\u0644\\u0636\\u0645\\u0627\\u0646 \\u0644\\u0627\\u063a\\u064a\\u0627.<\\/li>\\r\\n<li>\\u0641\\u064a \\u062d\\u0627\\u0644\\u0647 \\u0631\\u0641\\u0636 \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644 \\u0627\\u062c\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0635\\u064a\\u0627\\u0646\\u0647 &nbsp;\\u0628\\u0639\\u062f \\u0641\\u062d\\u0635 \\u0627\\u0644\\u062c\\u0647\\u0627\\u0632 \\u0627\\u0644\\u062c\\u0647\\u0627\\u0632 \\u064a\\u062a\\u0645 \\u062f\\u0641\\u0639 \\u0642\\u064a\\u0645\\u0647 \\u0627\\u0644\\u0641\\u062d\\u0635 \\u0648\\u062a\\u062e\\u0635\\u0645 \\u0641\\u064a \\u062d\\u0627\\u0644\\u0647 \\u0627\\u0644\\u0631\\u062c\\u0648\\u0639 \\u0644\\u0644\\u0635\\u064a\\u0646\\u0647 \\u0645\\u0631\\u0647 \\u0627\\u062e\\u0631\\u064a.<\\/li>\\r\\n<li>\\u062a\\u0636\\u0645\\u0646 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0629 \\u0627\\u0644\\u0627\\u062c\\u0647\\u0632\\u0629 \\u0639\\u0644\\u064a \\u0646\\u0641\\u0633 \\u0627\\u0644\\u0639\\u0637\\u0644 \\u0627\\u0644\\u062a\\u064a \\u0642\\u0627\\u0645\\u062a \\u0628\\u0623\\u0635\\u0644\\u0627\\u062d\\u0647 \\u0641\\u0642\\u0637.<\\/li>\\r\\n<li>\\u064a\\u062e\\u0631\\u062c \\u0627\\u0644\\u062c\\u0647\\u0627\\u0632 \\u0645\\u0646 \\u0641\\u062a\\u0631\\u0629 \\u0627\\u0644\\u0636\\u0645\\u0627\\u0646 \\u0641\\u064a \\u062d\\u0627\\u0644\\u0629 \\u0641\\u062a\\u062d \\u0627\\u0644\\u062c\\u0647\\u0627\\u0632 \\u062e\\u0627\\u0631\\u062c \\u0627\\u0644\\u0645\\u0631\\u0643\\u0632 \\u062e\\u0644\\u0627\\u0644 \\u0641\\u062a\\u0631\\u0629 \\u0627\\u0644\\u0636\\u0645\\u0627\\u0646.<\\/li>\\r\\n<li>\\u0644\\u064a\\u0633 \\u0645\\u0646 \\u062d\\u0642 \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644 \\u0627\\u0644\\u0645\\u0637\\u0627\\u0644\\u0628\\u0629 \\u0628\\u0642\\u0637\\u0639 \\u0627\\u0644\\u063a\\u064a\\u0627\\u0631 \\u0627\\u0644\\u0642\\u062f\\u064a\\u0645\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0645 \\u0627\\u0633\\u062a\\u0628\\u062f\\u0644\\u0647\\u0627 \\u0648\\u064a\\u062a\\u0645 \\u0627\\u0639\\u062f\\u0627\\u0645\\u0647\\u0627 \\u0648\\u0641\\u0642\\u0627 \\u0644\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0628\\u064a\\u0626\\u0629 \\u0631\\u0642\\u0645 \\u0664 \\u0644\\u0633\\u0646\\u0647 \\u0661\\u0669\\u0669\\u0662<\\/li>\\r\\n<\\/ol>\",\"job_sheet_prefix\":null,\"problem_reported_by_customer\":null,\"product_condition\":null,\"product_configuration\":null,\"job_sheet_custom_field_1\":\"TECHNITION FEES\",\"job_sheet_custom_field_2\":\"WARRANTY PERIOD\",\"job_sheet_custom_field_3\":null,\"job_sheet_custom_field_4\":null,\"job_sheet_custom_field_5\":null,\"default_status\":\"1\"}',0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year','{\"mail_driver\":\"smtp\",\"mail_host\":null,\"mail_port\":null,\"mail_username\":null,\"mail_password\":null,\"mail_encryption\":null,\"mail_from_address\":null,\"mail_from_name\":null}','{\"sms_service\":\"other\",\"nexmo_key\":null,\"nexmo_secret\":null,\"nexmo_from\":null,\"twilio_sid\":null,\"twilio_token\":null,\"twilio_from\":null,\"url\":null,\"send_to_param_name\":\"to\",\"msg_param_name\":\"text\",\"request_method\":\"post\",\"header_1\":null,\"header_val_1\":null,\"header_2\":null,\"header_val_2\":null,\"header_3\":null,\"header_val_3\":null,\"param_1\":null,\"param_val_1\":null,\"param_2\":null,\"param_val_2\":null,\"param_3\":null,\"param_val_3\":null,\"param_4\":null,\"param_val_4\":null,\"param_5\":null,\"param_val_5\":null,\"param_6\":null,\"param_val_6\":null,\"param_7\":null,\"param_val_7\":null,\"param_8\":null,\"param_val_8\":null,\"param_9\":null,\"param_val_9\":null,\"param_10\":null,\"param_val_10\":null}','{\"payments\":{\"custom_pay_1\":null,\"custom_pay_2\":null,\"custom_pay_3\":null,\"custom_pay_4\":null,\"custom_pay_5\":null,\"custom_pay_6\":null,\"custom_pay_7\":null},\"contact\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null,\"custom_field_7\":null,\"custom_field_8\":null,\"custom_field_9\":null,\"custom_field_10\":null},\"product\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"location\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"user\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"sell\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"types_of_service\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null}}','{\"enable_product_warranty\":\"1\",\"default_credit_limit\":null,\"default_datatable_page_entries\":\"50\"}',1,'2021-08-06 01:22:09','2021-09-20 19:16:09');
/*!40000 ALTER TABLE `business` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `business_locations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  `landmark` text COLLATE utf8mb4_unicode_ci,
  `country` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `city` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `zip_code` char(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `invoice_scheme_id` int(10) unsigned NOT NULL,
  `invoice_layout_id` int(10) unsigned NOT NULL,
  `sale_invoice_layout_id` int(11) DEFAULT NULL,
  `selling_price_group_id` int(11) DEFAULT NULL,
  `print_receipt_on_invoice` tinyint(1) DEFAULT '1',
  `receipt_printer_type` enum('browser','printer') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'browser',
  `printer_id` int(11) DEFAULT NULL,
  `mobile` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alternate_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `website` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `featured_products` text COLLATE utf8mb4_unicode_ci,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `default_payment_accounts` text COLLATE utf8mb4_unicode_ci,
  `custom_field1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `business_locations_business_id_index` (`business_id`) USING BTREE,
  KEY `business_locations_invoice_scheme_id_foreign` (`invoice_scheme_id`) USING BTREE,
  KEY `business_locations_invoice_layout_id_foreign` (`invoice_layout_id`) USING BTREE,
  KEY `business_locations_sale_invoice_layout_id_index` (`sale_invoice_layout_id`) USING BTREE,
  KEY `business_locations_selling_price_group_id_index` (`selling_price_group_id`) USING BTREE,
  KEY `business_locations_receipt_printer_type_index` (`receipt_printer_type`) USING BTREE,
  KEY `business_locations_printer_id_index` (`printer_id`) USING BTREE,
  CONSTRAINT `business_locations_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `business_locations_invoice_layout_id_foreign` FOREIGN KEY (`invoice_layout_id`) REFERENCES `invoice_layouts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `business_locations_invoice_scheme_id_foreign` FOREIGN KEY (`invoice_scheme_id`) REFERENCES `invoice_schemes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business_locations` WRITE;
/*!40000 ALTER TABLE `business_locations` DISABLE KEYS */;
INSERT INTO `business_locations` VALUES (1,1,'BL0001','Mobiley Eshtaghal','Helwan','Egypt','Cairo','Cairo','Cairo',1,1,1,NULL,1,'browser',NULL,'','','','',NULL,1,'{\"cash\":{\"is_enabled\":1,\"account\":null},\"card\":{\"is_enabled\":1,\"account\":null},\"cheque\":{\"is_enabled\":1,\"account\":null},\"bank_transfer\":{\"is_enabled\":1,\"account\":null},\"other\":{\"is_enabled\":1,\"account\":null},\"custom_pay_1\":{\"is_enabled\":1,\"account\":null},\"custom_pay_2\":{\"is_enabled\":1,\"account\":null},\"custom_pay_3\":{\"is_enabled\":1,\"account\":null},\"custom_pay_4\":{\"is_enabled\":1,\"account\":null},\"custom_pay_5\":{\"is_enabled\":1,\"account\":null},\"custom_pay_6\":{\"is_enabled\":1,\"account\":null},\"custom_pay_7\":{\"is_enabled\":1,\"account\":null}}',NULL,NULL,NULL,NULL,NULL,'2021-08-06 01:22:09','2021-08-06 01:22:09');
/*!40000 ALTER TABLE `business_locations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_register_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cash_register_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cash_register_id` int(10) unsigned NOT NULL,
  `amount` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `pay_method` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` enum('debit','credit') COLLATE utf8mb4_unicode_ci NOT NULL,
  `transaction_type` enum('initial','sell','transfer','refund') COLLATE utf8mb4_unicode_ci NOT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `cash_register_transactions_cash_register_id_foreign` (`cash_register_id`) USING BTREE,
  KEY `cash_register_transactions_transaction_id_index` (`transaction_id`) USING BTREE,
  KEY `cash_register_transactions_type_index` (`type`) USING BTREE,
  KEY `cash_register_transactions_transaction_type_index` (`transaction_type`) USING BTREE,
  CONSTRAINT `cash_register_transactions_cash_register_id_foreign` FOREIGN KEY (`cash_register_id`) REFERENCES `cash_registers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1017 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_register_transactions` WRITE;
/*!40000 ALTER TABLE `cash_register_transactions` DISABLE KEYS */;
INSERT INTO `cash_register_transactions` VALUES (1,1,100.0000,'cash','credit','initial',NULL,'2021-08-05 22:24:06','2021-08-05 22:24:06'),(2,1,500.0000,'cash','credit','sell',1,'2021-08-05 22:27:36','2021-08-05 22:27:36'),(3,1,0.0000,'cash','credit','sell',1,'2021-08-05 22:27:36','2021-08-05 22:27:36'),(4,1,800.0000,'cash','credit','sell',2,'2021-08-06 02:03:33','2021-08-06 02:03:33'),(5,1,0.0000,'cash','credit','sell',2,'2021-08-06 02:03:33','2021-08-06 02:03:33'),(8,1,1250.0000,'cash','credit','sell',8,'2021-08-07 17:35:13','2021-08-07 17:35:13'),(9,1,0.0000,'cash','credit','sell',8,'2021-08-07 17:35:13','2021-08-07 17:35:13'),(10,1,1750.0000,'cash','credit','sell',9,'2021-08-07 18:11:33','2021-08-07 18:11:33'),(11,1,0.0000,'cash','credit','sell',9,'2021-08-07 18:11:33','2021-08-07 18:11:33'),(14,1,1250.0000,'cash','credit','sell',12,'2021-08-08 22:37:49','2021-08-08 22:37:49'),(15,1,0.0000,'cash','credit','sell',12,'2021-08-08 22:37:49','2021-08-08 22:37:49'),(18,1,500.0000,'cash','credit','sell',14,'2021-08-08 22:38:24','2021-08-08 22:38:24'),(19,1,0.0000,'cash','credit','sell',14,'2021-08-08 22:38:24','2021-08-08 22:38:24'),(20,1,200.0000,'cash','credit','sell',16,'2021-08-16 15:34:31','2021-08-16 15:34:31'),(21,1,0.0000,'cash','credit','sell',16,'2021-08-16 15:34:31','2021-08-16 15:34:31'),(22,1,250.0000,'cash','credit','sell',17,'2021-08-16 15:39:16','2021-08-16 15:39:16'),(23,1,0.0000,'cash','credit','sell',17,'2021-08-16 15:39:16','2021-08-16 15:39:16'),(26,2,50.0000,'cash','credit','sell',20,'2021-08-16 16:04:31','2021-08-16 16:04:31'),(27,2,0.0000,'cash','credit','sell',20,'2021-08-16 16:04:31','2021-08-16 16:04:31'),(28,3,100.0000,'cash','credit','initial',NULL,'2021-08-16 16:23:27','2021-08-16 16:23:27'),(31,2,200.0000,'cash','credit','sell',22,'2021-08-16 16:47:23','2021-08-16 16:47:23'),(32,2,0.0000,'cash','credit','sell',22,'2021-08-16 16:47:23','2021-08-16 16:47:23'),(33,2,3000.0000,'cash','credit','sell',23,'2021-08-16 17:55:06','2021-08-16 17:55:06'),(34,2,0.0000,'cash','credit','sell',23,'2021-08-16 17:55:06','2021-08-16 17:55:06'),(35,2,3000.0000,'cash','credit','sell',24,'2021-08-16 17:57:07','2021-08-16 17:57:07'),(36,2,0.0000,'cash','credit','sell',24,'2021-08-16 17:57:07','2021-08-16 17:57:07'),(37,3,500.0000,'cash','credit','sell',25,'2021-08-16 18:06:54','2021-08-16 18:06:54'),(38,3,0.0000,'cash','credit','sell',25,'2021-08-16 18:06:54','2021-08-16 18:06:54'),(49,3,300.0000,'cash','credit','sell',31,'2021-08-16 19:13:15','2021-08-16 19:13:15'),(50,3,0.0000,'cash','credit','sell',31,'2021-08-16 19:13:15','2021-08-16 19:13:15'),(51,3,200.0000,'cash','credit','sell',32,'2021-08-16 19:18:28','2021-08-16 19:18:28'),(52,3,0.0000,'cash','credit','sell',32,'2021-08-16 19:18:28','2021-08-16 19:18:28'),(53,3,100.0000,'cash','credit','sell',33,'2021-08-21 14:22:49','2021-08-21 14:22:49'),(54,3,0.0000,'cash','credit','sell',33,'2021-08-21 14:22:49','2021-08-21 14:22:49'),(57,3,1000.0000,'cash','credit','sell',35,'2021-08-22 21:12:56','2021-08-22 21:12:56'),(58,3,0.0000,'cash','credit','sell',35,'2021-08-22 21:12:56','2021-08-22 21:12:56'),(61,1,75.0000,'cash','credit','sell',37,'2021-08-23 21:50:22','2021-08-23 21:50:22'),(62,1,0.0000,'cash','credit','sell',37,'2021-08-23 21:50:22','2021-08-23 21:50:22'),(63,3,400.0000,'cash','credit','sell',38,'2021-08-23 22:02:05','2021-08-23 22:02:05'),(64,3,0.0000,'cash','credit','sell',38,'2021-08-23 22:02:05','2021-08-23 22:02:05'),(65,3,800.0000,'cash','credit','sell',39,'2021-08-24 12:07:52','2021-08-24 12:07:52'),(66,3,0.0000,'cash','credit','sell',39,'2021-08-24 12:07:52','2021-08-24 12:07:52'),(67,3,650.0000,'cash','credit','sell',40,'2021-08-24 12:12:20','2021-08-24 12:12:20'),(68,3,0.0000,'cash','credit','sell',40,'2021-08-24 12:12:20','2021-08-24 12:12:20'),(69,3,300.0000,'cash','credit','sell',41,'2021-08-24 12:15:51','2021-08-24 12:15:51'),(70,3,0.0000,'cash','credit','sell',41,'2021-08-24 12:15:51','2021-08-24 12:15:51'),(71,3,400.0000,'cash','credit','sell',42,'2021-08-24 12:21:09','2021-08-24 12:21:09'),(72,3,0.0000,'cash','credit','sell',42,'2021-08-24 12:21:09','2021-08-24 12:21:09'),(73,3,1.0000,'cash','credit','sell',43,'2021-08-24 12:24:48','2021-08-24 12:24:48'),(74,3,0.0000,'cash','credit','sell',43,'2021-08-24 12:24:48','2021-08-24 12:24:48'),(75,3,400.0000,'cash','credit','sell',44,'2021-08-24 12:25:45','2021-08-24 12:25:45'),(76,3,0.0000,'cash','credit','sell',44,'2021-08-24 12:25:45','2021-08-24 12:25:45'),(77,3,350.0000,'cash','credit','sell',45,'2021-08-24 12:27:51','2021-08-24 12:27:51'),(78,3,0.0000,'cash','credit','sell',45,'2021-08-24 12:27:51','2021-08-24 12:27:51'),(79,3,100.0000,'cash','credit','sell',46,'2021-08-24 12:58:30','2021-08-24 12:58:30'),(80,3,0.0000,'cash','credit','sell',46,'2021-08-24 12:58:30','2021-08-24 12:58:30'),(81,3,125.0000,'cash','credit','sell',47,'2021-08-24 16:24:45','2021-08-24 16:24:45'),(82,3,0.0000,'cash','credit','sell',47,'2021-08-24 16:24:45','2021-08-24 16:24:45'),(83,3,200.0000,'cash','credit','sell',48,'2021-08-24 17:50:38','2021-08-24 17:50:38'),(84,3,0.0000,'cash','credit','sell',48,'2021-08-24 17:50:38','2021-08-24 17:50:38'),(85,3,600.0000,'cash','credit','sell',49,'2021-08-24 19:05:27','2021-08-24 19:05:27'),(86,3,0.0000,'cash','credit','sell',49,'2021-08-24 19:05:27','2021-08-24 19:05:27'),(87,3,550.0000,'cash','credit','sell',50,'2021-08-24 19:13:28','2021-08-24 19:13:28'),(88,3,0.0000,'cash','credit','sell',50,'2021-08-24 19:13:28','2021-08-24 19:13:28'),(89,3,150.0000,'cash','credit','sell',51,'2021-08-24 19:38:33','2021-08-24 19:38:33'),(90,3,0.0000,'cash','credit','sell',51,'2021-08-24 19:38:33','2021-08-24 19:38:33'),(91,3,1000.0000,'cash','credit','sell',52,'2021-08-24 20:13:06','2021-08-24 20:13:06'),(92,3,0.0000,'cash','credit','sell',52,'2021-08-24 20:13:06','2021-08-24 20:13:06'),(93,3,700.0000,'cash','credit','sell',53,'2021-08-24 22:03:40','2021-08-24 22:03:40'),(94,3,0.0000,'cash','credit','sell',53,'2021-08-24 22:03:40','2021-08-24 22:03:40'),(95,3,800.0000,'cash','credit','sell',54,'2021-08-24 22:10:36','2021-08-24 22:10:36'),(96,3,0.0000,'cash','credit','sell',54,'2021-08-24 22:10:36','2021-08-24 22:10:36'),(97,3,1000.0000,'cash','credit','sell',55,'2021-08-24 23:32:46','2021-08-24 23:32:46'),(98,3,-900.0000,'cash','credit','sell',55,'2021-08-24 23:32:46','2021-08-24 23:32:46'),(99,3,0.0000,'cash','credit','sell',55,'2021-08-24 23:32:46','2021-08-24 23:32:46'),(100,3,100.0000,'cash','credit','sell',56,'2021-08-24 23:35:47','2021-08-24 23:35:47'),(101,3,0.0000,'cash','credit','sell',56,'2021-08-24 23:35:47','2021-08-24 23:35:47'),(102,3,75.0000,'cash','credit','sell',57,'2021-08-25 12:56:15','2021-08-25 12:56:15'),(103,3,0.0000,'cash','credit','sell',57,'2021-08-25 12:56:15','2021-08-25 12:56:15'),(104,3,100.0000,'cash','credit','sell',58,'2021-08-25 12:58:28','2021-08-25 12:58:28'),(105,3,0.0000,'cash','credit','sell',58,'2021-08-25 12:58:28','2021-08-25 12:58:28'),(106,3,500.0000,'cash','credit','sell',59,'2021-08-25 14:20:21','2021-08-25 14:20:21'),(107,3,0.0000,'cash','credit','sell',59,'2021-08-25 14:20:21','2021-08-25 14:20:21'),(108,3,150.0000,'cash','credit','sell',60,'2021-08-25 15:08:46','2021-08-25 15:08:46'),(109,3,0.0000,'cash','credit','sell',60,'2021-08-25 15:08:46','2021-08-25 15:08:46'),(110,3,400.0000,'cash','credit','sell',61,'2021-08-25 15:25:53','2021-08-25 15:25:53'),(111,3,0.0000,'cash','credit','sell',61,'2021-08-25 15:25:53','2021-08-25 15:25:53'),(112,3,150.0000,'cash','credit','sell',62,'2021-08-25 18:42:55','2021-08-25 18:42:55'),(113,3,0.0000,'cash','credit','sell',62,'2021-08-25 18:42:55','2021-08-25 18:42:55'),(114,3,150.0000,'cash','credit','sell',63,'2021-08-25 20:47:15','2021-08-25 20:47:15'),(115,3,0.0000,'cash','credit','sell',63,'2021-08-25 20:47:15','2021-08-25 20:47:15'),(116,3,600.0000,'cash','credit','sell',64,'2021-08-25 21:34:49','2021-08-25 21:34:49'),(117,3,0.0000,'cash','credit','sell',64,'2021-08-25 21:34:49','2021-08-25 21:34:49'),(118,3,375.0000,'cash','credit','sell',65,'2021-08-25 21:38:02','2021-08-25 21:38:02'),(119,3,0.0000,'cash','credit','sell',65,'2021-08-25 21:38:02','2021-08-25 21:38:02'),(120,3,150.0000,'cash','credit','sell',66,'2021-08-25 21:58:32','2021-08-25 21:58:32'),(121,3,0.0000,'cash','credit','sell',66,'2021-08-25 21:58:32','2021-08-25 21:58:32'),(122,3,400.0000,'cash','credit','sell',67,'2021-08-25 22:04:37','2021-08-25 22:04:37'),(123,3,0.0000,'cash','credit','sell',67,'2021-08-25 22:04:37','2021-08-25 22:04:37'),(124,3,400.0000,'cash','credit','sell',68,'2021-08-25 22:26:02','2021-08-25 22:26:02'),(125,3,0.0000,'cash','credit','sell',68,'2021-08-25 22:26:02','2021-08-25 22:26:02'),(129,3,175.0000,'cash','credit','sell',70,'2021-08-26 15:58:01','2021-08-26 15:58:01'),(130,3,0.0000,'cash','credit','sell',70,'2021-08-26 15:58:01','2021-08-26 15:58:01'),(131,3,100.0000,'cash','credit','sell',71,'2021-08-28 18:39:46','2021-08-28 18:39:46'),(132,3,0.0000,'cash','credit','sell',71,'2021-08-28 18:39:46','2021-08-28 18:39:46'),(133,3,1100.0000,'cash','credit','sell',72,'2021-08-29 15:18:38','2021-08-29 15:18:38'),(134,3,0.0000,'cash','credit','sell',72,'2021-08-29 15:18:38','2021-08-29 15:18:38'),(135,3,900.0000,'cash','credit','sell',73,'2021-08-29 16:28:16','2021-08-29 16:28:16'),(136,3,0.0000,'cash','credit','sell',73,'2021-08-29 16:28:16','2021-08-29 16:28:16'),(137,3,1300.0000,'cash','credit','sell',74,'2021-08-29 16:29:05','2021-08-29 16:29:05'),(138,3,0.0000,'cash','credit','sell',74,'2021-08-29 16:29:05','2021-08-29 16:29:05'),(139,3,300.0000,'cash','credit','sell',75,'2021-08-29 16:30:52','2021-08-29 16:30:52'),(140,3,0.0000,'cash','credit','sell',75,'2021-08-29 16:30:52','2021-08-29 16:30:52'),(141,3,350.0000,'cash','credit','sell',76,'2021-08-29 16:35:03','2021-08-29 16:35:03'),(142,3,0.0000,'cash','credit','sell',76,'2021-08-29 16:35:03','2021-08-29 16:35:03'),(143,3,350.0000,'cash','credit','sell',77,'2021-08-29 16:38:09','2021-08-29 16:38:09'),(144,3,0.0000,'cash','credit','sell',77,'2021-08-29 16:38:09','2021-08-29 16:38:09'),(145,3,400.0000,'cash','credit','sell',78,'2021-08-29 16:45:03','2021-08-29 16:45:03'),(146,3,0.0000,'cash','credit','sell',78,'2021-08-29 16:45:03','2021-08-29 16:45:03'),(147,3,400.0000,'cash','credit','sell',79,'2021-08-29 16:47:59','2021-08-29 16:47:59'),(148,3,0.0000,'cash','credit','sell',79,'2021-08-29 16:47:59','2021-08-29 16:47:59'),(149,3,300.0000,'cash','credit','sell',80,'2021-08-29 16:51:06','2021-08-29 16:51:06'),(150,3,0.0000,'cash','credit','sell',80,'2021-08-29 16:51:06','2021-08-29 16:51:06'),(151,3,550.0000,'cash','credit','sell',81,'2021-08-29 16:54:19','2021-08-29 16:54:19'),(152,3,0.0000,'cash','credit','sell',81,'2021-08-29 16:54:19','2021-08-29 16:54:19'),(153,3,100.0000,'cash','credit','sell',82,'2021-08-29 18:59:03','2021-08-29 18:59:03'),(154,3,0.0000,'cash','credit','sell',82,'2021-08-29 18:59:03','2021-08-29 18:59:03'),(155,3,100.0000,'cash','credit','sell',83,'2021-08-29 20:51:06','2021-08-29 20:51:06'),(156,3,0.0000,'cash','credit','sell',83,'2021-08-29 20:51:06','2021-08-29 20:51:06'),(157,3,150.0000,'cash','credit','sell',84,'2021-08-29 20:55:13','2021-08-29 20:55:13'),(158,3,0.0000,'cash','credit','sell',84,'2021-08-29 20:55:13','2021-08-29 20:55:13'),(159,3,500.0000,'cash','credit','sell',85,'2021-08-29 21:41:38','2021-08-29 21:41:38'),(160,3,0.0000,'cash','credit','sell',85,'2021-08-29 21:41:38','2021-08-29 21:41:38'),(161,3,500.0000,'cash','credit','sell',86,'2021-08-30 13:29:09','2021-08-30 13:29:09'),(162,3,0.0000,'cash','credit','sell',86,'2021-08-30 13:29:09','2021-08-30 13:29:09'),(163,3,175.0000,'cash','credit','sell',87,'2021-08-30 15:07:25','2021-08-30 15:07:25'),(164,3,0.0000,'cash','credit','sell',87,'2021-08-30 15:07:25','2021-08-30 15:07:25'),(165,3,500.0000,'cash','credit','sell',88,'2021-08-30 15:33:23','2021-08-30 15:33:23'),(166,3,0.0000,'cash','credit','sell',88,'2021-08-30 15:33:23','2021-08-30 15:33:23'),(167,3,400.0000,'cash','credit','sell',89,'2021-08-30 15:48:08','2021-08-30 15:48:08'),(168,3,0.0000,'cash','credit','sell',89,'2021-08-30 15:48:08','2021-08-30 15:48:08'),(169,3,400.0000,'cash','credit','sell',90,'2021-08-30 17:29:06','2021-08-30 17:29:06'),(170,3,0.0000,'cash','credit','sell',90,'2021-08-30 17:29:06','2021-08-30 17:29:06'),(171,3,1800.0000,'cash','credit','sell',91,'2021-08-30 20:39:44','2021-08-30 20:39:44'),(172,3,0.0000,'cash','credit','sell',91,'2021-08-30 20:39:44','2021-08-30 20:39:44'),(173,3,100.0000,'cash','credit','sell',92,'2021-08-30 20:42:00','2021-08-30 20:42:00'),(174,3,0.0000,'cash','credit','sell',92,'2021-08-30 20:42:00','2021-08-30 20:42:00'),(175,3,600.0000,'cash','credit','sell',93,'2021-08-30 20:43:02','2021-08-30 20:43:02'),(176,3,0.0000,'cash','credit','sell',93,'2021-08-30 20:43:02','2021-08-30 20:43:02'),(177,3,400.0000,'cash','credit','sell',94,'2021-08-30 20:44:33','2021-08-30 20:44:33'),(178,3,0.0000,'cash','credit','sell',94,'2021-08-30 20:44:33','2021-08-30 20:44:33'),(179,3,400.0000,'cash','credit','sell',95,'2021-08-30 20:46:11','2021-08-30 20:46:11'),(180,3,0.0000,'cash','credit','sell',95,'2021-08-30 20:46:11','2021-08-30 20:46:11'),(181,3,150.0000,'cash','credit','sell',96,'2021-08-31 14:13:45','2021-08-31 14:13:45'),(182,3,0.0000,'cash','credit','sell',96,'2021-08-31 14:13:45','2021-08-31 14:13:45'),(183,3,75.0000,'cash','credit','sell',97,'2021-08-31 14:21:26','2021-08-31 14:21:26'),(184,3,0.0000,'cash','credit','sell',97,'2021-08-31 14:21:26','2021-08-31 14:21:26'),(185,3,600.0000,'cash','credit','sell',98,'2021-08-31 14:23:25','2021-08-31 14:23:25'),(186,3,0.0000,'cash','credit','sell',98,'2021-08-31 14:23:25','2021-08-31 14:23:25'),(187,3,800.0000,'cash','credit','sell',99,'2021-08-31 14:25:10','2021-08-31 14:25:10'),(188,3,0.0000,'cash','credit','sell',99,'2021-08-31 14:25:10','2021-08-31 14:25:10'),(189,3,750.0000,'cash','credit','sell',100,'2021-08-31 14:31:39','2021-08-31 14:31:39'),(190,3,0.0000,'cash','credit','sell',100,'2021-08-31 14:31:39','2021-08-31 14:31:39'),(191,3,1000.0000,'cash','credit','sell',101,'2021-08-31 14:33:48','2021-08-31 14:33:48'),(192,3,0.0000,'cash','credit','sell',101,'2021-08-31 14:33:48','2021-08-31 14:33:48'),(193,3,250.0000,'cash','credit','sell',102,'2021-08-31 14:41:23','2021-08-31 14:41:23'),(194,3,0.0000,'cash','credit','sell',102,'2021-08-31 14:41:23','2021-08-31 14:41:23'),(195,3,250.0000,'cash','credit','sell',103,'2021-08-31 19:19:32','2021-08-31 19:19:32'),(196,3,0.0000,'cash','credit','sell',103,'2021-08-31 19:19:32','2021-08-31 19:19:32'),(199,3,300.0000,'cash','credit','sell',105,'2021-08-31 20:25:21','2021-08-31 20:25:21'),(200,3,0.0000,'cash','credit','sell',105,'2021-08-31 20:25:21','2021-08-31 20:25:21'),(201,3,400.0000,'cash','credit','sell',106,'2021-08-31 20:49:36','2021-08-31 20:49:36'),(202,3,0.0000,'cash','credit','sell',106,'2021-08-31 20:49:36','2021-08-31 20:49:36'),(203,3,500.0000,'cash','credit','sell',107,'2021-08-31 21:26:51','2021-08-31 21:26:51'),(204,3,0.0000,'cash','credit','sell',107,'2021-08-31 21:26:51','2021-08-31 21:26:51'),(205,3,450.0000,'cash','credit','sell',108,'2021-08-31 21:49:10','2021-08-31 21:49:10'),(206,3,0.0000,'cash','credit','sell',108,'2021-08-31 21:49:10','2021-08-31 21:49:10'),(207,3,300.0000,'cash','credit','sell',109,'2021-08-31 22:16:51','2021-08-31 22:16:51'),(208,3,0.0000,'cash','credit','sell',109,'2021-08-31 22:16:51','2021-08-31 22:16:51'),(209,3,750.0000,'cash','credit','sell',110,'2021-08-31 22:49:20','2021-08-31 22:49:20'),(210,3,0.0000,'cash','credit','sell',110,'2021-08-31 22:49:20','2021-08-31 22:49:20'),(211,3,250.0000,'cash','credit','sell',111,'2021-09-01 15:49:48','2021-09-01 15:49:48'),(212,3,0.0000,'cash','credit','sell',111,'2021-09-01 15:49:48','2021-09-01 15:49:48'),(213,3,250.0000,'cash','credit','sell',112,'2021-09-01 15:51:41','2021-09-01 15:51:41'),(214,3,0.0000,'cash','credit','sell',112,'2021-09-01 15:51:41','2021-09-01 15:51:41'),(215,3,400.0000,'cash','credit','sell',113,'2021-09-01 15:52:56','2021-09-01 15:52:56'),(216,3,0.0000,'cash','credit','sell',113,'2021-09-01 15:52:56','2021-09-01 15:52:56'),(217,3,500.0000,'cash','credit','sell',114,'2021-09-01 16:02:17','2021-09-01 16:02:17'),(218,3,0.0000,'cash','credit','sell',114,'2021-09-01 16:02:17','2021-09-01 16:02:17'),(219,3,400.0000,'cash','credit','sell',115,'2021-09-01 16:07:54','2021-09-01 16:07:54'),(220,3,0.0000,'cash','credit','sell',115,'2021-09-01 16:07:54','2021-09-01 16:07:54'),(221,3,450.0000,'cash','credit','sell',116,'2021-09-01 16:55:00','2021-09-01 16:55:00'),(222,3,0.0000,'cash','credit','sell',116,'2021-09-01 16:55:00','2021-09-01 16:55:00'),(223,3,100.0000,'cash','credit','sell',117,'2021-09-01 17:45:18','2021-09-01 17:45:18'),(224,3,0.0000,'cash','credit','sell',117,'2021-09-01 17:45:18','2021-09-01 17:45:18'),(225,3,550.0000,'cash','credit','sell',118,'2021-09-01 17:48:40','2021-09-01 17:48:40'),(226,3,0.0000,'cash','credit','sell',118,'2021-09-01 17:48:40','2021-09-01 17:48:40'),(227,3,800.0000,'cash','credit','sell',119,'2021-09-01 18:22:51','2021-09-01 18:22:51'),(228,3,0.0000,'cash','credit','sell',119,'2021-09-01 18:22:51','2021-09-01 18:22:51'),(229,3,250.0000,'cash','credit','sell',120,'2021-09-01 19:05:20','2021-09-01 19:05:20'),(230,3,0.0000,'cash','credit','sell',120,'2021-09-01 19:05:20','2021-09-01 19:05:20'),(231,3,300.0000,'cash','credit','sell',121,'2021-09-01 19:28:04','2021-09-01 19:28:04'),(232,3,0.0000,'cash','credit','sell',121,'2021-09-01 19:28:04','2021-09-01 19:28:04'),(233,3,400.0000,'cash','credit','sell',122,'2021-09-01 19:40:05','2021-09-01 19:40:05'),(234,3,0.0000,'cash','credit','sell',122,'2021-09-01 19:40:05','2021-09-01 19:40:05'),(235,3,150.0000,'cash','credit','sell',123,'2021-09-01 20:26:41','2021-09-01 20:26:41'),(236,3,0.0000,'cash','credit','sell',123,'2021-09-01 20:26:41','2021-09-01 20:26:41'),(237,3,700.0000,'cash','credit','sell',124,'2021-09-01 21:54:40','2021-09-01 21:54:40'),(238,3,0.0000,'cash','credit','sell',124,'2021-09-01 21:54:40','2021-09-01 21:54:40'),(239,3,100.0000,'cash','credit','sell',125,'2021-09-01 21:56:43','2021-09-01 21:56:43'),(240,3,0.0000,'cash','credit','sell',125,'2021-09-01 21:56:43','2021-09-01 21:56:43'),(241,3,25.0000,'cash','credit','sell',126,'2021-09-01 22:00:53','2021-09-01 22:00:53'),(242,3,0.0000,'cash','credit','sell',126,'2021-09-01 22:00:53','2021-09-01 22:00:53'),(243,3,25.0000,'cash','credit','sell',127,'2021-09-01 22:03:29','2021-09-01 22:03:29'),(244,3,0.0000,'cash','credit','sell',127,'2021-09-01 22:03:29','2021-09-01 22:03:29'),(245,3,950.0000,'cash','credit','sell',128,'2021-09-01 22:04:28','2021-09-01 22:04:28'),(246,3,0.0000,'cash','credit','sell',128,'2021-09-01 22:04:28','2021-09-01 22:04:28'),(247,3,950.0000,'cash','credit','sell',129,'2021-09-01 23:06:57','2021-09-01 23:06:57'),(248,3,0.0000,'cash','credit','sell',129,'2021-09-01 23:06:57','2021-09-01 23:06:57'),(249,3,100.0000,'cash','credit','sell',130,'2021-09-02 14:06:44','2021-09-02 14:06:44'),(250,3,0.0000,'cash','credit','sell',130,'2021-09-02 14:06:44','2021-09-02 14:06:44'),(251,3,1000.0000,'cash','credit','sell',131,'2021-09-02 20:57:12','2021-09-02 20:57:12'),(252,3,0.0000,'cash','credit','sell',131,'2021-09-02 20:57:12','2021-09-02 20:57:12'),(253,3,750.0000,'cash','credit','sell',132,'2021-09-02 20:58:02','2021-09-02 20:58:02'),(254,3,0.0000,'cash','credit','sell',132,'2021-09-02 20:58:02','2021-09-02 20:58:02'),(255,3,200.0000,'cash','credit','sell',133,'2021-09-02 21:09:48','2021-09-02 21:09:48'),(256,3,0.0000,'cash','credit','sell',133,'2021-09-02 21:09:48','2021-09-02 21:09:48'),(257,3,900.0000,'cash','credit','sell',134,'2021-09-02 21:21:42','2021-09-02 21:21:42'),(258,3,0.0000,'cash','credit','sell',134,'2021-09-02 21:21:42','2021-09-02 21:21:42'),(259,3,550.0000,'cash','credit','sell',135,'2021-09-02 21:58:02','2021-09-02 21:58:02'),(260,3,0.0000,'cash','credit','sell',135,'2021-09-02 21:58:02','2021-09-02 21:58:02'),(261,3,20.0000,'cash','credit','sell',136,'2021-09-02 22:41:38','2021-09-02 22:41:38'),(262,3,0.0000,'cash','credit','sell',136,'2021-09-02 22:41:38','2021-09-02 22:41:38'),(263,3,100.0000,'cash','credit','sell',137,'2021-09-02 23:14:00','2021-09-02 23:14:00'),(264,3,0.0000,'cash','credit','sell',137,'2021-09-02 23:14:00','2021-09-02 23:14:00'),(265,3,450.0000,'cash','credit','sell',138,'2021-09-03 20:11:41','2021-09-03 20:11:41'),(266,3,0.0000,'cash','credit','sell',138,'2021-09-03 20:11:41','2021-09-03 20:11:41'),(267,3,100.0000,'cash','credit','sell',139,'2021-09-04 15:04:55','2021-09-04 15:04:55'),(268,3,0.0000,'cash','credit','sell',139,'2021-09-04 15:04:55','2021-09-04 15:04:55'),(269,3,350.0000,'cash','credit','sell',140,'2021-09-04 16:29:44','2021-09-04 16:29:44'),(270,3,0.0000,'cash','credit','sell',140,'2021-09-04 16:29:44','2021-09-04 16:29:44'),(271,3,400.0000,'cash','credit','sell',141,'2021-09-04 18:25:44','2021-09-04 18:25:44'),(272,3,0.0000,'cash','credit','sell',141,'2021-09-04 18:25:44','2021-09-04 18:25:44'),(273,3,300.0000,'cash','credit','sell',142,'2021-09-04 18:36:16','2021-09-04 18:36:16'),(274,3,0.0000,'cash','credit','sell',142,'2021-09-04 18:36:16','2021-09-04 18:36:16'),(275,3,100.0000,'cash','credit','sell',143,'2021-09-04 19:04:03','2021-09-04 19:04:03'),(276,3,0.0000,'cash','credit','sell',143,'2021-09-04 19:04:03','2021-09-04 19:04:03'),(277,3,350.0000,'cash','credit','sell',144,'2021-09-04 19:44:05','2021-09-04 19:44:05'),(278,3,0.0000,'cash','credit','sell',144,'2021-09-04 19:44:05','2021-09-04 19:44:05'),(279,3,300.0000,'cash','credit','sell',145,'2021-09-04 20:03:32','2021-09-04 20:03:32'),(280,3,0.0000,'cash','credit','sell',145,'2021-09-04 20:03:32','2021-09-04 20:03:32'),(281,3,100.0000,'cash','credit','sell',146,'2021-09-04 21:33:03','2021-09-04 21:33:03'),(282,3,0.0000,'cash','credit','sell',146,'2021-09-04 21:33:03','2021-09-04 21:33:03'),(283,3,100.0000,'cash','credit','sell',147,'2021-09-04 21:51:56','2021-09-04 21:51:56'),(284,3,0.0000,'cash','credit','sell',147,'2021-09-04 21:51:56','2021-09-04 21:51:56'),(285,3,350.0000,'cash','credit','sell',148,'2021-09-04 21:57:30','2021-09-04 21:57:30'),(286,3,0.0000,'cash','credit','sell',148,'2021-09-04 21:57:30','2021-09-04 21:57:30'),(287,3,300.0000,'cash','credit','sell',149,'2021-09-04 22:31:57','2021-09-04 22:31:57'),(288,3,0.0000,'cash','credit','sell',149,'2021-09-04 22:31:57','2021-09-04 22:31:57'),(289,3,1800.0000,'cash','credit','sell',150,'2021-09-04 23:10:00','2021-09-04 23:10:00'),(290,3,0.0000,'cash','credit','sell',150,'2021-09-04 23:10:00','2021-09-04 23:10:00'),(291,3,100.0000,'cash','credit','sell',151,'2021-09-05 16:19:52','2021-09-05 16:19:52'),(292,3,0.0000,'cash','credit','sell',151,'2021-09-05 16:19:52','2021-09-05 16:19:52'),(293,3,900.0000,'cash','credit','sell',152,'2021-09-05 17:30:08','2021-09-05 17:30:08'),(294,3,0.0000,'cash','credit','sell',152,'2021-09-05 17:30:08','2021-09-05 17:30:08'),(295,3,200.0000,'cash','credit','sell',153,'2021-09-05 18:12:51','2021-09-05 18:12:51'),(296,3,0.0000,'cash','credit','sell',153,'2021-09-05 18:12:51','2021-09-05 18:12:51'),(297,3,550.0000,'cash','credit','sell',154,'2021-09-05 18:53:59','2021-09-05 18:53:59'),(298,3,0.0000,'cash','credit','sell',154,'2021-09-05 18:53:59','2021-09-05 18:53:59'),(299,3,200.0000,'cash','credit','sell',155,'2021-09-05 20:33:12','2021-09-05 20:33:12'),(300,3,0.0000,'cash','credit','sell',155,'2021-09-05 20:33:12','2021-09-05 20:33:12'),(301,3,500.0000,'cash','credit','sell',156,'2021-09-05 20:36:09','2021-09-05 20:36:09'),(302,3,0.0000,'cash','credit','sell',156,'2021-09-05 20:36:09','2021-09-05 20:36:09'),(303,3,300.0000,'cash','credit','sell',157,'2021-09-05 20:38:37','2021-09-05 20:38:37'),(304,3,0.0000,'cash','credit','sell',157,'2021-09-05 20:38:37','2021-09-05 20:38:37'),(305,3,750.0000,'cash','credit','sell',158,'2021-09-05 20:56:47','2021-09-05 20:56:47'),(306,3,0.0000,'cash','credit','sell',158,'2021-09-05 20:56:47','2021-09-05 20:56:47'),(307,3,2500.0000,'cash','credit','sell',159,'2021-09-05 21:19:28','2021-09-05 21:19:28'),(308,3,0.0000,'cash','credit','sell',159,'2021-09-05 21:19:28','2021-09-05 21:19:28'),(309,3,500.0000,'cash','credit','sell',160,'2021-09-05 21:20:49','2021-09-05 21:20:49'),(310,3,0.0000,'cash','credit','sell',160,'2021-09-05 21:20:49','2021-09-05 21:20:49'),(311,3,1000.0000,'cash','credit','sell',161,'2021-09-05 21:22:08','2021-09-05 21:22:08'),(312,3,0.0000,'cash','credit','sell',161,'2021-09-05 21:22:08','2021-09-05 21:22:08'),(315,3,800.0000,'cash','credit','sell',163,'2021-09-05 21:52:26','2021-09-05 21:52:26'),(316,3,0.0000,'cash','credit','sell',163,'2021-09-05 21:52:26','2021-09-05 21:52:26'),(317,3,200.0000,'cash','credit','sell',164,'2021-09-05 22:02:23','2021-09-05 22:02:23'),(318,3,0.0000,'cash','credit','sell',164,'2021-09-05 22:02:23','2021-09-05 22:02:23'),(319,3,600.0000,'cash','credit','sell',165,'2021-09-05 22:05:45','2021-09-05 22:05:45'),(320,3,0.0000,'cash','credit','sell',165,'2021-09-05 22:05:45','2021-09-05 22:05:45'),(321,3,125.0000,'cash','credit','sell',166,'2021-09-06 13:29:30','2021-09-06 13:29:30'),(322,3,0.0000,'cash','credit','sell',166,'2021-09-06 13:29:30','2021-09-06 13:29:30'),(323,3,400.0000,'cash','credit','sell',167,'2021-09-06 14:31:04','2021-09-06 14:31:04'),(324,3,0.0000,'cash','credit','sell',167,'2021-09-06 14:31:04','2021-09-06 14:31:04'),(325,3,100.0000,'cash','credit','sell',168,'2021-09-06 15:21:19','2021-09-06 15:21:19'),(326,3,0.0000,'cash','credit','sell',168,'2021-09-06 15:21:19','2021-09-06 15:21:19'),(327,3,550.0000,'cash','credit','sell',169,'2021-09-06 15:25:49','2021-09-06 15:25:49'),(328,3,0.0000,'cash','credit','sell',169,'2021-09-06 15:25:49','2021-09-06 15:25:49'),(329,3,900.0000,'cash','credit','sell',170,'2021-09-06 15:29:24','2021-09-06 15:29:24'),(330,3,0.0000,'cash','credit','sell',170,'2021-09-06 15:29:24','2021-09-06 15:29:24'),(333,3,300.0000,'cash','credit','sell',172,'2021-09-06 17:15:12','2021-09-06 17:15:12'),(334,3,0.0000,'cash','credit','sell',172,'2021-09-06 17:15:12','2021-09-06 17:15:12'),(335,3,1000.0000,'cash','credit','sell',173,'2021-09-06 17:25:00','2021-09-06 17:25:00'),(336,3,0.0000,'cash','credit','sell',173,'2021-09-06 17:25:00','2021-09-06 17:25:00'),(337,3,75.0000,'cash','credit','sell',174,'2021-09-06 19:41:24','2021-09-06 19:41:24'),(338,3,0.0000,'cash','credit','sell',174,'2021-09-06 19:41:24','2021-09-06 19:41:24'),(339,3,400.0000,'cash','credit','sell',175,'2021-09-06 21:12:03','2021-09-06 21:12:03'),(340,3,0.0000,'cash','credit','sell',175,'2021-09-06 21:12:03','2021-09-06 21:12:03'),(341,3,1800.0000,'cash','credit','sell',176,'2021-09-06 21:44:32','2021-09-06 21:44:32'),(342,3,0.0000,'cash','credit','sell',176,'2021-09-06 21:44:32','2021-09-06 21:44:32'),(343,3,700.0000,'cash','credit','sell',177,'2021-09-06 21:45:19','2021-09-06 21:45:19'),(344,3,0.0000,'cash','credit','sell',177,'2021-09-06 21:45:19','2021-09-06 21:45:19'),(345,3,200.0000,'cash','credit','sell',178,'2021-09-06 21:46:29','2021-09-06 21:46:29'),(346,3,0.0000,'cash','credit','sell',178,'2021-09-06 21:46:29','2021-09-06 21:46:29'),(347,3,800.0000,'cash','credit','sell',179,'2021-09-06 21:48:02','2021-09-06 21:48:02'),(348,3,0.0000,'cash','credit','sell',179,'2021-09-06 21:48:02','2021-09-06 21:48:02'),(349,3,25.0000,'cash','credit','sell',180,'2021-09-06 21:49:31','2021-09-06 21:49:31'),(350,3,0.0000,'cash','credit','sell',180,'2021-09-06 21:49:31','2021-09-06 21:49:31'),(351,3,200.0000,'cash','credit','sell',181,'2021-09-06 22:00:18','2021-09-06 22:00:18'),(352,3,0.0000,'cash','credit','sell',181,'2021-09-06 22:00:18','2021-09-06 22:00:18'),(353,3,700.0000,'cash','credit','sell',182,'2021-09-06 22:03:15','2021-09-06 22:03:15'),(354,3,0.0000,'cash','credit','sell',182,'2021-09-06 22:03:15','2021-09-06 22:03:15'),(355,3,1000.0000,'cash','credit','sell',183,'2021-09-07 17:19:35','2021-09-07 17:19:35'),(356,3,0.0000,'cash','credit','sell',183,'2021-09-07 17:19:35','2021-09-07 17:19:35'),(357,3,100.0000,'cash','credit','sell',184,'2021-09-07 17:20:23','2021-09-07 17:20:23'),(358,3,0.0000,'cash','credit','sell',184,'2021-09-07 17:20:23','2021-09-07 17:20:23'),(359,3,300.0000,'cash','credit','sell',185,'2021-09-07 18:28:44','2021-09-07 18:28:44'),(360,3,0.0000,'cash','credit','sell',185,'2021-09-07 18:28:44','2021-09-07 18:28:44'),(361,3,800.0000,'cash','credit','sell',186,'2021-09-07 18:58:24','2021-09-07 18:58:24'),(362,3,0.0000,'cash','credit','sell',186,'2021-09-07 18:58:24','2021-09-07 18:58:24'),(363,3,125.0000,'cash','credit','sell',187,'2021-09-07 19:28:26','2021-09-07 19:28:26'),(364,3,0.0000,'cash','credit','sell',187,'2021-09-07 19:28:26','2021-09-07 19:28:26'),(365,3,50.0000,'cash','credit','sell',188,'2021-09-07 19:29:08','2021-09-07 19:29:08'),(366,3,0.0000,'cash','credit','sell',188,'2021-09-07 19:29:08','2021-09-07 19:29:08'),(367,3,1200.0000,'cash','credit','sell',189,'2021-09-07 19:30:38','2021-09-07 19:30:38'),(368,3,0.0000,'cash','credit','sell',189,'2021-09-07 19:30:38','2021-09-07 19:30:38'),(369,3,100.0000,'cash','credit','sell',190,'2021-09-07 19:31:32','2021-09-07 19:31:32'),(370,3,0.0000,'cash','credit','sell',190,'2021-09-07 19:31:32','2021-09-07 19:31:32'),(371,3,250.0000,'cash','credit','sell',191,'2021-09-07 20:47:28','2021-09-07 20:47:28'),(372,3,0.0000,'cash','credit','sell',191,'2021-09-07 20:47:28','2021-09-07 20:47:28'),(373,3,125.0000,'cash','credit','sell',192,'2021-09-07 20:59:07','2021-09-07 20:59:07'),(374,3,0.0000,'cash','credit','sell',192,'2021-09-07 20:59:07','2021-09-07 20:59:07'),(375,3,400.0000,'cash','credit','sell',193,'2021-09-07 21:25:37','2021-09-07 21:25:37'),(376,3,0.0000,'cash','credit','sell',193,'2021-09-07 21:25:37','2021-09-07 21:25:37'),(377,3,200.0000,'cash','credit','sell',194,'2021-09-07 21:33:21','2021-09-07 21:33:21'),(378,3,0.0000,'cash','credit','sell',194,'2021-09-07 21:33:21','2021-09-07 21:33:21'),(379,3,25.0000,'cash','credit','sell',195,'2021-09-07 21:36:03','2021-09-07 21:36:03'),(380,3,0.0000,'cash','credit','sell',195,'2021-09-07 21:36:03','2021-09-07 21:36:03'),(381,3,100.0000,'cash','credit','sell',196,'2021-09-07 22:08:51','2021-09-07 22:08:51'),(382,3,0.0000,'cash','credit','sell',196,'2021-09-07 22:08:51','2021-09-07 22:08:51'),(383,3,150.0000,'cash','credit','sell',197,'2021-09-08 15:39:28','2021-09-08 15:39:28'),(384,3,0.0000,'cash','credit','sell',197,'2021-09-08 15:39:28','2021-09-08 15:39:28'),(385,3,500.0000,'cash','credit','sell',198,'2021-09-08 16:07:15','2021-09-08 16:07:15'),(386,3,0.0000,'cash','credit','sell',198,'2021-09-08 16:07:15','2021-09-08 16:07:15'),(387,3,50.0000,'cash','credit','sell',199,'2021-09-08 17:12:13','2021-09-08 17:12:13'),(388,3,0.0000,'cash','credit','sell',199,'2021-09-08 17:12:13','2021-09-08 17:12:13'),(389,3,350.0000,'cash','credit','sell',200,'2021-09-08 17:28:23','2021-09-08 17:28:23'),(390,3,0.0000,'cash','credit','sell',200,'2021-09-08 17:28:23','2021-09-08 17:28:23'),(391,3,550.0000,'cash','credit','sell',201,'2021-09-08 18:20:32','2021-09-08 18:20:32'),(392,3,0.0000,'cash','credit','sell',201,'2021-09-08 18:20:32','2021-09-08 18:20:32'),(395,3,100.0000,'cash','credit','sell',203,'2021-09-08 19:12:56','2021-09-08 19:12:56'),(396,3,0.0000,'cash','credit','sell',203,'2021-09-08 19:12:56','2021-09-08 19:12:56'),(397,3,250.0000,'cash','credit','sell',204,'2021-09-08 20:56:34','2021-09-08 20:56:34'),(398,3,0.0000,'cash','credit','sell',204,'2021-09-08 20:56:34','2021-09-08 20:56:34'),(399,3,2000.0000,'cash','credit','sell',205,'2021-09-08 21:50:37','2021-09-08 21:50:37'),(400,3,0.0000,'cash','credit','sell',205,'2021-09-08 21:50:37','2021-09-08 21:50:37'),(401,3,2500.0000,'cash','credit','sell',206,'2021-09-08 22:15:04','2021-09-08 22:15:04'),(402,3,0.0000,'cash','credit','sell',206,'2021-09-08 22:15:04','2021-09-08 22:15:04'),(403,3,1150.0000,'cash','credit','sell',207,'2021-09-08 22:18:28','2021-09-08 22:18:28'),(404,3,0.0000,'cash','credit','sell',207,'2021-09-08 22:18:28','2021-09-08 22:18:28'),(405,3,900.0000,'cash','credit','sell',208,'2021-09-09 00:04:58','2021-09-09 00:04:58'),(406,3,0.0000,'cash','credit','sell',208,'2021-09-09 00:04:58','2021-09-09 00:04:58'),(407,3,300.0000,'cash','credit','sell',209,'2021-09-09 00:06:39','2021-09-09 00:06:39'),(408,3,0.0000,'cash','credit','sell',209,'2021-09-09 00:06:39','2021-09-09 00:06:39'),(409,3,1000.0000,'cash','credit','sell',210,'2021-09-09 12:49:50','2021-09-09 12:49:50'),(410,3,0.0000,'cash','credit','sell',210,'2021-09-09 12:49:50','2021-09-09 12:49:50'),(411,3,750.0000,'cash','credit','sell',211,'2021-09-09 13:55:26','2021-09-09 13:55:26'),(412,3,0.0000,'cash','credit','sell',211,'2021-09-09 13:55:26','2021-09-09 13:55:26'),(415,3,725.0000,'cash','credit','sell',213,'2021-09-09 15:00:04','2021-09-09 15:00:04'),(416,3,0.0000,'cash','credit','sell',213,'2021-09-09 15:00:04','2021-09-09 15:00:04'),(417,3,1000.0000,'cash','credit','sell',214,'2021-09-09 15:53:40','2021-09-09 15:53:40'),(418,3,0.0000,'cash','credit','sell',214,'2021-09-09 15:53:40','2021-09-09 15:53:40'),(419,3,125.0000,'cash','credit','sell',215,'2021-09-09 17:16:52','2021-09-09 17:16:52'),(420,3,0.0000,'cash','credit','sell',215,'2021-09-09 17:16:52','2021-09-09 17:16:52'),(421,3,1200.0000,'cash','credit','sell',216,'2021-09-09 19:12:00','2021-09-09 19:12:00'),(422,3,0.0000,'cash','credit','sell',216,'2021-09-09 19:12:00','2021-09-09 19:12:00'),(423,3,100.0000,'cash','credit','sell',217,'2021-09-09 19:47:21','2021-09-09 19:47:21'),(424,3,0.0000,'cash','credit','sell',217,'2021-09-09 19:47:21','2021-09-09 19:47:21'),(425,3,350.0000,'cash','credit','sell',218,'2021-09-09 20:41:06','2021-09-09 20:41:06'),(426,3,0.0000,'cash','credit','sell',218,'2021-09-09 20:41:06','2021-09-09 20:41:06'),(427,3,700.0000,'cash','credit','sell',219,'2021-09-09 20:48:28','2021-09-09 20:48:28'),(428,3,0.0000,'cash','credit','sell',219,'2021-09-09 20:48:28','2021-09-09 20:48:28'),(429,3,200.0000,'cash','credit','sell',220,'2021-09-09 21:09:06','2021-09-09 21:09:06'),(430,3,0.0000,'cash','credit','sell',220,'2021-09-09 21:09:06','2021-09-09 21:09:06'),(431,3,100.0000,'cash','credit','sell',221,'2021-09-09 21:22:25','2021-09-09 21:22:25'),(432,3,0.0000,'cash','credit','sell',221,'2021-09-09 21:22:25','2021-09-09 21:22:25'),(433,3,175.0000,'cash','credit','sell',222,'2021-09-09 21:37:13','2021-09-09 21:37:13'),(434,3,0.0000,'cash','credit','sell',222,'2021-09-09 21:37:13','2021-09-09 21:37:13'),(435,3,1100.0000,'cash','credit','sell',223,'2021-09-09 21:38:00','2021-09-09 21:38:00'),(436,3,0.0000,'cash','credit','sell',223,'2021-09-09 21:38:00','2021-09-09 21:38:00'),(437,1,150.0000,'cash','credit','sell',224,'2021-09-10 22:39:36','2021-09-10 22:39:36'),(438,1,0.0000,'cash','credit','sell',224,'2021-09-10 22:39:36','2021-09-10 22:39:36'),(441,3,100.0000,'cash','credit','sell',226,'2021-09-11 13:33:07','2021-09-11 13:33:07'),(442,3,0.0000,'cash','credit','sell',226,'2021-09-11 13:33:07','2021-09-11 13:33:07'),(443,3,200.0000,'cash','credit','sell',227,'2021-09-11 13:37:43','2021-09-11 13:37:43'),(444,3,0.0000,'cash','credit','sell',227,'2021-09-11 13:37:43','2021-09-11 13:37:43'),(445,3,50.0000,'cash','credit','sell',228,'2021-09-11 13:38:17','2021-09-11 13:38:17'),(446,3,0.0000,'cash','credit','sell',228,'2021-09-11 13:38:17','2021-09-11 13:38:17'),(447,3,400.0000,'cash','credit','sell',229,'2021-09-11 15:36:30','2021-09-11 15:36:30'),(448,3,0.0000,'cash','credit','sell',229,'2021-09-11 15:36:30','2021-09-11 15:36:30'),(449,3,1000.0000,'cash','credit','sell',230,'2021-09-11 16:11:53','2021-09-11 16:11:53'),(450,3,0.0000,'cash','credit','sell',230,'2021-09-11 16:11:53','2021-09-11 16:11:53'),(451,3,100.0000,'cash','credit','sell',231,'2021-09-11 16:31:41','2021-09-11 16:31:41'),(452,3,0.0000,'cash','credit','sell',231,'2021-09-11 16:31:41','2021-09-11 16:31:41'),(453,3,350.0000,'cash','credit','sell',232,'2021-09-11 18:28:51','2021-09-11 18:28:51'),(454,3,0.0000,'cash','credit','sell',232,'2021-09-11 18:28:51','2021-09-11 18:28:51'),(455,3,250.0000,'cash','credit','sell',233,'2021-09-11 18:52:34','2021-09-11 18:52:34'),(456,3,0.0000,'cash','credit','sell',233,'2021-09-11 18:52:34','2021-09-11 18:52:34'),(457,3,150.0000,'cash','credit','sell',234,'2021-09-11 18:55:24','2021-09-11 18:55:24'),(458,3,0.0000,'cash','credit','sell',234,'2021-09-11 18:55:24','2021-09-11 18:55:24'),(459,3,600.0000,'cash','credit','sell',235,'2021-09-11 19:53:13','2021-09-11 19:53:13'),(460,3,0.0000,'cash','credit','sell',235,'2021-09-11 19:53:13','2021-09-11 19:53:13'),(461,3,700.0000,'cash','credit','sell',236,'2021-09-11 19:57:50','2021-09-11 19:57:50'),(462,3,0.0000,'cash','credit','sell',236,'2021-09-11 19:57:50','2021-09-11 19:57:50'),(463,3,500.0000,'cash','credit','sell',237,'2021-09-11 20:26:33','2021-09-11 20:26:33'),(464,3,0.0000,'cash','credit','sell',237,'2021-09-11 20:26:33','2021-09-11 20:26:33'),(465,3,900.0000,'cash','credit','sell',238,'2021-09-11 20:28:58','2021-09-11 20:28:58'),(466,3,0.0000,'cash','credit','sell',238,'2021-09-11 20:28:58','2021-09-11 20:28:58'),(467,3,150.0000,'cash','credit','sell',239,'2021-09-11 20:38:17','2021-09-11 20:38:17'),(468,3,0.0000,'cash','credit','sell',239,'2021-09-11 20:38:17','2021-09-11 20:38:17'),(469,3,3500.0000,'cash','credit','sell',240,'2021-09-11 22:02:08','2021-09-11 22:02:08'),(470,3,0.0000,'cash','credit','sell',240,'2021-09-11 22:02:08','2021-09-11 22:02:08'),(471,3,25.0000,'cash','credit','sell',241,'2021-09-11 22:43:04','2021-09-11 22:43:04'),(472,3,0.0000,'cash','credit','sell',241,'2021-09-11 22:43:04','2021-09-11 22:43:04'),(473,3,150.0000,'cash','credit','sell',242,'2021-09-12 13:11:19','2021-09-12 13:11:19'),(474,3,0.0000,'cash','credit','sell',242,'2021-09-12 13:11:19','2021-09-12 13:11:19'),(475,3,25.0000,'cash','credit','sell',243,'2021-09-12 13:16:36','2021-09-12 13:16:36'),(476,3,0.0000,'cash','credit','sell',243,'2021-09-12 13:16:36','2021-09-12 13:16:36'),(477,3,100.0000,'cash','credit','sell',244,'2021-09-12 13:58:44','2021-09-12 13:58:44'),(478,3,0.0000,'cash','credit','sell',244,'2021-09-12 13:58:44','2021-09-12 13:58:44'),(479,3,1200.0000,'cash','credit','sell',245,'2021-09-12 16:31:35','2021-09-12 16:31:35'),(480,3,0.0000,'cash','credit','sell',245,'2021-09-12 16:31:35','2021-09-12 16:31:35'),(481,3,800.0000,'cash','credit','sell',246,'2021-09-12 16:53:21','2021-09-12 16:53:21'),(482,3,0.0000,'cash','credit','sell',246,'2021-09-12 16:53:21','2021-09-12 16:53:21'),(483,3,250.0000,'cash','credit','sell',247,'2021-09-12 17:16:45','2021-09-12 17:16:45'),(484,3,0.0000,'cash','credit','sell',247,'2021-09-12 17:16:45','2021-09-12 17:16:45'),(485,3,600.0000,'cash','credit','sell',248,'2021-09-12 17:39:25','2021-09-12 17:39:25'),(486,3,0.0000,'cash','credit','sell',248,'2021-09-12 17:39:25','2021-09-12 17:39:25'),(487,3,250.0000,'cash','credit','sell',249,'2021-09-12 17:44:56','2021-09-12 17:44:56'),(488,3,0.0000,'cash','credit','sell',249,'2021-09-12 17:44:56','2021-09-12 17:44:56'),(489,3,100.0000,'cash','credit','sell',250,'2021-09-12 17:58:58','2021-09-12 17:58:58'),(490,3,0.0000,'cash','credit','sell',250,'2021-09-12 17:58:58','2021-09-12 17:58:58'),(491,3,100.0000,'cash','credit','sell',251,'2021-09-12 18:09:28','2021-09-12 18:09:28'),(492,3,0.0000,'cash','credit','sell',251,'2021-09-12 18:09:28','2021-09-12 18:09:28'),(493,3,450.0000,'cash','credit','sell',252,'2021-09-12 19:29:51','2021-09-12 19:29:51'),(494,3,0.0000,'cash','credit','sell',252,'2021-09-12 19:29:51','2021-09-12 19:29:51'),(495,3,125.0000,'cash','credit','sell',253,'2021-09-12 19:39:17','2021-09-12 19:39:17'),(496,3,0.0000,'cash','credit','sell',253,'2021-09-12 19:39:17','2021-09-12 19:39:17'),(497,3,300.0000,'cash','credit','sell',254,'2021-09-12 21:10:25','2021-09-12 21:10:25'),(498,3,0.0000,'cash','credit','sell',254,'2021-09-12 21:10:25','2021-09-12 21:10:25'),(503,3,250.0000,'cash','credit','sell',257,'2021-09-12 21:56:35','2021-09-12 21:56:35'),(504,3,0.0000,'cash','credit','sell',257,'2021-09-12 21:56:35','2021-09-12 21:56:35'),(505,3,800.0000,'cash','credit','sell',258,'2021-09-12 22:09:21','2021-09-12 22:09:21'),(506,3,0.0000,'cash','credit','sell',258,'2021-09-12 22:09:21','2021-09-12 22:09:21'),(507,3,75.0000,'cash','credit','sell',259,'2021-09-12 22:11:47','2021-09-12 22:11:47'),(508,3,0.0000,'cash','credit','sell',259,'2021-09-12 22:11:47','2021-09-12 22:11:47'),(509,3,1000.0000,'cash','credit','sell',260,'2021-09-12 22:12:32','2021-09-12 22:12:32'),(510,3,0.0000,'cash','credit','sell',260,'2021-09-12 22:12:32','2021-09-12 22:12:32'),(511,3,750.0000,'cash','credit','sell',261,'2021-09-12 22:13:30','2021-09-12 22:13:30'),(512,3,0.0000,'cash','credit','sell',261,'2021-09-12 22:13:30','2021-09-12 22:13:30'),(513,3,50.0000,'cash','credit','sell',262,'2021-09-12 22:14:04','2021-09-12 22:14:04'),(514,3,0.0000,'cash','credit','sell',262,'2021-09-12 22:14:04','2021-09-12 22:14:04'),(515,3,350.0000,'cash','credit','sell',263,'2021-09-12 22:18:20','2021-09-12 22:18:20'),(516,3,0.0000,'cash','credit','sell',263,'2021-09-12 22:18:20','2021-09-12 22:18:20'),(517,3,400.0000,'cash','credit','sell',264,'2021-09-12 22:31:25','2021-09-12 22:31:25'),(518,3,0.0000,'cash','credit','sell',264,'2021-09-12 22:31:25','2021-09-12 22:31:25'),(519,1,100.0000,'cash','credit','sell',265,'2021-09-13 02:05:31','2021-09-13 02:05:31'),(520,1,0.0000,'cash','credit','sell',265,'2021-09-13 02:05:31','2021-09-13 02:05:31'),(535,3,150.0000,'cash','credit','sell',275,'2021-09-13 13:53:57','2021-09-13 13:53:57'),(536,3,0.0000,'cash','credit','sell',275,'2021-09-13 13:53:57','2021-09-13 13:53:57'),(537,3,700.0000,'cash','credit','sell',276,'2021-09-13 14:10:11','2021-09-13 14:10:11'),(538,3,0.0000,'cash','credit','sell',276,'2021-09-13 14:10:11','2021-09-13 14:10:11'),(539,1,0.0000,'cash','credit','sell',277,'2021-09-13 16:30:24','2021-09-13 16:30:24'),(540,1,0.0000,'cash','credit','sell',277,'2021-09-13 16:30:24','2021-09-13 16:30:24'),(541,1,0.0000,'cash','credit','sell',278,'2021-09-13 16:36:04','2021-09-13 16:36:04'),(542,1,0.0000,'cash','credit','sell',278,'2021-09-13 16:36:04','2021-09-13 16:36:04'),(543,1,0.0000,'cash','credit','sell',279,'2021-09-13 16:44:19','2021-09-13 16:44:19'),(544,1,0.0000,'cash','credit','sell',279,'2021-09-13 16:44:19','2021-09-13 16:44:19'),(545,3,100.0000,'cash','credit','sell',280,'2021-09-13 16:56:28','2021-09-13 16:56:28'),(546,3,0.0000,'cash','credit','sell',280,'2021-09-13 16:56:28','2021-09-13 16:56:28'),(547,4,0.0000,'cash','credit','sell',281,'2021-09-13 17:06:08','2021-09-13 17:06:08'),(548,4,0.0000,'cash','credit','sell',281,'2021-09-13 17:06:08','2021-09-13 17:06:08'),(549,1,0.0000,'cash','credit','sell',282,'2021-09-13 17:19:48','2021-09-13 17:19:48'),(550,1,0.0000,'cash','credit','sell',282,'2021-09-13 17:19:48','2021-09-13 17:19:48'),(551,1,0.0000,'cash','credit','sell',283,'2021-09-13 17:21:17','2021-09-13 17:21:17'),(552,1,0.0000,'cash','credit','sell',283,'2021-09-13 17:21:17','2021-09-13 17:21:17'),(555,3,200.0000,'cash','credit','sell',285,'2021-09-13 17:26:18','2021-09-13 17:26:18'),(556,3,0.0000,'cash','credit','sell',285,'2021-09-13 17:26:18','2021-09-13 17:26:18'),(557,1,0.0000,'cash','credit','sell',286,'2021-09-13 17:33:11','2021-09-13 17:33:11'),(558,1,0.0000,'cash','credit','sell',286,'2021-09-13 17:33:11','2021-09-13 17:33:11'),(559,1,0.0000,'cash','credit','sell',287,'2021-09-13 17:56:27','2021-09-13 17:56:27'),(560,1,0.0000,'cash','credit','sell',287,'2021-09-13 17:56:27','2021-09-13 17:56:27'),(561,3,50.0000,'cash','credit','sell',288,'2021-09-13 17:59:02','2021-09-13 17:59:02'),(562,3,0.0000,'cash','credit','sell',288,'2021-09-13 17:59:02','2021-09-13 17:59:02'),(563,3,125.0000,'cash','credit','sell',289,'2021-09-13 18:35:17','2021-09-13 18:35:17'),(564,3,0.0000,'cash','credit','sell',289,'2021-09-13 18:35:17','2021-09-13 18:35:17'),(565,3,2300.0000,'cash','credit','sell',290,'2021-09-13 18:45:37','2021-09-13 18:45:37'),(566,3,0.0000,'cash','credit','sell',290,'2021-09-13 18:45:37','2021-09-13 18:45:37'),(567,3,300.0000,'cash','credit','sell',291,'2021-09-13 20:16:23','2021-09-13 20:16:23'),(568,3,0.0000,'cash','credit','sell',291,'2021-09-13 20:16:23','2021-09-13 20:16:23'),(569,3,250.0000,'cash','credit','sell',292,'2021-09-13 20:18:10','2021-09-13 20:18:10'),(570,3,0.0000,'cash','credit','sell',292,'2021-09-13 20:18:10','2021-09-13 20:18:10'),(571,3,300.0000,'cash','credit','sell',293,'2021-09-13 20:35:09','2021-09-13 20:35:09'),(572,3,0.0000,'cash','credit','sell',293,'2021-09-13 20:35:09','2021-09-13 20:35:09'),(573,3,450.0000,'cash','credit','sell',294,'2021-09-13 21:02:02','2021-09-13 21:02:02'),(574,3,0.0000,'cash','credit','sell',294,'2021-09-13 21:02:02','2021-09-13 21:02:02'),(575,3,50.0000,'cash','credit','sell',295,'2021-09-13 21:11:16','2021-09-13 21:11:16'),(576,3,0.0000,'cash','credit','sell',295,'2021-09-13 21:11:16','2021-09-13 21:11:16'),(577,3,500.0000,'cash','credit','sell',296,'2021-09-13 21:59:15','2021-09-13 21:59:15'),(578,3,0.0000,'cash','credit','sell',296,'2021-09-13 21:59:15','2021-09-13 21:59:15'),(579,3,350.0000,'cash','credit','sell',297,'2021-09-13 22:03:08','2021-09-13 22:03:08'),(580,3,0.0000,'cash','credit','sell',297,'2021-09-13 22:03:08','2021-09-13 22:03:08'),(583,3,0.0000,'cash','credit','sell',299,'2021-09-13 23:04:31','2021-09-13 23:04:31'),(584,3,0.0000,'cash','credit','sell',299,'2021-09-13 23:04:31','2021-09-13 23:04:31'),(585,3,0.0000,'cash','credit','sell',300,'2021-09-13 23:06:54','2021-09-13 23:06:54'),(586,3,0.0000,'cash','credit','sell',300,'2021-09-13 23:06:54','2021-09-13 23:06:54'),(587,3,500.0000,'cash','credit','sell',301,'2021-09-14 14:43:55','2021-09-14 14:43:55'),(588,3,0.0000,'cash','credit','sell',301,'2021-09-14 14:43:55','2021-09-14 14:43:55'),(589,3,1100.0000,'cash','credit','sell',302,'2021-09-14 15:15:38','2021-09-14 15:15:38'),(590,3,0.0000,'cash','credit','sell',302,'2021-09-14 15:15:38','2021-09-14 15:15:38'),(591,3,2250.0000,'cash','credit','sell',303,'2021-09-14 16:05:51','2021-09-14 16:05:51'),(592,3,0.0000,'cash','credit','sell',303,'2021-09-14 16:05:51','2021-09-14 16:05:51'),(593,3,250.0000,'cash','credit','sell',304,'2021-09-14 18:19:03','2021-09-14 18:19:03'),(594,3,0.0000,'cash','credit','sell',304,'2021-09-14 18:19:03','2021-09-14 18:19:03'),(595,3,0.0000,'cash','credit','sell',305,'2021-09-14 19:01:35','2021-09-14 19:01:35'),(596,3,0.0000,'cash','credit','sell',305,'2021-09-14 19:01:35','2021-09-14 19:01:35'),(597,3,900.0000,'cash','credit','sell',306,'2021-09-14 19:11:34','2021-09-14 19:11:34'),(598,3,0.0000,'cash','credit','sell',306,'2021-09-14 19:11:34','2021-09-14 19:11:34'),(599,3,100.0000,'cash','credit','sell',307,'2021-09-14 19:51:04','2021-09-14 19:51:04'),(600,3,0.0000,'cash','credit','sell',307,'2021-09-14 19:51:04','2021-09-14 19:51:04'),(601,3,100.0000,'cash','credit','sell',308,'2021-09-14 20:04:04','2021-09-14 20:04:04'),(602,3,0.0000,'cash','credit','sell',308,'2021-09-14 20:04:04','2021-09-14 20:04:04'),(603,3,500.0000,'cash','credit','sell',309,'2021-09-14 20:27:59','2021-09-14 20:27:59'),(604,3,0.0000,'cash','credit','sell',309,'2021-09-14 20:27:59','2021-09-14 20:27:59'),(605,3,800.0000,'cash','credit','sell',310,'2021-09-14 20:45:00','2021-09-14 20:45:00'),(606,3,0.0000,'cash','credit','sell',310,'2021-09-14 20:45:00','2021-09-14 20:45:00'),(607,3,300.0000,'cash','credit','sell',311,'2021-09-14 21:15:18','2021-09-14 21:15:18'),(608,3,0.0000,'cash','credit','sell',311,'2021-09-14 21:15:18','2021-09-14 21:15:18'),(609,3,500.0000,'cash','credit','sell',312,'2021-09-14 21:22:58','2021-09-14 21:22:58'),(610,3,0.0000,'cash','credit','sell',312,'2021-09-14 21:22:58','2021-09-14 21:22:58'),(611,3,200.0000,'cash','credit','sell',313,'2021-09-14 21:28:44','2021-09-14 21:28:44'),(612,3,0.0000,'cash','credit','sell',313,'2021-09-14 21:28:44','2021-09-14 21:28:44'),(613,3,200.0000,'cash','credit','sell',314,'2021-09-14 21:29:26','2021-09-14 21:29:26'),(614,3,0.0000,'cash','credit','sell',314,'2021-09-14 21:29:26','2021-09-14 21:29:26'),(615,3,200.0000,'cash','credit','sell',315,'2021-09-14 21:41:13','2021-09-14 21:41:13'),(616,3,0.0000,'cash','credit','sell',315,'2021-09-14 21:41:13','2021-09-14 21:41:13'),(617,3,650.0000,'cash','credit','sell',316,'2021-09-14 22:19:17','2021-09-14 22:19:17'),(618,3,0.0000,'cash','credit','sell',316,'2021-09-14 22:19:17','2021-09-14 22:19:17'),(619,3,1000.0000,'cash','credit','sell',317,'2021-09-14 22:43:37','2021-09-14 22:43:37'),(620,3,0.0000,'cash','credit','sell',317,'2021-09-14 22:43:37','2021-09-14 22:43:37'),(621,4,2500.0000,'cash','credit','sell',318,'2021-09-15 13:52:49','2021-09-15 13:52:49'),(622,4,0.0000,'cash','credit','sell',318,'2021-09-15 13:52:49','2021-09-15 13:52:49'),(623,3,700.0000,'cash','credit','sell',319,'2021-09-15 14:44:42','2021-09-15 14:44:42'),(624,3,0.0000,'cash','credit','sell',319,'2021-09-15 14:44:42','2021-09-15 14:44:42'),(625,3,1000.0000,'cash','credit','sell',320,'2021-09-15 16:54:41','2021-09-15 16:54:41'),(626,3,0.0000,'cash','credit','sell',320,'2021-09-15 16:54:41','2021-09-15 16:54:41'),(627,3,150.0000,'cash','credit','sell',321,'2021-09-15 19:10:21','2021-09-15 19:10:21'),(628,3,0.0000,'cash','credit','sell',321,'2021-09-15 19:10:21','2021-09-15 19:10:21'),(629,3,300.0000,'cash','credit','sell',322,'2021-09-15 20:38:54','2021-09-15 20:38:54'),(630,3,0.0000,'cash','credit','sell',322,'2021-09-15 20:38:54','2021-09-15 20:38:54'),(631,3,100.0000,'cash','credit','sell',323,'2021-09-15 20:40:31','2021-09-15 20:40:31'),(632,3,0.0000,'cash','credit','sell',323,'2021-09-15 20:40:31','2021-09-15 20:40:31'),(633,3,100.0000,'cash','credit','sell',324,'2021-09-15 20:42:26','2021-09-15 20:42:26'),(634,3,0.0000,'cash','credit','sell',324,'2021-09-15 20:42:26','2021-09-15 20:42:26'),(637,3,750.0000,'cash','credit','sell',326,'2021-09-15 20:55:29','2021-09-15 20:55:29'),(638,3,0.0000,'cash','credit','sell',326,'2021-09-15 20:55:29','2021-09-15 20:55:29'),(639,3,250.0000,'cash','credit','sell',327,'2021-09-15 21:02:18','2021-09-15 21:02:18'),(640,3,0.0000,'cash','credit','sell',327,'2021-09-15 21:02:18','2021-09-15 21:02:18'),(641,3,100.0000,'cash','credit','sell',328,'2021-09-15 21:18:07','2021-09-15 21:18:07'),(642,3,0.0000,'cash','credit','sell',328,'2021-09-15 21:18:07','2021-09-15 21:18:07'),(643,3,100.0000,'cash','credit','sell',329,'2021-09-15 22:07:25','2021-09-15 22:07:25'),(644,3,0.0000,'cash','credit','sell',329,'2021-09-15 22:07:25','2021-09-15 22:07:25'),(645,3,750.0000,'cash','credit','sell',330,'2021-09-15 22:10:48','2021-09-15 22:10:48'),(646,3,0.0000,'cash','credit','sell',330,'2021-09-15 22:10:48','2021-09-15 22:10:48'),(647,3,100.0000,'cash','credit','sell',331,'2021-09-15 22:11:51','2021-09-15 22:11:51'),(648,3,0.0000,'cash','credit','sell',331,'2021-09-15 22:11:51','2021-09-15 22:11:51'),(649,3,100.0000,'cash','credit','sell',332,'2021-09-15 22:37:29','2021-09-15 22:37:29'),(650,3,0.0000,'cash','credit','sell',332,'2021-09-15 22:37:29','2021-09-15 22:37:29'),(651,3,150.0000,'cash','credit','sell',333,'2021-09-15 22:55:23','2021-09-15 22:55:23'),(652,3,0.0000,'cash','credit','sell',333,'2021-09-15 22:55:23','2021-09-15 22:55:23'),(653,4,300.0000,'cash','credit','sell',334,'2021-09-16 12:48:36','2021-09-16 12:48:36'),(654,4,0.0000,'cash','credit','sell',334,'2021-09-16 12:48:36','2021-09-16 12:48:36'),(655,4,900.0000,'cash','credit','sell',335,'2021-09-16 14:49:18','2021-09-16 14:49:18'),(656,4,0.0000,'cash','credit','sell',335,'2021-09-16 14:49:18','2021-09-16 14:49:18'),(657,4,150.0000,'cash','credit','sell',336,'2021-09-16 14:50:32','2021-09-16 14:50:32'),(658,4,0.0000,'cash','credit','sell',336,'2021-09-16 14:50:32','2021-09-16 14:50:32'),(659,4,150.0000,'cash','credit','sell',337,'2021-09-16 16:01:43','2021-09-16 16:01:43'),(660,4,0.0000,'cash','credit','sell',337,'2021-09-16 16:01:43','2021-09-16 16:01:43'),(661,4,2800.0000,'cash','credit','sell',338,'2021-09-16 17:05:27','2021-09-16 17:05:27'),(662,4,0.0000,'cash','credit','sell',338,'2021-09-16 17:05:27','2021-09-16 17:05:27'),(663,4,500.0000,'cash','credit','sell',339,'2021-09-16 17:34:41','2021-09-16 17:34:41'),(664,4,0.0000,'cash','credit','sell',339,'2021-09-16 17:34:41','2021-09-16 17:34:41'),(665,4,650.0000,'cash','credit','sell',340,'2021-09-16 19:38:22','2021-09-16 19:38:22'),(666,4,0.0000,'cash','credit','sell',340,'2021-09-16 19:38:22','2021-09-16 19:38:22'),(667,3,400.0000,'cash','credit','sell',341,'2021-09-16 20:35:07','2021-09-16 20:35:07'),(668,3,0.0000,'cash','credit','sell',341,'2021-09-16 20:35:07','2021-09-16 20:35:07'),(669,1,0.0000,'cash','credit','sell',342,'2021-09-16 20:42:49','2021-09-16 20:42:49'),(670,1,0.0000,'cash','credit','sell',342,'2021-09-16 20:42:49','2021-09-16 20:42:49'),(671,3,1000.0000,'cash','credit','sell',343,'2021-09-16 21:01:54','2021-09-16 21:01:54'),(672,3,0.0000,'cash','credit','sell',343,'2021-09-16 21:01:54','2021-09-16 21:01:54'),(673,3,400.0000,'cash','credit','sell',344,'2021-09-16 21:02:31','2021-09-16 21:02:31'),(674,3,0.0000,'cash','credit','sell',344,'2021-09-16 21:02:31','2021-09-16 21:02:31'),(675,3,900.0000,'cash','credit','sell',345,'2021-09-16 21:03:14','2021-09-16 21:03:14'),(676,3,0.0000,'cash','credit','sell',345,'2021-09-16 21:03:14','2021-09-16 21:03:14'),(677,3,200.0000,'cash','credit','sell',346,'2021-09-16 21:11:48','2021-09-16 21:11:48'),(678,3,0.0000,'cash','credit','sell',346,'2021-09-16 21:11:48','2021-09-16 21:11:48'),(679,3,25.0000,'cash','credit','sell',347,'2021-09-16 21:27:41','2021-09-16 21:27:41'),(680,3,0.0000,'cash','credit','sell',347,'2021-09-16 21:27:41','2021-09-16 21:27:41'),(681,3,400.0000,'cash','credit','sell',348,'2021-09-16 22:04:02','2021-09-16 22:04:02'),(682,3,0.0000,'cash','credit','sell',348,'2021-09-16 22:04:02','2021-09-16 22:04:02'),(683,3,150.0000,'cash','credit','sell',349,'2021-09-16 22:08:44','2021-09-16 22:08:44'),(684,3,0.0000,'cash','credit','sell',349,'2021-09-16 22:08:44','2021-09-16 22:08:44'),(685,3,300.0000,'cash','credit','sell',350,'2021-09-16 22:17:04','2021-09-16 22:17:04'),(686,3,0.0000,'cash','credit','sell',350,'2021-09-16 22:17:04','2021-09-16 22:17:04'),(687,3,500.0000,'cash','credit','sell',351,'2021-09-16 23:07:38','2021-09-16 23:07:38'),(688,3,0.0000,'cash','credit','sell',351,'2021-09-16 23:07:38','2021-09-16 23:07:38'),(689,3,150.0000,'cash','credit','sell',352,'2021-09-17 18:19:27','2021-09-17 18:19:27'),(690,3,0.0000,'cash','credit','sell',352,'2021-09-17 18:19:27','2021-09-17 18:19:27'),(691,3,500.0000,'cash','credit','sell',353,'2021-09-17 19:14:24','2021-09-17 19:14:24'),(692,3,0.0000,'cash','credit','sell',353,'2021-09-17 19:14:24','2021-09-17 19:14:24'),(693,4,700.0000,'cash','credit','sell',354,'2021-09-18 16:09:17','2021-09-18 16:09:17'),(694,4,0.0000,'cash','credit','sell',354,'2021-09-18 16:09:17','2021-09-18 16:09:17'),(695,4,20.0000,'cash','credit','sell',355,'2021-09-18 16:24:08','2021-09-18 16:24:08'),(696,4,0.0000,'cash','credit','sell',355,'2021-09-18 16:24:08','2021-09-18 16:24:08'),(697,4,50.0000,'cash','credit','sell',356,'2021-09-18 16:32:12','2021-09-18 16:32:12'),(698,4,0.0000,'cash','credit','sell',356,'2021-09-18 16:32:12','2021-09-18 16:32:12'),(699,4,100.0000,'cash','credit','sell',357,'2021-09-18 18:30:37','2021-09-18 18:30:37'),(700,4,0.0000,'cash','credit','sell',357,'2021-09-18 18:30:37','2021-09-18 18:30:37'),(701,4,450.0000,'cash','credit','sell',358,'2021-09-18 21:25:50','2021-09-18 21:25:50'),(702,4,0.0000,'cash','credit','sell',358,'2021-09-18 21:25:50','2021-09-18 21:25:50'),(703,4,750.0000,'cash','credit','sell',359,'2021-09-18 21:41:44','2021-09-18 21:41:44'),(704,4,0.0000,'cash','credit','sell',359,'2021-09-18 21:41:44','2021-09-18 21:41:44'),(705,4,800.0000,'cash','credit','sell',360,'2021-09-19 16:39:10','2021-09-19 16:39:10'),(706,4,0.0000,'cash','credit','sell',360,'2021-09-19 16:39:10','2021-09-19 16:39:10'),(707,3,100.0000,'cash','credit','sell',361,'2021-09-19 19:14:51','2021-09-19 19:14:51'),(708,3,0.0000,'cash','credit','sell',361,'2021-09-19 19:14:51','2021-09-19 19:14:51'),(709,3,100.0000,'cash','credit','sell',362,'2021-09-19 21:21:40','2021-09-19 21:21:40'),(710,3,0.0000,'cash','credit','sell',362,'2021-09-19 21:21:40','2021-09-19 21:21:40'),(711,3,250.0000,'cash','credit','sell',363,'2021-09-19 22:21:38','2021-09-19 22:21:38'),(712,3,0.0000,'cash','credit','sell',363,'2021-09-19 22:21:38','2021-09-19 22:21:38'),(713,3,400.0000,'cash','credit','sell',364,'2021-09-19 22:33:36','2021-09-19 22:33:36'),(714,3,0.0000,'cash','credit','sell',364,'2021-09-19 22:33:36','2021-09-19 22:33:36'),(715,3,550.0000,'cash','credit','sell',365,'2021-09-19 22:51:15','2021-09-19 22:51:15'),(716,3,0.0000,'cash','credit','sell',365,'2021-09-19 22:51:15','2021-09-19 22:51:15'),(717,3,325.0000,'cash','credit','sell',366,'2021-09-20 14:18:16','2021-09-20 14:18:16'),(718,3,0.0000,'cash','credit','sell',366,'2021-09-20 14:18:16','2021-09-20 14:18:16'),(719,3,200.0000,'cash','credit','sell',367,'2021-09-20 17:43:27','2021-09-20 17:43:27'),(720,3,0.0000,'cash','credit','sell',367,'2021-09-20 17:43:27','2021-09-20 17:43:27'),(721,3,150.0000,'cash','credit','sell',368,'2021-09-20 19:37:17','2021-09-20 19:37:17'),(722,3,0.0000,'cash','credit','sell',368,'2021-09-20 19:37:17','2021-09-20 19:37:17'),(723,3,150.0000,'cash','credit','sell',369,'2021-09-20 20:56:22','2021-09-20 20:56:22'),(724,3,0.0000,'cash','credit','sell',369,'2021-09-20 20:56:22','2021-09-20 20:56:22'),(725,3,150.0000,'cash','credit','sell',370,'2021-09-20 20:57:33','2021-09-20 20:57:33'),(726,3,0.0000,'cash','credit','sell',370,'2021-09-20 20:57:33','2021-09-20 20:57:33'),(727,3,175.0000,'cash','credit','sell',371,'2021-09-20 21:16:18','2021-09-20 21:16:18'),(728,3,0.0000,'cash','credit','sell',371,'2021-09-20 21:16:18','2021-09-20 21:16:18'),(729,3,100.0000,'cash','credit','sell',372,'2021-09-20 21:21:40','2021-09-20 21:21:40'),(730,3,0.0000,'cash','credit','sell',372,'2021-09-20 21:21:40','2021-09-20 21:21:40'),(731,3,250.0000,'cash','credit','sell',373,'2021-09-20 21:24:56','2021-09-20 21:24:56'),(732,3,0.0000,'cash','credit','sell',373,'2021-09-20 21:24:56','2021-09-20 21:24:56'),(733,3,550.0000,'cash','credit','sell',374,'2021-09-20 21:26:11','2021-09-20 21:26:11'),(734,3,0.0000,'cash','credit','sell',374,'2021-09-20 21:26:11','2021-09-20 21:26:11'),(735,3,300.0000,'cash','credit','sell',375,'2021-09-20 21:32:13','2021-09-20 21:32:13'),(736,3,0.0000,'cash','credit','sell',375,'2021-09-20 21:32:13','2021-09-20 21:32:13'),(737,3,900.0000,'cash','credit','sell',376,'2021-09-20 22:11:19','2021-09-20 22:11:19'),(738,3,0.0000,'cash','credit','sell',376,'2021-09-20 22:11:19','2021-09-20 22:11:19'),(739,3,2800.0000,'cash','credit','sell',377,'2021-09-20 22:28:51','2021-09-20 22:28:51'),(740,3,0.0000,'cash','credit','sell',377,'2021-09-20 22:28:51','2021-09-20 22:28:51'),(741,3,600.0000,'cash','credit','sell',378,'2021-09-20 23:09:12','2021-09-20 23:09:12'),(742,3,0.0000,'cash','credit','sell',378,'2021-09-20 23:09:12','2021-09-20 23:09:12'),(743,3,200.0000,'cash','credit','sell',379,'2021-09-20 23:09:51','2021-09-20 23:09:51'),(744,3,0.0000,'cash','credit','sell',379,'2021-09-20 23:09:51','2021-09-20 23:09:51'),(745,4,75.0000,'cash','credit','sell',380,'2021-09-21 13:03:18','2021-09-21 13:03:18'),(746,4,0.0000,'cash','credit','sell',380,'2021-09-21 13:03:18','2021-09-21 13:03:18'),(747,4,100.0000,'cash','credit','sell',381,'2021-09-21 15:36:10','2021-09-21 15:36:10'),(748,4,0.0000,'cash','credit','sell',381,'2021-09-21 15:36:10','2021-09-21 15:36:10'),(749,1,250.0000,'cash','credit','sell',382,'2021-09-21 16:37:59','2021-09-21 16:37:59'),(750,1,0.0000,'cash','credit','sell',382,'2021-09-21 16:37:59','2021-09-21 16:37:59'),(751,1,400.0000,'cash','debit','refund',175,'2021-09-21 17:09:26','2021-09-21 17:09:26'),(752,1,400.0000,'cash','debit','refund',115,'2021-09-21 17:14:03','2021-09-21 17:14:03'),(753,1,50.0000,'cash','credit','sell',383,'2021-09-21 17:20:26','2021-09-21 17:20:26'),(754,1,0.0000,'cash','credit','sell',383,'2021-09-21 17:20:26','2021-09-21 17:20:26'),(755,1,25.0000,'cash','credit','sell',384,'2021-09-21 17:22:03','2021-09-21 17:22:03'),(756,1,0.0000,'cash','credit','sell',384,'2021-09-21 17:22:03','2021-09-21 17:22:03'),(757,1,150.0000,'cash','credit','sell',385,'2021-09-21 17:31:52','2021-09-21 17:31:52'),(758,1,0.0000,'cash','credit','sell',385,'2021-09-21 17:31:52','2021-09-21 17:31:52'),(759,1,150.0000,'cash','credit','sell',386,'2021-09-21 18:53:15','2021-09-21 18:53:15'),(760,1,0.0000,'cash','credit','sell',386,'2021-09-21 18:53:15','2021-09-21 18:53:15'),(761,3,100.0000,'cash','credit','sell',387,'2021-09-21 19:28:20','2021-09-21 19:28:20'),(762,3,0.0000,'cash','credit','sell',387,'2021-09-21 19:28:20','2021-09-21 19:28:20'),(763,3,1000.0000,'cash','credit','sell',388,'2021-09-21 21:01:25','2021-09-21 21:01:25'),(764,3,0.0000,'cash','credit','sell',388,'2021-09-21 21:01:25','2021-09-21 21:01:25'),(765,3,150.0000,'cash','credit','sell',389,'2021-09-21 21:48:23','2021-09-21 21:48:23'),(766,3,0.0000,'cash','credit','sell',389,'2021-09-21 21:48:23','2021-09-21 21:48:23'),(767,3,1000.0000,'cash','credit','sell',390,'2021-09-21 22:37:22','2021-09-21 22:37:22'),(768,3,0.0000,'cash','credit','sell',390,'2021-09-21 22:37:22','2021-09-21 22:37:22'),(769,4,750.0000,'cash','credit','sell',392,'2021-09-22 12:33:14','2021-09-22 12:33:14'),(770,4,0.0000,'cash','credit','sell',392,'2021-09-22 12:33:14','2021-09-22 12:33:14'),(771,3,200.0000,'cash','credit','sell',393,'2021-09-22 17:18:56','2021-09-22 17:18:56'),(772,3,0.0000,'cash','credit','sell',393,'2021-09-22 17:18:56','2021-09-22 17:18:56'),(773,3,1100.0000,'cash','credit','sell',394,'2021-09-22 18:33:45','2021-09-22 18:33:45'),(774,3,0.0000,'cash','credit','sell',394,'2021-09-22 18:33:45','2021-09-22 18:33:45'),(775,3,450.0000,'cash','credit','sell',395,'2021-09-22 18:34:36','2021-09-22 18:34:36'),(776,3,0.0000,'cash','credit','sell',395,'2021-09-22 18:34:36','2021-09-22 18:34:36'),(777,3,400.0000,'cash','credit','sell',396,'2021-09-22 19:12:36','2021-09-22 19:12:36'),(778,3,0.0000,'cash','credit','sell',396,'2021-09-22 19:12:36','2021-09-22 19:12:36'),(779,4,550.0000,'cash','credit','sell',397,'2021-09-22 20:09:29','2021-09-22 20:09:29'),(780,4,0.0000,'cash','credit','sell',397,'2021-09-22 20:09:29','2021-09-22 20:09:29'),(781,3,750.0000,'cash','credit','sell',398,'2021-09-22 20:19:13','2021-09-22 20:19:13'),(782,3,0.0000,'cash','credit','sell',398,'2021-09-22 20:19:13','2021-09-22 20:19:13'),(783,3,150.0000,'cash','credit','sell',399,'2021-09-22 20:21:21','2021-09-22 20:21:21'),(784,3,0.0000,'cash','credit','sell',399,'2021-09-22 20:21:21','2021-09-22 20:21:21'),(785,3,850.0000,'cash','credit','sell',400,'2021-09-22 20:25:00','2021-09-22 20:25:00'),(786,3,0.0000,'cash','credit','sell',400,'2021-09-22 20:25:00','2021-09-22 20:25:00'),(787,3,850.0000,'cash','credit','sell',401,'2021-09-22 20:27:57','2021-09-22 20:27:57'),(788,3,0.0000,'cash','credit','sell',401,'2021-09-22 20:27:57','2021-09-22 20:27:57'),(789,3,250.0000,'cash','credit','sell',402,'2021-09-22 20:29:00','2021-09-22 20:29:00'),(790,3,0.0000,'cash','credit','sell',402,'2021-09-22 20:29:00','2021-09-22 20:29:00'),(791,3,100.0000,'cash','credit','sell',403,'2021-09-22 21:25:28','2021-09-22 21:25:28'),(792,3,0.0000,'cash','credit','sell',403,'2021-09-22 21:25:28','2021-09-22 21:25:28'),(793,3,1500.0000,'cash','credit','sell',404,'2021-09-22 21:37:50','2021-09-22 21:37:50'),(794,3,0.0000,'cash','credit','sell',404,'2021-09-22 21:37:50','2021-09-22 21:37:50'),(795,3,1000.0000,'cash','credit','sell',405,'2021-09-22 21:38:48','2021-09-22 21:38:48'),(796,3,0.0000,'cash','credit','sell',405,'2021-09-22 21:38:48','2021-09-22 21:38:48'),(797,3,2000.0000,'cash','credit','sell',406,'2021-09-22 21:52:27','2021-09-22 21:52:27'),(798,3,0.0000,'cash','credit','sell',406,'2021-09-22 21:52:27','2021-09-22 21:52:27'),(799,3,750.0000,'cash','credit','sell',407,'2021-09-22 22:11:01','2021-09-22 22:11:01'),(800,3,0.0000,'cash','credit','sell',407,'2021-09-22 22:11:01','2021-09-22 22:11:01'),(801,3,400.0000,'cash','credit','sell',408,'2021-09-22 22:24:13','2021-09-22 22:24:13'),(802,3,0.0000,'cash','credit','sell',408,'2021-09-22 22:24:13','2021-09-22 22:24:13'),(803,3,150.0000,'cash','credit','sell',409,'2021-09-22 22:28:47','2021-09-22 22:28:47'),(804,3,0.0000,'cash','credit','sell',409,'2021-09-22 22:28:47','2021-09-22 22:28:47'),(805,3,800.0000,'cash','credit','sell',410,'2021-09-22 22:57:13','2021-09-22 22:57:13'),(806,3,0.0000,'cash','credit','sell',410,'2021-09-22 22:57:13','2021-09-22 22:57:13'),(807,3,50.0000,'cash','credit','sell',411,'2021-09-22 22:58:52','2021-09-22 22:58:52'),(808,3,0.0000,'cash','credit','sell',411,'2021-09-22 22:58:52','2021-09-22 22:58:52'),(809,4,800.0000,'cash','credit','sell',412,'2021-09-23 12:32:21','2021-09-23 12:32:21'),(810,4,0.0000,'cash','credit','sell',412,'2021-09-23 12:32:21','2021-09-23 12:32:21'),(811,4,300.0000,'cash','credit','sell',413,'2021-09-23 17:36:23','2021-09-23 17:36:23'),(812,4,0.0000,'cash','credit','sell',413,'2021-09-23 17:36:25','2021-09-23 17:36:25'),(813,4,250.0000,'cash','credit','sell',414,'2021-09-23 17:37:12','2021-09-23 17:37:12'),(814,4,0.0000,'cash','credit','sell',414,'2021-09-23 17:37:12','2021-09-23 17:37:12'),(815,4,800.0000,'cash','credit','sell',415,'2021-09-23 17:39:00','2021-09-23 17:39:00'),(816,4,0.0000,'cash','credit','sell',415,'2021-09-23 17:39:00','2021-09-23 17:39:00'),(817,4,200.0000,'cash','credit','sell',416,'2021-09-23 18:01:34','2021-09-23 18:01:34'),(818,4,0.0000,'cash','credit','sell',416,'2021-09-23 18:01:34','2021-09-23 18:01:34'),(819,4,100.0000,'cash','credit','sell',417,'2021-09-23 18:20:33','2021-09-23 18:20:33'),(820,4,0.0000,'cash','credit','sell',417,'2021-09-23 18:20:33','2021-09-23 18:20:33'),(821,4,1000.0000,'cash','credit','sell',418,'2021-09-23 19:40:14','2021-09-23 19:40:14'),(822,4,0.0000,'cash','credit','sell',418,'2021-09-23 19:40:14','2021-09-23 19:40:14'),(823,4,1000.0000,'cash','credit','sell',419,'2021-09-23 20:34:14','2021-09-23 20:34:14'),(824,4,0.0000,'cash','credit','sell',419,'2021-09-23 20:34:14','2021-09-23 20:34:14'),(825,4,100.0000,'cash','credit','sell',420,'2021-09-23 21:02:46','2021-09-23 21:02:46'),(826,4,0.0000,'cash','credit','sell',420,'2021-09-23 21:02:46','2021-09-23 21:02:46'),(827,4,850.0000,'cash','credit','sell',422,'2021-09-23 21:15:40','2021-09-23 21:15:40'),(828,4,0.0000,'cash','credit','sell',422,'2021-09-23 21:15:40','2021-09-23 21:15:40'),(829,4,1200.0000,'cash','credit','sell',423,'2021-09-23 21:16:40','2021-09-23 21:16:40'),(830,4,0.0000,'cash','credit','sell',423,'2021-09-23 21:16:40','2021-09-23 21:16:40'),(831,4,250.0000,'cash','credit','sell',424,'2021-09-23 22:12:30','2021-09-23 22:12:30'),(832,4,0.0000,'cash','credit','sell',424,'2021-09-23 22:12:30','2021-09-23 22:12:30'),(833,4,4000.0000,'cash','credit','sell',425,'2021-09-23 22:56:11','2021-09-23 22:56:11'),(834,4,0.0000,'cash','credit','sell',425,'2021-09-23 22:56:11','2021-09-23 22:56:11'),(835,6,1000.0000,'cash','credit','sell',426,'2021-09-24 19:04:44','2021-09-24 19:04:44'),(836,6,0.0000,'cash','credit','sell',426,'2021-09-24 19:04:44','2021-09-24 19:04:44'),(837,6,400.0000,'cash','credit','sell',427,'2021-09-24 19:49:37','2021-09-24 19:49:37'),(838,6,0.0000,'cash','credit','sell',427,'2021-09-24 19:49:37','2021-09-24 19:49:37'),(839,6,225.0000,'cash','credit','sell',428,'2021-09-24 21:21:12','2021-09-24 21:21:12'),(840,6,0.0000,'cash','credit','sell',428,'2021-09-24 21:21:12','2021-09-24 21:21:12'),(841,6,100.0000,'cash','credit','sell',429,'2021-09-24 21:21:46','2021-09-24 21:21:46'),(842,6,0.0000,'cash','credit','sell',429,'2021-09-24 21:21:46','2021-09-24 21:21:46'),(843,3,1000.0000,'cash','credit','sell',430,'2021-09-25 14:36:30','2021-09-25 14:36:30'),(844,3,0.0000,'cash','credit','sell',430,'2021-09-25 14:36:30','2021-09-25 14:36:30'),(845,3,100.0000,'cash','credit','sell',431,'2021-09-25 17:29:04','2021-09-25 17:29:04'),(846,3,0.0000,'cash','credit','sell',431,'2021-09-25 17:29:04','2021-09-25 17:29:04'),(847,3,100.0000,'cash','credit','sell',432,'2021-09-25 17:51:24','2021-09-25 17:51:24'),(848,3,0.0000,'cash','credit','sell',432,'2021-09-25 17:51:24','2021-09-25 17:51:24'),(849,3,700.0000,'cash','credit','sell',433,'2021-09-25 19:56:17','2021-09-25 19:56:17'),(850,3,0.0000,'cash','credit','sell',433,'2021-09-25 19:56:17','2021-09-25 19:56:17'),(851,3,300.0000,'cash','credit','sell',434,'2021-09-25 19:57:13','2021-09-25 19:57:13'),(852,3,0.0000,'cash','credit','sell',434,'2021-09-25 19:57:13','2021-09-25 19:57:13'),(853,3,150.0000,'cash','credit','sell',435,'2021-09-25 20:00:29','2021-09-25 20:00:29'),(854,3,0.0000,'cash','credit','sell',435,'2021-09-25 20:00:29','2021-09-25 20:00:29'),(855,3,250.0000,'cash','credit','sell',436,'2021-09-25 20:52:17','2021-09-25 20:52:17'),(856,3,0.0000,'cash','credit','sell',436,'2021-09-25 20:52:17','2021-09-25 20:52:17'),(857,4,125.0000,'cash','credit','sell',437,'2021-09-25 21:14:12','2021-09-25 21:14:12'),(858,4,0.0000,'cash','credit','sell',437,'2021-09-25 21:14:12','2021-09-25 21:14:12'),(859,3,800.0000,'cash','credit','sell',438,'2021-09-25 21:52:24','2021-09-25 21:52:24'),(860,3,0.0000,'cash','credit','sell',438,'2021-09-25 21:52:24','2021-09-25 21:52:24'),(861,3,500.0000,'cash','credit','sell',439,'2021-09-25 21:55:44','2021-09-25 21:55:44'),(862,3,0.0000,'cash','credit','sell',439,'2021-09-25 21:55:44','2021-09-25 21:55:44'),(863,3,200.0000,'cash','credit','sell',440,'2021-09-25 21:56:23','2021-09-25 21:56:23'),(864,3,0.0000,'cash','credit','sell',440,'2021-09-25 21:56:23','2021-09-25 21:56:23'),(865,3,75.0000,'cash','credit','sell',442,'2021-09-25 22:17:50','2021-09-25 22:17:50'),(866,3,0.0000,'cash','credit','sell',442,'2021-09-25 22:17:50','2021-09-25 22:17:50'),(867,3,1300.0000,'cash','credit','sell',443,'2021-09-25 22:19:14','2021-09-25 22:19:14'),(868,3,0.0000,'cash','credit','sell',443,'2021-09-25 22:19:14','2021-09-25 22:19:14'),(869,3,750.0000,'cash','credit','sell',444,'2021-09-25 22:22:23','2021-09-25 22:22:23'),(870,3,0.0000,'cash','credit','sell',444,'2021-09-25 22:22:23','2021-09-25 22:22:23'),(871,3,800.0000,'cash','credit','sell',445,'2021-09-25 22:51:37','2021-09-25 22:51:37'),(872,3,0.0000,'cash','credit','sell',445,'2021-09-25 22:51:37','2021-09-25 22:51:37'),(873,3,150.0000,'cash','credit','sell',446,'2021-09-25 22:56:39','2021-09-25 22:56:39'),(874,3,0.0000,'cash','credit','sell',446,'2021-09-25 22:56:39','2021-09-25 22:56:39'),(875,3,75.0000,'cash','credit','sell',447,'2021-09-26 14:28:38','2021-09-26 14:28:38'),(876,3,0.0000,'cash','credit','sell',447,'2021-09-26 14:28:38','2021-09-26 14:28:38'),(877,3,350.0000,'cash','credit','sell',448,'2021-09-26 14:33:15','2021-09-26 14:33:15'),(878,3,0.0000,'cash','credit','sell',448,'2021-09-26 14:33:15','2021-09-26 14:33:15'),(879,3,1000.0000,'cash','credit','sell',449,'2021-09-26 15:04:53','2021-09-26 15:04:53'),(880,3,0.0000,'cash','credit','sell',449,'2021-09-26 15:04:53','2021-09-26 15:04:53'),(881,3,400.0000,'cash','credit','sell',450,'2021-09-26 15:13:48','2021-09-26 15:13:48'),(882,3,0.0000,'cash','credit','sell',450,'2021-09-26 15:13:48','2021-09-26 15:13:48'),(883,3,175.0000,'cash','credit','sell',451,'2021-09-26 15:29:49','2021-09-26 15:29:49'),(884,3,0.0000,'cash','credit','sell',451,'2021-09-26 15:29:49','2021-09-26 15:29:49'),(885,3,50.0000,'cash','credit','sell',452,'2021-09-26 17:51:26','2021-09-26 17:51:26'),(886,3,0.0000,'cash','credit','sell',452,'2021-09-26 17:51:26','2021-09-26 17:51:26'),(887,3,600.0000,'cash','credit','sell',453,'2021-09-26 18:42:33','2021-09-26 18:42:33'),(888,3,0.0000,'cash','credit','sell',453,'2021-09-26 18:42:33','2021-09-26 18:42:33'),(889,4,100.0000,'cash','credit','sell',454,'2021-09-26 19:01:01','2021-09-26 19:01:01'),(890,4,0.0000,'cash','credit','sell',454,'2021-09-26 19:01:01','2021-09-26 19:01:01'),(891,3,1600.0000,'cash','credit','sell',455,'2021-09-26 19:57:49','2021-09-26 19:57:49'),(892,3,0.0000,'cash','credit','sell',455,'2021-09-26 19:57:49','2021-09-26 19:57:49'),(893,3,50.0000,'cash','credit','sell',456,'2021-09-26 20:04:31','2021-09-26 20:04:31'),(894,3,0.0000,'cash','credit','sell',456,'2021-09-26 20:04:31','2021-09-26 20:04:31'),(895,4,2400.0000,'cash','credit','sell',457,'2021-09-26 20:05:03','2021-09-26 20:05:03'),(896,4,0.0000,'cash','credit','sell',457,'2021-09-26 20:05:03','2021-09-26 20:05:03'),(897,3,125.0000,'cash','credit','sell',458,'2021-09-26 21:01:45','2021-09-26 21:01:45'),(898,3,0.0000,'cash','credit','sell',458,'2021-09-26 21:01:45','2021-09-26 21:01:45'),(899,3,200.0000,'cash','credit','sell',459,'2021-09-26 21:23:25','2021-09-26 21:23:25'),(900,3,0.0000,'cash','credit','sell',459,'2021-09-26 21:23:25','2021-09-26 21:23:25'),(901,3,100.0000,'cash','credit','sell',460,'2021-09-26 21:56:12','2021-09-26 21:56:12'),(902,3,0.0000,'cash','credit','sell',460,'2021-09-26 21:56:12','2021-09-26 21:56:12'),(903,3,300.0000,'cash','credit','sell',461,'2021-09-26 21:57:44','2021-09-26 21:57:44'),(904,3,0.0000,'cash','credit','sell',461,'2021-09-26 21:57:44','2021-09-26 21:57:44'),(905,4,5300.0000,'cash','credit','sell',462,'2021-09-26 22:12:14','2021-09-26 22:12:14'),(906,4,0.0000,'cash','credit','sell',462,'2021-09-26 22:12:14','2021-09-26 22:12:14'),(907,4,3300.0000,'cash','credit','sell',463,'2021-09-26 22:13:00','2021-09-26 22:13:00'),(908,4,0.0000,'cash','credit','sell',463,'2021-09-26 22:13:00','2021-09-26 22:13:00'),(909,4,150.0000,'cash','credit','sell',464,'2021-09-27 12:55:19','2021-09-27 12:55:19'),(910,4,0.0000,'cash','credit','sell',464,'2021-09-27 12:55:19','2021-09-27 12:55:19'),(911,4,200.0000,'cash','credit','sell',465,'2021-09-27 16:58:04','2021-09-27 16:58:04'),(912,4,0.0000,'cash','credit','sell',465,'2021-09-27 16:58:04','2021-09-27 16:58:04'),(913,4,550.0000,'cash','credit','sell',466,'2021-09-27 16:58:50','2021-09-27 16:58:50'),(914,4,0.0000,'cash','credit','sell',466,'2021-09-27 16:58:50','2021-09-27 16:58:50'),(915,4,2000.0000,'cash','credit','sell',467,'2021-09-27 18:45:58','2021-09-27 18:45:58'),(916,4,0.0000,'cash','credit','sell',467,'2021-09-27 18:45:58','2021-09-27 18:45:58'),(917,4,100.0000,'cash','credit','sell',468,'2021-09-27 18:52:44','2021-09-27 18:52:44'),(918,4,0.0000,'cash','credit','sell',468,'2021-09-27 18:52:44','2021-09-27 18:52:44'),(919,4,200.0000,'cash','credit','sell',469,'2021-09-27 19:49:31','2021-09-27 19:49:31'),(920,4,0.0000,'cash','credit','sell',469,'2021-09-27 19:49:31','2021-09-27 19:49:31'),(921,4,1150.0000,'cash','credit','sell',470,'2021-09-27 20:36:13','2021-09-27 20:36:13'),(922,4,0.0000,'cash','credit','sell',470,'2021-09-27 20:36:13','2021-09-27 20:36:13'),(923,4,500.0000,'cash','credit','sell',471,'2021-09-27 20:40:35','2021-09-27 20:40:35'),(924,4,0.0000,'cash','credit','sell',471,'2021-09-27 20:40:35','2021-09-27 20:40:35'),(925,4,750.0000,'cash','credit','sell',472,'2021-09-27 21:03:17','2021-09-27 21:03:17'),(926,4,0.0000,'cash','credit','sell',472,'2021-09-27 21:03:17','2021-09-27 21:03:17'),(927,4,175.0000,'cash','credit','sell',473,'2021-09-27 21:42:36','2021-09-27 21:42:36'),(928,4,0.0000,'cash','credit','sell',473,'2021-09-27 21:42:36','2021-09-27 21:42:36'),(929,4,350.0000,'cash','credit','sell',474,'2021-09-27 22:25:15','2021-09-27 22:25:15'),(930,4,0.0000,'cash','credit','sell',474,'2021-09-27 22:25:15','2021-09-27 22:25:15'),(931,4,250.0000,'cash','credit','sell',475,'2021-09-27 22:33:23','2021-09-27 22:33:23'),(932,4,0.0000,'cash','credit','sell',475,'2021-09-27 22:33:23','2021-09-27 22:33:23'),(933,4,700.0000,'cash','credit','sell',476,'2021-09-27 22:49:53','2021-09-27 22:49:53'),(934,4,0.0000,'cash','credit','sell',476,'2021-09-27 22:49:53','2021-09-27 22:49:53'),(935,3,150.0000,'cash','credit','sell',477,'2021-09-28 18:11:16','2021-09-28 18:11:16'),(936,3,0.0000,'cash','credit','sell',477,'2021-09-28 18:11:16','2021-09-28 18:11:16'),(937,3,200.0000,'cash','credit','sell',478,'2021-09-28 19:02:25','2021-09-28 19:02:25'),(938,3,0.0000,'cash','credit','sell',478,'2021-09-28 19:02:25','2021-09-28 19:02:25'),(939,3,150.0000,'cash','credit','sell',479,'2021-09-28 19:10:23','2021-09-28 19:10:23'),(940,3,0.0000,'cash','credit','sell',479,'2021-09-28 19:10:23','2021-09-28 19:10:23'),(941,3,300.0000,'cash','credit','sell',480,'2021-09-28 19:14:09','2021-09-28 19:14:09'),(942,3,0.0000,'cash','credit','sell',480,'2021-09-28 19:14:09','2021-09-28 19:14:09'),(943,3,500.0000,'cash','credit','sell',481,'2021-09-28 19:51:22','2021-09-28 19:51:22'),(944,3,0.0000,'cash','credit','sell',481,'2021-09-28 19:51:22','2021-09-28 19:51:22'),(945,3,500.0000,'cash','credit','sell',482,'2021-09-28 20:29:23','2021-09-28 20:29:23'),(946,3,0.0000,'cash','credit','sell',482,'2021-09-28 20:29:23','2021-09-28 20:29:23'),(947,3,250.0000,'cash','credit','sell',483,'2021-09-28 21:07:07','2021-09-28 21:07:07'),(948,3,0.0000,'cash','credit','sell',483,'2021-09-28 21:07:07','2021-09-28 21:07:07'),(949,3,200.0000,'cash','credit','sell',484,'2021-09-28 22:22:01','2021-09-28 22:22:01'),(950,3,0.0000,'cash','credit','sell',484,'2021-09-28 22:22:01','2021-09-28 22:22:01'),(951,3,950.0000,'cash','credit','sell',485,'2021-09-28 22:22:41','2021-09-28 22:22:41'),(952,3,0.0000,'cash','credit','sell',485,'2021-09-28 22:22:41','2021-09-28 22:22:41'),(953,3,450.0000,'cash','credit','sell',486,'2021-09-28 22:23:36','2021-09-28 22:23:36'),(954,3,0.0000,'cash','credit','sell',486,'2021-09-28 22:23:36','2021-09-28 22:23:36'),(955,3,150.0000,'cash','credit','sell',487,'2021-09-28 22:24:24','2021-09-28 22:24:24'),(956,3,0.0000,'cash','credit','sell',487,'2021-09-28 22:24:24','2021-09-28 22:24:24'),(957,3,600.0000,'cash','credit','sell',488,'2021-09-28 22:25:09','2021-09-28 22:25:09'),(958,3,0.0000,'cash','credit','sell',488,'2021-09-28 22:25:09','2021-09-28 22:25:09'),(959,3,250.0000,'cash','credit','sell',489,'2021-09-28 22:25:56','2021-09-28 22:25:56'),(960,3,0.0000,'cash','credit','sell',489,'2021-09-28 22:25:56','2021-09-28 22:25:56'),(961,4,100.0000,'cash','credit','sell',490,'2021-09-29 14:27:41','2021-09-29 14:27:41'),(962,4,0.0000,'cash','credit','sell',490,'2021-09-29 14:27:41','2021-09-29 14:27:41'),(963,4,600.0000,'cash','credit','sell',491,'2021-09-29 15:53:26','2021-09-29 15:53:26'),(964,4,0.0000,'cash','credit','sell',491,'2021-09-29 15:53:26','2021-09-29 15:53:26'),(965,4,100.0000,'cash','credit','sell',492,'2021-09-29 16:51:48','2021-09-29 16:51:48'),(966,4,0.0000,'cash','credit','sell',492,'2021-09-29 16:51:48','2021-09-29 16:51:48'),(967,4,1600.0000,'cash','credit','sell',493,'2021-09-29 16:52:25','2021-09-29 16:52:25'),(968,4,0.0000,'cash','credit','sell',493,'2021-09-29 16:52:25','2021-09-29 16:52:25'),(969,4,1300.0000,'cash','credit','sell',494,'2021-09-29 16:53:14','2021-09-29 16:53:14'),(970,4,0.0000,'cash','credit','sell',494,'2021-09-29 16:53:14','2021-09-29 16:53:14'),(971,4,50.0000,'cash','credit','sell',495,'2021-09-29 16:54:10','2021-09-29 16:54:10'),(972,4,0.0000,'cash','credit','sell',495,'2021-09-29 16:54:10','2021-09-29 16:54:10'),(973,4,1200.0000,'cash','credit','sell',496,'2021-09-29 16:57:34','2021-09-29 16:57:34'),(974,4,0.0000,'cash','credit','sell',496,'2021-09-29 16:57:34','2021-09-29 16:57:34'),(975,4,100.0000,'cash','credit','sell',497,'2021-09-29 17:20:24','2021-09-29 17:20:24'),(976,4,0.0000,'cash','credit','sell',497,'2021-09-29 17:20:24','2021-09-29 17:20:24'),(977,4,1100.0000,'cash','credit','sell',498,'2021-09-29 17:59:00','2021-09-29 17:59:00'),(978,4,0.0000,'cash','credit','sell',498,'2021-09-29 17:59:00','2021-09-29 17:59:00'),(979,4,1150.0000,'cash','credit','sell',499,'2021-09-29 18:03:27','2021-09-29 18:03:27'),(980,4,0.0000,'cash','credit','sell',499,'2021-09-29 18:03:27','2021-09-29 18:03:27'),(981,4,150.0000,'cash','credit','sell',500,'2021-09-29 18:57:49','2021-09-29 18:57:49'),(982,4,0.0000,'cash','credit','sell',500,'2021-09-29 18:57:49','2021-09-29 18:57:49'),(983,4,400.0000,'cash','credit','sell',501,'2021-09-29 21:25:15','2021-09-29 21:25:15'),(984,4,0.0000,'cash','credit','sell',501,'2021-09-29 21:25:15','2021-09-29 21:25:15'),(985,4,175.0000,'cash','credit','sell',502,'2021-09-29 21:25:55','2021-09-29 21:25:55'),(986,4,0.0000,'cash','credit','sell',502,'2021-09-29 21:25:55','2021-09-29 21:25:55'),(987,4,175.0000,'cash','credit','sell',503,'2021-09-29 21:28:03','2021-09-29 21:28:03'),(988,4,0.0000,'cash','credit','sell',503,'2021-09-29 21:28:03','2021-09-29 21:28:03'),(989,4,75.0000,'cash','credit','sell',504,'2021-09-29 21:29:45','2021-09-29 21:29:45'),(990,4,0.0000,'cash','credit','sell',504,'2021-09-29 21:29:45','2021-09-29 21:29:45'),(991,4,75.0000,'cash','credit','sell',505,'2021-09-29 21:31:05','2021-09-29 21:31:05'),(992,4,0.0000,'cash','credit','sell',505,'2021-09-29 21:31:05','2021-09-29 21:31:05'),(993,4,600.0000,'cash','credit','sell',506,'2021-09-29 21:47:49','2021-09-29 21:47:49'),(994,4,0.0000,'cash','credit','sell',506,'2021-09-29 21:47:49','2021-09-29 21:47:49'),(995,4,400.0000,'cash','credit','sell',507,'2021-09-29 21:50:22','2021-09-29 21:50:22'),(996,4,0.0000,'cash','credit','sell',507,'2021-09-29 21:50:22','2021-09-29 21:50:22'),(997,4,300.0000,'cash','credit','sell',508,'2021-09-29 21:51:13','2021-09-29 21:51:13'),(998,4,0.0000,'cash','credit','sell',508,'2021-09-29 21:51:13','2021-09-29 21:51:13'),(999,4,550.0000,'cash','credit','sell',509,'2021-09-29 21:52:04','2021-09-29 21:52:04'),(1000,4,0.0000,'cash','credit','sell',509,'2021-09-29 21:52:04','2021-09-29 21:52:04'),(1001,4,50.0000,'cash','credit','sell',510,'2021-09-29 21:52:50','2021-09-29 21:52:50'),(1002,4,0.0000,'cash','credit','sell',510,'2021-09-29 21:52:50','2021-09-29 21:52:50'),(1003,4,500.0000,'cash','credit','sell',511,'2021-09-29 22:02:10','2021-09-29 22:02:10'),(1004,4,0.0000,'cash','credit','sell',511,'2021-09-29 22:02:10','2021-09-29 22:02:10'),(1005,4,1100.0000,'cash','credit','sell',512,'2021-09-29 22:58:13','2021-09-29 22:58:13'),(1006,4,0.0000,'cash','credit','sell',512,'2021-09-29 22:58:13','2021-09-29 22:58:13'),(1007,4,550.0000,'cash','credit','sell',513,'2021-09-29 22:59:14','2021-09-29 22:59:14'),(1008,4,0.0000,'cash','credit','sell',513,'2021-09-29 22:59:14','2021-09-29 22:59:14'),(1009,4,150.0000,'cash','credit','sell',514,'2021-09-29 23:00:03','2021-09-29 23:00:03'),(1010,4,0.0000,'cash','credit','sell',514,'2021-09-29 23:00:03','2021-09-29 23:00:03'),(1011,3,200.0000,'cash','credit','sell',515,'2021-09-30 14:11:38','2021-09-30 14:11:38'),(1012,3,0.0000,'cash','credit','sell',515,'2021-09-30 14:11:38','2021-09-30 14:11:38'),(1013,3,400.0000,'cash','credit','sell',516,'2021-09-30 15:54:42','2021-09-30 15:54:42'),(1014,3,0.0000,'cash','credit','sell',516,'2021-09-30 15:54:42','2021-09-30 15:54:42'),(1015,3,550.0000,'cash','credit','sell',517,'2021-09-30 17:08:24','2021-09-30 17:08:24'),(1016,3,0.0000,'cash','credit','sell',517,'2021-09-30 17:08:24','2021-09-30 17:08:24');
/*!40000 ALTER TABLE `cash_register_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_registers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cash_registers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(11) DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `status` enum('close','open') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `closed_at` datetime DEFAULT NULL,
  `closing_amount` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `total_card_slips` int(11) NOT NULL DEFAULT '0',
  `total_cheques` int(11) NOT NULL DEFAULT '0',
  `closing_note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `cash_registers_business_id_foreign` (`business_id`) USING BTREE,
  KEY `cash_registers_user_id_foreign` (`user_id`) USING BTREE,
  KEY `cash_registers_location_id_index` (`location_id`) USING BTREE,
  CONSTRAINT `cash_registers_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cash_registers_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_registers` WRITE;
/*!40000 ALTER TABLE `cash_registers` DISABLE KEYS */;
INSERT INTO `cash_registers` VALUES (1,1,1,1,'open',NULL,0.0000,0,0,NULL,'2021-08-05 22:24:00','2021-08-05 22:24:06'),(2,1,1,9,'open',NULL,0.0000,0,0,NULL,'2021-08-16 15:56:00','2021-08-16 15:56:54'),(3,1,1,4,'open',NULL,0.0000,0,0,NULL,'2021-08-16 16:23:00','2021-08-16 16:23:27'),(4,1,1,11,'open',NULL,0.0000,0,0,NULL,'2021-09-12 21:48:00','2021-09-12 21:48:17'),(5,1,1,19,'open',NULL,0.0000,0,0,NULL,'2021-09-21 21:56:00','2021-09-21 21:56:29'),(6,1,1,20,'open',NULL,0.0000,0,0,NULL,'2021-09-24 19:04:00','2021-09-24 19:04:26');
/*!40000 ALTER TABLE `cash_registers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `short_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` int(11) NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `category_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `categories_business_id_foreign` (`business_id`) USING BTREE,
  KEY `categories_created_by_foreign` (`created_by`) USING BTREE,
  KEY `categories_parent_id_index` (`parent_id`) USING BTREE,
  CONSTRAINT `categories_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `categories_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'Mobiles',1,NULL,0,1,'device','Mobile device',NULL,NULL,'2021-08-05 22:02:18','2021-08-07 21:09:48'),(2,'Tablet',1,NULL,0,1,'device','Tablet device',NULL,NULL,'2021-08-07 15:46:14','2021-08-07 21:09:59'),(3,'Motherboard',1,'001',0,1,'product',NULL,NULL,NULL,'2021-09-16 21:05:30','2021-09-16 21:05:30');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `categorizables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorizables` (
  `category_id` int(11) NOT NULL,
  `categorizable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `categorizable_id` bigint(20) unsigned NOT NULL,
  KEY `categorizables_categorizable_type_categorizable_id_index` (`categorizable_type`,`categorizable_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `categorizables` WRITE;
/*!40000 ALTER TABLE `categorizables` DISABLE KEYS */;
/*!40000 ALTER TABLE `categorizables` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contacts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `supplier_business_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `first_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `middle_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `tax_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address_line_1` text COLLATE utf8mb4_unicode_ci,
  `address_line_2` text COLLATE utf8mb4_unicode_ci,
  `zip_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `mobile` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `landline` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alternate_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pay_term_number` int(11) DEFAULT NULL,
  `pay_term_type` enum('days','months') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `credit_limit` decimal(22,4) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `balance` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `total_rp` int(11) NOT NULL DEFAULT '0' COMMENT 'rp is the short form of reward points',
  `total_rp_used` int(11) NOT NULL DEFAULT '0' COMMENT 'rp is the short form of reward points',
  `total_rp_expired` int(11) NOT NULL DEFAULT '0' COMMENT 'rp is the short form of reward points',
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `shipping_address` text COLLATE utf8mb4_unicode_ci,
  `position` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_group_id` int(11) DEFAULT NULL,
  `custom_field1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field5` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field6` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field7` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field8` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field9` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field10` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `contacts_business_id_foreign` (`business_id`) USING BTREE,
  KEY `contacts_created_by_foreign` (`created_by`) USING BTREE,
  KEY `contacts_type_index` (`type`) USING BTREE,
  KEY `contacts_contact_status_index` (`contact_status`) USING BTREE,
  CONSTRAINT `contacts_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contacts_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=694 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` VALUES (1,1,'customer',NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,0.0000,1,0.0000,0,0,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-06 01:22:09','2021-08-06 01:22:09'),(2,1,'customer',NULL,'Mr Dahashan  ','Mr','Dahashan',NULL,NULL,NULL,'1','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0111152021215',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-06 02:28:33','2021-08-06 02:36:43'),(3,1,'customer',NULL,' Marwa Mohy ',NULL,'Marwa','Mohy',NULL,NULL,'CO0003','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'975433567',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-08 00:57:35','2021-08-08 00:57:35'),(4,1,'customer',NULL,' Magdy  ',NULL,'Magdy',NULL,NULL,NULL,'CO0004','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01099987654',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-08 14:59:47','2021-08-08 14:59:47'),(5,1,'customer',NULL,'mr islam ashrief ','mr','islam','ashrief',NULL,NULL,'CO0005','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0102222222',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-13 21:20:53','2021-08-13 21:20:53'),(6,1,'customer',NULL,' MAGI EL KEDWANY ',NULL,'MAGI','EL KEDWANY',NULL,NULL,'CO0006','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01155117788',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-16 15:08:07','2021-08-16 15:08:07'),(7,1,'customer',NULL,' SAIF YOUSEF ',NULL,'SAIF','YOUSEF',NULL,NULL,'SAIF','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01023951246',NULL,NULL,NULL,NULL,NULL,9,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-16 16:00:28','2021-08-16 16:00:28'),(8,1,'customer',NULL,'MISS SAMA  ATEF','MISS','SAMA',NULL,'ATEF',NULL,'SAMA ATEF','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'010000000',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-16 16:20:18','2021-09-22 19:26:09'),(9,1,'customer',NULL,' اسماء رمضان  ',NULL,'اسماء رمضان',NULL,NULL,NULL,'0113058480','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0113058480',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-16 16:34:33','2021-08-16 16:34:33'),(10,1,'customer',NULL,'Mr Yassen Allam ','Mr','Yassen','Allam',NULL,NULL,'CO0010','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'012235375',NULL,NULL,NULL,NULL,NULL,9,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-16 17:53:18','2021-08-16 17:53:18'),(11,1,'customer',NULL,'Mr MIDO  MOHAMED','Mr','MIDO',NULL,'MOHAMED',NULL,'CO0011','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01111165376',NULL,NULL,NULL,NULL,NULL,9,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-16 18:40:14','2021-08-16 18:40:14'),(12,1,'customer',NULL,' محمد طلعت  ',NULL,'محمد طلعت',NULL,NULL,NULL,'CO0012','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01144099099',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-19 18:36:43','2021-08-19 18:36:43'),(13,1,'customer',NULL,' اسلام اشرف  ',NULL,'اسلام اشرف',NULL,NULL,NULL,'CO0013','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01144099099',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-19 21:35:34','2021-08-19 21:35:34'),(14,1,'customer',NULL,' talaat mohamed ',NULL,'talaat','mohamed',NULL,NULL,'CO0014','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01144099099',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-21 14:19:52','2021-08-21 14:19:52'),(15,1,'customer',NULL,' محمد فريد  ',NULL,'محمد فريد',NULL,NULL,NULL,'CO0015','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01155555555',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-21 17:17:07','2021-08-21 17:17:07'),(16,1,'customer',NULL,' محمد سعيد ',NULL,'محمد','سعيد',NULL,NULL,'CO0016','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01157354333',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-22 14:21:41','2021-08-22 14:21:41'),(17,1,'customer',NULL,' محمد فؤاد ',NULL,'محمد','فؤاد',NULL,NULL,'CO0017','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01010117099',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-22 14:30:13','2021-08-22 14:30:13'),(18,1,'customer',NULL,' محمود رجب ',NULL,'محمود','رجب',NULL,NULL,'CO0018','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01143300875',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-22 14:44:55','2021-08-22 14:44:55'),(19,1,'customer',NULL,' احمد ابراهيم ',NULL,'احمد','ابراهيم',NULL,NULL,'CO0019','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01286022006',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-22 17:27:08','2021-08-22 17:27:08'),(20,1,'customer',NULL,' جون نادر ',NULL,'جون','نادر',NULL,NULL,'CO0020','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01278833706',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-22 18:11:41','2021-08-22 18:11:41'),(21,1,'customer',NULL,' محمد هشام  ',NULL,'محمد هشام',NULL,NULL,NULL,'CO0021','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01006218055',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-22 19:57:38','2021-08-22 19:57:38'),(22,1,'customer',NULL,' نداء عبد الرحمن  ',NULL,'نداء عبد الرحمن',NULL,NULL,NULL,'CO0022','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01015251005',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-22 21:04:50','2021-08-22 21:04:50'),(23,1,'customer',NULL,' احمد جلال  ',NULL,'احمد جلال',NULL,NULL,NULL,'CO0023','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01117506030',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-22 22:03:02','2021-08-22 22:03:02'),(24,1,'customer',NULL,' اشرف عبد الحميد  ',NULL,'اشرف عبد الحميد',NULL,NULL,NULL,'CO0024','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01113855007',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-23 12:48:38','2021-08-23 12:48:38'),(25,1,'customer',NULL,' ربيع فوزي  ',NULL,'ربيع فوزي',NULL,NULL,NULL,'CO0025','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01019404854',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-23 13:17:54','2021-08-23 13:17:54'),(26,1,'customer',NULL,' محمد وحيد ',NULL,'محمد','وحيد',NULL,NULL,'CO0026','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01100213494',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-23 14:42:46','2021-08-23 14:42:46'),(27,1,'customer',NULL,' عمر جمال  ',NULL,'عمر جمال',NULL,NULL,NULL,'CO0027','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01140449825',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-23 14:43:24','2021-08-23 14:43:24'),(28,1,'customer',NULL,' سيد بدري  ',NULL,'سيد بدري',NULL,NULL,NULL,'CO0028','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01116561999',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-23 15:06:23','2021-08-23 15:06:23'),(29,1,'customer',NULL,' طارق رشاد ',NULL,'طارق','رشاد',NULL,NULL,'CO0029','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01007998515',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-23 15:13:10','2021-08-23 15:13:10'),(30,1,'customer',NULL,' احمد طه  ',NULL,'احمد طه',NULL,NULL,NULL,'CO0030','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01227842487',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-23 16:39:58','2021-08-23 16:39:58'),(31,1,'customer',NULL,' خالد فتحي ',NULL,'خالد','فتحي',NULL,NULL,'CO0031','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'000000',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-23 16:51:07','2021-08-23 16:51:07'),(32,1,'customer',NULL,' اسلام ناصر  ',NULL,'اسلام ناصر',NULL,NULL,NULL,'CO0032','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01110966965',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-23 17:06:27','2021-08-23 17:06:27'),(33,1,'customer',NULL,' هشام يوسف ',NULL,'هشام','يوسف',NULL,NULL,'CO0033','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01004603085',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-23 19:00:04','2021-08-23 19:00:04'),(34,1,'customer',NULL,' محمد حسين ',NULL,'محمد','حسين',NULL,NULL,'CO0034','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01112328603',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-23 19:21:12','2021-08-23 19:21:12'),(35,1,'customer',NULL,' حسين محمد ',NULL,'حسين','محمد',NULL,NULL,'CO0035','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01228028069',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-23 19:55:43','2021-08-23 19:55:43'),(36,1,'customer',NULL,' اسلام الشامي ',NULL,'اسلام','الشامي',NULL,NULL,'CO0036','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01015159995',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-23 20:37:11','2021-08-23 20:37:11'),(37,1,'customer',NULL,' محمد عبد الوهاب  ',NULL,'محمد عبد الوهاب',NULL,NULL,NULL,'CO0037','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01158885990',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-23 20:51:29','2021-08-23 20:51:29'),(38,1,'customer',NULL,' عبد الراوف محمد  ',NULL,'عبد الراوف محمد',NULL,NULL,NULL,'CO0038','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01022474823',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-23 20:55:49','2021-08-23 20:55:49'),(39,1,'customer',NULL,' لؤي رافت ',NULL,'لؤي','رافت',NULL,NULL,'CO0039','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01032508166',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-23 22:18:21','2021-08-23 22:18:21'),(40,1,'customer',NULL,' محمد جمعه ',NULL,'محمد','جمعه',NULL,NULL,'CO0040','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01118727030',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-23 22:46:36','2021-08-23 22:46:36'),(41,1,'customer',NULL,' منار طلعت ',NULL,'منار','طلعت',NULL,NULL,'CO0041','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01110267016',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-23 23:03:49','2021-08-23 23:03:49'),(42,1,'customer',NULL,' وليد دسوقي  ',NULL,'وليد دسوقي',NULL,NULL,NULL,'CO0042','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01001370296',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-24 12:30:22','2021-08-24 12:30:22'),(43,1,'customer',NULL,' سعد مجدي  ',NULL,'سعد مجدي',NULL,NULL,NULL,'CO0043','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01113846705',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-24 13:40:01','2021-08-24 13:40:01'),(44,1,'customer',NULL,' بدر الخولي ',NULL,'بدر','الخولي',NULL,NULL,'CO0044','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01110389881',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-24 13:50:01','2021-08-24 13:50:01'),(45,1,'customer',NULL,' بدر الخولي  ',NULL,'بدر الخولي',NULL,NULL,NULL,'CO0045','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01110389881',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-24 13:52:41','2021-08-24 13:52:41'),(46,1,'customer',NULL,' محمد رمضان ',NULL,'محمد','رمضان',NULL,NULL,'CO0046','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01002433825',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-24 14:39:12','2021-08-24 14:39:12'),(47,1,'customer',NULL,' محمدحسن  ',NULL,'محمدحسن',NULL,NULL,NULL,'CO0047','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01129718621',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-24 14:48:08','2021-08-24 14:48:08'),(48,1,'customer',NULL,' داليا خميس ',NULL,'داليا','خميس',NULL,NULL,'CO0048','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01153377699',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-24 14:48:50','2021-08-24 14:48:50'),(49,1,'customer',NULL,' داليا خميس ',NULL,'داليا','خميس',NULL,NULL,'CO0049','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01153377699',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-24 14:53:39','2021-08-24 14:53:39'),(50,1,'customer',NULL,' صلاح ابو عبدالرحمن ',NULL,'صلاح','ابو عبدالرحمن',NULL,NULL,'CO0050','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01111165376',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-24 15:37:40','2021-08-24 15:37:40'),(51,1,'customer',NULL,' صلاح ابو عبدالرحمن ',NULL,'صلاح','ابو عبدالرحمن',NULL,NULL,'CO0051','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01111165376',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-24 15:37:40','2021-08-24 15:37:40'),(52,1,'customer',NULL,' مصطفي زين ',NULL,'مصطفي','زين',NULL,NULL,'CO0052','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01119017535',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-24 16:41:38','2021-08-24 16:41:38'),(53,1,'customer',NULL,' سيف وليد ',NULL,'سيف','وليد',NULL,NULL,'CO0053','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01113874797',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-24 16:57:52','2021-08-24 16:57:52'),(54,1,'customer',NULL,' سيف وليد ',NULL,'سيف','وليد',NULL,NULL,'CO0054','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01113874797',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-24 17:02:17','2021-08-24 17:02:17'),(55,1,'customer',NULL,' سيف وليد ',NULL,'سيف','وليد',NULL,NULL,'CO0055','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01113874797',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-24 17:06:25','2021-08-24 17:06:25'),(56,1,'customer',NULL,' نهله عبدالحليم ',NULL,'نهله','عبدالحليم',NULL,NULL,'CO0056','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01118132762',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-24 17:08:23','2021-08-24 17:08:23'),(57,1,'customer',NULL,' فيصل عدنان ',NULL,'فيصل','عدنان',NULL,NULL,'CO0057','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01118790954',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-24 17:17:55','2021-08-24 17:17:55'),(58,1,'customer',NULL,' فيصيل عدنان ',NULL,'فيصيل','عدنان',NULL,NULL,'CO0058','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01118796954',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-24 17:20:51','2021-08-24 17:20:51'),(59,1,'customer',NULL,' محمود عثمان ',NULL,'محمود','عثمان',NULL,NULL,'CO0059','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01116310116',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-24 18:23:33','2021-08-24 18:23:33'),(60,1,'customer',NULL,' محمود عثمان ',NULL,'محمود','عثمان',NULL,NULL,'CO0060','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01116310116',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-24 18:25:08','2021-08-24 18:25:08'),(61,1,'customer',NULL,' محمد سمير ',NULL,'محمد','سمير',NULL,NULL,'CO0061','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01011643314',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-24 18:37:52','2021-08-24 18:37:52'),(62,1,'customer',NULL,' صلاح ابو عبدالرحمن ',NULL,'صلاح','ابو عبدالرحمن',NULL,NULL,'CO0062','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01111165376',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-24 18:43:48','2021-08-24 18:43:48'),(63,1,'customer',NULL,' احمد صالح  ',NULL,'احمد صالح',NULL,NULL,NULL,'CO0063','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01124242625',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-24 19:22:06','2021-08-24 19:22:06'),(64,1,'customer',NULL,' ايمان احمد  ',NULL,'ايمان احمد',NULL,NULL,NULL,'CO0064','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01068928333',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-24 19:28:09','2021-08-24 19:28:09'),(65,1,'customer',NULL,' مريم ايمن  ',NULL,'مريم ايمن',NULL,NULL,NULL,'CO0065','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01229291871',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-24 20:52:16','2021-08-24 20:52:16'),(66,1,'customer',NULL,' حاتم محمد  ',NULL,'حاتم محمد',NULL,NULL,NULL,'CO0066','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01024832671','0227840351',NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-24 21:39:16','2021-08-24 21:39:16'),(67,1,'customer',NULL,' عمر شعبان ',NULL,'عمر','شعبان',NULL,NULL,'CO0067','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01122902016',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-24 21:42:54','2021-08-24 21:42:54'),(68,1,'customer',NULL,' احمد عبد المحسن ',NULL,'احمد','عبد المحسن',NULL,NULL,'CO0068','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01555701000',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-24 23:29:14','2021-08-24 23:29:14'),(69,1,'customer',NULL,' شريف حسن ',NULL,'شريف','حسن',NULL,NULL,'CO0069','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01011372396',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-25 13:26:45','2021-08-25 13:26:45'),(70,1,'customer',NULL,' اسلام اشرف  ',NULL,'اسلام اشرف',NULL,NULL,NULL,'CO0070','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01023314353',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-25 14:02:35','2021-08-25 14:02:35'),(71,1,'customer',NULL,' مصطفي زفيق  ',NULL,'مصطفي زفيق',NULL,NULL,NULL,'CO0071','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01018821643',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-25 14:11:14','2021-08-25 14:11:14'),(72,1,'customer',NULL,' عمرو عزت  ',NULL,'عمرو عزت',NULL,NULL,NULL,'CO0072','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01145545572',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-25 15:01:49','2021-08-25 15:01:49'),(73,1,'customer',NULL,' عمرو عزت  ',NULL,'عمرو عزت',NULL,NULL,NULL,'CO0073','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01145545572',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-25 15:06:53','2021-08-25 15:06:53'),(74,1,'customer',NULL,' مازن محمد ',NULL,'مازن','محمد',NULL,NULL,'CO0074','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01100881939',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-25 15:13:34','2021-08-25 15:13:34'),(75,1,'customer',NULL,' اسلام مصطفي  ',NULL,'اسلام مصطفي',NULL,NULL,NULL,'CO0075','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01149956942',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-25 15:37:42','2021-08-25 15:37:42'),(76,1,'customer',NULL,' احمد الملاح  ',NULL,'احمد الملاح',NULL,NULL,NULL,'CO0076','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01270961791',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-25 15:47:32','2021-08-25 15:47:32'),(77,1,'customer',NULL,' اسلام رجب  ',NULL,'اسلام رجب',NULL,NULL,NULL,'CO0077','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01123337726',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-25 16:09:37','2021-08-25 16:09:37'),(78,1,'customer',NULL,' كريم محمد  ',NULL,'كريم محمد',NULL,NULL,NULL,'CO0078','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01115137442',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-25 16:33:00','2021-08-25 16:33:00'),(79,1,'customer',NULL,' مؤمن كمال  ',NULL,'مؤمن كمال',NULL,NULL,NULL,'CO0079','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01066399440',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-25 16:45:21','2021-08-25 16:45:21'),(80,1,'customer',NULL,' محمود محمد  ',NULL,'محمود محمد',NULL,NULL,NULL,'CO0080','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01159444785',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-25 17:12:05','2021-08-25 17:12:05'),(81,1,'customer',NULL,' حاتم محمد  ',NULL,'حاتم محمد',NULL,NULL,NULL,'CO0081','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01024832671',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-25 19:06:19','2021-08-25 19:06:19'),(82,1,'customer',NULL,' محمود راضي  ',NULL,'محمود راضي',NULL,NULL,NULL,'CO0082','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01022504122',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-25 19:59:05','2021-08-25 19:59:05'),(83,1,'customer',NULL,' ياسر محروس  ',NULL,'ياسر محروس',NULL,NULL,NULL,'CO0083','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01100500706',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-25 20:07:55','2021-08-25 20:07:55'),(84,1,'customer',NULL,' سمير محمد  ',NULL,'سمير محمد',NULL,NULL,NULL,'CO0084','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01122162885',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-25 20:12:44','2021-08-25 20:12:44'),(85,1,'customer',NULL,' محمد شوقي  ',NULL,'محمد شوقي',NULL,NULL,NULL,'CO0085','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01153567788',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-25 20:21:17','2021-08-25 20:21:17'),(86,1,'customer',NULL,' وليد حسن  ',NULL,'وليد حسن',NULL,NULL,NULL,'CO0086','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-26 14:02:13','2021-08-26 14:02:13'),(87,1,'customer',NULL,' مجدي عطيه  ',NULL,'مجدي عطيه',NULL,NULL,NULL,'CO0087','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01006761153',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-26 14:16:51','2021-08-26 14:16:51'),(88,1,'customer',NULL,' محمود السيد ',NULL,'محمود','السيد',NULL,NULL,'CO0088','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01008915505',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-26 15:32:48','2021-08-26 15:32:48'),(89,1,'customer',NULL,' مصطفي ياسر  ',NULL,'مصطفي ياسر',NULL,NULL,NULL,'CO0089','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01150333482',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-26 17:32:42','2021-08-26 17:32:42'),(90,1,'customer',NULL,' احمد السيد  ',NULL,'احمد السيد',NULL,NULL,NULL,'CO0090','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01020827666',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-27 14:29:39','2021-08-27 14:29:39'),(91,1,'customer',NULL,' عمرو عزت  ',NULL,'عمرو عزت',NULL,NULL,NULL,'CO0091','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01145545572',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-27 14:43:40','2021-08-27 14:43:40'),(92,1,'customer',NULL,' عمرو عزت  ',NULL,'عمرو عزت',NULL,NULL,NULL,'CO0092','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01145545572',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-27 14:45:49','2021-08-27 14:45:49'),(93,1,'customer',NULL,' محمد محسن  ',NULL,'محمد محسن',NULL,NULL,NULL,'CO0093','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01010052333',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-27 19:29:39','2021-08-27 19:29:39'),(94,1,'customer',NULL,' معتز محمد  ',NULL,'معتز محمد',NULL,NULL,NULL,'CO0094','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01001147731',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-27 20:35:02','2021-08-27 20:35:02'),(95,1,'customer',NULL,' مني بهاء  ',NULL,'مني بهاء',NULL,NULL,NULL,'CO0095','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01004054105',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-27 21:17:17','2021-08-27 21:17:17'),(96,1,'customer',NULL,' مني بهاء  ',NULL,'مني بهاء',NULL,NULL,NULL,'CO0096','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01004054105',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-27 21:17:59','2021-08-27 21:17:59'),(97,1,'customer',NULL,' مني بهاء  ',NULL,'مني بهاء',NULL,NULL,NULL,'CO0097','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01004054105',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-27 21:22:39','2021-08-27 21:22:39'),(98,1,'customer',NULL,' هشام عويس  ',NULL,'هشام عويس',NULL,NULL,NULL,'CO0098','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01090334455',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-27 22:01:08','2021-08-27 22:01:08'),(99,1,'customer',NULL,' ايه جمال  ',NULL,'ايه جمال',NULL,NULL,NULL,'CO0099','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01119017545',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-27 22:38:02','2021-08-27 22:38:02'),(100,1,'customer',NULL,' عمر نبيل ',NULL,'عمر','نبيل',NULL,NULL,'CO0100','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01121885958',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-28 14:00:11','2021-08-28 14:00:11'),(101,1,'customer',NULL,' احمد شبانه  ',NULL,'احمد شبانه',NULL,NULL,NULL,'CO0101','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01102123459',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-28 15:20:51','2021-08-28 15:20:51'),(102,1,'customer',NULL,' رمضان احمد  ',NULL,'رمضان احمد',NULL,NULL,NULL,'CO0102','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01111948465',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-28 15:29:48','2021-08-28 15:29:48'),(103,1,'customer',NULL,' عبدالمنعم محمود ',NULL,'عبدالمنعم','محمود',NULL,NULL,'CO0103','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01118357511',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-28 15:51:36','2021-08-28 15:51:36'),(104,1,'customer',NULL,' ابراهيم سعيد  ',NULL,'ابراهيم سعيد',NULL,NULL,NULL,'CO0104','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01120060539',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-28 16:22:28','2021-08-28 16:22:28'),(105,1,'customer',NULL,' مني محمود ',NULL,'مني','محمود',NULL,NULL,'CO0105','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01009704130',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-28 17:11:43','2021-08-28 17:11:43'),(106,1,'customer',NULL,' رامي عاطف ',NULL,'رامي','عاطف',NULL,NULL,'CO0106','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01112316621',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-28 17:43:04','2021-08-28 17:43:04'),(107,1,'customer',NULL,' محمد رافت  ',NULL,'محمد رافت',NULL,NULL,NULL,'CO0107','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01111828771',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-28 17:43:23','2021-08-28 17:43:23'),(108,1,'customer',NULL,' هند صلاح ',NULL,'هند','صلاح',NULL,NULL,'CO0108','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01122592877',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-28 17:50:26','2021-08-28 17:50:26'),(109,1,'customer',NULL,' محمد احمد ',NULL,'محمد','احمد',NULL,NULL,'CO0109','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01123055711',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-28 18:13:09','2021-08-28 18:13:09'),(110,1,'customer',NULL,' ثروت محمد  ',NULL,'ثروت محمد',NULL,NULL,NULL,'CO0110','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01112188887',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-28 19:06:51','2021-08-28 19:06:51'),(111,1,'customer',NULL,' صلاح الطناني  ',NULL,'صلاح الطناني',NULL,NULL,NULL,'CO0111','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01146644816',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-28 19:25:55','2021-08-28 19:25:55'),(112,1,'customer',NULL,' اسلام نبيل  ',NULL,'اسلام نبيل',NULL,NULL,NULL,'CO0112','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01033380903',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-28 20:53:07','2021-08-28 20:53:07'),(113,1,'customer',NULL,' خالد شعراوي  ',NULL,'خالد شعراوي',NULL,NULL,NULL,'CO0113','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01007349640',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-28 21:02:39','2021-08-28 21:02:39'),(114,1,'customer',NULL,' حسام عبد المنعم  ',NULL,'حسام عبد المنعم',NULL,NULL,NULL,'CO0114','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01100200183',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-28 21:22:11','2021-08-28 21:22:11'),(115,1,'customer',NULL,' احمد طارق  ',NULL,'احمد طارق',NULL,NULL,NULL,'CO0115','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01091701335',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-28 21:28:21','2021-08-28 21:28:21'),(116,1,'customer',NULL,' محمد علي ',NULL,'محمد','علي',NULL,NULL,'CO0116','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01158004997',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-28 22:13:21','2021-08-28 22:13:21'),(117,1,'customer',NULL,' عبدالرحمن عصام ',NULL,'عبدالرحمن','عصام',NULL,NULL,'CO0117','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01021305677',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-28 22:55:04','2021-08-28 22:55:04'),(118,1,'customer',NULL,' معاذ محمد  ',NULL,'معاذ محمد',NULL,NULL,NULL,'CO0118','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01127797515',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-29 12:09:38','2021-08-29 12:09:38'),(119,1,'customer',NULL,' وليد عبد اللطيف  ',NULL,'وليد عبد اللطيف',NULL,NULL,NULL,'CO0119','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01140462892',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-29 12:58:14','2021-08-29 12:58:14'),(120,1,'customer',NULL,' حسام مرعي  ',NULL,'حسام مرعي',NULL,NULL,NULL,'CO0120','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01128418150',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-29 13:02:45','2021-08-29 13:02:45'),(121,1,'customer',NULL,' يوسف طارق ',NULL,'يوسف','طارق',NULL,NULL,'CO0121','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01129920680',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-29 17:15:29','2021-08-29 17:15:29'),(122,1,'customer',NULL,' محمد السيد ',NULL,'محمد','السيد',NULL,NULL,'CO0122','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01090300062',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-29 17:49:30','2021-08-29 17:49:30'),(123,1,'customer',NULL,' عبدالرحمن احمد ',NULL,'عبدالرحمن','احمد',NULL,NULL,'CO0123','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01001450218',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-29 18:04:10','2021-08-29 18:04:10'),(124,1,'customer',NULL,' صالح محمد  ',NULL,'صالح محمد',NULL,NULL,NULL,'CO0124','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01155157350',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-29 18:48:13','2021-08-29 18:48:13'),(125,1,'customer',NULL,' عبدالرحمن ابراهيم ',NULL,'عبدالرحمن','ابراهيم',NULL,NULL,'CO0125','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01096508658',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-29 19:39:35','2021-08-29 19:39:35'),(126,1,'customer',NULL,' اسلام عثمان ',NULL,'اسلام','عثمان',NULL,NULL,'CO0126','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01102118855',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-29 20:04:15','2021-08-29 20:04:15'),(127,1,'customer',NULL,' محمود عمر ',NULL,'محمود','عمر',NULL,NULL,'CO0127','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01155968172',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-29 20:15:05','2021-08-29 20:15:05'),(128,1,'customer',NULL,' محمد محمود ',NULL,'محمد','محمود',NULL,NULL,'CO0128','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01152031779',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-29 20:38:39','2021-08-29 20:38:39'),(129,1,'customer',NULL,' عبدالله رفعت ',NULL,'عبدالله','رفعت',NULL,NULL,'CO0129','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01067716709',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-29 21:07:11','2021-08-29 21:07:11'),(130,1,'customer',NULL,' عبدالله رفعت ',NULL,'عبدالله','رفعت',NULL,NULL,'CO0130','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01067716709',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-29 21:10:04','2021-08-29 21:10:04'),(131,1,'customer',NULL,' محمدابراهيم  ',NULL,'محمدابراهيم',NULL,NULL,NULL,'CO0131','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01000905032',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-29 21:15:45','2021-08-29 21:15:45'),(132,1,'customer',NULL,' الراجل الي مش موجود علي السستيم  ',NULL,'الراجل الي مش موجود علي السستيم',NULL,NULL,NULL,'CO0132','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-29 21:21:52','2021-08-29 21:21:52'),(133,1,'customer',NULL,' ياسر عبد الباسط  ',NULL,'ياسر عبد الباسط',NULL,NULL,NULL,'CO0133','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01120144432',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-29 21:23:19','2021-08-29 21:23:19'),(134,1,'customer',NULL,' احمد شحاته  ',NULL,'احمد شحاته',NULL,NULL,NULL,'CO0134','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01555600060',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-29 21:29:04','2021-08-29 21:29:04'),(135,1,'customer',NULL,' ايمن سالم  ',NULL,'ايمن سالم',NULL,NULL,NULL,'CO0135','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01067417469',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-30 16:21:36','2021-08-30 16:21:36'),(136,1,'customer',NULL,' محمد الطويل  ',NULL,'محمد الطويل',NULL,NULL,NULL,'CO0136','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01027093399',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-30 17:11:41','2021-08-30 17:11:41'),(137,1,'customer',NULL,' يوسف كامل  ',NULL,'يوسف كامل',NULL,NULL,NULL,'CO0137','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01003737608',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-30 17:49:40','2021-08-30 17:49:40'),(138,1,'customer',NULL,' عبد الوهاب عزت  ',NULL,'عبد الوهاب عزت',NULL,NULL,NULL,'CO0138','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01157742226',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-30 18:23:10','2021-08-30 18:23:10'),(139,1,'customer',NULL,' اسلام عصام  ',NULL,'اسلام عصام',NULL,NULL,NULL,'CO0139','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01155568510',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-30 19:07:07','2021-08-30 19:07:07'),(140,1,'customer',NULL,' جمال سامي  ',NULL,'جمال سامي',NULL,NULL,NULL,'CO0140','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01276709760',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-30 19:27:42','2021-08-30 19:27:42'),(141,1,'customer',NULL,' محمد رضا  ',NULL,'محمد رضا',NULL,NULL,NULL,'CO0141','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01097011158',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-30 19:37:04','2021-08-30 19:37:04'),(142,1,'customer',NULL,' هاجر عبدالله ',NULL,'هاجر','عبدالله',NULL,NULL,'CO0142','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01096187495',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-30 20:16:18','2021-08-30 20:16:18'),(143,1,'customer',NULL,' عبدالمنعم محمود ',NULL,'عبدالمنعم','محمود',NULL,NULL,'CO0143','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01118357511',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-30 21:21:54','2021-08-30 21:21:54'),(144,1,'customer',NULL,' ايمان احمد ',NULL,'ايمان','احمد',NULL,NULL,'CO0144','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01068928333',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-30 22:01:04','2021-08-30 22:01:04'),(145,1,'customer',NULL,' اسلام شحاته ',NULL,'اسلام','شحاته',NULL,NULL,'CO0145','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01155291512',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-30 22:32:05','2021-08-30 22:32:05'),(146,1,'customer',NULL,' اسلام شحاته ',NULL,'اسلام','شحاته',NULL,NULL,'CO0146','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01155291512',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-30 22:36:12','2021-08-30 22:36:12'),(147,1,'customer',NULL,' محمود منصور ',NULL,'محمود','منصور',NULL,NULL,'CO0147','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01228479456',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-31 12:59:08','2021-08-31 12:59:08'),(148,1,'customer',NULL,' احمد حامد ',NULL,'احمد','حامد',NULL,NULL,'CO0148','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01008676136',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-31 13:10:18','2021-08-31 13:10:18'),(149,1,'customer',NULL,' ماهر ماهر ',NULL,'ماهر','ماهر',NULL,NULL,'CO0149','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01125638645',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-31 14:40:25','2021-08-31 14:40:25'),(150,1,'customer',NULL,' فرغلي احمد ',NULL,'فرغلي','احمد',NULL,NULL,'CO0150','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01030835338',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-31 16:46:46','2021-08-31 16:46:46'),(151,1,'customer',NULL,' محمود جابر  ',NULL,'محمود جابر',NULL,NULL,NULL,'CO0151','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01270150690',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-31 17:09:05','2021-08-31 17:09:05'),(152,1,'customer',NULL,' عبد الحميد فرج  ',NULL,'عبد الحميد فرج',NULL,NULL,NULL,'CO0152','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01142048373',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-31 17:29:52','2021-08-31 17:29:52'),(153,1,'customer',NULL,' محمد يسري  ',NULL,'محمد يسري',NULL,NULL,NULL,'CO0153','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01205125049',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-31 17:55:07','2021-08-31 17:55:07'),(154,1,'customer',NULL,' رحاب محمود ',NULL,'رحاب','محمود',NULL,NULL,'CO0154','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01114563060',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-31 18:54:03','2021-08-31 18:54:03'),(155,1,'customer',NULL,' ابراهيم فتحي  ',NULL,'ابراهيم فتحي',NULL,NULL,NULL,'CO0155','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01120015642',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-31 18:54:05','2021-08-31 18:54:05'),(156,1,'customer',NULL,' وليد خاطر  ',NULL,'وليد خاطر',NULL,NULL,NULL,'CO0156','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01022207822',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-31 20:36:39','2021-08-31 20:36:39'),(157,1,'customer',NULL,' شهندا عادل  ',NULL,'شهندا عادل',NULL,NULL,NULL,'CO0157','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01098869254',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-31 21:02:27','2021-08-31 21:02:27'),(158,1,'customer',NULL,' احمد خليل ',NULL,'احمد','خليل',NULL,NULL,'CO0158','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01000254711',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-31 21:20:15','2021-08-31 21:20:15'),(159,1,'customer',NULL,' محمد عادل  ',NULL,'محمد عادل',NULL,NULL,NULL,'CO0159','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01001249253',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-31 21:32:06','2021-08-31 21:32:06'),(160,1,'customer',NULL,' باسل وليد ',NULL,'باسل','وليد',NULL,NULL,'CO0160','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01145607772',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-08-31 21:39:54','2021-08-31 21:39:54'),(161,1,'customer',NULL,' محمد عدلي  ',NULL,'محمد عدلي',NULL,NULL,NULL,'CO0161','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01115662994',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 14:00:23','2021-09-01 14:00:23'),(162,1,'customer',NULL,' احمد طه ',NULL,'احمد','طه',NULL,NULL,'CO0162','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01227842487',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 14:38:16','2021-09-01 14:38:16'),(163,1,'customer',NULL,' احمد طه ',NULL,'احمد','طه',NULL,NULL,'CO0163','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01227842487',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 14:43:55','2021-09-01 14:43:55'),(164,1,'customer',NULL,' مدحت سعيد ',NULL,'مدحت','سعيد',NULL,NULL,'CO0164','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01066615141',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 15:06:49','2021-09-01 15:06:49'),(165,1,'customer',NULL,' طه ياسين  ',NULL,'طه ياسين',NULL,NULL,NULL,'CO0165','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01094361450',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 15:32:01','2021-09-01 15:32:01'),(166,1,'customer',NULL,' احمد طه  ',NULL,'احمد طه',NULL,NULL,NULL,'CO0166','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01227842487',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 15:47:18','2021-09-01 15:47:18'),(167,1,'customer',NULL,' محمود دبي ',NULL,'محمود','دبي',NULL,NULL,'CO0167','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01150559934',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 15:53:08','2021-09-01 15:53:08'),(168,1,'customer',NULL,' طارق عباس  ',NULL,'طارق عباس',NULL,NULL,NULL,'CO0168','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01114647933',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 15:58:50','2021-09-01 15:58:50'),(169,1,'customer',NULL,' صلاح ابو عبد الرحمن  ',NULL,'صلاح ابو عبد الرحمن',NULL,NULL,NULL,'CO0169','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01102850511',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 16:04:46','2021-09-01 16:04:46'),(170,1,'customer',NULL,' مفرح رجب  ',NULL,'مفرح رجب',NULL,NULL,NULL,'CO0170','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01120595912',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 16:12:21','2021-09-01 16:12:21'),(171,1,'customer',NULL,' احمد صابر  ',NULL,'احمد صابر',NULL,NULL,NULL,'CO0171','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01128833956',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 16:26:27','2021-09-01 16:26:27'),(172,1,'customer',NULL,' خالد سالم  ',NULL,'خالد سالم',NULL,NULL,NULL,'CO0172','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01228554748',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 17:07:20','2021-09-01 17:07:20'),(173,1,'customer',NULL,' اسلام سامي  ',NULL,'اسلام سامي',NULL,NULL,NULL,'CO0173','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01110287830',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 17:33:14','2021-09-01 17:33:14'),(174,1,'customer',NULL,' جمال موسي  ',NULL,'جمال موسي',NULL,NULL,NULL,'CO0174','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'010901486074',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 17:36:20','2021-09-01 17:36:20'),(175,1,'customer',NULL,' احمد مصطفي  ',NULL,'احمد مصطفي',NULL,NULL,NULL,'CO0175','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01113325124',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 17:40:33','2021-09-01 17:40:33'),(176,1,'customer',NULL,' عبد الله عبد الحميد  ',NULL,'عبد الله عبد الحميد',NULL,NULL,NULL,'CO0176','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01141025233',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 19:25:19','2021-09-01 19:25:19'),(177,1,'customer',NULL,' احمد مرتضي ',NULL,'احمد','مرتضي',NULL,NULL,'CO0177','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01122281008',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 19:56:20','2021-09-01 19:56:20'),(178,1,'customer',NULL,' محمد محسن  ',NULL,'محمد محسن',NULL,NULL,NULL,'CO0178','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01028694460',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 20:34:40','2021-09-01 20:34:40'),(179,1,'customer',NULL,' عبد الرحمن رمضان  ',NULL,'عبد الرحمن رمضان',NULL,NULL,NULL,'CO0179','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01150903021',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 20:40:19','2021-09-01 20:40:19'),(180,1,'customer',NULL,' التهامي حسين  ',NULL,'التهامي حسين',NULL,NULL,NULL,'CO0180','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01273555608',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 20:44:15','2021-09-01 20:44:15'),(181,1,'customer',NULL,' حمدي محمود  ',NULL,'حمدي محمود',NULL,NULL,NULL,'CO0181','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01228383921',NULL,'01110763463',NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:00:52','2021-09-01 21:00:52'),(182,1,'customer',NULL,' هدي احمد  ',NULL,'هدي احمد',NULL,NULL,NULL,'CO0182','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01033446244',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:11:28','2021-09-01 21:11:28'),(183,1,'customer',NULL,' عبدالله موسي ',NULL,'عبدالله','موسي',NULL,NULL,'CO0183','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01121348667',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:39:04','2021-09-01 21:39:04'),(184,1,'customer',NULL,' طارق عادل ',NULL,'طارق','عادل',NULL,NULL,'CO0184','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01017493934',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 21:45:25','2021-09-01 21:45:25'),(185,1,'customer',NULL,' خالد اوزو ',NULL,'خالد','اوزو',NULL,NULL,'CO0185','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01020089332',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 22:02:08','2021-09-01 22:02:08'),(186,1,'customer',NULL,' مصطفي عيد ',NULL,'مصطفي','عيد',NULL,NULL,'CO0186','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01000212279',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 22:39:00','2021-09-01 22:39:00'),(187,1,'customer',NULL,' محمد عبدالستار ',NULL,'محمد','عبدالستار',NULL,NULL,'CO0187','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01120407041',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-01 23:03:19','2021-09-01 23:03:19'),(188,1,'customer',NULL,' دعاء عيد الغني  ',NULL,'دعاء عيد الغني',NULL,NULL,NULL,'CO0188','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01286006831',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 13:02:38','2021-09-02 13:02:38'),(189,1,'customer',NULL,' اسامة علام  ',NULL,'اسامة علام',NULL,NULL,NULL,'CO0189','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01008364585',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 13:21:23','2021-09-02 13:21:23'),(190,1,'customer',NULL,' محمد صابر  ',NULL,'محمد صابر',NULL,NULL,NULL,'CO0190','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01150578560',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 15:21:07','2021-09-02 15:21:07'),(191,1,'customer',NULL,' احمد نعيم ',NULL,'احمد','نعيم',NULL,NULL,'CO0191','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 16:01:13','2021-09-02 16:01:13'),(192,1,'customer',NULL,' محمد انور  ',NULL,'محمد انور',NULL,NULL,NULL,'CO0192','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01015873851',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 16:30:16','2021-09-02 16:30:16'),(193,1,'customer',NULL,' مصطفي احمد  ',NULL,'مصطفي احمد',NULL,NULL,NULL,'CO0193','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01121479594',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 16:47:41','2021-09-02 16:47:41'),(194,1,'customer',NULL,' محمد احمد عباس  ',NULL,'محمد احمد عباس',NULL,NULL,NULL,'CO0194','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01009600196',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 18:52:02','2021-09-02 18:52:02'),(195,1,'customer',NULL,' طه عبد العظيم  ',NULL,'طه عبد العظيم',NULL,NULL,NULL,'CO0195','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01001945682',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 18:57:06','2021-09-02 18:57:06'),(196,1,'customer',NULL,' وائل صبحي  ',NULL,'وائل صبحي',NULL,NULL,NULL,'CO0196','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01116179151',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 19:07:49','2021-09-02 19:07:49'),(197,1,'customer',NULL,' وائل صبحي  ',NULL,'وائل صبحي',NULL,NULL,NULL,'CO0197','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01116179151',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 19:08:37','2021-09-02 19:08:37'),(198,1,'customer',NULL,' حسام محمد  ',NULL,'حسام محمد',NULL,NULL,NULL,'CO0198','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01009812518',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 20:24:40','2021-09-02 20:24:40'),(199,1,'customer',NULL,' امير رشدي  ',NULL,'امير رشدي',NULL,NULL,NULL,'CO0199','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01221962606',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 20:37:28','2021-09-02 20:37:28'),(200,1,'customer',NULL,' زينب سيد  ',NULL,'زينب سيد',NULL,NULL,NULL,'CO0200','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01124330343',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 20:41:03','2021-09-02 20:41:03'),(201,1,'customer',NULL,' فيصل ابراهيم  ',NULL,'فيصل ابراهيم',NULL,NULL,NULL,'CO0201','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01223452645',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 20:46:20','2021-09-02 20:46:20'),(202,1,'customer',NULL,' حمدي البرغوتي  ',NULL,'حمدي البرغوتي',NULL,NULL,NULL,'CO0202','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 21:19:46','2021-09-02 21:19:46'),(203,1,'customer',NULL,' احمد سمير  ',NULL,'احمد سمير',NULL,NULL,NULL,'CO0203','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01116032774',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 21:53:32','2021-09-02 21:53:32'),(204,1,'customer',NULL,' حسناء امين ',NULL,'حسناء','امين',NULL,NULL,'CO0204','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01156486311',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 22:35:23','2021-09-02 22:35:23'),(205,1,'customer',NULL,' شريف محمد ',NULL,'شريف','محمد',NULL,NULL,'CO0205','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01289666531',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-02 23:12:14','2021-09-02 23:12:14'),(206,1,'customer',NULL,' احمد حمدي  ',NULL,'احمد حمدي',NULL,NULL,NULL,'CO0206','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01129599941',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 15:03:55','2021-09-03 15:03:55'),(207,1,'customer',NULL,' احمد حمدي  ',NULL,'احمد حمدي',NULL,NULL,NULL,'CO0207','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 15:10:06','2021-09-03 15:10:06'),(208,1,'customer',NULL,' باسل وليد  ',NULL,'باسل وليد',NULL,NULL,NULL,'CO0208','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01145607772',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 16:15:48','2021-09-03 16:15:48'),(209,1,'customer',NULL,' كريم اشامة  ',NULL,'كريم اشامة',NULL,NULL,NULL,'CO0209','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01099177996',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 19:57:18','2021-09-03 19:57:18'),(210,1,'customer',NULL,' عبد الرحمن فرج  ',NULL,'عبد الرحمن فرج',NULL,NULL,NULL,'CO0210','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01157567245',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 21:31:51','2021-09-03 21:31:51'),(211,1,'customer',NULL,' احمد رافت ',NULL,'احمد','رافت',NULL,NULL,'CO0211','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01270931068',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-03 23:33:41','2021-09-03 23:33:41'),(212,1,'customer',NULL,' جمال عبد الرحمن  ',NULL,'جمال عبد الرحمن',NULL,NULL,NULL,'CO0212','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01003396882',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 13:43:04','2021-09-04 13:43:04'),(213,1,'customer',NULL,' عبد الحميد الفشاوي  ',NULL,'عبد الحميد الفشاوي',NULL,NULL,NULL,'CO0213','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01069693439',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 14:00:56','2021-09-04 14:00:56'),(214,1,'customer',NULL,' اسامه علام ',NULL,'اسامه','علام',NULL,NULL,'CO0214','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01008364585',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 15:19:24','2021-09-04 15:19:24'),(215,1,'customer',NULL,' اكسبريس  ',NULL,'اكسبريس',NULL,NULL,NULL,'CO0215','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 16:55:09','2021-09-04 16:55:09'),(216,1,'customer',NULL,' نعمه عبدالمجيد ',NULL,'نعمه','عبدالمجيد',NULL,NULL,'CO0216','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01127015320',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 16:59:46','2021-09-04 16:59:46'),(217,1,'customer',NULL,' ساره احمد  ',NULL,'ساره احمد',NULL,NULL,NULL,'CO0217','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01022169533',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 17:38:47','2021-09-04 17:38:47'),(218,1,'customer',NULL,' كريم جمال  ',NULL,'كريم جمال',NULL,NULL,NULL,'CO0218','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01009496039',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 18:10:48','2021-09-04 18:10:48'),(219,1,'customer',NULL,' نور السباعي  ',NULL,'نور السباعي',NULL,NULL,NULL,'CO0219','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01023415842',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 19:12:43','2021-09-04 19:12:43'),(220,1,'customer',NULL,' وليد عبد الرسول  ',NULL,'وليد عبد الرسول',NULL,NULL,NULL,'CO0220','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01005451542',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 19:14:22','2021-09-04 19:14:22'),(221,1,'customer',NULL,' عبد الحكيم شوقي  ',NULL,'عبد الحكيم شوقي',NULL,NULL,NULL,'CO0221','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01143640744',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 19:19:24','2021-09-04 19:19:24'),(222,1,'customer',NULL,' محمد عماد  ',NULL,'محمد عماد',NULL,NULL,NULL,'CO0222','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01009302209',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 19:24:56','2021-09-04 19:24:56'),(223,1,'customer',NULL,' عبد الحكيم شوقي  ',NULL,'عبد الحكيم شوقي',NULL,NULL,NULL,'CO0223','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01143640744',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 19:33:24','2021-09-04 19:33:24'),(224,1,'customer',NULL,' نور السباعي  ',NULL,'نور السباعي',NULL,NULL,NULL,'CO0224','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01023415842',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 19:46:33','2021-09-04 19:46:33'),(225,1,'customer',NULL,' نور السباعي  ',NULL,'نور السباعي',NULL,NULL,NULL,'CO0225','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01023415842',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 19:46:33','2021-09-04 19:46:33'),(226,1,'customer',NULL,' محمد سيد  ',NULL,'محمد سيد',NULL,NULL,NULL,'CO0226','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01151571352',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 19:51:14','2021-09-04 19:51:14'),(227,1,'customer',NULL,' محمد مجدي ',NULL,'محمد','مجدي',NULL,NULL,'CO0227','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01200088528',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-04 20:54:34','2021-09-04 20:54:34'),(228,1,'customer',NULL,' البير عبد المسيح  ',NULL,'البير عبد المسيح',NULL,NULL,NULL,'CO0228','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01283512265',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 13:24:08','2021-09-05 13:24:08'),(229,1,'customer',NULL,' هبه شريف  ',NULL,'هبه شريف',NULL,NULL,NULL,'CO0229','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01154819151',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 13:40:07','2021-09-05 13:40:07'),(230,1,'customer',NULL,' مها محمد  ',NULL,'مها محمد',NULL,NULL,NULL,'CO0230','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01028307773',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 13:48:51','2021-09-05 13:48:51'),(231,1,'customer',NULL,' ايمان عبد الوهاب  ',NULL,'ايمان عبد الوهاب',NULL,NULL,NULL,'CO0231','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01119215012',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 13:58:28','2021-09-05 13:58:28'),(232,1,'customer',NULL,' احمد شحاته  ',NULL,'احمد شحاته',NULL,NULL,NULL,'CO0232','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01555600060',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 14:41:51','2021-09-05 14:41:51'),(233,1,'customer',NULL,' احمد شبانه  ',NULL,'احمد شبانه',NULL,NULL,NULL,'CO0233','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01102123459',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 14:58:45','2021-09-05 14:58:45'),(234,1,'customer',NULL,' عبدالرحمن اشرف ',NULL,'عبدالرحمن','اشرف',NULL,NULL,'CO0234','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01146067697',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 15:39:32','2021-09-05 15:39:32'),(235,1,'customer',NULL,' سيد بدري  ',NULL,'سيد بدري',NULL,NULL,NULL,'CO0235','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01116561999',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 15:41:43','2021-09-05 15:41:43'),(236,1,'customer',NULL,' ايمان محمد ',NULL,'ايمان','محمد',NULL,NULL,'CO0236','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01551865006',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 16:18:10','2021-09-05 16:18:10'),(237,1,'customer',NULL,' محمد اسماعيل ',NULL,'محمد','اسماعيل',NULL,NULL,'CO0237','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01129301175',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 16:48:14','2021-09-05 16:48:14'),(238,1,'customer',NULL,' احمد حمدي  ',NULL,'احمد حمدي',NULL,NULL,NULL,'CO0238','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01142863963',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 17:09:20','2021-09-05 17:09:20'),(239,1,'customer',NULL,' ايراهيم فتحي  ',NULL,'ايراهيم فتحي',NULL,NULL,NULL,'CO0239','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01120015644',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 18:35:59','2021-09-05 18:35:59'),(240,1,'customer',NULL,' ابراهيم فتحي  ',NULL,'ابراهيم فتحي',NULL,NULL,NULL,'CO0240','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01120015642',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 18:37:00','2021-09-05 18:37:00'),(241,1,'customer',NULL,' وائل لبيب  ',NULL,'وائل لبيب',NULL,NULL,NULL,'CO0241','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01221284514',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 19:07:19','2021-09-05 19:07:19'),(242,1,'customer',NULL,' خالد محمد ',NULL,'خالد','محمد',NULL,NULL,'CO0242','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01281629045',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 19:51:35','2021-09-05 19:51:35'),(243,1,'customer','عمرو عزت',' محمود محمد  ',NULL,'محمود محمد',NULL,NULL,NULL,'CO0243','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01119612735',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 20:50:30','2021-09-05 20:50:30'),(244,1,'customer',NULL,' محمد خطاب  ',NULL,'محمد خطاب',NULL,NULL,NULL,'CO0244','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01006040113',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 21:48:55','2021-09-05 21:48:55'),(245,1,'customer',NULL,' محمد مجدي  ',NULL,'محمد مجدي',NULL,NULL,NULL,'CO0245','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01200088528',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 21:51:38','2021-09-05 21:51:38'),(246,1,'customer',NULL,' احمد جلال  ',NULL,'احمد جلال',NULL,NULL,NULL,'CO0246','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01006993313',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-05 22:04:06','2021-09-05 22:04:06'),(247,1,'customer',NULL,' محمد عبد الرحمن  ',NULL,'محمد عبد الرحمن',NULL,NULL,NULL,'CO0247','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01126718506',NULL,'01144010153',NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 12:24:08','2021-09-06 12:24:08'),(248,1,'customer',NULL,' شريف جدة  ',NULL,'شريف جدة',NULL,NULL,NULL,'CO0248','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 14:00:22','2021-09-06 14:00:22'),(249,1,'customer',NULL,' عماد عزت  ',NULL,'عماد عزت',NULL,NULL,NULL,'CO0249','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01020224277',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 14:14:40','2021-09-06 14:14:40'),(250,1,'customer',NULL,' عبد الرحمن سيد  ',NULL,'عبد الرحمن سيد',NULL,NULL,NULL,'CO0250','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01285335976',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 14:19:40','2021-09-06 14:19:40'),(251,1,'customer',NULL,' احمد حراز  ',NULL,'احمد حراز',NULL,NULL,NULL,'CO0251','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 14:25:15','2021-09-06 14:25:15'),(252,1,'customer',NULL,' عبد الله محمد  ',NULL,'عبد الله محمد',NULL,NULL,NULL,'CO0252','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01009418416',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 14:28:34','2021-09-06 14:28:34'),(253,1,'customer',NULL,' مجمد جمال ',NULL,'مجمد','جمال',NULL,NULL,'CO0253','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 14:57:12','2021-09-06 14:57:12'),(254,1,'customer',NULL,' زينب مجدي  ',NULL,'زينب مجدي',NULL,NULL,NULL,'CO0254','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01000258644',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 15:01:33','2021-09-06 15:01:33'),(255,1,'customer',NULL,' زينب مجدي  ',NULL,'زينب مجدي',NULL,NULL,NULL,'CO0255','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01000258644',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 15:04:01','2021-09-06 15:04:01'),(256,1,'customer',NULL,' محمود محمد ',NULL,'محمود','محمد',NULL,NULL,'CO0256','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01091406040',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 15:05:30','2021-09-06 15:05:30'),(257,1,'customer',NULL,' محمد عبدالرازق ',NULL,'محمد','عبدالرازق',NULL,NULL,'CO0257','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 15:10:03','2021-09-06 15:10:03'),(258,1,'customer',NULL,' هشام انور ',NULL,'هشام','انور',NULL,NULL,'CO0258','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01022170556',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 15:13:29','2021-09-06 15:13:29'),(259,1,'customer',NULL,' محمد احمد ',NULL,'محمد','احمد',NULL,NULL,'CO0259','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01145605385',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 15:15:21','2021-09-06 15:15:21'),(260,1,'customer',NULL,' محمد كمال ',NULL,'محمد','كمال',NULL,NULL,'CO0260','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01146868858',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 15:18:01','2021-09-06 15:18:01'),(261,1,'customer',NULL,' 0  ',NULL,'0',NULL,NULL,NULL,'CO0261','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 15:18:06','2021-09-06 15:18:06'),(262,1,'customer',NULL,' عميل طياره  ',NULL,'عميل طياره',NULL,NULL,NULL,'CO0262','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 15:18:37','2021-09-06 15:18:37'),(263,1,'customer',NULL,' مرينال محمد  ',NULL,'مرينال محمد',NULL,NULL,NULL,'CO0263','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01125855578',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 16:14:08','2021-09-06 16:14:08'),(264,1,'customer',NULL,' تالا حسام ',NULL,'تالا','حسام',NULL,NULL,'CO0264','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01003970217',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 16:18:15','2021-09-06 16:18:15'),(265,1,'customer',NULL,' شريف ابو اليزيد  ',NULL,'شريف ابو اليزيد',NULL,NULL,NULL,'CO0265','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01000964020',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 16:27:17','2021-09-06 16:27:17'),(266,1,'customer',NULL,' هشام عبد السلام  ',NULL,'هشام عبد السلام',NULL,NULL,NULL,'CO0266','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01123732918',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 16:32:41','2021-09-06 16:32:41'),(267,1,'customer',NULL,' محمد اشرف ',NULL,'محمد','اشرف',NULL,NULL,'CO0267','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01000622961',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 16:33:22','2021-09-06 16:33:22'),(268,1,'customer',NULL,' محمد عيد ',NULL,'محمد','عيد',NULL,NULL,'CO0268','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01128812837',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 16:36:10','2021-09-06 16:36:10'),(269,1,'customer',NULL,' ام عماد  ',NULL,'ام عماد',NULL,NULL,NULL,'CO0269','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 16:38:46','2021-09-06 16:38:46'),(270,1,'customer',NULL,' مدحت محمد  ',NULL,'مدحت محمد',NULL,NULL,NULL,'CO0270','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01148272657',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 16:39:03','2021-09-06 16:39:03'),(271,1,'customer',NULL,' ايهاب احمد ',NULL,'ايهاب','احمد',NULL,NULL,'CO0271','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01010460222',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 16:43:28','2021-09-06 16:43:28'),(272,1,'customer',NULL,' تامر سعيد  ',NULL,'تامر سعيد',NULL,NULL,NULL,'CO0272','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01003393160',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 16:52:55','2021-09-06 16:52:55'),(273,1,'customer',NULL,' احمد سعيد ',NULL,'احمد','سعيد',NULL,NULL,'CO0273','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01061388984',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 17:37:00','2021-09-06 17:37:00'),(274,1,'customer',NULL,' رجب عز الدين ',NULL,'رجب','عز الدين',NULL,NULL,'CO0274','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01141181103',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 17:39:08','2021-09-06 17:39:08'),(275,1,'customer',NULL,' تبع احمد نعيم ',NULL,'تبع','احمد نعيم',NULL,NULL,'CO0275','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 17:40:36','2021-09-06 17:40:36'),(276,1,'customer',NULL,' طه محمد ',NULL,'طه','محمد',NULL,NULL,'CO0276','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01097766243',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 19:13:55','2021-09-06 19:13:55'),(277,1,'customer',NULL,' هاجر عصام  ',NULL,'هاجر عصام',NULL,NULL,NULL,'CO0277','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01091167611',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 20:20:14','2021-09-06 20:20:14'),(278,1,'customer',NULL,' عبد الله رفعت  ',NULL,'عبد الله رفعت',NULL,NULL,NULL,'CO0278','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01067716709',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 20:41:04','2021-09-06 20:41:04'),(279,1,'customer',NULL,' عمرو ابراهيم ',NULL,'عمرو','ابراهيم',NULL,NULL,'CO0279','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01151382900',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 21:11:43','2021-09-06 21:11:43'),(280,1,'customer',NULL,' عبدالرحمن فايز ',NULL,'عبدالرحمن','فايز',NULL,NULL,'CO0280','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01014450695',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 21:34:09','2021-09-06 21:34:09'),(281,1,'customer',NULL,' حسام السيد  ',NULL,'حسام السيد',NULL,NULL,NULL,'CO0281','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01120735930',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-06 22:06:22','2021-09-06 22:06:22'),(282,1,'customer',NULL,' عبد الرحمن اشرف  ',NULL,'عبد الرحمن اشرف',NULL,NULL,NULL,'CO0282','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01170170705',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 13:00:49','2021-09-07 13:00:49'),(283,1,'customer',NULL,' وليد عبد الرسول  ',NULL,'وليد عبد الرسول',NULL,NULL,NULL,'CO0283','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01005451542',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 14:18:00','2021-09-07 14:18:00'),(284,1,'customer',NULL,' ضياء  ',NULL,'ضياء',NULL,NULL,NULL,'CO0284','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 14:25:00','2021-09-07 14:25:00'),(285,1,'customer',NULL,' مهيب احمد ',NULL,'مهيب','احمد',NULL,NULL,'CO0285','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01121135882',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 14:34:20','2021-09-07 14:34:20'),(286,1,'customer',NULL,' عماد محمد ',NULL,'عماد','محمد',NULL,NULL,'CO0286','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 14:39:21','2021-09-07 14:39:21'),(287,1,'customer',NULL,' سعيد عمار  ',NULL,'سعيد عمار',NULL,NULL,NULL,'CO0287','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 15:04:34','2021-09-07 15:04:34'),(288,1,'customer',NULL,' عمر رياض  ',NULL,'عمر رياض',NULL,NULL,NULL,'CO0288','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01024940129',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 15:16:01','2021-09-07 15:16:01'),(289,1,'customer',NULL,' عبد الرحمن اشرف  ',NULL,'عبد الرحمن اشرف',NULL,NULL,NULL,'CO0289','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01090020018',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 15:21:21','2021-09-07 15:21:21'),(290,1,'customer',NULL,' ياسمين حمدي ',NULL,'ياسمين','حمدي',NULL,NULL,'CO0290','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01110986324',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 16:14:51','2021-09-07 16:14:51'),(291,1,'customer',NULL,' احمد صلاح  ',NULL,'احمد صلاح',NULL,NULL,NULL,'CO0291','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01147387648',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 16:22:19','2021-09-07 16:22:19'),(292,1,'customer',NULL,' عبد الرحمن مصطفي  ',NULL,'عبد الرحمن مصطفي',NULL,NULL,NULL,'CO0292','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01018281378',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 16:58:47','2021-09-07 16:58:47'),(293,1,'customer','عمرو عزت',' تامر امين  ',NULL,'تامر امين',NULL,NULL,NULL,'CO0293','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01004850159',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 18:02:20','2021-09-07 18:02:20'),(294,1,'customer',NULL,' تامر امين  ',NULL,'تامر امين',NULL,NULL,NULL,'CO0294','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01004850159',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 18:04:45','2021-09-07 18:04:45'),(295,1,'customer',NULL,' محمود احمد  ',NULL,'محمود احمد',NULL,NULL,NULL,'CO0295','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01151513124',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 18:17:28','2021-09-07 18:17:28'),(296,1,'customer',NULL,' سيد طه  ',NULL,'سيد طه',NULL,NULL,NULL,'CO0296','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01115803535',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 19:00:49','2021-09-07 19:00:49'),(297,1,'customer',NULL,' عاطف سعد  ',NULL,'عاطف سعد',NULL,NULL,NULL,'CO0297','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01061811000',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 19:11:26','2021-09-07 19:11:26'),(298,1,'customer',NULL,' شهد عبد الحميد  ',NULL,'شهد عبد الحميد',NULL,NULL,NULL,'CO0298','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01110340861',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 19:40:00','2021-09-07 19:40:00'),(299,1,'customer',NULL,' جلال الدين  ',NULL,'جلال الدين',NULL,NULL,NULL,'CO0299','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01152933644',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 19:44:02','2021-09-07 19:44:02'),(300,1,'customer',NULL,' محمود عمر  ',NULL,'محمود عمر',NULL,NULL,NULL,'CO0300','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01000802855',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 20:43:38','2021-09-07 20:43:38'),(301,1,'customer',NULL,' محمد برعي  ',NULL,'محمد برعي',NULL,NULL,NULL,'CO0301','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01224068401',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 20:51:53','2021-09-07 20:51:53'),(302,1,'customer',NULL,' نور السباعي  ',NULL,'نور السباعي',NULL,NULL,NULL,'CO0302','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01020050400',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 21:31:12','2021-09-07 21:31:12'),(303,1,'customer',NULL,' ايمن طايل ',NULL,'ايمن','طايل',NULL,NULL,'CO0303','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01000767145',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 23:24:15','2021-09-07 23:24:15'),(304,1,'customer',NULL,' مؤمن مصطفي ',NULL,'مؤمن','مصطفي',NULL,NULL,'CO0304','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01113393011',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-07 23:27:34','2021-09-07 23:27:34'),(305,1,'customer',NULL,' سيد احمد  ',NULL,'سيد احمد',NULL,NULL,NULL,'CO0305','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01091100940',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 13:06:45','2021-09-08 13:06:45'),(306,1,'customer',NULL,' مي الشربيني  ',NULL,'مي الشربيني',NULL,NULL,NULL,'CO0306','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01092155756',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 13:26:23','2021-09-08 13:26:23'),(307,1,'customer',NULL,' مي الشربيني  ',NULL,'مي الشربيني',NULL,NULL,NULL,'CO0307','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01092155756',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 13:28:42','2021-09-08 13:28:42'),(308,1,'customer',NULL,' محمد حسان  ',NULL,'محمد حسان',NULL,NULL,NULL,'CO0308','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01099756225',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 15:52:09','2021-09-08 15:52:09'),(309,1,'customer',NULL,' احمد حمدي ',NULL,'احمد','حمدي',NULL,NULL,'CO0309','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01142893963',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 16:11:57','2021-09-08 16:11:57'),(310,1,'customer',NULL,' هاني حسني ',NULL,'هاني','حسني',NULL,NULL,'CO0310','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01001221039',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 16:41:06','2021-09-08 16:41:06'),(311,1,'customer',NULL,' عبده محمد ',NULL,'عبده','محمد',NULL,NULL,'CO0311','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01116924563',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 16:43:42','2021-09-08 16:43:42'),(312,1,'customer',NULL,' احمد سعد ',NULL,'احمد','سعد',NULL,NULL,'CO0312','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01124414708',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 18:32:49','2021-09-08 18:32:49'),(313,1,'customer',NULL,' محمد ابو العنين  ',NULL,'محمد ابو العنين',NULL,NULL,NULL,'CO0313','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01112070627',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 19:38:22','2021-09-08 19:38:22'),(314,1,'customer',NULL,' مجدي مجدي  ',NULL,'مجدي مجدي',NULL,NULL,NULL,'CO0314','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01112373764',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 19:48:57','2021-09-08 19:48:57'),(315,1,'customer',NULL,' مجدي جميل  ',NULL,'مجدي جميل',NULL,NULL,NULL,'CO0315','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01112373764',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 19:50:32','2021-09-08 19:50:32'),(316,1,'customer',NULL,' احمد العشري  ',NULL,'احمد العشري',NULL,NULL,NULL,'CO0316','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01111248909',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 20:22:15','2021-09-08 20:22:15'),(317,1,'customer',NULL,' طارق الجيار  ',NULL,'طارق الجيار',NULL,NULL,NULL,'CO0317','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01222343207',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 20:28:34','2021-09-08 20:28:34'),(318,1,'customer',NULL,' محمد مصطفي  ',NULL,'محمد مصطفي',NULL,NULL,NULL,'CO0318','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01006691411',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 20:42:15','2021-09-08 20:42:15'),(319,1,'customer',NULL,' محمد خالد ',NULL,'محمد','خالد',NULL,NULL,'CO0319','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01158113612',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-08 21:53:30','2021-09-08 21:53:30'),(320,1,'customer',NULL,' احمد علي  ',NULL,'احمد علي',NULL,NULL,NULL,'CO0320','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01027450005',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 14:09:59','2021-09-09 14:09:59'),(321,1,'customer',NULL,' حسين ايمن  ',NULL,'حسين ايمن',NULL,NULL,NULL,'CO0321','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01159820485',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 14:46:32','2021-09-09 14:46:32'),(322,1,'customer',NULL,' مريم محمد  ',NULL,'مريم محمد',NULL,NULL,NULL,'CO0322','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01558266267',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 16:03:22','2021-09-09 16:03:22'),(323,1,'customer',NULL,' هدي محمد  ',NULL,'هدي محمد',NULL,NULL,NULL,'CO0323','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01555071129',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 16:08:00','2021-09-09 16:08:00'),(324,1,'customer',NULL,' محمد صلاح  ',NULL,'محمد صلاح',NULL,NULL,NULL,'CO0324','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01121721081',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 16:22:32','2021-09-09 16:22:32'),(325,1,'customer',NULL,' محمد امين  ',NULL,'محمد امين',NULL,NULL,NULL,'CO0325','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01157292420',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 16:26:50','2021-09-09 16:26:50'),(326,1,'customer',NULL,' احمد عامر  ',NULL,'احمد عامر',NULL,NULL,NULL,'CO0326','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01227584572',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 16:46:55','2021-09-09 16:46:55'),(327,1,'customer',NULL,' محمد ابو الوفا  ',NULL,'محمد ابو الوفا',NULL,NULL,NULL,'CO0327','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01113391139',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 18:41:01','2021-09-09 18:41:01'),(328,1,'customer',NULL,' مصطفي شمس ',NULL,'مصطفي','شمس',NULL,NULL,'CO0328','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01009444411',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 19:10:12','2021-09-09 19:10:12'),(329,1,'customer',NULL,' خالد يحي ',NULL,'خالد','يحي',NULL,NULL,'CO0329','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01126569171',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 20:37:39','2021-09-09 20:37:39'),(330,1,'customer',NULL,' محمد عبدالرحمن ',NULL,'محمد','عبدالرحمن',NULL,NULL,'CO0330','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01157880198',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 20:45:27','2021-09-09 20:45:27'),(331,1,'customer',NULL,' دعاء مجدي  ',NULL,'دعاء مجدي',NULL,NULL,NULL,'CO0331','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01026034612',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 21:05:36','2021-09-09 21:05:36'),(332,1,'customer',NULL,' امل احمد ',NULL,'امل','احمد',NULL,NULL,'CO0332','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01151933158',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 21:05:52','2021-09-09 21:05:52'),(333,1,'customer',NULL,' عمرو صلاح ',NULL,'عمرو','صلاح',NULL,NULL,'CO0333','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01025252025',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 22:01:35','2021-09-09 22:01:35'),(334,1,'customer',NULL,' عمرو سواح ',NULL,'عمرو','سواح',NULL,NULL,'CO0334','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01025252025',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-09 22:03:19','2021-09-13 02:02:22'),(335,1,'customer',NULL,' احمد زايد  ',NULL,'احمد زايد',NULL,NULL,NULL,'CO0335','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01220329992',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-10 14:16:42','2021-09-10 14:16:42'),(336,1,'customer',NULL,' علاء مبارك  ',NULL,'علاء مبارك',NULL,NULL,NULL,'CO0336','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01090015598',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-10 16:24:43','2021-09-10 16:24:43'),(337,1,'customer',NULL,' رامي يسري  ',NULL,'رامي يسري',NULL,NULL,NULL,'CO0337','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01129766882',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-10 16:48:13','2021-09-10 16:48:13'),(338,1,'customer',NULL,' هدي رمضان  ',NULL,'هدي رمضان',NULL,NULL,NULL,'CO0338','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01060515886',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-10 17:23:50','2021-09-10 17:23:50'),(339,1,'customer',NULL,' احمد شحاته  ',NULL,'احمد شحاته',NULL,NULL,NULL,'CO0339','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01200548896',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-10 17:27:15','2021-09-10 17:27:15'),(340,1,'customer',NULL,' ضحي خالد  ',NULL,'ضحي خالد',NULL,NULL,NULL,'CO0340','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01090536821',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-10 17:40:22','2021-09-10 17:40:22'),(341,1,'customer',NULL,' يحيي احمد  ',NULL,'يحيي احمد',NULL,NULL,NULL,'CO0341','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01125551499',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-10 19:11:53','2021-09-10 19:11:53'),(342,1,'customer',NULL,' مازن محمد  ',NULL,'مازن محمد',NULL,NULL,NULL,'CO0342','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01157026741',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-10 19:45:03','2021-09-10 19:45:03'),(343,1,'customer',NULL,' عمر محمد  ',NULL,'عمر محمد',NULL,NULL,NULL,'CO0343','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01122077377',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-10 20:36:05','2021-09-10 20:36:05'),(344,1,'customer',NULL,' عماد هشام  ',NULL,'عماد هشام',NULL,NULL,NULL,'CO0344','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01009898822',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-10 20:41:08','2021-09-10 20:41:08'),(345,1,'customer',NULL,' محمد توفيق  ',NULL,'محمد توفيق',NULL,NULL,NULL,'CO0345','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01002769008',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-11 12:36:48','2021-09-11 12:36:48'),(346,1,'customer',NULL,' احمد محسن  ',NULL,'احمد محسن',NULL,NULL,NULL,'CO0346','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01004500044',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-11 13:15:04','2021-09-11 13:15:04'),(347,1,'customer',NULL,' عبير عبد ربه  ',NULL,'عبير عبد ربه',NULL,NULL,NULL,'CO0347','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01003730698',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-11 13:43:27','2021-09-11 13:43:27'),(348,1,'customer',NULL,' مصطفي عصام ',NULL,'مصطفي','عصام',NULL,NULL,'CO0348','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01142047440',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-11 14:52:46','2021-09-11 14:52:46'),(349,1,'customer',NULL,' احمد خالد ',NULL,'احمد','خالد',NULL,NULL,'CO0349','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01027776224',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-11 15:16:37','2021-09-11 15:16:37'),(350,1,'customer',NULL,' غريب رجب ',NULL,'غريب','رجب',NULL,NULL,'CO0350','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01147117438',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-11 15:32:29','2021-09-11 15:32:29'),(351,1,'customer',NULL,' غريب رجب ',NULL,'غريب','رجب',NULL,NULL,'CO0351','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01147117438',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-11 15:34:54','2021-09-11 15:34:54'),(352,1,'customer',NULL,' محمد عصام  ',NULL,'محمد عصام',NULL,NULL,NULL,'CO0352','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01030828843',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-11 15:55:38','2021-09-11 15:55:38'),(353,1,'customer',NULL,' فرغلي احمد فرغلي  ',NULL,'فرغلي احمد فرغلي',NULL,NULL,NULL,'CO0353','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01000090306',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-11 15:56:44','2021-09-11 15:56:44'),(354,1,'customer',NULL,' سالي محمد  ',NULL,'سالي محمد',NULL,NULL,NULL,'CO0354','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01110792257',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-11 16:06:45','2021-09-11 16:06:45'),(355,1,'customer',NULL,' محمد ابراهيم  ',NULL,'محمد ابراهيم',NULL,NULL,NULL,'CO0355','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01090232727',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-11 16:24:48','2021-09-11 16:24:48'),(356,1,'customer',NULL,' امير منير  ',NULL,'امير منير',NULL,NULL,NULL,'CO0356','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01001685507',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-11 16:28:55','2021-09-11 16:28:55'),(357,1,'customer',NULL,' هاني حسني ',NULL,'هاني','حسني',NULL,NULL,'CO0357','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01001221039',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-11 17:00:23','2021-09-11 17:00:23'),(358,1,'customer',NULL,' سندس رمضان  ',NULL,'سندس رمضان',NULL,NULL,NULL,'CO0358','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01151750053.',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-11 17:28:17','2021-09-11 17:28:17'),(359,1,'customer',NULL,' محمد عمرو ',NULL,'محمد','عمرو',NULL,NULL,'CO0359','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01142775241',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-11 18:17:49','2021-09-11 18:17:49'),(360,1,'customer',NULL,' علاء محمد  ',NULL,'علاء محمد',NULL,NULL,NULL,'CO0360','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01099919114',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-11 18:23:03','2021-09-11 18:23:03'),(361,1,'customer',NULL,' احمد عيد ',NULL,'احمد','عيد',NULL,NULL,'CO0361','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01004961269',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-11 18:48:24','2021-09-11 18:48:24'),(362,1,'customer',NULL,' محمد عصمت  ',NULL,'محمد عصمت',NULL,NULL,NULL,'CO0362','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01093358132',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-11 18:51:31','2021-09-11 18:51:31'),(363,1,'customer',NULL,' الحلول النهائيه  ',NULL,'الحلول النهائيه',NULL,NULL,NULL,'CO0363','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01024040075',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-11 19:02:55','2021-09-11 19:02:55'),(364,1,'customer',NULL,' محمد عبد الله  ',NULL,'محمد عبد الله',NULL,NULL,NULL,'CO0364','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01117784510',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-11 19:28:15','2021-09-11 19:28:15'),(365,1,'customer',NULL,' عمرو فريد  ',NULL,'عمرو فريد',NULL,NULL,NULL,'CO0365','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01022911249',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-11 19:49:31','2021-09-11 19:49:31'),(366,1,'customer',NULL,' ابو نور  ',NULL,'ابو نور',NULL,NULL,NULL,'CO0366','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-11 20:22:35','2021-09-11 20:22:35'),(367,1,'customer',NULL,' سيد مايو  ',NULL,'سيد مايو',NULL,NULL,NULL,'CO0367','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01145888233',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-11 21:34:41','2021-09-11 21:34:41'),(368,1,'customer',NULL,' عبدالرحمن علاء  ',NULL,'عبدالرحمن علاء',NULL,NULL,NULL,'CO0368','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01125880245',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-11 21:55:49','2021-09-11 21:55:49'),(369,1,'customer',NULL,' احمد حسن  ',NULL,'احمد حسن',NULL,NULL,NULL,'CO0369','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01099022280',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-11 23:18:57','2021-09-11 23:18:57'),(370,1,'customer',NULL,' عبد الله محمدي  ',NULL,'عبد الله محمدي',NULL,NULL,NULL,'CO0370','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01159590404',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-12 12:59:47','2021-09-12 12:59:47'),(371,1,'customer',NULL,' احمد عبد الوهاب  ',NULL,'احمد عبد الوهاب',NULL,NULL,NULL,'CO0371','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01027754848',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-12 13:07:31','2021-09-12 13:07:31'),(372,1,'customer',NULL,' رحمه اشرف  ',NULL,'رحمه اشرف',NULL,NULL,NULL,'CO0372','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01154574285',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-12 13:51:01','2021-09-12 13:51:01'),(373,1,'customer',NULL,' عمر محمود  ',NULL,'عمر محمود',NULL,NULL,NULL,'CO0373','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01158870645',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-12 15:05:57','2021-09-12 15:05:57'),(374,1,'customer',NULL,' محمود ابو المعاطي  ',NULL,'محمود ابو المعاطي',NULL,NULL,NULL,'CO0374','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01256599797',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-12 15:34:09','2021-09-12 15:34:09'),(375,1,'customer',NULL,' احمد محمد  ',NULL,'احمد محمد',NULL,NULL,NULL,'CO0375','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01030076440',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-12 16:01:28','2021-09-12 16:01:28'),(376,1,'customer',NULL,' محمد توفيق  ',NULL,'محمد توفيق',NULL,NULL,NULL,'CO0376','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01002769008',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-12 16:08:44','2021-09-12 16:08:44'),(377,1,'customer',NULL,' حازم حكيم  ',NULL,'حازم حكيم',NULL,NULL,NULL,'CO0377','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01100308722',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-12 16:15:12','2021-09-12 16:15:12'),(378,1,'customer',NULL,' احمد محمد  ',NULL,'احمد محمد',NULL,NULL,NULL,'CO0378','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01030076440',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-12 16:32:57','2021-09-12 16:32:57'),(379,1,'customer',NULL,' اسلام الحسيني  ',NULL,'اسلام الحسيني',NULL,NULL,NULL,'CO0379','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01145748833',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-12 16:59:33','2021-09-12 16:59:33'),(380,1,'customer',NULL,' اسلام احمد  ',NULL,'اسلام احمد',NULL,NULL,NULL,'CO0380','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01050004024',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-12 18:10:51','2021-09-12 18:10:51'),(381,1,'customer',NULL,' مصطفي سامي  ',NULL,'مصطفي سامي',NULL,NULL,NULL,'CO0381','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01063584603',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-12 18:26:13','2021-09-12 18:26:13'),(382,1,'customer',NULL,' محمد حمدي  ',NULL,'محمد حمدي',NULL,NULL,NULL,'CO0382','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01119682572',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-12 18:35:32','2021-09-12 18:35:32'),(383,1,'customer',NULL,' طارق سيف النصر  ',NULL,'طارق سيف النصر',NULL,NULL,NULL,'CO0383','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01066178368',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-12 18:39:58','2021-09-12 18:39:58'),(384,1,'customer',NULL,' هشام عويس  ',NULL,'هشام عويس',NULL,NULL,NULL,'CO0384','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01090334455',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-12 19:14:00','2021-09-12 19:14:00'),(385,1,'customer',NULL,' محمد غريب  ',NULL,'محمد غريب',NULL,NULL,NULL,'CO0385','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01125144359',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-12 19:23:17','2021-09-12 19:23:17'),(386,1,'customer',NULL,' عبد الله محمود  ',NULL,'عبد الله محمود',NULL,NULL,NULL,'CO0386','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01016069134',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-12 19:50:57','2021-09-12 19:50:57'),(387,1,'customer',NULL,' وائل محمد  ',NULL,'وائل محمد',NULL,NULL,NULL,'CO0387','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01555553638',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-12 20:09:12','2021-09-12 20:09:12'),(388,1,'customer',NULL,' احمد اسماعيل  ',NULL,'احمد اسماعيل',NULL,NULL,NULL,'CO0388','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01091621326',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-12 20:23:54','2021-09-12 20:23:54'),(389,1,'customer',NULL,' منه خالد  ',NULL,'منه خالد',NULL,NULL,NULL,'CO0389','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01145589744',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-12 20:48:46','2021-09-12 20:48:46'),(390,1,'customer',NULL,' راشد احمد  ',NULL,'راشد احمد',NULL,NULL,NULL,'CO0390','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01000848359',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-12 21:05:26','2021-09-12 21:05:26'),(391,1,'customer',NULL,' احمد عبد الوهاب  ',NULL,'احمد عبد الوهاب',NULL,NULL,NULL,'CO0391','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01027754848',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-12 21:24:59','2021-09-12 21:24:59'),(392,1,'customer',NULL,' محمد علي  ',NULL,'محمد علي',NULL,NULL,NULL,'CO0392','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01067624448',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-12 21:37:42','2021-09-12 21:37:42'),(393,1,'customer',NULL,' رحاب سيد  ',NULL,'رحاب سيد',NULL,NULL,NULL,'CO0393','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01016202947',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-12 21:45:33','2021-09-12 21:45:33'),(394,1,'customer',NULL,' رحاب سيد ',NULL,'رحاب','سيد',NULL,NULL,'CO0394','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01016202947',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-12 21:47:08','2021-09-12 21:47:08'),(395,1,'customer',NULL,' رحاب سيد  ',NULL,'رحاب سيد',NULL,NULL,NULL,'CO0395','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01016202947',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-12 21:49:26','2021-09-12 21:49:26'),(396,1,'customer',NULL,' رحاب سيد  ',NULL,'رحاب سيد',NULL,NULL,NULL,'CO0396','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01016202947',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-12 21:51:01','2021-09-12 21:51:01'),(397,1,'customer',NULL,' علي سليمان ',NULL,'علي','سليمان',NULL,NULL,'علي سليمان','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'000000','000000000',NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-12 21:53:18','2021-09-12 21:53:18'),(398,1,'customer',NULL,' محمود معاذ ',NULL,'محمود','معاذ',NULL,NULL,'CO0398','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01126149487',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-12 21:59:24','2021-09-12 21:59:24'),(399,1,'customer',NULL,' حسام عبدالرحيم ',NULL,'حسام','عبدالرحيم',NULL,NULL,'CO0399','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01096389428',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-12 22:06:03','2021-09-12 22:06:03'),(400,1,'customer',NULL,' عبد العزيز محمد  ',NULL,'عبد العزيز محمد',NULL,NULL,NULL,'CO0400','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01154242322',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-12 22:53:52','2021-09-12 22:53:52'),(401,1,'customer',NULL,' عمرو سواح ',NULL,'عمرو','سواح',NULL,NULL,'CO0401','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01025252025',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-13 01:30:09','2021-09-13 01:30:09'),(402,1,'customer',NULL,' test test ',NULL,'test','test',NULL,NULL,'CO0402','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'123456789',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-13 01:59:28','2021-09-13 01:59:28'),(403,1,'customer',NULL,' احمد علي  ',NULL,'احمد علي',NULL,NULL,NULL,'CO0403','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01283604479',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-13 12:18:19','2021-09-13 12:18:19'),(404,1,'customer',NULL,' محمد جمال  ',NULL,'محمد جمال',NULL,NULL,NULL,'CO0404','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01011131105',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-13 12:57:17','2021-09-13 12:57:17'),(405,1,'customer',NULL,' محمد نصر  ',NULL,'محمد نصر',NULL,NULL,NULL,'CO0405','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01120438789',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-13 14:22:12','2021-09-13 14:22:12'),(406,1,'customer',NULL,' عصام عبد الوادود  ',NULL,'عصام عبد الوادود',NULL,NULL,NULL,'CO0406','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01120217139',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-13 14:38:00','2021-09-13 14:38:00'),(407,1,'customer',NULL,' مصطفي عاطف  ',NULL,'مصطفي عاطف',NULL,NULL,NULL,'CO0407','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01224767440',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-13 18:08:38','2021-09-13 18:08:38'),(408,1,'customer',NULL,' محمد حمدي ابراهيم  ',NULL,'محمد حمدي ابراهيم',NULL,NULL,NULL,'CO0408','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01013790210',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-13 18:18:53','2021-09-13 18:18:53'),(409,1,'customer',NULL,' محمد خالد  ',NULL,'محمد خالد',NULL,NULL,NULL,'CO0409','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01060629993',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-13 18:23:15','2021-09-13 18:23:15'),(410,1,'customer',NULL,' محمد خالد  ',NULL,'محمد خالد',NULL,NULL,NULL,'CO0410','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01060629993',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-13 18:25:06','2021-09-13 18:25:06'),(411,1,'customer',NULL,' مصطفي قدري  ',NULL,'مصطفي قدري',NULL,NULL,NULL,'CO0411','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01151629251',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-13 19:42:57','2021-09-13 19:42:57'),(412,1,'customer',NULL,' مصطفي احمد رشدي  ',NULL,'مصطفي احمد رشدي',NULL,NULL,NULL,'CO0412','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01127469696',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-13 20:25:15','2021-09-13 20:25:15'),(413,1,'customer',NULL,' مصطفي قدري  ',NULL,'مصطفي قدري',NULL,NULL,NULL,'CO0413','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01151629251',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-13 20:27:26','2021-09-13 20:27:26'),(414,1,'customer',NULL,' احمد عاطف  ',NULL,'احمد عاطف',NULL,NULL,NULL,'CO0414','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01005001592',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-13 20:31:16','2021-09-13 20:31:16'),(415,1,'customer',NULL,' محمد ممدوح  ',NULL,'محمد ممدوح',NULL,NULL,NULL,'CO0415','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01149699913',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-13 20:42:43','2021-09-13 20:42:43'),(416,1,'customer',NULL,' احمد جمعه  ',NULL,'احمد جمعه',NULL,NULL,NULL,'CO0416','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01097033133',NULL,'01008974016',NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-14 12:57:34','2021-09-14 12:57:34'),(417,1,'customer',NULL,' محمد توفيق ',NULL,'محمد','توفيق',NULL,NULL,'CO0417','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01002769008',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-14 16:12:47','2021-09-14 16:12:47'),(418,1,'customer',NULL,' عبدالرحمن العشري ',NULL,'عبدالرحمن','العشري',NULL,NULL,'CO0418','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01019191114',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-14 16:17:04','2021-09-14 16:17:04'),(419,1,'customer',NULL,' مريم هشام  ',NULL,'مريم هشام',NULL,NULL,NULL,'CO0419','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01146522204',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-14 16:24:40','2021-09-14 16:24:40'),(420,1,'customer',NULL,' بسنت سيد  ',NULL,'بسنت سيد',NULL,NULL,NULL,'CO0420','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01007407118',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-14 17:19:42','2021-09-14 17:19:42'),(421,1,'customer',NULL,' حسني عبد العليم  ',NULL,'حسني عبد العليم',NULL,NULL,NULL,'CO0421','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01026630078',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-14 17:27:21','2021-09-14 17:27:21'),(422,1,'customer',NULL,' محمد حجازي ',NULL,'محمد','حجازي',NULL,NULL,'CO0422','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01142980101',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-14 17:47:57','2021-09-14 17:47:57'),(423,1,'customer',NULL,' يوسف عمر  ',NULL,'يوسف عمر',NULL,NULL,NULL,'CO0423','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01112337348',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-14 19:16:56','2021-09-14 19:16:56'),(424,1,'customer',NULL,' يوسف عمر  ',NULL,'يوسف عمر',NULL,NULL,NULL,'CO0424','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01112337348',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-14 19:21:57','2021-09-14 19:21:57'),(425,1,'customer',NULL,' عزه غلي  ',NULL,'عزه غلي',NULL,NULL,NULL,'CO0425','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01033923276',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-14 19:32:43','2021-09-14 19:32:43'),(426,1,'customer',NULL,' طاهر بدره  ',NULL,'طاهر بدره',NULL,NULL,NULL,'CO0426','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01140911940',NULL,NULL,NULL,NULL,NULL,19,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-14 19:33:19','2021-09-14 19:33:19'),(427,1,'customer',NULL,' اشرف عبد الحميد  ',NULL,'اشرف عبد الحميد',NULL,NULL,NULL,'CO0427','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01113855007',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-14 19:56:05','2021-09-14 19:56:05'),(428,1,'customer',NULL,' اسلام خالد  ',NULL,'اسلام خالد',NULL,NULL,NULL,'CO0428','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01005040900',NULL,'01063707333',NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-14 20:28:59','2021-09-14 20:28:59'),(429,1,'customer',NULL,' محمود محمود  ',NULL,'محمود محمود',NULL,NULL,NULL,'CO0429','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01069347009',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-14 20:32:37','2021-09-14 20:32:37'),(430,1,'customer',NULL,' سيف الدين  ',NULL,'سيف الدين',NULL,NULL,NULL,'CO0430','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01156713991',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-14 20:57:37','2021-09-14 20:57:37'),(431,1,'customer',NULL,' حسام عماره  ',NULL,'حسام عماره',NULL,NULL,NULL,'CO0431','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01006917423',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-14 21:01:05','2021-09-14 21:01:05'),(432,1,'customer',NULL,' عبد الحكيم الجوهري  ',NULL,'عبد الحكيم الجوهري',NULL,NULL,NULL,'CO0432','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01550511958',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-14 21:39:57','2021-09-14 21:39:57'),(433,1,'customer',NULL,' سعيد احمد  ',NULL,'سعيد احمد',NULL,NULL,NULL,'CO0433','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-14 21:50:39','2021-09-14 21:50:39'),(434,1,'customer',NULL,' عبد الرحمن الجمل  ',NULL,'عبد الرحمن الجمل',NULL,NULL,NULL,'CO0434','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01001499100',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-14 22:03:31','2021-09-14 22:03:31'),(435,1,'customer',NULL,' مصطفي سمير  ',NULL,'مصطفي سمير',NULL,NULL,NULL,'CO0435','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01153564148',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-14 22:07:01','2021-09-14 22:07:01'),(436,1,'customer',NULL,' ام ياسمين  ',NULL,'ام ياسمين',NULL,NULL,NULL,'CO0436','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01152265032',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-14 22:26:43','2021-09-14 22:26:43'),(437,1,'customer',NULL,' عبد الرحمن عصام  ',NULL,'عبد الرحمن عصام',NULL,NULL,NULL,'CO0437','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0111129845',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-14 22:35:29','2021-09-14 22:35:29'),(438,1,'customer',NULL,' محمد ابو الفضل  ',NULL,'محمد ابو الفضل',NULL,NULL,NULL,'CO0438','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01005402964',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-15 14:20:12','2021-09-15 14:20:12'),(439,1,'customer',NULL,' محمد احمد حسن  ',NULL,'محمد احمد حسن',NULL,NULL,NULL,'CO0439','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01114834140',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-15 15:23:32','2021-09-15 15:23:32'),(440,1,'customer',NULL,' محمود عثمان  ',NULL,'محمود عثمان',NULL,NULL,NULL,'CO0440','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01147208811',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-15 17:05:58','2021-09-15 17:05:58'),(441,1,'customer',NULL,' صفيه عاطف  ',NULL,'صفيه عاطف',NULL,NULL,NULL,'CO0441','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01127636578',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-15 17:23:59','2021-09-15 17:23:59'),(442,1,'customer',NULL,' اسامه سيد  ',NULL,'اسامه سيد',NULL,NULL,NULL,'CO0442','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01111049779',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-15 17:36:53','2021-09-15 17:36:53'),(443,1,'customer',NULL,' محمد امام  ',NULL,'محمد امام',NULL,NULL,NULL,'CO0443','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01033144973',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-15 19:32:02','2021-09-15 19:32:02'),(444,1,'customer',NULL,' محمد سامح  ',NULL,'محمد سامح',NULL,NULL,NULL,'CO0444','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01093915274',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-15 19:50:40','2021-09-15 19:50:40'),(445,1,'customer',NULL,' اشرف عبد الحميد  ',NULL,'اشرف عبد الحميد',NULL,NULL,NULL,'CO0445','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01113855007',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-15 20:04:54','2021-09-15 20:04:54'),(446,1,'customer',NULL,' محمد عزت  ',NULL,'محمد عزت',NULL,NULL,NULL,'CO0446','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01112816227',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-15 20:05:08','2021-09-15 20:05:08'),(447,1,'customer',NULL,' ايمن رمزي  ',NULL,'ايمن رمزي',NULL,NULL,NULL,'CO0447','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01159779099',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-15 20:12:14','2021-09-15 20:12:14'),(448,1,'customer',NULL,' عمرو رمضان  ',NULL,'عمرو رمضان',NULL,NULL,NULL,'CO0448','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01009900804',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-15 20:12:31','2021-09-15 20:12:31'),(449,1,'customer',NULL,' ايمن رمزي  ',NULL,'ايمن رمزي',NULL,NULL,NULL,'CO0449','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'011599179099',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-15 20:15:16','2021-09-15 20:15:16'),(450,1,'customer',NULL,' اماني علي  ',NULL,'اماني علي',NULL,NULL,NULL,'CO0450','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01006751064',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-15 21:08:28','2021-09-15 21:08:28'),(451,1,'customer',NULL,' هاجر طلعت  ',NULL,'هاجر طلعت',NULL,NULL,NULL,'CO0451','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01156380196',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-15 21:30:03','2021-09-15 21:30:03'),(452,1,'customer',NULL,' عمر خطاب ',NULL,'عمر','خطاب',NULL,NULL,'CO0452','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01006040113',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-15 21:58:28','2021-09-15 21:58:28'),(453,1,'customer',NULL,' احمد محمد ',NULL,'احمد','محمد',NULL,NULL,'CO0453','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01211785979',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-15 22:05:32','2021-09-15 22:05:32'),(454,1,'customer',NULL,' 0  ',NULL,'0',NULL,NULL,NULL,'CO0454','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-16 13:17:51','2021-09-16 13:17:51'),(455,1,'customer',NULL,' 0  ',NULL,'0',NULL,NULL,NULL,'CO0455','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-16 13:18:55','2021-09-16 13:18:55'),(456,1,'customer',NULL,' 0  ',NULL,'0',NULL,NULL,NULL,'CO0456','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-16 13:19:58','2021-09-16 13:19:58'),(457,1,'customer',NULL,' هشام زين  ',NULL,'هشام زين',NULL,NULL,NULL,'CO0457','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01010831663',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-16 16:59:16','2021-09-16 16:59:16'),(458,1,'customer',NULL,' حسين ايمن  ',NULL,'حسين ايمن',NULL,NULL,NULL,'CO0458','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01159820485',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-16 17:52:17','2021-09-16 17:52:17'),(459,1,'customer',NULL,' محمد طلعت  ',NULL,'محمد طلعت',NULL,NULL,NULL,'CO0459','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01093317064',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-16 19:39:09','2021-09-16 19:39:09'),(460,1,'customer',NULL,' اسلام هاني  ',NULL,'اسلام هاني',NULL,NULL,NULL,'CO0460','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01009551011',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-16 20:21:13','2021-09-16 20:21:13'),(461,1,'customer',NULL,' محمد طلعت  ',NULL,'محمد طلعت',NULL,NULL,NULL,'CO0461','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01144099099',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-16 21:41:18','2021-09-16 21:41:18'),(462,1,'customer',NULL,' اكسبرس  ',NULL,'اكسبرس',NULL,NULL,NULL,'CO0462','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-16 22:02:32','2021-09-16 22:02:32'),(463,1,'customer',NULL,' اكسبرس  ',NULL,'اكسبرس',NULL,NULL,NULL,'CO0463','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-16 22:06:08','2021-09-16 22:06:08'),(464,1,'customer',NULL,' شعبان محمد  ',NULL,'شعبان محمد',NULL,NULL,NULL,'CO0464','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01029344566',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-17 13:27:00','2021-09-17 13:27:00'),(465,1,'customer',NULL,' عبد الرحمن عادل  ',NULL,'عبد الرحمن عادل',NULL,NULL,NULL,'CO0465','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01156409349',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-17 16:02:25','2021-09-17 16:02:25'),(466,1,'customer',NULL,' احمد حاتم  ',NULL,'احمد حاتم',NULL,NULL,NULL,'CO0466','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01558138401',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-17 16:17:46','2021-09-17 16:17:46'),(467,1,'customer',NULL,' هدي رمضان  ',NULL,'هدي رمضان',NULL,NULL,NULL,'CO0467','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01060515886',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-17 17:48:17','2021-09-17 17:48:17'),(468,1,'customer',NULL,' هدي رمضان  ',NULL,'هدي رمضان',NULL,NULL,NULL,'CO0468','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01060515886',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-17 17:48:45','2021-09-17 17:48:45'),(469,1,'customer',NULL,' محمد شافعي  ',NULL,'محمد شافعي',NULL,NULL,NULL,'CO0469','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01065047758',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-17 18:05:21','2021-09-17 18:05:21'),(470,1,'customer',NULL,' محمد الشافعي  ',NULL,'محمد الشافعي',NULL,NULL,NULL,'CO0470','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01065047758',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-17 18:11:50','2021-09-17 18:11:50'),(471,1,'customer',NULL,' سيد مايو  ',NULL,'سيد مايو',NULL,NULL,NULL,'CO0471','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-17 19:11:28','2021-09-17 19:11:28'),(472,1,'customer',NULL,' محمد ذكري  ',NULL,'محمد ذكري',NULL,NULL,NULL,'CO0472','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01004201044',NULL,NULL,NULL,NULL,NULL,20,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-17 20:18:53','2021-09-17 20:18:53'),(473,1,'customer',NULL,' اسعد والي  ',NULL,'اسعد والي',NULL,NULL,NULL,'CO0473','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01010833860',NULL,NULL,NULL,NULL,NULL,20,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-17 22:34:58','2021-09-17 22:34:58'),(474,1,'customer',NULL,' مايكل  ',NULL,'مايكل',NULL,NULL,NULL,'CO0474','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01228906363',NULL,NULL,NULL,NULL,NULL,20,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-17 22:53:23','2021-09-17 22:53:23'),(475,1,'customer',NULL,' اشرف الرباح  ',NULL,'اشرف الرباح',NULL,NULL,NULL,'CO0475','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01004710782',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-18 13:36:40','2021-09-18 13:36:40'),(476,1,'customer',NULL,' اسلام وهيب  ',NULL,'اسلام وهيب',NULL,NULL,NULL,'CO0476','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01141350764',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-18 14:15:04','2021-09-18 14:15:04'),(477,1,'customer',NULL,' محمد عبدالعزيز  ',NULL,'محمد عبدالعزيز',NULL,NULL,NULL,'CO0477','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01102012074',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-18 14:17:18','2021-09-18 14:17:18'),(478,1,'customer',NULL,' محمد عبدالعزيز  ',NULL,'محمد عبدالعزيز',NULL,NULL,NULL,'CO0478','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01102012074',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-18 14:19:16','2021-09-18 14:19:16'),(479,1,'customer',NULL,' محمود ابو المعاطي  ',NULL,'محمود ابو المعاطي',NULL,NULL,NULL,'CO0479','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01156599797',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-18 14:22:27','2021-09-18 14:22:27'),(480,1,'customer',NULL,' محمود المعاطي  ',NULL,'محمود المعاطي',NULL,NULL,NULL,'CO0480','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01156599797',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-18 14:24:57','2021-09-18 14:24:57'),(481,1,'customer',NULL,' محمود يوسف  ',NULL,'محمود يوسف',NULL,NULL,NULL,'CO0481','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01120344766',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-18 14:27:59','2021-09-18 14:27:59'),(482,1,'customer',NULL,' شريف محمود  ',NULL,'شريف محمود',NULL,NULL,NULL,'CO0482','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01025550808',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-18 16:04:29','2021-09-18 16:04:29'),(483,1,'customer',NULL,' شريف محمود  ',NULL,'شريف محمود',NULL,NULL,NULL,'CO0483','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01025550808',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-18 16:12:59','2021-09-18 16:12:59'),(484,1,'customer',NULL,' شريف محمود  ',NULL,'شريف محمود',NULL,NULL,NULL,'CO0484','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01025550808',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-18 16:15:38','2021-09-18 16:15:38'),(485,1,'customer',NULL,' بدون  ',NULL,'بدون',NULL,NULL,NULL,'CO0485','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-18 16:30:32','2021-09-18 16:30:32'),(486,1,'customer',NULL,' طه محمد  ',NULL,'طه محمد',NULL,NULL,NULL,'CO0486','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01111060272',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-18 16:49:58','2021-09-18 16:49:58'),(487,1,'customer',NULL,' محمد سعد  ',NULL,'محمد سعد',NULL,NULL,NULL,'CO0487','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01005882652',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-18 19:03:24','2021-09-18 19:03:24'),(488,1,'customer',NULL,' جمعه محمد  ',NULL,'جمعه محمد',NULL,NULL,NULL,'CO0488','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01023831780',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-18 19:55:38','2021-09-18 19:55:38'),(489,1,'customer',NULL,' طارق حسن  ',NULL,'طارق حسن',NULL,NULL,NULL,'CO0489','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01000049478',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-18 20:00:32','2021-09-18 20:00:32'),(490,1,'customer',NULL,' عزه محمد  ',NULL,'عزه محمد',NULL,NULL,NULL,'CO0490','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01118682818',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-18 20:33:09','2021-09-18 20:33:09'),(491,1,'customer',NULL,' مهيب احمد  ',NULL,'مهيب احمد',NULL,NULL,NULL,'CO0491','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01121135882',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-18 21:07:44','2021-09-18 21:07:44'),(492,1,'customer',NULL,' كريم مجدي  ',NULL,'كريم مجدي',NULL,NULL,NULL,'CO0492','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0118999017',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-18 21:36:04','2021-09-18 21:36:04'),(493,1,'customer',NULL,' كريم مجدي  ',NULL,'كريم مجدي',NULL,NULL,NULL,'CO0493','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0118999017',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-18 21:37:00','2021-09-18 21:37:00'),(494,1,'customer',NULL,' عبد الرحمن احمد  ',NULL,'عبد الرحمن احمد',NULL,NULL,NULL,'CO0494','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01021236945',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-18 21:51:06','2021-09-18 21:51:06'),(495,1,'customer',NULL,' عادل حسن عبد ربه  ',NULL,'عادل حسن عبد ربه',NULL,NULL,NULL,'CO0495','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01555203210',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-18 21:55:25','2021-09-18 21:55:25'),(496,1,'customer',NULL,' محمد فاروق  ',NULL,'محمد فاروق',NULL,NULL,NULL,'CO0496','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01110028448',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-18 22:38:08','2021-09-18 22:38:08'),(497,1,'customer',NULL,' ابراهيم اسماعيل  ',NULL,'ابراهيم اسماعيل',NULL,NULL,NULL,'CO0497','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01002171216',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-18 22:42:36','2021-09-18 22:42:36'),(498,1,'customer',NULL,' ادهم محمد  ',NULL,'ادهم محمد',NULL,NULL,NULL,'CO0498','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01284504520',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-19 14:05:01','2021-09-19 14:05:01'),(499,1,'customer',NULL,' ادهم محمد  ',NULL,'ادهم محمد',NULL,NULL,NULL,'CO0499','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01284504520',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-19 14:11:43','2021-09-19 14:11:43'),(500,1,'customer',NULL,' ايه محمد  ',NULL,'ايه محمد',NULL,NULL,NULL,'CO0500','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01119165549',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-19 14:13:38','2021-09-19 14:13:38'),(501,1,'customer',NULL,' انس حسام  ',NULL,'انس حسام',NULL,NULL,NULL,'CO0501','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01008637556',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-19 16:10:29','2021-09-19 16:10:29'),(502,1,'customer',NULL,' هادي عبدالفتاح  ',NULL,'هادي عبدالفتاح',NULL,NULL,NULL,'CO0502','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01127768667',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-19 17:17:43','2021-09-19 17:17:43'),(503,1,'customer',NULL,' حسام حماد  ',NULL,'حسام حماد',NULL,NULL,NULL,'CO0503','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01096555393',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-19 17:46:32','2021-09-19 17:46:32'),(504,1,'customer',NULL,' احمد التهامي  ',NULL,'احمد التهامي',NULL,NULL,NULL,'CO0504','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01009714185',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-19 17:55:12','2021-09-19 17:55:12'),(505,1,'customer',NULL,' صالح محمد  ',NULL,'صالح محمد',NULL,NULL,NULL,'CO0505','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01102820144',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-19 18:26:03','2021-09-19 18:26:03'),(506,1,'customer',NULL,' محمد جندي  ',NULL,'محمد جندي',NULL,NULL,NULL,'CO0506','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01002902349',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-19 18:49:18','2021-09-19 18:49:18'),(507,1,'customer',NULL,' دعاء زكريا  ',NULL,'دعاء زكريا',NULL,NULL,NULL,'CO0507','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01026151517',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-19 19:40:42','2021-09-19 19:40:42'),(508,1,'customer',NULL,' هيثم زين  ',NULL,'هيثم زين',NULL,NULL,NULL,'CO0508','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01065716300',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-19 19:52:02','2021-09-19 19:52:02'),(509,1,'customer',NULL,' محمد عمرو  ',NULL,'محمد عمرو',NULL,NULL,NULL,'CO0509','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01010315163',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-19 19:59:01','2021-09-19 19:59:01'),(510,1,'customer',NULL,' محمد عمرو  ',NULL,'محمد عمرو',NULL,NULL,NULL,'CO0510','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01010315163',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-19 20:02:18','2021-09-19 20:02:18'),(511,1,'customer',NULL,' محمود صابر  ',NULL,'محمود صابر',NULL,NULL,NULL,'CO0511','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01101376765',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-19 20:10:00','2021-09-19 20:10:00'),(512,1,'customer',NULL,' عبد الله حنفي  ',NULL,'عبد الله حنفي',NULL,NULL,NULL,'CO0512','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01117746030',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-19 20:43:17','2021-09-19 20:43:17'),(513,1,'customer',NULL,' ياسر عبدالله  ',NULL,'ياسر عبدالله',NULL,NULL,NULL,'CO0513','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01030184323',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-19 21:42:09','2021-09-19 21:42:09'),(514,1,'customer',NULL,' محمد محكمه  ',NULL,'محمد محكمه',NULL,NULL,NULL,'CO0514','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01122212993',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-19 21:44:08','2021-09-19 21:44:08'),(515,1,'customer',NULL,' ميدو صفوت  ',NULL,'ميدو صفوت',NULL,NULL,NULL,'CO0515','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01098272726',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-19 21:45:37','2021-09-19 21:45:37'),(516,1,'customer',NULL,' ميدو صفوت  ',NULL,'ميدو صفوت',NULL,NULL,NULL,'CO0516','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01098272726',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-19 21:46:41','2021-09-19 21:46:41'),(517,1,'customer',NULL,' عمرو عبد القادر  ',NULL,'عمرو عبد القادر',NULL,NULL,NULL,'CO0517','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-19 22:02:30','2021-09-19 22:02:30'),(518,1,'customer',NULL,' نورهان محسن  ',NULL,'نورهان محسن',NULL,NULL,NULL,'CO0518','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01142051336',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-20 12:39:26','2021-09-20 12:39:26'),(519,1,'customer',NULL,' ايه اشرف  ',NULL,'ايه اشرف',NULL,NULL,NULL,'CO0519','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01010017572',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-20 12:40:54','2021-09-20 12:40:54'),(520,1,'customer',NULL,' محمد قاسم  ',NULL,'محمد قاسم',NULL,NULL,NULL,'CO0520','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01115161069',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-20 12:48:12','2021-09-20 12:48:12'),(521,1,'customer',NULL,' سيد طارق  ',NULL,'سيد طارق',NULL,NULL,NULL,'CO0521','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01159862321',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-20 12:57:15','2021-09-20 12:57:15'),(522,1,'customer',NULL,' سيد طارق  ',NULL,'سيد طارق',NULL,NULL,NULL,'CO0522','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01159862321',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-20 12:58:27','2021-09-20 12:58:27'),(523,1,'customer',NULL,' نبيل حسن  ',NULL,'نبيل حسن',NULL,NULL,NULL,'CO0523','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01092220390',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-20 13:00:25','2021-09-20 13:00:25'),(524,1,'customer',NULL,' مصطفي محمود  ',NULL,'مصطفي محمود',NULL,NULL,NULL,'CO0524','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01119096838',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-20 13:45:51','2021-09-20 13:45:51'),(525,1,'customer',NULL,' كمال الغطريفي  ',NULL,'كمال الغطريفي',NULL,NULL,NULL,'CO0525','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01006511311',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-20 14:15:01','2021-09-20 14:15:01'),(526,1,'customer',NULL,' محمد يسري  ',NULL,'محمد يسري',NULL,NULL,NULL,'CO0526','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01067744624',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-20 15:24:13','2021-09-20 15:24:13'),(527,1,'customer',NULL,' عزه احمد  ',NULL,'عزه احمد',NULL,NULL,NULL,'CO0527','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01155466687',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-20 15:50:21','2021-09-20 15:50:21'),(528,1,'customer',NULL,' خالد سيد  ',NULL,'خالد سيد',NULL,NULL,NULL,'CO0528','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01156054729',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-20 17:47:52','2021-09-20 17:47:52'),(529,1,'customer',NULL,' وليد خاطر  ',NULL,'وليد خاطر',NULL,NULL,NULL,'CO0529','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01022207822',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-20 19:37:44','2021-09-20 19:37:44'),(530,1,'customer',NULL,' وليد خاطر  ',NULL,'وليد خاطر',NULL,NULL,NULL,'CO0530','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01022207822',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-20 19:41:56','2021-09-20 19:41:56'),(531,1,'customer',NULL,' احمد ناصر  ',NULL,'احمد ناصر',NULL,NULL,NULL,'CO0531','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01006801522',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-20 19:49:26','2021-09-20 19:49:26'),(532,1,'customer',NULL,' محمد سلامه  ',NULL,'محمد سلامه',NULL,NULL,NULL,'CO0532','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01143183576',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-20 20:12:08','2021-09-20 20:12:08'),(533,1,'customer',NULL,' محمد سلامه  ',NULL,'محمد سلامه',NULL,NULL,NULL,'CO0533','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01143183576',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-20 20:14:40','2021-09-20 20:14:40'),(534,1,'customer',NULL,' محمد سلامه  ',NULL,'محمد سلامه',NULL,NULL,NULL,'CO0534','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01143183576',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-20 20:15:01','2021-09-20 20:15:01'),(535,1,'customer',NULL,' مصطفي حسني  ',NULL,'مصطفي حسني',NULL,NULL,NULL,'CO0535','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01115564396',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-20 20:35:12','2021-09-20 20:35:12'),(536,1,'customer',NULL,' محمد ابو زيد  ',NULL,'محمد ابو زيد',NULL,NULL,NULL,'CO0536','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-20 21:38:06','2021-09-20 21:38:06'),(537,1,'customer',NULL,' احمد ابراهيم  ',NULL,'احمد ابراهيم',NULL,NULL,NULL,'CO0537','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01021868842',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-20 23:01:32','2021-09-20 23:01:32'),(538,1,'customer',NULL,' مصطفي الجمل  ',NULL,'مصطفي الجمل',NULL,NULL,NULL,'CO0538','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01145055822',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-21 12:33:23','2021-09-21 12:33:23'),(539,1,'customer',NULL,' اميره شهير  ',NULL,'اميره شهير',NULL,NULL,NULL,'CO0539','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01114620505',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-21 13:22:30','2021-09-21 13:22:30'),(540,1,'customer',NULL,' ثابت اسماعيل  ',NULL,'ثابت اسماعيل',NULL,NULL,NULL,'CO0540','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01060162834',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-21 13:24:24','2021-09-21 13:24:24'),(541,1,'customer',NULL,' مني محمود  ',NULL,'مني محمود',NULL,NULL,NULL,'CO0541','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01014900392',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-21 16:40:34','2021-09-21 16:40:34'),(542,1,'customer',NULL,' عبدالرحمن احمد  ',NULL,'عبدالرحمن احمد',NULL,NULL,NULL,'CO0542','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01120002113',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-21 17:56:17','2021-09-21 17:56:17'),(543,1,'customer',NULL,' حسن محمد  ',NULL,'حسن محمد',NULL,NULL,NULL,'CO0543','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01099954546',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-21 18:46:02','2021-09-21 18:46:02'),(544,1,'customer',NULL,' يوسف هشام  ',NULL,'يوسف هشام',NULL,NULL,NULL,'CO0544','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01117079200',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-21 19:08:46','2021-09-21 19:08:46'),(545,1,'customer',NULL,' اسلام جمال  ',NULL,'اسلام جمال',NULL,NULL,NULL,'CO0545','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-21 19:18:14','2021-09-21 19:18:14'),(546,1,'customer',NULL,' منه عادل  ',NULL,'منه عادل',NULL,NULL,NULL,'CO0546','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01023201221',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-21 19:36:34','2021-09-21 19:36:34'),(547,1,'customer',NULL,' اسلام كامل  ',NULL,'اسلام كامل',NULL,NULL,NULL,'CO0547','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01156613551',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-21 19:59:17','2021-09-21 19:59:17'),(548,1,'customer',NULL,' اسامه محمد  ',NULL,'اسامه محمد',NULL,NULL,NULL,'CO0548','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01010720955',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-21 20:07:20','2021-09-21 20:07:20'),(549,1,'customer',NULL,' مينا وفيق  ',NULL,'مينا وفيق',NULL,NULL,NULL,'CO0549','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01228524822',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-21 20:18:47','2021-09-21 20:18:47'),(550,1,'customer',NULL,' سعد مجدي  ',NULL,'سعد مجدي',NULL,NULL,NULL,'CO0550','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01113846705',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-21 20:46:54','2021-09-21 20:46:54'),(551,1,'customer',NULL,' بهاء محمد  ',NULL,'بهاء محمد',NULL,NULL,NULL,'CO0551','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01005643046',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-21 20:54:15','2021-09-21 20:54:15'),(552,1,'customer',NULL,' يوسف احمد شعبان  ',NULL,'يوسف احمد شعبان',NULL,NULL,NULL,'CO0552','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01115000873',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-21 21:12:43','2021-09-21 21:12:43'),(553,1,'customer',NULL,' محمود سراج الدين  ',NULL,'محمود سراج الدين',NULL,NULL,NULL,'CO0553','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01062506734',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-21 22:14:52','2021-09-21 22:14:52'),(554,1,'customer',NULL,' عمرو ناصر  ',NULL,'عمرو ناصر',NULL,NULL,NULL,'CO0554','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01143966295',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-21 23:33:31','2021-09-21 23:33:31'),(555,1,'customer',NULL,' رافت زكي  ',NULL,'رافت زكي',NULL,NULL,NULL,'CO0555','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01211154580',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-22 13:57:15','2021-09-22 13:57:15'),(556,1,'customer',NULL,' رافت زكي  ',NULL,'رافت زكي',NULL,NULL,NULL,'CO0556','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01211154580',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-22 13:58:01','2021-09-22 13:58:01'),(557,1,'customer',NULL,' الاء محمود  ',NULL,'الاء محمود',NULL,NULL,NULL,'CO0557','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01119438465',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-22 14:11:42','2021-09-22 14:11:42'),(558,1,'customer',NULL,' ملك مصطفي  ',NULL,'ملك مصطفي',NULL,NULL,NULL,'CO0558','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01006096893',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-22 14:26:07','2021-09-22 14:26:07'),(559,1,'customer',NULL,' وفاء محمد  ',NULL,'وفاء محمد',NULL,NULL,NULL,'CO0559','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01124161497',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-22 15:31:31','2021-09-22 15:31:31'),(560,1,'customer',NULL,' محمد ممدوح  ',NULL,'محمد ممدوح',NULL,NULL,NULL,'CO0560','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01009726666',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-22 15:58:45','2021-09-22 15:58:45'),(561,1,'customer',NULL,' محمد رمضان  ',NULL,'محمد رمضان',NULL,NULL,NULL,'CO0561','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-22 17:22:30','2021-09-22 17:22:30'),(562,1,'customer',NULL,' فاطمه مصطفي عبد المنعم  ',NULL,'فاطمه مصطفي عبد المنعم',NULL,NULL,NULL,'CO0562','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01001170434',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-22 18:21:31','2021-09-22 18:21:31'),(563,1,'customer',NULL,' نهي احمد  ',NULL,'نهي احمد',NULL,NULL,NULL,'CO0563','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01126616372',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-22 20:08:53','2021-09-22 20:08:53'),(564,1,'customer',NULL,' محمد مكرم ',NULL,'محمد','مكرم',NULL,NULL,'CO0564','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01006449837',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-22 21:13:08','2021-09-22 21:13:08'),(565,1,'customer',NULL,' سعد مجدي  ',NULL,'سعد مجدي',NULL,NULL,NULL,'CO0565','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01113846705',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-22 21:53:42','2021-09-22 21:53:42'),(566,1,'customer',NULL,' احمد جمعه  ',NULL,'احمد جمعه',NULL,NULL,NULL,'CO0566','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01156596664',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-22 22:03:17','2021-09-22 22:03:17'),(567,1,'customer',NULL,' عاطف فتحي  ',NULL,'عاطف فتحي',NULL,NULL,NULL,'CO0567','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01151124922',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-23 12:48:25','2021-09-23 12:48:25'),(568,1,'customer',NULL,' عاطف فتحي  ',NULL,'عاطف فتحي',NULL,NULL,NULL,'CO0568','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01151124922',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-23 12:49:51','2021-09-23 12:49:51'),(569,1,'customer',NULL,' ام مجمد  ',NULL,'ام مجمد',NULL,NULL,NULL,'CO0569','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01111690866',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-23 13:05:23','2021-09-23 13:05:23'),(570,1,'customer',NULL,' ام محمد  ',NULL,'ام محمد',NULL,NULL,NULL,'CO0570','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01111690866',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-23 13:08:13','2021-09-23 13:08:13'),(571,1,'customer',NULL,' شهاب حمزه  ',NULL,'شهاب حمزه',NULL,NULL,NULL,'CO0571','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01111753459',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-23 13:19:00','2021-09-23 13:19:00'),(572,1,'customer',NULL,' امجد عادل  ',NULL,'امجد عادل',NULL,NULL,NULL,'CO0572','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01006680764',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-23 14:19:44','2021-09-23 14:19:44'),(573,1,'customer',NULL,' امجد عادل  ',NULL,'امجد عادل',NULL,NULL,NULL,'CO0573','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01006680764',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-23 14:21:53','2021-09-23 14:21:53'),(574,1,'customer',NULL,' هشام عويس  ',NULL,'هشام عويس',NULL,NULL,NULL,'CO0574','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01090334455',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-23 14:38:35','2021-09-23 14:38:35'),(575,1,'customer',NULL,' عبدالرحمن سامي  ',NULL,'عبدالرحمن سامي',NULL,NULL,NULL,'CO0575','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01151122167',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-23 14:51:52','2021-09-23 14:51:52'),(576,1,'customer',NULL,' عبدالرحمن سامي  ',NULL,'عبدالرحمن سامي',NULL,NULL,NULL,'CO0576','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01151122167',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-23 14:53:55','2021-09-23 14:53:55'),(577,1,'customer',NULL,' عبدالرحمن سامي  ',NULL,'عبدالرحمن سامي',NULL,NULL,NULL,'CO0577','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01151122167',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-23 14:55:03','2021-09-23 14:55:03'),(578,1,'customer',NULL,' محمد احمد  ',NULL,'محمد احمد',NULL,NULL,NULL,'CO0578','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01117659689',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-23 16:35:00','2021-09-23 16:35:00'),(579,1,'customer',NULL,' سيد رمضان  ',NULL,'سيد رمضان',NULL,NULL,NULL,'CO0579','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01005197770',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-23 17:12:29','2021-09-23 17:12:29'),(580,1,'customer',NULL,' يوسف عمر  ',NULL,'يوسف عمر',NULL,NULL,NULL,'CO0580','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01112337348',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-23 17:18:33','2021-09-23 17:18:33'),(581,1,'customer',NULL,' محمد عبد التواب  ',NULL,'محمد عبد التواب',NULL,NULL,NULL,'CO0581','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01111330404',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-23 17:24:46','2021-09-23 17:24:46'),(582,1,'customer',NULL,' خالد الفخراني  ',NULL,'خالد الفخراني',NULL,NULL,NULL,'CO0582','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01000550991',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-23 19:23:49','2021-09-23 19:23:49'),(583,1,'customer',NULL,' نشوه علاء  ',NULL,'نشوه علاء',NULL,NULL,NULL,'CO0583','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01144713396',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-23 19:32:51','2021-09-23 19:32:51'),(584,1,'customer',NULL,' نشوه علاء  ',NULL,'نشوه علاء',NULL,NULL,NULL,'CO0584','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01144713396',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-23 19:33:35','2021-09-23 19:33:35'),(585,1,'customer',NULL,' نشوه علاء  ',NULL,'نشوه علاء',NULL,NULL,NULL,'CO0585','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01144713396',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-23 19:33:59','2021-09-23 19:33:59'),(586,1,'customer',NULL,' حسين يحي  ',NULL,'حسين يحي',NULL,NULL,NULL,'CO0586','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01100684729',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-23 19:40:51','2021-09-23 19:40:51'),(587,1,'customer',NULL,' مصطفي عطيه  ',NULL,'مصطفي عطيه',NULL,NULL,NULL,'CO0587','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01100191459',NULL,NULL,NULL,NULL,NULL,20,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-24 16:32:58','2021-09-24 16:32:58'),(588,1,'customer',NULL,' احمد محمد  ',NULL,'احمد محمد',NULL,NULL,NULL,'CO0588','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01145310242',NULL,NULL,NULL,NULL,NULL,20,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-24 16:42:22','2021-09-24 16:42:22'),(589,1,'customer',NULL,' حسن علي  ',NULL,'حسن علي',NULL,NULL,NULL,'CO0589','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01111140678',NULL,NULL,NULL,NULL,NULL,20,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-24 17:12:02','2021-09-24 17:12:02'),(590,1,'customer',NULL,' محمد رفعت  ',NULL,'محمد رفعت',NULL,NULL,NULL,'CO0590','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01001183841',NULL,NULL,NULL,NULL,NULL,20,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-24 18:02:04','2021-09-24 18:02:04'),(591,1,'customer',NULL,' احمد عبد العظيم  ',NULL,'احمد عبد العظيم',NULL,NULL,NULL,'CO0591','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01123556996',NULL,NULL,NULL,NULL,NULL,20,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-24 18:15:46','2021-09-24 18:15:46'),(592,1,'customer',NULL,' مؤمن يحيي  ',NULL,'مؤمن يحيي',NULL,NULL,NULL,'CO0592','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01115755398',NULL,NULL,NULL,NULL,NULL,20,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-24 18:21:15','2021-09-24 18:21:15'),(593,1,'customer',NULL,' حازم احمد  ',NULL,'حازم احمد',NULL,NULL,NULL,'CO0593','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01150785601',NULL,NULL,NULL,NULL,NULL,20,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-24 18:27:18','2021-09-24 18:27:18'),(594,1,'customer',NULL,' شعراوي فاروق  ',NULL,'شعراوي فاروق',NULL,NULL,NULL,'CO0594','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01119581160',NULL,NULL,NULL,NULL,NULL,20,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-24 19:25:01','2021-09-24 19:25:01'),(595,1,'customer',NULL,' عيد فتحي  ',NULL,'عيد فتحي',NULL,NULL,NULL,'CO0595','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01157679192',NULL,NULL,NULL,NULL,NULL,20,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-24 19:27:54','2021-09-24 19:27:54'),(596,1,'customer',NULL,' ثروت ناشد  ',NULL,'ثروت ناشد',NULL,NULL,NULL,'CO0596','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01090192059',NULL,NULL,NULL,NULL,NULL,20,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-24 19:37:34','2021-09-24 19:37:34'),(597,1,'customer',NULL,' محمد محمود  ',NULL,'محمد محمود',NULL,NULL,NULL,'CO0597','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01154101453',NULL,NULL,NULL,NULL,NULL,20,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-24 19:42:37','2021-09-24 19:42:37'),(598,1,'customer',NULL,' محمد ثروت  ',NULL,'محمد ثروت',NULL,NULL,NULL,'CO0598','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01111060841',NULL,NULL,NULL,NULL,NULL,20,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-24 19:53:46','2021-09-24 19:53:46'),(599,1,'customer',NULL,' محمد ثروت  ',NULL,'محمد ثروت',NULL,NULL,NULL,'CO0599','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01111060841',NULL,NULL,NULL,NULL,NULL,20,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-24 19:56:54','2021-09-24 19:56:54'),(600,1,'customer',NULL,' امير طارق  ',NULL,'امير طارق',NULL,NULL,NULL,'CO0600','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1122608246',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-25 14:32:02','2021-09-25 14:32:02'),(601,1,'customer',NULL,' احمد انور  ',NULL,'احمد انور',NULL,NULL,NULL,'CO0601','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01123800575',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-25 16:43:43','2021-09-25 16:43:43'),(602,1,'customer',NULL,' محمد قاسم  ',NULL,'محمد قاسم',NULL,NULL,NULL,'CO0602','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01115161069',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-25 17:01:07','2021-09-25 17:01:07'),(603,1,'customer',NULL,' عاطف فتحي  ',NULL,'عاطف فتحي',NULL,NULL,NULL,'CO0603','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01151124922',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-25 17:47:13','2021-09-25 17:47:13'),(604,1,'customer',NULL,' احمد حماد  ',NULL,'احمد حماد',NULL,NULL,NULL,'CO0604','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01018082598',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-25 17:56:00','2021-09-25 17:56:00'),(605,1,'customer',NULL,' احمد مصطفي  ',NULL,'احمد مصطفي',NULL,NULL,NULL,'CO0605','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01027788909',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-25 18:14:37','2021-09-25 18:14:37'),(606,1,'customer',NULL,' مؤمن جمال  ',NULL,'مؤمن جمال',NULL,NULL,NULL,'CO0606','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01119775702',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-25 18:33:40','2021-09-25 18:33:40'),(607,1,'customer',NULL,' اشرف محمد  ',NULL,'اشرف محمد',NULL,NULL,NULL,'CO0607','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01201665808',NULL,'0',NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-25 19:08:15','2021-09-25 19:08:15'),(608,1,'customer',NULL,' مي نبيل  ',NULL,'مي نبيل',NULL,NULL,NULL,'CO0608','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01104393716',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-25 19:26:52','2021-09-25 19:26:52'),(609,1,'customer',NULL,' حسام محمود  ',NULL,'حسام محمود',NULL,NULL,NULL,'CO0609','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01117864949',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-25 20:41:26','2021-09-25 20:41:26'),(610,1,'customer',NULL,' يازن سيد  ',NULL,'يازن سيد',NULL,NULL,NULL,'CO0610','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01030095993',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-25 20:53:10','2021-09-25 20:53:10'),(611,1,'customer',NULL,' سماح احمد  ',NULL,'سماح احمد',NULL,NULL,NULL,'CO0611','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01022461812',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-26 12:52:02','2021-09-26 12:52:02'),(612,1,'customer',NULL,' اسلام كامل  ',NULL,'اسلام كامل',NULL,NULL,NULL,'CO0612','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01156613551',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-26 14:29:39','2021-09-26 14:29:39'),(613,1,'customer',NULL,' نشات فوزي  ',NULL,'نشات فوزي',NULL,NULL,NULL,'CO0613','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01222605335',NULL,'01144414045',NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-26 14:41:20','2021-09-26 14:41:20'),(614,1,'customer',NULL,' عمر احمد  ',NULL,'عمر احمد',NULL,NULL,NULL,'CO0614','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01140264141',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-26 17:05:21','2021-09-26 17:05:21'),(615,1,'customer',NULL,' محمود عبود  ',NULL,'محمود عبود',NULL,NULL,NULL,'CO0615','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01111884062',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-26 18:03:09','2021-09-26 18:03:09'),(616,1,'customer',NULL,' نجلاء زكريا  ',NULL,'نجلاء زكريا',NULL,NULL,NULL,'CO0616','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01151291321',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-26 18:54:39','2021-09-26 18:54:39'),(617,1,'customer',NULL,' احمد عادل جلال  ',NULL,'احمد عادل جلال',NULL,NULL,NULL,'CO0617','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01096502711',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-26 19:01:09','2021-09-26 19:01:09'),(618,1,'customer',NULL,' محمد اشرف  ',NULL,'محمد اشرف',NULL,NULL,NULL,'CO0618','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01027793325',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-26 19:30:57','2021-09-26 19:30:57'),(619,1,'customer',NULL,' محمد اشرف  ',NULL,'محمد اشرف',NULL,NULL,NULL,'CO0619','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01027793325',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-26 19:33:07','2021-09-26 19:33:07'),(620,1,'customer',NULL,' احمد عبد الفتاح  ',NULL,'احمد عبد الفتاح',NULL,NULL,NULL,'CO0620','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01019443495',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-26 19:43:41','2021-09-26 19:43:41'),(621,1,'customer',NULL,' يحي احمد  ',NULL,'يحي احمد',NULL,NULL,NULL,'CO0621','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01060688838',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-26 19:47:01','2021-09-26 19:47:01'),(622,1,'customer',NULL,' عبدالرحمن محمد  ',NULL,'عبدالرحمن محمد',NULL,NULL,NULL,'CO0622','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01153239166',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-26 20:26:49','2021-09-26 20:26:49'),(623,1,'customer',NULL,' خالد قاسم  ',NULL,'خالد قاسم',NULL,NULL,NULL,'CO0623','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01100902181',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-26 21:14:53','2021-09-26 21:14:53'),(624,1,'customer',NULL,' امير اسماعيل  ',NULL,'امير اسماعيل',NULL,NULL,NULL,'CO0624','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01144788878',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-27 12:44:11','2021-09-27 12:44:11'),(625,1,'customer',NULL,' سمر ابراهيم  ',NULL,'سمر ابراهيم',NULL,NULL,NULL,'CO0625','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01099630650',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-27 14:02:27','2021-09-27 14:02:27'),(626,1,'customer',NULL,' بهاء ابو زيد ',NULL,'بهاء','ابو زيد',NULL,NULL,'CO0626','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0107883097',NULL,NULL,NULL,NULL,NULL,19,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-27 15:15:28','2021-09-27 15:15:28'),(627,1,'customer',NULL,' محمود جمال  ',NULL,'محمود جمال',NULL,NULL,NULL,'CO0627','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01019849157',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-27 15:27:21','2021-09-27 15:27:21'),(628,1,'customer',NULL,' ملاك عبيد  ',NULL,'ملاك عبيد',NULL,NULL,NULL,'CO0628','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01227668525',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-27 15:41:17','2021-09-27 15:41:17'),(629,1,'customer',NULL,' يوسف طارق  ',NULL,'يوسف طارق',NULL,NULL,NULL,'CO0629','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01129920680',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-27 17:04:33','2021-09-27 17:04:33'),(630,1,'customer',NULL,' محمد معتز  ',NULL,'محمد معتز',NULL,NULL,NULL,'CO0630','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01121730345',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-27 17:15:46','2021-09-27 17:15:46'),(631,1,'customer',NULL,' محمد معتز  ',NULL,'محمد معتز',NULL,NULL,NULL,'CO0631','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01121730345',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-27 17:18:14','2021-09-27 17:18:14'),(632,1,'customer',NULL,' شهاب اشرف  ',NULL,'شهاب اشرف',NULL,NULL,NULL,'CO0632','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01152703010',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-27 17:36:11','2021-09-27 17:36:11'),(633,1,'customer',NULL,' بسام كمال  ',NULL,'بسام كمال',NULL,NULL,NULL,'CO0633','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01098558385',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-27 17:43:29','2021-09-27 17:43:29'),(634,1,'customer',NULL,' اسماعيل ابراهيم  ',NULL,'اسماعيل ابراهيم',NULL,NULL,NULL,'CO0634','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'011022161910',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-27 17:48:07','2021-09-27 17:48:07'),(635,1,'customer',NULL,' محمد منصور  ',NULL,'محمد منصور',NULL,NULL,NULL,'CO0635','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01150333520',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-27 18:28:16','2021-09-27 18:28:16'),(636,1,'customer',NULL,' محمد محمود  ',NULL,'محمد محمود',NULL,NULL,NULL,'CO0636','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01117192101',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-27 18:57:34','2021-09-27 18:57:34'),(637,1,'customer',NULL,' ناصر عبد الفتاح  ',NULL,'ناصر عبد الفتاح',NULL,NULL,NULL,'CO0637','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01118412332',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-27 20:04:48','2021-09-27 20:04:48'),(638,1,'customer',NULL,' امير اسامعيل  ',NULL,'امير اسامعيل',NULL,NULL,NULL,'CO0638','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01144788878',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-27 21:02:58','2021-09-27 21:02:58'),(639,1,'customer',NULL,' محمد امين  ',NULL,'محمد امين',NULL,NULL,NULL,'CO0639','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01210062228',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-27 21:05:48','2021-09-27 21:05:48'),(640,1,'customer',NULL,' محمد امين  ',NULL,'محمد امين',NULL,NULL,NULL,'CO0640','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01210062228',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-27 21:11:45','2021-09-27 21:11:45'),(641,1,'customer',NULL,' وليد محمود  ',NULL,'وليد محمود',NULL,NULL,NULL,'CO0641','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01000453785',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-27 21:21:34','2021-09-27 21:21:34'),(642,1,'customer',NULL,' محمود كمال  ',NULL,'محمود كمال',NULL,NULL,NULL,'CO0642','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01012883427',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-27 21:30:14','2021-09-27 21:30:14'),(643,1,'customer',NULL,' مي السيد  ',NULL,'مي السيد',NULL,NULL,NULL,'CO0643','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01117009399',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-28 13:35:28','2021-09-28 13:35:28'),(644,1,'customer',NULL,' مي السيد  ',NULL,'مي السيد',NULL,NULL,NULL,'CO0644','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01117009399',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-28 13:36:52','2021-09-28 13:36:52'),(645,1,'customer',NULL,' احمد حامد  ',NULL,'احمد حامد',NULL,NULL,NULL,'CO0645','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01155003031',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-28 14:14:06','2021-09-28 14:14:06'),(646,1,'customer',NULL,' حسام الدين احمد  ',NULL,'حسام الدين احمد',NULL,NULL,NULL,'CO0646','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01064867942',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-28 14:19:39','2021-09-28 14:19:39'),(647,1,'customer',NULL,' طارف الجيار  ',NULL,'طارف الجيار',NULL,NULL,NULL,'CO0647','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01222343207',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-28 14:35:16','2021-09-28 14:35:16'),(648,1,'customer',NULL,' حسام محمود ',NULL,'حسام','محمود',NULL,NULL,'CO0648','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01117976428',NULL,NULL,NULL,NULL,NULL,19,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-28 14:39:22','2021-09-28 14:39:22'),(649,1,'customer',NULL,' محمد قدري ',NULL,'محمد','قدري',NULL,NULL,'CO0649','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01061373455',NULL,NULL,NULL,NULL,NULL,19,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-28 18:37:59','2021-09-28 18:37:59'),(650,1,'customer',NULL,' محمد سمير  ',NULL,'محمد سمير',NULL,NULL,NULL,'CO0650','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01122221040',NULL,NULL,NULL,NULL,NULL,19,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-28 19:04:52','2021-09-28 19:04:52'),(651,1,'customer',NULL,' محمد سمير  ',NULL,'محمد سمير',NULL,NULL,NULL,'CO0651','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01102211001',NULL,NULL,NULL,NULL,NULL,19,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-28 19:05:18','2021-09-28 19:05:18'),(652,1,'customer',NULL,' مصطفي رمضان  ',NULL,'مصطفي رمضان',NULL,NULL,NULL,'CO0652','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01148406180',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-28 20:22:14','2021-09-28 20:22:14'),(653,1,'customer',NULL,' جمال علي  ',NULL,'جمال علي',NULL,NULL,NULL,'CO0653','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01097724686',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-28 20:47:33','2021-09-28 20:47:33'),(654,1,'customer',NULL,' محمد حسين  ',NULL,'محمد حسين',NULL,NULL,NULL,'CO0654','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01027775367',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-28 20:54:29','2021-09-28 20:54:29'),(655,1,'customer',NULL,' محمد سمير  ',NULL,'محمد سمير',NULL,NULL,NULL,'CO0655','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01092927555',NULL,NULL,NULL,NULL,NULL,19,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-28 21:40:35','2021-09-28 21:40:35'),(656,1,'customer',NULL,' رامي اسماعيل  ',NULL,'رامي اسماعيل',NULL,NULL,NULL,'CO0656','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01002171216',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-28 21:41:19','2021-09-28 21:41:19'),(657,1,'customer',NULL,' احمد عبد الحكيم  ',NULL,'احمد عبد الحكيم',NULL,NULL,NULL,'CO0657','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01002564543',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-28 22:10:09','2021-09-28 22:10:09'),(658,1,'customer',NULL,' نزيها سليمان  ',NULL,'نزيها سليمان',NULL,NULL,NULL,'CO0658','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01147179100',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-29 12:26:21','2021-09-29 12:26:21'),(659,1,'customer',NULL,' مريم محمد  ',NULL,'مريم محمد',NULL,NULL,NULL,'CO0659','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01153753435',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-29 13:06:01','2021-09-29 13:06:01'),(660,1,'customer',NULL,' بلال احمد  ',NULL,'بلال احمد',NULL,NULL,NULL,'CO0660','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01009647065',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-29 13:35:30','2021-09-29 13:35:30'),(661,1,'customer',NULL,' رضا محمد  ',NULL,'رضا محمد',NULL,NULL,NULL,'CO0661','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-29 13:41:45','2021-09-29 13:41:45'),(662,1,'customer',NULL,' رضا محمد  ',NULL,'رضا محمد',NULL,NULL,NULL,'CO0662','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-29 13:42:25','2021-09-29 13:42:25'),(663,1,'customer',NULL,' رضا محمد  ',NULL,'رضا محمد',NULL,NULL,NULL,'CO0663','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-29 13:44:09','2021-09-29 13:44:09'),(664,1,'customer',NULL,' اسلام محمد  ',NULL,'اسلام محمد',NULL,NULL,NULL,'CO0664','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01118261554',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-29 13:54:40','2021-09-29 13:54:40'),(665,1,'customer',NULL,' اسلام فوزي  ',NULL,'اسلام فوزي',NULL,NULL,NULL,'CO0665','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01003719396',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-29 14:46:52','2021-09-29 14:46:52'),(666,1,'customer',NULL,' طارق رشاد  ',NULL,'طارق رشاد',NULL,NULL,NULL,'CO0666','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01007998515',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-29 15:02:56','2021-09-29 15:02:56'),(667,1,'customer',NULL,' اسلام مجدي  ',NULL,'اسلام مجدي',NULL,NULL,NULL,'CO0667','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01067289623',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-29 15:31:19','2021-09-29 15:31:19'),(668,1,'customer',NULL,' نشات فوزي  ',NULL,'نشات فوزي',NULL,NULL,NULL,'CO0668','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-29 17:28:53','2021-09-29 17:28:53'),(669,1,'customer',NULL,' محمد ايمن  ',NULL,'محمد ايمن',NULL,NULL,NULL,'CO0669','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01100677476',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-29 17:45:54','2021-09-29 17:45:54'),(670,1,'customer',NULL,' رضا محمد  ',NULL,'رضا محمد',NULL,NULL,NULL,'CO0670','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01060503875',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-29 17:48:57','2021-09-29 17:48:57'),(671,1,'customer',NULL,' محسن احمد  ',NULL,'محسن احمد',NULL,NULL,NULL,'CO0671','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01000401689',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-29 18:09:52','2021-09-29 18:09:52'),(672,1,'customer',NULL,' احمد فراج  ',NULL,'احمد فراج',NULL,NULL,NULL,'CO0672','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01102901893',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-29 18:30:13','2021-09-29 18:30:13'),(673,1,'customer',NULL,' هاجر عصام  ',NULL,'هاجر عصام',NULL,NULL,NULL,'CO0673','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01091167611',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-29 18:40:34','2021-09-29 18:40:34'),(674,1,'customer',NULL,' ندي محمد  ',NULL,'ندي محمد',NULL,NULL,NULL,'CO0674','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01008417299',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-29 19:02:20','2021-09-29 19:02:20'),(675,1,'customer',NULL,' يوسف محمد  ',NULL,'يوسف محمد',NULL,NULL,NULL,'CO0675','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01069540051',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-29 19:33:23','2021-09-29 19:33:23'),(676,1,'customer',NULL,' احمد حسين  ',NULL,'احمد حسين',NULL,NULL,NULL,'CO0676','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01004464145',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-29 19:39:18','2021-09-29 19:39:18'),(677,1,'customer',NULL,' احمد جسين  ',NULL,'احمد جسين',NULL,NULL,NULL,'CO0677','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01004464145',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-29 19:41:46','2021-09-29 19:41:46'),(678,1,'customer',NULL,' احمد ممدوح  ',NULL,'احمد ممدوح',NULL,NULL,NULL,'CO0678','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01156577626',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-29 19:52:42','2021-09-29 19:52:42'),(679,1,'customer',NULL,' احمد علي  ',NULL,'احمد علي',NULL,NULL,NULL,'CO0679','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01212294550',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-29 20:18:44','2021-09-29 20:18:44'),(680,1,'customer',NULL,' نهي جمال  ',NULL,'نهي جمال',NULL,NULL,NULL,'CO0680','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01011190422',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-29 20:26:14','2021-09-29 20:26:14'),(681,1,'customer',NULL,' محمد محمود  ',NULL,'محمد محمود',NULL,NULL,NULL,'CO0681','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01154101453',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-29 20:31:16','2021-09-29 20:31:16'),(682,1,'customer',NULL,' محمود جمال  ',NULL,'محمود جمال',NULL,NULL,NULL,'CO0682','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01124611173',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-29 20:44:37','2021-09-29 20:44:37'),(683,1,'customer',NULL,' جدور جابر  ',NULL,'جدور جابر',NULL,NULL,NULL,'CO0683','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01120070175',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-29 21:04:03','2021-09-29 21:04:03'),(684,1,'customer',NULL,' جلال جوده  ',NULL,'جلال جوده',NULL,NULL,NULL,'CO0684','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01200033348',NULL,NULL,NULL,NULL,NULL,11,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-29 22:30:23','2021-09-29 22:30:23'),(685,1,'customer',NULL,' احمد ربيع  ',NULL,'احمد ربيع',NULL,NULL,NULL,'CO0685','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01156941447',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-30 13:06:47','2021-09-30 13:06:47'),(686,1,'customer',NULL,' مازن مجدي  ',NULL,'مازن مجدي',NULL,NULL,NULL,'CO0686','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01113066447',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-30 13:45:50','2021-09-30 13:45:50'),(687,1,'customer',NULL,' عبد الكريم عبد العزيز  ',NULL,'عبد الكريم عبد العزيز',NULL,NULL,NULL,'CO0687','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01116033248',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-30 14:03:33','2021-09-30 14:03:33'),(688,1,'customer',NULL,' سمير ابو العنين  ',NULL,'سمير ابو العنين',NULL,NULL,NULL,'CO0688','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01129963789',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-30 14:29:11','2021-09-30 14:29:11'),(689,1,'customer',NULL,' ربيع عباس  ',NULL,'ربيع عباس',NULL,NULL,NULL,'CO0689','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01061440304',NULL,NULL,NULL,NULL,NULL,19,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-30 14:35:08','2021-09-30 14:35:08'),(690,1,'customer',NULL,' محمود ماهر  ',NULL,'محمود ماهر',NULL,NULL,NULL,'CO0690','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01006184623',NULL,NULL,NULL,NULL,NULL,19,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-30 15:43:32','2021-09-30 15:43:32'),(691,1,'customer',NULL,' وليد محمود  ',NULL,'وليد محمود',NULL,NULL,NULL,'CO0691','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01143358950',NULL,NULL,NULL,NULL,NULL,19,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-30 15:48:56','2021-09-30 15:48:56'),(692,1,'customer',NULL,' محمد جمعه  ',NULL,'محمد جمعه',NULL,NULL,NULL,'CO0692','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01103913850',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-30 16:59:39','2021-09-30 16:59:39'),(693,1,'customer',NULL,' احمد عادل  ',NULL,'احمد عادل',NULL,NULL,NULL,'CO0693','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01002145335',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-09-30 17:34:44','2021-09-30 17:34:44');
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `currencies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `country` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `thousand_separator` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `decimal_separator` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=142 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `currencies` WRITE;
/*!40000 ALTER TABLE `currencies` DISABLE KEYS */;
INSERT INTO `currencies` VALUES (1,'Albania','Leke','ALL','Lek',',','.',NULL,NULL),(2,'America','Dollars','USD','$',',','.',NULL,NULL),(3,'Afghanistan','Afghanis','AF','؋',',','.',NULL,NULL),(4,'Argentina','Pesos','ARS','$',',','.',NULL,NULL),(5,'Aruba','Guilders','AWG','ƒ',',','.',NULL,NULL),(6,'Australia','Dollars','AUD','$',',','.',NULL,NULL),(7,'Azerbaijan','New Manats','AZ','ман',',','.',NULL,NULL),(8,'Bahamas','Dollars','BSD','$',',','.',NULL,NULL),(9,'Barbados','Dollars','BBD','$',',','.',NULL,NULL),(10,'Belarus','Rubles','BYR','p.',',','.',NULL,NULL),(11,'Belgium','Euro','EUR','€',',','.',NULL,NULL),(12,'Beliz','Dollars','BZD','BZ$',',','.',NULL,NULL),(13,'Bermuda','Dollars','BMD','$',',','.',NULL,NULL),(14,'Bolivia','Bolivianos','BOB','$b',',','.',NULL,NULL),(15,'Bosnia and Herzegovina','Convertible Marka','BAM','KM',',','.',NULL,NULL),(16,'Botswana','Pula\'s','BWP','P',',','.',NULL,NULL),(17,'Bulgaria','Leva','BG','лв',',','.',NULL,NULL),(18,'Brazil','Reais','BRL','R$',',','.',NULL,NULL),(19,'Britain [United Kingdom]','Pounds','GBP','£',',','.',NULL,NULL),(20,'Brunei Darussalam','Dollars','BND','$',',','.',NULL,NULL),(21,'Cambodia','Riels','KHR','៛',',','.',NULL,NULL),(22,'Canada','Dollars','CAD','$',',','.',NULL,NULL),(23,'Cayman Islands','Dollars','KYD','$',',','.',NULL,NULL),(24,'Chile','Pesos','CLP','$',',','.',NULL,NULL),(25,'China','Yuan Renminbi','CNY','¥',',','.',NULL,NULL),(26,'Colombia','Pesos','COP','$',',','.',NULL,NULL),(27,'Costa Rica','Colón','CRC','₡',',','.',NULL,NULL),(28,'Croatia','Kuna','HRK','kn',',','.',NULL,NULL),(29,'Cuba','Pesos','CUP','₱',',','.',NULL,NULL),(30,'Cyprus','Euro','EUR','€','.',',',NULL,NULL),(31,'Czech Republic','Koruny','CZK','Kč',',','.',NULL,NULL),(32,'Denmark','Kroner','DKK','kr',',','.',NULL,NULL),(33,'Dominican Republic','Pesos','DOP ','RD$',',','.',NULL,NULL),(34,'East Caribbean','Dollars','XCD','$',',','.',NULL,NULL),(35,'Egypt','Pounds','EGP','£',',','.',NULL,NULL),(36,'El Salvador','Colones','SVC','$',',','.',NULL,NULL),(37,'England [United Kingdom]','Pounds','GBP','£',',','.',NULL,NULL),(38,'Euro','Euro','EUR','€','.',',',NULL,NULL),(39,'Falkland Islands','Pounds','FKP','£',',','.',NULL,NULL),(40,'Fiji','Dollars','FJD','$',',','.',NULL,NULL),(41,'France','Euro','EUR','€','.',',',NULL,NULL),(42,'Ghana','Cedis','GHS','¢',',','.',NULL,NULL),(43,'Gibraltar','Pounds','GIP','£',',','.',NULL,NULL),(44,'Greece','Euro','EUR','€','.',',',NULL,NULL),(45,'Guatemala','Quetzales','GTQ','Q',',','.',NULL,NULL),(46,'Guernsey','Pounds','GGP','£',',','.',NULL,NULL),(47,'Guyana','Dollars','GYD','$',',','.',NULL,NULL),(48,'Holland [Netherlands]','Euro','EUR','€','.',',',NULL,NULL),(49,'Honduras','Lempiras','HNL','L',',','.',NULL,NULL),(50,'Hong Kong','Dollars','HKD','$',',','.',NULL,NULL),(51,'Hungary','Forint','HUF','Ft',',','.',NULL,NULL),(52,'Iceland','Kronur','ISK','kr',',','.',NULL,NULL),(53,'India','Rupees','INR','₹',',','.',NULL,NULL),(54,'Indonesia','Rupiahs','IDR','Rp',',','.',NULL,NULL),(55,'Iran','Rials','IRR','﷼',',','.',NULL,NULL),(56,'Ireland','Euro','EUR','€','.',',',NULL,NULL),(57,'Isle of Man','Pounds','IMP','£',',','.',NULL,NULL),(58,'Israel','New Shekels','ILS','₪',',','.',NULL,NULL),(59,'Italy','Euro','EUR','€','.',',',NULL,NULL),(60,'Jamaica','Dollars','JMD','J$',',','.',NULL,NULL),(61,'Japan','Yen','JPY','¥',',','.',NULL,NULL),(62,'Jersey','Pounds','JEP','£',',','.',NULL,NULL),(63,'Kazakhstan','Tenge','KZT','лв',',','.',NULL,NULL),(64,'Korea [North]','Won','KPW','₩',',','.',NULL,NULL),(65,'Korea [South]','Won','KRW','₩',',','.',NULL,NULL),(66,'Kyrgyzstan','Soms','KGS','лв',',','.',NULL,NULL),(67,'Laos','Kips','LAK','₭',',','.',NULL,NULL),(68,'Latvia','Lati','LVL','Ls',',','.',NULL,NULL),(69,'Lebanon','Pounds','LBP','£',',','.',NULL,NULL),(70,'Liberia','Dollars','LRD','$',',','.',NULL,NULL),(71,'Liechtenstein','Switzerland Francs','CHF','CHF',',','.',NULL,NULL),(72,'Lithuania','Litai','LTL','Lt',',','.',NULL,NULL),(73,'Luxembourg','Euro','EUR','€','.',',',NULL,NULL),(74,'Macedonia','Denars','MKD','ден',',','.',NULL,NULL),(75,'Malaysia','Ringgits','MYR','RM',',','.',NULL,NULL),(76,'Malta','Euro','EUR','€','.',',',NULL,NULL),(77,'Mauritius','Rupees','MUR','₨',',','.',NULL,NULL),(78,'Mexico','Pesos','MXN','$',',','.',NULL,NULL),(79,'Mongolia','Tugriks','MNT','₮',',','.',NULL,NULL),(80,'Mozambique','Meticais','MZ','MT',',','.',NULL,NULL),(81,'Namibia','Dollars','NAD','$',',','.',NULL,NULL),(82,'Nepal','Rupees','NPR','₨',',','.',NULL,NULL),(83,'Netherlands Antilles','Guilders','ANG','ƒ',',','.',NULL,NULL),(84,'Netherlands','Euro','EUR','€','.',',',NULL,NULL),(85,'New Zealand','Dollars','NZD','$',',','.',NULL,NULL),(86,'Nicaragua','Cordobas','NIO','C$',',','.',NULL,NULL),(87,'Nigeria','Nairas','NGN','₦',',','.',NULL,NULL),(88,'North Korea','Won','KPW','₩',',','.',NULL,NULL),(89,'Norway','Krone','NOK','kr',',','.',NULL,NULL),(90,'Oman','Rials','OMR','﷼',',','.',NULL,NULL),(91,'Pakistan','Rupees','PKR','₨',',','.',NULL,NULL),(92,'Panama','Balboa','PAB','B/.',',','.',NULL,NULL),(93,'Paraguay','Guarani','PYG','Gs',',','.',NULL,NULL),(94,'Peru','Nuevos Soles','PE','S/.',',','.',NULL,NULL),(95,'Philippines','Pesos','PHP','Php',',','.',NULL,NULL),(96,'Poland','Zlotych','PL','zł',',','.',NULL,NULL),(97,'Qatar','Rials','QAR','﷼',',','.',NULL,NULL),(98,'Romania','New Lei','RO','lei',',','.',NULL,NULL),(99,'Russia','Rubles','RUB','руб',',','.',NULL,NULL),(100,'Saint Helena','Pounds','SHP','£',',','.',NULL,NULL),(101,'Saudi Arabia','Riyals','SAR','﷼',',','.',NULL,NULL),(102,'Serbia','Dinars','RSD','Дин.',',','.',NULL,NULL),(103,'Seychelles','Rupees','SCR','₨',',','.',NULL,NULL),(104,'Singapore','Dollars','SGD','$',',','.',NULL,NULL),(105,'Slovenia','Euro','EUR','€','.',',',NULL,NULL),(106,'Solomon Islands','Dollars','SBD','$',',','.',NULL,NULL),(107,'Somalia','Shillings','SOS','S',',','.',NULL,NULL),(108,'South Africa','Rand','ZAR','R',',','.',NULL,NULL),(109,'South Korea','Won','KRW','₩',',','.',NULL,NULL),(110,'Spain','Euro','EUR','€','.',',',NULL,NULL),(111,'Sri Lanka','Rupees','LKR','₨',',','.',NULL,NULL),(112,'Sweden','Kronor','SEK','kr',',','.',NULL,NULL),(113,'Switzerland','Francs','CHF','CHF',',','.',NULL,NULL),(114,'Suriname','Dollars','SRD','$',',','.',NULL,NULL),(115,'Syria','Pounds','SYP','£',',','.',NULL,NULL),(116,'Taiwan','New Dollars','TWD','NT$',',','.',NULL,NULL),(117,'Thailand','Baht','THB','฿',',','.',NULL,NULL),(118,'Trinidad and Tobago','Dollars','TTD','TT$',',','.',NULL,NULL),(119,'Turkey','Lira','TRY','TL',',','.',NULL,NULL),(120,'Turkey','Liras','TRL','£',',','.',NULL,NULL),(121,'Tuvalu','Dollars','TVD','$',',','.',NULL,NULL),(122,'Ukraine','Hryvnia','UAH','₴',',','.',NULL,NULL),(123,'United Kingdom','Pounds','GBP','£',',','.',NULL,NULL),(124,'United States of America','Dollars','USD','$',',','.',NULL,NULL),(125,'Uruguay','Pesos','UYU','$U',',','.',NULL,NULL),(126,'Uzbekistan','Sums','UZS','лв',',','.',NULL,NULL),(127,'Vatican City','Euro','EUR','€','.',',',NULL,NULL),(128,'Venezuela','Bolivares Fuertes','VEF','Bs',',','.',NULL,NULL),(129,'Vietnam','Dong','VND','₫',',','.',NULL,NULL),(130,'Yemen','Rials','YER','﷼',',','.',NULL,NULL),(131,'Zimbabwe','Zimbabwe Dollars','ZWD','Z$',',','.',NULL,NULL),(132,'Iraq','Iraqi dinar','IQD','د.ع',',','.',NULL,NULL),(133,'Kenya','Kenyan shilling','KES','KSh',',','.',NULL,NULL),(134,'Bangladesh','Taka','BDT','৳',',','.',NULL,NULL),(135,'Algerie','Algerian dinar','DZD','د.ج',' ','.',NULL,NULL),(136,'United Arab Emirates','United Arab Emirates dirham','AED','د.إ',',','.',NULL,NULL),(137,'Uganda','Uganda shillings','UGX','USh',',','.',NULL,NULL),(138,'Tanzania','Tanzanian shilling','TZS','TSh',',','.',NULL,NULL),(139,'Angola','Kwanza','AOA','Kz',',','.',NULL,NULL),(140,'Kuwait','Kuwaiti dinar','KWD','KD',',','.',NULL,NULL),(141,'Bahrain','Bahraini dinar','BHD','BD',',','.',NULL,NULL);
/*!40000 ALTER TABLE `currencies` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `customer_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customer_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` double(5,2) NOT NULL,
  `price_calculation_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'percentage',
  `selling_price_group_id` int(11) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `customer_groups_business_id_foreign` (`business_id`) USING BTREE,
  KEY `customer_groups_created_by_index` (`created_by`) USING BTREE,
  KEY `customer_groups_price_calculation_type_index` (`price_calculation_type`) USING BTREE,
  KEY `customer_groups_selling_price_group_id_index` (`selling_price_group_id`) USING BTREE,
  CONSTRAINT `customer_groups_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `customer_groups` WRITE;
/*!40000 ALTER TABLE `customer_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `customer_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `dashboard_configurations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dashboard_configurations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `created_by` int(11) NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `configuration` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `dashboard_configurations_business_id_foreign` (`business_id`) USING BTREE,
  CONSTRAINT `dashboard_configurations_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `dashboard_configurations` WRITE;
/*!40000 ALTER TABLE `dashboard_configurations` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_configurations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discount_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `discount_variations` (
  `discount_id` int(11) NOT NULL,
  `variation_id` int(11) NOT NULL,
  KEY `discount_variations_discount_id_index` (`discount_id`) USING BTREE,
  KEY `discount_variations_variation_id_index` (`variation_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discount_variations` WRITE;
/*!40000 ALTER TABLE `discount_variations` DISABLE KEYS */;
/*!40000 ALTER TABLE `discount_variations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `discounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(11) NOT NULL,
  `brand_id` int(11) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `location_id` int(11) DEFAULT NULL,
  `priority` int(11) DEFAULT NULL,
  `discount_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_amount` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `starts_at` datetime DEFAULT NULL,
  `ends_at` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `applicable_in_spg` tinyint(1) DEFAULT '0',
  `applicable_in_cg` tinyint(1) DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `discounts_business_id_index` (`business_id`) USING BTREE,
  KEY `discounts_brand_id_index` (`brand_id`) USING BTREE,
  KEY `discounts_category_id_index` (`category_id`) USING BTREE,
  KEY `discounts_location_id_index` (`location_id`) USING BTREE,
  KEY `discounts_priority_index` (`priority`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discounts` WRITE;
/*!40000 ALTER TABLE `discounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `discounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `document_and_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `document_and_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `notable_id` int(11) NOT NULL,
  `notable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `heading` text COLLATE utf8mb4_unicode_ci,
  `description` text COLLATE utf8mb4_unicode_ci,
  `is_private` tinyint(1) NOT NULL DEFAULT '0',
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `document_and_notes_business_id_index` (`business_id`) USING BTREE,
  KEY `document_and_notes_notable_id_index` (`notable_id`) USING BTREE,
  KEY `document_and_notes_created_by_index` (`created_by`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `document_and_notes` WRITE;
/*!40000 ALTER TABLE `document_and_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `document_and_notes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `expense_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `expense_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `expense_categories_business_id_foreign` (`business_id`) USING BTREE,
  CONSTRAINT `expense_categories_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `expense_categories` WRITE;
/*!40000 ALTER TABLE `expense_categories` DISABLE KEYS */;
INSERT INTO `expense_categories` VALUES (1,'مصروفات تشغيل',1,'2',NULL,'2021-08-06 02:32:18','2021-09-01 18:36:16'),(2,'مراتبات',1,'4',NULL,'2021-09-01 18:35:30','2021-09-01 18:37:13'),(3,'ايجارات',1,'1',NULL,'2021-09-01 18:36:01','2021-09-01 18:37:35'),(4,'سلف موظفين',1,'3',NULL,'2021-09-01 18:36:48','2021-09-01 18:36:48'),(5,'شراء قطع غيار',1,'5',NULL,'2021-09-09 18:11:20','2021-09-09 18:11:29');
/*!40000 ALTER TABLE `expense_categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `group_sub_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_sub_taxes` (
  `group_tax_id` int(10) unsigned NOT NULL,
  `tax_id` int(10) unsigned NOT NULL,
  KEY `group_sub_taxes_group_tax_id_foreign` (`group_tax_id`) USING BTREE,
  KEY `group_sub_taxes_tax_id_foreign` (`tax_id`) USING BTREE,
  CONSTRAINT `group_sub_taxes_group_tax_id_foreign` FOREIGN KEY (`group_tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `group_sub_taxes_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `group_sub_taxes` WRITE;
/*!40000 ALTER TABLE `group_sub_taxes` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_sub_taxes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_layouts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoice_layouts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `header_text` text COLLATE utf8mb4_unicode_ci,
  `invoice_no_prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quotation_no_prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_heading` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line5` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_heading_not_paid` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_heading_paid` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quotation_heading` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_total_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `round_off_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_due_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paid_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_client_id` tinyint(1) NOT NULL DEFAULT '0',
  `client_id_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `client_tax_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_time_format` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_time` tinyint(1) NOT NULL DEFAULT '1',
  `show_brand` tinyint(1) NOT NULL DEFAULT '0',
  `show_sku` tinyint(1) NOT NULL DEFAULT '1',
  `show_cat_code` tinyint(1) NOT NULL DEFAULT '1',
  `show_expiry` tinyint(1) NOT NULL DEFAULT '0',
  `show_lot` tinyint(1) NOT NULL DEFAULT '0',
  `show_image` tinyint(1) NOT NULL DEFAULT '0',
  `show_sale_description` tinyint(1) NOT NULL DEFAULT '0',
  `sales_person_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_sales_person` tinyint(1) NOT NULL DEFAULT '0',
  `table_product_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_qty_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_unit_price_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_subtotal_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cat_code_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_logo` tinyint(1) NOT NULL DEFAULT '0',
  `show_business_name` tinyint(1) NOT NULL DEFAULT '0',
  `show_location_name` tinyint(1) NOT NULL DEFAULT '1',
  `show_landmark` tinyint(1) NOT NULL DEFAULT '1',
  `show_city` tinyint(1) NOT NULL DEFAULT '1',
  `show_state` tinyint(1) NOT NULL DEFAULT '1',
  `show_zip_code` tinyint(1) NOT NULL DEFAULT '1',
  `show_country` tinyint(1) NOT NULL DEFAULT '1',
  `show_mobile_number` tinyint(1) NOT NULL DEFAULT '1',
  `show_alternate_number` tinyint(1) NOT NULL DEFAULT '0',
  `show_email` tinyint(1) NOT NULL DEFAULT '0',
  `show_tax_1` tinyint(1) NOT NULL DEFAULT '1',
  `show_tax_2` tinyint(1) NOT NULL DEFAULT '0',
  `show_barcode` tinyint(1) NOT NULL DEFAULT '0',
  `show_payments` tinyint(1) NOT NULL DEFAULT '0',
  `show_customer` tinyint(1) NOT NULL DEFAULT '0',
  `customer_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_reward_point` tinyint(1) NOT NULL DEFAULT '0',
  `highlight_color` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `footer_text` text COLLATE utf8mb4_unicode_ci,
  `module_info` text COLLATE utf8mb4_unicode_ci,
  `common_settings` text COLLATE utf8mb4_unicode_ci,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `business_id` int(10) unsigned NOT NULL,
  `design` varchar(190) COLLATE utf8mb4_unicode_ci DEFAULT 'classic',
  `cn_heading` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'cn = credit note',
  `cn_no_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cn_amount_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_tax_headings` text COLLATE utf8mb4_unicode_ci,
  `show_previous_bal` tinyint(1) NOT NULL DEFAULT '0',
  `prev_bal_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `change_return_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_fields` text COLLATE utf8mb4_unicode_ci,
  `contact_custom_fields` text COLLATE utf8mb4_unicode_ci,
  `location_custom_fields` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `invoice_layouts_business_id_foreign` (`business_id`) USING BTREE,
  CONSTRAINT `invoice_layouts_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_layouts` WRITE;
/*!40000 ALTER TABLE `invoice_layouts` DISABLE KEYS */;
INSERT INTO `invoice_layouts` VALUES (1,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Subtotal','Discount','Tax','Total',NULL,'Total Due','Total Paid',0,NULL,NULL,'Date',NULL,1,0,0,0,0,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,'1628455640_mobiley_eshtagal_logo-Color.png',1,0,0,1,1,1,0,1,1,0,0,0,0,0,1,1,'Customer',0,'#000000',NULL,'{\"service_staff\":{\"service_staff_label\":null},\"repair\":{\"repair_status_label\":null,\"repair_warranty_label\":null,\"show_brand\":\"1\",\"brand_label\":null,\"device_label\":null,\"show_model\":\"1\",\"model_no_label\":null,\"show_serial_no\":\"1\",\"serial_no_label\":null,\"defects_label\":null,\"repair_checklist_label\":null}}','{\"due_date_label\":null,\"total_quantity_label\":null,\"num_to_word_format\":\"international\"}',1,1,'elegant',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'2021-08-06 01:22:09','2021-08-08 23:12:17');
/*!40000 ALTER TABLE `invoice_layouts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_schemes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoice_schemes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `scheme_type` enum('blank','year') COLLATE utf8mb4_unicode_ci NOT NULL,
  `prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `start_number` int(11) DEFAULT NULL,
  `invoice_count` int(11) NOT NULL DEFAULT '0',
  `total_digits` int(11) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `invoice_schemes_business_id_foreign` (`business_id`) USING BTREE,
  KEY `invoice_schemes_scheme_type_index` (`scheme_type`) USING BTREE,
  CONSTRAINT `invoice_schemes_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_schemes` WRITE;
/*!40000 ALTER TABLE `invoice_schemes` DISABLE KEYS */;
INSERT INTO `invoice_schemes` VALUES (1,1,'Default','blank',NULL,1,509,4,1,'2021-08-06 01:22:09','2021-09-30 17:08:24');
/*!40000 ALTER TABLE `invoice_schemes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `media`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `media` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `file_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `uploaded_by` int(11) DEFAULT NULL,
  `model_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_media_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `media_model_type_model_id_index` (`model_type`,`model_id`) USING BTREE,
  KEY `media_business_id_index` (`business_id`) USING BTREE,
  KEY `media_uploaded_by_index` (`uploaded_by`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `media` WRITE;
/*!40000 ALTER TABLE `media` DISABLE KEYS */;
INSERT INTO `media` VALUES (3,1,'1631804382_1589068605_IMG_1043.JPG',NULL,1,'App\\User',NULL,1,'2021-09-16 16:59:42','2021-09-16 16:59:42');
/*!40000 ALTER TABLE `media` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=270 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2014_10_12_000000_create_users_table',1),(2,'2014_10_12_100000_create_password_resets_table',1),(3,'2016_06_01_000001_create_oauth_auth_codes_table',1),(4,'2016_06_01_000002_create_oauth_access_tokens_table',1),(5,'2016_06_01_000003_create_oauth_refresh_tokens_table',1),(6,'2016_06_01_000004_create_oauth_clients_table',1),(7,'2016_06_01_000005_create_oauth_personal_access_clients_table',1),(8,'2017_07_05_071953_create_currencies_table',1),(9,'2017_07_05_073658_create_business_table',1),(10,'2017_07_22_075923_add_business_id_users_table',1),(11,'2017_07_23_113209_create_brands_table',1),(12,'2017_07_26_083429_create_permission_tables',1),(13,'2017_07_26_110000_create_tax_rates_table',1),(14,'2017_07_26_122313_create_units_table',1),(15,'2017_07_27_075706_create_contacts_table',1),(16,'2017_08_04_071038_create_categories_table',1),(17,'2017_08_08_115903_create_products_table',1),(18,'2017_08_09_061616_create_variation_templates_table',1),(19,'2017_08_09_061638_create_variation_value_templates_table',1),(20,'2017_08_10_061146_create_product_variations_table',1),(21,'2017_08_10_061216_create_variations_table',1),(22,'2017_08_19_054827_create_transactions_table',1),(23,'2017_08_31_073533_create_purchase_lines_table',1),(24,'2017_10_15_064638_create_transaction_payments_table',1),(25,'2017_10_31_065621_add_default_sales_tax_to_business_table',1),(26,'2017_11_20_051930_create_table_group_sub_taxes',1),(27,'2017_11_20_063603_create_transaction_sell_lines',1),(28,'2017_11_21_064540_create_barcodes_table',1),(29,'2017_11_23_181237_create_invoice_schemes_table',1),(30,'2017_12_25_122822_create_business_locations_table',1),(31,'2017_12_25_160253_add_location_id_to_transactions_table',1),(32,'2017_12_25_163227_create_variation_location_details_table',1),(33,'2018_01_04_115627_create_sessions_table',1),(34,'2018_01_05_112817_create_invoice_layouts_table',1),(35,'2018_01_06_112303_add_invoice_scheme_id_and_invoice_layout_id_to_business_locations',1),(36,'2018_01_08_104124_create_expense_categories_table',1),(37,'2018_01_08_123327_modify_transactions_table_for_expenses',1),(38,'2018_01_09_111005_modify_payment_status_in_transactions_table',1),(39,'2018_01_09_111109_add_paid_on_column_to_transaction_payments_table',1),(40,'2018_01_25_172439_add_printer_related_fields_to_business_locations_table',1),(41,'2018_01_27_184322_create_printers_table',1),(42,'2018_01_30_181442_create_cash_registers_table',1),(43,'2018_01_31_125836_create_cash_register_transactions_table',1),(44,'2018_02_07_173326_modify_business_table',1),(45,'2018_02_08_105425_add_enable_product_expiry_column_to_business_table',1),(46,'2018_02_08_111027_add_expiry_period_and_expiry_period_type_columns_to_products_table',1),(47,'2018_02_08_131118_add_mfg_date_and_exp_date_purchase_lines_table',1),(48,'2018_02_08_155348_add_exchange_rate_to_transactions_table',1),(49,'2018_02_09_124945_modify_transaction_payments_table_for_contact_payments',1),(50,'2018_02_12_113640_create_transaction_sell_lines_purchase_lines_table',1),(51,'2018_02_12_114605_add_quantity_sold_in_purchase_lines_table',1),(52,'2018_02_13_183323_alter_decimal_fields_size',1),(53,'2018_02_14_161928_add_transaction_edit_days_to_business_table',1),(54,'2018_02_15_161032_add_document_column_to_transactions_table',1),(55,'2018_02_17_124709_add_more_options_to_invoice_layouts',1),(56,'2018_02_19_111517_add_keyboard_shortcut_column_to_business_table',1),(57,'2018_02_19_121537_stock_adjustment_move_to_transaction_table',1),(58,'2018_02_20_165505_add_is_direct_sale_column_to_transactions_table',1),(59,'2018_02_21_105329_create_system_table',1),(60,'2018_02_23_100549_version_1_2',1),(61,'2018_02_23_125648_add_enable_editing_sp_from_purchase_column_to_business_table',1),(62,'2018_02_26_103612_add_sales_commission_agent_column_to_business_table',1),(63,'2018_02_26_130519_modify_users_table_for_sales_cmmsn_agnt',1),(64,'2018_02_26_134500_add_commission_agent_to_transactions_table',1),(65,'2018_02_27_121422_add_item_addition_method_to_business_table',1),(66,'2018_02_27_170232_modify_transactions_table_for_stock_transfer',1),(67,'2018_03_05_153510_add_enable_inline_tax_column_to_business_table',1),(68,'2018_03_06_210206_modify_product_barcode_types',1),(69,'2018_03_13_181541_add_expiry_type_to_business_table',1),(70,'2018_03_16_113446_product_expiry_setting_for_business',1),(71,'2018_03_19_113601_add_business_settings_options',1),(72,'2018_03_26_125334_add_pos_settings_to_business_table',1),(73,'2018_03_26_165350_create_customer_groups_table',1),(74,'2018_03_27_122720_customer_group_related_changes_in_tables',1),(75,'2018_03_29_110138_change_tax_field_to_nullable_in_business_table',1),(76,'2018_03_29_115502_add_changes_for_sr_number_in_products_and_sale_lines_table',1),(77,'2018_03_29_134340_add_inline_discount_fields_in_purchase_lines',1),(78,'2018_03_31_140921_update_transactions_table_exchange_rate',1),(79,'2018_04_03_103037_add_contact_id_to_contacts_table',1),(80,'2018_04_03_122709_add_changes_to_invoice_layouts_table',1),(81,'2018_04_09_135320_change_exchage_rate_size_in_business_table',1),(82,'2018_04_17_123122_add_lot_number_to_business',1),(83,'2018_04_17_160845_add_product_racks_table',1),(84,'2018_04_20_182015_create_res_tables_table',1),(85,'2018_04_24_105246_restaurant_fields_in_transaction_table',1),(86,'2018_04_24_114149_add_enabled_modules_business_table',1),(87,'2018_04_24_133704_add_modules_fields_in_invoice_layout_table',1),(88,'2018_04_27_132653_quotation_related_change',1),(89,'2018_05_02_104439_add_date_format_and_time_format_to_business',1),(90,'2018_05_02_111939_add_sell_return_to_transaction_payments',1),(91,'2018_05_14_114027_add_rows_positions_for_products',1),(92,'2018_05_14_125223_add_weight_to_products_table',1),(93,'2018_05_14_164754_add_opening_stock_permission',1),(94,'2018_05_15_134729_add_design_to_invoice_layouts',1),(95,'2018_05_16_183307_add_tax_fields_invoice_layout',1),(96,'2018_05_18_191956_add_sell_return_to_transaction_table',1),(97,'2018_05_21_131349_add_custom_fileds_to_contacts_table',1),(98,'2018_05_21_131607_invoice_layout_fields_for_sell_return',1),(99,'2018_05_21_131949_add_custom_fileds_and_website_to_business_locations_table',1),(100,'2018_05_22_123527_create_reference_counts_table',1),(101,'2018_05_22_154540_add_ref_no_prefixes_column_to_business_table',1),(102,'2018_05_24_132620_add_ref_no_column_to_transaction_payments_table',1),(103,'2018_05_24_161026_add_location_id_column_to_business_location_table',1),(104,'2018_05_25_180603_create_modifiers_related_table',1),(105,'2018_05_29_121714_add_purchase_line_id_to_stock_adjustment_line_table',1),(106,'2018_05_31_114645_add_res_order_status_column_to_transactions_table',1),(107,'2018_06_05_103530_rename_purchase_line_id_in_stock_adjustment_lines_table',1),(108,'2018_06_05_111905_modify_products_table_for_modifiers',1),(109,'2018_06_06_110524_add_parent_sell_line_id_column_to_transaction_sell_lines_table',1),(110,'2018_06_07_152443_add_is_service_staff_to_roles_table',1),(111,'2018_06_07_182258_add_image_field_to_products_table',1),(112,'2018_06_13_133705_create_bookings_table',1),(113,'2018_06_15_173636_add_email_column_to_contacts_table',1),(114,'2018_06_27_182835_add_superadmin_related_fields_business',1),(115,'2018_07_10_101913_add_custom_fields_to_products_table',1),(116,'2018_07_17_103434_add_sales_person_name_label_to_invoice_layouts_table',1),(117,'2018_07_17_163920_add_theme_skin_color_column_to_business_table',1),(118,'2018_07_24_160319_add_lot_no_line_id_to_transaction_sell_lines_table',1),(119,'2018_07_25_110004_add_show_expiry_and_show_lot_colums_to_invoice_layouts_table',1),(120,'2018_07_25_172004_add_discount_columns_to_transaction_sell_lines_table',1),(121,'2018_07_26_124720_change_design_column_type_in_invoice_layouts_table',1),(122,'2018_07_26_170424_add_unit_price_before_discount_column_to_transaction_sell_line_table',1),(123,'2018_07_28_103614_add_credit_limit_column_to_contacts_table',1),(124,'2018_08_08_110755_add_new_payment_methods_to_transaction_payments_table',1),(125,'2018_08_08_122225_modify_cash_register_transactions_table_for_new_payment_methods',1),(126,'2018_08_14_104036_add_opening_balance_type_to_transactions_table',1),(127,'2018_09_04_155900_create_accounts_table',1),(128,'2018_09_06_114438_create_selling_price_groups_table',1),(129,'2018_09_06_154057_create_variation_group_prices_table',1),(130,'2018_09_07_102413_add_permission_to_access_default_selling_price',1),(131,'2018_09_07_134858_add_selling_price_group_id_to_transactions_table',1),(132,'2018_09_10_112448_update_product_type_to_single_if_null_in_products_table',1),(133,'2018_09_10_152703_create_account_transactions_table',1),(134,'2018_09_10_173656_add_account_id_column_to_transaction_payments_table',1),(135,'2018_09_19_123914_create_notification_templates_table',1),(136,'2018_09_22_110504_add_sms_and_email_settings_columns_to_business_table',1),(137,'2018_09_24_134942_add_lot_no_line_id_to_stock_adjustment_lines_table',1),(138,'2018_09_26_105557_add_transaction_payments_for_existing_expenses',1),(139,'2018_09_27_111609_modify_transactions_table_for_purchase_return',1),(140,'2018_09_27_131154_add_quantity_returned_column_to_purchase_lines_table',1),(141,'2018_10_02_131401_add_return_quantity_column_to_transaction_sell_lines_table',1),(142,'2018_10_03_104918_add_qty_returned_column_to_transaction_sell_lines_purchase_lines_table',1),(143,'2018_10_03_185947_add_default_notification_templates_to_database',1),(144,'2018_10_09_153105_add_business_id_to_transaction_payments_table',1),(145,'2018_10_16_135229_create_permission_for_sells_and_purchase',1),(146,'2018_10_22_114441_add_columns_for_variable_product_modifications',1),(147,'2018_10_22_134428_modify_variable_product_data',1),(148,'2018_10_30_181558_add_table_tax_headings_to_invoice_layout',1),(149,'2018_10_31_122619_add_pay_terms_field_transactions_table',1),(150,'2018_10_31_161328_add_new_permissions_for_pos_screen',1),(151,'2018_10_31_174752_add_access_selected_contacts_only_to_users_table',1),(152,'2018_10_31_175627_add_user_contact_access',1),(153,'2018_10_31_180559_add_auto_send_sms_column_to_notification_templates_table',1),(154,'2018_11_02_171949_change_card_type_column_to_varchar_in_transaction_payments_table',1),(155,'2018_11_08_105621_add_role_permissions',1),(156,'2018_11_26_114135_add_is_suspend_column_to_transactions_table',1),(157,'2018_11_28_104410_modify_units_table_for_multi_unit',1),(158,'2018_11_28_170952_add_sub_unit_id_to_purchase_lines_and_sell_lines',1),(159,'2018_11_29_115918_add_primary_key_in_system_table',1),(160,'2018_12_03_185546_add_product_description_column_to_products_table',1),(161,'2018_12_06_114937_modify_system_table_and_users_table',1),(162,'2018_12_13_160007_add_custom_fields_display_options_to_invoice_layouts_table',1),(163,'2018_12_14_103307_modify_system_table',1),(164,'2018_12_18_133837_add_prev_balance_due_columns_to_invoice_layouts_table',1),(165,'2018_12_18_170656_add_invoice_token_column_to_transaction_table',1),(166,'2018_12_20_133639_add_date_time_format_column_to_invoice_layouts_table',1),(167,'2018_12_21_120659_add_recurring_invoice_fields_to_transactions_table',1),(168,'2018_12_24_154933_create_notifications_table',1),(169,'2019_01_08_112015_add_document_column_to_transaction_payments_table',1),(170,'2019_01_10_124645_add_account_permission',1),(171,'2019_01_16_125825_add_subscription_no_column_to_transactions_table',1),(172,'2019_01_28_111647_add_order_addresses_column_to_transactions_table',1),(173,'2019_02_13_173821_add_is_inactive_column_to_products_table',1),(174,'2019_02_19_103118_create_discounts_table',1),(175,'2019_02_21_120324_add_discount_id_column_to_transaction_sell_lines_table',1),(176,'2019_02_21_134324_add_permission_for_discount',1),(177,'2019_03_04_170832_add_service_staff_columns_to_transaction_sell_lines_table',1),(178,'2019_03_09_102425_add_sub_type_column_to_transactions_table',1),(179,'2019_03_09_124457_add_indexing_transaction_sell_lines_purchase_lines_table',1),(180,'2019_03_12_120336_create_activity_log_table',1),(181,'2019_03_15_132925_create_media_table',1),(182,'2019_05_08_130339_add_indexing_to_parent_id_in_transaction_payments_table',1),(183,'2019_05_10_132311_add_missing_column_indexing',1),(184,'2019_05_14_091812_add_show_image_column_to_invoice_layouts_table',1),(185,'2019_05_25_104922_add_view_purchase_price_permission',1),(186,'2019_06_17_103515_add_profile_informations_columns_to_users_table',1),(187,'2019_06_18_135524_add_permission_to_view_own_sales_only',1),(188,'2019_06_19_112058_add_database_changes_for_reward_points',1),(189,'2019_06_28_133732_change_type_column_to_string_in_transactions_table',1),(190,'2019_07_13_111420_add_is_created_from_api_column_to_transactions_table',1),(191,'2019_07_15_165136_add_fields_for_combo_product',1),(192,'2019_07_19_103446_add_mfg_quantity_used_column_to_purchase_lines_table',1),(193,'2019_07_22_152649_add_not_for_selling_in_product_table',1),(194,'2019_07_29_185351_add_show_reward_point_column_to_invoice_layouts_table',1),(195,'2019_08_08_162302_add_sub_units_related_fields',1),(196,'2019_08_26_133419_update_price_fields_decimal_point',1),(197,'2019_09_02_160054_remove_location_permissions_from_roles',1),(198,'2019_09_03_185259_add_permission_for_pos_screen',1),(199,'2019_09_04_163141_add_location_id_to_cash_registers_table',1),(200,'2019_09_04_184008_create_types_of_services_table',1),(201,'2019_09_06_131445_add_types_of_service_fields_to_transactions_table',1),(202,'2019_09_09_134810_add_default_selling_price_group_id_column_to_business_locations_table',1),(203,'2019_09_12_105616_create_product_locations_table',1),(204,'2019_09_17_122522_add_custom_labels_column_to_business_table',1),(205,'2019_09_18_164319_add_shipping_fields_to_transactions_table',1),(206,'2019_09_19_170927_close_all_active_registers',1),(207,'2019_09_23_161906_add_media_description_cloumn_to_media_table',1),(208,'2019_10_18_155633_create_account_types_table',1),(209,'2019_10_22_163335_add_common_settings_column_to_business_table',1),(210,'2019_10_29_132521_add_update_purchase_status_permission',1),(211,'2019_11_09_110522_add_indexing_to_lot_number',1),(212,'2019_11_19_170824_add_is_active_column_to_business_locations_table',1),(213,'2019_11_21_162913_change_quantity_field_types_to_decimal',1),(214,'2019_11_25_160340_modify_categories_table_for_polymerphic_relationship',1),(215,'2019_12_02_105025_create_warranties_table',1),(216,'2019_12_03_180342_add_common_settings_field_to_invoice_layouts_table',1),(217,'2019_12_05_183955_add_more_fields_to_users_table',1),(218,'2019_12_06_174904_add_change_return_label_column_to_invoice_layouts_table',1),(219,'2019_12_11_121307_add_draft_and_quotation_list_permissions',1),(220,'2019_12_12_180126_copy_expense_total_to_total_before_tax',1),(221,'2019_12_19_181412_make_alert_quantity_field_nullable_on_products_table',1),(222,'2019_12_25_173413_create_dashboard_configurations_table',1),(223,'2020_01_08_133506_create_document_and_notes_table',1),(224,'2020_01_09_113252_add_cc_bcc_column_to_notification_templates_table',1),(225,'2020_01_16_174818_add_round_off_amount_field_to_transactions_table',1),(226,'2020_01_28_162345_add_weighing_scale_settings_in_business_settings_table',1),(227,'2020_02_18_172447_add_import_fields_to_transactions_table',1),(228,'2020_03_13_135844_add_is_active_column_to_selling_price_groups_table',1),(229,'2020_03_16_115449_add_contact_status_field_to_contacts_table',1),(230,'2020_03_26_124736_add_allow_login_column_in_users_table',1),(231,'2020_04_13_154150_add_feature_products_column_to_business_loactions',1),(232,'2020_04_15_151802_add_user_type_to_users_table',1),(233,'2020_04_22_153905_add_subscription_repeat_on_column_to_transactions_table',1),(234,'2020_04_28_111436_add_shipping_address_to_contacts_table',1),(235,'2020_06_01_094654_add_max_sale_discount_column_to_users_table',1),(236,'2020_06_12_162245_modify_contacts_table',1),(237,'2020_06_22_103104_change_recur_interval_default_to_one',1),(238,'2020_07_09_174621_add_balance_field_to_contacts_table',1),(239,'2020_07_23_104933_change_status_column_to_varchar_in_transaction_table',1),(240,'2020_09_07_171059_change_completed_stock_transfer_status_to_final',1),(241,'2020_09_21_123224_modify_booking_status_column_in_bookings_table',1),(242,'2020_09_22_121639_create_discount_variations_table',1),(243,'2020_10_05_121550_modify_business_location_table_for_invoice_layout',1),(244,'2020_10_16_175726_set_status_as_received_for_opening_stock',1),(245,'2020_10_23_170823_add_for_group_tax_column_to_tax_rates_table',1),(246,'2020_11_04_130940_add_more_custom_fields_to_contacts_table',1),(247,'2020_11_10_152841_add_cash_register_permissions',1),(248,'2020_11_17_164041_modify_type_column_to_varchar_in_contacts_table',1),(249,'2020_12_18_181447_add_shipping_custom_fields_to_transactions_table',1),(250,'2020_12_22_164303_add_sub_status_column_to_transactions_table',1),(251,'2020_12_24_153050_add_custom_fields_to_transactions_table',1),(252,'2020_12_28_105403_add_whatsapp_text_column_to_notification_templates_table',1),(253,'2020_12_29_165925_add_model_document_type_to_media_table',1),(254,'2021_02_08_175632_add_contact_number_fields_to_users_table',1),(255,'2021_02_11_172217_add_indexing_for_multiple_columns',1),(256,'2021_02_23_122043_add_more_columns_to_customer_groups_table',1),(257,'2021_02_24_175551_add_print_invoice_permission_to_all_roles',1),(258,'2019_03_07_155813_make_repair_statuses_table',2),(259,'2019_03_08_120634_add_repair_columns_to_transactions_table',2),(260,'2019_03_14_182704_add_repair_permissions',2),(261,'2019_03_29_110241_add_repair_version_column_to_system_table',2),(262,'2019_04_12_113901_add_repair_settings_column_to_business_table',2),(263,'2020_05_05_125008_create_device_models_table',2),(264,'2020_05_06_103135_add_repair_model_id_column_to_products_table',2),(265,'2020_07_11_120308_add_columns_to_repair_statuses_table',2),(266,'2020_07_31_130737_create_job_sheets_table',2),(267,'2020_08_07_124241_add_job_sheet_id_to_transactions_table',2),(268,'2020_08_22_104640_add_email_template_field_to_repair_status_table',2),(269,'2020_10_19_131934_add_job_sheet_custom_fields_to_repair_job_sheets_table',2);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `model_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`) USING BTREE,
  KEY `model_has_permissions_model_type_model_id_index` (`model_type`,`model_id`) USING BTREE,
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_permissions` WRITE;
/*!40000 ALTER TABLE `model_has_permissions` DISABLE KEYS */;
INSERT INTO `model_has_permissions` VALUES (82,'App\\User',2),(80,'App\\User',3),(80,'App\\User',4),(80,'App\\User',5),(80,'App\\User',6),(80,'App\\User',7),(80,'App\\User',8),(80,'App\\User',9),(80,'App\\User',10),(80,'App\\User',11),(80,'App\\User',15),(80,'App\\User',16),(80,'App\\User',19),(80,'App\\User',20),(80,'App\\User',21),(80,'App\\User',22),(80,'App\\User',23),(80,'App\\User',24);
/*!40000 ALTER TABLE `model_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `model_has_roles` (
  `role_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`) USING BTREE,
  KEY `model_has_roles_model_type_model_id_index` (`model_type`,`model_id`) USING BTREE,
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_roles` WRITE;
/*!40000 ALTER TABLE `model_has_roles` DISABLE KEYS */;
INSERT INTO `model_has_roles` VALUES (1,'App\\User',1),(3,'App\\User',2),(5,'App\\User',3),(5,'App\\User',4),(3,'App\\User',6),(3,'App\\User',7),(3,'App\\User',8),(1,'App\\User',9),(3,'App\\User',10),(5,'App\\User',11),(1,'App\\User',15),(3,'App\\User',16),(5,'App\\User',19),(2,'App\\User',20),(3,'App\\User',21),(3,'App\\User',22),(3,'App\\User',23),(3,'App\\User',24);
/*!40000 ALTER TABLE `model_has_roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notification_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notification_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `template_for` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_body` text COLLATE utf8mb4_unicode_ci,
  `sms_body` text COLLATE utf8mb4_unicode_ci,
  `whatsapp_text` text COLLATE utf8mb4_unicode_ci,
  `subject` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cc` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bcc` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `auto_send` tinyint(1) NOT NULL DEFAULT '0',
  `auto_send_sms` tinyint(1) NOT NULL DEFAULT '0',
  `auto_send_wa_notif` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notification_templates` WRITE;
/*!40000 ALTER TABLE `notification_templates` DISABLE KEYS */;
INSERT INTO `notification_templates` VALUES (1,1,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2021-08-06 01:22:09','2021-08-06 01:22:09'),(2,1,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}',NULL,'Payment Received, from {business_name}',NULL,NULL,0,0,0,'2021-08-06 01:22:09','2021-08-06 01:22:09'),(3,1,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}',NULL,'Payment Reminder, from {business_name}',NULL,NULL,0,0,0,'2021-08-06 01:22:09','2021-08-06 01:22:09'),(4,1,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}',NULL,'Booking Confirmed - {business_name}',NULL,NULL,0,0,0,'2021-08-06 01:22:09','2021-08-06 01:22:09'),(5,1,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}',NULL,'New Order, from {business_name}',NULL,NULL,0,0,0,'2021-08-06 01:22:09','2021-08-06 01:22:09'),(6,1,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}',NULL,'Payment Paid, from {business_name}',NULL,NULL,0,0,0,'2021-08-06 01:22:09','2021-08-06 01:22:09'),(7,1,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}',NULL,'Items received, from {business_name}',NULL,NULL,0,0,0,'2021-08-06 01:22:09','2021-08-06 01:22:09'),(8,1,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}',NULL,'Items Pending, from {business_name}',NULL,NULL,0,0,0,'2021-08-06 01:22:09','2021-08-06 01:22:09'),(9,1,'new_quotation','<p>Dear {contact_name},</p>\n\n                    <p>Your quotation number is {invoice_number}<br />\n                    Total amount: {total_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2021-08-06 01:22:09','2021-08-06 01:22:09');
/*!40000 ALTER TABLE `notification_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notifications` (
  `id` char(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `notifiable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `notifiable_id` bigint(20) unsigned NOT NULL,
  `data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `notifications_notifiable_type_notifiable_id_index` (`notifiable_type`,`notifiable_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notifications` WRITE;
/*!40000 ALTER TABLE `notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `notifications` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_access_tokens` (
  `id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `client_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `scopes` text COLLATE utf8mb4_unicode_ci,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `oauth_access_tokens_user_id_index` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_access_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_auth_codes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_auth_codes` (
  `id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `client_id` int(10) unsigned NOT NULL,
  `scopes` text COLLATE utf8mb4_unicode_ci,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_auth_codes` WRITE;
/*!40000 ALTER TABLE `oauth_auth_codes` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_auth_codes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_clients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `secret` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `redirect` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `personal_access_client` tinyint(1) NOT NULL,
  `password_client` tinyint(1) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `oauth_clients_user_id_index` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_clients` WRITE;
/*!40000 ALTER TABLE `oauth_clients` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_clients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_personal_access_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_personal_access_clients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `client_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `oauth_personal_access_clients_client_id_index` (`client_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_personal_access_clients` WRITE;
/*!40000 ALTER TABLE `oauth_personal_access_clients` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_personal_access_clients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_refresh_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_refresh_tokens` (
  `id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `access_token_id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `oauth_refresh_tokens_access_token_id_index` (`access_token_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_refresh_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_refresh_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_refresh_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=106 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `permissions` WRITE;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
INSERT INTO `permissions` VALUES (1,'profit_loss_report.view','web','2021-08-06 01:20:51',NULL),(2,'direct_sell.access','web','2021-08-06 01:20:51',NULL),(3,'product.opening_stock','web','2021-08-06 01:20:51','2021-08-06 01:20:51'),(4,'crud_all_bookings','web','2021-08-06 01:20:51','2021-08-06 01:20:51'),(5,'crud_own_bookings','web','2021-08-06 01:20:52','2021-08-06 01:20:52'),(6,'access_default_selling_price','web','2021-08-06 01:20:52','2021-08-06 01:20:52'),(7,'purchase.payments','web','2021-08-06 01:20:52','2021-08-06 01:20:52'),(8,'sell.payments','web','2021-08-06 01:20:52','2021-08-06 01:20:52'),(9,'edit_product_price_from_sale_screen','web','2021-08-06 01:20:52','2021-08-06 01:20:52'),(10,'edit_product_discount_from_sale_screen','web','2021-08-06 01:20:52','2021-08-06 01:20:52'),(11,'roles.view','web','2021-08-06 01:20:52','2021-08-06 01:20:52'),(12,'roles.create','web','2021-08-06 01:20:52','2021-08-06 01:20:52'),(13,'roles.update','web','2021-08-06 01:20:52','2021-08-06 01:20:52'),(14,'roles.delete','web','2021-08-06 01:20:52','2021-08-06 01:20:52'),(15,'account.access','web','2021-08-06 01:20:52','2021-08-06 01:20:52'),(16,'discount.access','web','2021-08-06 01:20:52','2021-08-06 01:20:52'),(17,'view_purchase_price','web','2021-08-06 01:20:52','2021-08-06 01:20:52'),(18,'view_own_sell_only','web','2021-08-06 01:20:52','2021-08-06 01:20:52'),(19,'edit_product_discount_from_pos_screen','web','2021-08-06 01:20:53','2021-08-06 01:20:53'),(20,'edit_product_price_from_pos_screen','web','2021-08-06 01:20:53','2021-08-06 01:20:53'),(21,'access_shipping','web','2021-08-06 01:20:53','2021-08-06 01:20:53'),(22,'purchase.update_status','web','2021-08-06 01:20:53','2021-08-06 01:20:53'),(23,'list_drafts','web','2021-08-06 01:20:53','2021-08-06 01:20:53'),(24,'list_quotations','web','2021-08-06 01:20:53','2021-08-06 01:20:53'),(25,'view_cash_register','web','2021-08-06 01:20:53','2021-08-06 01:20:53'),(26,'close_cash_register','web','2021-08-06 01:20:53','2021-08-06 01:20:53'),(27,'print_invoice','web','2021-08-06 01:20:54','2021-08-06 01:20:54'),(28,'user.view','web','2021-08-06 01:20:54',NULL),(29,'user.create','web','2021-08-06 01:20:54',NULL),(30,'user.update','web','2021-08-06 01:20:54',NULL),(31,'user.delete','web','2021-08-06 01:20:54',NULL),(32,'supplier.view','web','2021-08-06 01:20:54',NULL),(33,'supplier.create','web','2021-08-06 01:20:54',NULL),(34,'supplier.update','web','2021-08-06 01:20:54',NULL),(35,'supplier.delete','web','2021-08-06 01:20:54',NULL),(36,'customer.view','web','2021-08-06 01:20:54',NULL),(37,'customer.create','web','2021-08-06 01:20:54',NULL),(38,'customer.update','web','2021-08-06 01:20:54',NULL),(39,'customer.delete','web','2021-08-06 01:20:54',NULL),(40,'product.view','web','2021-08-06 01:20:54',NULL),(41,'product.create','web','2021-08-06 01:20:54',NULL),(42,'product.update','web','2021-08-06 01:20:54',NULL),(43,'product.delete','web','2021-08-06 01:20:54',NULL),(44,'purchase.view','web','2021-08-06 01:20:54',NULL),(45,'purchase.create','web','2021-08-06 01:20:54',NULL),(46,'purchase.update','web','2021-08-06 01:20:54',NULL),(47,'purchase.delete','web','2021-08-06 01:20:54',NULL),(48,'sell.view','web','2021-08-06 01:20:54',NULL),(49,'sell.create','web','2021-08-06 01:20:54',NULL),(50,'sell.update','web','2021-08-06 01:20:54',NULL),(51,'sell.delete','web','2021-08-06 01:20:54',NULL),(52,'purchase_n_sell_report.view','web','2021-08-06 01:20:54',NULL),(53,'contacts_report.view','web','2021-08-06 01:20:54',NULL),(54,'stock_report.view','web','2021-08-06 01:20:54',NULL),(55,'tax_report.view','web','2021-08-06 01:20:54',NULL),(56,'trending_product_report.view','web','2021-08-06 01:20:54',NULL),(57,'register_report.view','web','2021-08-06 01:20:54',NULL),(58,'sales_representative.view','web','2021-08-06 01:20:54',NULL),(59,'expense_report.view','web','2021-08-06 01:20:54',NULL),(60,'business_settings.access','web','2021-08-06 01:20:54',NULL),(61,'barcode_settings.access','web','2021-08-06 01:20:54',NULL),(62,'invoice_settings.access','web','2021-08-06 01:20:54',NULL),(63,'brand.view','web','2021-08-06 01:20:54',NULL),(64,'brand.create','web','2021-08-06 01:20:54',NULL),(65,'brand.update','web','2021-08-06 01:20:54',NULL),(66,'brand.delete','web','2021-08-06 01:20:54',NULL),(67,'tax_rate.view','web','2021-08-06 01:20:54',NULL),(68,'tax_rate.create','web','2021-08-06 01:20:54',NULL),(69,'tax_rate.update','web','2021-08-06 01:20:54',NULL),(70,'tax_rate.delete','web','2021-08-06 01:20:54',NULL),(71,'unit.view','web','2021-08-06 01:20:54',NULL),(72,'unit.create','web','2021-08-06 01:20:54',NULL),(73,'unit.update','web','2021-08-06 01:20:54',NULL),(74,'unit.delete','web','2021-08-06 01:20:54',NULL),(75,'category.view','web','2021-08-06 01:20:54',NULL),(76,'category.create','web','2021-08-06 01:20:54',NULL),(77,'category.update','web','2021-08-06 01:20:54',NULL),(78,'category.delete','web','2021-08-06 01:20:54',NULL),(79,'expense.access','web','2021-08-06 01:20:54',NULL),(80,'access_all_locations','web','2021-08-06 01:20:54',NULL),(81,'dashboard.data','web','2021-08-06 01:20:54',NULL),(82,'location.1','web','2021-08-06 01:22:09','2021-08-06 01:22:09'),(83,'repair.create','web','2021-08-05 21:53:17','2021-08-05 21:53:17'),(84,'repair.update','web','2021-08-05 21:53:17','2021-08-05 21:53:17'),(85,'repair.view','web','2021-08-05 21:53:17','2021-08-05 21:53:17'),(86,'repair.delete','web','2021-08-05 21:53:17','2021-08-05 21:53:17'),(87,'repair_status.update','web','2021-08-05 21:53:17','2021-08-05 21:53:17'),(88,'repair_status.access','web','2021-08-05 21:53:18','2021-08-05 21:53:18'),(89,'job_sheet.view_assigned','web','2021-08-05 22:07:04','2021-08-05 22:07:04'),(90,'customer.view_own','web','2021-08-07 19:00:17','2021-08-07 19:00:17'),(91,'job_sheet.create','web','2021-08-07 19:00:17','2021-08-07 19:00:17'),(92,'supplier.view_own','web','2021-08-09 14:44:36','2021-08-09 14:44:36'),(93,'view_own_purchase','web','2021-08-09 14:44:36','2021-08-09 14:44:36'),(94,'direct_sell.delete','web','2021-08-09 14:44:36','2021-08-09 14:44:36'),(95,'view_commission_agent_sell','web','2021-08-09 14:44:36','2021-08-09 14:44:36'),(96,'access_sell_return','web','2021-08-09 14:44:36','2021-08-09 14:44:36'),(97,'edit_invoice_number','web','2021-08-09 14:44:36','2021-08-09 14:44:36'),(98,'access_own_shipping','web','2021-08-09 14:44:36','2021-08-09 14:44:36'),(99,'access_commission_agent_shipping','web','2021-08-09 14:44:36','2021-08-09 14:44:36'),(100,'view_product_stock_value','web','2021-08-09 14:44:36','2021-08-09 14:44:36'),(101,'view_own_expense','web','2021-08-09 14:44:36','2021-08-09 14:44:36'),(102,'access_printers','web','2021-08-09 14:44:37','2021-08-09 14:44:37'),(103,'job_sheet.edit','web','2021-08-09 14:44:37','2021-08-09 14:44:37'),(104,'job_sheet.delete','web','2021-08-09 14:44:37','2021-08-09 14:44:37'),(105,'job_sheet.view_all','web','2021-08-09 14:44:37','2021-08-09 14:44:37');
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `printers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `printers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection_type` enum('network','windows','linux') COLLATE utf8mb4_unicode_ci NOT NULL,
  `capability_profile` enum('default','simple','SP2000','TEP-200M','P822D') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `char_per_line` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip_address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `port` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `path` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `printers_business_id_foreign` (`business_id`) USING BTREE,
  CONSTRAINT `printers_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `printers` WRITE;
/*!40000 ALTER TABLE `printers` DISABLE KEYS */;
/*!40000 ALTER TABLE `printers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_locations` (
  `product_id` int(11) NOT NULL,
  `location_id` int(11) NOT NULL,
  KEY `product_locations_product_id_index` (`product_id`) USING BTREE,
  KEY `product_locations_location_id_index` (`location_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_locations` WRITE;
/*!40000 ALTER TABLE `product_locations` DISABLE KEYS */;
INSERT INTO `product_locations` VALUES (1,1),(2,1),(3,1),(4,1);
/*!40000 ALTER TABLE `product_locations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_racks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_racks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `rack` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `row` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `product_racks_business_id_index` (`business_id`) USING BTREE,
  KEY `product_racks_location_id_index` (`location_id`) USING BTREE,
  KEY `product_racks_product_id_index` (`product_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_racks` WRITE;
/*!40000 ALTER TABLE `product_racks` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_racks` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_variations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `variation_template_id` int(11) DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `is_dummy` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `product_variations_name_index` (`name`) USING BTREE,
  KEY `product_variations_product_id_index` (`product_id`) USING BTREE,
  CONSTRAINT `product_variations_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_variations` WRITE;
/*!40000 ALTER TABLE `product_variations` DISABLE KEYS */;
INSERT INTO `product_variations` VALUES (1,NULL,'DUMMY',1,1,'2021-08-05 22:26:23','2021-08-05 22:26:23'),(2,NULL,'DUMMY',2,1,'2021-08-07 17:07:44','2021-08-07 17:07:44'),(3,NULL,'DUMMY',3,1,'2021-08-07 18:03:47','2021-08-07 18:03:47'),(4,NULL,'DUMMY',4,1,'2021-08-16 15:49:45','2021-08-16 15:49:45');
/*!40000 ALTER TABLE `product_variations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `products` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `type` enum('single','variable','modifier','combo') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `unit_id` int(11) unsigned DEFAULT NULL,
  `sub_unit_ids` text COLLATE utf8mb4_unicode_ci,
  `brand_id` int(10) unsigned DEFAULT NULL,
  `category_id` int(10) unsigned DEFAULT NULL,
  `sub_category_id` int(10) unsigned DEFAULT NULL,
  `tax` int(10) unsigned DEFAULT NULL,
  `tax_type` enum('inclusive','exclusive') COLLATE utf8mb4_unicode_ci NOT NULL,
  `enable_stock` tinyint(1) NOT NULL DEFAULT '0',
  `alert_quantity` decimal(22,4) DEFAULT NULL,
  `sku` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `barcode_type` enum('C39','C128','EAN13','EAN8','UPCA','UPCE') COLLATE utf8mb4_unicode_ci DEFAULT 'C128',
  `expiry_period` decimal(4,2) DEFAULT NULL,
  `expiry_period_type` enum('days','months') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enable_sr_no` tinyint(1) NOT NULL DEFAULT '0',
  `weight` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_description` text COLLATE utf8mb4_unicode_ci,
  `created_by` int(10) unsigned NOT NULL,
  `warranty_id` int(11) DEFAULT NULL,
  `is_inactive` tinyint(1) NOT NULL DEFAULT '0',
  `repair_model_id` int(10) unsigned DEFAULT NULL,
  `not_for_selling` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `products_brand_id_foreign` (`brand_id`) USING BTREE,
  KEY `products_category_id_foreign` (`category_id`) USING BTREE,
  KEY `products_sub_category_id_foreign` (`sub_category_id`) USING BTREE,
  KEY `products_tax_foreign` (`tax`) USING BTREE,
  KEY `products_name_index` (`name`) USING BTREE,
  KEY `products_business_id_index` (`business_id`) USING BTREE,
  KEY `products_unit_id_index` (`unit_id`) USING BTREE,
  KEY `products_created_by_index` (`created_by`) USING BTREE,
  KEY `products_warranty_id_index` (`warranty_id`) USING BTREE,
  KEY `products_type_index` (`type`) USING BTREE,
  KEY `products_tax_type_index` (`tax_type`) USING BTREE,
  KEY `products_barcode_type_index` (`barcode_type`) USING BTREE,
  KEY `products_repair_model_id_foreign` (`repair_model_id`) USING BTREE,
  CONSTRAINT `products_brand_id_foreign` FOREIGN KEY (`brand_id`) REFERENCES `brands` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_repair_model_id_foreign` FOREIGN KEY (`repair_model_id`) REFERENCES `repair_device_models` (`id`),
  CONSTRAINT `products_sub_category_id_foreign` FOREIGN KEY (`sub_category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_tax_foreign` FOREIGN KEY (`tax`) REFERENCES `tax_rates` (`id`),
  CONSTRAINT `products_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `units` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,'Maintenance',1,'single',1,NULL,NULL,NULL,NULL,NULL,'exclusive',0,0.0000,'123','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,NULL,0,'2021-08-05 22:26:23','2021-08-05 22:26:23'),(2,'iPhone X Screen',1,'single',1,NULL,1,NULL,NULL,NULL,'inclusive',1,10.0000,'002','C128',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,12,0,'2021-08-07 17:07:44','2021-08-07 18:01:02'),(3,'System Service',1,'single',1,NULL,NULL,NULL,NULL,NULL,'exclusive',0,0.0000,'1234','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,NULL,0,'2021-08-07 18:03:46','2021-08-07 18:05:47'),(4,'SPARE PARTS',1,'single',1,'[\"1\"]',NULL,NULL,NULL,NULL,'exclusive',1,NULL,'01','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,NULL,0,'2021-08-16 15:49:45','2021-08-16 15:49:45');
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `purchase_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `purchase_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `variation_id` int(10) unsigned NOT NULL,
  `quantity` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `pp_without_discount` decimal(22,4) NOT NULL DEFAULT '0.0000' COMMENT 'Purchase price before inline discounts',
  `discount_percent` decimal(5,2) NOT NULL DEFAULT '0.00' COMMENT 'Inline discount percentage',
  `purchase_price` decimal(22,4) NOT NULL,
  `purchase_price_inc_tax` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `item_tax` decimal(22,4) NOT NULL COMMENT 'Tax for one quantity',
  `tax_id` int(10) unsigned DEFAULT NULL,
  `quantity_sold` decimal(22,4) NOT NULL DEFAULT '0.0000' COMMENT 'Quanity sold from this purchase line',
  `quantity_adjusted` decimal(22,4) NOT NULL DEFAULT '0.0000' COMMENT 'Quanity adjusted in stock adjustment from this purchase line',
  `quantity_returned` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `mfg_quantity_used` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `mfg_date` date DEFAULT NULL,
  `exp_date` date DEFAULT NULL,
  `lot_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_unit_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `purchase_lines_transaction_id_foreign` (`transaction_id`) USING BTREE,
  KEY `purchase_lines_product_id_foreign` (`product_id`) USING BTREE,
  KEY `purchase_lines_variation_id_foreign` (`variation_id`) USING BTREE,
  KEY `purchase_lines_tax_id_foreign` (`tax_id`) USING BTREE,
  KEY `purchase_lines_sub_unit_id_index` (`sub_unit_id`) USING BTREE,
  KEY `purchase_lines_lot_number_index` (`lot_number`) USING BTREE,
  CONSTRAINT `purchase_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `purchase_lines` WRITE;
/*!40000 ALTER TABLE `purchase_lines` DISABLE KEYS */;
INSERT INTO `purchase_lines` VALUES (1,6,2,2,3.0000,1000.0000,0.00,1000.0000,1000.0000,0.0000,NULL,3.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2021-08-07 17:08:13','2021-09-16 20:49:46');
/*!40000 ALTER TABLE `purchase_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `reference_counts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `reference_counts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ref_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ref_count` int(11) NOT NULL,
  `business_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `reference_counts_business_id_index` (`business_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `reference_counts` WRITE;
/*!40000 ALTER TABLE `reference_counts` DISABLE KEYS */;
INSERT INTO `reference_counts` VALUES (1,'contacts',693,1,'2021-08-06 01:22:09','2021-09-30 17:34:44'),(2,'business_location',1,1,'2021-08-06 01:22:09','2021-08-06 01:22:09'),(3,'username',18,1,'2021-08-05 22:07:52','2021-09-13 16:13:10'),(4,'job_sheet',678,1,'2021-08-05 22:08:54','2021-09-30 17:01:16'),(5,'sell_payment',499,1,'2021-08-05 22:27:36','2021-09-30 17:08:24'),(6,'expense',2,1,'2021-08-06 02:32:45','2021-08-07 19:05:02'),(7,'expense_payment',1,1,'2021-08-06 02:32:58','2021-08-06 02:32:58'),(8,'draft',2,1,'2021-08-16 15:52:14','2021-09-21 17:14:03'),(9,'sell_return',4,1,'2021-09-13 02:09:04','2021-09-25 22:09:03');
/*!40000 ALTER TABLE `reference_counts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `repair_device_models`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `repair_device_models` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `repair_checklist` text COLLATE utf8mb4_unicode_ci,
  `brand_id` int(10) unsigned DEFAULT NULL,
  `device_id` int(10) unsigned DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `repair_device_models_business_id_foreign` (`business_id`) USING BTREE,
  KEY `repair_device_models_brand_id_foreign` (`brand_id`) USING BTREE,
  KEY `repair_device_models_device_id_foreign` (`device_id`) USING BTREE,
  KEY `repair_device_models_created_by_foreign` (`created_by`) USING BTREE,
  CONSTRAINT `repair_device_models_brand_id_foreign` FOREIGN KEY (`brand_id`) REFERENCES `brands` (`id`),
  CONSTRAINT `repair_device_models_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `repair_device_models_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `repair_device_models_device_id_foreign` FOREIGN KEY (`device_id`) REFERENCES `categories` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=642 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `repair_device_models` WRITE;
/*!40000 ALTER TABLE `repair_device_models` DISABLE KEYS */;
INSERT INTO `repair_device_models` VALUES (1,1,'iPhone 5s','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Finger Print|Charger Port\"',1,1,1,'2021-08-05 22:03:11','2021-08-08 19:07:23'),(2,1,'iPhone 4s','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Finger Print|Charger Port\"',1,1,1,'2021-08-07 15:19:09','2021-08-08 19:07:41'),(3,1,'iPhone 6','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Finger Print|Charger Port\"',1,1,1,'2021-08-07 15:20:40','2021-08-08 19:07:17'),(4,1,'iPhone 6s','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Finger Print|Charger Port\"',1,1,1,'2021-08-07 15:20:58','2021-08-08 19:01:32'),(5,1,'iPhone 6 Plus','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Finger Print|Charger Port\"',1,1,1,'2021-08-07 15:21:18','2021-08-08 19:07:11'),(6,1,'iPhone 6s Plus','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Finger Print|Charger Port\"',1,1,1,'2021-08-07 15:21:59','2021-08-08 19:01:45'),(7,1,'iPhone 7','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Finger Print|Charger Port\"',1,1,1,'2021-08-07 15:22:16','2021-08-08 19:02:01'),(8,1,'iPhone 5','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Finger Print|Charger Port\"',1,1,1,'2021-08-07 15:22:43','2021-08-08 19:07:35'),(9,1,'iPhone 7 Plus','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Finger Print|Charger Port\"',1,1,1,'2021-08-07 15:23:24','2021-08-08 19:00:52'),(10,1,'iPhone 8','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Finger Print|Charger Port\"',1,1,1,'2021-08-07 15:23:46','2021-08-08 19:02:35'),(11,1,'iPhone 8 Plus','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Finger Print|Charger Port\"',1,1,1,'2021-08-07 15:24:22','2021-08-08 19:02:41'),(12,1,'iPhone X','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port\"',1,1,1,'2021-08-07 15:24:44','2021-08-08 19:03:11'),(13,1,'iPhone XR','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port\"',1,1,1,'2021-08-07 15:25:11','2021-08-08 19:03:22'),(14,1,'iPhone SE','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Finger Print|Charger Port\"',1,1,1,'2021-08-07 15:28:35','2021-08-08 18:58:14'),(15,1,'iPhone SE gen2','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Finger Print|Charger Port\"',1,1,1,'2021-08-07 15:28:57','2021-08-08 19:02:51'),(16,1,'iPhone 5C','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Finger Print|Charger Port\"',1,1,1,'2021-08-07 15:32:22','2021-08-08 19:07:29'),(17,1,'iPhone XS','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port\"',1,1,1,'2021-08-07 15:32:58','2021-08-08 19:03:31'),(18,1,'iPhone Xs Max','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port\"',1,1,1,'2021-08-07 15:36:52','2021-08-08 19:03:37'),(19,1,'iPhone 11','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port\"',1,1,1,'2021-08-07 15:39:20','2021-08-08 19:04:24'),(20,1,'iPhone 11 Pro','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port\"',1,1,1,'2021-08-07 15:39:41','2021-08-08 19:04:17'),(21,1,'iPhone 11 Pro Max','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port\"',1,1,1,'2021-08-07 15:40:44','2021-08-08 19:04:11'),(22,1,'iPhone 12 Mini','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port\"',1,1,1,'2021-08-07 15:41:17','2021-08-08 19:03:58'),(23,1,'iPhone 12','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port\"',1,1,1,'2021-08-07 15:41:50','2021-08-08 19:04:04'),(24,1,'iPhone 12 Pro','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port\"',1,1,1,'2021-08-07 15:42:10','2021-08-08 19:03:52'),(25,1,'iPhone 12 Pro Max','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port\"',1,1,1,'2021-08-07 15:42:33','2021-08-08 19:03:46'),(26,1,'iPad Wi-Fi','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',1,2,1,'2021-08-07 15:47:50','2021-08-08 19:05:21'),(27,1,'iPad W-iFi + 3G','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',1,2,1,'2021-08-07 15:48:23','2021-08-08 19:05:27'),(28,1,'iPad 2 CDMA','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',1,2,1,'2021-08-07 15:49:13','2021-08-08 19:06:48'),(29,1,'iPad 2 Wi-Fi','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',1,2,1,'2021-08-07 15:49:36','2021-08-08 19:06:42'),(30,1,'iPad 2 Wi-Fi +3G','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',1,2,1,'2021-08-07 15:53:23','2021-08-08 19:06:19'),(31,1,'iPad 3 Wi-Fi','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',1,2,1,'2021-08-07 16:10:57','2021-08-08 19:06:14'),(32,1,'iPad 3 Wi-Fi + Cellular','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',1,2,1,'2021-08-07 16:11:56','2021-08-08 19:06:08'),(33,1,'iPad 4 Wi-Fi','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',1,2,1,'2021-08-07 16:13:00','2021-08-08 19:06:02'),(34,1,'iPad 4 Wi-Fi + Cellular','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',1,2,1,'2021-08-07 16:13:57','2021-08-08 19:05:56'),(35,1,'iPad mini Wi-Fi','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',1,2,1,'2021-08-07 16:14:35','2021-08-08 19:05:39'),(36,1,'iPad mini Wi-Fi + Cellular','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',1,2,1,'2021-08-07 16:15:21','2021-08-08 19:05:33'),(37,1,'iPad mini 2','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',1,2,1,'2021-08-07 16:23:06','2021-08-08 19:05:45'),(38,1,'iPad Air','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',1,2,1,'2021-08-07 16:23:20','2021-08-08 19:05:50'),(39,1,'iPad Air 2','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',1,2,1,'2021-08-08 19:11:10','2021-08-08 19:11:25'),(40,1,'iPad Mini 3','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',1,2,1,'2021-08-08 19:11:51','2021-08-08 19:11:51'),(41,1,'iPad mini 4','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',1,2,1,'2021-08-08 19:12:28','2021-08-08 19:12:28'),(42,1,'iPad Pro 12.9 (2015)','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',1,2,1,'2021-08-08 19:12:58','2021-08-08 19:13:33'),(43,1,'iPad Pro 9.7 (2016)','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',1,2,1,'2021-08-08 19:14:05','2021-08-08 19:14:05'),(44,1,'iPad 9.7 (2017)','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',1,2,1,'2021-08-08 19:15:00','2021-08-08 19:15:00'),(45,1,'iPad Pro (2017)','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',1,2,1,'2021-08-08 19:15:44','2021-08-08 19:15:44'),(46,1,'iPad 9.7 (2018)','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',1,2,1,'2021-08-08 19:16:16','2021-08-08 19:16:16'),(47,1,'iPad Pro (2018)','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',1,2,1,'2021-08-08 19:17:08','2021-08-08 19:17:08'),(48,1,'iPad Mini (2019)','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',1,2,1,'2021-08-08 19:17:34','2021-08-08 19:17:34'),(49,1,'iPad Air (2019)','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',1,2,1,'2021-08-08 19:18:00','2021-08-08 19:18:00'),(50,1,'iPad 10.2 (2019)','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',1,2,1,'2021-08-08 19:18:36','2021-08-08 19:18:36'),(51,1,'iPad Pro (2020)','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',1,2,1,'2021-08-08 19:19:32','2021-08-08 19:19:32'),(52,1,'iPad 10.2 (2020)','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',1,2,1,'2021-08-08 19:19:56','2021-08-08 19:19:56'),(53,1,'iPad Air (2020)','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',1,2,1,'2021-08-08 19:20:22','2021-08-08 19:20:22'),(54,1,'iPad Pro (2021)','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',1,2,1,'2021-08-08 19:21:28','2021-08-08 19:21:28'),(55,1,'Samsung Galaxy S21 Ultra 5G','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-08 19:26:20','2021-08-08 19:26:20'),(56,1,'Samsung Galaxy A52','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-08 19:27:47','2021-08-08 19:27:47'),(57,1,'Sumsung A32','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-08 19:28:31','2021-08-08 19:28:31'),(58,1,'Samsung Galaxy A12','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-08 19:28:56','2021-08-08 19:28:56'),(59,1,'Samsung Galaxy A52 5G','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-08 19:29:28','2021-08-08 19:29:28'),(60,1,'Sumsung Galaxy A22 5G','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-08 19:29:57','2021-08-08 19:29:57'),(61,1,'Samsung Galaxy A72','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-08 19:30:22','2021-08-08 19:30:22'),(62,1,'Samsung Galaxy S21 5G','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-08 19:30:52','2021-08-08 19:30:52'),(63,1,'Samsung Galaxy M21 2021','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-08 19:31:16','2021-08-08 19:31:16'),(64,1,'Samsung Galaxy A22','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-08 19:31:33','2021-08-08 19:31:33'),(65,1,'Samsung Galaxy s20 5G','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 17:50:18','2021-08-09 17:50:18'),(66,1,'Samsung Galaxy A32 5G','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 17:50:48','2021-08-09 17:50:48'),(67,1,'Samsung Galaxy A51','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 17:51:18','2021-08-09 17:51:18'),(68,1,'Samsung Galaxy A21s','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 17:51:52','2021-08-09 17:51:52'),(69,1,'Samsung Galaxy A02s','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 17:52:19','2021-08-09 17:52:19'),(70,1,'Sumsung Galaxy S9','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 17:54:28','2021-08-09 17:54:28'),(71,1,'Samsung Galaxy S9 Plus','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 17:55:00','2021-08-09 17:55:00'),(72,1,'Samsung Galaxy S8','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 17:55:31','2021-08-09 17:55:31'),(73,1,'Samsung Galaxy M32','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 17:56:31','2021-08-10 18:26:06'),(74,1,'Samsung Galaxy Note 20 Ultra 5G','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 17:58:15','2021-08-09 17:58:15'),(75,1,'Samsung Galaxy S20','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 17:58:37','2021-08-09 17:58:37'),(76,1,'Samsung Galaxy A52s 5G','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 17:58:58','2021-08-09 17:58:58'),(77,1,'Samsung Galaxy S10','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 17:59:21','2021-08-09 17:59:21'),(78,1,'Samsung Galaxy S21+ 5G','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 17:59:53','2021-08-09 17:59:53'),(79,1,'Samsung Galaxy S10+','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:00:14','2021-08-09 18:00:14'),(80,1,'Samsung Galaxy A02','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:00:33','2021-08-09 18:00:33'),(81,1,'Samsung Galaxy A71','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:00:50','2021-08-09 18:00:50'),(82,1,'Samsung Galaxy M51','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:01:10','2021-08-09 18:01:10'),(83,1,'Samsung Galaxy F22','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:01:50','2021-08-09 18:01:50'),(84,1,'Samsung Galaxy Note10+','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:02:14','2021-08-09 18:02:14'),(85,1,'Samsung Galaxy J7 Prime','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:02:44','2021-08-09 18:02:44'),(86,1,'Samsung Galaxy A50','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:03:02','2021-08-09 18:03:02'),(87,1,'Samsung Galaxy Z Flod3 5G','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:03:37','2021-08-09 18:03:37'),(88,1,'Samsung Galaxy F62','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:04:09','2021-08-09 18:04:09'),(89,1,'Samsung Galaxy M12','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:04:26','2021-08-09 18:04:26'),(90,1,'Samsung Galaxy S7','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:04:51','2021-08-09 18:04:51'),(91,1,'Samsung Galaxy J7','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:05:14','2021-08-09 18:05:14'),(92,1,'Samsung Galaxy Tab A7 Lite','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,2,1,'2021-08-09 18:05:35','2021-08-09 18:05:35'),(93,1,'Samsung Galaxy A11','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:05:55','2021-08-09 18:05:55'),(94,1,'Samsung Galaxy Tab S7','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,2,1,'2021-08-09 18:06:18','2021-08-09 18:06:18'),(95,1,'Samsung Galaxy M31','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:06:44','2021-08-09 18:06:44'),(96,1,'Samsung Galaxy A31','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:07:05','2021-08-09 18:07:05'),(97,1,'Samsung Galaxy Note 9','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:07:30','2021-08-09 18:07:30'),(98,1,'Samsung Galaxy S7 Edge','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:07:57','2021-08-09 18:07:57'),(99,1,'Samsung Galaxy S20 Ultra 5G','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:08:23','2021-08-09 18:08:23'),(100,1,'Samsung Galaxy M62','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:08:56','2021-08-09 18:08:56'),(101,1,'Samsung Galaxy A20','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:09:16','2021-08-09 18:09:16'),(102,1,'Samsung Galaxy J5','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:11:28','2021-08-09 18:11:28'),(103,1,'Samsung Galaxy Note 10','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:11:45','2021-08-09 18:11:45'),(104,1,'Samsung Galaxy M42 5G','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:12:04','2021-08-09 18:12:04'),(105,1,'Samsung Galaxy F52 5G','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:12:51','2021-08-09 18:12:51'),(106,1,'Samsung F52 5G','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:13:11','2021-08-09 18:13:11'),(107,1,'Samsung Galaxy Note 20','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:13:28','2021-08-09 18:13:28'),(108,1,'Samsung Galaxy Note 8','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:13:56','2021-08-09 18:13:56'),(109,1,'Samsung Galaxy J2','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:14:14','2021-08-09 18:14:14'),(110,1,'Samsung Galaxy A70','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:14:33','2021-08-09 18:14:33'),(111,1,'Samsung Galaxy Tab S6','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,2,1,'2021-08-09 18:15:11','2021-08-09 18:15:11'),(112,1,'Samsung Galaxy A10s','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:15:30','2021-08-09 18:15:30'),(113,1,'Samsung Galaxy A10','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:15:54','2021-08-09 18:15:54'),(114,1,'Samsung Galaxy A42','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:16:30','2021-08-09 18:16:30'),(115,1,'Samsung Galaxy M11','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:17:53','2021-08-09 18:17:53'),(116,1,'Samsung Galaxy S20 Plus','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:18:23','2021-08-09 18:18:23'),(117,1,'Samsung Galaxy S6','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:18:45','2021-08-09 18:18:45'),(118,1,'Samsung Galaxy S6 Edge','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:19:21','2021-08-09 18:19:21'),(119,1,'Samsung Galaxy J5','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:24:56','2021-08-09 18:24:56'),(120,1,'Samsung Galaxy J1 Prime','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:26:03','2021-08-09 18:26:03'),(121,1,'Samsung Galaxy A7','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:26:29','2021-08-09 18:26:29'),(122,1,'Samsung Galaxy A5','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:26:44','2021-08-09 18:26:44'),(123,1,'Samsung Galaxy A3','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:26:58','2021-08-09 18:26:58'),(124,1,'Samsung Galaxy J2 Prime','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:27:27','2021-08-09 18:27:27'),(125,1,'Samsung Galaxy A8','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:27:48','2021-08-09 18:27:48'),(127,1,'Samsung Galaxy Note 5','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:39:24','2021-08-09 18:39:24'),(128,1,'Samsung Galaxy S6 edge+','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:39:48','2021-08-09 18:39:48'),(129,1,'Samsung Galaxy S4','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:40:07','2021-08-09 18:40:07'),(130,1,'Samsung Galaxy S3','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:40:24','2021-08-09 18:40:24'),(131,1,'Samsung Galaxy S3 Mini','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:40:43','2021-08-09 18:40:43'),(132,1,'Samsung Galaxy Grand Prime','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:41:30','2021-08-09 18:41:30'),(133,1,'Samsung Galaxy Core Prime','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:41:55','2021-08-09 18:41:55'),(134,1,'Samsung Galaxy Note 4','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:42:25','2021-08-09 18:42:25'),(135,1,'Samsung Galaxy S5','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:42:57','2021-08-09 18:42:57'),(136,1,'Samsung Galaxy Star','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:44:26','2021-08-09 19:17:13'),(137,1,'Samsung Galaxy Note 3','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:44:47','2021-08-09 18:44:47'),(138,1,'Samsung Galaxy Grand  Neo','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:45:14','2021-08-09 18:45:14'),(139,1,'Samsung Galaxy S Duos','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:45:45','2021-08-09 18:45:45'),(140,1,'Samsung Galaxy Grand 2','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-09 18:46:10','2021-08-09 18:46:10'),(141,1,'Poco X3 GT','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 18:50:29','2021-08-10 18:48:35'),(142,1,'Poco F3 GT','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 18:50:51','2021-08-09 18:50:51'),(143,1,'Redmi Note 10T 5G','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 18:51:16','2021-08-09 18:51:16'),(144,1,'Redmi Note 10 Pro','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 18:51:46','2021-08-09 18:51:46'),(145,1,'Redmi Note 8','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 18:52:04','2021-08-09 18:52:04'),(146,1,'Poco M3 Pro','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 18:52:45','2021-08-09 18:52:45'),(147,1,'Redmi Note 10','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 18:55:02','2021-08-09 18:55:02'),(148,1,'Mi 11 Lite','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 18:55:19','2021-08-09 18:55:19'),(149,1,'Redmi Note 9T','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 18:55:53','2021-08-09 18:55:53'),(150,1,'Mi 11','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 18:56:08','2021-08-09 18:56:08'),(151,1,'Poco M3','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 18:56:34','2021-08-09 18:56:34'),(152,1,'Mi 10T Lite','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 18:57:33','2021-08-09 18:57:33'),(153,1,'Redmi 9C','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 18:58:49','2021-08-09 18:58:49'),(154,1,'Redmi 9A','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 18:59:12','2021-08-09 18:59:12'),(155,1,'Mi Note 10 Lite','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 18:59:35','2021-08-09 18:59:35'),(156,1,'Redmi Note 9 Pro','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 19:00:07','2021-08-09 19:00:07'),(157,1,'Redmi Note 9','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 19:00:27','2021-08-09 19:00:27'),(158,1,'Redmi Note 9s','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 19:01:07','2021-08-09 19:01:07'),(159,1,'Mi 10','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 19:01:31','2021-08-09 19:01:31'),(160,1,'Mi Note 10','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 19:01:47','2021-08-09 19:01:47'),(161,1,'Mi 9 Lite','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 19:02:03','2021-08-09 19:02:03'),(162,1,'Redmi Note 8 Pro','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 19:02:25','2021-08-09 19:02:25'),(163,1,'Redmi 8','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 19:03:20','2021-08-09 19:03:20'),(164,1,'Mi 9T','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 19:03:36','2021-08-09 19:03:36'),(165,1,'Redmi 7A','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 19:04:06','2021-08-09 19:04:06'),(166,1,'Redmi Note 7','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 19:04:31','2021-08-09 19:04:31'),(167,1,'Mi A3','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 19:05:56','2021-08-09 19:05:56'),(168,1,'Mi 9T Pro','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 19:07:24','2021-08-09 19:07:24'),(169,1,'Redmi 7','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 19:07:40','2021-08-09 19:07:40'),(170,1,'Redmi Go','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 19:07:55','2021-08-09 19:07:55'),(171,1,'Mi Mix 3','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 19:08:13','2021-08-09 19:08:13'),(172,1,'Mi 9','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 19:08:27','2021-08-09 19:08:27'),(173,1,'Mi 8 Lite','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 19:08:50','2021-08-09 19:08:50'),(174,1,'Mi 8 Pro','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 19:09:06','2021-08-09 19:09:06'),(175,1,'Redmi Note 6 Pro','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 19:09:25','2021-08-09 19:09:25'),(176,1,'F1','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 19:09:54','2021-08-09 19:09:54'),(177,1,'Mi A2','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 19:10:07','2021-08-09 19:10:07'),(178,1,'Mi 8','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 19:10:21','2021-08-09 19:10:21'),(179,1,'Mi A2','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 19:10:47','2021-08-09 19:10:47'),(180,1,'Redmi S2','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 19:12:01','2021-08-09 19:12:01'),(181,1,'Redmi 6','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 19:12:14','2021-08-09 19:12:14'),(182,1,'Redmi Note 5','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 19:12:42','2021-08-09 19:12:42'),(183,1,'Mi A1','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 19:12:56','2021-08-09 19:12:56'),(184,1,'Redmi Note 5A','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 19:13:43','2021-08-09 19:13:43'),(185,1,'Redmi Note 4X','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 19:14:06','2021-08-09 19:14:06'),(186,1,'Mi 5x','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 19:14:34','2021-08-09 19:14:34'),(187,1,'Redmi 3s','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 19:14:50','2021-08-09 19:14:50'),(188,1,'Mi Note 3','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,1,'2021-08-09 19:15:09','2021-08-09 19:15:09'),(189,1,'Mi 6','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 19:15:36','2021-08-09 19:15:36'),(190,1,'Mi 5','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 19:15:57','2021-08-09 19:15:57'),(191,1,'Redmi Note 4','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 19:16:19','2021-08-09 19:16:19'),(192,1,'Redmi Note 2','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 19:16:40','2021-08-09 19:16:40'),(193,1,'Redmi Note 3','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,1,'2021-08-09 19:16:54','2021-08-09 19:16:54'),(194,1,'OPPO Reno 6','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:18:20','2021-08-09 19:18:20'),(195,1,'OPPO A94','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:18:48','2021-08-10 18:48:07'),(196,1,'OPPO A74','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:19:06','2021-08-09 19:19:06'),(197,1,'OPPO A54','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:19:47','2021-08-09 19:19:47'),(198,1,'OPPO A15s','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:20:21','2021-08-09 19:20:21'),(199,1,'OPPO A15','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:20:35','2021-08-10 20:00:24'),(200,1,'OPPO A73','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:21:05','2021-08-09 19:21:05'),(201,1,'OPPO A53','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:21:30','2021-08-09 19:21:30'),(202,1,'OPPO A93','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:21:49','2021-08-09 19:21:49'),(203,1,'OPPO Reno 4','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:22:08','2021-08-09 19:22:08'),(204,1,'OPPO Find X2','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:22:25','2021-08-09 19:22:25'),(205,1,'OPPO A12','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:22:58','2021-08-09 19:22:58'),(206,1,'OPPO A92','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:23:14','2021-08-09 19:23:14'),(207,1,'OPPO Reno 3','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:23:43','2021-08-09 19:23:43'),(208,1,'OPPO A72','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:24:11','2021-08-09 19:24:11'),(209,1,'OPPO A52','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:24:32','2021-08-09 19:24:32'),(210,1,'OPPO A31','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:24:45','2021-08-10 18:49:25'),(211,1,'OPPO F15','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:25:00','2021-08-09 19:25:00'),(212,1,'OPPO Reno 2','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:25:19','2021-08-09 19:25:19'),(213,1,'OPPO A9','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:25:38','2021-08-10 20:00:35'),(214,1,'OPPO A5','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:26:07','2021-08-09 19:26:07'),(215,1,'OPPO Reno 10','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:26:31','2021-08-09 19:26:31'),(216,1,'OPPO A1k','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:26:51','2021-08-09 19:26:51'),(217,1,'OPPO Reno','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:27:11','2021-08-09 19:27:11'),(218,1,'OPPO A5s','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:27:27','2021-08-09 19:27:27'),(219,1,'OPPO F11','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:27:48','2021-08-09 19:27:48'),(220,1,'OPPO A7','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:28:05','2021-08-09 19:28:05'),(221,1,'OPPO Find X','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:28:30','2021-08-09 19:28:30'),(222,1,'OPPO F9','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:29:19','2021-08-09 19:29:19'),(223,1,'OPPO A3s','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:29:37','2021-08-09 19:29:37'),(224,1,'OPPO R17','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:29:57','2021-08-09 19:29:57'),(225,1,'OPPO K1','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:30:15','2021-08-09 19:30:15'),(226,1,'OPPO F5','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:30:34','2021-08-09 19:30:34'),(227,1,'OPPO F7','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:30:48','2021-08-09 19:30:48'),(228,1,'OPPO A83','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:31:02','2021-08-09 19:31:02'),(229,1,'OPPO A71','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:31:21','2021-08-09 19:31:21'),(230,1,'Oppo R15','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:31:41','2021-08-10 20:00:41'),(231,1,'OPPO R11s Plus','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:32:02','2021-08-09 19:32:02'),(232,1,'OPPO R11s','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:37:32','2021-08-09 19:37:32'),(233,1,'OPPO A77','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:37:57','2021-08-09 19:37:57'),(234,1,'OPPO A57','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:38:16','2021-08-09 19:38:16'),(235,1,'OPPO F3','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:38:36','2021-08-09 19:38:36'),(236,1,'OPPO A37','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:39:01','2021-08-09 19:39:01'),(237,1,'OPPO F3 Plus','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:39:23','2021-08-09 19:39:23'),(238,1,'OPPO F1','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:39:39','2021-08-09 19:39:39'),(239,1,'OPPO Neo 5','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:40:00','2021-08-09 19:40:00'),(240,1,'OPPO Joy 3','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:40:28','2021-08-09 19:40:28'),(241,1,'OPPO Neo 7','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:40:50','2021-08-09 19:40:50'),(242,1,'OPPO F1 Plus','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:41:18','2021-08-09 19:41:18'),(243,1,'OPPO F1s','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,1,'2021-08-09 19:41:32','2021-08-09 19:41:32'),(244,1,'Realme 8','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',6,1,1,'2021-08-09 19:44:27','2021-08-09 19:44:27'),(245,1,'Realme C21','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',6,1,1,'2021-08-09 19:44:57','2021-08-09 19:44:57'),(246,1,'Realme C25','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',6,1,1,'2021-08-09 19:45:12','2021-08-09 19:45:12'),(247,1,'Realme 8 Pro','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',6,1,1,'2021-08-09 19:45:33','2021-08-09 19:45:33'),(248,1,'Relme GT','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',6,1,1,'2021-08-09 19:46:08','2021-08-09 19:46:08'),(249,1,'Realme C12','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',6,1,1,'2021-08-09 19:46:22','2021-08-09 19:46:22'),(250,1,'Realme 7i','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',6,1,1,'2021-08-09 19:46:45','2021-08-09 19:46:45'),(251,1,'Realme C17','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',6,1,1,'2021-08-09 19:47:05','2021-08-09 19:47:05'),(252,1,'Realme 7','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',6,1,1,'2021-08-09 19:47:16','2021-08-09 19:47:16'),(253,1,'Realme 7 Pro','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',6,1,1,'2021-08-09 19:47:37','2021-08-10 18:47:50'),(254,1,'Realme C15','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',6,1,1,'2021-08-09 19:47:57','2021-08-09 19:47:57'),(255,1,'Realme C11','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',6,1,1,'2021-08-09 19:48:13','2021-08-09 19:48:13'),(256,1,'Realme X3','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',6,1,1,'2021-08-09 19:48:34','2021-08-09 19:48:34'),(257,1,'Realme C3i','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',6,1,1,'2021-08-09 19:48:49','2021-08-10 20:00:48'),(258,1,'Realme 6 Pro','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',6,1,1,'2021-08-09 19:49:07','2021-08-09 19:49:07'),(259,1,'Realme 6','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',6,1,1,'2021-08-09 19:49:20','2021-08-09 19:49:20'),(260,1,'Realme 6i','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',6,1,1,'2021-08-09 19:49:35','2021-08-09 19:49:35'),(261,1,'Realme X2 Pro','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',6,1,1,'2021-08-09 19:49:49','2021-08-09 19:49:49'),(262,1,'Realme XT','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',6,1,1,'2021-08-09 19:50:04','2021-08-09 19:50:04'),(263,1,'Realme 5','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',6,1,1,'2021-08-09 19:50:19','2021-08-09 19:50:19'),(264,1,'Realme 5 Pro','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',6,1,1,'2021-08-09 19:50:30','2021-08-09 19:50:30'),(265,1,'Realme 3 Pro','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',6,1,1,'2021-08-09 19:50:44','2021-08-09 19:50:44'),(266,1,'Realme C2','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',6,1,1,'2021-08-09 19:50:58','2021-08-10 20:00:56'),(267,1,'Realme 3','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',6,1,1,'2021-08-09 19:51:10','2021-08-09 19:51:10'),(268,1,'Realme 2 Pro','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',6,1,1,'2021-08-09 19:51:25','2021-08-09 19:51:25'),(269,1,'Realme 2','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',6,1,1,'2021-08-09 19:51:42','2021-08-09 19:51:42'),(270,1,'Realme U1','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',6,1,1,'2021-08-09 19:51:55','2021-08-09 19:51:55'),(271,1,'Realme C1','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',6,1,1,'2021-08-09 19:52:08','2021-08-09 19:52:08'),(272,1,'Hot 10S','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,1,'2021-08-09 19:53:09','2021-08-09 19:53:09'),(273,1,'Note 10 Pro','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,1,'2021-08-09 19:53:28','2021-08-09 19:53:28'),(274,1,'Note 10','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,1,'2021-08-09 19:53:45','2021-08-09 19:53:45'),(275,1,'Smart HD 2021','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,1,'2021-08-09 19:54:22','2021-08-09 19:54:22'),(276,1,'Zero 8i','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,1,'2021-08-09 19:54:56','2021-08-09 19:54:56'),(277,1,'Note 8','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,1,'2021-08-09 19:55:11','2021-08-09 19:55:11'),(278,1,'Zero 8','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,1,'2021-08-09 19:55:32','2021-08-10 18:03:09'),(279,1,'Smart 5','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,1,'2021-08-09 19:56:03','2021-08-09 19:56:03'),(280,1,'Hot 9','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,1,'2021-08-09 19:56:30','2021-08-09 19:56:30'),(281,1,'Note 7','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,1,'2021-08-09 19:56:43','2021-08-10 20:01:03'),(282,1,'Note 7 Lite','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,1,'2021-08-09 19:57:02','2021-08-09 19:57:02'),(283,1,'S5 Pro','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,1,'2021-08-09 19:57:18','2021-08-09 19:57:18'),(284,1,'Smart 4','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,1,'2021-08-09 19:58:02','2021-08-09 19:58:02'),(285,1,'Hot 8','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,1,'2021-08-09 19:58:17','2021-08-09 19:58:17'),(286,1,'Smart 3 Plus','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,1,'2021-08-09 19:58:33','2021-08-09 19:58:33'),(287,1,'Hot 7 Pro','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,1,'2021-08-09 19:58:51','2021-08-09 19:58:51'),(288,1,'S4','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,1,'2021-08-09 19:59:02','2021-08-09 19:59:02'),(289,1,'Hot 7','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,1,'2021-08-09 19:59:20','2021-08-09 19:59:20'),(290,1,'Hot 6','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,1,'2021-08-09 19:59:45','2021-08-10 18:29:12'),(291,1,'Note 5','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,1,'2021-08-09 20:00:04','2021-08-09 20:00:04'),(292,1,'Smart 2','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,1,'2021-08-09 20:02:11','2021-08-09 20:02:11'),(293,1,'Hot S3','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,1,'2021-08-09 20:02:34','2021-08-09 20:02:34'),(294,1,'Smart 2 Pro','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,1,'2021-08-09 20:02:50','2021-08-10 18:46:21'),(295,1,'Hot 6 Pro','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,1,'2021-08-09 20:03:09','2021-08-09 20:03:09'),(296,1,'Hot Zero 5','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,1,'2021-08-09 20:03:30','2021-08-09 20:03:30'),(297,1,'Hot 5 Lite','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,1,'2021-08-09 20:03:52','2021-08-09 20:03:52'),(298,1,'Hot 5','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,1,'2021-08-09 20:04:05','2021-08-09 20:04:05'),(299,1,'Note 4 Pro','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,1,'2021-08-09 20:04:17','2021-08-09 20:04:17'),(300,1,'Note 4','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,1,'2021-08-09 20:04:34','2021-08-09 20:04:34'),(301,1,'Hot S2 Pro','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,1,'2021-08-09 20:04:51','2021-08-09 20:04:51'),(302,1,'Hot S2','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,1,'2021-08-09 20:05:06','2021-08-09 20:05:06'),(303,1,'Note 3 Pro','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,1,'2021-08-09 20:05:20','2021-08-09 20:05:20'),(304,1,'Note 3','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,1,'2021-08-09 20:05:38','2021-08-09 20:05:38'),(305,1,'Hot 4','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,1,'2021-08-09 20:05:50','2021-08-09 20:05:50'),(306,1,'Hot S','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,1,'2021-08-09 20:06:13','2021-08-09 20:06:13'),(307,1,'Zero 4 Plus','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,1,'2021-08-09 20:06:31','2021-08-09 20:06:31'),(308,1,'x655','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,1,'2021-08-09 20:07:00','2021-08-27 21:21:45'),(309,1,'Zero 3','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,1,'2021-08-09 20:07:10','2021-08-09 20:07:10'),(310,1,'Hot 3','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,1,'2021-08-09 20:07:32','2021-08-09 20:07:32'),(311,1,'Zero 2','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,1,'2021-08-09 20:07:45','2021-08-09 20:07:45'),(312,1,'Note 2','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,1,'2021-08-09 20:07:59','2021-08-09 20:07:59'),(313,1,'G20','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',10,1,1,'2021-08-09 20:15:48','2021-08-09 20:15:48'),(314,1,'Nokia 5.4','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',10,1,1,'2021-08-09 20:16:09','2021-08-09 20:16:09'),(315,1,'Nokia 8.3','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',10,1,1,'2021-08-09 20:16:28','2021-08-09 20:16:28'),(316,1,'Nokia 2.4','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',10,1,1,'2021-08-09 20:16:51','2021-08-09 20:16:51'),(317,1,'Nokia C3','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',10,1,1,'2021-08-09 20:17:11','2021-08-09 20:17:11'),(318,1,'Nokia 3.4','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',10,1,1,'2021-08-09 20:17:28','2021-08-09 20:17:28'),(319,1,'Nokia C2','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',10,1,1,'2021-08-09 20:17:44','2021-08-09 20:17:44'),(320,1,'Nokia 5.3','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',10,1,1,'2021-08-09 20:17:56','2021-08-09 20:17:56'),(321,1,'Nokia 2.3','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',10,1,1,'2021-08-09 20:18:11','2021-08-09 20:18:11'),(322,1,'Nokia 7.2','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',10,1,1,'2021-08-09 20:18:26','2021-08-09 20:18:26'),(323,1,'Nokia 6.2','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',10,1,1,'2021-08-09 20:18:40','2021-08-09 20:18:40'),(324,1,'Nokia 4.2','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',10,1,1,'2021-08-09 20:18:54','2021-08-09 20:18:54'),(325,1,'Nokia 3.2','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',10,1,1,'2021-08-09 20:19:08','2021-08-09 20:19:08'),(326,1,'Nokia 3.2','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',10,1,1,'2021-08-09 20:22:15','2021-08-09 20:22:15'),(327,1,'Nokia 1 Plus','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',10,1,1,'2021-08-09 20:22:32','2021-08-09 20:22:32'),(328,1,'Nokia 9','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',10,1,1,'2021-08-09 20:22:45','2021-08-09 20:22:45'),(329,1,'Nokia 8.1','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',10,1,1,'2021-08-09 20:23:00','2021-08-09 20:23:00'),(330,1,'Nokia 7.1','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',10,1,1,'2021-08-09 20:23:19','2021-08-09 20:23:19'),(331,1,'Nokia 6.1 Plus','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',10,1,1,'2021-08-09 20:23:49','2021-08-09 20:23:49'),(332,1,'Nokia 3.1 Plus','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',10,1,1,'2021-08-09 20:24:03','2021-08-09 20:24:03'),(333,1,'Nokia 5.1 Plus','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',10,1,1,'2021-08-09 20:24:21','2021-08-09 20:24:21'),(334,1,'Nokia 7 Plus','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',10,1,1,'2021-08-09 20:24:43','2021-08-09 20:24:43'),(335,1,'Nokia 2.1','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',10,1,1,'2021-08-09 20:24:56','2021-08-09 20:24:56'),(336,1,'Nokia 6.1','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',10,1,1,'2021-08-09 20:25:11','2021-08-09 20:25:11'),(337,1,'Nokia 3.1','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',10,1,1,'2021-08-09 20:25:27','2021-08-09 20:25:27'),(338,1,'Nokia 1','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',10,1,1,'2021-08-09 20:25:42','2021-08-09 20:25:42'),(339,1,'Nokia 6','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',10,1,1,'2021-08-09 20:25:55','2021-08-09 20:25:55'),(340,1,'Nokia 2','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',10,1,1,'2021-08-09 20:26:09','2021-08-09 20:26:09'),(341,1,'Nokia 5','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',10,1,1,'2021-08-09 20:26:27','2021-08-09 20:26:27'),(342,1,'Nokia 3','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',10,1,1,'2021-08-09 20:26:41','2021-08-09 20:26:41'),(343,1,'Nokia 8','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',10,1,1,'2021-08-09 20:26:52','2021-08-09 20:26:52'),(344,1,'Nokia 7','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',10,1,1,'2021-08-09 20:27:21','2021-08-09 20:27:21'),(345,1,'Nokia 9','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',10,1,1,'2021-08-09 20:27:44','2021-08-09 20:27:44'),(346,1,'Xperia 1 |||','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 20:29:51','2021-08-09 20:29:51'),(347,1,'Xperia 5 |||','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 20:30:11','2021-08-09 21:28:10'),(348,1,'Xperia 10 |||','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 20:30:27','2021-08-09 20:30:27'),(349,1,'Xperia Pro','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 20:30:41','2021-08-09 20:30:41'),(350,1,'Xperia 5 ||','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 20:30:59','2021-08-09 20:30:59'),(351,1,'Xperia 1 ||','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 20:31:14','2021-08-09 20:31:14'),(352,1,'Xperia 10 ||','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 20:31:32','2021-08-10 18:25:26'),(353,1,'Xpreia 10 ||','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 20:31:46','2021-08-09 20:31:46'),(354,1,'Xperia L4','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 20:32:05','2021-08-09 20:32:05'),(355,1,'Xperia 5','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 20:32:51','2021-08-09 20:32:51'),(356,1,'Xpreia 1','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 20:33:05','2021-08-10 18:48:45'),(357,1,'Xperia 10 Plus','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 20:33:29','2021-08-09 20:33:29'),(358,1,'Xperia 10','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 20:33:48','2021-08-10 18:24:54'),(359,1,'Xperia L3','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 20:34:02','2021-08-10 18:23:44'),(360,1,'Xperia XZ2','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 20:34:34','2021-08-09 20:34:34'),(361,1,'Xperia XA2','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 20:34:52','2021-08-09 20:34:52'),(362,1,'Xperia XA2 Ultra','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 20:35:14','2021-08-09 20:35:14'),(363,1,'Xpreia L2','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 20:35:30','2021-08-09 20:35:30'),(364,1,'Xperia L2','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 20:35:50','2021-08-09 20:35:50'),(365,1,'Xperia R1 (Plus)','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 20:36:08','2021-08-09 20:36:08'),(366,1,'Xperia XZ1','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 20:36:22','2021-08-09 20:36:22'),(367,1,'Xpreia XA1 Plus','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 20:36:53','2021-08-09 20:36:53'),(368,1,'Xperia XA1','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 20:37:15','2021-08-09 20:37:15'),(369,1,'Xperia XZ','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 20:37:28','2021-08-09 20:37:28'),(370,1,'Xperia L1','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 20:37:46','2021-08-09 20:37:46'),(371,1,'Xperia X Performance','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 20:38:40','2021-08-09 20:38:40'),(372,1,'Xperia XA Ultra','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 20:39:00','2021-08-09 20:39:00'),(373,1,'Xperia E5','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 20:39:37','2021-08-09 20:39:37'),(374,1,'Xperia X','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 20:39:57','2021-08-10 18:46:34'),(375,1,'Xperia XA','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 20:40:15','2021-08-09 20:40:15'),(376,1,'Xperia Z5','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 20:40:27','2021-08-09 20:40:27'),(377,1,'Xperia Z5','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 20:40:41','2021-08-09 20:40:41'),(378,1,'Xperia M5','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 20:40:55','2021-08-09 20:40:55'),(380,1,'Xperia C5','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 20:41:43','2021-08-09 20:41:43'),(381,1,'Xperia C4','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 20:42:05','2021-08-09 20:42:05'),(382,1,'Xperia M4','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 20:42:31','2021-08-09 20:42:31'),(383,1,'Xperia E3','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 21:26:00','2021-08-09 21:26:00'),(385,1,'Xperia Z3','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 21:26:35','2021-08-09 21:26:35'),(386,1,'Xperia M2','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 21:27:39','2021-08-09 21:28:17'),(387,1,'Xperia C3','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 21:28:41','2021-08-09 21:28:41'),(388,1,'Xperia Z2','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 21:28:58','2021-08-09 21:28:58'),(389,1,'Xperia T3','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 21:29:12','2021-08-09 21:29:12'),(390,1,'Xperia E1','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 21:29:25','2021-08-09 21:29:25'),(391,1,'Xperia Z2','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 21:29:39','2021-08-09 21:29:39'),(392,1,'Xperia Z1','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 21:29:54','2021-08-09 21:29:54'),(393,1,'Xperia Z1s','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 21:30:08','2021-08-09 21:30:08'),(394,1,'Xperia E1','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 21:30:24','2021-08-09 21:30:24'),(395,1,'Xperia Z','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 21:30:47','2021-08-09 21:30:47'),(396,1,'Xpeira C','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 21:31:47','2021-08-09 21:31:47'),(397,1,'Xperia M','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 21:32:06','2021-08-09 21:32:06'),(398,1,'Xperia ZR','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 21:32:22','2021-08-10 18:24:07'),(399,1,'Xperia SP','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 21:33:08','2021-08-09 21:33:08'),(400,1,'Xperia L','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 21:33:26','2021-08-10 18:23:54'),(401,1,'Xperia E1 ||','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',5,1,1,'2021-08-09 21:33:59','2021-08-09 21:33:59'),(402,1,'Huawei Y9a','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-09 22:28:14','2021-08-09 22:28:14'),(403,1,'Huawei Y7a','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 17:27:18','2021-08-10 17:27:18'),(404,1,'Huawei Mate 40 Pro','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 17:28:05','2021-08-10 17:28:05'),(405,1,'Huawei Nova 8','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 17:29:28','2021-08-10 17:29:28'),(406,1,'Huawei Nova 7','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 17:30:11','2021-08-10 17:30:11'),(407,1,'Huawei Y9a','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 17:30:38','2021-08-10 17:30:38'),(408,1,'Huawei Y5p','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 17:31:21','2021-08-10 17:31:21'),(409,1,'Huawei Y6p','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 17:32:09','2021-08-10 17:32:09'),(410,1,'Huawei Y8p','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 17:32:43','2021-08-10 17:32:43'),(411,1,'Huawei P40','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 17:33:31','2021-08-10 17:33:31'),(412,1,'Huawei P40 Pro','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 17:34:01','2021-08-10 17:34:01'),(413,1,'Huawei Y8s','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 17:34:34','2021-08-10 17:34:34'),(414,1,'Huawei Nova 5T','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 17:35:16','2021-08-10 17:35:16'),(415,1,'Huawei Nova Y7p','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 17:36:19','2021-08-10 17:36:19'),(416,1,'Huawei Y6s','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 17:37:23','2021-08-10 17:37:23'),(417,1,'Huawei Y9 Prime 2019','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 17:48:37','2021-08-10 17:48:37'),(418,1,'Huawei Mate 30 Pro','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 17:49:29','2021-08-10 17:49:29'),(419,1,'Huawei Y9s','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 17:50:04','2021-08-10 20:16:04'),(420,1,'Huawei P30 Pro','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 17:50:41','2021-08-10 17:50:41'),(421,1,'Huawei P30 Lite','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 17:51:03','2021-08-10 17:51:03'),(422,1,'Huawei Y5 2019','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 17:51:27','2021-08-10 17:51:27'),(423,1,'Huawei Mate 20 Pro','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 17:52:17','2021-08-10 17:52:17'),(424,1,'Huawei Mate 20','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 17:52:38','2021-08-10 17:52:38'),(425,1,'Huawei Y6 Prime 2019','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 17:53:16','2021-08-10 17:53:16'),(426,1,'Huawei Nova 5i','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 17:53:43','2021-08-10 17:53:43'),(427,1,'Huawei Nova 5','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 17:54:05','2021-08-10 17:54:05'),(428,1,'Huawei Nova 4','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 17:54:33','2021-08-10 17:54:33'),(429,1,'Huawei Mate 20 Lite','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 17:54:59','2021-08-10 17:54:59'),(430,1,'Huawei Nova 3i','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 17:55:27','2021-08-10 17:55:27'),(431,1,'Huawei Nova 3','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 17:56:41','2021-08-10 17:56:41'),(432,1,'Huawei P20 Lite','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 17:57:04','2021-08-10 17:57:04'),(433,1,'Huawei Y7 Prime 2018','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 17:57:30','2021-08-10 17:57:30'),(434,1,'Huawei Y5 Prime 2018','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 17:58:35','2021-08-10 17:58:35'),(435,1,'Huawei Y5 Prime 2018','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 17:59:25','2021-08-10 17:59:25'),(436,1,'Huawei Y9 Prime 2018','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 18:02:17','2021-08-10 18:02:17'),(437,1,'Huawei Y6 Prime 2018','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 18:02:49','2021-08-10 18:02:49'),(438,1,'Huawei P20 Pro','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 18:03:37','2021-08-10 18:03:37'),(439,1,'Huawei Mate 10 Lite','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 18:04:10','2021-08-10 18:04:10'),(440,1,'Huawei Mate 10 Pro','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 18:05:16','2021-08-10 18:05:16'),(441,1,'Huawei Y7 Prime','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 18:05:43','2021-08-10 18:05:43'),(442,1,'Huawei Y5 2017','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 18:06:09','2021-08-10 18:06:09'),(443,1,'Huawei Mate 10','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 18:06:51','2021-08-10 18:06:51'),(444,1,'Huawei Y7 Prime','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 18:07:52','2021-08-10 18:07:52'),(445,1,'Huawei Honor V10','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 18:08:52','2021-08-10 18:08:52'),(446,1,'Huawei Nova 2','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 18:09:11','2021-08-10 18:09:11'),(447,1,'Huawei Y3 2017','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 18:11:33','2021-08-10 18:11:33'),(448,1,'Huawei Honor 9','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 18:11:57','2021-08-10 18:11:57'),(449,1,'Huawei Y7','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 18:12:29','2021-08-10 18:12:29'),(450,1,'Huawei Y6 2017','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 18:12:52','2021-08-10 18:12:52'),(451,1,'Huawei P10 Plus','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 18:13:16','2021-08-10 18:13:16'),(452,1,'Huawei P10','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 18:13:36','2021-08-10 18:13:36'),(453,1,'Huawie P10 Lite','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 18:13:56','2021-08-10 18:13:56'),(454,1,'Huawie Nova Plus','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 18:14:40','2021-08-10 18:14:40'),(455,1,'Huawei Mate 9 Pro','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 18:15:04','2021-08-10 18:15:04'),(456,1,'Huawei Mate s','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 18:15:30','2021-08-10 18:15:30'),(457,1,'Huawei P8 Lite','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 18:15:55','2021-08-10 18:15:55'),(458,1,'Huawei Honor 5','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 18:16:18','2021-08-10 18:16:18'),(459,1,'Huawei Honor 8','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 18:16:50','2021-08-10 18:16:50'),(460,1,'Huawei Mate 9','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 18:17:28','2021-08-10 18:17:28'),(461,1,'Huawei P9','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 18:18:07','2021-08-10 18:18:07'),(462,1,'Huawei P9 Plus','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 18:22:35','2021-08-10 18:22:35'),(463,1,'Huawei GR5 2016','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,1,'2021-08-10 18:23:11','2021-08-10 18:23:11'),(464,1,'Honor 10X Lite','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',11,1,1,'2021-08-10 18:33:19','2021-08-10 18:33:19'),(465,1,'Honor 9C','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',11,1,1,'2021-08-10 18:33:36','2021-08-10 18:33:36'),(466,1,'Honor 9A','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',11,1,1,'2021-08-10 18:33:51','2021-08-10 18:33:51'),(467,1,'Honor 9X Lite','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',11,1,1,'2021-08-10 18:34:17','2021-08-10 18:34:17'),(468,1,'Honor 9X Pro','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',11,1,1,'2021-08-10 18:34:43','2021-08-10 18:34:43'),(469,1,'Honor 9X','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',11,1,1,'2021-08-10 18:34:59','2021-08-10 18:34:59'),(470,1,'Honor 20 Pro','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',11,1,1,'2021-08-10 18:35:29','2021-08-10 18:35:29'),(471,1,'Honor 8X Max','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',11,1,1,'2021-08-10 18:36:06','2021-08-10 18:36:06'),(472,1,'Honor 20','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',11,1,1,'2021-08-10 18:36:20','2021-08-10 18:36:20'),(473,1,'Honor 20 Lite','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',11,1,1,'2021-08-10 18:36:39','2021-08-10 18:36:39'),(474,1,'Honor 8A','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',11,1,1,'2021-08-10 18:37:05','2021-08-10 18:37:05'),(475,1,'Honor 8S','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',11,1,1,'2021-08-10 18:37:32','2021-08-10 18:37:32'),(476,1,'Honor 8C','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',11,1,1,'2021-08-10 18:37:53','2021-08-10 18:37:53'),(477,1,'Honor View 20','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',11,1,1,'2021-08-10 18:38:14','2021-08-10 18:38:14'),(478,1,'Honor 10 Lite','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',11,1,1,'2021-08-10 18:39:01','2021-08-10 18:39:01'),(479,1,'Honor 8X','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',11,1,1,'2021-08-10 18:39:19','2021-08-10 18:39:19'),(480,1,'Honor Play','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',11,1,1,'2021-08-10 18:39:46','2021-08-10 18:39:46'),(481,1,'Honor 10','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',11,1,1,'2021-08-10 18:40:02','2021-08-10 18:40:02'),(482,1,'Honor 7S','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',11,1,1,'2021-08-10 18:40:16','2021-08-10 18:40:16'),(483,1,'Honor 7X','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',11,1,1,'2021-08-10 18:40:43','2021-08-10 18:50:31'),(484,1,'Honor 7C','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',11,1,1,'2021-08-10 18:41:01','2021-08-10 18:41:01'),(485,1,'Honor 7C','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',11,1,1,'2021-08-10 18:41:22','2021-08-10 18:41:22'),(486,1,'Honor 9 Lite','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',11,1,1,'2021-08-10 18:41:45','2021-08-10 18:41:45'),(487,1,'820','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',4,1,1,'2021-08-10 19:52:48','2021-08-10 19:52:48'),(488,1,'816','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',4,1,1,'2021-08-10 19:53:03','2021-08-10 19:53:03'),(489,1,'728','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',4,1,1,'2021-08-10 19:53:24','2021-08-10 19:53:24'),(490,1,'828','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',4,1,1,'2021-08-10 19:53:41','2021-08-10 19:53:41'),(491,1,'620','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',4,1,1,'2021-08-10 19:53:58','2021-08-10 19:53:58'),(492,1,'M10','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',4,1,1,'2021-08-10 19:54:17','2021-08-10 19:54:17'),(493,1,'M8','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',4,1,1,'2021-08-10 19:54:34','2021-08-10 19:54:34'),(494,1,'M9','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',4,1,1,'2021-08-10 19:55:11','2021-08-10 19:55:11'),(495,1,'D10','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',4,1,1,'2021-08-10 19:55:30','2021-08-10 19:55:30'),(496,1,'U Play','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',4,1,1,'2021-08-10 19:55:49','2021-08-10 19:55:49'),(497,1,'U Ultra','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',4,1,1,'2021-08-10 19:56:13','2021-08-10 19:56:13'),(498,1,'T1','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,2,1,'2021-08-10 19:57:56','2021-08-10 19:57:56'),(499,1,'T2','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,2,1,'2021-08-10 19:58:11','2021-08-10 20:02:01'),(500,1,'T3','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,2,1,'2021-08-10 19:58:30','2021-08-10 19:58:30'),(501,1,'S7','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,2,1,'2021-08-10 19:58:46','2021-08-10 19:58:46'),(502,1,'T3-10','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,2,1,'2021-08-10 19:59:06','2021-08-10 19:59:06'),(503,1,'S8','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,2,1,'2021-08-10 19:59:26','2021-08-10 19:59:26'),(504,1,'Met Pad 10','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,2,1,'2021-08-10 20:00:04','2021-08-10 20:00:04'),(505,1,'T111','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,2,1,'2021-08-10 20:07:32','2021-08-10 20:07:32'),(506,1,'T113','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,2,1,'2021-08-10 20:07:50','2021-08-10 20:07:50'),(507,1,'T211','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,2,1,'2021-08-10 20:08:08','2021-08-10 20:08:08'),(508,1,'T231','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,2,1,'2021-08-10 20:08:28','2021-08-10 20:08:28'),(509,1,'T285','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,2,1,'2021-08-10 20:08:50','2021-08-10 20:08:50'),(510,1,'P1000','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,2,1,'2021-08-10 20:09:07','2021-08-10 20:09:07'),(511,1,'P3100','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,2,1,'2021-08-10 20:09:29','2021-08-10 20:09:29'),(512,1,'P5200','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,2,1,'2021-08-10 20:10:19','2021-08-10 20:10:19'),(513,1,'P601','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,2,1,'2021-08-10 20:10:37','2021-08-10 20:10:37'),(514,1,'T265','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,2,1,'2021-08-10 20:10:59','2021-08-10 20:10:59'),(515,1,'N 5100','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,2,1,'2021-08-10 20:11:31','2021-08-10 20:11:31'),(516,1,'T531','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,2,1,'2021-08-10 20:11:47','2021-08-10 20:11:47'),(517,1,'N 8000','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,2,1,'2021-08-10 20:12:44','2021-08-10 20:12:44'),(518,1,'T 295','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,2,1,'2021-08-10 20:13:04','2021-08-10 20:13:04'),(519,1,'A3000','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',12,2,1,'2021-08-10 20:19:58','2021-08-10 20:19:58'),(520,1,'A 3300','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',12,2,1,'2021-08-10 20:20:15','2021-08-10 20:20:15'),(521,1,'A 3500','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',12,2,1,'2021-08-10 20:20:35','2021-08-10 20:20:35'),(522,1,'A 5500','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',12,2,1,'2021-08-10 20:21:01','2021-08-10 20:21:01'),(523,1,'A 7600','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',12,2,1,'2021-08-10 20:21:28','2021-08-10 20:21:28'),(524,1,'Tap 2','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',12,2,1,'2021-08-10 20:22:27','2021-08-10 20:22:27'),(525,1,'Tap 3','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',12,2,1,'2021-08-10 20:22:42','2021-08-10 20:22:42'),(526,1,'Tap 4','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',12,2,1,'2021-08-10 20:23:03','2021-08-10 20:23:03'),(527,1,'Tap 3 - 730','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',12,2,1,'2021-08-10 20:23:25','2021-08-10 20:23:25'),(528,1,'PB1 750','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',12,2,1,'2021-08-10 20:23:48','2021-08-10 20:23:48'),(529,1,'PB1 770','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',12,2,1,'2021-08-10 20:24:07','2021-08-10 20:24:07'),(530,1,'A8','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',12,2,1,'2021-08-10 20:24:26','2021-08-10 20:24:26'),(531,1,'A 316','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',12,1,1,'2021-08-10 22:23:08','2021-08-10 22:23:08'),(532,1,'A 319','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',12,1,1,'2021-08-10 22:23:27','2021-08-10 22:23:27'),(533,1,'A 328','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',12,1,1,'2021-08-10 22:23:49','2021-08-10 22:23:49'),(534,1,'A 1000','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',12,1,1,'2021-08-10 22:24:21','2021-08-10 22:24:21'),(535,1,'A 2020','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',12,1,1,'2021-08-10 22:24:40','2021-08-10 22:24:40'),(536,1,'C1','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',12,1,1,'2021-08-10 22:24:55','2021-08-10 22:24:55'),(537,1,'A 5000','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',12,1,1,'2021-08-10 22:25:26','2021-08-10 22:25:26'),(538,1,'A 6000','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',12,1,1,'2021-08-10 22:25:43','2021-08-10 22:25:43'),(539,1,'A 7000','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',12,1,1,'2021-08-10 22:26:00','2021-08-10 22:26:00'),(540,1,'A 7010','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',12,1,1,'2021-08-10 22:26:21','2021-08-10 22:26:21'),(541,1,'A 7020','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',12,1,1,'2021-08-10 22:26:36','2021-08-10 22:26:36'),(542,1,'K6','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',12,1,1,'2021-08-10 22:26:56','2021-08-10 22:26:56'),(543,1,'K6 Note','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',12,1,1,'2021-08-10 22:27:17','2021-08-10 22:27:17'),(544,1,'K1 (c2)','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',12,1,1,'2021-08-10 22:27:39','2021-08-10 22:27:39'),(545,1,'P1','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',12,1,1,'2021-08-10 22:28:00','2021-08-10 22:28:00'),(546,1,'P1 M','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',12,1,1,'2021-08-10 22:28:19','2021-08-10 22:28:19'),(547,1,'P 70','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',12,1,1,'2021-08-10 22:28:39','2021-08-10 22:28:39'),(548,1,'S 60','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',12,1,1,'2021-08-10 22:28:53','2021-08-10 22:28:53'),(549,1,'S 90','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',12,1,1,'2021-08-10 22:29:12','2021-08-10 22:29:12'),(550,1,'K 8note','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',12,1,1,'2021-08-10 22:29:41','2021-08-10 22:29:41'),(551,1,'j6 - j600','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-21 15:17:27','2021-08-21 15:19:37'),(552,1,'J8 - J800','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-21 15:25:16','2021-08-21 15:25:40'),(553,1,'j7 pro','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-21 16:39:07','2021-08-21 16:39:07'),(554,1,'j8 plus','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-21 16:40:39','2021-08-21 16:40:39'),(555,1,'j6 plus','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-21 16:40:56','2021-08-21 16:40:56'),(556,1,'j1 ace','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,1,'2021-08-21 16:41:27','2021-08-21 16:41:27'),(557,1,'t2','\"Scratches,Broken Back,Broken Front,SIM&Memory,Battrey,Network,Touch,Screen,Back - Camera,Front - Camera,Portrait Mode,Flash,Wi-Fi,Bluetooth,Speaker,Earphone Port,Mic,Vibrator,Face ID,Charger Port,Finger Print\"',5,1,4,'2021-08-23 20:10:33','2021-08-23 20:10:33'),(558,1,'l1','\"Scratches,Broken Back,Broken Front,SIM&Memory,Battrey,Network,Touch,Screen,Back - Camera,Front - Camera,Portrait Mode,Flash,Wi-Fi,Bluetooth,Speaker,Earphone Port,Mic,Vibrator,Face ID,Charger Port,Finger Print\"',5,1,4,'2021-08-23 20:11:04','2021-08-23 20:11:04'),(559,1,'4c','\"Scratches,Broken Back,Broken Front,SIM&Memory,Battrey,Network,Touch,Screen,Back - Camera,Front - Camera,Portrait Mode,Flash,Wi-Fi,Bluetooth,Speaker,Earphone Port,Mic,Vibrator,Face ID,Charger Port,Finger Print\"',11,1,4,'2021-08-23 20:11:33','2021-08-23 20:11:33'),(560,1,'T2 ULTRA','\"Scratches,Broken Back,Broken Front,SIM&Memory,Battrey,Network,Touch,Screen,Back - Camera,Front - Camera,Portrait Mode,Flash,Wi-Fi,Bluetooth,Speaker,Earphone Port,Mic,Vibrator,Face ID,Charger Port,Finger Print\"',5,1,1,'2021-08-23 21:16:18','2021-08-23 21:16:18'),(561,1,'note 2','\"Scratches,Broken Back,Broken Front,SIM&Memory,Battrey,Network,Touch,Screen,Back - Camera,Front - Camera,Portrait Mode,Flash,Wi-Fi,Bluetooth,Speaker,Earphone Port,Mic,Vibrator,Face ID,Charger Port,Finger Print\"',2,1,4,'2021-08-24 12:34:00','2021-08-24 12:34:00'),(562,1,'note 1','\"Scratches,Broken Back,Broken Front,SIM&Memory,Battrey,Network,Touch,Screen,Back - Camera,Front - Camera,Portrait Mode,Flash,Wi-Fi,Bluetooth,Speaker,Earphone Port,Mic,Vibrator,Face ID,Charger Port,Finger Print\"',2,1,4,'2021-08-24 12:34:32','2021-08-24 12:34:32'),(563,1,'x557','\"Scratches,Broken Back,Broken Front,SIM&Memory,Battrey,Network,Touch,Screen,Back - Camera,Front - Camera,Portrait Mode,Flash,Wi-Fi,Bluetooth,Speaker,Earphone Port,Mic,Vibrator,Face ID,Charger Port,Finger Print\"',8,1,4,'2021-08-24 12:36:52','2021-08-24 12:36:52'),(564,1,'x556','\"Scratches,Broken Back,Broken Front,SIM&Memory,Battrey,Network,Touch,Screen,Back - Camera,Front - Camera,Portrait Mode,Flash,Wi-Fi,Bluetooth,Speaker,Earphone Port,Mic,Vibrator,Face ID,Charger Port,Finger Print\"',8,1,4,'2021-08-24 12:37:09','2021-08-24 12:37:09'),(565,1,'x559','\"Scratches,Broken Back,Broken Front,SIM&Memory,Battrey,Network,Touch,Screen,Back - Camera,Front - Camera,Portrait Mode,Flash,Wi-Fi,Bluetooth,Speaker,Earphone Port,Mic,Vibrator,Face ID,Charger Port,Finger Print\"',8,1,4,'2021-08-24 12:37:36','2021-08-24 12:37:36'),(566,1,'x626','\"Scratches,Broken Back,Broken Front,SIM&Memory,Battrey,Network,Touch,Screen,Back - Camera,Front - Camera,Portrait Mode,Flash,Wi-Fi,Bluetooth,Speaker,Earphone Port,Mic,Vibrator,Face ID,Charger Port,Finger Print\"',8,1,4,'2021-08-24 12:38:21','2021-08-24 12:38:21'),(567,1,'x608','\"Scratches,Broken Back,Broken Front,SIM&Memory,Battrey,Network,Touch,Screen,Back - Camera,Front - Camera,Portrait Mode,Flash,Wi-Fi,Bluetooth,Speaker,Earphone Port,Mic,Vibrator,Face ID,Charger Port,Finger Print\"',8,1,4,'2021-08-24 12:38:51','2021-08-24 12:38:51'),(568,1,'x625','\"Scratches,Broken Back,Broken Front,SIM&Memory,Battrey,Network,Touch,Screen,Back - Camera,Front - Camera,Portrait Mode,Flash,Wi-Fi,Bluetooth,Speaker,Earphone Port,Mic,Vibrator,Face ID,Charger Port,Finger Print\"',8,1,4,'2021-08-24 12:39:27','2021-08-24 12:39:27'),(569,1,'g530','\"Scratches,Broken Back,Broken Front,SIM&Memory,Battrey,Network,Touch,Screen,Back - Camera,Front - Camera,Portrait Mode,Flash,Wi-Fi,Bluetooth,Speaker,Earphone Port,Mic,Vibrator,Face ID,Charger Port,Finger Print\"',2,1,4,'2021-08-24 12:39:46','2021-08-24 12:39:46'),(570,1,'g531','\"Scratches,Broken Back,Broken Front,SIM&Memory,Battrey,Network,Touch,Screen,Back - Camera,Front - Camera,Portrait Mode,Flash,Wi-Fi,Bluetooth,Speaker,Earphone Port,Mic,Vibrator,Face ID,Charger Port,Finger Print\"',2,1,4,'2021-08-24 12:40:02','2021-08-24 12:40:02'),(571,1,'g532','\"Scratches,Broken Back,Broken Front,SIM&Memory,Battrey,Network,Touch,Screen,Back - Camera,Front - Camera,Portrait Mode,Flash,Wi-Fi,Bluetooth,Speaker,Earphone Port,Mic,Vibrator,Face ID,Charger Port,Finger Print\"',2,1,4,'2021-08-24 12:40:29','2021-08-24 12:40:29'),(572,1,'7102','\"Scratches,Broken Back,Broken Front,SIM&Memory,Battrey,Network,Touch,Screen,Back - Camera,Front - Camera,Portrait Mode,Flash,Wi-Fi,Bluetooth,Speaker,Earphone Port,Mic,Vibrator,Face ID,Charger Port,Finger Print\"',2,1,4,'2021-08-24 12:40:52','2021-08-24 12:40:52'),(573,1,'9060','\"Scratches,Broken Back,Broken Front,SIM&Memory,Battrey,Network,Touch,Screen,Back - Camera,Front - Camera,Portrait Mode,Flash,Wi-Fi,Bluetooth,Speaker,Earphone Port,Mic,Vibrator,Face ID,Charger Port,Finger Print\"',2,1,4,'2021-08-24 12:41:13','2021-08-24 12:41:13'),(574,1,'s2','\"Scratches,Broken Back,Broken Front,SIM&Memory,Battrey,Network,Touch,Screen,Back - Camera,Front - Camera,Portrait Mode,Flash,Wi-Fi,Bluetooth,Speaker,Earphone Port,Mic,Vibrator,Face ID,Charger Port,Finger Print\"',2,1,4,'2021-08-24 12:42:46','2021-08-24 12:42:46'),(575,1,'g610','\"Scratches,Broken Back,Broken Front,SIM&Memory,Battrey,Network,Touch,Screen,Back - Camera,Front - Camera,Portrait Mode,Flash,Wi-Fi,Bluetooth,Speaker,Earphone Port,Mic,Vibrator,Face ID,Charger Port,Finger Print\"',2,1,4,'2021-08-24 12:44:18','2021-08-24 12:44:18'),(576,1,'g611','\"Scratches,Broken Back,Broken Front,SIM&Memory,Battrey,Network,Touch,Screen,Back - Camera,Front - Camera,Portrait Mode,Flash,Wi-Fi,Bluetooth,Speaker,Earphone Port,Mic,Vibrator,Face ID,Charger Port,Finger Print\"',2,1,4,'2021-08-24 12:44:37','2021-08-24 12:44:37'),(577,1,'g570','\"Scratches,Broken Back,Broken Front,SIM&Memory,Battrey,Network,Touch,Screen,Back - Camera,Front - Camera,Portrait Mode,Flash,Wi-Fi,Bluetooth,Speaker,Earphone Port,Mic,Vibrator,Face ID,Charger Port,Finger Print\"',2,1,4,'2021-08-24 12:47:05','2021-08-24 12:47:05'),(578,1,'j730','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,4,'2021-08-24 12:47:33','2021-08-24 15:00:16'),(579,1,'j530','\"Scratches,Broken Back,Broken Front,SIM&Memory,Battrey,Network,Touch,Screen,Back - Camera,Front - Camera,Portrait Mode,Flash,Wi-Fi,Bluetooth,Speaker,Earphone Port,Mic,Vibrator,Face ID,Charger Port,Finger Print\"',2,1,4,'2021-08-24 12:47:48','2021-08-24 12:47:48'),(581,1,'f11 pro','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,4,'2021-08-24 15:21:02','2021-08-24 15:21:02'),(582,1,'reno 2f','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,4,'2021-08-24 15:22:23','2021-08-24 15:22:23'),(583,1,'reno 5','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,4,'2021-08-24 15:23:22','2021-08-24 15:23:22'),(584,1,'f1','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,4,'2021-08-24 15:25:59','2021-08-24 15:25:59'),(585,1,'526','\"Scratches,Broken Back,Broken Front,SIM&Memory,Battrey,Network,Touch,Screen,Back - Camera,Front - Camera,Portrait Mode,Flash,Wi-Fi,Bluetooth,Speaker,Earphone Port,Mic,Vibrator,Face ID,Charger Port,Finger Print\"',4,1,4,'2021-08-24 17:05:53','2021-08-24 17:05:53'),(586,1,'T585','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,2,4,'2021-08-24 17:19:50','2021-08-24 17:19:50'),(587,1,'A5 2020','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',3,1,4,'2021-08-24 17:20:39','2021-08-24 17:20:39'),(588,1,'X5010','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,4,'2021-08-24 18:24:40','2021-08-24 18:24:40'),(589,1,'A20S','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,4,'2021-08-24 18:50:11','2021-08-24 18:50:11'),(590,1,'tb 7305i','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',12,2,4,'2021-08-24 19:21:35','2021-08-24 19:21:35'),(591,1,'t805','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,2,4,'2021-08-24 21:41:30','2021-08-24 21:41:30'),(592,1,'7262','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,4,'2021-08-25 14:18:01','2021-08-25 14:18:01'),(593,1,'y9 2019','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,4,'2021-08-25 20:14:39','2021-08-25 20:14:39'),(594,1,'note 7','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,4,'2021-08-26 14:06:36','2021-08-26 14:06:36'),(595,1,'gr5 2017','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,4,'2021-08-28 15:54:02','2021-08-28 15:54:02'),(596,1,'y6 pro','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,4,'2021-08-28 21:05:22','2021-08-28 21:05:22'),(597,1,'redmei 5','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,4,'2021-08-29 20:06:34','2021-08-29 20:06:34'),(598,1,'me 10t','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,4,'2021-08-30 17:54:01','2021-08-30 17:54:01'),(599,1,'A1000','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',12,1,4,'2021-08-31 18:53:40','2021-08-31 18:53:40'),(600,1,'t531','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,2,4,'2021-09-01 14:40:52','2021-09-01 14:40:52'),(601,1,'t210','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,4,'2021-09-01 14:41:10','2021-09-01 14:41:10'),(602,1,'REDMI NOTE 5A PRIME','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,4,'2021-09-01 15:09:03','2021-09-01 15:09:03'),(603,1,'x606','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',8,1,4,'2021-09-01 15:34:27','2021-09-01 15:34:27'),(604,1,'J4 plus','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,4,'2021-09-01 15:56:50','2021-09-01 15:56:50'),(605,1,'redmi 7','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,4,'2021-09-01 22:41:02','2021-09-01 22:41:02'),(606,1,'Tab E','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,2,4,'2021-09-02 22:37:18','2021-09-02 22:37:18'),(607,1,'ipad 5','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',1,2,4,'2021-09-04 17:42:53','2021-09-04 17:42:53'),(608,1,'nova 7i','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,4,'2021-09-05 16:22:57','2021-09-05 16:22:57'),(609,1,'a2020','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',12,1,4,'2021-09-06 14:04:10','2021-09-06 14:04:10'),(610,1,'j320','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,4,'2021-09-07 17:03:23','2021-09-07 17:03:23'),(611,1,'a30','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,4,'2021-09-09 16:50:00','2021-09-09 16:50:00'),(612,1,'moto z play','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',13,1,4,'2021-09-12 17:03:20','2021-09-12 17:03:20'),(613,1,'Y7 2019','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,4,'2021-09-12 22:55:26','2021-09-12 22:55:39'),(614,1,'NOVA 2 PLUS','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,4,'2021-09-13 16:58:13','2021-09-13 16:58:13'),(615,1,'J4','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',2,1,4,'2021-09-13 18:22:27','2021-09-13 18:22:27'),(616,1,'a2 lite','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',NULL,NULL,4,'2021-09-14 13:00:01','2021-09-14 13:00:01'),(617,1,'mate 7','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,4,'2021-09-14 19:20:30','2021-09-14 19:20:30'),(618,1,'redmi 9','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',7,1,4,'2021-09-14 21:45:09','2021-09-14 21:45:09'),(619,1,'mi 11 t pro',NULL,7,1,1,'2021-09-16 17:15:56','2021-09-16 17:15:56'),(623,1,'g8','\"Scratches|Broken Back|Broken Front|SIM&Memory|Battrey|Network|Touch|Screen|Back - Camera|Front - Camera|Portrait Mode|Flash|Wi-Fi|Bluetooth|Speaker|Earphone Port|Mic|Vibrator|Face ID|Charger Port|Finger Print\"',9,1,11,'2021-09-18 16:14:39','2021-09-18 16:14:39'),(624,1,'e4',NULL,13,1,11,'2021-09-18 21:36:44','2021-09-18 21:36:44'),(625,1,'GLAXAY ACE NXT',NULL,2,1,4,'2021-09-19 20:00:18','2021-09-19 20:00:18'),(626,1,'NOTE 10 PLUS',NULL,2,1,4,'2021-09-19 21:46:18','2021-09-19 21:46:18'),(627,1,'phap',NULL,12,2,4,'2021-09-20 20:09:27','2021-09-20 20:09:27'),(628,1,'p30',NULL,9,1,4,'2021-09-20 20:37:32','2021-09-20 20:37:32'),(629,1,'5.1',NULL,10,1,11,'2021-09-22 13:57:39','2021-09-22 13:57:39'),(630,1,'TAB A',NULL,2,2,4,'2021-09-22 21:14:42','2021-09-22 21:14:42'),(631,1,'a6000',NULL,12,1,11,'2021-09-23 12:49:26','2021-09-23 12:49:26'),(632,1,'A3300',NULL,12,2,11,'2021-09-23 14:54:47','2021-09-23 14:54:47'),(633,1,'k8 plus',NULL,12,1,11,'2021-09-23 17:11:55','2021-09-23 17:11:55'),(634,1,'P2',NULL,12,1,11,'2021-09-23 19:33:20','2021-09-23 19:33:20'),(635,1,'galaxy WIN',NULL,2,1,11,'2021-09-28 13:36:26','2021-09-28 13:36:26'),(636,1,'A30s',NULL,2,1,11,'2021-09-28 14:15:58','2021-09-28 14:15:58'),(637,1,'Y7 2017',NULL,9,1,19,'2021-09-28 14:40:22','2021-09-28 14:40:22'),(638,1,'Y6 II',NULL,9,1,19,'2021-09-28 18:39:18','2021-09-28 18:39:18'),(639,1,'Y7 Prim 2019',NULL,9,1,19,'2021-09-28 19:09:51','2021-09-28 19:09:51'),(640,1,'y3c',NULL,2,1,11,'2021-09-29 13:42:11','2021-09-29 13:42:11'),(641,1,'y3c',NULL,9,1,11,'2021-09-29 13:42:55','2021-09-29 13:42:55');
/*!40000 ALTER TABLE `repair_device_models` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `repair_job_sheets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `repair_job_sheets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned DEFAULT NULL,
  `contact_id` int(10) unsigned NOT NULL,
  `job_sheet_no` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `service_type` enum('carry_in','pick_up','on_site') COLLATE utf8mb4_unicode_ci NOT NULL,
  `pick_up_on_site_addr` text COLLATE utf8mb4_unicode_ci,
  `brand_id` int(10) unsigned DEFAULT NULL,
  `device_id` int(10) unsigned DEFAULT NULL,
  `device_model_id` int(10) unsigned DEFAULT NULL,
  `checklist` text COLLATE utf8mb4_unicode_ci,
  `security_pwd` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `security_pattern` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `serial_no` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status_id` int(11) NOT NULL,
  `delivery_date` datetime DEFAULT NULL,
  `product_configuration` text COLLATE utf8mb4_unicode_ci,
  `defects` text COLLATE utf8mb4_unicode_ci,
  `product_condition` text COLLATE utf8mb4_unicode_ci,
  `service_staff` int(10) unsigned DEFAULT NULL,
  `comment_by_ss` text COLLATE utf8mb4_unicode_ci COMMENT 'comment made by technician',
  `estimated_cost` decimal(22,4) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `custom_field_1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field_2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field_3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field_4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field_5` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `repair_job_sheets_business_id_foreign` (`business_id`) USING BTREE,
  KEY `repair_job_sheets_contact_id_foreign` (`contact_id`) USING BTREE,
  KEY `repair_job_sheets_brand_id_foreign` (`brand_id`) USING BTREE,
  KEY `repair_job_sheets_device_id_foreign` (`device_id`) USING BTREE,
  KEY `repair_job_sheets_device_model_id_foreign` (`device_model_id`) USING BTREE,
  KEY `repair_job_sheets_service_staff_foreign` (`service_staff`) USING BTREE,
  KEY `repair_job_sheets_created_by_foreign` (`created_by`) USING BTREE,
  CONSTRAINT `repair_job_sheets_brand_id_foreign` FOREIGN KEY (`brand_id`) REFERENCES `brands` (`id`),
  CONSTRAINT `repair_job_sheets_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `repair_job_sheets_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `repair_job_sheets_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `repair_job_sheets_device_id_foreign` FOREIGN KEY (`device_id`) REFERENCES `categories` (`id`),
  CONSTRAINT `repair_job_sheets_device_model_id_foreign` FOREIGN KEY (`device_model_id`) REFERENCES `repair_device_models` (`id`),
  CONSTRAINT `repair_job_sheets_service_staff_foreign` FOREIGN KEY (`service_staff`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=679 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `repair_job_sheets` WRITE;
/*!40000 ALTER TABLE `repair_job_sheets` DISABLE KEYS */;
INSERT INTO `repair_job_sheets` VALUES (29,1,1,16,'2021/0029','carry_in',NULL,2,1,110,'{\"Scratches\":\"yes\",\"Broken Back\":\"no\",\"Broken Front\":\"no\",\"SIM&Memory\":\"not_applicable\",\"Battrey\":\"not_applicable\",\"Network\":\"not_applicable\",\"Touch\":\"not_applicable\",\"Screen\":\"not_applicable\",\"Back - Camera\":\"yes\",\"Front - Camera\":\"not_applicable\",\"Portrait Mode\":\"not_applicable\",\"Flash\":\"not_applicable\",\"Wi-Fi\":\"not_applicable\",\"Bluetooth\":\"not_applicable\",\"Speaker\":\"not_applicable\",\"Earphone Port\":\"not_applicable\",\"Mic\":\"not_applicable\",\"Vibrator\":\"not_applicable\",\"Face ID\":\"not_applicable\",\"Charger Port\":\"yes\",\"Finger Print\":\"yes\"}',NULL,NULL,'357473104247539',10,NULL,NULL,'[{\"value\":\"شبكه\"},{\"value\":\"تعرض لماء\"}]',NULL,NULL,NULL,300.0000,11,NULL,NULL,NULL,NULL,NULL,'2021-08-22 14:24:50','2021-08-23 20:19:09'),(30,1,1,17,'2021/0030','carry_in',NULL,3,1,227,'{\"Scratches\":\"yes\",\"Broken Back\":\"no\",\"Broken Front\":\"no\",\"SIM&Memory\":\"not_applicable\",\"Battrey\":\"yes\",\"Network\":\"not_applicable\",\"Touch\":\"not_applicable\",\"Screen\":\"not_applicable\",\"Back - Camera\":\"not_applicable\",\"Front - Camera\":\"not_applicable\",\"Portrait Mode\":\"not_applicable\",\"Flash\":\"not_applicable\",\"Wi-Fi\":\"not_applicable\",\"Bluetooth\":\"not_applicable\",\"Speaker\":\"yes\",\"Earphone Port\":\"not_applicable\",\"Mic\":\"not_applicable\",\"Vibrator\":\"yes\",\"Face ID\":\"not_applicable\",\"Charger Port\":\"yes\",\"Finger Print\":\"not_applicable\"}','102030',NULL,'123456789789',10,'2021-08-25 20:28:00',NULL,'[{\"value\":\"اضاءه\"}]',NULL,NULL,NULL,400.0000,11,NULL,NULL,NULL,NULL,NULL,'2021-08-22 14:34:15','2021-08-25 15:22:32'),(31,1,1,18,'2021/0031','carry_in',NULL,1,1,5,'{\"Scratches\":\"yes\",\"Broken Back\":\"not_applicable\",\"Broken Front\":\"no\",\"SIM&Memory\":\"not_applicable\",\"Battrey\":\"yes\",\"Network\":\"no\",\"Touch\":\"not_applicable\",\"Screen\":\"yes\",\"Back - Camera\":\"yes\",\"Front - Camera\":\"yes\",\"Flash\":\"yes\",\"Wi-Fi\":\"not_applicable\",\"Bluetooth\":\"yes\",\"Speaker\":\"yes\",\"Earphone Port\":\"not_applicable\",\"Mic\":\"not_applicable\",\"Vibrator\":\"yes\",\"Finger Print\":\"no\",\"Charger Port\":\"yes\"}',NULL,NULL,'354436063979155',10,NULL,NULL,'[{\"value\":\"لا يوجد شبكه كشف شبكه\"}]',NULL,NULL,NULL,0.0000,11,NULL,NULL,NULL,NULL,NULL,'2021-08-22 14:47:36','2021-08-23 21:48:42'),(32,1,1,19,'2021/0032','carry_in',NULL,10,1,334,'{\"Scratches\":\"yes\",\"Broken Back\":\"not_applicable\",\"Broken Front\":\"yes\",\"SIM&Memory\":\"not_applicable\",\"Battrey\":\"not_applicable\",\"Network\":\"not_applicable\",\"Touch\":\"not_applicable\",\"Screen\":\"not_applicable\",\"Back - Camera\":\"not_applicable\",\"Front - Camera\":\"not_applicable\",\"Portrait Mode\":\"not_applicable\",\"Flash\":\"not_applicable\",\"Wi-Fi\":\"not_applicable\",\"Bluetooth\":\"not_applicable\",\"Speaker\":\"not_applicable\",\"Earphone Port\":\"not_applicable\",\"Mic\":\"not_applicable\",\"Vibrator\":\"not_applicable\",\"Face ID\":\"not_applicable\",\"Charger Port\":\"not_applicable\",\"Finger Print\":\"not_applicable\"}',NULL,NULL,'12345678999',10,'2021-08-22 17:32:00',NULL,'[{\"value\":\"فلاته شحن\"}]',NULL,NULL,NULL,350.0000,4,NULL,'3 month',NULL,NULL,NULL,'2021-08-22 17:29:42','2021-08-24 12:22:47'),(33,1,1,20,'2021/0033','carry_in',NULL,11,1,479,'{\"Scratches\":\"yes\",\"Broken Back\":\"no\",\"Broken Front\":\"no\",\"SIM&Memory\":\"not_applicable\",\"Battrey\":\"not_applicable\",\"Network\":\"yes\",\"Touch\":\"not_applicable\",\"Screen\":\"not_applicable\",\"Back - Camera\":\"yes\",\"Front - Camera\":\"not_applicable\",\"Portrait Mode\":\"not_applicable\",\"Flash\":\"not_applicable\",\"Wi-Fi\":\"not_applicable\",\"Bluetooth\":\"not_applicable\",\"Speaker\":\"yes\",\"Earphone Port\":\"not_applicable\",\"Mic\":\"not_applicable\",\"Vibrator\":\"yes\",\"Face ID\":\"not_applicable\",\"Charger Port\":\"yes\",\"Finger Print\":\"not_applicable\"}',NULL,NULL,'0000000000',10,'2021-08-22 18:17:00',NULL,NULL,NULL,NULL,NULL,400.0000,4,NULL,'3 month',NULL,NULL,NULL,'2021-08-22 18:13:19','2021-08-24 12:23:04'),(34,1,1,21,'2021/0034','carry_in',NULL,3,1,201,'{\"Scratches\":\"yes\",\"Broken Back\":\"not_applicable\",\"Broken Front\":\"not_applicable\",\"SIM&Memory\":\"no\",\"Battrey\":\"yes\",\"Network\":\"not_applicable\",\"Touch\":\"not_applicable\",\"Screen\":\"not_applicable\",\"Back - Camera\":\"not_applicable\",\"Front - Camera\":\"not_applicable\",\"Portrait Mode\":\"not_applicable\",\"Flash\":\"not_applicable\",\"Wi-Fi\":\"not_applicable\",\"Bluetooth\":\"not_applicable\",\"Speaker\":\"not_applicable\",\"Earphone Port\":\"not_applicable\",\"Mic\":\"not_applicable\",\"Vibrator\":\"not_applicable\",\"Face ID\":\"not_applicable\",\"Charger Port\":\"not_applicable\",\"Finger Print\":\"not_applicable\"}','262626',NULL,'523860',10,'2021-08-23 20:01:00',NULL,'[{\"value\":\"شاشة\"}]',NULL,8,NULL,650.0000,4,NULL,NULL,NULL,NULL,NULL,'2021-08-22 19:57:45','2021-08-23 22:13:56'),(35,1,1,22,'2021/0035','pick_up',NULL,2,1,97,'{\"Scratches\":\"yes\",\"Broken Back\":\"not_applicable\",\"Broken Front\":\"not_applicable\",\"SIM&Memory\":\"not_applicable\",\"Battrey\":\"not_applicable\",\"Network\":\"not_applicable\",\"Touch\":\"not_applicable\",\"Screen\":\"not_applicable\",\"Back - Camera\":\"not_applicable\",\"Front - Camera\":\"not_applicable\",\"Portrait Mode\":\"not_applicable\",\"Flash\":\"not_applicable\",\"Wi-Fi\":\"not_applicable\",\"Bluetooth\":\"not_applicable\",\"Speaker\":\"not_applicable\",\"Earphone Port\":\"not_applicable\",\"Mic\":\"not_applicable\",\"Vibrator\":\"not_applicable\",\"Face ID\":\"not_applicable\",\"Charger Port\":\"not_applicable\",\"Finger Print\":\"not_applicable\"}','1616',NULL,'352455100489129',10,'2021-08-25 21:11:00',NULL,'[{\"value\":\"باغه\"},{\"value\":\"ضهر\"}]',NULL,10,NULL,1850.0000,4,NULL,'3 شهور',NULL,NULL,NULL,'2021-08-22 21:09:05','2021-08-25 22:50:39'),(36,1,1,23,'2021/0036','pick_up',NULL,1,1,9,'{\"Scratches\":\"not_applicable\",\"Broken Back\":\"not_applicable\",\"Broken Front\":\"not_applicable\",\"SIM&Memory\":\"not_applicable\",\"Battrey\":\"not_applicable\",\"Network\":\"not_applicable\",\"Touch\":\"not_applicable\",\"Screen\":\"not_applicable\",\"Back - Camera\":\"not_applicable\",\"Front - Camera\":\"not_applicable\",\"Portrait Mode\":\"not_applicable\",\"Flash\":\"not_applicable\",\"Wi-Fi\":\"not_applicable\",\"Bluetooth\":\"not_applicable\",\"Speaker\":\"not_applicable\",\"Earphone Port\":\"not_applicable\",\"Mic\":\"not_applicable\",\"Vibrator\":\"not_applicable\",\"Finger Print\":\"not_applicable\",\"Charger Port\":\"not_applicable\"}','066666',NULL,'1784',10,'2021-08-23 22:07:00',NULL,'[{\"value\":\"شاشة\"}]',NULL,8,NULL,1300.0000,4,NULL,NULL,NULL,NULL,NULL,'2021-08-22 22:04:29','2021-08-29 16:29:20'),(37,1,1,24,'2021/0037','carry_in',NULL,2,1,108,'{\"Scratches\":\"not_applicable\",\"Broken Back\":\"not_applicable\",\"Broken Front\":\"not_applicable\",\"SIM&Memory\":\"not_applicable\",\"Battrey\":\"not_applicable\",\"Network\":\"yes\",\"Touch\":\"not_applicable\",\"Screen\":\"not_applicable\",\"Back - Camera\":\"not_applicable\",\"Front - Camera\":\"not_applicable\",\"Portrait Mode\":\"not_applicable\",\"Flash\":\"not_applicable\",\"Wi-Fi\":\"not_applicable\",\"Bluetooth\":\"yes\",\"Speaker\":\"not_applicable\",\"Earphone Port\":\"not_applicable\",\"Mic\":\"not_applicable\",\"Vibrator\":\"not_applicable\",\"Face ID\":\"not_applicable\",\"Charger Port\":\"not_applicable\",\"Finger Print\":\"not_applicable\"}','0841',NULL,'362008098657304',10,NULL,NULL,'[{\"value\":\"شبكه\"},{\"value\":\"بلتوث\"}]',NULL,7,NULL,400.0000,4,NULL,NULL,NULL,NULL,NULL,'2021-08-23 12:50:57','2021-08-23 22:02:33'),(38,1,1,25,'2021/0038','carry_in',NULL,7,1,184,'{\"Scratches\":\"yes\",\"Broken Back\":\"not_applicable\",\"Broken Front\":\"not_applicable\",\"SIM&Memory\":\"not_applicable\",\"Battrey\":\"not_applicable\",\"Network\":\"not_applicable\",\"Touch\":\"not_applicable\",\"Screen\":\"not_applicable\",\"Back - Camera\":\"not_applicable\",\"Front - Camera\":\"not_applicable\",\"Portrait Mode\":\"not_applicable\",\"Flash\":\"yes\",\"Wi-Fi\":\"not_applicable\",\"Bluetooth\":\"not_applicable\",\"Speaker\":\"not_applicable\",\"Earphone Port\":\"not_applicable\",\"Mic\":\"not_applicable\",\"Vibrator\":\"not_applicable\",\"Face ID\":\"not_applicable\",\"Charger Port\":\"not_applicable\",\"Finger Print\":\"not_applicable\"}','0',NULL,'00000',10,NULL,NULL,'[{\"value\":\"كشف باور\"}]',NULL,7,NULL,100.0000,4,NULL,NULL,NULL,NULL,NULL,'2021-08-23 13:19:51','2021-08-24 12:57:50'),(39,1,1,26,'2021/0039','carry_in',NULL,2,1,132,'{\"Scratches\":\"yes\",\"Broken Back\":\"yes\",\"Broken Front\":\"yes\",\"SIM&Memory\":\"not_applicable\",\"Battrey\":\"not_applicable\",\"Network\":\"not_applicable\",\"Touch\":\"not_applicable\",\"Screen\":\"not_applicable\",\"Back - Camera\":\"not_applicable\",\"Front - Camera\":\"not_applicable\",\"Portrait Mode\":\"not_applicable\",\"Flash\":\"not_applicable\",\"Wi-Fi\":\"not_applicable\",\"Bluetooth\":\"not_applicable\",\"Speaker\":\"not_applicable\",\"Earphone Port\":\"not_applicable\",\"Mic\":\"not_applicable\",\"Vibrator\":\"not_applicable\",\"Face ID\":\"not_applicable\",\"Charger Port\":\"not_applicable\",\"Finger Print\":\"not_applicable\"}',NULL,NULL,'356400079168441',10,'2021-08-23 14:48:00',NULL,NULL,NULL,NULL,NULL,200.0000,4,NULL,'3 month',NULL,NULL,NULL,'2021-08-23 14:45:51','2021-08-25 16:21:27'),(40,1,1,27,'2021/0040','carry_in',NULL,2,1,140,'{\"Scratches\":\"not_applicable\",\"Broken Back\":\"not_applicable\",\"Broken Front\":\"not_applicable\",\"SIM&Memory\":\"not_applicable\",\"Battrey\":\"not_applicable\",\"Network\":\"not_applicable\",\"Touch\":\"not_applicable\",\"Screen\":\"not_applicable\",\"Back - Camera\":\"not_applicable\",\"Front - Camera\":\"not_applicable\",\"Portrait Mode\":\"not_applicable\",\"Flash\":\"not_applicable\",\"Wi-Fi\":\"not_applicable\",\"Bluetooth\":\"not_applicable\",\"Speaker\":\"not_applicable\",\"Earphone Port\":\"not_applicable\",\"Mic\":\"not_applicable\",\"Vibrator\":\"not_applicable\",\"Face ID\":\"not_applicable\",\"Charger Port\":\"not_applicable\",\"Finger Print\":\"not_applicable\"}','0',NULL,'45733',10,'2021-08-24 14:48:00',NULL,'[{\"value\":\"شاشة\"},{\"value\":\"تاتش\"}]',NULL,NULL,NULL,300.0000,11,NULL,NULL,NULL,NULL,NULL,'2021-08-23 14:48:24','2021-08-25 16:21:59'),(41,1,1,28,'2021/0041','carry_in',NULL,9,1,439,'{\"Scratches\":\"yes\",\"Broken Back\":\"not_applicable\",\"Broken Front\":\"not_applicable\",\"SIM&Memory\":\"not_applicable\",\"Battrey\":\"not_applicable\",\"Network\":\"not_applicable\",\"Touch\":\"not_applicable\",\"Screen\":\"yes\",\"Back - Camera\":\"not_applicable\",\"Front - Camera\":\"not_applicable\",\"Portrait Mode\":\"not_applicable\",\"Flash\":\"not_applicable\",\"Wi-Fi\":\"not_applicable\",\"Bluetooth\":\"not_applicable\",\"Speaker\":\"not_applicable\",\"Earphone Port\":\"not_applicable\",\"Mic\":\"not_applicable\",\"Vibrator\":\"not_applicable\",\"Face ID\":\"not_applicable\",\"Charger Port\":\"not_applicable\",\"Finger Print\":\"not_applicable\"}','0',NULL,'518129',10,'2021-08-23 15:12:00',NULL,'[{\"value\":\"شاشة\"}]',NULL,NULL,NULL,800.0000,4,NULL,NULL,NULL,NULL,NULL,'2021-08-23 15:08:50','2021-09-01 18:21:50'),(42,1,1,29,'2021/0042','carry_in',NULL,9,1,417,'{\"Scratches\":\"yes\",\"Broken Back\":\"no\",\"Broken Front\":\"yes\",\"SIM&Memory\":\"not_applicable\",\"Battrey\":\"yes\",\"Network\":\"not_applicable\",\"Touch\":\"not_applicable\",\"Screen\":\"no\",\"Back - Camera\":\"not_applicable\",\"Front - Camera\":\"not_applicable\",\"Portrait Mode\":\"not_applicable\",\"Flash\":\"not_applicable\",\"Wi-Fi\":\"not_applicable\",\"Bluetooth\":\"not_applicable\",\"Speaker\":\"not_applicable\",\"Earphone Port\":\"not_applicable\",\"Mic\":\"not_applicable\",\"Vibrator\":\"yes\",\"Face ID\":\"not_applicable\",\"Charger Port\":\"not_applicable\",\"Finger Print\":\"not_applicable\"}',NULL,NULL,'0000000000',10,'2021-08-24 17:00:00',NULL,'[{\"value\":\"شاشه\"}]',NULL,NULL,NULL,1100.0000,11,NULL,'3 شهور',NULL,NULL,NULL,'2021-08-23 15:16:33','2021-08-29 15:17:34'),(43,1,1,32,'2021/0043','carry_in',NULL,3,1,219,'{\"Scratches\":\"yes\",\"Broken Back\":\"not_applicable\",\"Broken Front\":\"not_applicable\",\"SIM&Memory\":\"not_applicable\",\"Battrey\":\"not_applicable\",\"Network\":\"not_applicable\",\"Touch\":\"not_applicable\",\"Screen\":\"not_applicable\",\"Back - Camera\":\"not_applicable\",\"Front - Camera\":\"not_applicable\",\"Portrait Mode\":\"not_applicable\",\"Flash\":\"not_applicable\",\"Wi-Fi\":\"not_applicable\",\"Bluetooth\":\"not_applicable\",\"Speaker\":\"not_applicable\",\"Earphone Port\":\"not_applicable\",\"Mic\":\"not_applicable\",\"Vibrator\":\"not_applicable\",\"Face ID\":\"not_applicable\",\"Charger Port\":\"not_applicable\",\"Finger Print\":\"not_applicable\"}','0',NULL,'1969',10,'2021-08-24 17:12:00',NULL,'[{\"value\":\"شاشة\"}]',NULL,NULL,NULL,1000.0000,4,NULL,NULL,NULL,NULL,NULL,'2021-08-23 17:08:38','2021-08-24 20:11:54'),(44,1,1,33,'2021/0044','carry_in',NULL,2,1,137,'{\"Scratches\":\"yes\",\"Broken Back\":\"not_applicable\",\"Broken Front\":\"not_applicable\",\"SIM&Memory\":\"not_applicable\",\"Battrey\":\"not_applicable\",\"Network\":\"not_applicable\",\"Touch\":\"not_applicable\",\"Screen\":\"not_applicable\",\"Back - Camera\":\"not_applicable\",\"Front - Camera\":\"not_applicable\",\"Portrait Mode\":\"not_applicable\",\"Flash\":\"not_applicable\",\"Wi-Fi\":\"not_applicable\",\"Bluetooth\":\"not_applicable\",\"Speaker\":\"not_applicable\",\"Earphone Port\":\"not_applicable\",\"Mic\":\"not_applicable\",\"Vibrator\":\"not_applicable\",\"Face ID\":\"not_applicable\",\"Charger Port\":\"not_applicable\",\"Finger Print\":\"not_applicable\"}',NULL,NULL,'359092056857869',10,NULL,NULL,'[{\"value\":\"سوفت وير\"}]',NULL,NULL,NULL,75.0000,4,NULL,NULL,NULL,NULL,NULL,'2021-08-23 19:01:56','2021-08-23 21:48:32'),(45,1,1,34,'2021/0045','carry_in',NULL,2,1,91,'{\"Scratches\":\"not_applicable\",\"Broken Back\":\"not_applicable\",\"Broken Front\":\"not_applicable\",\"SIM&Memory\":\"not_applicable\",\"Battrey\":\"not_applicable\",\"Network\":\"not_applicable\",\"Touch\":\"not_applicable\",\"Screen\":\"not_applicable\",\"Back - Camera\":\"not_applicable\",\"Front - Camera\":\"not_applicable\",\"Portrait Mode\":\"not_applicable\",\"Flash\":\"not_applicable\",\"Wi-Fi\":\"not_applicable\",\"Bluetooth\":\"not_applicable\",\"Speaker\":\"not_applicable\",\"Earphone Port\":\"not_applicable\",\"Mic\":\"not_applicable\",\"Vibrator\":\"not_applicable\",\"Face ID\":\"not_applicable\",\"Charger Port\":\"not_applicable\",\"Finger Print\":\"not_applicable\"}',NULL,NULL,'352462072456870',10,NULL,NULL,'[{\"value\":\"كشف باور\"}]',NULL,NULL,NULL,125.0000,4,NULL,NULL,NULL,NULL,NULL,'2021-08-23 19:22:46','2021-08-24 1