
<?php $__env->startSection('title', __('repair::lang.repair') . ' '. __('business.dashboard')); ?>
<meta name="csrf-token" content="<?php echo e(csrf_token(), false); ?>">

<?php $__env->startSection('content'); ?>
<?php echo $__env->make('repair::layouts.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- Content Header (Page header) -->
<section class="content-header no-print">
    <h1>
    	<?php echo app('translator')->getFromJson('repair::lang.repair'); ?>
    	<small><?php echo app('translator')->getFromJson('business.dashboard'); ?></small>
    </h1>
</section>
<!-- Main content -->
<section class="content no-print">
	<div class="row">
		<div class="col-md-12">

			<div class="box box-solid">
				<div class="raw">
					<div class="col-md-9">
						<div class="box-header with-border">
							<h4 class="box-title"><?php echo app('translator')->getFromJson('repair::lang.job_sheets_by_status'); ?></h4>
						</div>
					</div>
					<div class="col-md-3">
						<div class="form-group">
							<?php echo Form::label('ssr_date_range', __('report.date_range') . ':'); ?>

							<?php echo Form::text('date_range', \Carbon::createFromTimestamp(strtotime('first day of this month'))->format(session('business.date_format')) . ' ~ ' . \Carbon::createFromTimestamp(strtotime('last day of this month'))->format(session('business.date_format')), ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'id' => 'ssr_date_range', 'readonly']);; ?>

						</div>
					</div>

				</div>

				<div class="box-body">
					<div class="row">
				        <?php $__empty_1 = true; $__currentLoopData = $job_sheets_by_status; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $job_sheet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
							<div class="col-md-3 col-sm-6 col-xs-12">
								<div class="small-box" style="background-color: <?php echo e($job_sheet->color, false); ?>;color: #fff;">
						            <div class="inner">
						              	<p><?php echo e($job_sheet->status_name, false); ?></p>
						              	<h3 id="JobSheetId-<?php echo e($job_sheet->status_id, false); ?>" class="JobSheetStatusBe"><?php echo e($job_sheet->total_job_sheets, false); ?></h3>
						            </div>
					          	</div>
					        </div>
					    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
					    	<div class="col-md-12">
	    						<div class="alert alert-info">
					                <h4><?php echo app('translator')->getFromJson('repair::lang.no_report_found'); ?></h4>
					            </div>
				           	</div>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php if(in_array('service_staff', $enabled_modules)): ?>
		<div class="row">
		    <div class="col-xs-12">
		        <?php $__env->startComponent('components.widget'); ?>
		            <?php $__env->slot('title'); ?>
		                <?php echo app('translator')->getFromJson('repair::lang.job_sheets_by_service_staff'); ?>
		            <?php $__env->endSlot(); ?>
		            <div class="table-responsive">
						<table class="table table-striped">
							<thead>
								<tr>
									<th>#</th>
									<th><?php echo app('translator')->getFromJson('restaurant.service_staff'); ?></th>
									<th><?php echo app('translator')->getFromJson('repair::lang.total_job_sheets'); ?></th>
								</tr>
							</thead>
							<tbody>
								<?php $__currentLoopData = $job_sheets_by_service_staff; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $job_sheet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<tr>
										<td><?php echo e($loop->iteration, false); ?></td>
										<td><?php echo e($job_sheet->service_staff, false); ?></td>
										<td id="jobTotal-<?php echo e($loop->iteration, false); ?>" class="jobSheetTotalStaff"><?php echo e($job_sheet->total_job_sheets, false); ?></td>
									</tr>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							</tbody>
						</table>
					</div>
		        <?php echo $__env->renderComponent(); ?>
		    </div>
		</div>
	<?php endif; ?>
	<div class="row">
	    <div class="col-xs-12">
	        <?php $__env->startComponent('components.widget'); ?>
	            <?php $__env->slot('title'); ?>
	                <?php echo app('translator')->getFromJson('repair::lang.trending_brands'); ?>
	            <?php $__env->endSlot(); ?>
	            <?php echo $trending_brand_chart->container(); ?>

	        <?php echo $__env->renderComponent(); ?>
	    </div>
	</div>
	<div class="row">
	    <div class="col-xs-12">
	        <?php $__env->startComponent('components.widget'); ?>
	            <?php $__env->slot('title'); ?>
	                <?php echo app('translator')->getFromJson('repair::lang.trending_devices'); ?>
	            <?php $__env->endSlot(); ?>
	            <?php echo $trending_devices_chart->container(); ?>

	        <?php echo $__env->renderComponent(); ?>
	    </div>
	</div>
	<div class="row">
	    <div class="col-xs-12">
	        <?php $__env->startComponent('components.widget'); ?>
	            <?php $__env->slot('title'); ?>
	                <?php echo app('translator')->getFromJson('repair::lang.trending_device_models'); ?>
	            <?php $__env->endSlot(); ?>
	            <?php echo $trending_dm_chart->container(); ?>

	        <?php echo $__env->renderComponent(); ?>
	    </div>
	</div>
</section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascript'); ?>
	<?php echo $trending_devices_chart->script(); ?>

	<?php echo $trending_dm_chart->script(); ?>

	<?php echo $trending_brand_chart->script(); ?>

	<script type="text/javascript">
		$(document).ready(function () {
			if ($('#ssr_date_range').length == 1) {
				$('#ssr_date_range').daterangepicker({
					ranges: ranges,
					autoUpdateInput: false,
					startDate: moment().startOf('month'),
					endDate: moment().endOf('month'),
					locale: {
						format: moment_date_format
					}
				});
				$('#ssr_date_range').on('apply.daterangepicker', function (ev, picker) {
					$(this).val(picker.startDate.format(moment_date_format) + ' ~ ' + picker.endDate.format(moment_date_format));
					CallDate();

				});

				$('#ssr_date_range').on('cancel.daterangepicker', function (ev, picker) {
					$(this).val('');
					pending_job_sheets_datatable.ajax.reload();
					completed_job_sheets_datatable.ajax.reload();
				});
			}
		})
		function CallDate() {
			$(".jobSheetTotalStaff").each(function() {
				$(this).text("0");
			});
			$(".JobSheetStatusBe").each(function() {
				$(this).text("0");
			});
			var start_date;
			var end_date;
			if($('#ssr_date_range').val()) {
				var start = $('#ssr_date_range').data('daterangepicker').startDate.format('YYYY-MM-DD');
				var end = $('#ssr_date_range').data('daterangepicker').endDate.format('YYYY-MM-DD');
				start_date = start;
				end_date = end;
			}
			else {
				start_date = '2020-01-01';
				end_date = '2099-01-01';
			}
			$.ajaxSetup({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				}

			});
			$.ajax({
				type: "GET",
				url: '/repair/orderdata',
				dataType: 'json',// This is what I have updated
				data:  {
					start_date,
							end_date

				},
				success: function (result) {
					//alert(result);
					//var data = JSON.parse(result);
					for (var x = 0; x < result.length; x++) {
						content = result[x].total_job_sheets;
						content += "<br>";
						content += result[x].status_name;
						content += "<br>";
						//alert(content);
						$('#JobSheetId-'+result[x].status_id).text(result[x].total_job_sheets);
						// updateListing(data[x]);
					}

				}
			});
			CallDate2();
		}


		function CallDate2() {
			var start_date;
			var end_date;
			if($('#ssr_date_range').val()) {
				var start = $('#ssr_date_range').data('daterangepicker').startDate.format('YYYY-MM-DD');
				var end = $('#ssr_date_range').data('daterangepicker').endDate.format('YYYY-MM-DD');
				start_date = start;
				end_date = end;
			}
			else {
				start_date = '2020-01-01';
				end_date = '2099-01-01';
			}
			$.ajaxSetup({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				}

			});
			$.ajax({
				type: "GET",
				url: '/repair/orderdata2',
				dataType: 'json',// This is what I have updated
				data:  {
					start_date,
					end_date

				},
				success: function (result) {
					//alert(result);
					//var data = JSON.parse(result);
					var counter=1;
					for (var x = 0; x < result.length; x++) {

						//alert(content);
						$('#jobTotal-'+counter).text(result[x].total_job_sheets);
						counter++;
						// updateListing(data[x]);
					}

				}
			});
		}
	</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mobileyeshtaghal/software/Modules/Repair/Providers/../Resources/views/dashboard/index.blade.php ENDPATH**/ ?>