var Echo = (function () {
  'use strict';

  var classCallCheck = function (instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  };

  var createClass = function () {
    function defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];
        descriptor.enumerable = descriptor.enumerable || false;
        descriptor.configurable = true;
        if ("value" in descriptor) descriptor.writable = true;
        Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    return function (Constructor, protoProps, staticProps) {
      if (protoProps) defineProperties(Constructor.prototype, protoProps);
      if (staticProps) defineProperties(Constructor, staticProps);
      return Constructor;
    };
  }();

  var _extends = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];

      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }

    return target;
  };

  var inherits = function (subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        enumerable: false,
        writable: true,
        configurable: true
      }
    });
    if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
  };

  var possibleConstructorReturn = function (self, call) {
    if (!self) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return call && (typeof call === "object" || typeof call === "function") ? call : self;
  };

  var Connector = function () {
      /**
       * Create a new class instance.
       */
      function Connector(options) {
          classCallCheck(this, Connector);

          /**
           * Default connector options.
           */
          this._defaultOptions = {
              auth: {
                  headers: {}
              },
              authEndpoint: '/broadcasting/auth',
              broadcaster: 'pusher',
              csrfToken: null,
              host: null,
              key: null,
              namespace: 'App.Events'
          };
          this.setOptions(options);
          this.connect();
      }
      /**
       * Merge the custom options with the defaults.
       */


      createClass(Connector, [{
          key: 'setOptions',
          value: function setOptions(options) {
              this.options = _extends(this._defaultOptions, options);
              if (this.csrfToken()) {
                  this.options.auth.headers['X-CSRF-TOKEN'] = this.csrfToken();
              }
              return options;
          }
          /**
           * Extract the CSRF token from the page.
           */

      }, {
          key: 'csrfToken',
          value: function csrfToken() {
              var selector = void 0;
              if (typeof window !== 'undefined' && window['Laravel'] && window['Laravel'].csrfToken) {
                  return window['Laravel'].csrfToken;
              } else if (this.options.csrfToken) {
                  return this.options.csrfToken;
              } else if (typeof document !== 'undefined' && typeof document.querySelector === 'function' && (selector = document.querySelector('meta[name="csrf-token"]'))) {
                  return selector.getAttribute('content');
              }
              return null;
          }
      }]);
      return Connector;
  }();

  /**
   * This class represents a basic channel.
   */
  var Channel = function () {
    function Channel() {
      classCallCheck(this, Channel);
    }

    createClass(Channel, [{
      key: 'listenForWhisper',

      /**
       * Listen for a whisper event on the channel instance.
       */
      value: function listenForWhisper(event, callback) {
        return this.listen('.client-' + event, callback);
      }
      /**
       * Listen for an event on the channel instance.
       */

    }, {
      key: 'notification',
      value: function notification(callback) {
        return this.listen('.Illuminate\\Notifications\\Events\\BroadcastNotificationCreated', callback);
      }
      /**
       * Stop listening for a whispser event on the channel instance.
       */

    }, {
      key: 'stopListeningForWhisper',
      value: function stopListeningForWhisper(event) {
        return this.stopListening('.client-' + event);
      }
    }]);
    return Channel;
  }();

  /**
   * Event name formatter
   */
  var EventFormatter = function () {
      /**
       * Create a new class instance.
       */
      function EventFormatter(namespace) {
          classCallCheck(this, EventFormatter);

          this.setNamespace(namespace);
      }
      /**
       * Format the given event name.
       */


      createClass(EventFormatter, [{
          key: 'format',
          value: function format(event) {
              if (event.charAt(0) === '.' || event.charAt(0) === '\\') {
                  return event.substr(1);
              } else if (this.namespace) {
                  event = this.namespace + '.' + event;
              }
              return event.replace(/\./g, '\\');
          }
          /**
           * Set the event namespace.
           */

      }, {
          key: 'setNamespace',
          value: function setNamespace(value) {
              this.namespace = value;
          }
      }]);
      return EventFormatter;
  }();

  /**
   * This class represents a Pusher channel.
   */
  var PusherChannel = function (_Channel) {
      inherits(PusherChannel, _Channel);

      /**
       * Create a new class instance.
       */
      function PusherChannel(pusher, name, options) {
          classCallCheck(this, PusherChannel);

          var _this = possibleConstructorReturn(this, (PusherChannel.__proto__ || Object.getPrototypeOf(PusherChannel)).call(this));

          _this.name = name;
          _this.pusher = pusher;
          _this.options = options;
          _this.eventFormatter = new EventFormatter(_this.options.namespace);
          _this.subscribe();
          return _this;
      }
      /**
       * Subscribe to a Pusher channel.
       */


      createClass(PusherChannel, [{
          key: 'subscribe',
          value: function subscribe() {
              this.subscription = this.pusher.subscribe(this.name);
          }
          /**
           * Unsubscribe from a Pusher channel.
           */

      }, {
          key: 'unsubscribe',
          value: function unsubscribe() {
              this.pusher.unsubscribe(this.name);
          }
          /**
           * Listen for an event on the channel instance.
           */

      }, {
          key: 'listen',
          value: function listen(event, callback) {
              this.on(this.eventFormatter.format(event), callback);
              return this;
          }
          /**
           * Stop listening for an event on the channel instance.
           */

      }, {
          key: 'stopListening',
          value: function stopListening(event) {
              this.subscription.unbind(this.eventFormatter.format(event));
              return this;
          }
          /**
           * Bind a channel to an event.
           */

      }, {
          key: 'on',
          value: function on(event, callback) {
              this.subscription.bind(event, callback);
              return this;
          }
      }]);
      return PusherChannel;
  }(Channel);

  /**
   * This class represents a Pusher private channel.
   */
  var PusherPrivateChannel = function (_PusherChannel) {
    inherits(PusherPrivateChannel, _PusherChannel);

    function PusherPrivateChannel() {
      classCallCheck(this, PusherPrivateChannel);
      return possibleConstructorReturn(this, (PusherPrivateChannel.__proto__ || Object.getPrototypeOf(PusherPrivateChannel)).apply(this, arguments));
    }

    createClass(PusherPrivateChannel, [{
      key: 'whisper',

      /**
       * Trigger client event on the channel.
       */
      value: function whisper(eventName, data) {
        this.pusher.channels.channels[this.name].trigger('client-' + eventName, data);
        return this;
      }
    }]);
    return PusherPrivateChannel;
  }(PusherChannel);

  /**
   * This class represents a Pusher presence channel.
   */
  var PusherPresenceChannel = function (_PusherChannel) {
      inherits(PusherPresenceChannel, _PusherChannel);

      function PusherPresenceChannel() {
          classCallCheck(this, PusherPresenceChannel);
          return possibleConstructorReturn(this, (PusherPresenceChannel.__proto__ || Object.getPrototypeOf(PusherPresenceChannel)).apply(this, arguments));
      }

      createClass(PusherPresenceChannel, [{
          key: 'here',

          /**
           * Register a callback to be called anytime the member list changes.
           */
          value: function here(callback) {
              this.on('pusher:subscription_succeeded', function (data) {
                  callback(Object.keys(data.members).map(function (k) {
                      return data.members[k];
                  }));
              });
              return this;
          }
          /**
           * Listen for someone joining the channel.
           */

      }, {
          key: 'joining',
          value: function joining(callback) {
              this.on('pusher:member_added', function (member) {
                  callback(member.info);
              });
              return this;
          }
          /**
           * Listen for someone leaving the channel.
           */

      }, {
          key: 'leaving',
          value: function leaving(callback) {
              this.on('pusher:member_removed', function (member) {
                  callback(member.info);
              });
              return this;
          }
          /**
           * Trigger client event on the channel.
           */

      }, {
          key: 'whisper',
          value: function whisper(eventName, data) {
              this.pusher.channels.channels[this.name].trigger('client-' + eventName, data);
              return this;
          }
      }]);
      return PusherPresenceChannel;
  }(PusherChannel);

  /**
   * This class represents a Socket.io channel.
   */
  var SocketIoChannel = function (_Channel) {
      inherits(SocketIoChannel, _Channel);

      /**
       * Create a new class instance.
       */
      function SocketIoChannel(socket, name, options) {
          classCallCheck(this, SocketIoChannel);

          /**
           * The event callbacks applied to the channel.
           */
          var _this = possibleConstructorReturn(this, (SocketIoChannel.__proto__ || Object.getPrototypeOf(SocketIoChannel)).call(this));

          _this.events = {};
          _this.name = name;
          _this.socket = socket;
          _this.options = options;
          _this.eventFormatter = new EventFormatter(_this.options.namespace);
          _this.subscribe();
          _this.configureReconnector();
          return _this;
      }
      /**
       * Subscribe to a Socket.io channel.
       */


      createClass(SocketIoChannel, [{
          key: 'subscribe',
          value: function subscribe() {
              this.socket.emit('subscribe', {
                  channel: this.name,
                  auth: this.options.auth || {}
              });
          }
          /**
           * Unsubscribe from channel and ubind event callbacks.
           */

      }, {
          key: 'unsubscribe',
          value: function unsubscribe() {
              this.unbind();
              this.socket.emit('unsubscribe', {
                  channel: this.name,
                  auth: this.options.auth || {}
              });
          }
          /**
           * Listen for an event on the channel instance.
           */

      }, {
          key: 'listen',
          value: function listen(event, callback) {
              this.on(this.eventFormatter.format(event), callback);
              return this;
          }
          /**
           * Stop listening for an event on the channel instance.
           */

      }, {
          key: 'stopListening',
          value: function stopListening(event) {
              var name = this.eventFormatter.format(event);
              this.socket.removeListener(name);
              delete this.events[name];
              return this;
          }
          /**
           * Bind the channel's socket to an event and store the callback.
           */

      }, {
          key: 'on',
          value: function on(event, callback) {
              var _this2 = this;

              var listener = function listener(channel, data) {
                  if (_this2.name == channel) {
                      callback(data);
                  }
              };
              this.socket.on(event, listener);
              this.bind(event, listener);
          }
          /**
           * Attach a 'reconnect' listener and bind the event.
           */

      }, {
          key: 'configureReconnector',
          value: function configureReconnector() {
              var _this3 = this;

              var listener = function listener() {
                  _this3.subscribe();
              };
              this.socket.on('reconnect', listener);
              this.bind('reconnect', listener);
          }
          /**
           * Bind the channel's socket to an event and store the callback.
           */

      }, {
          key: 'bind',
          value: function bind(event, callback) {
              this.events[event] = this.events[event] || [];
              this.events[event].push(callback);
          }
          /**
           * Unbind the channel's socket from all stored event callbacks.
           */

      }, {
          key: 'unbind',
          value: function unbind() {
              var _this4 = this;

              Object.keys(this.events).forEach(function (event) {
                  _this4.events[event].forEach(function (callback) {
                      _this4.socket.removeListener(event, callback);
                  });
                  delete _this4.events[event];
              });
          }
      }]);
      return SocketIoChannel;
  }(Channel);

  /**
   * This class represents a Socket.io presence channel.
   */
  var SocketIoPrivateChannel = function (_SocketIoChannel) {
      inherits(SocketIoPrivateChannel, _SocketIoChannel);

      function SocketIoPrivateChannel() {
          classCallCheck(this, SocketIoPrivateChannel);
          return possibleConstructorReturn(this, (SocketIoPrivateChannel.__proto__ || Object.getPrototypeOf(SocketIoPrivateChannel)).apply(this, arguments));
      }

      createClass(SocketIoPrivateChannel, [{
          key: 'whisper',

          /**
           * Trigger client event on the channel.
           */
          value: function whisper(eventName, data) {
              this.socket.emit('client event', {
                  channel: this.name,
                  event: 'client-' + eventName,
                  data: data
              });
              return this;
          }
      }]);
      return SocketIoPrivateChannel;
  }(SocketIoChannel);

  /**
   * This class represents a Socket.io presence channel.
   */
  var SocketIoPresenceChannel = function (_SocketIoPrivateChann) {
      inherits(SocketIoPresenceChannel, _SocketIoPrivateChann);

      function SocketIoPresenceChannel() {
          classCallCheck(this, SocketIoPresenceChannel);
          return possibleConstructorReturn(this, (SocketIoPresenceChannel.__proto__ || Object.getPrototypeOf(SocketIoPresenceChannel)).apply(this, arguments));
      }

      createClass(SocketIoPresenceChannel, [{
          key: 'here',

          /**
           * Register a callback to be called anytime the member list changes.
           */
          value: function here(callback) {
              this.on('presence:subscribed', function (members) {
                  callback(members.map(function (m) {
                      return m.user_info;
                  }));
              });
              return this;
          }
          /**
           * Listen for someone joining the channel.
           */

      }, {
          key: 'joining',
          value: function joining(callback) {
              this.on('presence:joining', function (member) {
                  return callback(member.user_info);
              });
              return this;
          }
          /**
           * Listen for someone leaving the channel.
           */

      }, {
          key: 'leaving',
          value: function leaving(callback) {
              this.on('presence:leaving', function (member) {
                  return callback(member.user_info);
              });
              return this;
          }
      }]);
      return SocketIoPresenceChannel;
  }(SocketIoPrivateChannel);

  /**
   * This class represents a null channel.
   */
  var NullChannel = function (_Channel) {
    inherits(NullChannel, _Channel);

    function NullChannel() {
      classCallCheck(this, NullChannel);
      return possibleConstructorReturn(this, (NullChannel.__proto__ || Object.getPrototypeOf(NullChannel)).apply(this, arguments));
    }

    createClass(NullChannel, [{
      key: 'subscribe',

      /**
       * Subscribe to a channel.
       */
      value: function subscribe() {}
      //

      /**
       * Unsubscribe from a channel.
       */

    }, {
      key: 'unsubscribe',
      value: function unsubscribe() {}
      //

      /**
       * Listen for an event on the channel instance.
       */

    }, {
      key: 'listen',
      value: function listen(event, callback) {
        return this;
      }
      /**
       * Stop listening for an event on the channel instance.
       */

    }, {
      key: 'stopListening',
      value: function stopListening(event) {
        return this;
      }
      /**
       * Bind a channel to an event.
       */

    }, {
      key: 'on',
      value: function on(event, callback) {
        return this;
      }
    }]);
    return NullChannel;
  }(Channel);

  /**
   * This class represents a null private channel.
   */
  var NullPrivateChannel = function (_NullChannel) {
    inherits(NullPrivateChannel, _NullChannel);

    function NullPrivateChannel() {
      classCallCheck(this, NullPrivateChannel);
      return possibleConstructorReturn(this, (NullPrivateChannel.__proto__ || Object.getPrototypeOf(NullPrivateChannel)).apply(this, arguments));
    }

    createClass(NullPrivateChannel, [{
      key: 'whisper',

      /**
       * Trigger client event on the channel.
       */
      value: function whisper(eventName, data) {
        return this;
      }
    }]);
    return NullPrivateChannel;
  }(NullChannel);

  /**
   * This class represents a null presence channel.
   */
  var NullPresenceChannel = function (_NullChannel) {
    inherits(NullPresenceChannel, _NullChannel);

    function NullPresenceChannel() {
      classCallCheck(this, NullPresenceChannel);
      return possibleConstructorReturn(this, (NullPresenceChannel.__proto__ || Object.getPrototypeOf(NullPresenceChannel)).apply(this, arguments));
    }

    createClass(NullPresenceChannel, [{
      key: 'here',

      /**
       * Register a callback to be called anytime the member list changes.
       */
      value: function here(callback) {
        return this;
      }
      /**
       * Listen for someone joining the channel.
       */

    }, {
      key: 'joining',
      value: function joining(callback) {
        return this;
      }
      /**
       * Listen for someone leaving the channel.
       */

    }, {
      key: 'leaving',
      value: function leaving(callback) {
        return this;
      }
      /**
       * Trigger client event on the channel.
       */

    }, {
      key: 'whisper',
      value: function whisper(eventName, data) {
        return this;
      }
    }]);
    return NullPresenceChannel;
  }(NullChannel);

  /**
   * This class creates a connector to Pusher.
   */
  var PusherConnector = function (_Connector) {
      inherits(PusherConnector, _Connector);

      function PusherConnector() {
          classCallCheck(this, PusherConnector);

          /**
           * All of the subscribed channel names.
           */
          var _this = possibleConstructorReturn(this, (PusherConnector.__proto__ || Object.getPrototypeOf(PusherConnector)).apply(this, arguments));

          _this.channels = {};
          return _this;
      }
      /**
       * Create a fresh Pusher connection.
       */


      createClass(PusherConnector, [{
          key: 'connect',
          value: function connect() {
              if (typeof this.options.client !== 'undefined') {
                  this.pusher = this.options.client;
              } else {
                  this.pusher = new Pusher(this.options.key, this.options);
              }
          }
          /**
           * Listen for an event on a channel instance.
           */

      }, {
          key: 'listen',
          value: function listen(name, event, callback) {
              return this.channel(name).listen(event, callback);
          }
          /**
           * Get a channel instance by name.
           */

      }, {
          key: 'channel',
          value: function channel(name) {
              if (!this.channels[name]) {
                  this.channels[name] = new PusherChannel(this.pusher, name, this.options);
              }
              return this.channels[name];
          }
          /**
           * Get a private channel instance by name.
           */

      }, {
          key: 'privateChannel',
          value: function privateChannel(name) {
              if (!this.channels['private-' + name]) {
                  this.channels['private-' + name] = new PusherPrivateChannel(this.pusher, 'private-' + name, this.options);
              }
              return this.channels['private-' + name];
          }
          /**
           * Get a presence channel instance by name.
           */

      }, {
          key: 'presenceChannel',
          value: function presenceChannel(name) {
              if (!this.channels['presence-' + name]) {
                  this.channels['presence-' + name] = new PusherPresenceChannel(this.pusher, 'presence-' + name, this.options);
              }
              return this.channels['presence-' + name];
          }
          /**
           * Leave the given channel, as well as its private and presence variants.
           */

      }, {
          key: 'leave',
          value: function leave(name) {
              var _this2 = this;

              var channels = [name, 'private-' + name, 'presence-' + name];
              channels.forEach(function (name, index) {
                  _this2.leaveChannel(name);
              });
          }
          /**
           * Leave the given channel.
           */

      }, {
          key: 'leaveChannel',
          value: function leaveChannel(name) {
              if (this.channels[name]) {
                  this.channels[name].unsubscribe();
                  delete this.channels[name];
              }
          }
          /**
           * Get the socket ID for the connection.
           */

      }, {
          key: 'socketId',
          value: function socketId() {
              return this.pusher.connection.socket_id;
          }
          /**
           * Disconnect Pusher connection.
           */

      }, {
          key: 'disconnect',
          value: function disconnect() {
              this.pusher.disconnect();
          }
      }]);
      return PusherConnector;
  }(Connector);

  /**
   * This class creates a connnector to a Socket.io server.
   */
  var SocketIoConnector = function (_Connector) {
      inherits(SocketIoConnector, _Connector);

      function SocketIoConnector() {
          classCallCheck(this, SocketIoConnector);

          /**
           * All of the subscribed channel names.
           */
          var _this = possibleConstructorReturn(this, (SocketIoConnector.__proto__ || Object.getPrototypeOf(SocketIoConnector)).apply(this, arguments));

          _this.channels = {};
          return _this;
      }
      /**
       * Create a fresh Socket.io connection.
       */


      createClass(SocketIoConnector, [{
          key: 'connect',
          value: function connect() {
              var io = this.getSocketIO();
              this.socket = io(this.options.host, this.options);
              return this.socket;
          }
          /**
           * Get socket.io module from global scope or options.
           */

      }, {
          key: 'getSocketIO',
          value: function getSocketIO() {
              if (typeof this.options.client !== 'undefined') {
                  return this.options.client;
              }
              if (typeof io !== 'undefined') {
                  return io;
              }
              throw new Error('Socket.io client not found. Should be globally available or passed via options.client');
          }
          /**
           * Listen for an event on a channel instance.
           */

      }, {
          key: 'listen',
          value: function listen(name, event, callback) {
              return this.channel(name).listen(event, callback);
          }
          /**
           * Get a channel instance by name.
           */

      }, {
          key: 'channel',
          value: function channel(name) {
              if (!this.channels[name]) {
                  this.channels[name] = new SocketIoChannel(this.socket, name, this.options);
              }
              return this.channels[name];
          }
          /**
           * Get a private channel instance by name.
           */

      }, {
          key: 'privateChannel',
          value: function privateChannel(name) {
              if (!this.channels['private-' + name]) {
                  this.channels['private-' + name] = new SocketIoPrivateChannel(this.socket, 'private-' + name, this.options);
              }
              return this.channels['private-' + name];
          }
          /**
           * Get a presence channel instance by name.
           */

      }, {
          key: 'presenceChannel',
          value: function presenceChannel(name) {
              if (!this.channels['presence-' + name]) {
                  this.channels['presence-' + name] = new SocketIoPresenceChannel(this.socket, 'presence-' + name, this.options);
              }
              return this.channels['presence-' + name];
          }
          /**
           * Leave the given channel, as well as its private and presence variants.
           */

      }, {
          key: 'leave',
          value: function leave(name) {
              var _this2 = this;

              var channels = [name, 'private-' + name, 'presence-' + name];
              channels.forEach(function (name) {
                  _this2.leaveChannel(name);
              });
          }
          /**
           * Leave the given channel.
           */

      }, {
          key: 'leaveChannel',
          value: function leaveChannel(name) {
              if (this.channels[name]) {
                  this.channels[name].unsubscribe();
                  delete this.channels[name];
              }
          }
          /**
           * Get the socket ID for the connection.
           */

      }, {
          key: 'socketId',
          value: function socketId() {
              return this.socket.id;
          }
          /**
           * Disconnect Socketio connection.
           */

      }, {
          key: 'disconnect',
          value: function disconnect() {
              this.socket.disconnect();
          }
      }]);
      return SocketIoConnector;
  }(Connector);

  /**
   * This class creates a null connector.
   */
  var NullConnector = function (_Connector) {
    inherits(NullConnector, _Connector);

    function NullConnector() {
      classCallCheck(this, NullConnector);

      /**
       * All of the subscribed channel names.
       */
      var _this = possibleConstructorReturn(this, (NullConnector.__proto__ || Object.getPrototypeOf(NullConnector)).apply(this, arguments));

      _this.channels = {};
      return _this;
    }
    /**
     * Create a fresh connection.
     */


    createClass(NullConnector, [{
      key: 'connect',
      value: function connect() {}
      //

      /**
       * Listen for an event on a channel instance.
       */

    }, {
      key: 'listen',
      value: function listen(name, event, callback) {
        return new NullChannel();
      }
      /**
       * Get a channel instance by name.
       */

    }, {
      key: 'channel',
      value: function channel(name) {
        return new NullChannel();
      }
      /**
       * Get a private channel instance by name.
       */

    }, {
      key: 'privateChannel',
      value: function privateChannel(name) {
        return new NullPrivateChannel();
      }
      /**
       * Get a presence channel instance by name.
       */

    }, {
      key: 'presenceChannel',
      value: function presenceChannel(name) {
        return new NullPresenceChannel();
      }
      /**
       * Leave the given channel, as well as its private and presence variants.
       */

    }, {
      key: 'leave',
      value: function leave(name) {}
      //

      /**
       * Leave the given channel.
       */

    }, {
      key: 'leaveChannel',
      value: function leaveChannel(name) {}
      //

      /**
       * Get the socket ID for the connection.
       */

    }, {
      key: 'socketId',
      value: function socketId() {
        return 'fake-socket-id';
      }
      /**
       * Disconnect the connection.
       */

    }, {
      key: 'disconnect',
      value: function disconnect() {
        //
      }
    }]);
    return NullConnector;
  }(Connector);

  /**
   * This class is the primary API for interacting with broadcasting.
   */

  var Echo = function () {
      /**
       * Create a new class instance.
       */
      function Echo(options) {
          classCallCheck(this, Echo);

          this.options = options;
          this.connect();
          if (!this.options.withoutInterceptors) {
              this.registerInterceptors();
          }
      }
      /**
       * Get a channel instance by name.
       */


      createClass(Echo, [{
          key: 'channel',
          value: function channel(_channel) {
              return this.connector.channel(_channel);
          }
          /**
           * Create a new connection.
           */

      }, {
          key: 'connect',
          value: function connect() {
              if (this.options.broadcaster == 'pusher') {
                  this.connector = new PusherConnector(this.options);
              } else if (this.options.broadcaster == 'socket.io') {
                  this.connector = new SocketIoConnector(this.options);
              } else if (this.options.broadcaster == 'null') {
                  this.connector = new NullConnector(this.options);
              } else if (typeof this.options.broadcaster == 'function') {
                  this.connector = new this.options.broadcaster(this.options);
              }
          }
          /**
           * Disconnect from the Echo server.
           */

      }, {
          key: 'disconnect',
          value: function disconnect() {
              this.connector.disconnect();
          }
          /**
           * Get a presence channel instance by name.
           */

      }, {
          key: 'join',
          value: function join(channel) {
              return this.connector.presenceChannel(channel);
          }
          /**
           * Leave the given channel, as well as its private and presence variants.
           */

      }, {
          key: 'leave',
          value: function leave(channel) {
              this.connector.leave(channel);
          }
          /**
           * Leave the given channel.
           */

      }, {
          key: 'leaveChannel',
          value: function leaveChannel(channel) {
              this.connector.leaveChannel(channel);
          }
          /**
           * Listen for an event on a channel instance.
           */

      }, {
          key: 'listen',
          value: function listen(channel, event, callback) {
              return this.connector.listen(channel, event, callback);
          }
          /**
           * Get a private channel instance by name.
           */

      }, {
          key: 'private',
          value: function _private(channel) {
              return this.connector.privateChannel(channel);
          }
          /**
           * Get the Socket ID for the connection.
           */

      }, {
          key: 'socketId',
          value: function socketId() {
              return this.connector.socketId();
          }
          /**
           * Register 3rd party request interceptiors. These are used to automatically
           * send a connections socket id to a Laravel app with a X-Socket-Id header.
           */

      }, {
          key: 'registerInterceptors',
          value: function registerInterceptors() {
              if (typeof Vue === 'function' && Vue.http) {
                  this.registerVueRequestInterceptor();
              }
              if (typeof axios === 'function') {
                  this.registerAxiosRequestInterceptor();
              }
              if (typeof jQuery === 'function') {
                  this.registerjQueryAjaxSetup();
              }
          }
          /**
           * Register a Vue HTTP interceptor to add the X-Socket-ID header.
           */

      }, {
          key: 'registerVueRequestInterceptor',
          value: function registerVueRequestInterceptor() {
              var _this = this;

              Vue.http.interceptors.push(function (request, next) {
                  if (_this.socketId()) {
                      request.headers.set('X-Socket-ID', _this.socketId());
                  }
                  next();
              });
          }
          /**
           * Register an Axios HTTP interceptor to add the X-Socket-ID header.
           */

      }, {
          key: 'registerAxiosRequestInterceptor',
          value: function registerAxiosRequestInterceptor() {
              var _this2 = this;

              axios.interceptors.request.use(function (config) {
                  if (_this2.socketId()) {
                      config.headers['X-Socket-Id'] = _this2.socketId();
                  }
                  return config;
              });
          }
          /**
           * Register jQuery AjaxPrefilter to add the X-Socket-ID header.
           */

      }, {
          key: 'registerjQueryAjaxSetup',
          value: function registerjQueryAjaxSetup() {
              var _this3 = this;

              if (typeof jQuery.ajax != 'undefined') {
                  jQuery.ajaxPrefilter(function (options, originalOptions, xhr) {
                      if (_this3.socketId()) {
                          xhr.setRequestHeader('X-Socket-Id', _this3.socketId());
                      }
                  });
              }
          }
      }]);
      return Echo;
  }();

  return Echo;

}());
