<?php


namespace App\Http\Controllers;
use App\Account;

use App\AccountTransaction;
use App\BusinessLocation;
use App\ExpenseCategory;
use App\TaxRate;
use App\Transaction;
use App\TransactionPayment;
use App\User;
use App\Utils\ModuleUtil;
use App\Utils\TransactionUtil;
use DB;
use Illuminate\Http\Request;
use mysql_xdevapi\Exception;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Str;
use App\Contact;
use App\CashCapital;

class CashCapitalController extends Controller
{

    /**
     * Constructor
     *
     * @param TransactionUtil $transactionUtil
     * @return void
     */
    public function __construct(TransactionUtil $transactionUtil, ModuleUtil $moduleUtil)
    {
        $this->transactionUtil = $transactionUtil;
        $this->moduleUtil = $moduleUtil;
        $this->dummyPaymentLine = ['method' => 'cash', 'amount' => 0, 'note' => '', 'card_transaction_number' => '', 'card_number' => '', 'card_type' => '', 'card_holder_name' => '', 'card_month' => '', 'card_year' => '', 'card_security' => '', 'cheque_number' => '', 'bank_account_number' => '',
            'is_return' => 0, 'transaction_no' => ''];
    }


    public function index()
    {
        $business_id = request()->session()->get('user.business_id');
        $cash_capital=CashCapital::leftJoin('business_locations AS bl','cash_capital.location_id',
            '=',
            'bl.id')
            ->leftJoin('users AS usr', 'cash_capital.user_id', '=', 'usr.id')
            ->select(
                'cash_capital.id',
                'cash_capital.trans_amount',
                'cash_capital.paid_on',
                'cash_capital.trans_notes',
                'cash_capital.created_at',
                'bl.name as location_name',
                'cash_capital.paid_from',
                'usr.first_name as first_name',
                'usr.last_name as last_name',
                DB::raw("CONCAT(COALESCE(usr.surname, ''),' ',COALESCE(usr.first_name, ''),' ',COALESCE(usr.last_name,'')) as added_by"),
                DB::raw("CASE WHEN cash_capital.paid_from='register' THEN 'Register' WHEN cash_capital.paid_from='cashcapital' THEN 'Cash Capital' END as account_name")

            )
            ->get();
return view('cash_capital.index')
    ->with(compact('cash_capital'));
    }



    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        if (!auth()->user()->can('expense.access')) {
            abort(403, 'Unauthorized action.');
        }

        $business_id = request()->session()->get('user.business_id');
        $business_locations = BusinessLocation::forDropdown($business_id, false, true);
        $bl_attributes = $business_locations['attributes'];
        $payment_line = $this->dummyPaymentLine;
        return view('cash_capital.create')
            ->with(compact('business_id', 'business_locations', 'bl_attributes','payment_line'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if (!auth()->user()->can('expense.access')) {
            abort(403, 'Unauthorized action.');
        }
        try {
            $business_id = $request->session()->get('user.business_id');
            $user_id = $request->session()->get('user.id');
            $now = \Carbon::now()->toDateTimeString();
            $cash_capital_data['business_id']='1' ;
            $cash_capital_data['location_id']=$request->location_id ;
            $cash_capital_data['user_id']= $user_id;
            $cash_capital_data['trans_amount']=$request->payment_amount ;
            $cash_capital_data['trans_notes']=$request->payment_notes ;
            $cash_capital_data['paid_on']=$request->paid_on ;
            $cash_capital_data['paid_from']=$request->paid_from_account ;
            $cash_capital_data['created_at']=$now ;
            $cash_capital_data['updated_at']=$now ;
            $transaction = CashCapital::create($cash_capital_data);

            $this->transactionUtil->activityLog($transaction, 'added');
            DB::commit();

            $output = ['success' => 1,
                'msg' => __('lang_v1.cash_capital_created_succ')
            ];
            return redirect()->action('CashCapitalController@index');
        }
        catch (Exception $eExcaption)
        {
            DB::rollBack();

            \Log::emergency("File:" . $eExcaption->getFile(). "Line:" . $eExcaption->getLine(). "Message:" . $eExcaption->getMessage());

            $output = ['success' => 0,
                'msg' => __('messages.something_went_wrong')
            ];
        }

    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $expense = CashCapital::destroy( $id);
        if (request()->ajax()) {
            try {
                $business_id = request()->session()->get('user.business_id');



                //Delete account transactions
                CashCapital::where('id',$id)->delete();

                $output = ['success' => true,
                    'msg' => __("expense.expense_delete_success")
                ];
            } catch (\Exception $e) {
                \Log::emergency("File:" . $e->getFile(). "Line:" . $e->getLine(). "Message:" . $e->getMessage());

                $output = ['success' => false,
                    'msg' => __("messages.something_went_wrong")
                ];
            }

            return $output;
        }

    }



    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        CashCapital::where('id',$id)->delete();
        return redirect()->action('CashCapitalController@index');
    }


    public function showReport()
    {
        $cash_capital=CashCapital::leftJoin('business_locations AS bl','cash_capital.location_id',
            '=',
            'bl.id')
            ->leftJoin('users AS usr', 'cash_capital.user_id', '=', 'usr.id')
            ->select(
                'cash_capital.id',
                'cash_capital.trans_amount',
                'cash_capital.paid_on',
                'cash_capital.trans_notes',
                'cash_capital.created_at',
                'bl.name as location_name',
                'cash_capital.paid_from',
                'usr.first_name as first_name',
                'usr.last_name as last_name',
                DB::raw("CONCAT(COALESCE(usr.surname, ''),' ',COALESCE(usr.first_name, ''),' ',COALESCE(usr.last_name,'')) as added_by"),
                DB::raw("CASE WHEN cash_capital.paid_from='register' THEN 'Register' WHEN cash_capital.paid_from='cashcapital' THEN 'Cash Capital' END as account_name")

            )
            ->get();
        $business_id = request()->session()->get('user.business_id');
        $payment_purchase = TransactionPayment::leftjoin('transactions as t', function ($join) use ($business_id) {
            $join->on('transaction_payments.transaction_id', '=', 't.id')
                ->where('t.business_id', $business_id)
                ->wherein('t.type', ['purchase','expense']);
        })
            ->leftJoin('users AS usr', 't.created_by', '=', 'usr.id')
            ->leftJoin('business_locations AS bl','t.location_id',
                '=',
                'bl.id')
            ->where('transaction_payments.business_id', $business_id)
            ->where('transaction_payments.method', 'other')


            ->select(
                DB::raw("IF(transaction_payments.transaction_id IS NULL, 
                                (SELECT c.name FROM transactions as ts
                                JOIN contacts as c ON ts.contact_id=c.id 
                                WHERE ts.id=(
                                        SELECT tps.transaction_id FROM transaction_payments as tps
                                        WHERE tps.parent_id=transaction_payments.id LIMIT 1
                                    )
                                ),
                                (SELECT CONCAT(COALESCE(c.supplier_business_name, ''), '<br>', c.name) FROM transactions as ts JOIN
                                    contacts as c ON ts.contact_id=c.id
                                    WHERE ts.id=t.id 
                                )
                            ) as supplier"),
                DB::raw("CONCAT(COALESCE(usr.surname, ''),' ',COALESCE(usr.first_name, ''),' ',COALESCE(usr.last_name,'')) as added_by"),
                'transaction_payments.amount',
                'transaction_payments.created_at',
                'bl.name as location_name',
                'method',
                'paid_on',
                'transaction_payments.payment_ref_no',
                'transaction_payments.document',
                't.ref_no',
                't.id as transaction_id',
                'cheque_number',
                'card_transaction_number',
                'bank_account_number',
                'transaction_no',
                't.type' ,
                'transaction_payments.id as DT_RowId'
            )
            ->groupBy('transaction_payments.id')
        ->get();


        $payment_expenses = TransactionPayment::leftjoin('transactions as t', function ($join) use ($business_id) {
            $join->on('transaction_payments.transaction_id', '=', 't.id')
                ->where('t.business_id', $business_id)
                ->where('t.type', 'expense');
        })
            ->leftJoin('users AS usr', 't.created_by', '=', 'usr.id')
            ->leftJoin('business_locations AS bl','t.location_id',
                '=',
                'bl.id')
            ->where('transaction_payments.business_id', $business_id)
            ->where('transaction_payments.method', 'other')
            ->select(
                DB::raw("CONCAT(COALESCE(usr.surname, ''),' ',COALESCE(usr.first_name, ''),' ',COALESCE(usr.last_name,'')) as added_by"),
                'transaction_payments.amount',
                'transaction_payments.created_at',
                'bl.name as location_name',
                'method',
                'paid_on',
                'transaction_payments.payment_ref_no',
                'transaction_payments.document',
                't.ref_no',
                't.id as transaction_id',
                'cheque_number',
                'card_transaction_number',
                'bank_account_number',
                'transaction_no',
                't.type' ,
                'transaction_payments.id as DT_RowId'
            )
            ->groupBy('transaction_payments.id')
            ->get();
        return view('cash_capital.show_report')
            ->with(compact('cash_capital','payment_purchase','payment_expenses'));
    }
    }