
<?php $__env->startSection('title', __('lang_v1.add_cash_capital')); ?>

<?php $__env->startSection('content'); ?>

    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1><?php echo app('translator')->getFromJson('lang_v1.add_cash_capital'); ?></h1>
    </section>

    <section class="content">
        <?php echo Form::open(['url' => action('CashCapitalController@store'), 'method' => 'post', 'id' => 'add_expense_form', 'files' => true ]); ?>

        <div class="box box-solid">
            <div class="box-body">
                <div class="row">
<?php
    $readonly = $payment_line['method'] == 'advance' ? true : false;

?>
                    <?php if(count($business_locations) == 1): ?>
                        <?php
                            $default_location = current(array_keys($business_locations->toArray()))
                        ?>
                    <?php else: ?>
                        <?php $default_location = null; ?>
                    <?php endif; ?>
                    <div class="row">
                    <div class="col-sm-6">
                        <div class="form-group">
                            <?php echo Form::label('location_id', __('purchase.business_location').':*'); ?>

                            <?php echo Form::select('location_id', $business_locations, $default_location, ['class' => 'form-control select2', 'placeholder' => __('messages.please_select'), 'required']);; ?>

                        </div>
                    </div>
                    </div>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <?php echo Form::label("payment_amount" ,__('sale.amount') . ':*'); ?>

                                    <div class="input-group">
				<span class="input-group-addon">
					<i class="fas fa-money-bill-alt"></i>
				</span>
                                        <?php echo Form::text("payment_amount", number_format($payment_line['amount'], config('constants.currency_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']), ['class' => 'form-control payment-amount input_number', 'required', 'id' => "amount_0", 'placeholder' => __('sale.amount'), 'readonly' => $readonly]);; ?>

                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <?php echo Form::label("paid_on" , __('lang_v1.paid_on') . ':*'); ?>

                                    <div class="input-group">
              <span class="input-group-addon">
                <i class="fa fa-calendar"></i>
              </span>
                                      <input type="datetime-local" name="paid_on" id="paid_on_input" class="form-control" value="<?php echo e(Carbon::now()->format('Y-m-d\TH:i'), false); ?>">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <?php echo Form::label("paid_on_0" , __('lang_v1.account_name_capital') . ':*'); ?>

                                    <div class="input-group">
              <span class="input-group-addon">
                <i class="fa fa-money-bill-alt"></i>
              </span>
<select class="form-control select2" placeholder="__('messages.please_select')"  name="paid_from_account">
    <option value="register">Register</option>
    <option value="cashcapital">Cash Capital</option>
</select>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <?php echo Form::label("note_0", __('sale.payment_note') . ':'); ?>

                                    <?php echo Form::textarea("payment_notes", $payment_line['note'], ['class' => 'form-control', 'rows' => 3, 'id' => "note_0"]);; ?>

                                </div>
                        </div>



                    <div class="clearfix"></div>
                </div>
            </div>
        </div> <!--box end-->

        <div class="col-sm-12">
            <button type="submit" class="btn btn-primary pull-right"><?php echo app('translator')->getFromJson('messages.save'); ?></button>
        </div>
        <?php echo Form::close(); ?>

    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascript'); ?>
    <script type="text/javascript">
        $(document).ready( function(){

            document.getElementById("paid_on_input").defaultValue ="<?php echo e(Carbon::now()->format('Y-m-d\TH:i'), false); ?>";

        });
        </script>
	<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home1/generals/mobiley.generalserviceonline.com/resources/views/cash_capital/create.blade.php ENDPATH**/ ?>