

<?php $__env->startSection('title', __('repair::lang.view_job_sheet')); ?>

<?php $__env->startSection('content'); ?>
<?php echo $__env->make('repair::layouts.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- Content Header (Page header) -->
<section class="content-header no-print">
    <h1>
    	<?php echo app('translator')->getFromJson('repair::lang.job_sheet'); ?>
    	(<code><?php echo e($job_sheet->job_sheet_no, false); ?></code>)
    </h1>
</section>
<!-- Main content -->
<section class="content">
	<div class="box box-solid" style="box-shadow:none;!important;">
		<div class="box-header no-print">
			<div class="box-tools">
				<a href="<?php echo e(action('\Modules\Repair\Http\Controllers\JobSheetController@edit', ['id' => $job_sheet->id]), false); ?>" class="btn btn-info cursor-pointer">
                    <i class="fa fa-edit"></i>
                    <?php echo app('translator')->getFromJson("messages.edit"); ?>
                </a>
				<button type="button" class="btn btn-primary" aria-label="Print" onclick="window.print();">
					<i class="fa fa-print"></i>
					<?php echo app('translator')->getFromJson( 'messages.print' ); ?>
		      	</button>
	      </div>
	    </div>
		<div class="box-body">

			
			<table class="table table-bordered" style="margin-top: 15px;">
				<tr>
					<th rowspan="3">
						<?php echo app('translator')->getFromJson('receipt.date'); ?>:
						<span style="font-weight: 100">
							<?php echo e(\Carbon::createFromTimestamp(strtotime($job_sheet->created_at))->format(session('business.date_format') . ' ' . 'h:i A'), false); ?>

						</span>
					</th>
				</tr>
				<tr>

					<th rowspan="2">
						<b>
							<?php echo app('translator')->getFromJson('repair::lang.expected_delivery_date'); ?>:
						</b>
						<?php if(!empty($job_sheet->delivery_date)): ?>
							<span style="font-weight: 100">
								<?php echo e(\Carbon::createFromTimestamp(strtotime($job_sheet->delivery_date))->format(session('business.date_format') . ' ' . 'h:i A'), false); ?>

							</span>
						<?php endif; ?>
					</th>
				</tr>
				<tr>
					<td>
						<b><?php echo app('translator')->getFromJson('repair::lang.job_sheet_no'); ?>:</b>
						<?php echo e($job_sheet->job_sheet_no, false); ?>

					</td>
				</tr>
				<tr>
					<td colspan="1">
						<strong><?php echo app('translator')->getFromJson('role.customer'); ?>:</strong><br>
						<p>
							<?php echo e($job_sheet->customer->name, false); ?> <br>

							<?php if(!empty($contact->email)): ?>
								<br><?php echo app('translator')->getFromJson('business.email'); ?>:
								<?php echo e($job_sheet->customer->email, false); ?>

							<?php endif; ?>
							<br><?php echo app('translator')->getFromJson('contact.mobile'); ?>:
							<?php echo e($job_sheet->customer->mobile, false); ?>

							<?php if(!empty($contact->tax_number)): ?>
								<br><?php echo app('translator')->getFromJson('contact.tax_no'); ?>:
								<?php echo e($job_sheet->customer->tax_number, false); ?>

							<?php endif; ?>
						</p>
					</td>
					<td>
						<b>
							<?php echo app('translator')->getFromJson('repair::lang.problem_reported_by_customer'); ?>:
						</b> <br>
						<?php
							$defects = json_decode($job_sheet->defects, true);
						?>
						<?php if(!empty($defects)): ?>
							<?php $__currentLoopData = $defects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product_defect): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<?php echo e($product_defect['value'], false); ?>

								<?php if(!$loop->last): ?>
									<?php echo e(',', false); ?>

								<?php endif; ?>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						<?php endif; ?>
						<br>
						<b>
							<?php echo app('translator')->getFromJson('repair::lang.condition_of_product'); ?>:
						</b> <br>
						<?php
							$product_condition = json_decode($job_sheet->product_condition, true);
						?>
						<?php if(!empty($product_condition)): ?>
							<?php $__currentLoopData = $product_condition; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product_cond): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<?php echo e($product_cond['value'], false); ?>

								<?php if(!$loop->last): ?>
									<?php echo e(',', false); ?>

								<?php endif; ?>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						<?php endif; ?>
						<br>
					</td>
					<td>
						<b><?php echo app('translator')->getFromJson('product.brand'); ?>:</b>
						<?php echo e(optional($job_sheet->brand)->name, false); ?>

						<br>
						<b><?php echo app('translator')->getFromJson('repair::lang.device'); ?>:</b>
						<?php echo e(optional($job_sheet->device)->name, false); ?>

						<br>
						<b><?php echo app('translator')->getFromJson('repair::lang.device_model'); ?>:</b>
						<?php echo e(optional($job_sheet->deviceModel)->name, false); ?>

						<br>
						<b><?php echo app('translator')->getFromJson('repair::lang.serial_no'); ?>:</b>
						<?php echo e($job_sheet->serial_no, false); ?>

						<br>
						<b><?php echo app('translator')->getFromJson('lang_v1.password'); ?>:</b>
						<?php echo e($job_sheet->security_pwd, false); ?>

						<br>
						<b>
							<?php echo app('translator')->getFromJson('repair::lang.security_pattern_code'); ?>:
						</b>
						<?php echo e($job_sheet->security_pattern, false); ?>

					</td>
				</tr>
				<tr>
					<td colspan="2">
						<b>
							<?php echo app('translator')->getFromJson('sale.invoice_no'); ?>:
						</b>
					</td>
					<td>
						<?php if($job_sheet->invoices->count() > 0): ?>
							<?php $__currentLoopData = $job_sheet->invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<?php echo e($invoice->invoice_no, false); ?>

								<?php if(!$loop->last): ?>
							        <?php echo e(', ', false); ?>

							    <?php endif; ?>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						<?php endif; ?>
					</td>
				</tr>
				<tr>
					<td colspan="2">
						<b>
							<?php echo app('translator')->getFromJson('repair::lang.estimated_cost'); ?>:
						</b>
					</td>
					<td>
						<span class="display_currency" data-currency_symbol="true">
							<?php echo e($job_sheet->estimated_cost, false); ?>

						</span>
					</td>
				</tr>
				<tr>
					<td colspan="2">
						<b>
							<?php echo app('translator')->getFromJson('sale.status'); ?>:
						</b>
					</td>
					<td>
						<?php echo e(optional($job_sheet->status)->name, false); ?>

					</td>
				</tr>
				<tr>
					<td colspan="2">
						<b>
							<?php echo app('translator')->getFromJson('business.location'); ?>:
						</b>
					</td>
					<td>
						<?php echo e(optional($job_sheet->businessLocation)->name, false); ?>

					</td>
				</tr>

				<tr>
					<td colspan="2">
						<b>
							<?php echo app('translator')->getFromJson('repair::lang.warranty_period'); ?>:
						</b>
					</td>
					<td>
						<?php echo e($job_sheet->custom_field_2, false); ?>

					</td>
				</tr>
				<tr>
					<td colspan="2">
						<b>
							<?php echo app('translator')->getFromJson('repair::lang.custom_payed_amount'); ?>:
						</b>
					</td>
					<td>
						<?php echo e($job_sheet->custom_field_3, false); ?>

					</td>
				</tr>

			</table>
		</div>
	</div>
	<?php if($job_sheet->media->count() > 0): ?>
		<div class="box box-solid no-print">
			<div class="box-header with-border">
				<h4>
					<?php echo app('translator')->getFromJson('repair::lang.uploaded_image_for', ['job_sheet_no' => $job_sheet->job_sheet_no]); ?>
				</h4>
		    </div>
			<div class="box-body">
				<table class="table table-striped">
					<thead>
						<tr>
							<th><?php echo app('translator')->getFromJson('lang_v1.image'); ?></th>
							<th><?php echo app('translator')->getFromJson('messages.action'); ?></th>
						</tr>
					</thead>
					<tbody>
						<?php $__currentLoopData = $job_sheet->media; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $media): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<tr class="media_row">
							<td>
								<a href="<?php echo e($media->display_url, false); ?>" class="cursor-pointer"target="_blank">
									<?php echo e($media->display_name, false); ?>	
								</a>
							</td>
							<td>
								<a href="<?php echo e($media->display_url, false); ?>" class="btn btn-info btn-sm" target="_blank">
									<i class="fas fa-external-link-alt"></i>
								</a>
								<a data-href="<?php echo e(action('\Modules\Repair\Http\Controllers\JobSheetController@deleteJobSheetImage', ['id' => $media->id]), false); ?>" class="btn btn-danger btn-sm delete_media">
									<i class="fas fa-trash-alt"></i>
								</a>
							</td>
						</tr>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</tbody>
				</table>
			</div>
		</div>
	<?php endif; ?>
</section>
<!-- /.content -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
<style type="text/css">
	.table-bordered>thead>tr>th, .table-bordered>tbody>tr>th,
	.table-bordered>tfoot>tr>th, .table-bordered>thead>tr>td,
	.table-bordered>tbody>tr>td, .table-bordered>tfoot>tr>td {
		border: 1px solid #1d1a1a;
	}
	@media  print{
		.bizz_addr {
			float: right;
		}
	}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascript'); ?>
<script type="text/javascript">
	$(document).ready(function () {
		$(document).on('click', '.delete_media', function (e) {
            e.preventDefault();
            var url = $(this).data('href');
            var this_btn = $(this);
            swal({
                title: LANG.sure,
                icon: "warning",
                buttons: true,
                dangerMode: true,
            }).then((confirmed) => {
                if (confirmed) {
                    $.ajax({
                        method: 'GET',
                        url: url,
                        dataType: 'json',
                        success: function(result) {
                            if(result.success == true){
			                    this_btn.closest('tr').remove();
			                    toastr.success(result.msg);
			                } else {
			                    toastr.error(result.msg);
			                }
                        }
                    });
                }
            });
        });
	});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home1/generals/mobiley.generalserviceonline.com/Modules/Repair/Providers/../Resources/views/job_sheet/show.blade.php ENDPATH**/ ?>