@extends('layouts.app')
@section('title', __('lang_v1.add_cash_capital'))

@section('content')

    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>@lang('lang_v1.add_cash_capital')</h1>
    </section>

    <section class="content">
        {!! Form::open(['url' => action('CashCapitalController@store'), 'method' => 'post', 'id' => 'add_expense_form', 'files' => true ]) !!}
        <div class="box box-solid">
            <div class="box-body">
                <div class="row">
@php
    $readonly = $payment_line['method'] == 'advance' ? true : false;

@endphp
                    @if(count($business_locations) == 1)
                        @php
                            $default_location = current(array_keys($business_locations->toArray()))
                        @endphp
                    @else
                        @php $default_location = null; @endphp
                    @endif
                    <div class="row">
                    <div class="col-sm-6">
                        <div class="form-group">
                            {!! Form::label('location_id', __('purchase.business_location').':*') !!}
                            {!! Form::select('location_id', $business_locations, $default_location, ['class' => 'form-control select2', 'placeholder' => __('messages.please_select'), 'required']); !!}
                        </div>
                    </div>
                    </div>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    {!! Form::label("payment_amount" ,__('sale.amount') . ':*') !!}
                                    <div class="input-group">
				<span class="input-group-addon">
					<i class="fas fa-money-bill-alt"></i>
				</span>
                                        {!! Form::text("payment_amount", @num_format($payment_line['amount']), ['class' => 'form-control payment-amount input_number', 'required', 'id' => "amount_0", 'placeholder' => __('sale.amount'), 'readonly' => $readonly]); !!}
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    {!! Form::label("paid_on" , __('lang_v1.paid_on') . ':*') !!}
                                    <div class="input-group">
              <span class="input-group-addon">
                <i class="fa fa-calendar"></i>
              </span>
                                      <input type="datetime-local" name="paid_on" id="paid_on_input" class="form-control" value="{{ Carbon::now()->format('Y-m-d\TH:i') }}">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    {!! Form::label("paid_on_0" , __('lang_v1.account_name_capital') . ':*') !!}
                                    <div class="input-group">
              <span class="input-group-addon">
                <i class="fa fa-money-bill-alt"></i>
              </span>
<select class="form-control select2" placeholder="__('messages.please_select')"  name="paid_from_account">
    <option value="register">Register</option>
    <option value="cashcapital">Cash Capital</option>
</select>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    {!! Form::label("note_0", __('sale.payment_note') . ':') !!}
                                    {!! Form::textarea("payment_notes", $payment_line['note'], ['class' => 'form-control', 'rows' => 3, 'id' => "note_0"]); !!}
                                </div>
                        </div>



                    <div class="clearfix"></div>
                </div>
            </div>
        </div> <!--box end-->

        <div class="col-sm-12">
            <button type="submit" class="btn btn-primary pull-right">@lang('messages.save')</button>
        </div>
        {!! Form::close() !!}
    </section>
@endsection
@section('javascript')
    <script type="text/javascript">
        $(document).ready( function(){

            document.getElementById("paid_on_input").defaultValue ="{{ Carbon::now()->format('Y-m-d\TH:i') }}";

        });
        </script>
	@endsection