
/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
DROP TABLE IF EXISTS `account_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `account_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(11) NOT NULL,
  `type` enum('debit','credit') COLLATE utf8mb4_unicode_ci NOT NULL,
  `sub_type` enum('opening_balance','fund_transfer','deposit') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(22,4) NOT NULL,
  `reff_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `operation_date` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `transaction_payment_id` int(11) DEFAULT NULL,
  `transfer_transaction_id` int(11) DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `account_transactions_account_id_index` (`account_id`) USING BTREE,
  KEY `account_transactions_transaction_id_index` (`transaction_id`) USING BTREE,
  KEY `account_transactions_transaction_payment_id_index` (`transaction_payment_id`) USING BTREE,
  KEY `account_transactions_transfer_transaction_id_index` (`transfer_transaction_id`) USING BTREE,
  KEY `account_transactions_created_by_index` (`created_by`) USING BTREE,
  KEY `account_transactions_type_index` (`type`) USING BTREE,
  KEY `account_transactions_sub_type_index` (`sub_type`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_transactions` WRITE;
/*!40000 ALTER TABLE `account_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `account_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `account_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_account_type_id` int(11) DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `account_types_parent_account_type_id_index` (`parent_account_type_id`) USING BTREE,
  KEY `account_types_business_id_index` (`business_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_types` WRITE;
/*!40000 ALTER TABLE `account_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_number` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_type_id` int(11) DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `created_by` int(11) NOT NULL,
  `is_closed` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `accounts_business_id_index` (`business_id`) USING BTREE,
  KEY `accounts_account_type_id_index` (`account_type_id`) USING BTREE,
  KEY `accounts_created_by_index` (`created_by`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `activity_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `log_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject_id` int(11) DEFAULT NULL,
  `subject_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `business_id` int(11) NOT NULL DEFAULT '1',
  `causer_id` int(11) DEFAULT NULL,
  `causer_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `properties` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `activity_log_log_name_index` (`log_name`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=22909 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `activity_log` WRITE;
/*!40000 ALTER TABLE `activity_log` DISABLE KEYS */;
INSERT INTO `activity_log` VALUES (1,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-08-06 01:22:17','2021-08-06 01:22:17'),(2,'default','added',2,'App\\User',1,1,'App\\User','[]','2021-08-05 22:07:52','2021-08-05 22:07:52'),(3,'default','edited',2,'App\\User',1,1,'App\\User','[]','2021-08-05 22:20:08','2021-08-05 22:20:08'),(4,'default','status_changed',1,'Modules\\Repair\\Entities\\JobSheet',1,1,'App\\User','{\"update_note\":null,\"updated_status\":\"Finished\"}','2021-08-05 22:23:51','2021-08-05 22:23:51'),(5,'default','added',1,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-08-05 22:27:36','2021-08-05 22:27:36'),(6,'default','edited',1,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"500.0000\"}}','2021-08-05 22:47:14','2021-08-05 22:47:14'),(7,'default','status_changed',2,'Modules\\Repair\\Entities\\JobSheet',1,1,'App\\User','{\"update_note\":null,\"updated_status\":\"Finished\"}','2021-08-06 02:01:30','2021-08-06 02:01:30'),(8,'default','added',2,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-08-06 02:03:33','2021-08-06 02:03:33'),(9,'default','added',2,'App\\Contact',1,1,'App\\User','[]','2021-08-06 02:28:33','2021-08-06 02:28:33'),(10,'default','added',3,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-08-06 02:32:45','2021-08-06 02:32:45'),(11,'default','payment_edited',3,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"},\"old\":{\"payment_status\":\"due\"}}','2021-08-06 02:32:58','2021-08-06 02:32:58'),(12,'default','added',4,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":500}}','2021-08-06 02:33:53','2021-08-06 02:33:53'),(13,'default','added',5,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":250}}','2021-08-06 02:37:57','2021-08-06 02:37:57'),(14,'default','payment_edited',5,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"250.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"250.0000\"}}','2021-08-06 02:38:34','2021-08-06 02:38:34'),(15,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-08-06 03:37:23','2021-08-06 03:37:23'),(16,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-08-06 04:53:37','2021-08-06 04:53:37'),(17,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-08-07 01:06:07','2021-08-07 01:06:07'),(18,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-08-07 13:44:31','2021-08-07 13:44:31'),(19,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-08-07 13:57:04','2021-08-07 13:57:04'),(20,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-08-07 14:37:43','2021-08-07 14:37:43'),(21,'default','added',3,'App\\User',1,1,'App\\User','[]','2021-08-07 14:41:42','2021-08-07 14:41:42'),(22,'default','status_changed',5,'Modules\\Repair\\Entities\\JobSheet',1,1,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating\"}','2021-08-07 17:02:30','2021-08-07 17:02:30'),(23,'default','added',7,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250}}','2021-08-07 17:17:18','2021-08-07 17:17:18'),(24,'default','status_changed',5,'Modules\\Repair\\Entities\\JobSheet',1,1,'App\\User','{\"update_note\":null,\"updated_status\":\"Finished\"}','2021-08-07 17:31:46','2021-08-07 17:31:46'),(25,'default','status_changed',7,'App\\Transaction',1,1,'App\\User','{\"update_note\":\"done\",\"updated_status\":\"Finished\"}','2021-08-07 17:33:00','2021-08-07 17:33:00'),(26,'default','added',8,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250}}','2021-08-07 17:35:13','2021-08-07 17:35:13'),(27,'default','status_changed',6,'Modules\\Repair\\Entities\\JobSheet',1,1,'App\\User','{\"update_note\":\"waiting check\",\"updated_status\":\"In Progress\"}','2021-08-07 18:08:40','2021-08-07 18:08:40'),(28,'default','status_changed',6,'Modules\\Repair\\Entities\\JobSheet',1,1,'App\\User','{\"update_note\":\"Done\",\"updated_status\":\"Finished\"}','2021-08-07 18:10:04','2021-08-07 18:10:04'),(29,'default','added',9,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1750}}','2021-08-07 18:11:33','2021-08-07 18:11:33'),(30,'default','added',4,'App\\User',1,1,'App\\User','[]','2021-08-07 18:55:22','2021-08-07 18:55:22'),(31,'default','added',10,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-08-07 19:05:02','2021-08-07 19:05:02'),(32,'default','added',3,'App\\Contact',1,1,'App\\User','[]','2021-08-08 00:57:35','2021-08-08 00:57:35'),(33,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-08-08 14:58:33','2021-08-08 14:58:33'),(34,'default','added',4,'App\\Contact',1,1,'App\\User','[]','2021-08-08 14:59:47','2021-08-08 14:59:47'),(35,'default','status_changed',8,'Modules\\Repair\\Entities\\JobSheet',1,1,'App\\User','{\"update_note\":null,\"updated_status\":\"Finished\"}','2021-08-08 15:06:57','2021-08-08 15:06:57'),(36,'default','added',11,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250}}','2021-08-08 20:11:51','2021-08-08 20:11:51'),(37,'default','added',12,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250}}','2021-08-08 22:37:49','2021-08-08 22:37:49'),(38,'default','added',13,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250}}','2021-08-08 22:37:55','2021-08-08 22:37:55'),(39,'default','added',14,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-08-08 22:38:24','2021-08-08 22:38:24'),(40,'default','added',5,'App\\User',1,1,'App\\User','[]','2021-08-09 14:46:04','2021-08-09 14:46:04'),(41,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-08-09 18:25:23','2021-08-09 18:25:23'),(42,'default','status_changed',10,'Modules\\Repair\\Entities\\JobSheet',1,1,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-09 18:33:25','2021-08-09 18:33:25'),(43,'default','status_changed',11,'Modules\\Repair\\Entities\\JobSheet',1,1,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-09 18:33:37','2021-08-09 18:33:37'),(44,'default','added',15,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1}}','2021-08-09 18:35:30','2021-08-09 18:35:30'),(45,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-08-12 15:20:59','2021-08-12 15:20:59'),(46,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-08-12 18:49:45','2021-08-12 18:49:45'),(47,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-08-13 01:14:35','2021-08-13 01:14:35'),(48,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-08-13 21:19:26','2021-08-13 21:19:26'),(49,'default','added',5,'App\\Contact',1,1,'App\\User','[]','2021-08-13 21:20:53','2021-08-13 21:20:53'),(50,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-08-13 21:25:46','2021-08-13 21:25:46'),(51,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-08-16 14:16:18','2021-08-16 14:16:18'),(52,'default','edited',4,'App\\User',1,1,'App\\User','[]','2021-08-16 14:18:59','2021-08-16 14:18:59'),(53,'default','added',6,'App\\User',1,1,'App\\User','[]','2021-08-16 14:32:31','2021-08-16 14:32:31'),(54,'default','added',7,'App\\User',1,1,'App\\User','[]','2021-08-16 14:33:47','2021-08-16 14:33:47'),(55,'default','edited',7,'App\\User',1,1,'App\\User','[]','2021-08-16 14:34:18','2021-08-16 14:34:18'),(56,'default','added',8,'App\\User',1,1,'App\\User','[]','2021-08-16 14:35:54','2021-08-16 14:35:54'),(57,'default','added',9,'App\\User',1,1,'App\\User','[]','2021-08-16 15:05:05','2021-08-16 15:05:05'),(58,'default','added',6,'App\\Contact',1,1,'App\\User','[]','2021-08-16 15:08:07','2021-08-16 15:08:07'),(59,'default','status_changed',12,'Modules\\Repair\\Entities\\JobSheet',1,1,'App\\User','{\"update_note\":null,\"updated_status\":\"Finished\"}','2021-08-16 15:30:00','2021-08-16 15:30:00'),(60,'default','status_changed',12,'Modules\\Repair\\Entities\\JobSheet',1,1,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-16 15:30:10','2021-08-16 15:30:10'),(61,'default','status_changed',12,'Modules\\Repair\\Entities\\JobSheet',1,1,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-08-16 15:31:02','2021-08-16 15:31:02'),(62,'default','added',16,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":1000}}','2021-08-16 15:34:31','2021-08-16 15:34:31'),(63,'default','added',17,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":500}}','2021-08-16 15:39:16','2021-08-16 15:39:16'),(64,'default','status_changed',12,'Modules\\Repair\\Entities\\JobSheet',1,1,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-08-16 15:46:14','2021-08-16 15:46:14'),(65,'default','added',18,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":200}}','2021-08-16 15:52:14','2021-08-16 15:52:14'),(66,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-08-16 15:56:13','2021-08-16 15:56:13'),(67,'default','login',9,'App\\User',1,9,'App\\User','[]','2021-08-16 15:56:37','2021-08-16 15:56:37'),(68,'default','added',7,'App\\Contact',1,9,'App\\User','[]','2021-08-16 16:00:28','2021-08-16 16:00:28'),(69,'default','added',19,'App\\Transaction',1,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":1000}}','2021-08-16 16:00:37','2021-08-16 16:00:37'),(70,'default','added',20,'App\\Transaction',1,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":200}}','2021-08-16 16:04:31','2021-08-16 16:04:31'),(71,'default','logout',9,'App\\User',1,9,'App\\User','[]','2021-08-16 16:13:24','2021-08-16 16:13:24'),(72,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-08-16 16:13:33','2021-08-16 16:13:33'),(73,'default','edited',6,'App\\User',1,1,'App\\User','[]','2021-08-16 16:14:13','2021-08-16 16:14:13'),(74,'default','added',10,'App\\User',1,1,'App\\User','[]','2021-08-16 16:15:56','2021-08-16 16:15:56'),(75,'default','added',8,'App\\Contact',1,1,'App\\User','[]','2021-08-16 16:20:18','2021-08-16 16:20:18'),(76,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-08-16 16:20:37','2021-08-16 16:20:37'),(77,'default','added',9,'App\\Contact',1,4,'App\\User','[]','2021-08-16 16:34:33','2021-08-16 16:34:33'),(78,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-08-16 16:37:12','2021-08-16 16:37:12'),(79,'default','login',9,'App\\User',1,9,'App\\User','[]','2021-08-16 16:37:19','2021-08-16 16:37:19'),(80,'default','status_changed',14,'Modules\\Repair\\Entities\\JobSheet',1,9,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-08-16 16:38:47','2021-08-16 16:38:47'),(81,'default','status_changed',13,'Modules\\Repair\\Entities\\JobSheet',1,9,'App\\User','{\"update_note\":null,\"updated_status\":\"Can\'t be repaired\"}','2021-08-16 16:39:01','2021-08-16 16:39:01'),(82,'default','added',21,'App\\Transaction',1,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3000}}','2021-08-16 16:46:21','2021-08-16 16:46:21'),(83,'default','added',22,'App\\Transaction',1,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":1200}}','2021-08-16 16:47:23','2021-08-16 16:47:23'),(84,'default','logout',9,'App\\User',1,9,'App\\User','[]','2021-08-16 17:11:06','2021-08-16 17:11:06'),(85,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-08-16 17:11:13','2021-08-16 17:11:13'),(86,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-08-16 17:11:49','2021-08-16 17:11:49'),(87,'default','login',9,'App\\User',1,9,'App\\User','[]','2021-08-16 17:11:54','2021-08-16 17:11:54'),(88,'default','logout',9,'App\\User',1,9,'App\\User','[]','2021-08-16 17:15:09','2021-08-16 17:15:09'),(89,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-08-16 17:15:20','2021-08-16 17:15:20'),(90,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-08-16 17:18:57','2021-08-16 17:18:57'),(91,'default','login',9,'App\\User',1,9,'App\\User','[]','2021-08-16 17:19:06','2021-08-16 17:19:06'),(92,'default','logout',9,'App\\User',1,9,'App\\User','[]','2021-08-16 17:23:37','2021-08-16 17:23:37'),(93,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-08-16 17:23:44','2021-08-16 17:23:44'),(94,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-08-16 17:33:06','2021-08-16 17:33:06'),(95,'default','login',9,'App\\User',1,9,'App\\User','[]','2021-08-16 17:33:19','2021-08-16 17:33:19'),(96,'default','logout',9,'App\\User',1,9,'App\\User','[]','2021-08-16 17:35:57','2021-08-16 17:35:57'),(97,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-08-16 17:36:06','2021-08-16 17:36:06'),(98,'default','login',9,'App\\User',1,9,'App\\User','[]','2021-08-16 17:37:59','2021-08-16 17:37:59'),(99,'default','login',9,'App\\User',1,9,'App\\User','[]','2021-08-16 17:40:28','2021-08-16 17:40:28'),(100,'default','logout',9,'App\\User',1,9,'App\\User','[]','2021-08-16 17:45:59','2021-08-16 17:45:59'),(101,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-08-16 17:46:11','2021-08-16 17:46:11'),(102,'default','edited',4,'App\\User',1,1,'App\\User','[]','2021-08-16 17:51:44','2021-08-16 17:51:44'),(103,'default','added',10,'App\\Contact',1,9,'App\\User','[]','2021-08-16 17:53:18','2021-08-16 17:53:18'),(104,'default','added',23,'App\\Transaction',1,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}','2021-08-16 17:55:06','2021-08-16 17:55:06'),(105,'default','status_changed',17,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Check In Progress\"}','2021-08-16 17:55:12','2021-08-16 17:55:12'),(106,'default','added',24,'App\\Transaction',1,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}','2021-08-16 17:57:07','2021-08-16 17:57:07'),(107,'default','logout',9,'App\\User',1,9,'App\\User','[]','2021-08-16 18:04:15','2021-08-16 18:04:15'),(108,'default','login',9,'App\\User',1,9,'App\\User','[]','2021-08-16 18:04:22','2021-08-16 18:04:22'),(109,'default','added',25,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-08-16 18:06:54','2021-08-16 18:06:54'),(110,'default','edited',9,'App\\User',1,1,'App\\User','[]','2021-08-16 18:16:40','2021-08-16 18:16:40'),(111,'default','added',26,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5000}}','2021-08-16 18:26:32','2021-08-16 18:26:32'),(112,'default','added',27,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5000}}','2021-08-16 18:30:19','2021-08-16 18:30:19'),(113,'default','added',28,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-08-16 18:34:48','2021-08-16 18:34:48'),(114,'default','added',29,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250}}','2021-08-16 18:35:39','2021-08-16 18:35:39'),(115,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-08-16 18:38:29','2021-08-16 18:38:29'),(116,'default','login',9,'App\\User',1,9,'App\\User','[]','2021-08-16 18:38:33','2021-08-16 18:38:33'),(117,'default','added',11,'App\\Contact',1,9,'App\\User','[]','2021-08-16 18:40:14','2021-08-16 18:40:14'),(118,'default','added',30,'App\\Transaction',1,9,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-08-16 18:41:14','2021-08-16 18:41:14'),(119,'default','logout',9,'App\\User',1,9,'App\\User','[]','2021-08-16 19:08:59','2021-08-16 19:08:59'),(120,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-08-16 19:09:13','2021-08-16 19:09:13'),(121,'default','added',31,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-08-16 19:13:15','2021-08-16 19:13:15'),(122,'default','added',32,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":500}}','2021-08-16 19:18:28','2021-08-16 19:18:28'),(123,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-08-16 19:37:36','2021-08-16 19:37:36'),(124,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-08-16 19:37:47','2021-08-16 19:37:47'),(125,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-08-16 20:10:39','2021-08-16 20:10:39'),(126,'default','login',9,'App\\User',1,9,'App\\User','[]','2021-08-16 20:10:47','2021-08-16 20:10:47'),(127,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-08-16 21:10:38','2021-08-16 21:10:38'),(128,'default','login',9,'App\\User',1,9,'App\\User','[]','2021-08-16 22:34:33','2021-08-16 22:34:33'),(129,'default','login',9,'App\\User',1,9,'App\\User','[]','2021-08-16 22:35:23','2021-08-16 22:35:23'),(130,'default','login',9,'App\\User',1,9,'App\\User','[]','2021-08-16 22:43:24','2021-08-16 22:43:24'),(131,'default','login',9,'App\\User',1,9,'App\\User','[]','2021-08-16 23:24:30','2021-08-16 23:24:30'),(132,'default','login',9,'App\\User',1,9,'App\\User','[]','2021-08-17 14:48:07','2021-08-17 14:48:07'),(133,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-08-17 14:51:10','2021-08-17 14:51:10'),(134,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-08-17 15:10:01','2021-08-17 15:10:01'),(135,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-08-17 19:35:34','2021-08-17 19:35:34'),(136,'default','login',9,'App\\User',1,9,'App\\User','[]','2021-08-18 00:38:31','2021-08-18 00:38:31'),(137,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-08-19 14:38:56','2021-08-19 14:38:56'),(138,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-08-19 18:09:51','2021-08-19 18:09:51'),(139,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-08-19 18:34:39','2021-08-19 18:34:39'),(140,'default','added',12,'App\\Contact',1,4,'App\\User','[]','2021-08-19 18:36:43','2021-08-19 18:36:43'),(141,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-08-19 19:22:48','2021-08-19 19:22:48'),(142,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-08-19 19:25:02','2021-08-19 19:25:02'),(143,'default','added',13,'App\\Contact',1,4,'App\\User','[]','2021-08-19 21:35:34','2021-08-19 21:35:34'),(144,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-08-19 22:12:41','2021-08-19 22:12:41'),(145,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-08-21 14:16:34','2021-08-21 14:16:34'),(146,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-08-21 14:18:38','2021-08-21 14:18:38'),(147,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-08-21 14:18:44','2021-08-21 14:18:44'),(148,'default','added',14,'App\\Contact',1,4,'App\\User','[]','2021-08-21 14:19:52','2021-08-21 14:19:52'),(149,'default','added',33,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":200}}','2021-08-21 14:22:49','2021-08-21 14:22:49'),(150,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-08-21 15:16:03','2021-08-21 15:16:03'),(151,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-08-21 15:20:06','2021-08-21 15:20:06'),(152,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-08-21 15:20:16','2021-08-21 15:20:16'),(153,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-08-21 15:21:21','2021-08-21 15:21:21'),(154,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-08-21 15:21:45','2021-08-21 15:21:45'),(155,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-08-21 15:47:01','2021-08-21 15:47:01'),(156,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-08-21 15:47:13','2021-08-21 15:47:13'),(157,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-08-21 15:48:30','2021-08-21 15:48:30'),(158,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-08-21 15:48:47','2021-08-21 15:48:47'),(159,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-08-21 17:15:48','2021-08-21 17:15:48'),(160,'default','added',15,'App\\Contact',1,4,'App\\User','[]','2021-08-21 17:17:07','2021-08-21 17:17:07'),(161,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-08-21 17:53:27','2021-08-21 17:53:27'),(162,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-08-21 17:53:40','2021-08-21 17:53:40'),(163,'default','added',11,'App\\User',1,1,'App\\User','[]','2021-08-21 17:56:35','2021-08-21 17:56:35'),(164,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-08-21 18:02:02','2021-08-21 18:02:02'),(165,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-08-21 18:02:26','2021-08-21 18:02:26'),(166,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-08-21 23:48:14','2021-08-21 23:48:14'),(167,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-08-22 14:20:28','2021-08-22 14:20:28'),(168,'default','added',16,'App\\Contact',1,11,'App\\User','[]','2021-08-22 14:21:41','2021-08-22 14:21:41'),(169,'default','added',17,'App\\Contact',1,11,'App\\User','[]','2021-08-22 14:30:13','2021-08-22 14:30:13'),(170,'default','added',18,'App\\Contact',1,11,'App\\User','[]','2021-08-22 14:44:55','2021-08-22 14:44:55'),(171,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-08-22 15:02:11','2021-08-22 15:02:11'),(172,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-08-22 15:51:27','2021-08-22 15:51:27'),(173,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-08-22 15:54:47','2021-08-22 15:54:47'),(174,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-08-22 15:54:55','2021-08-22 15:54:55'),(175,'default','added',19,'App\\Contact',1,4,'App\\User','[]','2021-08-22 17:27:08','2021-08-22 17:27:08'),(176,'default','added',20,'App\\Contact',1,4,'App\\User','[]','2021-08-22 18:11:41','2021-08-22 18:11:41'),(177,'default','added',21,'App\\Contact',1,4,'App\\User','[]','2021-08-22 19:57:38','2021-08-22 19:57:38'),(178,'default','added',22,'App\\Contact',1,4,'App\\User','[]','2021-08-22 21:04:50','2021-08-22 21:04:50'),(179,'default','added',34,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1}}','2021-08-22 21:11:41','2021-08-22 21:11:41'),(180,'default','added',35,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":1850}}','2021-08-22 21:12:56','2021-08-22 21:12:56'),(181,'default','added',23,'App\\Contact',1,4,'App\\User','[]','2021-08-22 22:03:02','2021-08-22 22:03:02'),(182,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-08-22 22:15:21','2021-08-22 22:15:21'),(183,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-08-23 12:47:34','2021-08-23 12:47:34'),(184,'default','added',24,'App\\Contact',1,4,'App\\User','[]','2021-08-23 12:48:38','2021-08-23 12:48:38'),(185,'default','status_changed',30,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-08-23 13:08:56','2021-08-23 13:08:56'),(186,'default','status_changed',31,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-23 13:09:32','2021-08-23 13:09:32'),(187,'default','added',25,'App\\Contact',1,4,'App\\User','[]','2021-08-23 13:17:54','2021-08-23 13:17:54'),(188,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-08-23 13:38:47','2021-08-23 13:38:47'),(189,'default','status_changed',32,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Finished\"}','2021-08-23 13:40:24','2021-08-23 13:40:24'),(190,'default','status_changed',33,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Finished\"}','2021-08-23 13:40:51','2021-08-23 13:40:51'),(191,'default','added',26,'App\\Contact',1,4,'App\\User','[]','2021-08-23 14:42:46','2021-08-23 14:42:46'),(192,'default','added',27,'App\\Contact',1,11,'App\\User','[]','2021-08-23 14:43:24','2021-08-23 14:43:24'),(193,'default','added',28,'App\\Contact',1,4,'App\\User','[]','2021-08-23 15:06:23','2021-08-23 15:06:23'),(194,'default','added',29,'App\\Contact',1,11,'App\\User','[]','2021-08-23 15:13:10','2021-08-23 15:13:10'),(195,'default','added',30,'App\\Contact',1,4,'App\\User','[]','2021-08-23 16:39:58','2021-08-23 16:39:58'),(196,'default','added',31,'App\\Contact',1,11,'App\\User','[]','2021-08-23 16:51:07','2021-08-23 16:51:07'),(197,'default','added',32,'App\\Contact',1,4,'App\\User','[]','2021-08-23 17:06:27','2021-08-23 17:06:27'),(198,'default','status_changed',40,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Finished\"}','2021-08-23 18:28:18','2021-08-23 18:28:18'),(199,'default','status_changed',39,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Finished\"}','2021-08-23 18:29:01','2021-08-23 18:29:01'),(200,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-08-23 18:30:51','2021-08-23 18:30:51'),(201,'default','edited',4,'App\\User',1,1,'App\\User','[]','2021-08-23 18:32:24','2021-08-23 18:32:24'),(202,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-08-23 18:42:22','2021-08-23 18:42:22'),(203,'default','edited',10,'App\\User',1,1,'App\\User','[]','2021-08-23 18:47:13','2021-08-23 18:47:13'),(204,'default','edited',9,'App\\User',1,1,'App\\User','[]','2021-08-23 18:54:24','2021-08-23 18:54:24'),(205,'default','added',15,'App\\User',1,1,'App\\User','[]','2021-08-23 18:56:51','2021-08-23 18:56:51'),(206,'default','login',15,'App\\User',1,15,'App\\User','[]','2021-08-23 18:59:47','2021-08-23 18:59:47'),(207,'default','added',33,'App\\Contact',1,4,'App\\User','[]','2021-08-23 19:00:04','2021-08-23 19:00:04'),(208,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-08-23 19:01:03','2021-08-23 19:01:03'),(209,'default','login',15,'App\\User',1,15,'App\\User','[]','2021-08-23 19:05:33','2021-08-23 19:05:33'),(210,'default','added',34,'App\\Contact',1,4,'App\\User','[]','2021-08-23 19:21:12','2021-08-23 19:21:12'),(211,'default','added',35,'App\\Contact',1,11,'App\\User','[]','2021-08-23 19:55:43','2021-08-23 19:55:43'),(212,'default','status_changed',42,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Finished\"}','2021-08-23 20:12:25','2021-08-23 20:12:25'),(213,'default','status_changed',41,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Finished\"}','2021-08-23 20:12:55','2021-08-23 20:12:55'),(214,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-08-23 20:13:18','2021-08-23 20:13:18'),(215,'default','status_changed',44,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Finished\"}','2021-08-23 20:16:40','2021-08-23 20:16:40'),(216,'default','status_changed',43,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Finished\"}','2021-08-23 20:17:55','2021-08-23 20:17:55'),(217,'default','status_changed',29,'Modules\\Repair\\Entities\\JobSheet',1,1,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-23 20:19:09','2021-08-23 20:19:09'),(218,'default','status_changed',44,'Modules\\Repair\\Entities\\JobSheet',1,1,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-23 20:20:44','2021-08-23 20:20:44'),(219,'default','status_changed',30,'Modules\\Repair\\Entities\\JobSheet',1,1,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-23 20:21:11','2021-08-23 20:21:11'),(220,'default','status_changed',45,'Modules\\Repair\\Entities\\JobSheet',1,1,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-08-23 20:21:32','2021-08-23 20:21:32'),(221,'default','status_changed',38,'Modules\\Repair\\Entities\\JobSheet',1,1,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-23 20:21:48','2021-08-23 20:21:48'),(222,'default','status_changed',46,'Modules\\Repair\\Entities\\JobSheet',1,1,'App\\User','{\"update_note\":null,\"updated_status\":\"Check In Progress\"}','2021-08-23 20:29:31','2021-08-23 20:29:31'),(223,'default','status_changed',44,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-23 20:36:45','2021-08-23 20:36:45'),(224,'default','added',36,'App\\Contact',1,1,'App\\User','[]','2021-08-23 20:37:11','2021-08-23 20:37:11'),(225,'default','added',37,'App\\Contact',1,4,'App\\User','[]','2021-08-23 20:51:29','2021-08-23 20:51:29'),(226,'default','added',38,'App\\Contact',1,4,'App\\User','[]','2021-08-23 20:55:49','2021-08-23 20:55:49'),(227,'default','added',36,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":1100}}','2021-08-23 20:58:07','2021-08-23 20:58:07'),(228,'default','status_changed',35,'App\\Transaction',1,1,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-08-23 21:24:18','2021-08-23 21:24:18'),(229,'default','status_changed',45,'Modules\\Repair\\Entities\\JobSheet',1,1,'App\\User','{\"update_note\":null,\"updated_status\":\"Finished\"}','2021-08-23 21:45:11','2021-08-23 21:45:11'),(230,'default','status_changed',44,'Modules\\Repair\\Entities\\JobSheet',1,1,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-23 21:48:32','2021-08-23 21:48:32'),(231,'default','status_changed',31,'Modules\\Repair\\Entities\\JobSheet',1,1,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-23 21:48:42','2021-08-23 21:48:42'),(232,'default','added',37,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-08-23 21:50:22','2021-08-23 21:50:22'),(233,'default','added',38,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-08-23 22:02:05','2021-08-23 22:02:05'),(234,'default','status_changed',37,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-23 22:02:33','2021-08-23 22:02:33'),(235,'default','status_changed',34,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-23 22:12:55','2021-08-23 22:12:55'),(236,'default','added',39,'App\\Contact',1,4,'App\\User','[]','2021-08-23 22:18:21','2021-08-23 22:18:21'),(237,'default','added',40,'App\\Contact',1,4,'App\\User','[]','2021-08-23 22:46:36','2021-08-23 22:46:36'),(238,'default','added',41,'App\\Contact',1,4,'App\\User','[]','2021-08-23 23:03:49','2021-08-23 23:03:49'),(239,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-08-24 12:04:12','2021-08-24 12:04:12'),(240,'default','added',39,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-08-24 12:07:52','2021-08-24 12:07:52'),(241,'default','status_changed',41,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-24 12:08:19','2021-08-24 12:08:19'),(242,'default','added',40,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":650}}','2021-08-24 12:12:20','2021-08-24 12:12:20'),(243,'default','added',41,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-08-24 12:15:51','2021-08-24 12:15:51'),(244,'default','added',42,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-08-24 12:21:09','2021-08-24 12:21:09'),(245,'default','status_changed',32,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-24 12:22:47','2021-08-24 12:22:47'),(246,'default','status_changed',33,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-24 12:23:04','2021-08-24 12:23:04'),(247,'default','added',43,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1}}','2021-08-24 12:24:48','2021-08-24 12:24:48'),(248,'default','added',44,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-08-24 12:25:45','2021-08-24 12:25:45'),(249,'default','added',45,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-08-24 12:27:51','2021-08-24 12:27:51'),(250,'default','added',42,'App\\Contact',1,4,'App\\User','[]','2021-08-24 12:30:22','2021-08-24 12:30:22'),(251,'default','status_changed',38,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-24 12:57:50','2021-08-24 12:57:50'),(252,'default','added',46,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-08-24 12:58:30','2021-08-24 12:58:30'),(253,'default','added',43,'App\\Contact',1,4,'App\\User','[]','2021-08-24 13:40:01','2021-08-24 13:40:01'),(254,'default','added',44,'App\\Contact',1,11,'App\\User','[]','2021-08-24 13:50:01','2021-08-24 13:50:01'),(255,'default','added',45,'App\\Contact',1,4,'App\\User','[]','2021-08-24 13:52:41','2021-08-24 13:52:41'),(256,'default','added',46,'App\\Contact',1,4,'App\\User','[]','2021-08-24 14:39:12','2021-08-24 14:39:12'),(257,'default','added',47,'App\\Contact',1,11,'App\\User','[]','2021-08-24 14:48:08','2021-08-24 14:48:08'),(258,'default','added',48,'App\\Contact',1,4,'App\\User','[]','2021-08-24 14:48:50','2021-08-24 14:48:50'),(259,'default','added',49,'App\\Contact',1,4,'App\\User','[]','2021-08-24 14:53:39','2021-08-24 14:53:39'),(260,'default','status_changed',38,'App\\Transaction',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-24 15:06:04','2021-08-24 15:06:04'),(261,'default','status_changed',39,'App\\Transaction',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-24 15:07:09','2021-08-24 15:07:09'),(262,'default','status_changed',45,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-24 15:10:11','2021-08-24 15:10:11'),(263,'default','status_changed',39,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-24 15:10:24','2021-08-24 15:10:24'),(264,'default','status_changed',40,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-24 15:10:48','2021-08-24 15:10:48'),(265,'default','status_changed',42,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-24 15:11:00','2021-08-24 15:11:00'),(266,'default','status_changed',43,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-24 15:11:15','2021-08-24 15:11:15'),(267,'default','added',50,'App\\Contact',1,4,'App\\User','[]','2021-08-24 15:37:40','2021-08-24 15:37:40'),(268,'default','added',51,'App\\Contact',1,4,'App\\User','[]','2021-08-24 15:37:40','2021-08-24 15:37:40'),(269,'default','status_changed',53,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-24 15:57:47','2021-08-24 15:57:47'),(270,'default','added',47,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":125}}','2021-08-24 16:24:45','2021-08-24 16:24:45'),(271,'default','added',52,'App\\Contact',1,4,'App\\User','[]','2021-08-24 16:41:38','2021-08-24 16:41:38'),(272,'default','added',53,'App\\Contact',1,4,'App\\User','[]','2021-08-24 16:57:52','2021-08-24 16:57:52'),(273,'default','added',54,'App\\Contact',1,4,'App\\User','[]','2021-08-24 17:02:17','2021-08-24 17:02:17'),(274,'default','added',55,'App\\Contact',1,4,'App\\User','[]','2021-08-24 17:06:25','2021-08-24 17:06:25'),(275,'default','added',56,'App\\Contact',1,4,'App\\User','[]','2021-08-24 17:08:23','2021-08-24 17:08:23'),(276,'default','added',57,'App\\Contact',1,11,'App\\User','[]','2021-08-24 17:17:55','2021-08-24 17:17:55'),(277,'default','added',58,'App\\Contact',1,11,'App\\User','[]','2021-08-24 17:20:51','2021-08-24 17:20:51'),(278,'default','added',48,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-08-24 17:50:38','2021-08-24 17:50:38'),(279,'default','status_changed',57,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Can\'t be repaired\"}','2021-08-24 17:59:13','2021-08-24 17:59:13'),(280,'default','status_changed',58,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Can\'t be repaired\"}','2021-08-24 17:59:28','2021-08-24 17:59:28'),(281,'default','status_changed',49,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-24 18:00:35','2021-08-24 18:00:35'),(282,'default','status_changed',54,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-24 18:01:45','2021-08-24 18:01:45'),(283,'default','added',59,'App\\Contact',1,4,'App\\User','[]','2021-08-24 18:23:33','2021-08-24 18:23:33'),(284,'default','added',60,'App\\Contact',1,4,'App\\User','[]','2021-08-24 18:25:08','2021-08-24 18:25:08'),(285,'default','added',61,'App\\Contact',1,4,'App\\User','[]','2021-08-24 18:37:52','2021-08-24 18:37:52'),(286,'default','added',62,'App\\Contact',1,4,'App\\User','[]','2021-08-24 18:43:48','2021-08-24 18:43:48'),(287,'default','status_changed',56,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-24 18:54:19','2021-08-24 18:54:19'),(288,'default','status_changed',51,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-24 18:54:55','2021-08-24 18:54:55'),(289,'default','status_changed',49,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-24 19:04:50','2021-08-24 19:04:50'),(290,'default','added',49,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-08-24 19:05:27','2021-08-24 19:05:27'),(291,'default','added',50,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-08-24 19:13:28','2021-08-24 19:13:28'),(292,'default','added',63,'App\\Contact',1,4,'App\\User','[]','2021-08-24 19:22:06','2021-08-24 19:22:06'),(293,'default','added',64,'App\\Contact',1,4,'App\\User','[]','2021-08-24 19:28:09','2021-08-24 19:28:09'),(294,'default','added',51,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-08-24 19:38:33','2021-08-24 19:38:33'),(295,'default','status_changed',60,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-24 19:38:59','2021-08-24 19:38:59'),(296,'default','status_changed',55,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-24 19:40:18','2021-08-24 19:40:18'),(297,'default','status_changed',43,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-24 20:11:54','2021-08-24 20:11:54'),(298,'default','added',52,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-08-24 20:13:06','2021-08-24 20:13:06'),(299,'default','added',65,'App\\Contact',1,4,'App\\User','[]','2021-08-24 20:52:16','2021-08-24 20:52:16'),(300,'default','added',66,'App\\Contact',1,4,'App\\User','[]','2021-08-24 21:39:16','2021-08-24 21:39:16'),(301,'default','added',67,'App\\Contact',1,11,'App\\User','[]','2021-08-24 21:42:54','2021-08-24 21:42:54'),(302,'default','status_changed',61,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-24 22:02:15','2021-08-24 22:02:15'),(303,'default','added',53,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-08-24 22:03:40','2021-08-24 22:03:40'),(304,'default','added',54,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-08-24 22:10:36','2021-08-24 22:10:36'),(305,'default','status_changed',51,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-24 22:11:28','2021-08-24 22:11:28'),(306,'default','added',68,'App\\Contact',1,11,'App\\User','[]','2021-08-24 23:29:14','2021-08-24 23:29:14'),(307,'default','added',55,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-08-24 23:32:46','2021-08-24 23:32:46'),(308,'default','added',56,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":1000}}','2021-08-24 23:35:47','2021-08-24 23:35:47'),(309,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-08-25 12:26:34','2021-08-25 12:26:34'),(310,'default','status_changed',53,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-25 12:55:35','2021-08-25 12:55:35'),(311,'default','status_changed',54,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-25 12:55:46','2021-08-25 12:55:46'),(312,'default','added',57,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-08-25 12:56:15','2021-08-25 12:56:15'),(313,'default','added',58,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-08-25 12:58:28','2021-08-25 12:58:28'),(314,'default','added',69,'App\\Contact',1,4,'App\\User','[]','2021-08-25 13:26:45','2021-08-25 13:26:45'),(315,'default','added',70,'App\\Contact',1,4,'App\\User','[]','2021-08-25 14:02:35','2021-08-25 14:02:35'),(316,'default','added',71,'App\\Contact',1,4,'App\\User','[]','2021-08-25 14:11:14','2021-08-25 14:11:14'),(317,'default','added',59,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-08-25 14:20:21','2021-08-25 14:20:21'),(318,'default','status_changed',67,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-25 14:26:09','2021-08-25 14:26:09'),(319,'default','added',72,'App\\Contact',1,4,'App\\User','[]','2021-08-25 15:01:49','2021-08-25 15:01:49'),(320,'default','added',73,'App\\Contact',1,4,'App\\User','[]','2021-08-25 15:06:53','2021-08-25 15:06:53'),(321,'default','added',60,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-08-25 15:08:46','2021-08-25 15:08:46'),(322,'default','added',74,'App\\Contact',1,11,'App\\User','[]','2021-08-25 15:13:34','2021-08-25 15:13:34'),(323,'default','added',61,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-08-25 15:25:53','2021-08-25 15:25:53'),(324,'default','added',75,'App\\Contact',1,4,'App\\User','[]','2021-08-25 15:37:42','2021-08-25 15:37:42'),(325,'default','added',76,'App\\Contact',1,4,'App\\User','[]','2021-08-25 15:47:32','2021-08-25 15:47:32'),(326,'default','added',77,'App\\Contact',1,4,'App\\User','[]','2021-08-25 16:09:37','2021-08-25 16:09:37'),(327,'default','status_changed',39,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-25 16:21:27','2021-08-25 16:21:27'),(328,'default','status_changed',40,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-25 16:21:59','2021-08-25 16:21:59'),(329,'default','status_changed',64,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-25 16:22:52','2021-08-25 16:22:52'),(330,'default','status_changed',50,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-25 16:23:12','2021-08-25 16:23:12'),(331,'default','added',78,'App\\Contact',1,4,'App\\User','[]','2021-08-25 16:33:00','2021-08-25 16:33:00'),(332,'default','added',79,'App\\Contact',1,4,'App\\User','[]','2021-08-25 16:45:21','2021-08-25 16:45:21'),(333,'default','added',80,'App\\Contact',1,4,'App\\User','[]','2021-08-25 17:12:05','2021-08-25 17:12:05'),(334,'default','status_changed',79,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-25 18:41:56','2021-08-25 18:41:56'),(335,'default','added',62,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-08-25 18:42:55','2021-08-25 18:42:55'),(336,'default','added',81,'App\\Contact',1,4,'App\\User','[]','2021-08-25 19:06:19','2021-08-25 19:06:19'),(337,'default','added',82,'App\\Contact',1,4,'App\\User','[]','2021-08-25 19:59:05','2021-08-25 19:59:05'),(338,'default','added',83,'App\\Contact',1,4,'App\\User','[]','2021-08-25 20:07:55','2021-08-25 20:07:55'),(339,'default','added',84,'App\\Contact',1,4,'App\\User','[]','2021-08-25 20:12:44','2021-08-25 20:12:44'),(340,'default','added',85,'App\\Contact',1,4,'App\\User','[]','2021-08-25 20:21:17','2021-08-25 20:21:17'),(341,'default','added',63,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-08-25 20:47:15','2021-08-25 20:47:15'),(342,'default','status_changed',52,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-25 21:33:07','2021-08-25 21:33:07'),(343,'default','added',64,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-08-25 21:34:49','2021-08-25 21:34:49'),(344,'default','added',65,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":375}}','2021-08-25 21:38:02','2021-08-25 21:38:02'),(345,'default','status_changed',59,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":\"\\u0631\\u0641\\u0636 \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644 \\u0627\\u0644\\u0627\\u0635\\u0644\\u0627\\u062d \\u0627\\u0644\\u062a\\u0643\\u0644\\u0641\\u0647 \\u0643\\u0628\\u064a\\u0631\\u0647\",\"updated_status\":\"Ready for client\"}','2021-08-25 21:42:11','2021-08-25 21:42:11'),(346,'default','status_changed',83,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-25 21:57:35','2021-08-25 21:57:35'),(347,'default','added',66,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-08-25 21:58:32','2021-08-25 21:58:32'),(348,'default','added',67,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-08-25 22:04:37','2021-08-25 22:04:37'),(349,'default','status_changed',72,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-25 22:05:12','2021-08-25 22:05:12'),(350,'default','added',68,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-08-25 22:26:02','2021-08-25 22:26:02'),(351,'default','status_changed',81,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-25 22:27:28','2021-08-25 22:27:28'),(352,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-08-25 22:46:34','2021-08-25 22:46:34'),(353,'default','status_changed',35,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-25 22:49:59','2021-08-25 22:49:59'),(354,'default','added',69,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":850}}','2021-08-25 22:54:17','2021-08-25 22:54:17'),(355,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-08-26 13:18:28','2021-08-26 13:18:28'),(356,'default','added',86,'App\\Contact',1,4,'App\\User','[]','2021-08-26 14:02:13','2021-08-26 14:02:13'),(357,'default','added',87,'App\\Contact',1,4,'App\\User','[]','2021-08-26 14:16:51','2021-08-26 14:16:51'),(358,'default','added',88,'App\\Contact',1,4,'App\\User','[]','2021-08-26 15:32:48','2021-08-26 15:32:48'),(359,'default','added',70,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":175}}','2021-08-26 15:58:01','2021-08-26 15:58:01'),(360,'default','status_changed',80,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-26 15:58:31','2021-08-26 15:58:31'),(361,'default','added',89,'App\\Contact',1,4,'App\\User','[]','2021-08-26 17:32:42','2021-08-26 17:32:42'),(362,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-08-27 14:28:52','2021-08-27 14:28:52'),(363,'default','added',90,'App\\Contact',1,4,'App\\User','[]','2021-08-27 14:29:39','2021-08-27 14:29:39'),(364,'default','added',91,'App\\Contact',1,4,'App\\User','[]','2021-08-27 14:43:40','2021-08-27 14:43:40'),(365,'default','added',92,'App\\Contact',1,4,'App\\User','[]','2021-08-27 14:45:49','2021-08-27 14:45:49'),(366,'default','added',93,'App\\Contact',1,4,'App\\User','[]','2021-08-27 19:29:39','2021-08-27 19:29:39'),(367,'default','added',94,'App\\Contact',1,4,'App\\User','[]','2021-08-27 20:35:02','2021-08-27 20:35:02'),(368,'default','added',95,'App\\Contact',1,4,'App\\User','[]','2021-08-27 21:17:17','2021-08-27 21:17:17'),(369,'default','added',96,'App\\Contact',1,4,'App\\User','[]','2021-08-27 21:17:59','2021-08-27 21:17:59'),(370,'default','added',97,'App\\Contact',1,4,'App\\User','[]','2021-08-27 21:22:39','2021-08-27 21:22:39'),(371,'default','added',98,'App\\Contact',1,4,'App\\User','[]','2021-08-27 22:01:09','2021-08-27 22:01:09'),(372,'default','added',99,'App\\Contact',1,4,'App\\User','[]','2021-08-27 22:38:02','2021-08-27 22:38:02'),(373,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-08-28 13:59:15','2021-08-28 13:59:15'),(374,'default','added',100,'App\\Contact',1,4,'App\\User','[]','2021-08-28 14:00:11','2021-08-28 14:00:11'),(375,'default','added',101,'App\\Contact',1,4,'App\\User','[]','2021-08-28 15:20:51','2021-08-28 15:20:51'),(376,'default','added',102,'App\\Contact',1,4,'App\\User','[]','2021-08-28 15:29:49','2021-08-28 15:29:49'),(377,'default','added',103,'App\\Contact',1,11,'App\\User','[]','2021-08-28 15:51:36','2021-08-28 15:51:36'),(378,'default','added',104,'App\\Contact',1,4,'App\\User','[]','2021-08-28 16:22:28','2021-08-28 16:22:28'),(379,'default','added',105,'App\\Contact',1,4,'App\\User','[]','2021-08-28 17:11:43','2021-08-28 17:11:43'),(380,'default','added',106,'App\\Contact',1,4,'App\\User','[]','2021-08-28 17:43:04','2021-08-28 17:43:04'),(381,'default','added',107,'App\\Contact',1,11,'App\\User','[]','2021-08-28 17:43:23','2021-08-28 17:43:23'),(382,'default','added',108,'App\\Contact',1,4,'App\\User','[]','2021-08-28 17:50:26','2021-08-28 17:50:26'),(383,'default','added',109,'App\\Contact',1,4,'App\\User','[]','2021-08-28 18:13:09','2021-08-28 18:13:09'),(384,'default','added',71,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-08-28 18:39:46','2021-08-28 18:39:46'),(385,'default','status_changed',101,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-28 18:41:42','2021-08-28 18:41:42'),(386,'default','added',110,'App\\Contact',1,4,'App\\User','[]','2021-08-28 19:06:51','2021-08-28 19:06:51'),(387,'default','added',111,'App\\Contact',1,11,'App\\User','[]','2021-08-28 19:25:55','2021-08-28 19:25:55'),(388,'default','added',112,'App\\Contact',1,4,'App\\User','[]','2021-08-28 20:53:07','2021-08-28 20:53:07'),(389,'default','added',113,'App\\Contact',1,4,'App\\User','[]','2021-08-28 21:02:39','2021-08-28 21:02:39'),(390,'default','added',114,'App\\Contact',1,4,'App\\User','[]','2021-08-28 21:22:11','2021-08-28 21:22:11'),(391,'default','added',115,'App\\Contact',1,4,'App\\User','[]','2021-08-28 21:28:21','2021-08-28 21:28:21'),(392,'default','added',116,'App\\Contact',1,4,'App\\User','[]','2021-08-28 22:13:21','2021-08-28 22:13:21'),(393,'default','status_changed',109,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-28 22:46:45','2021-08-28 22:46:45'),(394,'default','added',117,'App\\Contact',1,4,'App\\User','[]','2021-08-28 22:55:04','2021-08-28 22:55:04'),(395,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-08-29 12:08:25','2021-08-29 12:08:25'),(396,'default','added',118,'App\\Contact',1,4,'App\\User','[]','2021-08-29 12:09:38','2021-08-29 12:09:38'),(397,'default','added',119,'App\\Contact',1,4,'App\\User','[]','2021-08-29 12:58:14','2021-08-29 12:58:14'),(398,'default','added',120,'App\\Contact',1,4,'App\\User','[]','2021-08-29 13:02:45','2021-08-29 13:02:45'),(399,'default','status_changed',42,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-29 15:17:10','2021-08-29 15:17:10'),(400,'default','added',72,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1100}}','2021-08-29 15:18:38','2021-08-29 15:18:38'),(401,'default','added',73,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}','2021-08-29 16:28:16','2021-08-29 16:28:16'),(402,'default','status_changed',71,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-29 16:28:35','2021-08-29 16:28:35'),(403,'default','added',74,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}','2021-08-29 16:29:05','2021-08-29 16:29:05'),(404,'default','status_changed',36,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-29 16:29:20','2021-08-29 16:29:20'),(405,'default','added',75,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-08-29 16:30:52','2021-08-29 16:30:52'),(406,'default','status_changed',55,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-29 16:31:08','2021-08-29 16:31:08'),(407,'default','status_changed',63,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-29 16:32:39','2021-08-29 16:32:39'),(408,'default','status_changed',65,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-29 16:32:55','2021-08-29 16:32:55'),(409,'default','added',76,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-08-29 16:35:03','2021-08-29 16:35:03'),(410,'default','status_changed',75,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-29 16:35:35','2021-08-29 16:35:35'),(411,'default','status_changed',66,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-29 16:37:25','2021-08-29 16:37:25'),(412,'default','status_changed',74,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-29 16:37:39','2021-08-29 16:37:39'),(413,'default','added',77,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-08-29 16:38:09','2021-08-29 16:38:09'),(414,'default','status_changed',68,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-29 16:38:37','2021-08-29 16:38:37'),(415,'default','status_changed',88,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-29 16:42:14','2021-08-29 16:42:14'),(416,'default','added',78,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-08-29 16:45:03','2021-08-29 16:45:03'),(417,'default','added',79,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-08-29 16:47:59','2021-08-29 16:47:59'),(418,'default','status_changed',92,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-29 16:48:41','2021-08-29 16:48:41'),(419,'default','status_changed',78,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-29 16:49:17','2021-08-29 16:49:17'),(420,'default','added',80,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-08-29 16:51:06','2021-08-29 16:51:06'),(421,'default','status_changed',84,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-29 16:52:34','2021-08-29 16:52:34'),(422,'default','added',81,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-08-29 16:54:19','2021-08-29 16:54:19'),(423,'default','status_changed',102,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-29 16:54:44','2021-08-29 16:54:44'),(424,'default','status_changed',99,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-29 16:58:33','2021-08-29 16:58:33'),(425,'default','added',121,'App\\Contact',1,11,'App\\User','[]','2021-08-29 17:15:29','2021-08-29 17:15:29'),(426,'default','status_changed',100,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":\"\\u0628\\u0648\\u0631\\u062f\\u0647\",\"updated_status\":\"DELIVERED\"}','2021-08-29 17:28:04','2021-08-29 17:28:04'),(427,'default','status_changed',59,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":\"\\u0631\\u0641\\u0636 \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644 \\u0627\\u0644\\u0627\\u0635\\u0644\\u0627\\u062d\",\"updated_status\":\"Ready for client\"}','2021-08-29 17:28:55','2021-08-29 17:28:55'),(428,'default','status_changed',59,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-29 17:29:03','2021-08-29 17:29:03'),(429,'default','added',122,'App\\Contact',1,4,'App\\User','[]','2021-08-29 17:49:30','2021-08-29 17:49:30'),(430,'default','added',123,'App\\Contact',1,4,'App\\User','[]','2021-08-29 18:04:10','2021-08-29 18:04:10'),(431,'default','status_changed',41,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-08-29 18:12:40','2021-08-29 18:12:40'),(432,'default','added',124,'App\\Contact',1,4,'App\\User','[]','2021-08-29 18:48:13','2021-08-29 18:48:13'),(433,'default','status_changed',117,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-29 18:56:49','2021-08-29 18:56:49'),(434,'default','added',82,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-08-29 18:59:03','2021-08-29 18:59:03'),(435,'default','added',125,'App\\Contact',1,11,'App\\User','[]','2021-08-29 19:39:35','2021-08-29 19:39:35'),(436,'default','added',126,'App\\Contact',1,11,'App\\User','[]','2021-08-29 20:04:15','2021-08-29 20:04:15'),(437,'default','added',127,'App\\Contact',1,11,'App\\User','[]','2021-08-29 20:15:05','2021-08-29 20:15:05'),(438,'default','status_changed',122,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-29 20:22:39','2021-08-29 20:22:39'),(439,'default','status_changed',116,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Can\'t be repaired\"}','2021-08-29 20:36:15','2021-08-29 20:36:15'),(440,'default','added',128,'App\\Contact',1,4,'App\\User','[]','2021-08-29 20:38:39','2021-08-29 20:38:39'),(441,'default','status_changed',114,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-29 20:49:03','2021-08-29 20:49:03'),(442,'default','added',83,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-08-29 20:51:06','2021-08-29 20:51:06'),(443,'default','status_changed',85,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-29 20:54:24','2021-08-29 20:54:24'),(444,'default','added',84,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-08-29 20:55:13','2021-08-29 20:55:13'),(445,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-08-29 20:57:38','2021-08-29 20:57:38'),(446,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-08-29 20:58:00','2021-08-29 20:58:00'),(447,'default','added',129,'App\\Contact',1,4,'App\\User','[]','2021-08-29 21:07:11','2021-08-29 21:07:11'),(448,'default','added',130,'App\\Contact',1,4,'App\\User','[]','2021-08-29 21:10:04','2021-08-29 21:10:04'),(449,'default','added',131,'App\\Contact',1,11,'App\\User','[]','2021-08-29 21:15:45','2021-08-29 21:15:45'),(450,'default','added',132,'App\\Contact',1,4,'App\\User','[]','2021-08-29 21:21:52','2021-08-29 21:21:52'),(451,'default','added',133,'App\\Contact',1,11,'App\\User','[]','2021-08-29 21:23:19','2021-08-29 21:23:19'),(452,'default','added',134,'App\\Contact',1,11,'App\\User','[]','2021-08-29 21:29:04','2021-08-29 21:29:04'),(453,'default','status_changed',120,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-29 21:41:00','2021-08-29 21:41:00'),(454,'default','added',85,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-08-29 21:41:38','2021-08-29 21:41:38'),(455,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-08-30 13:04:36','2021-08-30 13:04:36'),(456,'default','added',86,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-08-30 13:29:09','2021-08-30 13:29:09'),(457,'default','status_changed',103,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-30 13:29:36','2021-08-30 13:29:36'),(458,'default','added',87,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":175}}','2021-08-30 15:07:25','2021-08-30 15:07:25'),(459,'default','status_changed',111,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-30 15:07:43','2021-08-30 15:07:43'),(460,'default','added',88,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-08-30 15:33:23','2021-08-30 15:33:23'),(461,'default','status_changed',70,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-30 15:41:48','2021-08-30 15:41:48'),(462,'default','added',89,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-08-30 15:48:08','2021-08-30 15:48:08'),(463,'default','status_changed',89,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-30 15:48:53','2021-08-30 15:48:53'),(464,'default','status_changed',57,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-30 15:53:29','2021-08-30 15:53:29'),(465,'default','status_changed',58,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-30 15:53:37','2021-08-30 15:53:37'),(466,'default','status_changed',110,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-30 15:54:39','2021-08-30 15:54:39'),(467,'default','status_changed',123,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-08-30 16:02:44','2021-08-30 16:02:44'),(468,'default','status_changed',113,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-08-30 16:02:59','2021-08-30 16:02:59'),(469,'default','status_changed',127,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-08-30 16:03:21','2021-08-30 16:03:21'),(470,'default','added',135,'App\\Contact',1,4,'App\\User','[]','2021-08-30 16:21:36','2021-08-30 16:21:36'),(471,'default','added',136,'App\\Contact',1,4,'App\\User','[]','2021-08-30 17:11:41','2021-08-30 17:11:41'),(472,'default','added',90,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-08-30 17:29:06','2021-08-30 17:29:06'),(473,'default','status_changed',93,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-30 17:29:30','2021-08-30 17:29:30'),(474,'default','added',137,'App\\Contact',1,4,'App\\User','[]','2021-08-30 17:49:40','2021-08-30 17:49:40'),(475,'default','added',138,'App\\Contact',1,4,'App\\User','[]','2021-08-30 18:23:10','2021-08-30 18:23:10'),(476,'default','added',139,'App\\Contact',1,4,'App\\User','[]','2021-08-30 19:07:07','2021-08-30 19:07:07'),(477,'default','added',140,'App\\Contact',1,4,'App\\User','[]','2021-08-30 19:27:42','2021-08-30 19:27:42'),(478,'default','added',141,'App\\Contact',1,4,'App\\User','[]','2021-08-30 19:37:04','2021-08-30 19:37:04'),(479,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-08-30 20:14:07','2021-08-30 20:14:07'),(480,'default','added',142,'App\\Contact',1,11,'App\\User','[]','2021-08-30 20:16:18','2021-08-30 20:16:18'),(481,'default','added',91,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}','2021-08-30 20:39:44','2021-08-30 20:39:44'),(482,'default','status_changed',128,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-30 20:40:39','2021-08-30 20:40:39'),(483,'default','added',92,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-08-30 20:42:00','2021-08-30 20:42:00'),(484,'default','status_changed',115,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-30 20:42:23','2021-08-30 20:42:23'),(485,'default','added',93,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-08-30 20:43:02','2021-08-30 20:43:02'),(486,'default','status_changed',129,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-30 20:43:30','2021-08-30 20:43:30'),(487,'default','added',94,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-08-30 20:44:33','2021-08-30 20:44:33'),(488,'default','status_changed',121,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-30 20:45:24','2021-08-30 20:45:24'),(489,'default','added',95,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-08-30 20:46:11','2021-08-30 20:46:11'),(490,'default','status_changed',135,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-30 20:46:36','2021-08-30 20:46:36'),(491,'default','added',143,'App\\Contact',1,11,'App\\User','[]','2021-08-30 21:21:54','2021-08-30 21:21:54'),(492,'default','added',144,'App\\Contact',1,4,'App\\User','[]','2021-08-30 22:01:04','2021-08-30 22:01:04'),(493,'default','added',145,'App\\Contact',1,4,'App\\User','[]','2021-08-30 22:32:05','2021-08-30 22:32:05'),(494,'default','added',146,'App\\Contact',1,4,'App\\User','[]','2021-08-30 22:36:12','2021-08-30 22:36:12'),(495,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-08-31 12:11:15','2021-08-31 12:11:15'),(496,'default','added',147,'App\\Contact',1,4,'App\\User','[]','2021-08-31 12:59:08','2021-08-31 12:59:08'),(497,'default','added',148,'App\\Contact',1,4,'App\\User','[]','2021-08-31 13:10:18','2021-08-31 13:10:18'),(498,'default','added',96,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-08-31 14:13:45','2021-08-31 14:13:45'),(499,'default','status_changed',137,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-31 14:13:58','2021-08-31 14:13:58'),(500,'default','status_changed',46,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-31 14:16:44','2021-08-31 14:16:44'),(501,'default','status_changed',41,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-31 14:18:29','2021-08-31 14:18:29'),(502,'default','status_changed',119,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-31 14:20:24','2021-08-31 14:20:24'),(503,'default','added',97,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-08-31 14:21:26','2021-08-31 14:21:26'),(504,'default','status_changed',104,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-31 14:21:48','2021-08-31 14:21:48'),(505,'default','added',98,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-08-31 14:23:26','2021-08-31 14:23:26'),(506,'default','status_changed',105,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-31 14:23:40','2021-08-31 14:23:40'),(507,'default','status_changed',106,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Can\'t be repaired\"}','2021-08-31 14:24:00','2021-08-31 14:24:00'),(508,'default','status_changed',107,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-31 14:24:17','2021-08-31 14:24:17'),(509,'default','added',99,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-08-31 14:25:10','2021-08-31 14:25:10'),(510,'default','status_changed',108,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-31 14:25:23','2021-08-31 14:25:23'),(511,'default','status_changed',124,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-08-31 14:25:44','2021-08-31 14:25:44'),(512,'default','status_changed',126,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-08-31 14:26:01','2021-08-31 14:26:01'),(513,'default','status_changed',94,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-31 14:26:13','2021-08-31 14:26:13'),(514,'default','added',100,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-08-31 14:31:39','2021-08-31 14:31:39'),(515,'default','status_changed',97,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-31 14:32:08','2021-08-31 14:32:08'),(516,'default','added',101,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-08-31 14:33:48','2021-08-31 14:33:48'),(517,'default','status_changed',95,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-31 14:34:14','2021-08-31 14:34:14'),(518,'default','status_changed',98,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-31 14:39:38','2021-08-31 14:39:38'),(519,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-08-31 14:39:40','2021-08-31 14:39:40'),(520,'default','added',149,'App\\Contact',1,11,'App\\User','[]','2021-08-31 14:40:25','2021-08-31 14:40:25'),(521,'default','status_changed',134,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-31 14:40:35','2021-08-31 14:40:35'),(522,'default','added',102,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-08-31 14:41:23','2021-08-31 14:41:23'),(523,'default','status_changed',145,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-31 14:41:58','2021-08-31 14:41:58'),(524,'default','status_changed',147,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-08-31 14:43:17','2021-08-31 14:43:17'),(525,'default','status_changed',138,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-31 14:51:18','2021-08-31 14:51:18'),(526,'default','status_changed',113,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-31 16:46:15','2021-08-31 16:46:15'),(527,'default','added',150,'App\\Contact',1,11,'App\\User','[]','2021-08-31 16:46:46','2021-08-31 16:46:46'),(528,'default','added',151,'App\\Contact',1,4,'App\\User','[]','2021-08-31 17:09:05','2021-08-31 17:09:05'),(529,'default','added',152,'App\\Contact',1,4,'App\\User','[]','2021-08-31 17:29:52','2021-08-31 17:29:52'),(530,'default','added',153,'App\\Contact',1,4,'App\\User','[]','2021-08-31 17:55:07','2021-08-31 17:55:07'),(531,'default','added',154,'App\\Contact',1,4,'App\\User','[]','2021-08-31 18:54:03','2021-08-31 18:54:03'),(532,'default','added',155,'App\\Contact',1,11,'App\\User','[]','2021-08-31 18:54:05','2021-08-31 18:54:05'),(533,'default','added',103,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-08-31 19:19:32','2021-08-31 19:19:32'),(534,'default','added',104,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1}}','2021-08-31 20:17:11','2021-08-31 20:17:11'),(535,'default','added',105,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-08-31 20:25:21','2021-08-31 20:25:21'),(536,'default','status_changed',150,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-31 20:26:38','2021-08-31 20:26:38'),(537,'default','status_changed',127,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-31 20:28:59','2021-08-31 20:28:59'),(538,'default','status_changed',151,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-08-31 20:29:36','2021-08-31 20:29:36'),(539,'default','added',156,'App\\Contact',1,11,'App\\User','[]','2021-08-31 20:36:39','2021-08-31 20:36:39'),(540,'default','added',106,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-08-31 20:49:36','2021-08-31 20:49:36'),(541,'default','added',157,'App\\Contact',1,11,'App\\User','[]','2021-08-31 21:02:27','2021-08-31 21:02:27'),(542,'default','status_changed',127,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-31 21:04:04','2021-08-31 21:04:04'),(543,'default','status_changed',154,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-31 21:19:23','2021-08-31 21:19:23'),(544,'default','added',158,'App\\Contact',1,11,'App\\User','[]','2021-08-31 21:20:15','2021-08-31 21:20:15'),(545,'default','added',107,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-08-31 21:26:51','2021-08-31 21:26:51'),(546,'default','status_changed',142,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-31 21:31:29','2021-08-31 21:31:29'),(547,'default','added',159,'App\\Contact',1,4,'App\\User','[]','2021-08-31 21:32:06','2021-08-31 21:32:06'),(548,'default','added',160,'App\\Contact',1,11,'App\\User','[]','2021-08-31 21:39:54','2021-08-31 21:39:54'),(549,'default','added',108,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}','2021-08-31 21:49:10','2021-08-31 21:49:10'),(550,'default','added',109,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-08-31 22:16:51','2021-08-31 22:16:51'),(551,'default','status_changed',151,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-08-31 22:17:25','2021-08-31 22:17:25'),(552,'default','added',110,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-08-31 22:49:20','2021-08-31 22:49:20'),(553,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-01 12:43:33','2021-09-01 12:43:33'),(554,'default','added',161,'App\\Contact',1,4,'App\\User','[]','2021-09-01 14:00:23','2021-09-01 14:00:23'),(555,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-01 14:37:41','2021-09-01 14:37:41'),(556,'default','added',162,'App\\Contact',1,11,'App\\User','[]','2021-09-01 14:38:16','2021-09-01 14:38:16'),(557,'default','added',163,'App\\Contact',1,11,'App\\User','[]','2021-09-01 14:43:55','2021-09-01 14:43:55'),(558,'default','added',164,'App\\Contact',1,11,'App\\User','[]','2021-09-01 15:06:49','2021-09-01 15:06:49'),(559,'default','added',165,'App\\Contact',1,4,'App\\User','[]','2021-09-01 15:32:01','2021-09-01 15:32:01'),(560,'default','added',166,'App\\Contact',1,4,'App\\User','[]','2021-09-01 15:47:18','2021-09-01 15:47:18'),(561,'default','added',111,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-01 15:49:48','2021-09-01 15:49:48'),(562,'default','added',112,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-01 15:51:41','2021-09-01 15:51:41'),(563,'default','status_changed',165,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-01 15:52:11','2021-09-01 15:52:11'),(564,'default','added',113,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-09-01 15:52:56','2021-09-01 15:52:56'),(565,'default','added',167,'App\\Contact',1,11,'App\\User','[]','2021-09-01 15:53:08','2021-09-01 15:53:08'),(566,'default','status_changed',164,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-01 15:53:16','2021-09-01 15:53:16'),(567,'default','added',168,'App\\Contact',1,4,'App\\User','[]','2021-09-01 15:58:50','2021-09-01 15:58:50'),(568,'default','added',114,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":800}}','2021-09-01 16:02:17','2021-09-01 16:02:17'),(569,'default','added',169,'App\\Contact',1,4,'App\\User','[]','2021-09-01 16:04:46','2021-09-01 16:04:46'),(570,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-01 16:06:57','2021-09-01 16:06:57'),(571,'default','added',115,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":700}}','2021-09-01 16:07:54','2021-09-01 16:07:54'),(572,'default','status_changed',106,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-01 16:09:20','2021-09-01 16:09:20'),(573,'default','added',170,'App\\Contact',1,4,'App\\User','[]','2021-09-01 16:12:21','2021-09-01 16:12:21'),(574,'default','status_changed',130,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-01 16:16:54','2021-09-01 16:16:54'),(575,'default','status_changed',125,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-01 16:19:27','2021-09-01 16:19:27'),(576,'default','status_changed',143,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-01 16:19:39','2021-09-01 16:19:39'),(577,'default','status_changed',144,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-09-01 16:20:02','2021-09-01 16:20:02'),(578,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-01 16:23:28','2021-09-01 16:23:28'),(579,'default','status_changed',148,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-09-01 16:24:25','2021-09-01 16:24:25'),(580,'default','added',171,'App\\Contact',1,4,'App\\User','[]','2021-09-01 16:26:27','2021-09-01 16:26:27'),(581,'default','status_changed',136,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-01 16:32:33','2021-09-01 16:32:33'),(582,'default','status_changed',152,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-01 16:33:22','2021-09-01 16:33:22'),(583,'default','status_changed',156,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-09-01 16:35:53','2021-09-01 16:35:53'),(584,'default','status_changed',141,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-01 16:36:06','2021-09-01 16:36:06'),(585,'default','status_changed',160,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-09-01 16:36:18','2021-09-01 16:36:18'),(586,'default','status_changed',162,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-09-01 16:37:02','2021-09-01 16:37:02'),(587,'default','status_changed',163,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-09-01 16:44:24','2021-09-01 16:44:24'),(588,'default','status_changed',169,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-09-01 16:44:37','2021-09-01 16:44:37'),(589,'default','status_changed',155,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-09-01 16:44:58','2021-09-01 16:44:58'),(590,'default','status_changed',159,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-09-01 16:45:06','2021-09-01 16:45:06'),(591,'default','added',116,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}','2021-09-01 16:55:00','2021-09-01 16:55:00'),(592,'default','status_changed',136,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-01 16:55:22','2021-09-01 16:55:22'),(593,'default','status_changed',158,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-01 16:56:15','2021-09-01 16:56:15'),(594,'default','added',172,'App\\Contact',1,4,'App\\User','[]','2021-09-01 17:07:20','2021-09-01 17:07:20'),(595,'default','status_changed',96,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-01 17:11:07','2021-09-01 17:11:07'),(596,'default','added',173,'App\\Contact',1,4,'App\\User','[]','2021-09-01 17:33:14','2021-09-01 17:33:14'),(597,'default','added',174,'App\\Contact',1,4,'App\\User','[]','2021-09-01 17:36:20','2021-09-01 17:36:20'),(598,'default','added',175,'App\\Contact',1,4,'App\\User','[]','2021-09-01 17:40:33','2021-09-01 17:40:33'),(599,'default','added',117,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-01 17:45:18','2021-09-01 17:45:18'),(600,'default','status_changed',156,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-01 17:45:41','2021-09-01 17:45:41'),(601,'default','added',118,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-09-01 17:48:40','2021-09-01 17:48:40'),(602,'default','status_changed',155,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-01 17:48:53','2021-09-01 17:48:53'),(603,'default','status_changed',41,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-01 18:21:50','2021-09-01 18:21:50'),(604,'default','added',119,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-09-01 18:22:51','2021-09-01 18:22:51'),(605,'default','added',120,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-01 19:05:20','2021-09-01 19:05:20'),(606,'default','added',176,'App\\Contact',1,4,'App\\User','[]','2021-09-01 19:25:19','2021-09-01 19:25:19'),(607,'default','added',121,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-01 19:28:04','2021-09-01 19:28:04'),(608,'default','added',122,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-09-01 19:40:05','2021-09-01 19:40:05'),(609,'default','status_changed',143,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-01 19:40:30','2021-09-01 19:40:30'),(610,'default','added',177,'App\\Contact',1,4,'App\\User','[]','2021-09-01 19:56:20','2021-09-01 19:56:20'),(611,'default','status_changed',158,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Finished\"}','2021-09-01 20:22:45','2021-09-01 20:22:45'),(612,'default','status_changed',158,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-01 20:24:10','2021-09-01 20:24:10'),(613,'default','status_changed',159,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-01 20:24:25','2021-09-01 20:24:25'),(614,'default','added',123,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-01 20:26:41','2021-09-01 20:26:41'),(615,'default','status_changed',167,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-01 20:27:01','2021-09-01 20:27:01'),(616,'default','added',178,'App\\Contact',1,4,'App\\User','[]','2021-09-01 20:34:40','2021-09-01 20:34:40'),(617,'default','status_changed',177,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-01 20:35:47','2021-09-01 20:35:47'),(618,'default','added',179,'App\\Contact',1,4,'App\\User','[]','2021-09-01 20:40:19','2021-09-01 20:40:19'),(619,'default','added',180,'App\\Contact',1,4,'App\\User','[]','2021-09-01 20:44:15','2021-09-01 20:44:15'),(620,'default','added',181,'App\\Contact',1,4,'App\\User','[]','2021-09-01 21:00:52','2021-09-01 21:00:52'),(621,'default','added',182,'App\\Contact',1,4,'App\\User','[]','2021-09-01 21:11:28','2021-09-01 21:11:28'),(622,'default','added',183,'App\\Contact',1,11,'App\\User','[]','2021-09-01 21:39:04','2021-09-01 21:39:04'),(623,'default','status_changed',161,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-01 21:39:40','2021-09-01 21:39:40'),(624,'default','added',184,'App\\Contact',1,11,'App\\User','[]','2021-09-01 21:45:25','2021-09-01 21:45:25'),(625,'default','added',124,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-09-01 21:54:40','2021-09-01 21:54:40'),(626,'default','status_changed',177,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-01 21:55:58','2021-09-01 21:55:58'),(627,'default','added',125,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-01 21:56:43','2021-09-01 21:56:43'),(628,'default','status_changed',176,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-01 21:57:05','2021-09-01 21:57:05'),(629,'default','added',126,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}','2021-09-01 22:00:53','2021-09-01 22:00:53'),(630,'default','status_changed',163,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-01 22:02:07','2021-09-01 22:02:07'),(631,'default','added',185,'App\\Contact',1,11,'App\\User','[]','2021-09-01 22:02:08','2021-09-01 22:02:08'),(632,'default','added',127,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}','2021-09-01 22:03:29','2021-09-01 22:03:29'),(633,'default','status_changed',162,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-01 22:03:52','2021-09-01 22:03:52'),(634,'default','added',128,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":950}}','2021-09-01 22:04:28','2021-09-01 22:04:28'),(635,'default','status_changed',159,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-01 22:04:53','2021-09-01 22:04:53'),(636,'default','added',186,'App\\Contact',1,11,'App\\User','[]','2021-09-01 22:39:00','2021-09-01 22:39:00'),(637,'default','status_changed',179,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-01 23:02:43','2021-09-01 23:02:43'),(638,'default','added',187,'App\\Contact',1,4,'App\\User','[]','2021-09-01 23:03:19','2021-09-01 23:03:19'),(639,'default','added',129,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":950}}','2021-09-01 23:06:57','2021-09-01 23:06:57'),(640,'default','status_changed',173,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-01 23:07:18','2021-09-01 23:07:18'),(641,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-02 12:26:38','2021-09-02 12:26:38'),(642,'default','added',188,'App\\Contact',1,4,'App\\User','[]','2021-09-02 13:02:38','2021-09-02 13:02:38'),(643,'default','added',189,'App\\Contact',1,4,'App\\User','[]','2021-09-02 13:21:23','2021-09-02 13:21:23'),(644,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-02 13:57:12','2021-09-02 13:57:12'),(645,'default','added',130,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-02 14:06:44','2021-09-02 14:06:44'),(646,'default','status_changed',189,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-02 14:06:58','2021-09-02 14:06:58'),(647,'default','added',190,'App\\Contact',1,4,'App\\User','[]','2021-09-02 15:21:07','2021-09-02 15:21:07'),(648,'default','status_changed',166,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-02 15:26:37','2021-09-02 15:26:37'),(649,'default','status_changed',172,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-02 15:26:46','2021-09-02 15:26:46'),(650,'default','added',191,'App\\Contact',1,11,'App\\User','[]','2021-09-02 16:01:13','2021-09-02 16:01:13'),(651,'default','status_changed',191,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-02 16:05:43','2021-09-02 16:05:43'),(652,'default','added',192,'App\\Contact',1,4,'App\\User','[]','2021-09-02 16:30:16','2021-09-02 16:30:16'),(653,'default','status_changed',185,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-02 16:41:54','2021-09-02 16:41:54'),(654,'default','status_changed',182,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-02 16:42:04','2021-09-02 16:42:04'),(655,'default','status_changed',181,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-02 16:42:16','2021-09-02 16:42:16'),(656,'default','status_changed',186,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-02 16:42:27','2021-09-02 16:42:27'),(657,'default','added',193,'App\\Contact',1,4,'App\\User','[]','2021-09-02 16:47:41','2021-09-02 16:47:41'),(658,'default','status_changed',138,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-02 16:48:25','2021-09-02 16:48:25'),(659,'default','status_changed',194,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Can\'t be repaired\"}','2021-09-02 18:34:26','2021-09-02 18:34:26'),(660,'default','added',194,'App\\Contact',1,4,'App\\User','[]','2021-09-02 18:52:02','2021-09-02 18:52:02'),(661,'default','added',195,'App\\Contact',1,4,'App\\User','[]','2021-09-02 18:57:06','2021-09-02 18:57:06'),(662,'default','added',196,'App\\Contact',1,4,'App\\User','[]','2021-09-02 19:07:49','2021-09-02 19:07:49'),(663,'default','added',197,'App\\Contact',1,4,'App\\User','[]','2021-09-02 19:08:37','2021-09-02 19:08:37'),(664,'default','status_changed',182,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-02 19:14:40','2021-09-02 19:14:40'),(665,'default','status_changed',181,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-02 19:15:20','2021-09-02 19:15:20'),(666,'default','status_changed',188,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-02 19:17:49','2021-09-02 19:17:49'),(667,'default','status_changed',180,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-02 19:18:04','2021-09-02 19:18:04'),(668,'default','status_changed',190,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-02 19:18:20','2021-09-02 19:18:20'),(669,'default','status_changed',186,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-02 19:21:48','2021-09-02 19:21:48'),(670,'default','status_changed',185,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-02 19:35:46','2021-09-02 19:35:46'),(671,'default','added',198,'App\\Contact',1,4,'App\\User','[]','2021-09-02 20:24:40','2021-09-02 20:24:40'),(672,'default','added',199,'App\\Contact',1,4,'App\\User','[]','2021-09-02 20:37:28','2021-09-02 20:37:28'),(673,'default','added',200,'App\\Contact',1,4,'App\\User','[]','2021-09-02 20:41:03','2021-09-02 20:41:03'),(674,'default','added',201,'App\\Contact',1,4,'App\\User','[]','2021-09-02 20:46:20','2021-09-02 20:46:20'),(675,'default','added',131,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-09-02 20:57:12','2021-09-02 20:57:12'),(676,'default','added',132,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-09-02 20:58:02','2021-09-02 20:58:02'),(677,'default','status_changed',125,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-02 21:07:29','2021-09-02 21:07:29'),(678,'default','status_changed',186,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-02 21:08:02','2021-09-02 21:08:02'),(679,'default','status_changed',182,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-02 21:08:45','2021-09-02 21:08:45'),(680,'default','added',133,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-02 21:09:48','2021-09-02 21:09:48'),(681,'default','status_changed',198,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-02 21:10:07','2021-09-02 21:10:07'),(682,'default','added',202,'App\\Contact',1,4,'App\\User','[]','2021-09-02 21:19:46','2021-09-02 21:19:46'),(683,'default','added',134,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}','2021-09-02 21:21:42','2021-09-02 21:21:42'),(684,'default','status_changed',158,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-02 21:22:12','2021-09-02 21:22:12'),(685,'default','status_changed',197,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-02 21:48:57','2021-09-02 21:48:57'),(686,'default','added',203,'App\\Contact',1,4,'App\\User','[]','2021-09-02 21:53:32','2021-09-02 21:53:32'),(687,'default','added',135,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-09-02 21:58:02','2021-09-02 21:58:02'),(688,'default','status_changed',185,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-02 21:58:48','2021-09-02 21:58:48'),(689,'default','added',204,'App\\Contact',1,4,'App\\User','[]','2021-09-02 22:35:23','2021-09-02 22:35:23'),(690,'default','added',136,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}','2021-09-02 22:41:38','2021-09-02 22:41:38'),(691,'default','status_changed',188,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-02 22:41:55','2021-09-02 22:41:55'),(692,'default','added',205,'App\\Contact',1,4,'App\\User','[]','2021-09-02 23:12:14','2021-09-02 23:12:14'),(693,'default','added',137,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-02 23:14:00','2021-09-02 23:14:00'),(694,'default','status_changed',207,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-02 23:14:28','2021-09-02 23:14:28'),(695,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-03 15:02:59','2021-09-03 15:02:59'),(696,'default','added',206,'App\\Contact',1,4,'App\\User','[]','2021-09-03 15:03:55','2021-09-03 15:03:55'),(697,'default','added',207,'App\\Contact',1,4,'App\\User','[]','2021-09-03 15:10:06','2021-09-03 15:10:06'),(698,'default','added',208,'App\\Contact',1,4,'App\\User','[]','2021-09-03 16:15:48','2021-09-03 16:15:48'),(699,'default','added',209,'App\\Contact',1,4,'App\\User','[]','2021-09-03 19:57:18','2021-09-03 19:57:18'),(700,'default','added',138,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}','2021-09-03 20:11:41','2021-09-03 20:11:41'),(701,'default','status_changed',200,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-03 20:12:20','2021-09-03 20:12:20'),(702,'default','added',210,'App\\Contact',1,4,'App\\User','[]','2021-09-03 21:31:51','2021-09-03 21:31:51'),(703,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-09-03 23:32:49','2021-09-03 23:32:49'),(704,'default','added',211,'App\\Contact',1,1,'App\\User','[]','2021-09-03 23:33:41','2021-09-03 23:33:41'),(705,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-04 11:59:33','2021-09-04 11:59:33'),(706,'default','added',212,'App\\Contact',1,4,'App\\User','[]','2021-09-04 13:43:04','2021-09-04 13:43:04'),(707,'default','added',213,'App\\Contact',1,4,'App\\User','[]','2021-09-04 14:00:56','2021-09-04 14:00:56'),(708,'default','status_changed',210,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-04 14:33:08','2021-09-04 14:33:08'),(709,'default','status_changed',206,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-04 14:33:21','2021-09-04 14:33:21'),(710,'default','status_changed',214,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-04 14:33:37','2021-09-04 14:33:37'),(711,'default','status_changed',187,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-04 14:35:26','2021-09-04 14:35:26'),(712,'default','status_changed',183,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-04 14:36:18','2021-09-04 14:36:18'),(713,'default','status_changed',192,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-04 14:37:09','2021-09-04 14:37:09'),(714,'default','status_changed',201,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-04 14:41:49','2021-09-04 14:41:49'),(715,'default','status_changed',196,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-04 14:45:15','2021-09-04 14:45:15'),(716,'default','status_changed',195,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-04 14:45:31','2021-09-04 14:45:31'),(717,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-04 14:51:35','2021-09-04 14:51:35'),(718,'default','status_changed',124,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-04 14:52:14','2021-09-04 14:52:14'),(719,'default','status_changed',126,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-04 14:53:03','2021-09-04 14:53:03'),(720,'default','status_changed',144,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-04 14:53:25','2021-09-04 14:53:25'),(721,'default','status_changed',148,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-09-04 14:53:49','2021-09-04 14:53:49'),(722,'default','status_changed',139,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-04 14:56:11','2021-09-04 14:56:11'),(723,'default','status_changed',160,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-04 14:57:45','2021-09-04 14:57:45'),(724,'default','added',139,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-04 15:04:55','2021-09-04 15:04:55'),(725,'default','status_changed',191,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-04 15:05:25','2021-09-04 15:05:25'),(726,'default','added',214,'App\\Contact',1,11,'App\\User','[]','2021-09-04 15:19:24','2021-09-04 15:19:24'),(727,'default','added',140,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-09-04 16:29:44','2021-09-04 16:29:44'),(728,'default','status_changed',195,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-04 16:30:02','2021-09-04 16:30:02'),(729,'default','added',215,'App\\Contact',1,4,'App\\User','[]','2021-09-04 16:55:09','2021-09-04 16:55:09'),(730,'default','added',216,'App\\Contact',1,4,'App\\User','[]','2021-09-04 16:59:46','2021-09-04 16:59:46'),(731,'default','added',217,'App\\Contact',1,4,'App\\User','[]','2021-09-04 17:38:47','2021-09-04 17:38:47'),(732,'default','added',218,'App\\Contact',1,4,'App\\User','[]','2021-09-04 18:10:48','2021-09-04 18:10:48'),(733,'default','status_changed',206,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-04 18:17:16','2021-09-04 18:17:16'),(734,'default','status_changed',214,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-04 18:21:07','2021-09-04 18:21:07'),(735,'default','status_changed',209,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-04 18:25:29','2021-09-04 18:25:29'),(736,'default','added',141,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-09-04 18:25:44','2021-09-04 18:25:44'),(737,'default','status_changed',212,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-04 18:26:20','2021-09-04 18:26:20'),(738,'default','status_changed',215,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-04 18:26:20','2021-09-04 18:26:20'),(739,'default','status_changed',217,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-04 18:34:29','2021-09-04 18:34:29'),(740,'default','status_changed',205,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-04 18:34:55','2021-09-04 18:34:55'),(741,'default','status_changed',216,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-04 18:36:00','2021-09-04 18:36:00'),(742,'default','added',142,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-04 18:36:16','2021-09-04 18:36:16'),(743,'default','status_changed',203,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-04 18:36:25','2021-09-04 18:36:25'),(744,'default','status_changed',220,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-04 18:36:34','2021-09-04 18:36:34'),(745,'default','status_changed',196,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-04 18:36:36','2021-09-04 18:36:36'),(746,'default','status_changed',216,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-04 18:37:28','2021-09-04 18:37:28'),(747,'default','status_changed',204,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-04 18:39:57','2021-09-04 18:39:57'),(748,'default','added',143,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-04 19:04:03','2021-09-04 19:04:03'),(749,'default','status_changed',216,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-04 19:07:11','2021-09-04 19:07:11'),(750,'default','status_changed',209,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-04 19:11:16','2021-09-04 19:11:16'),(751,'default','added',219,'App\\Contact',1,4,'App\\User','[]','2021-09-04 19:12:43','2021-09-04 19:12:43'),(752,'default','added',220,'App\\Contact',1,4,'App\\User','[]','2021-09-04 19:14:22','2021-09-04 19:14:22'),(753,'default','added',221,'App\\Contact',1,4,'App\\User','[]','2021-09-04 19:19:25','2021-09-04 19:19:25'),(754,'default','added',222,'App\\Contact',1,4,'App\\User','[]','2021-09-04 19:24:56','2021-09-04 19:24:56'),(755,'default','added',223,'App\\Contact',1,4,'App\\User','[]','2021-09-04 19:33:24','2021-09-04 19:33:24'),(756,'default','added',144,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-09-04 19:44:05','2021-09-04 19:44:05'),(757,'default','status_changed',221,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-04 19:44:21','2021-09-04 19:44:21'),(758,'default','added',224,'App\\Contact',1,4,'App\\User','[]','2021-09-04 19:46:33','2021-09-04 19:46:33'),(759,'default','added',225,'App\\Contact',1,4,'App\\User','[]','2021-09-04 19:46:33','2021-09-04 19:46:33'),(760,'default','added',226,'App\\Contact',1,11,'App\\User','[]','2021-09-04 19:51:15','2021-09-04 19:51:15'),(761,'default','added',145,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-04 20:03:32','2021-09-04 20:03:32'),(762,'default','status_changed',160,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Can\'t be repaired\"}','2021-09-04 20:43:08','2021-09-04 20:43:08'),(763,'default','added',227,'App\\Contact',1,11,'App\\User','[]','2021-09-04 20:54:34','2021-09-04 20:54:34'),(764,'default','status_changed',214,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Can\'t be repaired\"}','2021-09-04 21:29:37','2021-09-04 21:29:37'),(765,'default','added',146,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-04 21:33:03','2021-09-04 21:33:03'),(766,'default','status_changed',226,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-04 21:33:54','2021-09-04 21:33:54'),(767,'default','added',147,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-04 21:51:56','2021-09-04 21:51:56'),(768,'default','status_changed',166,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-04 21:52:16','2021-09-04 21:52:16'),(769,'default','added',148,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-09-04 21:57:30','2021-09-04 21:57:30'),(770,'default','status_changed',227,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-04 21:57:56','2021-09-04 21:57:56'),(771,'default','added',149,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-04 22:31:57','2021-09-04 22:31:57'),(772,'default','status_changed',225,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-04 22:32:15','2021-09-04 22:32:15'),(773,'default','status_changed',139,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-04 22:44:24','2021-09-04 22:44:24'),(774,'default','status_changed',219,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-04 22:53:35','2021-09-04 22:53:35'),(775,'default','status_changed',218,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-04 22:53:52','2021-09-04 22:53:52'),(776,'default','added',150,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}','2021-09-04 23:10:00','2021-09-04 23:10:00'),(777,'default','status_changed',218,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-04 23:10:48','2021-09-04 23:10:48'),(778,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-05 12:04:59','2021-09-05 12:04:59'),(779,'default','added',228,'App\\Contact',1,4,'App\\User','[]','2021-09-05 13:24:08','2021-09-05 13:24:08'),(780,'default','added',229,'App\\Contact',1,4,'App\\User','[]','2021-09-05 13:40:07','2021-09-05 13:40:07'),(781,'default','added',230,'App\\Contact',1,4,'App\\User','[]','2021-09-05 13:48:51','2021-09-05 13:48:51'),(782,'default','added',231,'App\\Contact',1,4,'App\\User','[]','2021-09-05 13:58:28','2021-09-05 13:58:28'),(783,'default','added',232,'App\\Contact',1,4,'App\\User','[]','2021-09-05 14:41:51','2021-09-05 14:41:51'),(784,'default','status_changed',232,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-05 14:44:09','2021-09-05 14:44:09'),(785,'default','added',233,'App\\Contact',1,4,'App\\User','[]','2021-09-05 14:58:45','2021-09-05 14:58:45'),(786,'default','added',234,'App\\Contact',1,4,'App\\User','[]','2021-09-05 15:39:32','2021-09-05 15:39:32'),(787,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-05 15:39:50','2021-09-05 15:39:50'),(788,'default','added',235,'App\\Contact',1,4,'App\\User','[]','2021-09-05 15:41:43','2021-09-05 15:41:43'),(789,'default','added',236,'App\\Contact',1,4,'App\\User','[]','2021-09-05 16:18:10','2021-09-05 16:18:10'),(790,'default','added',151,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-05 16:19:52','2021-09-05 16:19:52'),(791,'default','status_changed',215,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-05 16:21:38','2021-09-05 16:21:38'),(792,'default','added',237,'App\\Contact',1,4,'App\\User','[]','2021-09-05 16:48:14','2021-09-05 16:48:14'),(793,'default','added',238,'App\\Contact',1,4,'App\\User','[]','2021-09-05 17:09:20','2021-09-05 17:09:20'),(794,'default','status_changed',230,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-05 17:25:29','2021-09-05 17:25:29'),(795,'default','status_changed',210,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-05 17:29:38','2021-09-05 17:29:38'),(796,'default','added',152,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}','2021-09-05 17:30:08','2021-09-05 17:30:08'),(797,'default','status_changed',174,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-05 17:31:33','2021-09-05 17:31:33'),(798,'default','status_changed',214,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-05 17:35:48','2021-09-05 17:35:48'),(799,'default','status_changed',213,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-05 17:37:43','2021-09-05 17:37:43'),(800,'default','status_changed',234,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-05 17:42:36','2021-09-05 17:42:36'),(801,'default','status_changed',233,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-05 17:44:00','2021-09-05 17:44:00'),(802,'default','added',153,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-05 18:12:52','2021-09-05 18:12:52'),(803,'default','status_changed',236,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-05 18:20:58','2021-09-05 18:20:58'),(804,'default','status_changed',126,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-05 18:30:38','2021-09-05 18:30:38'),(805,'default','added',239,'App\\Contact',1,4,'App\\User','[]','2021-09-05 18:35:59','2021-09-05 18:35:59'),(806,'default','added',240,'App\\Contact',1,4,'App\\User','[]','2021-09-05 18:37:00','2021-09-05 18:37:00'),(807,'default','added',154,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-09-05 18:53:59','2021-09-05 18:53:59'),(808,'default','status_changed',197,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-05 19:02:24','2021-09-05 19:02:24'),(809,'default','added',241,'App\\Contact',1,4,'App\\User','[]','2021-09-05 19:07:19','2021-09-05 19:07:19'),(810,'default','status_changed',211,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-05 19:25:00','2021-09-05 19:25:00'),(811,'default','added',242,'App\\Contact',1,4,'App\\User','[]','2021-09-05 19:51:35','2021-09-05 19:51:35'),(812,'default','added',155,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-05 20:33:12','2021-09-05 20:33:12'),(813,'default','added',156,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-09-05 20:36:09','2021-09-05 20:36:09'),(814,'default','added',157,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-05 20:38:37','2021-09-05 20:38:37'),(815,'default','status_changed',232,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-05 20:40:06','2021-09-05 20:40:06'),(816,'default','added',243,'App\\Contact',1,4,'App\\User','[]','2021-09-05 20:50:30','2021-09-05 20:50:30'),(817,'default','added',158,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-09-05 20:56:47','2021-09-05 20:56:47'),(818,'default','status_changed',98,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-05 20:57:05','2021-09-05 20:57:05'),(819,'default','added',159,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}','2021-09-05 21:19:28','2021-09-05 21:19:28'),(820,'default','status_changed',220,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-05 21:20:06','2021-09-05 21:20:06'),(821,'default','added',160,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-09-05 21:20:49','2021-09-05 21:20:49'),(822,'default','status_changed',179,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-05 21:21:11','2021-09-05 21:21:11'),(823,'default','added',161,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-09-05 21:22:08','2021-09-05 21:22:08'),(824,'default','added',162,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-09-05 21:22:52','2021-09-05 21:22:52'),(825,'default','added',244,'App\\Contact',1,4,'App\\User','[]','2021-09-05 21:48:55','2021-09-05 21:48:55'),(826,'default','added',245,'App\\Contact',1,4,'App\\User','[]','2021-09-05 21:51:38','2021-09-05 21:51:38'),(827,'default','added',163,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-09-05 21:52:26','2021-09-05 21:52:26'),(828,'default','status_changed',239,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-05 21:57:02','2021-09-05 21:57:02'),(829,'default','status_changed',233,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-05 21:57:43','2021-09-05 21:57:43'),(830,'default','status_changed',237,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-05 21:58:06','2021-09-05 21:58:06'),(831,'default','status_changed',242,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-05 21:58:16','2021-09-05 21:58:16'),(832,'default','status_changed',240,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-05 21:58:27','2021-09-05 21:58:27'),(833,'default','status_changed',231,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-05 21:58:37','2021-09-05 21:58:37'),(834,'default','status_changed',241,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-05 21:59:22','2021-09-05 21:59:22'),(835,'default','added',164,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-05 22:02:23','2021-09-05 22:02:23'),(836,'default','status_changed',238,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-05 22:03:00','2021-09-05 22:03:00'),(837,'default','added',246,'App\\Contact',1,4,'App\\User','[]','2021-09-05 22:04:06','2021-09-05 22:04:06'),(838,'default','added',165,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-09-05 22:05:45','2021-09-05 22:05:45'),(839,'default','status_changed',244,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-05 22:08:47','2021-09-05 22:08:47'),(840,'default','status_changed',243,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-05 22:08:56','2021-09-05 22:08:56'),(841,'default','status_changed',224,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-05 22:09:05','2021-09-05 22:09:05'),(842,'default','status_changed',229,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-05 22:09:16','2021-09-05 22:09:16'),(843,'default','status_changed',148,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-05 22:09:24','2021-09-05 22:09:24'),(844,'default','status_changed',237,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-05 23:58:14','2021-09-05 23:58:14'),(845,'default','status_changed',236,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-06 00:01:36','2021-09-06 00:01:36'),(846,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-06 12:23:11','2021-09-06 12:23:11'),(847,'default','added',247,'App\\Contact',1,4,'App\\User','[]','2021-09-06 12:24:08','2021-09-06 12:24:08'),(848,'default','added',166,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":125}}','2021-09-06 13:29:30','2021-09-06 13:29:30'),(849,'default','added',248,'App\\Contact',1,4,'App\\User','[]','2021-09-06 14:00:22','2021-09-06 14:00:22'),(850,'default','added',249,'App\\Contact',1,4,'App\\User','[]','2021-09-06 14:14:40','2021-09-06 14:14:40'),(851,'default','added',250,'App\\Contact',1,4,'App\\User','[]','2021-09-06 14:19:40','2021-09-06 14:19:40'),(852,'default','added',251,'App\\Contact',1,4,'App\\User','[]','2021-09-06 14:25:15','2021-09-06 14:25:15'),(853,'default','added',252,'App\\Contact',1,4,'App\\User','[]','2021-09-06 14:28:34','2021-09-06 14:28:34'),(854,'default','added',167,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":800}}','2021-09-06 14:31:04','2021-09-06 14:31:04'),(855,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-06 14:55:49','2021-09-06 14:55:49'),(856,'default','added',253,'App\\Contact',1,11,'App\\User','[]','2021-09-06 14:57:12','2021-09-06 14:57:12'),(857,'default','added',254,'App\\Contact',1,4,'App\\User','[]','2021-09-06 15:01:33','2021-09-06 15:01:33'),(858,'default','added',255,'App\\Contact',1,4,'App\\User','[]','2021-09-06 15:04:01','2021-09-06 15:04:01'),(859,'default','added',256,'App\\Contact',1,11,'App\\User','[]','2021-09-06 15:05:30','2021-09-06 15:05:30'),(860,'default','added',257,'App\\Contact',1,11,'App\\User','[]','2021-09-06 15:10:03','2021-09-06 15:10:03'),(861,'default','added',258,'App\\Contact',1,11,'App\\User','[]','2021-09-06 15:13:29','2021-09-06 15:13:29'),(862,'default','added',259,'App\\Contact',1,11,'App\\User','[]','2021-09-06 15:15:21','2021-09-06 15:15:21'),(863,'default','added',260,'App\\Contact',1,11,'App\\User','[]','2021-09-06 15:18:01','2021-09-06 15:18:01'),(864,'default','added',261,'App\\Contact',1,4,'App\\User','[]','2021-09-06 15:18:06','2021-09-06 15:18:06'),(865,'default','added',262,'App\\Contact',1,4,'App\\User','[]','2021-09-06 15:18:37','2021-09-06 15:18:37'),(866,'default','added',168,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-06 15:21:19','2021-09-06 15:21:19'),(867,'default','added',169,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-09-06 15:25:49','2021-09-06 15:25:49'),(868,'default','status_changed',231,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-06 15:28:10','2021-09-06 15:28:10'),(869,'default','added',170,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}','2021-09-06 15:29:24','2021-09-06 15:29:24'),(870,'default','status_changed',211,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-06 15:29:46','2021-09-06 15:29:46'),(871,'default','added',171,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":125}}','2021-09-06 15:31:45','2021-09-06 15:31:45'),(872,'default','status_changed',172,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-06 15:32:09','2021-09-06 15:32:09'),(873,'default','added',263,'App\\Contact',1,4,'App\\User','[]','2021-09-06 16:14:08','2021-09-06 16:14:08'),(874,'default','added',264,'App\\Contact',1,11,'App\\User','[]','2021-09-06 16:18:15','2021-09-06 16:18:15'),(875,'default','added',265,'App\\Contact',1,4,'App\\User','[]','2021-09-06 16:27:17','2021-09-06 16:27:17'),(876,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-06 16:30:11','2021-09-06 16:30:11'),(877,'default','added',266,'App\\Contact',1,4,'App\\User','[]','2021-09-06 16:32:41','2021-09-06 16:32:41'),(878,'default','added',267,'App\\Contact',1,11,'App\\User','[]','2021-09-06 16:33:22','2021-09-06 16:33:22'),(879,'default','added',268,'App\\Contact',1,11,'App\\User','[]','2021-09-06 16:36:10','2021-09-06 16:36:10'),(880,'default','added',269,'App\\Contact',1,11,'App\\User','[]','2021-09-06 16:38:46','2021-09-06 16:38:46'),(881,'default','added',270,'App\\Contact',1,4,'App\\User','[]','2021-09-06 16:39:03','2021-09-06 16:39:03'),(882,'default','added',271,'App\\Contact',1,11,'App\\User','[]','2021-09-06 16:43:28','2021-09-06 16:43:28'),(883,'default','status_changed',254,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Finished\"}','2021-09-06 16:50:22','2021-09-06 16:50:22'),(884,'default','added',272,'App\\Contact',1,4,'App\\User','[]','2021-09-06 16:52:55','2021-09-06 16:52:55'),(885,'default','status_changed',254,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-06 16:55:44','2021-09-06 16:55:44'),(886,'default','added',172,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-06 17:15:12','2021-09-06 17:15:12'),(887,'default','added',173,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-09-06 17:25:00','2021-09-06 17:25:00'),(888,'default','status_changed',237,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-06 17:30:07','2021-09-06 17:30:07'),(889,'default','added',273,'App\\Contact',1,4,'App\\User','[]','2021-09-06 17:37:00','2021-09-06 17:37:00'),(890,'default','added',274,'App\\Contact',1,4,'App\\User','[]','2021-09-06 17:39:08','2021-09-06 17:39:08'),(891,'default','added',275,'App\\Contact',1,4,'App\\User','[]','2021-09-06 17:40:36','2021-09-06 17:40:36'),(892,'default','status_changed',126,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-06 17:53:55','2021-09-06 17:53:55'),(893,'default','status_changed',144,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-06 18:14:28','2021-09-06 18:14:28'),(894,'default','status_changed',243,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-09-06 19:10:51','2021-09-06 19:10:51'),(895,'default','added',276,'App\\Contact',1,4,'App\\User','[]','2021-09-06 19:13:55','2021-09-06 19:13:55'),(896,'default','added',174,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-06 19:41:24','2021-09-06 19:41:24'),(897,'default','status_changed',241,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-06 19:42:10','2021-09-06 19:42:10'),(898,'default','added',277,'App\\Contact',1,4,'App\\User','[]','2021-09-06 20:20:14','2021-09-06 20:20:14'),(899,'default','added',278,'App\\Contact',1,4,'App\\User','[]','2021-09-06 20:41:04','2021-09-06 20:41:04'),(900,'default','added',279,'App\\Contact',1,11,'App\\User','[]','2021-09-06 21:11:43','2021-09-06 21:11:43'),(901,'default','added',175,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-09-06 21:12:03','2021-09-06 21:12:03'),(902,'default','added',280,'App\\Contact',1,4,'App\\User','[]','2021-09-06 21:34:09','2021-09-06 21:34:09'),(903,'default','added',176,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}','2021-09-06 21:44:32','2021-09-06 21:44:32'),(904,'default','status_changed',99,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-06 21:44:49','2021-09-06 21:44:49'),(905,'default','added',177,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-09-06 21:45:19','2021-09-06 21:45:19'),(906,'default','status_changed',243,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-06 21:45:41','2021-09-06 21:45:41'),(907,'default','added',178,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-06 21:46:29','2021-09-06 21:46:29'),(908,'default','added',179,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-09-06 21:48:02','2021-09-06 21:48:02'),(909,'default','added',180,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}','2021-09-06 21:49:31','2021-09-06 21:49:31'),(910,'default','added',181,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-06 22:00:18','2021-09-06 22:00:18'),(911,'default','status_changed',206,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-06 22:00:33','2021-09-06 22:00:33'),(912,'default','added',182,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-09-06 22:03:15','2021-09-06 22:03:15'),(913,'default','status_changed',202,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-06 22:05:54','2021-09-06 22:05:54'),(914,'default','added',281,'App\\Contact',1,4,'App\\User','[]','2021-09-06 22:06:22','2021-09-06 22:06:22'),(915,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-07 13:00:10','2021-09-07 13:00:10'),(916,'default','added',282,'App\\Contact',1,4,'App\\User','[]','2021-09-07 13:00:49','2021-09-07 13:00:49'),(917,'default','added',16,'App\\User',1,1,'App\\User','[]','2021-09-07 14:15:41','2021-09-07 14:15:41'),(918,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-07 14:17:12','2021-09-07 14:17:12'),(919,'default','added',283,'App\\Contact',1,4,'App\\User','[]','2021-09-07 14:18:00','2021-09-07 14:18:00'),(920,'default','added',284,'App\\Contact',1,4,'App\\User','[]','2021-09-07 14:25:00','2021-09-07 14:25:00'),(921,'default','added',285,'App\\Contact',1,4,'App\\User','[]','2021-09-07 14:34:20','2021-09-07 14:34:20'),(922,'default','added',286,'App\\Contact',1,4,'App\\User','[]','2021-09-07 14:39:21','2021-09-07 14:39:21'),(923,'default','status_changed',274,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-07 15:00:02','2021-09-07 15:00:02'),(924,'default','login',16,'App\\User',1,16,'App\\User','[]','2021-09-07 15:04:33','2021-09-07 15:04:33'),(925,'default','added',287,'App\\Contact',1,4,'App\\User','[]','2021-09-07 15:04:34','2021-09-07 15:04:34'),(926,'default','added',288,'App\\Contact',1,4,'App\\User','[]','2021-09-07 15:16:01','2021-09-07 15:16:01'),(927,'default','added',289,'App\\Contact',1,4,'App\\User','[]','2021-09-07 15:21:21','2021-09-07 15:21:21'),(928,'default','status_changed',160,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-07 15:58:27','2021-09-07 15:58:27'),(929,'default','added',290,'App\\Contact',1,4,'App\\User','[]','2021-09-07 16:14:51','2021-09-07 16:14:51'),(930,'default','added',291,'App\\Contact',1,4,'App\\User','[]','2021-09-07 16:22:19','2021-09-07 16:22:19'),(931,'default','logout',16,'App\\User',1,16,'App\\User','[]','2021-09-07 16:36:09','2021-09-07 16:36:09'),(932,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-07 16:36:56','2021-09-07 16:36:56'),(933,'default','status_changed',280,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-07 16:48:54','2021-09-07 16:48:54'),(934,'default','added',292,'App\\Contact',1,4,'App\\User','[]','2021-09-07 16:58:47','2021-09-07 16:58:47'),(935,'default','added',183,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-09-07 17:19:35','2021-09-07 17:19:35'),(936,'default','status_changed',210,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-07 17:19:56','2021-09-07 17:19:56'),(937,'default','added',184,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-07 17:20:23','2021-09-07 17:20:23'),(938,'default','status_changed',280,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-07 17:20:50','2021-09-07 17:20:50'),(939,'default','status_changed',275,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-07 17:23:00','2021-09-07 17:23:00'),(940,'default','added',293,'App\\Contact',1,4,'App\\User','[]','2021-09-07 18:02:20','2021-09-07 18:02:20'),(941,'default','added',294,'App\\Contact',1,4,'App\\User','[]','2021-09-07 18:04:45','2021-09-07 18:04:45'),(942,'default','added',295,'App\\Contact',1,4,'App\\User','[]','2021-09-07 18:17:28','2021-09-07 18:17:28'),(943,'default','added',185,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-07 18:28:44','2021-09-07 18:28:44'),(944,'default','status_changed',274,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-07 18:30:54','2021-09-07 18:30:54'),(945,'default','added',186,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-09-07 18:58:24','2021-09-07 18:58:24'),(946,'default','status_changed',240,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-07 18:58:46','2021-09-07 18:58:46'),(947,'default','added',296,'App\\Contact',1,4,'App\\User','[]','2021-09-07 19:00:49','2021-09-07 19:00:49'),(948,'default','added',297,'App\\Contact',1,4,'App\\User','[]','2021-09-07 19:11:26','2021-09-07 19:11:26'),(949,'default','status_changed',277,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-07 19:24:09','2021-09-07 19:24:09'),(950,'default','status_changed',288,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-07 19:24:28','2021-09-07 19:24:28'),(951,'default','added',187,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":125}}','2021-09-07 19:28:26','2021-09-07 19:28:26'),(952,'default','status_changed',254,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-07 19:28:51','2021-09-07 19:28:51'),(953,'default','added',188,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-07 19:29:08','2021-09-07 19:29:08'),(954,'default','status_changed',253,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-07 19:30:14','2021-09-07 19:30:14'),(955,'default','added',189,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1200}}','2021-09-07 19:30:38','2021-09-07 19:30:38'),(956,'default','status_changed',219,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-07 19:31:07','2021-09-07 19:31:07'),(957,'default','added',190,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-07 19:31:32','2021-09-07 19:31:32'),(958,'default','status_changed',223,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-07 19:32:03','2021-09-07 19:32:03'),(959,'default','status_changed',275,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-07 19:32:37','2021-09-07 19:32:37'),(960,'default','added',298,'App\\Contact',1,4,'App\\User','[]','2021-09-07 19:40:00','2021-09-07 19:40:00'),(961,'default','added',299,'App\\Contact',1,4,'App\\User','[]','2021-09-07 19:44:02','2021-09-07 19:44:02'),(962,'default','added',300,'App\\Contact',1,4,'App\\User','[]','2021-09-07 20:43:38','2021-09-07 20:43:38'),(963,'default','added',191,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-07 20:47:28','2021-09-07 20:47:28'),(964,'default','added',301,'App\\Contact',1,4,'App\\User','[]','2021-09-07 20:51:53','2021-09-07 20:51:53'),(965,'default','added',192,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":125}}','2021-09-07 20:59:07','2021-09-07 20:59:07'),(966,'default','status_changed',277,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-07 20:59:44','2021-09-07 20:59:44'),(967,'default','added',193,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-09-07 21:25:37','2021-09-07 21:25:37'),(968,'default','status_changed',180,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-07 21:25:58','2021-09-07 21:25:58'),(969,'default','added',302,'App\\Contact',1,4,'App\\User','[]','2021-09-07 21:31:12','2021-09-07 21:31:12'),(970,'default','added',194,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-07 21:33:21','2021-09-07 21:33:21'),(971,'default','status_changed',279,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-07 21:35:26','2021-09-07 21:35:26'),(972,'default','added',195,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}','2021-09-07 21:36:03','2021-09-07 21:36:03'),(973,'default','status_changed',294,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-07 21:55:04','2021-09-07 21:55:04'),(974,'default','status_changed',289,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-07 21:56:07','2021-09-07 21:56:07'),(975,'default','added',196,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-07 22:08:51','2021-09-07 22:08:51'),(976,'default','status_changed',295,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-07 22:09:12','2021-09-07 22:09:12'),(977,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-09-07 22:44:19','2021-09-07 22:44:19'),(978,'default','added',19,'App\\User',1,1,'App\\User','[]','2021-09-07 22:47:04','2021-09-07 22:47:04'),(979,'default','added',303,'App\\Contact',1,4,'App\\User','[]','2021-09-07 23:24:15','2021-09-07 23:24:15'),(980,'default','added',304,'App\\Contact',1,4,'App\\User','[]','2021-09-07 23:27:34','2021-09-07 23:27:34'),(981,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-08 12:52:52','2021-09-08 12:52:52'),(982,'default','added',305,'App\\Contact',1,4,'App\\User','[]','2021-09-08 13:06:45','2021-09-08 13:06:45'),(983,'default','added',306,'App\\Contact',1,4,'App\\User','[]','2021-09-08 13:26:24','2021-09-08 13:26:24'),(984,'default','added',307,'App\\Contact',1,4,'App\\User','[]','2021-09-08 13:28:42','2021-09-08 13:28:42'),(985,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-08 13:45:58','2021-09-08 13:45:58'),(986,'default','status_changed',291,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-08 13:49:48','2021-09-08 13:49:48'),(987,'default','status_changed',229,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-08 13:50:10','2021-09-08 13:50:10'),(988,'default','status_changed',273,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-08 14:42:05','2021-09-08 14:42:05'),(989,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-09-08 14:55:58','2021-09-08 14:55:58'),(990,'default','login',19,'App\\User',1,19,'App\\User','[]','2021-09-08 14:56:17','2021-09-08 14:56:17'),(991,'default','logout',19,'App\\User',1,19,'App\\User','[]','2021-09-08 14:58:25','2021-09-08 14:58:25'),(992,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-08 14:58:39','2021-09-08 14:58:39'),(993,'default','added',197,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-08 15:39:28','2021-09-08 15:39:28'),(994,'default','status_changed',230,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-08 15:40:03','2021-09-08 15:40:03'),(995,'default','added',308,'App\\Contact',1,4,'App\\User','[]','2021-09-08 15:52:09','2021-09-08 15:52:09'),(996,'default','added',198,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-09-08 16:07:15','2021-09-08 16:07:15'),(997,'default','added',309,'App\\Contact',1,4,'App\\User','[]','2021-09-08 16:11:57','2021-09-08 16:11:57'),(998,'default','status_changed',303,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-08 16:26:22','2021-09-08 16:26:22'),(999,'default','added',310,'App\\Contact',1,4,'App\\User','[]','2021-09-08 16:41:06','2021-09-08 16:41:06'),(1000,'default','added',311,'App\\Contact',1,4,'App\\User','[]','2021-09-08 16:43:42','2021-09-08 16:43:42'),(1001,'default','added',199,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-08 17:12:13','2021-09-08 17:12:13'),(1002,'default','status_changed',304,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-08 17:12:31','2021-09-08 17:12:31'),(1003,'default','status_changed',305,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-08 17:23:23','2021-09-08 17:23:23'),(1004,'default','status_changed',307,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-08 17:23:36','2021-09-08 17:23:36'),(1005,'default','added',200,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-09-08 17:28:23','2021-09-08 17:28:23'),(1006,'default','status_changed',294,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-08 17:28:59','2021-09-08 17:28:59'),(1007,'default','added',201,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-09-08 18:20:32','2021-09-08 18:20:32'),(1008,'default','status_changed',278,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-08 18:20:59','2021-09-08 18:20:59'),(1009,'default','added',202,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-08 18:31:53','2021-09-08 18:31:53'),(1010,'default','status_changed',148,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-08 18:32:11','2021-09-08 18:32:11'),(1011,'default','added',312,'App\\Contact',1,4,'App\\User','[]','2021-09-08 18:32:49','2021-09-08 18:32:49'),(1012,'default','status_changed',308,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-08 18:39:12','2021-09-08 18:39:12'),(1013,'default','status_changed',301,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-08 18:48:00','2021-09-08 18:48:00'),(1014,'default','status_changed',299,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-08 18:48:10','2021-09-08 18:48:10'),(1015,'default','status_changed',302,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-08 18:48:27','2021-09-08 18:48:27'),(1016,'default','status_changed',290,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-08 18:48:46','2021-09-08 18:48:46'),(1017,'default','added',203,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-08 19:12:56','2021-09-08 19:12:56'),(1018,'default','status_changed',306,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-08 19:21:40','2021-09-08 19:21:40'),(1019,'default','status_changed',292,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-08 19:22:26','2021-09-08 19:22:26'),(1020,'default','added',313,'App\\Contact',1,4,'App\\User','[]','2021-09-08 19:38:22','2021-09-08 19:38:22'),(1021,'default','added',314,'App\\Contact',1,4,'App\\User','[]','2021-09-08 19:48:57','2021-09-08 19:48:57'),(1022,'default','added',315,'App\\Contact',1,4,'App\\User','[]','2021-09-08 19:50:32','2021-09-08 19:50:32'),(1023,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-08 19:58:37','2021-09-08 19:58:37'),(1024,'default','added',316,'App\\Contact',1,4,'App\\User','[]','2021-09-08 20:22:15','2021-09-08 20:22:15'),(1025,'default','added',317,'App\\Contact',1,4,'App\\User','[]','2021-09-08 20:28:34','2021-09-08 20:28:34'),(1026,'default','status_changed',309,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-08 20:28:57','2021-09-08 20:28:57'),(1027,'default','added',318,'App\\Contact',1,4,'App\\User','[]','2021-09-08 20:42:15','2021-09-08 20:42:15'),(1028,'default','added',204,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-08 20:56:34','2021-09-08 20:56:34'),(1029,'default','status_changed',312,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-08 20:57:02','2021-09-08 20:57:02'),(1030,'default','added',205,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}','2021-09-08 21:50:37','2021-09-08 21:50:37'),(1031,'default','added',319,'App\\Contact',1,4,'App\\User','[]','2021-09-08 21:53:30','2021-09-08 21:53:30'),(1032,'default','status_changed',307,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-08 21:59:42','2021-09-08 21:59:42'),(1033,'default','status_changed',213,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-08 22:00:27','2021-09-08 22:00:27'),(1034,'default','added',206,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}','2021-09-08 22:15:04','2021-09-08 22:15:04'),(1035,'default','added',207,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1150}}','2021-09-08 22:18:28','2021-09-08 22:18:28'),(1036,'default','status_changed',291,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-08 22:19:49','2021-09-08 22:19:49'),(1037,'default','added',208,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}','2021-09-09 00:04:58','2021-09-09 00:04:58'),(1038,'default','added',209,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-09 00:06:39','2021-09-09 00:06:39'),(1039,'default','status_changed',209,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-09 00:07:04','2021-09-09 00:07:04'),(1040,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-09 12:43:02','2021-09-09 12:43:02'),(1041,'default','added',210,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-09-09 12:49:50','2021-09-09 12:49:50'),(1042,'default','status_changed',293,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-09 12:51:01','2021-09-09 12:51:01'),(1043,'default','added',211,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-09-09 13:55:26','2021-09-09 13:55:26'),(1044,'default','added',212,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-09-09 13:58:44','2021-09-09 13:58:44'),(1045,'default','status_changed',289,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-09 14:00:45','2021-09-09 14:00:45'),(1046,'default','added',320,'App\\Contact',1,4,'App\\User','[]','2021-09-09 14:09:59','2021-09-09 14:09:59'),(1047,'default','added',321,'App\\Contact',1,4,'App\\User','[]','2021-09-09 14:46:32','2021-09-09 14:46:32'),(1048,'default','added',213,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":725}}','2021-09-09 15:00:04','2021-09-09 15:00:04'),(1049,'default','status_changed',305,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-09 15:00:30','2021-09-09 15:00:30'),(1050,'default','added',214,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-09-09 15:53:40','2021-09-09 15:53:40'),(1051,'default','status_changed',300,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-09 15:54:03','2021-09-09 15:54:03'),(1052,'default','status_changed',315,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-09 15:55:12','2021-09-09 15:55:12'),(1053,'default','added',322,'App\\Contact',1,4,'App\\User','[]','2021-09-09 16:03:22','2021-09-09 16:03:22'),(1054,'default','added',323,'App\\Contact',1,4,'App\\User','[]','2021-09-09 16:08:00','2021-09-09 16:08:00'),(1055,'default','added',324,'App\\Contact',1,4,'App\\User','[]','2021-09-09 16:22:32','2021-09-09 16:22:32'),(1056,'default','added',325,'App\\Contact',1,4,'App\\User','[]','2021-09-09 16:26:50','2021-09-09 16:26:50'),(1057,'default','added',326,'App\\Contact',1,4,'App\\User','[]','2021-09-09 16:46:55','2021-09-09 16:46:55'),(1058,'default','status_changed',317,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-09 17:11:55','2021-09-09 17:11:55'),(1059,'default','status_changed',316,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-09 17:14:09','2021-09-09 17:14:09'),(1060,'default','status_changed',314,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-09 17:14:19','2021-09-09 17:14:19'),(1061,'default','status_changed',319,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-09 17:14:29','2021-09-09 17:14:29'),(1062,'default','status_changed',313,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-09 17:14:40','2021-09-09 17:14:40'),(1063,'default','added',215,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":125}}','2021-09-09 17:16:52','2021-09-09 17:16:52'),(1064,'default','status_changed',321,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-09 17:17:30','2021-09-09 17:17:30'),(1065,'default','status_changed',309,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":\"\\u0631\\u0641\\u0636 \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644 \\u0627\\u0644\\u0627\\u0635\\u0644\\u0627\\u062d\",\"updated_status\":\"Can\'t be repaired\"}','2021-09-09 17:18:20','2021-09-09 17:18:20'),(1066,'default','added',327,'App\\Contact',1,4,'App\\User','[]','2021-09-09 18:41:01','2021-09-09 18:41:01'),(1067,'default','status_changed',309,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-09 18:46:00','2021-09-09 18:46:00'),(1068,'default','added',328,'App\\Contact',1,4,'App\\User','[]','2021-09-09 19:10:12','2021-09-09 19:10:12'),(1069,'default','added',216,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1200}}','2021-09-09 19:12:00','2021-09-09 19:12:00'),(1070,'default','status_changed',324,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-09 19:12:59','2021-09-09 19:12:59'),(1071,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-09 19:43:00','2021-09-09 19:43:00'),(1072,'default','status_changed',322,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-09 19:44:59','2021-09-09 19:44:59'),(1073,'default','status_changed',314,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-09 19:45:47','2021-09-09 19:45:47'),(1074,'default','added',217,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-09 19:47:21','2021-09-09 19:47:21'),(1075,'default','status_changed',319,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-09 19:47:58','2021-09-09 19:47:58'),(1076,'default','added',329,'App\\Contact',1,4,'App\\User','[]','2021-09-09 20:37:39','2021-09-09 20:37:39'),(1077,'default','added',218,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-09-09 20:41:06','2021-09-09 20:41:06'),(1078,'default','status_changed',314,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-09 20:41:32','2021-09-09 20:41:32'),(1079,'default','added',330,'App\\Contact',1,4,'App\\User','[]','2021-09-09 20:45:27','2021-09-09 20:45:27'),(1080,'default','added',219,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-09-09 20:48:28','2021-09-09 20:48:28'),(1081,'default','added',331,'App\\Contact',1,4,'App\\User','[]','2021-09-09 21:05:36','2021-09-09 21:05:36'),(1082,'default','added',332,'App\\Contact',1,4,'App\\User','[]','2021-09-09 21:05:52','2021-09-09 21:05:52'),(1083,'default','status_changed',313,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-09 21:07:54','2021-09-09 21:07:54'),(1084,'default','status_changed',308,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-09 21:08:08','2021-09-09 21:08:08'),(1085,'default','status_changed',308,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Can\'t be repaired\"}','2021-09-09 21:08:18','2021-09-09 21:08:18'),(1086,'default','status_changed',316,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-09 21:08:34','2021-09-09 21:08:34'),(1087,'default','added',220,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-09 21:09:06','2021-09-09 21:09:06'),(1088,'default','added',221,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-09 21:22:25','2021-09-09 21:22:25'),(1089,'default','status_changed',316,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-09 21:23:07','2021-09-09 21:23:07'),(1090,'default','added',222,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":175}}','2021-09-09 21:37:14','2021-09-09 21:37:14'),(1091,'default','status_changed',302,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-09 21:37:34','2021-09-09 21:37:34'),(1092,'default','added',223,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1100}}','2021-09-09 21:38:00','2021-09-09 21:38:00'),(1093,'default','status_changed',70,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-09 21:38:19','2021-09-09 21:38:19'),(1094,'default','added',333,'App\\Contact',1,4,'App\\User','[]','2021-09-09 22:01:35','2021-09-09 22:01:35'),(1095,'default','added',334,'App\\Contact',1,4,'App\\User','[]','2021-09-09 22:03:19','2021-09-09 22:03:19'),(1096,'default','status_changed',325,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-09 22:56:38','2021-09-09 22:56:38'),(1097,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-10 14:13:20','2021-09-10 14:13:20'),(1098,'default','added',335,'App\\Contact',1,4,'App\\User','[]','2021-09-10 14:16:42','2021-09-10 14:16:42'),(1099,'default','added',336,'App\\Contact',1,4,'App\\User','[]','2021-09-10 16:24:43','2021-09-10 16:24:43'),(1100,'default','added',337,'App\\Contact',1,4,'App\\User','[]','2021-09-10 16:48:13','2021-09-10 16:48:13'),(1101,'default','added',338,'App\\Contact',1,4,'App\\User','[]','2021-09-10 17:23:50','2021-09-10 17:23:50'),(1102,'default','added',339,'App\\Contact',1,4,'App\\User','[]','2021-09-10 17:27:15','2021-09-10 17:27:15'),(1103,'default','added',340,'App\\Contact',1,4,'App\\User','[]','2021-09-10 17:40:22','2021-09-10 17:40:22'),(1104,'default','added',341,'App\\Contact',1,4,'App\\User','[]','2021-09-10 19:11:53','2021-09-10 19:11:53'),(1105,'default','added',342,'App\\Contact',1,4,'App\\User','[]','2021-09-10 19:45:04','2021-09-10 19:45:04'),(1106,'default','added',343,'App\\Contact',1,4,'App\\User','[]','2021-09-10 20:36:05','2021-09-10 20:36:05'),(1107,'default','added',344,'App\\Contact',1,4,'App\\User','[]','2021-09-10 20:41:08','2021-09-10 20:41:08'),(1108,'default','added',224,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-10 22:39:36','2021-09-10 22:39:36'),(1109,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-11 10:33:23','2021-09-11 10:33:23'),(1110,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-11 12:19:36','2021-09-11 12:19:36'),(1111,'default','added',345,'App\\Contact',1,4,'App\\User','[]','2021-09-11 12:36:48','2021-09-11 12:36:48'),(1112,'default','added',225,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-11 12:39:32','2021-09-11 12:39:32'),(1113,'default','added',346,'App\\Contact',1,4,'App\\User','[]','2021-09-11 13:15:04','2021-09-11 13:15:04'),(1114,'default','added',226,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-11 13:33:07','2021-09-11 13:33:07'),(1115,'default','status_changed',325,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-11 13:35:31','2021-09-11 13:35:31'),(1116,'default','added',227,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-11 13:37:43','2021-09-11 13:37:43'),(1117,'default','added',228,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-11 13:38:17','2021-09-11 13:38:17'),(1118,'default','status_changed',318,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-11 13:38:39','2021-09-11 13:38:39'),(1119,'default','added',347,'App\\Contact',1,4,'App\\User','[]','2021-09-11 13:43:27','2021-09-11 13:43:27'),(1120,'default','status_changed',313,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-11 14:18:07','2021-09-11 14:18:07'),(1121,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-11 14:35:04','2021-09-11 14:35:04'),(1122,'default','added',348,'App\\Contact',1,4,'App\\User','[]','2021-09-11 14:52:46','2021-09-11 14:52:46'),(1123,'default','status_changed',242,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-11 14:58:51','2021-09-11 14:58:51'),(1124,'default','status_changed',144,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-11 15:00:51','2021-09-11 15:00:51'),(1125,'default','status_changed',306,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-11 15:02:24','2021-09-11 15:02:24'),(1126,'default','status_changed',229,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-11 15:07:03','2021-09-11 15:07:03'),(1127,'default','added',349,'App\\Contact',1,1,'App\\User','[]','2021-09-11 15:16:37','2021-09-11 15:16:37'),(1128,'default','edited',16,'App\\User',1,1,'App\\User','[]','2021-09-11 15:19:39','2021-09-11 15:19:39'),(1129,'default','status_changed',124,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-11 15:30:18','2021-09-11 15:30:18'),(1130,'default','added',350,'App\\Contact',1,4,'App\\User','[]','2021-09-11 15:32:29','2021-09-11 15:32:29'),(1131,'default','added',351,'App\\Contact',1,4,'App\\User','[]','2021-09-11 15:34:54','2021-09-11 15:34:54'),(1132,'default','added',229,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-09-11 15:36:30','2021-09-11 15:36:30'),(1133,'default','status_changed',339,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-11 15:47:48','2021-09-11 15:47:48'),(1134,'default','status_changed',326,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-11 15:50:21','2021-09-11 15:50:21'),(1135,'default','status_changed',344,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-11 15:50:39','2021-09-11 15:50:39'),(1136,'default','status_changed',346,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-11 15:50:51','2021-09-11 15:50:51'),(1137,'default','status_changed',342,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-11 15:51:06','2021-09-11 15:51:06'),(1138,'default','status_changed',331,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-11 15:51:23','2021-09-11 15:51:23'),(1139,'default','status_changed',327,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-11 15:51:35','2021-09-11 15:51:35'),(1140,'default','added',352,'App\\Contact',1,4,'App\\User','[]','2021-09-11 15:55:38','2021-09-11 15:55:38'),(1141,'default','added',353,'App\\Contact',1,4,'App\\User','[]','2021-09-11 15:56:44','2021-09-11 15:56:44'),(1142,'default','status_changed',334,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-11 16:01:56','2021-09-11 16:01:56'),(1143,'default','status_changed',335,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-11 16:02:09','2021-09-11 16:02:09'),(1144,'default','added',354,'App\\Contact',1,4,'App\\User','[]','2021-09-11 16:06:45','2021-09-11 16:06:45'),(1145,'default','added',230,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-09-11 16:11:53','2021-09-11 16:11:53'),(1146,'default','added',355,'App\\Contact',1,4,'App\\User','[]','2021-09-11 16:24:48','2021-09-11 16:24:48'),(1147,'default','added',356,'App\\Contact',1,4,'App\\User','[]','2021-09-11 16:28:55','2021-09-11 16:28:55'),(1148,'default','added',231,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-11 16:31:41','2021-09-11 16:31:41'),(1149,'default','added',357,'App\\Contact',1,4,'App\\User','[]','2021-09-11 17:00:23','2021-09-11 17:00:23'),(1150,'default','status_changed',353,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-11 17:21:59','2021-09-11 17:21:59'),(1151,'default','added',358,'App\\Contact',1,4,'App\\User','[]','2021-09-11 17:28:17','2021-09-11 17:28:17'),(1152,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-11 18:16:43','2021-09-11 18:16:43'),(1153,'default','added',359,'App\\Contact',1,11,'App\\User','[]','2021-09-11 18:17:49','2021-09-11 18:17:49'),(1154,'default','added',360,'App\\Contact',1,4,'App\\User','[]','2021-09-11 18:23:03','2021-09-11 18:23:03'),(1155,'default','added',232,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-09-11 18:28:51','2021-09-11 18:28:51'),(1156,'default','status_changed',56,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-11 18:34:48','2021-09-11 18:34:48'),(1157,'default','added',361,'App\\Contact',1,4,'App\\User','[]','2021-09-11 18:48:24','2021-09-11 18:48:24'),(1158,'default','added',362,'App\\Contact',1,11,'App\\User','[]','2021-09-11 18:51:31','2021-09-11 18:51:31'),(1159,'default','added',233,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-11 18:52:34','2021-09-11 18:52:34'),(1160,'default','added',234,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-11 18:55:24','2021-09-11 18:55:24'),(1161,'default','status_changed',348,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-11 18:55:44','2021-09-11 18:55:44'),(1162,'default','added',363,'App\\Contact',1,11,'App\\User','[]','2021-09-11 19:02:55','2021-09-11 19:02:55'),(1163,'default','added',364,'App\\Contact',1,4,'App\\User','[]','2021-09-11 19:28:15','2021-09-11 19:28:15'),(1164,'default','added',365,'App\\Contact',1,4,'App\\User','[]','2021-09-11 19:49:31','2021-09-11 19:49:31'),(1165,'default','added',235,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-09-11 19:53:13','2021-09-11 19:53:13'),(1166,'default','status_changed',331,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-11 19:53:38','2021-09-11 19:53:38'),(1167,'default','added',236,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-09-11 19:57:50','2021-09-11 19:57:50'),(1168,'default','status_changed',344,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-11 19:58:41','2021-09-11 19:58:41'),(1169,'default','added',366,'App\\Contact',1,4,'App\\User','[]','2021-09-11 20:22:35','2021-09-11 20:22:35'),(1170,'default','added',237,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-09-11 20:26:33','2021-09-11 20:26:33'),(1171,'default','added',238,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}','2021-09-11 20:28:58','2021-09-11 20:28:58'),(1172,'default','added',239,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-11 20:38:17','2021-09-11 20:38:17'),(1173,'default','status_changed',333,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Waiting for customer approve\"}','2021-09-11 21:14:17','2021-09-11 21:14:17'),(1174,'default','status_changed',357,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-11 21:24:36','2021-09-11 21:24:36'),(1175,'default','status_changed',361,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-11 21:24:49','2021-09-11 21:24:49'),(1176,'default','status_changed',356,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-11 21:25:21','2021-09-11 21:25:21'),(1177,'default','added',367,'App\\Contact',1,4,'App\\User','[]','2021-09-11 21:34:41','2021-09-11 21:34:41'),(1178,'default','added',368,'App\\Contact',1,4,'App\\User','[]','2021-09-11 21:55:49','2021-09-11 21:55:49'),(1179,'default','added',240,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3500}}','2021-09-11 22:02:08','2021-09-11 22:02:08'),(1180,'default','status_changed',364,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-11 22:02:23','2021-09-11 22:02:23'),(1181,'default','status_changed',357,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-11 22:33:23','2021-09-11 22:33:23'),(1182,'default','added',241,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}','2021-09-11 22:43:04','2021-09-11 22:43:04'),(1183,'default','status_changed',349,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-11 22:43:37','2021-09-11 22:43:37'),(1184,'default','status_changed',351,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-11 23:00:18','2021-09-11 23:00:18'),(1185,'default','added',369,'App\\Contact',1,4,'App\\User','[]','2021-09-11 23:18:57','2021-09-11 23:18:57'),(1186,'default','status_changed',346,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-11 23:27:55','2021-09-11 23:27:55'),(1187,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-09-11 23:43:45','2021-09-11 23:43:45'),(1188,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-12 12:59:12','2021-09-12 12:59:12'),(1189,'default','added',370,'App\\Contact',1,4,'App\\User','[]','2021-09-12 12:59:47','2021-09-12 12:59:47'),(1190,'default','added',371,'App\\Contact',1,4,'App\\User','[]','2021-09-12 13:07:31','2021-09-12 13:07:31'),(1191,'default','added',242,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-12 13:11:19','2021-09-12 13:11:19'),(1192,'default','status_changed',322,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-12 13:12:32','2021-09-12 13:12:32'),(1193,'default','added',243,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}','2021-09-12 13:16:36','2021-09-12 13:16:36'),(1194,'default','added',372,'App\\Contact',1,4,'App\\User','[]','2021-09-12 13:51:01','2021-09-12 13:51:01'),(1195,'default','added',244,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-12 13:58:44','2021-09-12 13:58:44'),(1196,'default','status_changed',317,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-12 13:59:44','2021-09-12 13:59:44'),(1197,'default','status_changed',194,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-12 14:01:58','2021-09-12 14:01:58'),(1198,'default','status_changed',361,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-12 14:55:18','2021-09-12 14:55:18'),(1199,'default','status_changed',363,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-12 14:56:27','2021-09-12 14:56:27'),(1200,'default','status_changed',365,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-12 14:56:41','2021-09-12 14:56:41'),(1201,'default','status_changed',367,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-12 14:56:51','2021-09-12 14:56:51'),(1202,'default','status_changed',360,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-12 14:57:05','2021-09-12 14:57:05'),(1203,'default','status_changed',354,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-12 14:57:20','2021-09-12 14:57:20'),(1204,'default','status_changed',362,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-12 14:57:44','2021-09-12 14:57:44'),(1205,'default','status_changed',368,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-12 14:58:15','2021-09-12 14:58:15'),(1206,'default','status_changed',358,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-12 14:58:24','2021-09-12 14:58:24'),(1207,'default','status_changed',350,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-12 14:58:39','2021-09-12 14:58:39'),(1208,'default','status_changed',355,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-12 14:58:58','2021-09-12 14:58:58'),(1209,'default','status_changed',359,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-12 15:00:18','2021-09-12 15:00:18'),(1210,'default','added',373,'App\\Contact',1,4,'App\\User','[]','2021-09-12 15:05:57','2021-09-12 15:05:57'),(1211,'default','added',374,'App\\Contact',1,4,'App\\User','[]','2021-09-12 15:34:09','2021-09-12 15:34:09'),(1212,'default','added',375,'App\\Contact',1,4,'App\\User','[]','2021-09-12 16:01:28','2021-09-12 16:01:28'),(1213,'default','added',376,'App\\Contact',1,4,'App\\User','[]','2021-09-12 16:08:44','2021-09-12 16:08:44'),(1214,'default','added',377,'App\\Contact',1,4,'App\\User','[]','2021-09-12 16:15:12','2021-09-12 16:15:12'),(1215,'default','added',245,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1200}}','2021-09-12 16:31:35','2021-09-12 16:31:35'),(1216,'default','status_changed',290,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-12 16:32:02','2021-09-12 16:32:02'),(1217,'default','added',378,'App\\Contact',1,4,'App\\User','[]','2021-09-12 16:32:57','2021-09-12 16:32:57'),(1218,'default','status_changed',341,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-12 16:33:45','2021-09-12 16:33:45'),(1219,'default','status_changed',370,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-12 16:33:54','2021-09-12 16:33:54'),(1220,'default','status_changed',373,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-12 16:35:16','2021-09-12 16:35:16'),(1221,'default','added',246,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-09-12 16:53:21','2021-09-12 16:53:21'),(1222,'default','status_changed',350,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-12 16:58:00','2021-09-12 16:58:00'),(1223,'default','status_changed',327,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-12 16:58:24','2021-09-12 16:58:24'),(1224,'default','added',379,'App\\Contact',1,4,'App\\User','[]','2021-09-12 16:59:33','2021-09-12 16:59:33'),(1225,'default','added',247,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-12 17:16:45','2021-09-12 17:16:45'),(1226,'default','added',248,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-09-12 17:39:25','2021-09-12 17:39:25'),(1227,'default','added',249,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-12 17:44:56','2021-09-12 17:44:56'),(1228,'default','status_changed',372,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-12 17:45:10','2021-09-12 17:45:10'),(1229,'default','status_changed',341,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-12 17:45:30','2021-09-12 17:45:30'),(1230,'default','added',250,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-12 17:58:58','2021-09-12 17:58:58'),(1231,'default','status_changed',358,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-12 17:59:14','2021-09-12 17:59:14'),(1232,'default','added',251,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-12 18:09:28','2021-09-12 18:09:28'),(1233,'default','added',380,'App\\Contact',1,4,'App\\User','[]','2021-09-12 18:10:51','2021-09-12 18:10:51'),(1234,'default','added',381,'App\\Contact',1,4,'App\\User','[]','2021-09-12 18:26:13','2021-09-12 18:26:13'),(1235,'default','added',382,'App\\Contact',1,4,'App\\User','[]','2021-09-12 18:35:32','2021-09-12 18:35:32'),(1236,'default','added',383,'App\\Contact',1,4,'App\\User','[]','2021-09-12 18:39:58','2021-09-12 18:39:58'),(1237,'default','status_changed',332,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-12 19:09:48','2021-09-12 19:09:48'),(1238,'default','added',384,'App\\Contact',1,4,'App\\User','[]','2021-09-12 19:14:00','2021-09-12 19:14:00'),(1239,'default','added',385,'App\\Contact',1,4,'App\\User','[]','2021-09-12 19:23:17','2021-09-12 19:23:17'),(1240,'default','added',252,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}','2021-09-12 19:29:51','2021-09-12 19:29:51'),(1241,'default','status_changed',175,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-12 19:30:37','2021-09-12 19:30:37'),(1242,'default','added',253,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":125}}','2021-09-12 19:39:17','2021-09-12 19:39:17'),(1243,'default','status_changed',370,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-12 19:39:40','2021-09-12 19:39:40'),(1244,'default','added',386,'App\\Contact',1,4,'App\\User','[]','2021-09-12 19:50:57','2021-09-12 19:50:57'),(1245,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-12 20:03:12','2021-09-12 20:03:12'),(1246,'default','status_changed',371,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-12 20:03:47','2021-09-12 20:03:47'),(1247,'default','added',387,'App\\Contact',1,11,'App\\User','[]','2021-09-12 20:09:12','2021-09-12 20:09:12'),(1248,'default','added',388,'App\\Contact',1,11,'App\\User','[]','2021-09-12 20:23:54','2021-09-12 20:23:54'),(1249,'default','added',389,'App\\Contact',1,4,'App\\User','[]','2021-09-12 20:48:46','2021-09-12 20:48:46'),(1250,'default','added',390,'App\\Contact',1,4,'App\\User','[]','2021-09-12 21:05:26','2021-09-12 21:05:26'),(1251,'default','added',254,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-12 21:10:25','2021-09-12 21:10:25'),(1252,'default','status_changed',360,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-12 21:10:57','2021-09-12 21:10:57'),(1253,'default','added',255,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-09-12 21:18:08','2021-09-12 21:18:08'),(1254,'default','status_changed',367,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-12 21:18:59','2021-09-12 21:18:59'),(1255,'default','added',391,'App\\Contact',1,4,'App\\User','[]','2021-09-12 21:24:59','2021-09-12 21:24:59'),(1256,'default','added',392,'App\\Contact',1,4,'App\\User','[]','2021-09-12 21:37:42','2021-09-12 21:37:42'),(1257,'default','added',393,'App\\Contact',1,4,'App\\User','[]','2021-09-12 21:45:33','2021-09-12 21:45:33'),(1258,'default','added',394,'App\\Contact',1,4,'App\\User','[]','2021-09-12 21:47:08','2021-09-12 21:47:08'),(1259,'default','added',395,'App\\Contact',1,4,'App\\User','[]','2021-09-12 21:49:26','2021-09-12 21:49:26'),(1260,'default','added',396,'App\\Contact',1,4,'App\\User','[]','2021-09-12 21:51:01','2021-09-12 21:51:01'),(1261,'default','added',397,'App\\Contact',1,11,'App\\User','[]','2021-09-12 21:53:18','2021-09-12 21:53:18'),(1262,'default','added',256,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}','2021-09-12 21:55:48','2021-09-12 21:55:48'),(1263,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-09-12 21:56:01','2021-09-12 21:56:01'),(1264,'default','added',257,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-12 21:56:35','2021-09-12 21:56:35'),(1265,'default','status_changed',369,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-12 21:56:56','2021-09-12 21:56:56'),(1266,'default','added',398,'App\\Contact',1,11,'App\\User','[]','2021-09-12 21:59:24','2021-09-12 21:59:24'),(1267,'default','added',399,'App\\Contact',1,11,'App\\User','[]','2021-09-12 22:06:03','2021-09-12 22:06:03'),(1268,'default','added',258,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-09-12 22:09:21','2021-09-12 22:09:21'),(1269,'default','added',259,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-12 22:11:47','2021-09-12 22:11:47'),(1270,'default','status_changed',361,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-12 22:11:59','2021-09-12 22:11:59'),(1271,'default','added',260,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-09-12 22:12:32','2021-09-12 22:12:32'),(1272,'default','status_changed',374,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-12 22:12:50','2021-09-12 22:12:50'),(1273,'default','added',261,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-09-12 22:13:30','2021-09-12 22:13:30'),(1274,'default','added',262,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-12 22:14:04','2021-09-12 22:14:04'),(1275,'default','status_changed',376,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-12 22:14:38','2021-09-12 22:14:38'),(1276,'default','added',263,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-09-12 22:18:20','2021-09-12 22:18:20'),(1277,'default','status_changed',335,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-12 22:19:51','2021-09-12 22:19:51'),(1278,'default','added',264,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-09-12 22:31:25','2021-09-12 22:31:25'),(1279,'default','status_changed',363,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-12 22:32:22','2021-09-12 22:32:22'),(1280,'default','status_changed',385,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-12 22:35:04','2021-09-12 22:35:04'),(1281,'default','added',400,'App\\Contact',1,4,'App\\User','[]','2021-09-12 22:53:52','2021-09-12 22:53:52'),(1282,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-09-12 23:29:00','2021-09-12 23:29:00'),(1283,'default','edited',6,'App\\User',1,1,'App\\User','[]','2021-09-13 01:15:34','2021-09-13 01:15:34'),(1284,'default','login',6,'App\\User',1,6,'App\\User','[]','2021-09-13 01:16:54','2021-09-13 01:16:54'),(1285,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-13 01:24:36','2021-09-13 01:24:36'),(1286,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-09-13 01:26:20','2021-09-13 01:26:20'),(1287,'default','added',401,'App\\Contact',1,1,'App\\User','[]','2021-09-13 01:30:09','2021-09-13 01:30:09'),(1288,'default','added',402,'App\\Contact',1,1,'App\\User','[]','2021-09-13 01:59:28','2021-09-13 01:59:28'),(1289,'default','edited',334,'App\\Contact',1,1,'App\\User','[]','2021-09-13 02:02:22','2021-09-13 02:02:22'),(1290,'default','status_changed',399,'Modules\\Repair\\Entities\\JobSheet',1,1,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-13 02:05:05','2021-09-13 02:05:05'),(1291,'default','added',265,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-13 02:05:31','2021-09-13 02:05:31'),(1292,'default','added',266,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":100}}','2021-09-13 02:09:04','2021-09-13 02:09:04'),(1293,'default','added',267,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-13 02:20:39','2021-09-13 02:20:39'),(1294,'default','added',268,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-13 02:23:38','2021-09-13 02:23:38'),(1295,'default','added',269,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}','2021-09-13 02:40:53','2021-09-13 02:40:53'),(1296,'default','added',270,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}','2021-09-13 02:43:02','2021-09-13 02:43:02'),(1297,'default','added',271,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}','2021-09-13 02:52:50','2021-09-13 02:52:50'),(1298,'default','added',272,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}','2021-09-13 02:57:16','2021-09-13 02:57:16'),(1299,'default','added',273,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}','2021-09-13 02:59:05','2021-09-13 02:59:05'),(1300,'default','added',274,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}','2021-09-13 03:00:35','2021-09-13 03:00:35'),(1301,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-13 12:16:01','2021-09-13 12:16:01'),(1302,'default','added',403,'App\\Contact',1,4,'App\\User','[]','2021-09-13 12:18:19','2021-09-13 12:18:19'),(1303,'default','added',404,'App\\Contact',1,4,'App\\User','[]','2021-09-13 12:57:17','2021-09-13 12:57:17'),(1304,'default','added',275,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-13 13:53:57','2021-09-13 13:53:57'),(1305,'default','status_changed',368,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-13 13:54:17','2021-09-13 13:54:17'),(1306,'default','added',276,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-09-13 14:10:11','2021-09-13 14:10:11'),(1307,'default','status_changed',371,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-13 14:10:36','2021-09-13 14:10:36'),(1308,'default','added',405,'App\\Contact',1,4,'App\\User','[]','2021-09-13 14:22:12','2021-09-13 14:22:12'),(1309,'default','added',406,'App\\Contact',1,4,'App\\User','[]','2021-09-13 14:38:00','2021-09-13 14:38:00'),(1310,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-13 15:06:04','2021-09-13 15:06:04'),(1311,'default','status_changed',403,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-13 15:08:03','2021-09-13 15:08:03'),(1312,'default','login',16,'App\\User',1,16,'App\\User','[]','2021-09-13 15:45:14','2021-09-13 15:45:14'),(1313,'default','edited',16,'App\\User',1,1,'App\\User','[]','2021-09-13 16:11:30','2021-09-13 16:11:30'),(1314,'default','added',20,'App\\User',1,1,'App\\User','[]','2021-09-13 16:13:10','2021-09-13 16:13:10'),(1315,'default','added',277,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}','2021-09-13 16:30:24','2021-09-13 16:30:24'),(1316,'default','added',278,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}','2021-09-13 16:36:04','2021-09-13 16:36:04'),(1317,'default','added',279,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}','2021-09-13 16:44:19','2021-09-13 16:44:19'),(1318,'default','added',280,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-13 16:56:28','2021-09-13 16:56:28'),(1319,'default','added',281,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":500}}','2021-09-13 17:06:08','2021-09-13 17:06:08'),(1320,'default','added',282,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}','2021-09-13 17:19:48','2021-09-13 17:19:48'),(1321,'default','added',283,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}','2021-09-13 17:21:17','2021-09-13 17:21:17'),(1322,'default','added',284,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}','2021-09-13 17:24:21','2021-09-13 17:24:21'),(1323,'default','added',285,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-13 17:26:18','2021-09-13 17:26:18'),(1324,'default','status_changed',354,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-13 17:26:39','2021-09-13 17:26:39'),(1325,'default','added',286,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}','2021-09-13 17:33:11','2021-09-13 17:33:11'),(1326,'default','added',287,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}','2021-09-13 17:56:27','2021-09-13 17:56:27'),(1327,'default','added',288,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-13 17:59:02','2021-09-13 17:59:02'),(1328,'default','status_changed',386,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-13 17:59:29','2021-09-13 17:59:29'),(1329,'default','added',407,'App\\Contact',1,4,'App\\User','[]','2021-09-13 18:08:38','2021-09-13 18:08:38'),(1330,'default','added',408,'App\\Contact',1,4,'App\\User','[]','2021-09-13 18:18:53','2021-09-13 18:18:53'),(1331,'default','added',409,'App\\Contact',1,4,'App\\User','[]','2021-09-13 18:23:15','2021-09-13 18:23:15'),(1332,'default','added',410,'App\\Contact',1,4,'App\\User','[]','2021-09-13 18:25:06','2021-09-13 18:25:06'),(1333,'default','added',289,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":125}}','2021-09-13 18:35:17','2021-09-13 18:35:17'),(1334,'default','status_changed',379,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-13 18:35:44','2021-09-13 18:35:44'),(1335,'default','added',290,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2300}}','2021-09-13 18:45:37','2021-09-13 18:45:37'),(1336,'default','status_changed',356,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-13 18:49:03','2021-09-13 18:49:03'),(1337,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-13 19:42:23','2021-09-13 19:42:23'),(1338,'default','added',411,'App\\Contact',1,4,'App\\User','[]','2021-09-13 19:42:57','2021-09-13 19:42:57'),(1339,'default','added',291,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-13 20:16:23','2021-09-13 20:16:23'),(1340,'default','status_changed',355,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-13 20:16:45','2021-09-13 20:16:45'),(1341,'default','added',292,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-13 20:18:10','2021-09-13 20:18:10'),(1342,'default','status_changed',359,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-13 20:18:30','2021-09-13 20:18:30'),(1343,'default','status_changed',330,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-13 20:21:17','2021-09-13 20:21:17'),(1344,'default','added',412,'App\\Contact',1,11,'App\\User','[]','2021-09-13 20:25:15','2021-09-13 20:25:15'),(1345,'default','added',413,'App\\Contact',1,11,'App\\User','[]','2021-09-13 20:27:26','2021-09-13 20:27:26'),(1346,'default','added',414,'App\\Contact',1,4,'App\\User','[]','2021-09-13 20:31:16','2021-09-13 20:31:16'),(1347,'default','added',293,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-13 20:35:09','2021-09-13 20:35:09'),(1348,'default','status_changed',377,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-13 20:35:37','2021-09-13 20:35:37'),(1349,'default','added',415,'App\\Contact',1,4,'App\\User','[]','2021-09-13 20:42:43','2021-09-13 20:42:43'),(1350,'default','status_changed',406,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-13 20:47:23','2021-09-13 20:47:23'),(1351,'default','added',294,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}','2021-09-13 21:02:02','2021-09-13 21:02:02'),(1352,'default','added',295,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-13 21:11:16','2021-09-13 21:11:16'),(1353,'default','status_changed',406,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-13 21:11:51','2021-09-13 21:11:51'),(1354,'default','status_changed',405,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-13 21:48:17','2021-09-13 21:48:17'),(1355,'default','added',296,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-09-13 21:59:15','2021-09-13 21:59:15'),(1356,'default','status_changed',402,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-13 21:59:42','2021-09-13 21:59:42'),(1357,'default','added',297,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-09-13 22:03:08','2021-09-13 22:03:08'),(1358,'default','added',298,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-09-13 22:03:56','2021-09-13 22:03:56'),(1359,'default','status_changed',405,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-13 22:05:15','2021-09-13 22:05:15'),(1360,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-13 22:38:37','2021-09-13 22:38:37'),(1361,'default','status_changed',384,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-13 22:39:05','2021-09-13 22:39:05'),(1362,'default','added',299,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}','2021-09-13 23:04:31','2021-09-13 23:04:31'),(1363,'default','added',300,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}','2021-09-13 23:06:54','2021-09-13 23:06:54'),(1364,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-14 12:38:47','2021-09-14 12:38:47'),(1365,'default','added',416,'App\\Contact',1,4,'App\\User','[]','2021-09-14 12:57:34','2021-09-14 12:57:34'),(1366,'default','status_changed',248,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 14:10:15','2021-09-14 14:10:15'),(1367,'default','status_changed',265,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 14:11:22','2021-09-14 14:11:22'),(1368,'default','status_changed',258,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 14:12:17','2021-09-14 14:12:17'),(1369,'default','status_changed',259,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 14:12:47','2021-09-14 14:12:47'),(1370,'default','status_changed',362,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 14:15:21','2021-09-14 14:15:21'),(1371,'default','status_changed',284,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 14:15:40','2021-09-14 14:15:40'),(1372,'default','status_changed',285,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 14:16:04','2021-09-14 14:16:04'),(1373,'default','status_changed',266,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 14:16:49','2021-09-14 14:16:49'),(1374,'default','status_changed',271,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 14:18:24','2021-09-14 14:18:24'),(1375,'default','status_changed',250,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 14:27:20','2021-09-14 14:27:20'),(1376,'default','status_changed',257,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 14:30:12','2021-09-14 14:30:12'),(1377,'default','status_changed',268,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 14:31:42','2021-09-14 14:31:42'),(1378,'default','status_changed',282,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 14:37:59','2021-09-14 14:37:59'),(1379,'default','status_changed',255,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 14:39:18','2021-09-14 14:39:18'),(1380,'default','status_changed',264,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 14:39:46','2021-09-14 14:39:46'),(1381,'default','status_changed',263,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 14:40:24','2021-09-14 14:40:24'),(1382,'default','status_changed',247,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 14:40:36','2021-09-14 14:40:36'),(1383,'default','added',301,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-09-14 14:43:55','2021-09-14 14:43:55'),(1384,'default','status_changed',337,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 14:44:16','2021-09-14 14:44:16'),(1385,'default','status_changed',256,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 14:54:10','2021-09-14 14:54:10'),(1386,'default','status_changed',392,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 14:55:12','2021-09-14 14:55:12'),(1387,'default','status_changed',272,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 14:55:39','2021-09-14 14:55:39'),(1388,'default','status_changed',404,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 15:01:59','2021-09-14 15:01:59'),(1389,'default','edited',11,'App\\User',1,4,'App\\User','[]','2021-09-14 15:04:25','2021-09-14 15:04:25'),(1390,'default','added',302,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1100}}','2021-09-14 15:15:38','2021-09-14 15:15:38'),(1391,'default','status_changed',183,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 15:18:01','2021-09-14 15:18:01'),(1392,'default','status_changed',233,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 15:18:25','2021-09-14 15:18:25'),(1393,'default','status_changed',270,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 15:20:42','2021-09-14 15:20:42'),(1394,'default','status_changed',283,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 15:20:54','2021-09-14 15:20:54'),(1395,'default','status_changed',286,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-14 15:21:13','2021-09-14 15:21:13'),(1396,'default','status_changed',347,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 15:27:58','2021-09-14 15:27:58'),(1397,'default','status_changed',340,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 15:29:33','2021-09-14 15:29:33'),(1398,'default','status_changed',350,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 15:31:03','2021-09-14 15:31:03'),(1399,'default','added',303,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2250}}','2021-09-14 16:05:51','2021-09-14 16:05:51'),(1400,'default','added',417,'App\\Contact',1,4,'App\\User','[]','2021-09-14 16:12:47','2021-09-14 16:12:47'),(1401,'default','added',418,'App\\Contact',1,4,'App\\User','[]','2021-09-14 16:17:04','2021-09-14 16:17:04'),(1402,'default','added',419,'App\\Contact',1,4,'App\\User','[]','2021-09-14 16:24:40','2021-09-14 16:24:40'),(1403,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-14 16:30:57','2021-09-14 16:30:57'),(1404,'default','added',420,'App\\Contact',1,4,'App\\User','[]','2021-09-14 17:19:42','2021-09-14 17:19:42'),(1405,'default','added',421,'App\\Contact',1,4,'App\\User','[]','2021-09-14 17:27:21','2021-09-14 17:27:21'),(1406,'default','added',422,'App\\Contact',1,4,'App\\User','[]','2021-09-14 17:47:57','2021-09-14 17:47:57'),(1407,'default','status_changed',375,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-14 18:18:38','2021-09-14 18:18:38'),(1408,'default','status_changed',415,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-14 18:18:51','2021-09-14 18:18:51'),(1409,'default','added',304,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-14 18:19:03','2021-09-14 18:19:03'),(1410,'default','status_changed',417,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-14 18:19:05','2021-09-14 18:19:05'),(1411,'default','status_changed',417,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-14 18:22:53','2021-09-14 18:22:53'),(1412,'default','status_changed',388,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-14 18:24:27','2021-09-14 18:24:27'),(1413,'default','status_changed',409,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-14 18:24:42','2021-09-14 18:24:42'),(1414,'default','status_changed',414,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 18:24:53','2021-09-14 18:24:53'),(1415,'default','status_changed',412,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-14 18:25:02','2021-09-14 18:25:02'),(1416,'default','status_changed',419,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-14 18:25:14','2021-09-14 18:25:14'),(1417,'default','status_changed',408,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-14 18:27:30','2021-09-14 18:27:30'),(1418,'default','status_changed',366,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 18:31:28','2021-09-14 18:31:28'),(1419,'default','status_changed',329,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-14 18:31:52','2021-09-14 18:31:52'),(1420,'default','status_changed',410,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-14 18:32:06','2021-09-14 18:32:06'),(1421,'default','status_changed',387,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-14 18:32:14','2021-09-14 18:32:14'),(1422,'default','login',19,'App\\User',1,19,'App\\User','[]','2021-09-14 18:39:19','2021-09-14 18:39:19'),(1423,'default','added',305,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}','2021-09-14 19:01:35','2021-09-14 19:01:35'),(1424,'default','status_changed',395,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 19:01:48','2021-09-14 19:01:48'),(1425,'default','added',306,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}','2021-09-14 19:11:34','2021-09-14 19:11:34'),(1426,'default','status_changed',334,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 19:11:51','2021-09-14 19:11:51'),(1427,'default','added',423,'App\\Contact',1,4,'App\\User','[]','2021-09-14 19:16:56','2021-09-14 19:16:56'),(1428,'default','added',424,'App\\Contact',1,4,'App\\User','[]','2021-09-14 19:21:57','2021-09-14 19:21:57'),(1429,'default','status_changed',187,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 19:28:28','2021-09-14 19:28:28'),(1430,'default','added',425,'App\\Contact',1,4,'App\\User','[]','2021-09-14 19:32:43','2021-09-14 19:32:43'),(1431,'default','added',426,'App\\Contact',1,19,'App\\User','[]','2021-09-14 19:33:19','2021-09-14 19:33:19'),(1432,'default','added',307,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-14 19:51:04','2021-09-14 19:51:04'),(1433,'default','status_changed',390,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 19:51:20','2021-09-14 19:51:20'),(1434,'default','added',427,'App\\Contact',1,4,'App\\User','[]','2021-09-14 19:56:05','2021-09-14 19:56:05'),(1435,'default','added',308,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-14 20:04:04','2021-09-14 20:04:04'),(1436,'default','status_changed',417,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 20:04:35','2021-09-14 20:04:35'),(1437,'default','status_changed',422,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-14 20:11:40','2021-09-14 20:11:40'),(1438,'default','status_changed',423,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-14 20:11:56','2021-09-14 20:11:56'),(1439,'default','status_changed',420,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-14 20:12:02','2021-09-14 20:12:02'),(1440,'default','status_changed',421,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-14 20:12:09','2021-09-14 20:12:09'),(1441,'default','added',309,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-09-14 20:27:59','2021-09-14 20:27:59'),(1442,'default','status_changed',412,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 20:28:26','2021-09-14 20:28:26'),(1443,'default','added',428,'App\\Contact',1,4,'App\\User','[]','2021-09-14 20:28:59','2021-09-14 20:28:59'),(1444,'default','added',429,'App\\Contact',1,4,'App\\User','[]','2021-09-14 20:32:37','2021-09-14 20:32:37'),(1445,'default','added',310,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-09-14 20:45:00','2021-09-14 20:45:00'),(1446,'default','status_changed',410,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 20:45:20','2021-09-14 20:45:20'),(1447,'default','logout',19,'App\\User',1,19,'App\\User','[]','2021-09-14 20:56:27','2021-09-14 20:56:27'),(1448,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-14 20:56:36','2021-09-14 20:56:36'),(1449,'default','added',430,'App\\Contact',1,11,'App\\User','[]','2021-09-14 20:57:37','2021-09-14 20:57:37'),(1450,'default','added',431,'App\\Contact',1,4,'App\\User','[]','2021-09-14 21:01:05','2021-09-14 21:01:05'),(1451,'default','added',311,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-14 21:15:18','2021-09-14 21:15:18'),(1452,'default','added',312,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-09-14 21:22:58','2021-09-14 21:22:58'),(1453,'default','status_changed',384,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 21:23:45','2021-09-14 21:23:45'),(1454,'default','added',313,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-14 21:28:44','2021-09-14 21:28:44'),(1455,'default','status_changed',401,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 21:29:01','2021-09-14 21:29:01'),(1456,'default','added',314,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-14 21:29:26','2021-09-14 21:29:26'),(1457,'default','status_changed',416,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 21:29:44','2021-09-14 21:29:44'),(1458,'default','added',432,'App\\Contact',1,11,'App\\User','[]','2021-09-14 21:39:57','2021-09-14 21:39:57'),(1459,'default','added',315,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-14 21:41:13','2021-09-14 21:41:13'),(1460,'default','status_changed',413,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 21:42:44','2021-09-14 21:42:44'),(1461,'default','added',433,'App\\Contact',1,4,'App\\User','[]','2021-09-14 21:50:39','2021-09-14 21:50:39'),(1462,'default','added',434,'App\\Contact',1,4,'App\\User','[]','2021-09-14 22:03:31','2021-09-14 22:03:31'),(1463,'default','added',435,'App\\Contact',1,4,'App\\User','[]','2021-09-14 22:07:01','2021-09-14 22:07:01'),(1464,'default','added',316,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":650}}','2021-09-14 22:19:17','2021-09-14 22:19:17'),(1465,'default','added',436,'App\\Contact',1,11,'App\\User','[]','2021-09-14 22:26:43','2021-09-14 22:26:43'),(1466,'default','added',437,'App\\Contact',1,4,'App\\User','[]','2021-09-14 22:35:29','2021-09-14 22:35:29'),(1467,'default','added',317,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-09-14 22:43:37','2021-09-14 22:43:37'),(1468,'default','status_changed',365,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-14 22:43:54','2021-09-14 22:43:54'),(1469,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-15 13:11:08','2021-09-15 13:11:08'),(1470,'default','added',318,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}','2021-09-15 13:52:49','2021-09-15 13:52:49'),(1471,'default','status_changed',353,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-15 13:53:52','2021-09-15 13:53:52'),(1472,'default','added',438,'App\\Contact',1,11,'App\\User','[]','2021-09-15 14:20:12','2021-09-15 14:20:12'),(1473,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-09-15 14:39:06','2021-09-15 14:39:06'),(1474,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-15 14:40:42','2021-09-15 14:40:42'),(1475,'default','added',319,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-09-15 14:44:42','2021-09-15 14:44:42'),(1476,'default','status_changed',339,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-15 14:45:10','2021-09-15 14:45:10'),(1477,'default','status_changed',433,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-15 15:01:31','2021-09-15 15:01:31'),(1478,'default','status_changed',431,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-15 15:01:39','2021-09-15 15:01:39'),(1479,'default','status_changed',429,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-15 15:01:51','2021-09-15 15:01:51'),(1480,'default','status_changed',427,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-15 15:02:12','2021-09-15 15:02:12'),(1481,'default','status_changed',435,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-15 15:02:23','2021-09-15 15:02:23'),(1482,'default','status_changed',434,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-15 15:02:31','2021-09-15 15:02:31'),(1483,'default','status_changed',430,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-15 15:02:40','2021-09-15 15:02:40'),(1484,'default','status_changed',428,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-15 15:02:48','2021-09-15 15:02:48'),(1485,'default','status_changed',424,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-15 15:02:56','2021-09-15 15:02:56'),(1486,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-15 15:11:58','2021-09-15 15:11:58'),(1487,'default','added',439,'App\\Contact',1,4,'App\\User','[]','2021-09-15 15:23:32','2021-09-15 15:23:32'),(1488,'default','status_changed',392,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-15 15:40:44','2021-09-15 15:40:44'),(1489,'default','added',320,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-09-15 16:54:41','2021-09-15 16:54:41'),(1490,'default','status_changed',224,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-15 16:55:17','2021-09-15 16:55:17'),(1491,'default','added',440,'App\\Contact',1,4,'App\\User','[]','2021-09-15 17:05:58','2021-09-15 17:05:58'),(1492,'default','added',441,'App\\Contact',1,4,'App\\User','[]','2021-09-15 17:23:59','2021-09-15 17:23:59'),(1493,'default','added',442,'App\\Contact',1,4,'App\\User','[]','2021-09-15 17:36:53','2021-09-15 17:36:53'),(1494,'default','status_changed',432,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-15 18:04:13','2021-09-15 18:04:13'),(1495,'default','status_changed',437,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-15 18:04:21','2021-09-15 18:04:21'),(1496,'default','status_changed',438,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-15 18:04:28','2021-09-15 18:04:28'),(1497,'default','status_changed',439,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-15 18:04:36','2021-09-15 18:04:36'),(1498,'default','status_changed',436,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-15 18:04:48','2021-09-15 18:04:48'),(1499,'default','added',321,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-15 19:10:21','2021-09-15 19:10:21'),(1500,'default','status_changed',387,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-15 19:10:44','2021-09-15 19:10:44'),(1501,'default','added',443,'App\\Contact',1,4,'App\\User','[]','2021-09-15 19:32:02','2021-09-15 19:32:02'),(1502,'default','added',444,'App\\Contact',1,4,'App\\User','[]','2021-09-15 19:50:40','2021-09-15 19:50:40'),(1503,'default','status_changed',440,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-15 19:58:41','2021-09-15 19:58:41'),(1504,'default','status_changed',441,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-15 19:58:49','2021-09-15 19:58:49'),(1505,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-15 20:04:28','2021-09-15 20:04:28'),(1506,'default','added',445,'App\\Contact',1,4,'App\\User','[]','2021-09-15 20:04:54','2021-09-15 20:04:54'),(1507,'default','added',446,'App\\Contact',1,4,'App\\User','[]','2021-09-15 20:05:08','2021-09-15 20:05:08'),(1508,'default','added',447,'App\\Contact',1,4,'App\\User','[]','2021-09-15 20:12:14','2021-09-15 20:12:14'),(1509,'default','added',448,'App\\Contact',1,4,'App\\User','[]','2021-09-15 20:12:31','2021-09-15 20:12:31'),(1510,'default','added',449,'App\\Contact',1,4,'App\\User','[]','2021-09-15 20:15:16','2021-09-15 20:15:16'),(1511,'default','added',322,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-15 20:38:54','2021-09-15 20:38:54'),(1512,'default','added',323,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-15 20:40:31','2021-09-15 20:40:31'),(1513,'default','added',324,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-15 20:42:26','2021-09-15 20:42:26'),(1514,'default','status_changed',435,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-15 20:43:19','2021-09-15 20:43:19'),(1515,'default','added',325,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-15 20:43:44','2021-09-15 20:43:44'),(1516,'default','status_changed',426,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-15 20:44:26','2021-09-15 20:44:26'),(1517,'default','added',326,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-09-15 20:55:29','2021-09-15 20:55:29'),(1518,'default','status_changed',434,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-15 20:56:29','2021-09-15 20:56:29'),(1519,'default','added',327,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-15 21:02:18','2021-09-15 21:02:18'),(1520,'default','added',450,'App\\Contact',1,4,'App\\User','[]','2021-09-15 21:08:28','2021-09-15 21:08:28'),(1521,'default','added',328,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-15 21:18:07','2021-09-15 21:18:07'),(1522,'default','added',451,'App\\Contact',1,4,'App\\User','[]','2021-09-15 21:30:03','2021-09-15 21:30:03'),(1523,'default','status_changed',448,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-15 21:52:07','2021-09-15 21:52:07'),(1524,'default','added',452,'App\\Contact',1,4,'App\\User','[]','2021-09-15 21:58:28','2021-09-15 21:58:28'),(1525,'default','status_changed',447,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-15 22:01:40','2021-09-15 22:01:40'),(1526,'default','added',453,'App\\Contact',1,4,'App\\User','[]','2021-09-15 22:05:32','2021-09-15 22:05:32'),(1527,'default','added',329,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-15 22:07:25','2021-09-15 22:07:25'),(1528,'default','status_changed',450,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-15 22:07:43','2021-09-15 22:07:43'),(1529,'default','added',330,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-09-15 22:10:48','2021-09-15 22:10:48'),(1530,'default','added',331,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-15 22:11:51','2021-09-15 22:11:51'),(1531,'default','status_changed',447,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-15 22:13:10','2021-09-15 22:13:10'),(1532,'default','added',332,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-15 22:37:29','2021-09-15 22:37:29'),(1533,'default','status_changed',448,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-15 22:37:43','2021-09-15 22:37:43'),(1534,'default','added',333,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-15 22:55:23','2021-09-15 22:55:23'),(1535,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-16 12:08:09','2021-09-16 12:08:09'),(1536,'default','added',334,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-16 12:48:36','2021-09-16 12:48:36'),(1537,'default','status_changed',389,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-16 12:54:31','2021-09-16 12:54:31'),(1538,'default','status_changed',389,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-16 12:54:37','2021-09-16 12:54:37'),(1539,'default','status_changed',388,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-16 13:03:45','2021-09-16 13:03:45'),(1540,'default','added',454,'App\\Contact',1,11,'App\\User','[]','2021-09-16 13:17:51','2021-09-16 13:17:51'),(1541,'default','added',455,'App\\Contact',1,11,'App\\User','[]','2021-09-16 13:18:55','2021-09-16 13:18:55'),(1542,'default','added',456,'App\\Contact',1,11,'App\\User','[]','2021-09-16 13:19:58','2021-09-16 13:19:58'),(1543,'default','added',335,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}','2021-09-16 14:49:18','2021-09-16 14:49:18'),(1544,'default','added',336,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-16 14:50:32','2021-09-16 14:50:32'),(1545,'default','status_changed',332,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-16 14:50:57','2021-09-16 14:50:57'),(1546,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-09-16 16:00:10','2021-09-16 16:00:10'),(1547,'default','added',337,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-16 16:01:43','2021-09-16 16:01:43'),(1548,'default','status_changed',423,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-16 16:02:05','2021-09-16 16:02:05'),(1549,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-09-16 16:19:19','2021-09-16 16:19:19'),(1550,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-09-16 16:44:47','2021-09-16 16:44:47'),(1551,'default','added',457,'App\\Contact',1,11,'App\\User','[]','2021-09-16 16:59:16','2021-09-16 16:59:16'),(1552,'default','added',338,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2800}}','2021-09-16 17:05:27','2021-09-16 17:05:27'),(1553,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-09-16 17:12:51','2021-09-16 17:12:51'),(1554,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-09-16 17:14:10','2021-09-16 17:14:10'),(1555,'default','added',339,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-09-16 17:34:41','2021-09-16 17:34:41'),(1556,'default','edited',4,'App\\User',1,1,'App\\User','[]','2021-09-16 17:51:26','2021-09-16 17:51:26'),(1557,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-09-16 17:51:44','2021-09-16 17:51:44'),(1558,'default','added',458,'App\\Contact',1,11,'App\\User','[]','2021-09-16 17:52:17','2021-09-16 17:52:17'),(1559,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-16 17:52:22','2021-09-16 17:52:22'),(1560,'default','status_changed',419,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-16 17:56:02','2021-09-16 17:56:02'),(1561,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-09-16 18:39:59','2021-09-16 18:39:59'),(1562,'default','edited',3,'App\\User',1,1,'App\\User','[]','2021-09-16 18:40:42','2021-09-16 18:40:42'),(1563,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-09-16 18:43:03','2021-09-16 18:43:03'),(1564,'default','added',340,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":650}}','2021-09-16 19:38:22','2021-09-16 19:38:22'),(1565,'default','status_changed',433,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-16 19:38:45','2021-09-16 19:38:45'),(1566,'default','added',459,'App\\Contact',1,11,'App\\User','[]','2021-09-16 19:39:09','2021-09-16 19:39:09'),(1567,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-09-16 20:07:45','2021-09-16 20:07:45'),(1568,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-16 20:08:02','2021-09-16 20:08:02'),(1569,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-09-16 20:08:04','2021-09-16 20:08:04'),(1570,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-09-16 20:08:27','2021-09-16 20:08:27'),(1571,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-09-16 20:08:30','2021-09-16 20:08:30'),(1572,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-16 20:08:38','2021-09-16 20:08:38'),(1573,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-16 20:08:42','2021-09-16 20:08:42'),(1574,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-09-16 20:20:51','2021-09-16 20:20:51'),(1575,'default','added',460,'App\\Contact',1,11,'App\\User','[]','2021-09-16 20:21:13','2021-09-16 20:21:13'),(1576,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-09-16 20:24:57','2021-09-16 20:24:57'),(1577,'default','added',341,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-09-16 20:35:07','2021-09-16 20:35:07'),(1578,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-09-16 20:36:14','2021-09-16 20:36:14'),(1579,'default','status_changed',396,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-16 20:36:54','2021-09-16 20:36:54'),(1580,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-09-16 20:37:00','2021-09-16 20:37:00'),(1581,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-09-16 20:37:41','2021-09-16 20:37:41'),(1582,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-09-16 20:38:06','2021-09-16 20:38:06'),(1583,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-09-16 20:40:56','2021-09-16 20:40:56'),(1584,'default','added',342,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}','2021-09-16 20:42:49','2021-09-16 20:42:49'),(1585,'default','status_changed',458,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-16 20:54:46','2021-09-16 20:54:46'),(1586,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-09-16 20:56:59','2021-09-16 20:56:59'),(1587,'default','status_changed',445,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-09-16 20:57:23','2021-09-16 20:57:23'),(1588,'default','status_changed',458,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-09-16 20:57:32','2021-09-16 20:57:32'),(1589,'default','added',343,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-09-16 21:01:54','2021-09-16 21:01:54'),(1590,'default','added',344,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-09-16 21:02:31','2021-09-16 21:02:31'),(1591,'default','added',345,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}','2021-09-16 21:03:14','2021-09-16 21:03:14'),(1592,'default','status_changed',444,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-16 21:03:45','2021-09-16 21:03:45'),(1593,'default','status_changed',446,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-16 21:03:55','2021-09-16 21:03:55'),(1594,'default','status_changed',429,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-16 21:07:46','2021-09-16 21:07:46'),(1595,'default','added',346,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-16 21:11:48','2021-09-16 21:11:48'),(1596,'default','added',347,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}','2021-09-16 21:27:41','2021-09-16 21:27:41'),(1597,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-09-16 21:29:04','2021-09-16 21:29:04'),(1598,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-09-16 21:29:13','2021-09-16 21:29:13'),(1599,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-09-16 21:35:01','2021-09-16 21:35:01'),(1600,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-09-16 21:35:08','2021-09-16 21:35:08'),(1601,'default','added',461,'App\\Contact',1,4,'App\\User','[]','2021-09-16 21:41:18','2021-09-16 21:41:18'),(1602,'default','added',462,'App\\Contact',1,4,'App\\User','[]','2021-09-16 22:02:32','2021-09-16 22:02:32'),(1603,'default','added',348,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-09-16 22:04:02','2021-09-16 22:04:02'),(1604,'default','status_changed',415,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-16 22:04:18','2021-09-16 22:04:18'),(1605,'default','added',463,'App\\Contact',1,4,'App\\User','[]','2021-09-16 22:06:08','2021-09-16 22:06:08'),(1606,'default','added',349,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-16 22:08:44','2021-09-16 22:08:44'),(1607,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-09-16 22:11:29','2021-09-16 22:11:29'),(1608,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-16 22:12:00','2021-09-16 22:12:00'),(1609,'default','added',350,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-16 22:17:04','2021-09-16 22:17:04'),(1610,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-16 22:48:28','2021-09-16 22:48:28'),(1611,'default','added',351,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-09-16 23:07:38','2021-09-16 23:07:38'),(1612,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-09-16 23:08:57','2021-09-16 23:08:57'),(1613,'default','status_changed',326,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-16 23:09:14','2021-09-16 23:09:14'),(1614,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-16 23:10:13','2021-09-16 23:10:13'),(1615,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-09-16 23:10:24','2021-09-16 23:10:24'),(1616,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-16 23:11:23','2021-09-16 23:11:23'),(1617,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-09-16 23:14:45','2021-09-16 23:14:45'),(1618,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-09-17 00:25:33','2021-09-17 00:25:33'),(1619,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-09-17 00:30:46','2021-09-17 00:30:46'),(1620,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-09-17 13:21:54','2021-09-17 13:21:54'),(1621,'default','logout',20,'App\\User',1,20,'App\\User','[]','2021-09-17 13:23:30','2021-09-17 13:23:30'),(1622,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-09-17 13:23:54','2021-09-17 13:23:54'),(1623,'default','logout',20,'App\\User',1,20,'App\\User','[]','2021-09-17 13:25:57','2021-09-17 13:25:57'),(1624,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-17 13:26:08','2021-09-17 13:26:08'),(1625,'default','added',464,'App\\Contact',1,4,'App\\User','[]','2021-09-17 13:27:00','2021-09-17 13:27:00'),(1626,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-09-17 13:53:42','2021-09-17 13:53:42'),(1627,'default','edited',20,'App\\User',1,1,'App\\User','[]','2021-09-17 14:02:33','2021-09-17 14:02:33'),(1628,'default','added',465,'App\\Contact',1,4,'App\\User','[]','2021-09-17 16:02:25','2021-09-17 16:02:25'),(1629,'default','added',466,'App\\Contact',1,4,'App\\User','[]','2021-09-17 16:17:46','2021-09-17 16:17:46'),(1630,'default','added',467,'App\\Contact',1,4,'App\\User','[]','2021-09-17 17:48:17','2021-09-17 17:48:17'),(1631,'default','added',468,'App\\Contact',1,4,'App\\User','[]','2021-09-17 17:48:45','2021-09-17 17:48:45'),(1632,'default','added',469,'App\\Contact',1,4,'App\\User','[]','2021-09-17 18:05:21','2021-09-17 18:05:21'),(1633,'default','added',470,'App\\Contact',1,4,'App\\User','[]','2021-09-17 18:11:50','2021-09-17 18:11:50'),(1634,'default','status_changed',464,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-17 18:19:13','2021-09-17 18:19:13'),(1635,'default','added',352,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-17 18:19:27','2021-09-17 18:19:27'),(1636,'default','status_changed',464,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-17 18:21:17','2021-09-17 18:21:17'),(1637,'default','added',471,'App\\Contact',1,4,'App\\User','[]','2021-09-17 19:11:28','2021-09-17 19:11:28'),(1638,'default','added',353,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-09-17 19:14:24','2021-09-17 19:14:24'),(1639,'default','status_changed',467,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-17 19:15:01','2021-09-17 19:15:01'),(1640,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-09-17 20:18:22','2021-09-17 20:18:22'),(1641,'default','added',472,'App\\Contact',1,20,'App\\User','[]','2021-09-17 20:18:53','2021-09-17 20:18:53'),(1642,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-09-17 20:34:46','2021-09-17 20:34:46'),(1643,'default','added',473,'App\\Contact',1,20,'App\\User','[]','2021-09-17 22:34:58','2021-09-17 22:34:58'),(1644,'default','added',474,'App\\Contact',1,20,'App\\User','[]','2021-09-17 22:53:23','2021-09-17 22:53:23'),(1645,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-18 13:14:43','2021-09-18 13:14:43'),(1646,'default','added',475,'App\\Contact',1,11,'App\\User','[]','2021-09-18 13:36:41','2021-09-18 13:36:41'),(1647,'default','added',476,'App\\Contact',1,11,'App\\User','[]','2021-09-18 14:15:04','2021-09-18 14:15:04'),(1648,'default','added',477,'App\\Contact',1,11,'App\\User','[]','2021-09-18 14:17:18','2021-09-18 14:17:18'),(1649,'default','added',478,'App\\Contact',1,11,'App\\User','[]','2021-09-18 14:19:16','2021-09-18 14:19:16'),(1650,'default','added',479,'App\\Contact',1,11,'App\\User','[]','2021-09-18 14:22:28','2021-09-18 14:22:28'),(1651,'default','added',480,'App\\Contact',1,11,'App\\User','[]','2021-09-18 14:24:57','2021-09-18 14:24:57'),(1652,'default','added',481,'App\\Contact',1,11,'App\\User','[]','2021-09-18 14:27:59','2021-09-18 14:27:59'),(1653,'default','added',482,'App\\Contact',1,11,'App\\User','[]','2021-09-18 16:04:29','2021-09-18 16:04:29'),(1654,'default','added',354,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-09-18 16:09:17','2021-09-18 16:09:17'),(1655,'default','status_changed',427,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-18 16:10:11','2021-09-18 16:10:11'),(1656,'default','added',483,'App\\Contact',1,11,'App\\User','[]','2021-09-18 16:12:59','2021-09-18 16:12:59'),(1657,'default','added',484,'App\\Contact',1,11,'App\\User','[]','2021-09-18 16:15:38','2021-09-18 16:15:38'),(1658,'default','added',355,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20}}','2021-09-18 16:24:08','2021-09-18 16:24:08'),(1659,'default','added',485,'App\\Contact',1,11,'App\\User','[]','2021-09-18 16:30:32','2021-09-18 16:30:32'),(1660,'default','added',356,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-18 16:32:12','2021-09-18 16:32:12'),(1661,'default','added',486,'App\\Contact',1,11,'App\\User','[]','2021-09-18 16:49:58','2021-09-18 16:49:58'),(1662,'default','added',357,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-18 18:30:37','2021-09-18 18:30:37'),(1663,'default','added',487,'App\\Contact',1,11,'App\\User','[]','2021-09-18 19:03:24','2021-09-18 19:03:24'),(1664,'default','added',488,'App\\Contact',1,11,'App\\User','[]','2021-09-18 19:55:38','2021-09-18 19:55:38'),(1665,'default','added',489,'App\\Contact',1,11,'App\\User','[]','2021-09-18 20:00:32','2021-09-18 20:00:32'),(1666,'default','added',490,'App\\Contact',1,11,'App\\User','[]','2021-09-18 20:33:09','2021-09-18 20:33:09'),(1667,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-18 20:55:37','2021-09-18 20:55:37'),(1668,'default','added',491,'App\\Contact',1,11,'App\\User','[]','2021-09-18 21:07:44','2021-09-18 21:07:44'),(1669,'default','added',358,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}','2021-09-18 21:25:50','2021-09-18 21:25:50'),(1670,'default','added',492,'App\\Contact',1,11,'App\\User','[]','2021-09-18 21:36:04','2021-09-18 21:36:04'),(1671,'default','added',493,'App\\Contact',1,11,'App\\User','[]','2021-09-18 21:37:00','2021-09-18 21:37:00'),(1672,'default','added',359,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-09-18 21:41:44','2021-09-18 21:41:44'),(1673,'default','added',494,'App\\Contact',1,11,'App\\User','[]','2021-09-18 21:51:06','2021-09-18 21:51:06'),(1674,'default','added',495,'App\\Contact',1,11,'App\\User','[]','2021-09-18 21:55:25','2021-09-18 21:55:25'),(1675,'default','added',496,'App\\Contact',1,11,'App\\User','[]','2021-09-18 22:38:08','2021-09-18 22:38:08'),(1676,'default','added',497,'App\\Contact',1,11,'App\\User','[]','2021-09-18 22:42:36','2021-09-18 22:42:36'),(1677,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-19 14:04:18','2021-09-19 14:04:18'),(1678,'default','added',498,'App\\Contact',1,11,'App\\User','[]','2021-09-19 14:05:01','2021-09-19 14:05:01'),(1679,'default','added',499,'App\\Contact',1,11,'App\\User','[]','2021-09-19 14:11:43','2021-09-19 14:11:43'),(1680,'default','added',500,'App\\Contact',1,11,'App\\User','[]','2021-09-19 14:13:38','2021-09-19 14:13:38'),(1681,'default','added',501,'App\\Contact',1,11,'App\\User','[]','2021-09-19 16:10:29','2021-09-19 16:10:29'),(1682,'default','added',360,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-09-19 16:39:10','2021-09-19 16:39:10'),(1683,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-19 16:40:27','2021-09-19 16:40:27'),(1684,'default','status_changed',486,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-19 16:43:49','2021-09-19 16:43:49'),(1685,'default','status_changed',472,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-19 16:44:01','2021-09-19 16:44:01'),(1686,'default','added',502,'App\\Contact',1,11,'App\\User','[]','2021-09-19 17:17:43','2021-09-19 17:17:43'),(1687,'default','added',503,'App\\Contact',1,11,'App\\User','[]','2021-09-19 17:46:32','2021-09-19 17:46:32'),(1688,'default','added',504,'App\\Contact',1,11,'App\\User','[]','2021-09-19 17:55:12','2021-09-19 17:55:12'),(1689,'default','added',505,'App\\Contact',1,11,'App\\User','[]','2021-09-19 18:26:03','2021-09-19 18:26:03'),(1690,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-09-19 18:32:05','2021-09-19 18:32:05'),(1691,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-19 18:32:16','2021-09-19 18:32:16'),(1692,'default','status_changed',490,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-19 18:33:33','2021-09-19 18:33:33'),(1693,'default','added',506,'App\\Contact',1,4,'App\\User','[]','2021-09-19 18:49:18','2021-09-19 18:49:18'),(1694,'default','added',361,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-19 19:14:51','2021-09-19 19:14:51'),(1695,'default','status_changed',477,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-19 19:16:00','2021-09-19 19:16:00'),(1696,'default','added',507,'App\\Contact',1,4,'App\\User','[]','2021-09-19 19:40:43','2021-09-19 19:40:43'),(1697,'default','added',508,'App\\Contact',1,4,'App\\User','[]','2021-09-19 19:52:02','2021-09-19 19:52:02'),(1698,'default','added',509,'App\\Contact',1,4,'App\\User','[]','2021-09-19 19:59:01','2021-09-19 19:59:01'),(1699,'default','added',510,'App\\Contact',1,4,'App\\User','[]','2021-09-19 20:02:18','2021-09-19 20:02:18'),(1700,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-19 20:08:01','2021-09-19 20:08:01'),(1701,'default','added',511,'App\\Contact',1,4,'App\\User','[]','2021-09-19 20:10:00','2021-09-19 20:10:00'),(1702,'default','added',512,'App\\Contact',1,4,'App\\User','[]','2021-09-19 20:43:17','2021-09-19 20:43:17'),(1703,'default','added',362,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-19 21:21:40','2021-09-19 21:21:40'),(1704,'default','status_changed',473,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-19 21:22:45','2021-09-19 21:22:45'),(1705,'default','added',513,'App\\Contact',1,4,'App\\User','[]','2021-09-19 21:42:09','2021-09-19 21:42:09'),(1706,'default','added',514,'App\\Contact',1,4,'App\\User','[]','2021-09-19 21:44:08','2021-09-19 21:44:08'),(1707,'default','added',515,'App\\Contact',1,4,'App\\User','[]','2021-09-19 21:45:37','2021-09-19 21:45:37'),(1708,'default','added',516,'App\\Contact',1,4,'App\\User','[]','2021-09-19 21:46:41','2021-09-19 21:46:41'),(1709,'default','status_changed',35,'App\\Transaction',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-19 22:01:38','2021-09-19 22:01:38'),(1710,'default','added',517,'App\\Contact',1,4,'App\\User','[]','2021-09-19 22:02:30','2021-09-19 22:02:30'),(1711,'default','added',363,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-19 22:21:38','2021-09-19 22:21:38'),(1712,'default','status_changed',489,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-19 22:21:52','2021-09-19 22:21:52'),(1713,'default','status_changed',56,'App\\Transaction',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-19 22:22:56','2021-09-19 22:22:56'),(1714,'default','added',364,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-09-19 22:33:36','2021-09-19 22:33:36'),(1715,'default','status_changed',497,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-19 22:33:56','2021-09-19 22:33:56'),(1716,'default','added',365,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-09-19 22:51:15','2021-09-19 22:51:15'),(1717,'default','status_changed',501,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-19 22:52:21','2021-09-19 22:52:21'),(1718,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-20 12:37:06','2021-09-20 12:37:06'),(1719,'default','added',518,'App\\Contact',1,11,'App\\User','[]','2021-09-20 12:39:26','2021-09-20 12:39:26'),(1720,'default','added',519,'App\\Contact',1,11,'App\\User','[]','2021-09-20 12:40:54','2021-09-20 12:40:54'),(1721,'default','added',520,'App\\Contact',1,11,'App\\User','[]','2021-09-20 12:48:12','2021-09-20 12:48:12'),(1722,'default','added',521,'App\\Contact',1,11,'App\\User','[]','2021-09-20 12:57:15','2021-09-20 12:57:15'),(1723,'default','added',522,'App\\Contact',1,11,'App\\User','[]','2021-09-20 12:58:27','2021-09-20 12:58:27'),(1724,'default','added',523,'App\\Contact',1,11,'App\\User','[]','2021-09-20 13:00:25','2021-09-20 13:00:25'),(1725,'default','added',524,'App\\Contact',1,11,'App\\User','[]','2021-09-20 13:45:51','2021-09-20 13:45:51'),(1726,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-20 13:50:29','2021-09-20 13:50:29'),(1727,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-09-20 13:51:33','2021-09-20 13:51:33'),(1728,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-09-20 13:53:42','2021-09-20 13:53:42'),(1729,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-20 14:04:18','2021-09-20 14:04:18'),(1730,'default','added',525,'App\\Contact',1,4,'App\\User','[]','2021-09-20 14:15:01','2021-09-20 14:15:01'),(1731,'default','added',366,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":325}}','2021-09-20 14:18:16','2021-09-20 14:18:16'),(1732,'default','status_changed',474,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-20 14:18:40','2021-09-20 14:18:40'),(1733,'default','added',526,'App\\Contact',1,4,'App\\User','[]','2021-09-20 15:24:13','2021-09-20 15:24:13'),(1734,'default','added',527,'App\\Contact',1,4,'App\\User','[]','2021-09-20 15:50:21','2021-09-20 15:50:21'),(1735,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-09-20 16:11:34','2021-09-20 16:11:34'),(1736,'default','status_changed',515,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-20 16:39:35','2021-09-20 16:39:35'),(1737,'default','status_changed',484,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-20 16:39:49','2021-09-20 16:39:49'),(1738,'default','added',367,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-20 17:43:27','2021-09-20 17:43:27'),(1739,'default','added',528,'App\\Contact',1,4,'App\\User','[]','2021-09-20 17:47:52','2021-09-20 17:47:52'),(1740,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-09-20 18:27:36','2021-09-20 18:27:36'),(1741,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-09-20 18:27:46','2021-09-20 18:27:46'),(1742,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-09-20 18:27:54','2021-09-20 18:27:54'),(1743,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-09-20 18:28:03','2021-09-20 18:28:03'),(1744,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-09-20 18:38:53','2021-09-20 18:38:53'),(1745,'default','added',21,'App\\User',1,1,'App\\User','[]','2021-09-20 19:12:12','2021-09-20 19:12:12'),(1746,'default','status_changed',488,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-20 19:20:08','2021-09-20 19:20:08'),(1747,'default','status_changed',486,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-20 19:26:27','2021-09-20 19:26:27'),(1748,'default','status_changed',516,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-20 19:27:18','2021-09-20 19:27:18'),(1749,'default','status_changed',506,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-20 19:36:24','2021-09-20 19:36:24'),(1750,'default','added',368,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-20 19:37:17','2021-09-20 19:37:17'),(1751,'default','added',529,'App\\Contact',1,4,'App\\User','[]','2021-09-20 19:37:44','2021-09-20 19:37:44'),(1752,'default','added',530,'App\\Contact',1,4,'App\\User','[]','2021-09-20 19:41:56','2021-09-20 19:41:56'),(1753,'default','status_changed',488,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-20 19:42:17','2021-09-20 19:42:17'),(1754,'default','added',531,'App\\Contact',1,4,'App\\User','[]','2021-09-20 19:49:26','2021-09-20 19:49:26'),(1755,'default','status_changed',480,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":\"\\u0631\\u0641\\u0636 \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644 \\u0627\\u0644\\u0627\\u0635\\u0644\\u0627\\u062d \\u0645\\u062d\\u0627\\u0648\\u0644\\u0629 300\",\"updated_status\":\"reject by customer\"}','2021-09-20 20:04:10','2021-09-20 20:04:10'),(1756,'default','added',532,'App\\Contact',1,4,'App\\User','[]','2021-09-20 20:12:08','2021-09-20 20:12:08'),(1757,'default','added',533,'App\\Contact',1,4,'App\\User','[]','2021-09-20 20:14:40','2021-09-20 20:14:40'),(1758,'default','added',534,'App\\Contact',1,4,'App\\User','[]','2021-09-20 20:15:01','2021-09-20 20:15:01'),(1759,'default','added',535,'App\\Contact',1,4,'App\\User','[]','2021-09-20 20:35:12','2021-09-20 20:35:12'),(1760,'default','status_changed',504,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-20 20:40:33','2021-09-20 20:40:33'),(1761,'default','added',369,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-20 20:56:22','2021-09-20 20:56:22'),(1762,'default','added',370,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-20 20:57:33','2021-09-20 20:57:33'),(1763,'default','status_changed',515,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-20 21:01:35','2021-09-20 21:01:35'),(1764,'default','added',371,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":175}}','2021-09-20 21:16:18','2021-09-20 21:16:18'),(1765,'default','status_changed',475,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-20 21:16:37','2021-09-20 21:16:37'),(1766,'default','added',372,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-20 21:21:40','2021-09-20 21:21:40'),(1767,'default','status_changed',486,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-20 21:22:19','2021-09-20 21:22:19'),(1768,'default','added',373,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-20 21:24:57','2021-09-20 21:24:57'),(1769,'default','added',374,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-09-20 21:26:11','2021-09-20 21:26:11'),(1770,'default','status_changed',499,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-20 21:27:41','2021-09-20 21:27:41'),(1771,'default','added',375,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-20 21:32:14','2021-09-20 21:32:14'),(1772,'default','added',536,'App\\Contact',1,11,'App\\User','[]','2021-09-20 21:38:06','2021-09-20 21:38:06'),(1773,'default','status_changed',488,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-20 21:39:04','2021-09-20 21:39:04'),(1774,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-09-20 21:45:14','2021-09-20 21:45:14'),(1775,'default','added',376,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}','2021-09-20 22:11:19','2021-09-20 22:11:19'),(1776,'default','status_changed',466,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"reject by customer\"}','2021-09-20 22:28:24','2021-09-20 22:28:24'),(1777,'default','added',377,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2800}}','2021-09-20 22:28:51','2021-09-20 22:28:51'),(1778,'default','status_changed',465,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-20 22:31:13','2021-09-20 22:31:13'),(1779,'default','added',537,'App\\Contact',1,4,'App\\User','[]','2021-09-20 23:01:32','2021-09-20 23:01:32'),(1780,'default','added',378,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-09-20 23:09:13','2021-09-20 23:09:13'),(1781,'default','added',379,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-20 23:09:51','2021-09-20 23:09:51'),(1782,'default','status_changed',519,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-20 23:10:08','2021-09-20 23:10:08'),(1783,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-21 12:31:31','2021-09-21 12:31:31'),(1784,'default','added',538,'App\\Contact',1,11,'App\\User','[]','2021-09-21 12:33:23','2021-09-21 12:33:23'),(1785,'default','added',380,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-21 13:03:19','2021-09-21 13:03:19'),(1786,'default','status_changed',516,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-21 13:03:49','2021-09-21 13:03:49'),(1787,'default','added',539,'App\\Contact',1,11,'App\\User','[]','2021-09-21 13:22:30','2021-09-21 13:22:30'),(1788,'default','added',540,'App\\Contact',1,11,'App\\User','[]','2021-09-21 13:24:24','2021-09-21 13:24:24'),(1789,'default','status_changed',481,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-21 14:47:51','2021-09-21 14:47:51'),(1790,'default','status_changed',509,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-21 14:48:11','2021-09-21 14:48:11'),(1791,'default','status_changed',514,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-21 14:48:21','2021-09-21 14:48:21'),(1792,'default','status_changed',508,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"reject by customer\"}','2021-09-21 14:49:49','2021-09-21 14:49:49'),(1793,'default','status_changed',513,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-21 14:50:16','2021-09-21 14:50:16'),(1794,'default','status_changed',517,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-21 14:53:01','2021-09-21 14:53:01'),(1795,'default','status_changed',521,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-21 14:54:11','2021-09-21 14:54:11'),(1796,'default','status_changed',522,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-21 14:54:29','2021-09-21 14:54:29'),(1797,'default','status_changed',523,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-21 14:54:56','2021-09-21 14:54:56'),(1798,'default','status_changed',524,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-21 14:55:07','2021-09-21 14:55:07'),(1799,'default','status_changed',530,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-21 14:55:20','2021-09-21 14:55:20'),(1800,'default','status_changed',527,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-21 14:55:32','2021-09-21 14:55:32'),(1801,'default','status_changed',520,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-21 14:56:26','2021-09-21 14:56:26'),(1802,'default','status_changed',458,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-21 14:56:40','2021-09-21 14:56:40'),(1803,'default','status_changed',478,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-21 15:07:57','2021-09-21 15:07:57'),(1804,'default','status_changed',269,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-21 15:32:03','2021-09-21 15:32:03'),(1805,'default','status_changed',217,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-21 15:32:14','2021-09-21 15:32:14'),(1806,'default','status_changed',205,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-21 15:32:52','2021-09-21 15:32:52'),(1807,'default','added',381,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-21 15:36:10','2021-09-21 15:36:10'),(1808,'default','status_changed',373,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-21 15:49:02','2021-09-21 15:49:02'),(1809,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-09-21 16:25:20','2021-09-21 16:25:20'),(1810,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-09-21 16:25:35','2021-09-21 16:25:35'),(1811,'default','payment_edited',167,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"800.0000\"}}','2021-09-21 16:30:41','2021-09-21 16:30:41'),(1812,'default','added',382,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-21 16:37:59','2021-09-21 16:37:59'),(1813,'default','status_changed',440,'Modules\\Repair\\Entities\\JobSheet',1,1,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-21 16:38:26','2021-09-21 16:38:26'),(1814,'default','added',541,'App\\Contact',1,1,'App\\User','[]','2021-09-21 16:40:34','2021-09-21 16:40:34'),(1815,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-09-21 16:47:11','2021-09-21 16:47:11'),(1816,'default','edited',175,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"400.0000\"}}','2021-09-21 17:09:26','2021-09-21 17:09:26'),(1817,'default','status_changed',167,'App\\Transaction',1,1,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-21 17:10:26','2021-09-21 17:10:26'),(1818,'default','edited',115,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"payment_status\":\"partial\",\"final_total\":800},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"700.0000\"}}','2021-09-21 17:14:03','2021-09-21 17:14:03'),(1819,'default','status_changed',525,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-21 17:18:07','2021-09-21 17:18:07'),(1820,'default','status_changed',500,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-21 17:18:24','2021-09-21 17:18:24'),(1821,'default','added',383,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-21 17:20:26','2021-09-21 17:20:26'),(1822,'default','added',384,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}','2021-09-21 17:22:03','2021-09-21 17:22:03'),(1823,'default','added',385,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-21 17:31:52','2021-09-21 17:31:52'),(1824,'default','status_changed',528,'Modules\\Repair\\Entities\\JobSheet',1,1,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-21 17:43:27','2021-09-21 17:43:27'),(1825,'default','added',542,'App\\Contact',1,1,'App\\User','[]','2021-09-21 17:56:17','2021-09-21 17:56:17'),(1826,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-09-21 18:06:04','2021-09-21 18:06:04'),(1827,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-09-21 18:32:52','2021-09-21 18:32:52'),(1828,'default','added',543,'App\\Contact',1,1,'App\\User','[]','2021-09-21 18:46:02','2021-09-21 18:46:02'),(1829,'default','added',386,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-21 18:53:15','2021-09-21 18:53:15'),(1830,'default','status_changed',529,'Modules\\Repair\\Entities\\JobSheet',1,1,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-21 18:53:53','2021-09-21 18:53:53'),(1831,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-09-21 19:03:09','2021-09-21 19:03:09'),(1832,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-21 19:03:23','2021-09-21 19:03:23'),(1833,'default','added',544,'App\\Contact',1,11,'App\\User','[]','2021-09-21 19:08:46','2021-09-21 19:08:46'),(1834,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-09-21 19:11:27','2021-09-21 19:11:27'),(1835,'default','added',22,'App\\User',1,1,'App\\User','[]','2021-09-21 19:12:42','2021-09-21 19:12:42'),(1836,'default','added',545,'App\\Contact',1,11,'App\\User','[]','2021-09-21 19:18:14','2021-09-21 19:18:14'),(1837,'default','added',387,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-21 19:28:20','2021-09-21 19:28:20'),(1838,'default','status_changed',506,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-21 19:28:44','2021-09-21 19:28:44'),(1839,'default','status_changed',525,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-09-21 19:34:03','2021-09-21 19:34:03'),(1840,'default','added',546,'App\\Contact',1,4,'App\\User','[]','2021-09-21 19:36:34','2021-09-21 19:36:34'),(1841,'default','status_changed',525,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-21 19:44:16','2021-09-21 19:44:16'),(1842,'default','status_changed',533,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-21 19:44:25','2021-09-21 19:44:25'),(1843,'default','status_changed',531,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-21 19:44:35','2021-09-21 19:44:35'),(1844,'default','status_changed',524,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-21 19:55:37','2021-09-21 19:55:37'),(1845,'default','added',547,'App\\Contact',1,4,'App\\User','[]','2021-09-21 19:59:17','2021-09-21 19:59:17'),(1846,'default','added',548,'App\\Contact',1,4,'App\\User','[]','2021-09-21 20:07:20','2021-09-21 20:07:20'),(1847,'default','added',549,'App\\Contact',1,4,'App\\User','[]','2021-09-21 20:18:47','2021-09-21 20:18:47'),(1848,'default','status_changed',537,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-21 20:39:08','2021-09-21 20:39:08'),(1849,'default','status_changed',539,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-21 20:40:34','2021-09-21 20:40:34'),(1850,'default','status_changed',536,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-21 20:40:50','2021-09-21 20:40:50'),(1851,'default','status_changed',468,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-21 20:41:20','2021-09-21 20:41:20'),(1852,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-09-21 20:45:42','2021-09-21 20:45:42'),(1853,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-21 20:46:03','2021-09-21 20:46:03'),(1854,'default','payment_edited',167,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"800.0000\"}}','2021-09-21 20:46:45','2021-09-21 20:46:45'),(1855,'default','added',550,'App\\Contact',1,4,'App\\User','[]','2021-09-21 20:46:54','2021-09-21 20:46:54'),(1856,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-09-21 20:53:47','2021-09-21 20:53:47'),(1857,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-09-21 20:53:56','2021-09-21 20:53:56'),(1858,'default','added',551,'App\\Contact',1,4,'App\\User','[]','2021-09-21 20:54:15','2021-09-21 20:54:15'),(1859,'default','added',388,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-09-21 21:01:25','2021-09-21 21:01:25'),(1860,'default','status_changed',496,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-21 21:02:21','2021-09-21 21:02:21'),(1861,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-09-21 21:05:20','2021-09-21 21:05:20'),(1862,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-21 21:05:29','2021-09-21 21:05:29'),(1863,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-09-21 21:11:18','2021-09-21 21:11:18'),(1864,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-09-21 21:11:27','2021-09-21 21:11:27'),(1865,'default','payment_edited',35,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1850.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1850.0000\"}}','2021-09-21 21:11:56','2021-09-21 21:11:56'),(1866,'default','payment_edited',56,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1000.0000\"}}','2021-09-21 21:12:36','2021-09-21 21:12:36'),(1867,'default','added',552,'App\\Contact',1,4,'App\\User','[]','2021-09-21 21:12:43','2021-09-21 21:12:43'),(1868,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-09-21 21:13:47','2021-09-21 21:13:47'),(1869,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-09-21 21:13:52','2021-09-21 21:13:52'),(1870,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-09-21 21:13:57','2021-09-21 21:13:57'),(1871,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-21 21:14:03','2021-09-21 21:14:03'),(1872,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-09-21 21:16:56','2021-09-21 21:16:56'),(1873,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-09-21 21:17:05','2021-09-21 21:17:05'),(1874,'default','payment_edited',114,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"800.0000\"}}','2021-09-21 21:19:32','2021-09-21 21:19:32'),(1875,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-09-21 21:19:45','2021-09-21 21:19:45'),(1876,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-21 21:19:55','2021-09-21 21:19:55'),(1877,'default','payment_edited',114,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"800.0000\"}}','2021-09-21 21:20:49','2021-09-21 21:20:49'),(1878,'default','payment_edited',114,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"800.0000\"}}','2021-09-21 21:23:11','2021-09-21 21:23:11'),(1879,'default','payment_edited',114,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"800.0000\"}}','2021-09-21 21:23:49','2021-09-21 21:23:49'),(1880,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-09-21 21:24:26','2021-09-21 21:24:26'),(1881,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-09-21 21:24:33','2021-09-21 21:24:33'),(1882,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-09-21 21:27:27','2021-09-21 21:27:27'),(1883,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-09-21 21:27:31','2021-09-21 21:27:31'),(1884,'default','status_changed',481,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-21 21:43:45','2021-09-21 21:43:45'),(1885,'default','added',389,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-21 21:48:23','2021-09-21 21:48:23'),(1886,'default','status_changed',522,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-21 21:49:47','2021-09-21 21:49:47'),(1887,'default','status_changed',505,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-21 21:49:58','2021-09-21 21:49:58'),(1888,'default','status_changed',472,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-21 21:50:09','2021-09-21 21:50:09'),(1889,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-09-21 21:56:04','2021-09-21 21:56:04'),(1890,'default','login',19,'App\\User',1,19,'App\\User','[]','2021-09-21 21:56:18','2021-09-21 21:56:18'),(1891,'default','status_changed',500,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-09-21 21:56:51','2021-09-21 21:56:51'),(1892,'default','status_changed',539,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-09-21 21:57:28','2021-09-21 21:57:28'),(1893,'default','status_changed',525,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-09-21 21:57:45','2021-09-21 21:57:45'),(1894,'default','status_changed',533,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-09-21 22:00:03','2021-09-21 22:00:03'),(1895,'default','status_changed',538,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-09-21 22:02:43','2021-09-21 22:02:43'),(1896,'default','status_changed',537,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-09-21 22:03:04','2021-09-21 22:03:04'),(1897,'default','status_changed',536,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-21 22:10:33','2021-09-21 22:10:33'),(1898,'default','added',553,'App\\Contact',1,4,'App\\User','[]','2021-09-21 22:14:52','2021-09-21 22:14:52'),(1899,'default','logout',19,'App\\User',1,19,'App\\User','[]','2021-09-21 22:20:22','2021-09-21 22:20:22'),(1900,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-09-21 22:20:34','2021-09-21 22:20:34'),(1901,'default','added',390,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-09-21 22:37:22','2021-09-21 22:37:22'),(1902,'default','status_changed',510,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-21 22:39:20','2021-09-21 22:39:20'),(1903,'default','status_changed',449,'Modules\\Repair\\Entities\\JobSheet',1,1,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-21 22:56:01','2021-09-21 22:56:01'),(1904,'default','added',391,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":250}}','2021-09-21 22:58:42','2021-09-21 22:58:42'),(1905,'default','added',554,'App\\Contact',1,4,'App\\User','[]','2021-09-21 23:33:31','2021-09-21 23:33:31'),(1906,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-22 12:32:32','2021-09-22 12:32:32'),(1907,'default','added',392,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-09-22 12:33:14','2021-09-22 12:33:14'),(1908,'default','status_changed',517,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-22 12:33:33','2021-09-22 12:33:33'),(1909,'default','added',555,'App\\Contact',1,11,'App\\User','[]','2021-09-22 13:57:15','2021-09-22 13:57:15'),(1910,'default','added',556,'App\\Contact',1,11,'App\\User','[]','2021-09-22 13:58:01','2021-09-22 13:58:01'),(1911,'default','added',557,'App\\Contact',1,11,'App\\User','[]','2021-09-22 14:11:42','2021-09-22 14:11:42'),(1912,'default','added',558,'App\\Contact',1,11,'App\\User','[]','2021-09-22 14:26:07','2021-09-22 14:26:07'),(1913,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-22 14:59:03','2021-09-22 14:59:03'),(1914,'default','status_changed',525,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-22 15:01:15','2021-09-22 15:01:15'),(1915,'default','added',559,'App\\Contact',1,11,'App\\User','[]','2021-09-22 15:31:31','2021-09-22 15:31:31'),(1916,'default','added',560,'App\\Contact',1,11,'App\\User','[]','2021-09-22 15:58:45','2021-09-22 15:58:45'),(1917,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-09-22 16:55:15','2021-09-22 16:55:15'),(1918,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-22 16:55:23','2021-09-22 16:55:23'),(1919,'default','added',393,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":300}}','2021-09-22 17:18:56','2021-09-22 17:18:56'),(1920,'default','added',561,'App\\Contact',1,4,'App\\User','[]','2021-09-22 17:22:30','2021-09-22 17:22:30'),(1921,'default','added',562,'App\\Contact',1,4,'App\\User','[]','2021-09-22 18:21:31','2021-09-22 18:21:31'),(1922,'default','added',394,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1100}}','2021-09-22 18:33:45','2021-09-22 18:33:45'),(1923,'default','status_changed',533,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-22 18:34:12','2021-09-22 18:34:12'),(1924,'default','added',395,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}','2021-09-22 18:34:36','2021-09-22 18:34:36'),(1925,'default','status_changed',530,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-22 18:34:54','2021-09-22 18:34:54'),(1926,'default','added',396,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-09-22 19:12:36','2021-09-22 19:12:36'),(1927,'default','status_changed',532,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-22 19:13:12','2021-09-22 19:13:12'),(1928,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-09-22 19:23:12','2021-09-22 19:23:12'),(1929,'default','login',19,'App\\User',1,19,'App\\User','[]','2021-09-22 19:23:41','2021-09-22 19:23:41'),(1930,'default','logout',19,'App\\User',1,19,'App\\User','[]','2021-09-22 19:44:18','2021-09-22 19:44:18'),(1931,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-09-22 19:44:23','2021-09-22 19:44:23'),(1932,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-22 20:08:45','2021-09-22 20:08:45'),(1933,'default','added',563,'App\\Contact',1,4,'App\\User','[]','2021-09-22 20:08:53','2021-09-22 20:08:53'),(1934,'default','added',397,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-09-22 20:09:29','2021-09-22 20:09:29'),(1935,'default','status_changed',538,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-22 20:11:08','2021-09-22 20:11:08'),(1936,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-09-22 20:11:18','2021-09-22 20:11:18'),(1937,'default','status_changed',545,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-22 20:18:00','2021-09-22 20:18:00'),(1938,'default','added',398,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-09-22 20:19:13','2021-09-22 20:19:13'),(1939,'default','added',399,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-22 20:21:21','2021-09-22 20:21:21'),(1940,'default','status_changed',542,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-22 20:22:09','2021-09-22 20:22:09'),(1941,'default','added',400,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":850}}','2021-09-22 20:25:01','2021-09-22 20:25:01'),(1942,'default','added',401,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":850}}','2021-09-22 20:27:57','2021-09-22 20:27:57'),(1943,'default','status_changed',521,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-22 20:28:21','2021-09-22 20:28:21'),(1944,'default','added',402,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-22 20:29:00','2021-09-22 20:29:00'),(1945,'default','status_changed',544,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-22 20:29:25','2021-09-22 20:29:25'),(1946,'default','login',19,'App\\User',1,19,'App\\User','[]','2021-09-22 20:38:48','2021-09-22 20:38:48'),(1947,'default','added',564,'App\\Contact',1,4,'App\\User','[]','2021-09-22 21:13:08','2021-09-22 21:13:08'),(1948,'default','added',403,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-22 21:25:28','2021-09-22 21:25:28'),(1949,'default','status_changed',536,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-22 21:25:43','2021-09-22 21:25:43'),(1950,'default','added',404,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}','2021-09-22 21:37:50','2021-09-22 21:37:50'),(1951,'default','status_changed',512,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-22 21:38:04','2021-09-22 21:38:04'),(1952,'default','added',405,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-09-22 21:38:48','2021-09-22 21:38:48'),(1953,'default','status_changed',513,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-22 21:39:08','2021-09-22 21:39:08'),(1954,'default','added',406,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}','2021-09-22 21:52:28','2021-09-22 21:52:28'),(1955,'default','added',565,'App\\Contact',1,4,'App\\User','[]','2021-09-22 21:53:42','2021-09-22 21:53:42'),(1956,'default','status_changed',527,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-22 22:01:46','2021-09-22 22:01:46'),(1957,'default','added',566,'App\\Contact',1,4,'App\\User','[]','2021-09-22 22:03:17','2021-09-22 22:03:17'),(1958,'default','added',407,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-09-22 22:11:01','2021-09-22 22:11:01'),(1959,'default','added',408,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-09-22 22:24:13','2021-09-22 22:24:13'),(1960,'default','status_changed',547,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-22 22:28:14','2021-09-22 22:28:14'),(1961,'default','added',409,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-22 22:28:47','2021-09-22 22:28:47'),(1962,'default','status_changed',543,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-22 22:29:04','2021-09-22 22:29:04'),(1963,'default','payment_edited',368,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"150.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"150.0000\"}}','2021-09-22 22:53:11','2021-09-22 22:53:11'),(1964,'default','payment_edited',368,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"150.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"150.0000\"}}','2021-09-22 22:54:10','2021-09-22 22:54:10'),(1965,'default','added',410,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-09-22 22:57:13','2021-09-22 22:57:13'),(1966,'default','status_changed',509,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-22 22:57:32','2021-09-22 22:57:32'),(1967,'default','status_changed',511,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-22 22:57:51','2021-09-22 22:57:51'),(1968,'default','added',411,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-22 22:58:52','2021-09-22 22:58:52'),(1969,'default','status_changed',550,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-22 23:00:17','2021-09-22 23:00:17'),(1970,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-09-22 23:04:55','2021-09-22 23:04:55'),(1971,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-09-23 02:08:45','2021-09-23 02:08:45'),(1972,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-23 12:31:17','2021-09-23 12:31:17'),(1973,'default','added',412,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-09-23 12:32:21','2021-09-23 12:32:21'),(1974,'default','status_changed',548,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-23 12:33:20','2021-09-23 12:33:20'),(1975,'default','added',567,'App\\Contact',1,11,'App\\User','[]','2021-09-23 12:48:25','2021-09-23 12:48:25'),(1976,'default','added',568,'App\\Contact',1,11,'App\\User','[]','2021-09-23 12:49:51','2021-09-23 12:49:51'),(1977,'default','added',569,'App\\Contact',1,11,'App\\User','[]','2021-09-23 13:05:23','2021-09-23 13:05:23'),(1978,'default','added',570,'App\\Contact',1,11,'App\\User','[]','2021-09-23 13:08:13','2021-09-23 13:08:13'),(1979,'default','added',571,'App\\Contact',1,11,'App\\User','[]','2021-09-23 13:19:00','2021-09-23 13:19:00'),(1980,'default','added',572,'App\\Contact',1,11,'App\\User','[]','2021-09-23 14:19:44','2021-09-23 14:19:44'),(1981,'default','added',573,'App\\Contact',1,11,'App\\User','[]','2021-09-23 14:21:53','2021-09-23 14:21:53'),(1982,'default','added',574,'App\\Contact',1,11,'App\\User','[]','2021-09-23 14:38:35','2021-09-23 14:38:35'),(1983,'default','added',575,'App\\Contact',1,11,'App\\User','[]','2021-09-23 14:51:52','2021-09-23 14:51:52'),(1984,'default','added',576,'App\\Contact',1,11,'App\\User','[]','2021-09-23 14:53:55','2021-09-23 14:53:55'),(1985,'default','added',577,'App\\Contact',1,11,'App\\User','[]','2021-09-23 14:55:03','2021-09-23 14:55:03'),(1986,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-23 15:18:23','2021-09-23 15:18:23'),(1987,'default','added',578,'App\\Contact',1,11,'App\\User','[]','2021-09-23 16:35:00','2021-09-23 16:35:00'),(1988,'default','status_changed',563,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-23 16:55:49','2021-09-23 16:55:49'),(1989,'default','status_changed',564,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-23 16:56:00','2021-09-23 16:56:00'),(1990,'default','added',23,'App\\User',1,1,'App\\User','[]','2021-09-23 17:04:51','2021-09-23 17:04:51'),(1991,'default','added',579,'App\\Contact',1,11,'App\\User','[]','2021-09-23 17:12:29','2021-09-23 17:12:29'),(1992,'default','added',580,'App\\Contact',1,11,'App\\User','[]','2021-09-23 17:18:33','2021-09-23 17:18:33'),(1993,'default','added',581,'App\\Contact',1,11,'App\\User','[]','2021-09-23 17:24:46','2021-09-23 17:24:46'),(1994,'default','status_changed',503,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-23 17:35:19','2021-09-23 17:35:19'),(1995,'default','added',413,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-23 17:36:25','2021-09-23 17:36:25'),(1996,'default','status_changed',560,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-23 17:36:50','2021-09-23 17:36:50'),(1997,'default','added',414,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-23 17:37:12','2021-09-23 17:37:12'),(1998,'default','status_changed',561,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-23 17:37:35','2021-09-23 17:37:35'),(1999,'default','added',415,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-09-23 17:39:00','2021-09-23 17:39:00'),(2000,'default','status_changed',539,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-23 17:39:17','2021-09-23 17:39:17'),(2001,'default','status_changed',458,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-23 17:47:36','2021-09-23 17:47:36'),(2002,'default','status_changed',570,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-23 17:59:30','2021-09-23 17:59:30'),(2003,'default','added',416,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-23 18:01:34','2021-09-23 18:01:34'),(2004,'default','added',417,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-23 18:20:33','2021-09-23 18:20:33'),(2005,'default','status_changed',571,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-23 18:21:21','2021-09-23 18:21:21'),(2006,'default','added',582,'App\\Contact',1,11,'App\\User','[]','2021-09-23 19:23:49','2021-09-23 19:23:49'),(2007,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-23 19:31:51','2021-09-23 19:31:51'),(2008,'default','added',583,'App\\Contact',1,11,'App\\User','[]','2021-09-23 19:32:51','2021-09-23 19:32:51'),(2009,'default','added',584,'App\\Contact',1,11,'App\\User','[]','2021-09-23 19:33:35','2021-09-23 19:33:35'),(2010,'default','added',585,'App\\Contact',1,11,'App\\User','[]','2021-09-23 19:33:59','2021-09-23 19:33:59'),(2011,'default','added',418,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-09-23 19:40:14','2021-09-23 19:40:14'),(2012,'default','added',586,'App\\Contact',1,11,'App\\User','[]','2021-09-23 19:40:51','2021-09-23 19:40:51'),(2013,'default','status_changed',483,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-23 19:49:21','2021-09-23 19:49:21'),(2014,'default','status_changed',572,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-23 20:08:37','2021-09-23 20:08:37'),(2015,'default','status_changed',556,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-23 20:08:46','2021-09-23 20:08:46'),(2016,'default','status_changed',569,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-23 20:09:08','2021-09-23 20:09:08'),(2017,'default','status_changed',574,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-23 20:09:37','2021-09-23 20:09:37'),(2018,'default','added',419,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-09-23 20:34:14','2021-09-23 20:34:14'),(2019,'default','status_changed',559,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-23 20:34:40','2021-09-23 20:34:40'),(2020,'default','added',420,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-23 21:02:46','2021-09-23 21:02:46'),(2021,'default','status_changed',572,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-23 21:03:12','2021-09-23 21:03:12'),(2022,'default','added',421,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":350}}','2021-09-23 21:12:44','2021-09-23 21:12:44'),(2023,'default','added',422,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":850}}','2021-09-23 21:15:40','2021-09-23 21:15:40'),(2024,'default','status_changed',514,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-23 21:16:09','2021-09-23 21:16:09'),(2025,'default','added',423,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1200}}','2021-09-23 21:16:40','2021-09-23 21:16:40'),(2026,'default','status_changed',261,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-23 21:16:57','2021-09-23 21:16:57'),(2027,'default','added',424,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-23 22:12:30','2021-09-23 22:12:30'),(2028,'default','status_changed',555,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-23 22:14:06','2021-09-23 22:14:06'),(2029,'default','added',425,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4000}}','2021-09-23 22:56:11','2021-09-23 22:56:11'),(2030,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-09-24 14:44:58','2021-09-24 14:44:58'),(2031,'default','added',587,'App\\Contact',1,20,'App\\User','[]','2021-09-24 16:32:58','2021-09-24 16:32:58'),(2032,'default','added',588,'App\\Contact',1,20,'App\\User','[]','2021-09-24 16:42:22','2021-09-24 16:42:22'),(2033,'default','status_changed',534,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-24 17:02:14','2021-09-24 17:02:14'),(2034,'default','added',589,'App\\Contact',1,20,'App\\User','[]','2021-09-24 17:12:02','2021-09-24 17:12:02'),(2035,'default','added',590,'App\\Contact',1,20,'App\\User','[]','2021-09-24 18:02:04','2021-09-24 18:02:04'),(2036,'default','added',591,'App\\Contact',1,20,'App\\User','[]','2021-09-24 18:15:46','2021-09-24 18:15:46'),(2037,'default','added',592,'App\\Contact',1,20,'App\\User','[]','2021-09-24 18:21:15','2021-09-24 18:21:15'),(2038,'default','added',593,'App\\Contact',1,20,'App\\User','[]','2021-09-24 18:27:18','2021-09-24 18:27:18'),(2039,'default','added',426,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-09-24 19:04:44','2021-09-24 19:04:44'),(2040,'default','added',594,'App\\Contact',1,20,'App\\User','[]','2021-09-24 19:25:01','2021-09-24 19:25:01'),(2041,'default','added',595,'App\\Contact',1,20,'App\\User','[]','2021-09-24 19:27:54','2021-09-24 19:27:54'),(2042,'default','status_changed',552,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-24 19:34:15','2021-09-24 19:34:15'),(2043,'default','added',596,'App\\Contact',1,20,'App\\User','[]','2021-09-24 19:37:34','2021-09-24 19:37:34'),(2044,'default','added',597,'App\\Contact',1,20,'App\\User','[]','2021-09-24 19:42:37','2021-09-24 19:42:37'),(2045,'default','added',427,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-09-24 19:49:37','2021-09-24 19:49:37'),(2046,'default','added',598,'App\\Contact',1,20,'App\\User','[]','2021-09-24 19:53:46','2021-09-24 19:53:46'),(2047,'default','added',599,'App\\Contact',1,20,'App\\User','[]','2021-09-24 19:56:54','2021-09-24 19:56:54'),(2048,'default','added',428,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":225}}','2021-09-24 21:21:12','2021-09-24 21:21:12'),(2049,'default','added',429,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-24 21:21:46','2021-09-24 21:21:46'),(2050,'default','status_changed',566,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-24 21:22:14','2021-09-24 21:22:14'),(2051,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-25 14:30:23','2021-09-25 14:30:23'),(2052,'default','added',600,'App\\Contact',1,4,'App\\User','[]','2021-09-25 14:32:02','2021-09-25 14:32:02'),(2053,'default','added',430,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-09-25 14:36:30','2021-09-25 14:36:30'),(2054,'default','status_changed',500,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-25 14:36:57','2021-09-25 14:36:57'),(2055,'default','status_changed',478,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-25 14:37:31','2021-09-25 14:37:31'),(2056,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-25 14:38:58','2021-09-25 14:38:58'),(2057,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-09-25 16:12:49','2021-09-25 16:12:49'),(2058,'default','added',601,'App\\Contact',1,4,'App\\User','[]','2021-09-25 16:43:43','2021-09-25 16:43:43'),(2059,'default','added',602,'App\\Contact',1,4,'App\\User','[]','2021-09-25 17:01:07','2021-09-25 17:01:07'),(2060,'default','added',431,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-25 17:29:05','2021-09-25 17:29:05'),(2061,'default','status_changed',569,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-25 17:29:27','2021-09-25 17:29:27'),(2062,'default','added',603,'App\\Contact',1,4,'App\\User','[]','2021-09-25 17:47:13','2021-09-25 17:47:13'),(2063,'default','added',432,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-25 17:51:24','2021-09-25 17:51:24'),(2064,'default','status_changed',588,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-25 17:52:11','2021-09-25 17:52:11'),(2065,'default','added',604,'App\\Contact',1,4,'App\\User','[]','2021-09-25 17:56:00','2021-09-25 17:56:00'),(2066,'default','added',605,'App\\Contact',1,4,'App\\User','[]','2021-09-25 18:14:37','2021-09-25 18:14:37'),(2067,'default','added',606,'App\\Contact',1,4,'App\\User','[]','2021-09-25 18:33:40','2021-09-25 18:33:40'),(2068,'default','added',607,'App\\Contact',1,4,'App\\User','[]','2021-09-25 19:08:15','2021-09-25 19:08:15'),(2069,'default','added',608,'App\\Contact',1,4,'App\\User','[]','2021-09-25 19:26:52','2021-09-25 19:26:52'),(2070,'default','added',433,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-09-25 19:56:17','2021-09-25 19:56:17'),(2071,'default','added',434,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-25 19:57:13','2021-09-25 19:57:13'),(2072,'default','added',435,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-25 20:00:29','2021-09-25 20:00:29'),(2073,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-09-25 20:02:02','2021-09-25 20:02:02'),(2074,'default','status_changed',494,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-25 20:14:50','2021-09-25 20:14:50'),(2075,'default','status_changed',577,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-25 20:35:20','2021-09-25 20:35:20'),(2076,'default','status_changed',582,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-25 20:35:30','2021-09-25 20:35:30'),(2077,'default','status_changed',584,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-25 20:36:37','2021-09-25 20:36:37'),(2078,'default','status_changed',583,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-25 20:36:47','2021-09-25 20:36:47'),(2079,'default','status_changed',580,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-25 20:36:58','2021-09-25 20:36:58'),(2080,'default','status_changed',593,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-25 20:37:08','2021-09-25 20:37:08'),(2081,'default','status_changed',591,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-25 20:39:38','2021-09-25 20:39:38'),(2082,'default','status_changed',596,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-25 20:39:46','2021-09-25 20:39:46'),(2083,'default','added',609,'App\\Contact',1,4,'App\\User','[]','2021-09-25 20:41:26','2021-09-25 20:41:26'),(2084,'default','added',436,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-25 20:52:17','2021-09-25 20:52:17'),(2085,'default','status_changed',595,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-25 20:52:35','2021-09-25 20:52:35'),(2086,'default','added',610,'App\\Contact',1,4,'App\\User','[]','2021-09-25 20:53:10','2021-09-25 20:53:10'),(2087,'default','status_changed',458,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-25 21:02:58','2021-09-25 21:02:58'),(2088,'default','status_changed',579,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-25 21:12:02','2021-09-25 21:12:02'),(2089,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-25 21:13:22','2021-09-25 21:13:22'),(2090,'default','added',437,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":125}}','2021-09-25 21:14:12','2021-09-25 21:14:12'),(2091,'default','status_changed',581,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-25 21:14:24','2021-09-25 21:14:24'),(2092,'default','status_changed',525,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-25 21:36:05','2021-09-25 21:36:05'),(2093,'default','added',438,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-09-25 21:52:24','2021-09-25 21:52:24'),(2094,'default','status_changed',585,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-25 21:52:54','2021-09-25 21:52:54'),(2095,'default','status_changed',575,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-25 21:55:02','2021-09-25 21:55:02'),(2096,'default','added',439,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-09-25 21:55:44','2021-09-25 21:55:44'),(2097,'default','added',440,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-25 21:56:23','2021-09-25 21:56:23'),(2098,'default','added',441,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":50}}','2021-09-25 22:09:03','2021-09-25 22:09:03'),(2099,'default','added',442,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-25 22:17:50','2021-09-25 22:17:50'),(2100,'default','status_changed',586,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-25 22:18:21','2021-09-25 22:18:21'),(2101,'default','added',443,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}','2021-09-25 22:19:14','2021-09-25 22:19:14'),(2102,'default','status_changed',582,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-25 22:19:33','2021-09-25 22:19:33'),(2103,'default','added',444,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-09-25 22:22:23','2021-09-25 22:22:23'),(2104,'default','status_changed',570,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-25 22:22:47','2021-09-25 22:22:47'),(2105,'default','added',445,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-09-25 22:51:37','2021-09-25 22:51:37'),(2106,'default','status_changed',593,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-25 22:55:10','2021-09-25 22:55:10'),(2107,'default','added',446,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-25 22:56:39','2021-09-25 22:56:39'),(2108,'default','status_changed',537,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-25 23:27:03','2021-09-25 23:27:03'),(2109,'default','login',19,'App\\User',1,19,'App\\User','[]','2021-09-26 06:53:25','2021-09-26 06:53:25'),(2110,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-26 12:42:05','2021-09-26 12:42:05'),(2111,'default','added',611,'App\\Contact',1,11,'App\\User','[]','2021-09-26 12:52:02','2021-09-26 12:52:02'),(2112,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-26 14:26:19','2021-09-26 14:26:19'),(2113,'default','added',447,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-26 14:28:38','2021-09-26 14:28:38'),(2114,'default','added',612,'App\\Contact',1,4,'App\\User','[]','2021-09-26 14:29:39','2021-09-26 14:29:39'),(2115,'default','added',448,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-09-26 14:33:15','2021-09-26 14:33:15'),(2116,'default','added',613,'App\\Contact',1,4,'App\\User','[]','2021-09-26 14:41:20','2021-09-26 14:41:20'),(2117,'default','added',449,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-09-26 15:04:53','2021-09-26 15:04:53'),(2118,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-26 15:05:10','2021-09-26 15:05:10'),(2119,'default','status_changed',264,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-26 15:05:52','2021-09-26 15:05:52'),(2120,'default','status_changed',269,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-09-26 15:07:33','2021-09-26 15:07:33'),(2121,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-09-26 15:08:30','2021-09-26 15:08:30'),(2122,'default','added',450,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-09-26 15:13:48','2021-09-26 15:13:48'),(2123,'default','status_changed',589,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-26 15:29:08','2021-09-26 15:29:08'),(2124,'default','added',451,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":175}}','2021-09-26 15:29:49','2021-09-26 15:29:49'),(2125,'default','status_changed',594,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-26 15:30:40','2021-09-26 15:30:40'),(2126,'default','status_changed',454,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-26 15:56:45','2021-09-26 15:56:45'),(2127,'default','status_changed',580,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-26 16:00:07','2021-09-26 16:00:07'),(2128,'default','status_changed',473,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-26 16:39:31','2021-09-26 16:39:31'),(2129,'default','status_changed',373,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-26 16:51:30','2021-09-26 16:51:30'),(2130,'default','added',614,'App\\Contact',1,4,'App\\User','[]','2021-09-26 17:05:21','2021-09-26 17:05:21'),(2131,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-26 17:31:41','2021-09-26 17:31:41'),(2132,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-09-26 17:37:05','2021-09-26 17:37:05'),(2133,'default','added',452,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-26 17:51:26','2021-09-26 17:51:26'),(2134,'default','status_changed',565,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-26 17:51:46','2021-09-26 17:51:46'),(2135,'default','added',615,'App\\Contact',1,4,'App\\User','[]','2021-09-26 18:03:09','2021-09-26 18:03:09'),(2136,'default','added',453,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-09-26 18:42:33','2021-09-26 18:42:33'),(2137,'default','added',616,'App\\Contact',1,4,'App\\User','[]','2021-09-26 18:54:39','2021-09-26 18:54:39'),(2138,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-26 19:00:23','2021-09-26 19:00:23'),(2139,'default','added',454,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-26 19:01:01','2021-09-26 19:01:01'),(2140,'default','added',617,'App\\Contact',1,4,'App\\User','[]','2021-09-26 19:01:09','2021-09-26 19:01:09'),(2141,'default','added',618,'App\\Contact',1,4,'App\\User','[]','2021-09-26 19:30:57','2021-09-26 19:30:57'),(2142,'default','added',619,'App\\Contact',1,4,'App\\User','[]','2021-09-26 19:33:07','2021-09-26 19:33:07'),(2143,'default','added',620,'App\\Contact',1,4,'App\\User','[]','2021-09-26 19:43:41','2021-09-26 19:43:41'),(2144,'default','added',621,'App\\Contact',1,4,'App\\User','[]','2021-09-26 19:47:01','2021-09-26 19:47:01'),(2145,'default','added',455,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600}}','2021-09-26 19:57:49','2021-09-26 19:57:49'),(2146,'default','status_changed',580,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-26 19:58:22','2021-09-26 19:58:22'),(2147,'default','added',456,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-26 20:04:31','2021-09-26 20:04:31'),(2148,'default','added',457,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2400}}','2021-09-26 20:05:03','2021-09-26 20:05:03'),(2149,'default','status_changed',599,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-26 20:05:26','2021-09-26 20:05:26'),(2150,'default','status_changed',574,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-26 20:05:27','2021-09-26 20:05:27'),(2151,'default','added',622,'App\\Contact',1,11,'App\\User','[]','2021-09-26 20:26:49','2021-09-26 20:26:49'),(2152,'default','added',458,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":125}}','2021-09-26 21:01:45','2021-09-26 21:01:45'),(2153,'default','status_changed',609,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-26 21:06:30','2021-09-26 21:06:30'),(2154,'default','added',623,'App\\Contact',1,4,'App\\User','[]','2021-09-26 21:14:53','2021-09-26 21:14:53'),(2155,'default','added',459,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-26 21:23:25','2021-09-26 21:23:25'),(2156,'default','status_changed',590,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-26 21:36:28','2021-09-26 21:36:28'),(2157,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-09-26 21:50:43','2021-09-26 21:50:43'),(2158,'default','added',460,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-26 21:56:12','2021-09-26 21:56:12'),(2159,'default','added',461,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-26 21:57:44','2021-09-26 21:57:44'),(2160,'default','status_changed',611,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-26 21:57:58','2021-09-26 21:57:58'),(2161,'default','added',462,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5300}}','2021-09-26 22:12:14','2021-09-26 22:12:14'),(2162,'default','status_changed',554,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-26 22:12:35','2021-09-26 22:12:35'),(2163,'default','added',463,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3300}}','2021-09-26 22:13:00','2021-09-26 22:13:00'),(2164,'default','status_changed',540,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-26 22:13:25','2021-09-26 22:13:25'),(2165,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-27 12:43:21','2021-09-27 12:43:21'),(2166,'default','added',624,'App\\Contact',1,11,'App\\User','[]','2021-09-27 12:44:11','2021-09-27 12:44:11'),(2167,'default','added',464,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-27 12:55:19','2021-09-27 12:55:19'),(2168,'default','status_changed',610,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-27 12:56:45','2021-09-27 12:56:45'),(2169,'default','added',625,'App\\Contact',1,11,'App\\User','[]','2021-09-27 14:02:27','2021-09-27 14:02:27'),(2170,'default','login',19,'App\\User',1,19,'App\\User','[]','2021-09-27 15:13:45','2021-09-27 15:13:45'),(2171,'default','added',626,'App\\Contact',1,19,'App\\User','[]','2021-09-27 15:15:28','2021-09-27 15:15:28'),(2172,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-27 15:15:35','2021-09-27 15:15:35'),(2173,'default','added',627,'App\\Contact',1,11,'App\\User','[]','2021-09-27 15:27:21','2021-09-27 15:27:21'),(2174,'default','added',628,'App\\Contact',1,11,'App\\User','[]','2021-09-27 15:41:17','2021-09-27 15:41:17'),(2175,'default','status_changed',454,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-27 16:00:23','2021-09-27 16:00:23'),(2176,'default','status_changed',577,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Check In Progress\"}','2021-09-27 16:01:47','2021-09-27 16:01:47'),(2177,'default','added',465,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-27 16:58:04','2021-09-27 16:58:04'),(2178,'default','status_changed',502,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-27 16:58:24','2021-09-27 16:58:24'),(2179,'default','added',466,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-09-27 16:58:50','2021-09-27 16:58:50'),(2180,'default','status_changed',602,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-27 16:59:51','2021-09-27 16:59:51'),(2181,'default','logout',19,'App\\User',1,19,'App\\User','[]','2021-09-27 17:02:37','2021-09-27 17:02:37'),(2182,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-27 17:03:53','2021-09-27 17:03:53'),(2183,'default','added',629,'App\\Contact',1,11,'App\\User','[]','2021-09-27 17:04:33','2021-09-27 17:04:33'),(2184,'default','added',630,'App\\Contact',1,11,'App\\User','[]','2021-09-27 17:15:46','2021-09-27 17:15:46'),(2185,'default','added',631,'App\\Contact',1,11,'App\\User','[]','2021-09-27 17:18:14','2021-09-27 17:18:14'),(2186,'default','added',632,'App\\Contact',1,11,'App\\User','[]','2021-09-27 17:36:11','2021-09-27 17:36:11'),(2187,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-09-27 17:36:41','2021-09-27 17:36:41'),(2188,'default','added',633,'App\\Contact',1,11,'App\\User','[]','2021-09-27 17:43:29','2021-09-27 17:43:29'),(2189,'default','added',634,'App\\Contact',1,11,'App\\User','[]','2021-09-27 17:48:07','2021-09-27 17:48:07'),(2190,'default','added',635,'App\\Contact',1,11,'App\\User','[]','2021-09-27 18:28:16','2021-09-27 18:28:16'),(2191,'default','status_changed',605,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-27 18:41:42','2021-09-27 18:41:42'),(2192,'default','added',467,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}','2021-09-27 18:45:58','2021-09-27 18:45:58'),(2193,'default','status_changed',246,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-27 18:46:18','2021-09-27 18:46:18'),(2194,'default','added',468,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-27 18:52:44','2021-09-27 18:52:44'),(2195,'default','status_changed',607,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-27 18:53:06','2021-09-27 18:53:06'),(2196,'default','added',636,'App\\Contact',1,11,'App\\User','[]','2021-09-27 18:57:34','2021-09-27 18:57:34'),(2197,'default','status_changed',617,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-27 19:00:31','2021-09-27 19:00:31'),(2198,'default','added',469,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-27 19:49:31','2021-09-27 19:49:31'),(2199,'default','status_changed',458,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-27 19:49:47','2021-09-27 19:49:47'),(2200,'default','added',637,'App\\Contact',1,11,'App\\User','[]','2021-09-27 20:04:48','2021-09-27 20:04:48'),(2201,'default','added',470,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1150}}','2021-09-27 20:36:14','2021-09-27 20:36:14'),(2202,'default','added',471,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-09-27 20:40:36','2021-09-27 20:40:36'),(2203,'default','status_changed',616,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-27 20:40:49','2021-09-27 20:40:49'),(2204,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-27 21:01:41','2021-09-27 21:01:41'),(2205,'default','added',638,'App\\Contact',1,11,'App\\User','[]','2021-09-27 21:02:58','2021-09-27 21:02:58'),(2206,'default','added',472,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-09-27 21:03:17','2021-09-27 21:03:17'),(2207,'default','status_changed',584,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-27 21:03:55','2021-09-27 21:03:55'),(2208,'default','added',639,'App\\Contact',1,11,'App\\User','[]','2021-09-27 21:05:48','2021-09-27 21:05:48'),(2209,'default','added',640,'App\\Contact',1,11,'App\\User','[]','2021-09-27 21:11:45','2021-09-27 21:11:45'),(2210,'default','added',641,'App\\Contact',1,11,'App\\User','[]','2021-09-27 21:21:34','2021-09-27 21:21:34'),(2211,'default','added',642,'App\\Contact',1,11,'App\\User','[]','2021-09-27 21:30:14','2021-09-27 21:30:14'),(2212,'default','added',473,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":175}}','2021-09-27 21:42:36','2021-09-27 21:42:36'),(2213,'default','status_changed',578,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-27 21:43:22','2021-09-27 21:43:22'),(2214,'default','status_changed',629,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-27 22:00:10','2021-09-27 22:00:10'),(2215,'default','status_changed',627,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-27 22:00:23','2021-09-27 22:00:23'),(2216,'default','added',474,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-09-27 22:25:15','2021-09-27 22:25:15'),(2217,'default','status_changed',621,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-27 22:25:33','2021-09-27 22:25:33'),(2218,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-09-27 22:29:26','2021-09-27 22:29:26'),(2219,'default','added',475,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-27 22:33:24','2021-09-27 22:33:24'),(2220,'default','status_changed',591,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-27 22:33:41','2021-09-27 22:33:41'),(2221,'default','added',476,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-09-27 22:49:53','2021-09-27 22:49:53'),(2222,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-28 13:34:49','2021-09-28 13:34:49'),(2223,'default','added',643,'App\\Contact',1,11,'App\\User','[]','2021-09-28 13:35:28','2021-09-28 13:35:28'),(2224,'default','added',644,'App\\Contact',1,11,'App\\User','[]','2021-09-28 13:36:52','2021-09-28 13:36:52'),(2225,'default','added',645,'App\\Contact',1,11,'App\\User','[]','2021-09-28 14:14:06','2021-09-28 14:14:06'),(2226,'default','added',646,'App\\Contact',1,11,'App\\User','[]','2021-09-28 14:19:39','2021-09-28 14:19:39'),(2227,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-28 14:26:32','2021-09-28 14:26:32'),(2228,'default','added',647,'App\\Contact',1,11,'App\\User','[]','2021-09-28 14:35:16','2021-09-28 14:35:16'),(2229,'default','login',19,'App\\User',1,19,'App\\User','[]','2021-09-28 14:38:26','2021-09-28 14:38:26'),(2230,'default','added',648,'App\\Contact',1,19,'App\\User','[]','2021-09-28 14:39:22','2021-09-28 14:39:22'),(2231,'default','status_changed',453,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Finished\"}','2021-09-28 14:51:04','2021-09-28 14:51:04'),(2232,'default','status_changed',345,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-09-28 14:51:18','2021-09-28 14:51:18'),(2233,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-09-28 17:01:23','2021-09-28 17:01:23'),(2234,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-28 17:01:31','2021-09-28 17:01:31'),(2235,'default','added',477,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-28 18:11:16','2021-09-28 18:11:16'),(2236,'default','status_changed',623,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-28 18:11:33','2021-09-28 18:11:33'),(2237,'default','added',649,'App\\Contact',1,19,'App\\User','[]','2021-09-28 18:37:59','2021-09-28 18:37:59'),(2238,'default','added',478,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-28 19:02:25','2021-09-28 19:02:25'),(2239,'default','added',650,'App\\Contact',1,19,'App\\User','[]','2021-09-28 19:04:52','2021-09-28 19:04:52'),(2240,'default','added',651,'App\\Contact',1,19,'App\\User','[]','2021-09-28 19:05:18','2021-09-28 19:05:18'),(2241,'default','added',479,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-28 19:10:23','2021-09-28 19:10:23'),(2242,'default','status_changed',612,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-28 19:11:40','2021-09-28 19:11:40'),(2243,'default','added',480,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-28 19:14:09','2021-09-28 19:14:09'),(2244,'default','status_changed',598,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-28 19:14:26','2021-09-28 19:14:26'),(2245,'default','added',481,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-09-28 19:51:22','2021-09-28 19:51:22'),(2246,'default','status_changed',608,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-28 19:51:40','2021-09-28 19:51:40'),(2247,'default','added',652,'App\\Contact',1,4,'App\\User','[]','2021-09-28 20:22:14','2021-09-28 20:22:14'),(2248,'default','added',482,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-09-28 20:29:23','2021-09-28 20:29:23'),(2249,'default','status_changed',614,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-28 20:29:44','2021-09-28 20:29:44'),(2250,'default','added',653,'App\\Contact',1,4,'App\\User','[]','2021-09-28 20:47:33','2021-09-28 20:47:33'),(2251,'default','added',654,'App\\Contact',1,4,'App\\User','[]','2021-09-28 20:54:29','2021-09-28 20:54:29'),(2252,'default','added',483,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-28 21:07:07','2021-09-28 21:07:07'),(2253,'default','status_changed',637,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-28 21:07:28','2021-09-28 21:07:28'),(2254,'default','status_changed',375,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-28 21:18:55','2021-09-28 21:18:55'),(2255,'default','added',655,'App\\Contact',1,19,'App\\User','[]','2021-09-28 21:40:35','2021-09-28 21:40:35'),(2256,'default','added',656,'App\\Contact',1,4,'App\\User','[]','2021-09-28 21:41:19','2021-09-28 21:41:19'),(2257,'default','added',657,'App\\Contact',1,4,'App\\User','[]','2021-09-28 22:10:09','2021-09-28 22:10:09'),(2258,'default','added',484,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-28 22:22:01','2021-09-28 22:22:01'),(2259,'default','added',485,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":950}}','2021-09-28 22:22:41','2021-09-28 22:22:41'),(2260,'default','status_changed',627,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-28 22:23:03','2021-09-28 22:23:03'),(2261,'default','added',486,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}','2021-09-28 22:23:36','2021-09-28 22:23:36'),(2262,'default','added',487,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-28 22:24:24','2021-09-28 22:24:24'),(2263,'default','status_changed',596,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-28 22:24:43','2021-09-28 22:24:43'),(2264,'default','added',488,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-09-28 22:25:09','2021-09-28 22:25:09'),(2265,'default','status_changed',615,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-28 22:25:25','2021-09-28 22:25:25'),(2266,'default','added',489,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-09-28 22:25:56','2021-09-28 22:25:56'),(2267,'default','status_changed',620,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-28 22:26:31','2021-09-28 22:26:31'),(2268,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-29 12:13:17','2021-09-29 12:13:17'),(2269,'default','added',658,'App\\Contact',1,11,'App\\User','[]','2021-09-29 12:26:21','2021-09-29 12:26:21'),(2270,'default','added',659,'App\\Contact',1,11,'App\\User','[]','2021-09-29 13:06:01','2021-09-29 13:06:01'),(2271,'default','added',660,'App\\Contact',1,11,'App\\User','[]','2021-09-29 13:35:30','2021-09-29 13:35:30'),(2272,'default','added',661,'App\\Contact',1,11,'App\\User','[]','2021-09-29 13:41:45','2021-09-29 13:41:45'),(2273,'default','added',662,'App\\Contact',1,11,'App\\User','[]','2021-09-29 13:42:25','2021-09-29 13:42:25'),(2274,'default','added',663,'App\\Contact',1,11,'App\\User','[]','2021-09-29 13:44:09','2021-09-29 13:44:09'),(2275,'default','added',664,'App\\Contact',1,11,'App\\User','[]','2021-09-29 13:54:40','2021-09-29 13:54:40'),(2276,'default','added',490,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-29 14:27:41','2021-09-29 14:27:41'),(2277,'default','status_changed',630,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 14:27:54','2021-09-29 14:27:54'),(2278,'default','added',665,'App\\Contact',1,11,'App\\User','[]','2021-09-29 14:46:52','2021-09-29 14:46:52'),(2279,'default','added',666,'App\\Contact',1,11,'App\\User','[]','2021-09-29 15:02:56','2021-09-29 15:02:56'),(2280,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-29 15:04:57','2021-09-29 15:04:57'),(2281,'default','added',667,'App\\Contact',1,11,'App\\User','[]','2021-09-29 15:31:19','2021-09-29 15:31:19'),(2282,'default','added',491,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-09-29 15:53:26','2021-09-29 15:53:26'),(2283,'default','status_changed',638,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"reject by customer\"}','2021-09-29 16:25:02','2021-09-29 16:25:02'),(2284,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-29 16:34:53','2021-09-29 16:34:53'),(2285,'default','status_changed',205,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 16:45:12','2021-09-29 16:45:12'),(2286,'default','status_changed',383,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 16:45:43','2021-09-29 16:45:43'),(2287,'default','status_changed',441,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 16:46:34','2021-09-29 16:46:34'),(2288,'default','status_changed',424,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 16:47:06','2021-09-29 16:47:06'),(2289,'default','status_changed',460,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 16:47:27','2021-09-29 16:47:27'),(2290,'default','status_changed',411,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 16:47:59','2021-09-29 16:47:59'),(2291,'default','status_changed',626,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 16:50:43','2021-09-29 16:50:43'),(2292,'default','added',492,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-29 16:51:48','2021-09-29 16:51:48'),(2293,'default','status_changed',217,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 16:51:49','2021-09-29 16:51:49'),(2294,'default','added',493,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600}}','2021-09-29 16:52:26','2021-09-29 16:52:26'),(2295,'default','status_changed',642,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 16:52:47','2021-09-29 16:52:47'),(2296,'default','added',494,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}','2021-09-29 16:53:14','2021-09-29 16:53:14'),(2297,'default','status_changed',428,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 16:53:30','2021-09-29 16:53:30'),(2298,'default','added',495,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-29 16:54:10','2021-09-29 16:54:10'),(2299,'default','status_changed',562,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 16:54:24','2021-09-29 16:54:24'),(2300,'default','status_changed',558,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 16:57:14','2021-09-29 16:57:14'),(2301,'default','added',496,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1200}}','2021-09-29 16:57:34','2021-09-29 16:57:34'),(2302,'default','status_changed',490,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 16:57:47','2021-09-29 16:57:47'),(2303,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-09-29 16:59:27','2021-09-29 16:59:27'),(2304,'default','status_changed',428,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-29 17:08:41','2021-09-29 17:08:41'),(2305,'default','added',497,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-29 17:20:24','2021-09-29 17:20:24'),(2306,'default','status_changed',649,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 17:21:16','2021-09-29 17:21:16'),(2307,'default','status_changed',557,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-09-29 17:24:37','2021-09-29 17:24:37'),(2308,'default','added',668,'App\\Contact',1,11,'App\\User','[]','2021-09-29 17:28:53','2021-09-29 17:28:53'),(2309,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-09-29 17:43:38','2021-09-29 17:43:38'),(2310,'default','added',669,'App\\Contact',1,11,'App\\User','[]','2021-09-29 17:45:54','2021-09-29 17:45:54'),(2311,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-29 17:48:04','2021-09-29 17:48:04'),(2312,'default','added',670,'App\\Contact',1,11,'App\\User','[]','2021-09-29 17:48:57','2021-09-29 17:48:57'),(2313,'default','added',498,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1100}}','2021-09-29 17:59:00','2021-09-29 17:59:00'),(2314,'default','status_changed',619,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 18:00:19','2021-09-29 18:00:19'),(2315,'default','added',499,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1150}}','2021-09-29 18:03:27','2021-09-29 18:03:27'),(2316,'default','status_changed',618,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 18:04:25','2021-09-29 18:04:25'),(2317,'default','added',671,'App\\Contact',1,11,'App\\User','[]','2021-09-29 18:09:52','2021-09-29 18:09:52'),(2318,'default','added',672,'App\\Contact',1,11,'App\\User','[]','2021-09-29 18:30:13','2021-09-29 18:30:13'),(2319,'default','added',673,'App\\Contact',1,11,'App\\User','[]','2021-09-29 18:40:34','2021-09-29 18:40:34'),(2320,'default','added',500,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-29 18:57:49','2021-09-29 18:57:49'),(2321,'default','status_changed',648,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 18:58:08','2021-09-29 18:58:08'),(2322,'default','added',674,'App\\Contact',1,11,'App\\User','[]','2021-09-29 19:02:20','2021-09-29 19:02:20'),(2323,'default','added',675,'App\\Contact',1,11,'App\\User','[]','2021-09-29 19:33:23','2021-09-29 19:33:23'),(2324,'default','added',676,'App\\Contact',1,11,'App\\User','[]','2021-09-29 19:39:18','2021-09-29 19:39:18'),(2325,'default','added',677,'App\\Contact',1,11,'App\\User','[]','2021-09-29 19:41:46','2021-09-29 19:41:46'),(2326,'default','added',678,'App\\Contact',1,11,'App\\User','[]','2021-09-29 19:52:42','2021-09-29 19:52:42'),(2327,'default','status_changed',652,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-29 20:02:20','2021-09-29 20:02:20'),(2328,'default','status_changed',660,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-09-29 20:05:46','2021-09-29 20:05:46'),(2329,'default','added',679,'App\\Contact',1,11,'App\\User','[]','2021-09-29 20:18:44','2021-09-29 20:18:44'),(2330,'default','added',680,'App\\Contact',1,11,'App\\User','[]','2021-09-29 20:26:14','2021-09-29 20:26:14'),(2331,'default','added',681,'App\\Contact',1,11,'App\\User','[]','2021-09-29 20:31:16','2021-09-29 20:31:16'),(2332,'default','status_changed',636,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-29 20:31:53','2021-09-29 20:31:53'),(2333,'default','status_changed',664,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-29 20:32:04','2021-09-29 20:32:04'),(2334,'default','added',682,'App\\Contact',1,11,'App\\User','[]','2021-09-29 20:44:37','2021-09-29 20:44:37'),(2335,'default','added',683,'App\\Contact',1,11,'App\\User','[]','2021-09-29 21:04:03','2021-09-29 21:04:03'),(2336,'default','status_changed',428,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 21:24:37','2021-09-29 21:24:37'),(2337,'default','added',501,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-09-29 21:25:15','2021-09-29 21:25:15'),(2338,'default','added',502,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":175}}','2021-09-29 21:25:55','2021-09-29 21:25:55'),(2339,'default','status_changed',655,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 21:26:20','2021-09-29 21:26:20'),(2340,'default','added',503,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":175}}','2021-09-29 21:28:03','2021-09-29 21:28:03'),(2341,'default','status_changed',644,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 21:28:53','2021-09-29 21:28:53'),(2342,'default','added',504,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-29 21:29:45','2021-09-29 21:29:45'),(2343,'default','status_changed',664,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 21:30:22','2021-09-29 21:30:22'),(2344,'default','added',505,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-29 21:31:05','2021-09-29 21:31:05'),(2345,'default','status_changed',658,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 21:31:37','2021-09-29 21:31:37'),(2346,'default','status_changed',660,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-29 21:34:11','2021-09-29 21:34:11'),(2347,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-09-29 21:37:15','2021-09-29 21:37:15'),(2348,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-09-29 21:42:53','2021-09-29 21:42:53'),(2349,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-29 21:45:06','2021-09-29 21:45:06'),(2350,'default','added',506,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-09-29 21:47:49','2021-09-29 21:47:49'),(2351,'default','added',507,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-09-29 21:50:22','2021-09-29 21:50:22'),(2352,'default','status_changed',659,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 21:50:35','2021-09-29 21:50:35'),(2353,'default','added',508,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-29 21:51:13','2021-09-29 21:51:13'),(2354,'default','status_changed',639,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 21:51:29','2021-09-29 21:51:29'),(2355,'default','added',509,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-09-29 21:52:04','2021-09-29 21:52:04'),(2356,'default','status_changed',657,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 21:52:21','2021-09-29 21:52:21'),(2357,'default','added',510,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-29 21:52:50','2021-09-29 21:52:50'),(2358,'default','status_changed',641,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 21:53:15','2021-09-29 21:53:15'),(2359,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-09-29 22:00:07','2021-09-29 22:00:07'),(2360,'default','added',511,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-09-29 22:02:10','2021-09-29 22:02:10'),(2361,'default','status_changed',652,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 22:02:33','2021-09-29 22:02:33'),(2362,'default','added',684,'App\\Contact',1,11,'App\\User','[]','2021-09-29 22:30:23','2021-09-29 22:30:23'),(2363,'default','added',512,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1100}}','2021-09-29 22:58:13','2021-09-29 22:58:13'),(2364,'default','status_changed',635,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 22:58:35','2021-09-29 22:58:35'),(2365,'default','added',513,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-09-29 22:59:14','2021-09-29 22:59:14'),(2366,'default','status_changed',640,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 22:59:33','2021-09-29 22:59:33'),(2367,'default','added',514,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-09-29 23:00:03','2021-09-29 23:00:03'),(2368,'default','status_changed',668,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-29 23:00:35','2021-09-29 23:00:35'),(2369,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-30 12:28:43','2021-09-30 12:28:43'),(2370,'default','added',685,'App\\Contact',1,4,'App\\User','[]','2021-09-30 13:06:47','2021-09-30 13:06:47'),(2371,'default','status_changed',647,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-30 13:29:10','2021-09-30 13:29:10'),(2372,'default','added',686,'App\\Contact',1,4,'App\\User','[]','2021-09-30 13:45:50','2021-09-30 13:45:50'),(2373,'default','added',687,'App\\Contact',1,4,'App\\User','[]','2021-09-30 14:03:33','2021-09-30 14:03:33'),(2374,'default','added',515,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-30 14:11:38','2021-09-30 14:11:38'),(2375,'default','status_changed',632,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-30 14:12:02','2021-09-30 14:12:02'),(2376,'default','added',688,'App\\Contact',1,4,'App\\User','[]','2021-09-30 14:29:11','2021-09-30 14:29:11'),(2377,'default','login',19,'App\\User',1,19,'App\\User','[]','2021-09-30 14:33:45','2021-09-30 14:33:45'),(2378,'default','added',689,'App\\Contact',1,19,'App\\User','[]','2021-09-30 14:35:08','2021-09-30 14:35:08'),(2379,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-30 15:24:35','2021-09-30 15:24:35'),(2380,'default','added',690,'App\\Contact',1,19,'App\\User','[]','2021-09-30 15:43:32','2021-09-30 15:43:32'),(2381,'default','added',691,'App\\Contact',1,19,'App\\User','[]','2021-09-30 15:48:56','2021-09-30 15:48:56'),(2382,'default','added',516,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-09-30 15:54:42','2021-09-30 15:54:42'),(2383,'default','status_changed',671,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-30 15:55:06','2021-09-30 15:55:06'),(2384,'default','added',692,'App\\Contact',1,4,'App\\User','[]','2021-09-30 16:59:39','2021-09-30 16:59:39'),(2385,'default','added',517,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-09-30 17:08:24','2021-09-30 17:08:24'),(2386,'default','status_changed',634,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-30 17:08:43','2021-09-30 17:08:43'),(2387,'default','added',693,'App\\Contact',1,4,'App\\User','[]','2021-09-30 17:34:44','2021-09-30 17:34:44'),(2388,'default','added',24,'App\\User',1,1,'App\\User','[]','2021-09-30 17:37:18','2021-09-30 17:37:18'),(2389,'default','status_changed',673,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-30 17:38:28','2021-09-30 17:38:28'),(2390,'default','added',694,'App\\Contact',1,4,'App\\User','[]','2021-09-30 17:47:41','2021-09-30 17:47:41'),(2391,'default','status_changed',453,'Modules\\Repair\\Entities\\JobSheet',1,1,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-09-30 18:09:29','2021-09-30 18:09:29'),(2392,'default','added',695,'App\\Contact',1,4,'App\\User','[]','2021-09-30 18:43:39','2021-09-30 18:43:39'),(2393,'default','added',518,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-30 18:54:51','2021-09-30 18:54:51'),(2394,'default','status_changed',675,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-30 18:55:22','2021-09-30 18:55:22'),(2395,'default','status_changed',557,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-30 18:56:37','2021-09-30 18:56:37'),(2396,'default','added',696,'App\\Contact',1,4,'App\\User','[]','2021-09-30 18:57:24','2021-09-30 18:57:24'),(2397,'default','status_changed',453,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-09-30 18:57:50','2021-09-30 18:57:50'),(2398,'default','status_changed',287,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"reject by customer\"}','2021-09-30 18:58:37','2021-09-30 18:58:37'),(2399,'default','status_changed',672,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Can\'t be repaired\"}','2021-09-30 18:59:30','2021-09-30 18:59:30'),(2400,'default','added',697,'App\\Contact',1,4,'App\\User','[]','2021-09-30 19:02:36','2021-09-30 19:02:36'),(2401,'default','added',519,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-09-30 19:33:48','2021-09-30 19:33:48'),(2402,'default','added',698,'App\\Contact',1,4,'App\\User','[]','2021-09-30 19:37:38','2021-09-30 19:37:38'),(2403,'default','logout',19,'App\\User',1,19,'App\\User','[]','2021-09-30 19:38:46','2021-09-30 19:38:46'),(2404,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-09-30 19:39:07','2021-09-30 19:39:07'),(2405,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-09-30 19:41:48','2021-09-30 19:41:48'),(2406,'default','added',699,'App\\Contact',1,4,'App\\User','[]','2021-09-30 19:43:18','2021-09-30 19:43:18'),(2407,'default','added',700,'App\\Contact',1,4,'App\\User','[]','2021-09-30 20:07:06','2021-09-30 20:07:06'),(2408,'default','added',520,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-09-30 20:12:32','2021-09-30 20:12:32'),(2409,'default','added',701,'App\\Contact',1,4,'App\\User','[]','2021-09-30 20:13:24','2021-09-30 20:13:24'),(2410,'default','status_changed',669,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-30 20:24:31','2021-09-30 20:24:31'),(2411,'default','added',702,'App\\Contact',1,4,'App\\User','[]','2021-09-30 20:25:22','2021-09-30 20:25:22'),(2412,'default','added',521,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-09-30 20:28:36','2021-09-30 20:28:36'),(2413,'default','status_changed',633,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-30 20:29:10','2021-09-30 20:29:10'),(2414,'default','added',522,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-09-30 20:31:14','2021-09-30 20:31:14'),(2415,'default','status_changed',656,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-30 20:31:32','2021-09-30 20:31:32'),(2416,'default','added',523,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-09-30 20:32:48','2021-09-30 20:32:48'),(2417,'default','status_changed',682,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-30 20:33:05','2021-09-30 20:33:05'),(2418,'default','status_changed',681,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-09-30 20:33:12','2021-09-30 20:33:12'),(2419,'default','status_changed',650,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-30 20:41:24','2021-09-30 20:41:24'),(2420,'default','status_changed',686,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-09-30 21:01:00','2021-09-30 21:01:00'),(2421,'default','added',703,'App\\Contact',1,4,'App\\User','[]','2021-09-30 21:07:17','2021-09-30 21:07:17'),(2422,'default','added',704,'App\\Contact',1,4,'App\\User','[]','2021-09-30 21:23:34','2021-09-30 21:23:34'),(2423,'default','added',524,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-09-30 21:32:36','2021-09-30 21:32:36'),(2424,'default','status_changed',636,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-30 21:32:59','2021-09-30 21:32:59'),(2425,'default','added',705,'App\\Contact',1,4,'App\\User','[]','2021-09-30 22:00:13','2021-09-30 22:00:13'),(2426,'default','added',706,'App\\Contact',1,4,'App\\User','[]','2021-09-30 22:07:08','2021-09-30 22:07:08'),(2427,'default','added',525,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-09-30 22:37:03','2021-09-30 22:37:03'),(2428,'default','status_changed',531,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-30 22:37:19','2021-09-30 22:37:19'),(2429,'default','added',526,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":850}}','2021-09-30 22:37:51','2021-09-30 22:37:51'),(2430,'default','status_changed',691,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-30 22:38:05','2021-09-30 22:38:05'),(2431,'default','added',527,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-09-30 22:38:31','2021-09-30 22:38:31'),(2432,'default','status_changed',679,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-30 22:38:47','2021-09-30 22:38:47'),(2433,'default','added',528,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1150}}','2021-09-30 22:39:43','2021-09-30 22:39:43'),(2434,'default','status_changed',667,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-30 22:39:56','2021-09-30 22:39:56'),(2435,'default','added',529,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}','2021-09-30 22:47:34','2021-09-30 22:47:34'),(2436,'default','status_changed',629,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-30 22:47:47','2021-09-30 22:47:47'),(2437,'default','added',530,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-09-30 22:48:07','2021-09-30 22:48:07'),(2438,'default','status_changed',683,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-09-30 22:48:20','2021-09-30 22:48:20'),(2439,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-09-30 23:07:36','2021-09-30 23:07:36'),(2440,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-01 14:24:02','2021-10-01 14:24:02'),(2441,'default','added',707,'App\\Contact',1,11,'App\\User','[]','2021-10-01 14:25:00','2021-10-01 14:25:00'),(2442,'default','status_changed',672,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-01 14:31:08','2021-10-01 14:31:08'),(2443,'default','added',708,'App\\Contact',1,11,'App\\User','[]','2021-10-01 16:30:14','2021-10-01 16:30:14'),(2444,'default','added',709,'App\\Contact',1,11,'App\\User','[]','2021-10-01 18:57:29','2021-10-01 18:57:29'),(2445,'default','added',710,'App\\Contact',1,11,'App\\User','[]','2021-10-01 19:06:50','2021-10-01 19:06:50'),(2446,'default','added',711,'App\\Contact',1,11,'App\\User','[]','2021-10-01 19:26:04','2021-10-01 19:26:04'),(2447,'default','added',712,'App\\Contact',1,11,'App\\User','[]','2021-10-01 19:49:25','2021-10-01 19:49:25'),(2448,'default','added',713,'App\\Contact',1,11,'App\\User','[]','2021-10-01 19:56:47','2021-10-01 19:56:47'),(2449,'default','added',714,'App\\Contact',1,11,'App\\User','[]','2021-10-01 21:04:45','2021-10-01 21:04:45'),(2450,'default','added',715,'App\\Contact',1,11,'App\\User','[]','2021-10-01 21:22:18','2021-10-01 21:22:18'),(2451,'default','added',716,'App\\Contact',1,11,'App\\User','[]','2021-10-01 21:29:38','2021-10-01 21:29:38'),(2452,'default','added',717,'App\\Contact',1,11,'App\\User','[]','2021-10-01 21:30:34','2021-10-01 21:30:34'),(2453,'default','added',531,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-10-01 21:40:25','2021-10-01 21:40:25'),(2454,'default','status_changed',674,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-01 21:40:38','2021-10-01 21:40:38'),(2455,'default','added',532,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-10-01 22:06:39','2021-10-01 22:06:39'),(2456,'default','status_changed',391,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-01 22:06:53','2021-10-01 22:06:53'),(2457,'default','status_changed',394,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-01 22:07:00','2021-10-01 22:07:00'),(2458,'default','added',533,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-10-01 22:07:17','2021-10-01 22:07:17'),(2459,'default','added',534,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-10-01 22:07:38','2021-10-01 22:07:38'),(2460,'default','status_changed',392,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-01 22:08:29','2021-10-01 22:08:29'),(2461,'default','status_changed',393,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-01 22:08:36','2021-10-01 22:08:36'),(2462,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-02 05:50:15','2021-10-02 05:50:15'),(2463,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-02 12:48:28','2021-10-02 12:48:28'),(2464,'default','added',718,'App\\Contact',1,11,'App\\User','[]','2021-10-02 13:02:46','2021-10-02 13:02:46'),(2465,'default','added',719,'App\\Contact',1,11,'App\\User','[]','2021-10-02 13:15:47','2021-10-02 13:15:47'),(2466,'default','added',720,'App\\Contact',1,11,'App\\User','[]','2021-10-02 13:18:14','2021-10-02 13:18:14'),(2467,'default','added',721,'App\\Contact',1,11,'App\\User','[]','2021-10-02 13:28:43','2021-10-02 13:28:43'),(2468,'default','added',535,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-10-02 14:09:51','2021-10-02 14:09:51'),(2469,'default','status_changed',676,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-02 14:10:03','2021-10-02 14:10:03'),(2470,'default','added',722,'App\\Contact',1,11,'App\\User','[]','2021-10-02 14:23:06','2021-10-02 14:23:06'),(2471,'default','added',536,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}','2021-10-02 14:43:06','2021-10-02 14:43:06'),(2472,'default','status_changed',680,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-02 14:43:28','2021-10-02 14:43:28'),(2473,'default','added',537,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-10-02 14:43:47','2021-10-02 14:43:47'),(2474,'default','status_changed',613,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-02 14:44:15','2021-10-02 14:44:15'),(2475,'default','added',723,'App\\Contact',1,11,'App\\User','[]','2021-10-02 15:15:41','2021-10-02 15:15:41'),(2476,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-02 15:19:38','2021-10-02 15:19:38'),(2477,'default','added',724,'App\\Contact',1,11,'App\\User','[]','2021-10-02 15:22:42','2021-10-02 15:22:42'),(2478,'default','added',538,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-10-02 15:43:48','2021-10-02 15:43:48'),(2479,'default','added',725,'App\\Contact',1,11,'App\\User','[]','2021-10-02 16:16:13','2021-10-02 16:16:13'),(2480,'default','status_changed',573,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-02 16:19:59','2021-10-02 16:19:59'),(2481,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-02 16:23:22','2021-10-02 16:23:22'),(2482,'default','added',726,'App\\Contact',1,11,'App\\User','[]','2021-10-02 16:51:58','2021-10-02 16:51:58'),(2483,'default','added',727,'App\\Contact',1,11,'App\\User','[]','2021-10-02 17:03:21','2021-10-02 17:03:21'),(2484,'default','added',728,'App\\Contact',1,11,'App\\User','[]','2021-10-02 17:13:05','2021-10-02 17:13:05'),(2485,'default','added',729,'App\\Contact',1,11,'App\\User','[]','2021-10-02 17:16:09','2021-10-02 17:16:09'),(2486,'default','added',730,'App\\Contact',1,11,'App\\User','[]','2021-10-02 17:57:34','2021-10-02 17:57:34'),(2487,'default','added',731,'App\\Contact',1,11,'App\\User','[]','2021-10-02 18:20:27','2021-10-02 18:20:27'),(2488,'default','added',732,'App\\Contact',1,11,'App\\User','[]','2021-10-02 19:10:19','2021-10-02 19:10:19'),(2489,'default','added',733,'App\\Contact',1,11,'App\\User','[]','2021-10-02 19:13:51','2021-10-02 19:13:51'),(2490,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-02 19:14:22','2021-10-02 19:14:22'),(2491,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-02 19:14:40','2021-10-02 19:14:40'),(2492,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-02 19:14:51','2021-10-02 19:14:51'),(2493,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-02 19:15:02','2021-10-02 19:15:02'),(2494,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-02 19:15:09','2021-10-02 19:15:09'),(2495,'default','added',539,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-10-02 19:22:51','2021-10-02 19:22:51'),(2496,'default','status_changed',714,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-02 19:23:03','2021-10-02 19:23:03'),(2497,'default','added',540,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-10-02 19:26:00','2021-10-02 19:26:00'),(2498,'default','status_changed',692,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-02 19:26:13','2021-10-02 19:26:13'),(2499,'default','added',734,'App\\Contact',1,11,'App\\User','[]','2021-10-02 19:34:09','2021-10-02 19:34:09'),(2500,'default','status_changed',690,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-10-02 19:50:18','2021-10-02 19:50:18'),(2501,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-02 19:55:17','2021-10-02 19:55:17'),(2502,'default','status_changed',699,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"reject by customer\"}','2021-10-02 20:20:47','2021-10-02 20:20:47'),(2503,'default','added',735,'App\\Contact',1,11,'App\\User','[]','2021-10-02 20:21:38','2021-10-02 20:21:38'),(2504,'default','added',736,'App\\Contact',1,11,'App\\User','[]','2021-10-02 20:31:37','2021-10-02 20:31:37'),(2505,'default','added',737,'App\\Contact',1,11,'App\\User','[]','2021-10-02 20:35:26','2021-10-02 20:35:26'),(2506,'default','status_changed',703,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"reject by customer\"}','2021-10-02 20:52:19','2021-10-02 20:52:19'),(2507,'default','added',738,'App\\Contact',1,11,'App\\User','[]','2021-10-02 21:10:01','2021-10-02 21:10:01'),(2508,'default','status_changed',706,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-02 21:20:52','2021-10-02 21:20:52'),(2509,'default','added',541,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-10-02 21:24:59','2021-10-02 21:24:59'),(2510,'default','status_changed',711,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-02 21:25:13','2021-10-02 21:25:13'),(2511,'default','added',542,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-10-02 21:26:31','2021-10-02 21:26:31'),(2512,'default','status_changed',709,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-02 21:26:49','2021-10-02 21:26:49'),(2513,'default','added',543,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-10-02 21:28:53','2021-10-02 21:28:53'),(2514,'default','status_changed',690,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-02 21:29:20','2021-10-02 21:29:20'),(2515,'default','added',544,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}','2021-10-02 21:32:54','2021-10-02 21:32:54'),(2516,'default','status_changed',693,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-02 21:33:29','2021-10-02 21:33:29'),(2517,'default','added',545,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-10-02 21:37:34','2021-10-02 21:37:34'),(2518,'default','status_changed',708,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-02 21:37:50','2021-10-02 21:37:50'),(2519,'default','added',546,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":725}}','2021-10-02 21:38:55','2021-10-02 21:38:55'),(2520,'default','status_changed',700,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-02 21:43:14','2021-10-02 21:43:14'),(2521,'default','added',547,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}','2021-10-02 21:43:38','2021-10-02 21:43:38'),(2522,'default','status_changed',716,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-02 21:43:55','2021-10-02 21:43:55'),(2523,'default','added',548,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-10-02 21:44:22','2021-10-02 21:44:22'),(2524,'default','status_changed',712,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-02 21:44:38','2021-10-02 21:44:38'),(2525,'default','added',549,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-10-02 21:51:07','2021-10-02 21:51:07'),(2526,'default','status_changed',704,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-02 21:51:19','2021-10-02 21:51:19'),(2527,'default','added',550,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-10-02 21:54:00','2021-10-02 21:54:00'),(2528,'default','status_changed',702,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-02 21:54:18','2021-10-02 21:54:18'),(2529,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-02 21:57:07','2021-10-02 21:57:07'),(2530,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-03 12:13:16','2021-10-03 12:13:16'),(2531,'default','added',739,'App\\Contact',1,11,'App\\User','[]','2021-10-03 12:20:52','2021-10-03 12:20:52'),(2532,'default','added',740,'App\\Contact',1,11,'App\\User','[]','2021-10-03 12:21:54','2021-10-03 12:21:54'),(2533,'default','added',551,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-10-03 13:07:03','2021-10-03 13:07:03'),(2534,'default','status_changed',568,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-03 13:08:57','2021-10-03 13:08:57'),(2535,'default','status_changed',703,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-03 13:15:57','2021-10-03 13:15:57'),(2536,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-03 13:18:47','2021-10-03 13:18:47'),(2537,'default','added',552,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-10-03 13:19:09','2021-10-03 13:19:09'),(2538,'default','added',741,'App\\Contact',1,11,'App\\User','[]','2021-10-03 13:19:33','2021-10-03 13:19:33'),(2539,'default','status_changed',710,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-03 13:19:33','2021-10-03 13:19:33'),(2540,'default','status_changed',715,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-03 13:50:55','2021-10-03 13:50:55'),(2541,'default','status_changed',666,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Waiting for customer approve\"}','2021-10-03 13:51:10','2021-10-03 13:51:10'),(2542,'default','added',553,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}','2021-10-03 14:59:23','2021-10-03 14:59:23'),(2543,'default','status_changed',673,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-03 15:00:21','2021-10-03 15:00:21'),(2544,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-03 15:00:55','2021-10-03 15:00:55'),(2545,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-03 15:01:08','2021-10-03 15:01:08'),(2546,'default','status_changed',456,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"reject by customer\"}','2021-10-03 15:02:11','2021-10-03 15:02:11'),(2547,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-03 15:05:39','2021-10-03 15:05:39'),(2548,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-10-03 15:05:56','2021-10-03 15:05:56'),(2549,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-03 15:06:07','2021-10-03 15:06:07'),(2550,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-10-03 15:09:02','2021-10-03 15:09:02'),(2551,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-03 15:09:13','2021-10-03 15:09:13'),(2552,'default','added',742,'App\\Contact',1,11,'App\\User','[]','2021-10-03 15:10:54','2021-10-03 15:10:54'),(2553,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-10-03 15:11:34','2021-10-03 15:11:34'),(2554,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-03 15:11:47','2021-10-03 15:11:47'),(2555,'default','added',554,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-03 15:26:23','2021-10-03 15:26:23'),(2556,'default','added',555,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-03 15:27:34','2021-10-03 15:27:34'),(2557,'default','added',556,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-03 15:34:18','2021-10-03 15:34:18'),(2558,'default','payment_edited',556,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"},\"old\":{\"payment_status\":\"due\"}}','2021-10-03 15:35:15','2021-10-03 15:35:15'),(2559,'default','payment_edited',555,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"},\"old\":{\"payment_status\":\"due\"}}','2021-10-03 15:35:28','2021-10-03 15:35:28'),(2560,'default','payment_edited',554,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"},\"old\":{\"payment_status\":\"due\"}}','2021-10-03 15:35:38','2021-10-03 15:35:38'),(2561,'default','added',557,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-03 15:40:10','2021-10-03 15:40:10'),(2562,'default','added',558,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-03 15:41:47','2021-10-03 15:41:47'),(2563,'default','added',559,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-03 15:42:47','2021-10-03 15:42:47'),(2564,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-03 15:57:09','2021-10-03 15:57:09'),(2565,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-03 15:57:20','2021-10-03 15:57:20'),(2566,'default','payment_edited',559,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"},\"old\":{\"payment_status\":\"due\"}}','2021-10-03 15:58:55','2021-10-03 15:58:55'),(2567,'default','payment_edited',558,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"},\"old\":{\"payment_status\":\"due\"}}','2021-10-03 15:59:04','2021-10-03 15:59:04'),(2568,'default','added',743,'App\\Contact',1,11,'App\\User','[]','2021-10-03 15:59:08','2021-10-03 15:59:08'),(2569,'default','payment_edited',557,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"},\"old\":{\"payment_status\":\"due\"}}','2021-10-03 15:59:17','2021-10-03 15:59:17'),(2570,'default','added',560,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-03 16:00:57','2021-10-03 16:00:57'),(2571,'default','added',561,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":725}}','2021-10-03 16:05:53','2021-10-03 16:05:53'),(2572,'default','added',562,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":700}}','2021-10-03 16:14:56','2021-10-03 16:14:56'),(2573,'default','added',563,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":700}}','2021-10-03 16:16:55','2021-10-03 16:16:55'),(2574,'default','payment_edited',281,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"500.0000\"}}','2021-10-03 16:21:09','2021-10-03 16:21:09'),(2575,'default','status_changed',720,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Can\'t be repaired\"}','2021-10-03 16:33:57','2021-10-03 16:33:57'),(2576,'default','payment_edited',393,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"300.0000\"}}','2021-10-03 16:35:35','2021-10-03 16:35:35'),(2577,'default','payment_edited',393,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"300.0000\"}}','2021-10-03 16:37:42','2021-10-03 16:37:42'),(2578,'default','payment_edited',393,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"300.0000\"}}','2021-10-03 16:38:44','2021-10-03 16:38:44'),(2579,'default','payment_edited',393,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"300.0000\"}}','2021-10-03 16:40:24','2021-10-03 16:40:24'),(2580,'default','payment_edited',114,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"800.0000\"}}','2021-10-03 16:50:37','2021-10-03 16:50:37'),(2581,'default','added',564,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-03 17:04:35','2021-10-03 17:04:35'),(2582,'default','added',565,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-03 17:06:06','2021-10-03 17:06:06'),(2583,'default','edited',565,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"}}','2021-10-03 17:06:40','2021-10-03 17:06:40'),(2584,'default','added',566,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-03 17:07:43','2021-10-03 17:07:43'),(2585,'default','added',567,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-03 17:08:45','2021-10-03 17:08:45'),(2586,'default','added',568,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-03 17:09:38','2021-10-03 17:09:38'),(2587,'default','added',569,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-03 17:10:58','2021-10-03 17:10:58'),(2588,'default','edited',566,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"}}','2021-10-03 17:12:28','2021-10-03 17:12:28'),(2589,'default','edited',558,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"}}','2021-10-03 17:13:00','2021-10-03 17:13:00'),(2590,'default','edited',568,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"}}','2021-10-03 17:14:18','2021-10-03 17:14:18'),(2591,'default','edited',558,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"}}','2021-10-03 17:15:12','2021-10-03 17:15:12'),(2592,'default','edited',567,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"}}','2021-10-03 17:15:45','2021-10-03 17:15:45'),(2593,'default','added',570,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-03 17:17:43','2021-10-03 17:17:43'),(2594,'default','added',571,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-03 17:18:42','2021-10-03 17:18:42'),(2595,'default','added',572,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-03 17:20:51','2021-10-03 17:20:51'),(2596,'default','added',744,'App\\Contact',1,4,'App\\User','[]','2021-10-03 17:49:53','2021-10-03 17:49:53'),(2597,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-10-03 18:10:05','2021-10-03 18:10:05'),(2598,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-03 18:10:13','2021-10-03 18:10:13'),(2599,'default','added',745,'App\\Contact',1,4,'App\\User','[]','2021-10-03 18:11:24','2021-10-03 18:11:24'),(2600,'default','added',746,'App\\Contact',1,4,'App\\User','[]','2021-10-03 18:35:16','2021-10-03 18:35:16'),(2601,'default','added',747,'App\\Contact',1,11,'App\\User','[]','2021-10-03 18:36:44','2021-10-03 18:36:44'),(2602,'default','added',748,'App\\Contact',1,11,'App\\User','[]','2021-10-03 18:44:26','2021-10-03 18:44:26'),(2603,'default','added',749,'App\\Contact',1,4,'App\\User','[]','2021-10-03 18:50:43','2021-10-03 18:50:43'),(2604,'default','added',573,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-10-03 19:10:34','2021-10-03 19:10:34'),(2605,'default','added',574,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}','2021-10-03 19:12:49','2021-10-03 19:12:49'),(2606,'default','status_changed',726,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-03 19:13:04','2021-10-03 19:13:04'),(2607,'default','added',575,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-10-03 19:19:59','2021-10-03 19:19:59'),(2608,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-10-03 19:20:33','2021-10-03 19:20:33'),(2609,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-03 19:21:03','2021-10-03 19:21:03'),(2610,'default','status_changed',729,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-03 19:22:21','2021-10-03 19:22:21'),(2611,'default','status_changed',728,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":\"\\u0639\\u064a\\u0628 \\u0647\\u0627\\u0631\\u062f\\u0648\\u064a\\u0631 \\u0644\\u064a\\u0633 \\u0633\\u0648\\u0641\\u062a\",\"updated_status\":\"Repair in progress\"}','2021-10-03 19:30:52','2021-10-03 19:30:52'),(2612,'default','status_changed',728,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-03 19:31:00','2021-10-03 19:31:00'),(2613,'default','status_changed',694,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-03 19:33:06','2021-10-03 19:33:06'),(2614,'default','added',576,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}','2021-10-03 19:36:21','2021-10-03 19:36:21'),(2615,'default','status_changed',733,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-03 19:37:12','2021-10-03 19:37:12'),(2616,'default','added',577,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-10-03 20:06:22','2021-10-03 20:06:22'),(2617,'default','added',578,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-10-03 20:08:06','2021-10-03 20:08:06'),(2618,'default','status_changed',684,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-03 20:09:48','2021-10-03 20:09:48'),(2619,'default','added',579,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-10-03 20:12:47','2021-10-03 20:12:47'),(2620,'default','status_changed',462,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-03 20:14:06','2021-10-03 20:14:06'),(2621,'default','added',750,'App\\Contact',1,4,'App\\User','[]','2021-10-03 20:18:05','2021-10-03 20:18:05'),(2622,'default','added',751,'App\\Contact',1,4,'App\\User','[]','2021-10-03 20:41:36','2021-10-03 20:41:36'),(2623,'default','added',752,'App\\Contact',1,4,'App\\User','[]','2021-10-03 20:57:36','2021-10-03 20:57:36'),(2624,'default','added',580,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-03 21:09:59','2021-10-03 21:09:59'),(2625,'default','added',581,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-03 21:11:16','2021-10-03 21:11:16'),(2626,'default','added',582,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-03 21:12:31','2021-10-03 21:12:31'),(2627,'default','added',753,'App\\Contact',1,11,'App\\User','[]','2021-10-03 21:13:33','2021-10-03 21:13:33'),(2628,'default','added',583,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-03 21:13:46','2021-10-03 21:13:46'),(2629,'default','added',584,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-03 21:20:35','2021-10-03 21:20:35'),(2630,'default','added',585,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-03 21:39:16','2021-10-03 21:39:16'),(2631,'default','added',754,'App\\Contact',1,11,'App\\User','[]','2021-10-03 21:44:56','2021-10-03 21:44:56'),(2632,'default','added',586,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-10-03 22:00:40','2021-10-03 22:00:40'),(2633,'default','status_changed',725,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-03 22:00:58','2021-10-03 22:00:58'),(2634,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-10-04 13:02:39','2021-10-04 13:02:39'),(2635,'default','added',587,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-04 14:29:14','2021-10-04 14:29:14'),(2636,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-04 15:52:50','2021-10-04 15:52:50'),(2637,'default','payment_edited',562,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"700.0000\"}}','2021-10-04 15:56:21','2021-10-04 15:56:21'),(2638,'default','status_changed',707,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-04 15:56:50','2021-10-04 15:56:50'),(2639,'default','added',588,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":200}}','2021-10-04 16:01:31','2021-10-04 16:01:31'),(2640,'default','status_changed',393,'App\\Transaction',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-04 16:07:12','2021-10-04 16:07:12'),(2641,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-10-04 16:28:57','2021-10-04 16:28:57'),(2642,'default','added',755,'App\\Contact',1,20,'App\\User','[]','2021-10-04 16:30:13','2021-10-04 16:30:13'),(2643,'default','added',756,'App\\Contact',1,20,'App\\User','[]','2021-10-04 16:50:38','2021-10-04 16:50:38'),(2644,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-04 16:58:44','2021-10-04 16:58:44'),(2645,'default','status_changed',534,'App\\Transaction',1,1,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-04 17:02:41','2021-10-04 17:02:41'),(2646,'default','status_changed',533,'App\\Transaction',1,1,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-04 17:03:14','2021-10-04 17:03:14'),(2647,'default','status_changed',532,'App\\Transaction',1,1,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-04 17:03:25','2021-10-04 17:03:25'),(2648,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-04 17:19:58','2021-10-04 17:19:58'),(2649,'default','added',589,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-10-04 17:20:22','2021-10-04 17:20:22'),(2650,'default','status_changed',689,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-04 17:22:01','2021-10-04 17:22:01'),(2651,'default','added',590,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-04 17:22:23','2021-10-04 17:22:23'),(2652,'default','added',591,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-10-04 17:36:31','2021-10-04 17:36:31'),(2653,'default','status_changed',724,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-04 17:36:48','2021-10-04 17:36:48'),(2654,'default','added',592,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-10-04 17:38:11','2021-10-04 17:38:11'),(2655,'default','status_changed',732,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-04 17:38:32','2021-10-04 17:38:32'),(2656,'default','added',593,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":125}}','2021-10-04 17:57:05','2021-10-04 17:57:05'),(2657,'default','status_changed',717,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-04 18:00:01','2021-10-04 18:00:01'),(2658,'default','added',594,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-10-04 18:03:28','2021-10-04 18:03:28'),(2659,'default','status_changed',731,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-04 18:05:50','2021-10-04 18:05:50'),(2660,'default','status_changed',375,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-04 18:06:54','2021-10-04 18:06:54'),(2661,'default','added',757,'App\\Contact',1,20,'App\\User','[]','2021-10-04 18:18:57','2021-10-04 18:18:57'),(2662,'default','added',758,'App\\Contact',1,20,'App\\User','[]','2021-10-04 18:28:57','2021-10-04 18:28:57'),(2663,'default','status_changed',738,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-10-04 18:29:03','2021-10-04 18:29:03'),(2664,'default','added',595,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-10-04 18:33:59','2021-10-04 18:33:59'),(2665,'default','status_changed',453,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-04 18:46:21','2021-10-04 18:46:21'),(2666,'default','status_changed',741,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-04 18:46:38','2021-10-04 18:46:38'),(2667,'default','status_changed',739,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-04 18:46:47','2021-10-04 18:46:47'),(2668,'default','status_changed',737,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-04 18:46:55','2021-10-04 18:46:55'),(2669,'default','added',596,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-04 19:12:57','2021-10-04 19:12:57'),(2670,'default','added',597,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-04 19:16:34','2021-10-04 19:16:34'),(2671,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-04 19:31:07','2021-10-04 19:31:07'),(2672,'default','status_changed',686,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-04 19:36:37','2021-10-04 19:36:37'),(2673,'default','added',598,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-04 19:42:36','2021-10-04 19:42:36'),(2674,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-10-04 19:45:55','2021-10-04 19:45:55'),(2675,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-04 19:46:46','2021-10-04 19:46:46'),(2676,'default','added',599,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-10-04 20:17:12','2021-10-04 20:17:12'),(2677,'default','status_changed',721,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-04 20:19:52','2021-10-04 20:19:52'),(2678,'default','status_changed',722,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-04 20:20:11','2021-10-04 20:20:11'),(2679,'default','status_changed',741,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-04 20:20:38','2021-10-04 20:20:38'),(2680,'default','status_changed',577,'Modules\\Repair\\Entities\\JobSheet',1,1,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-04 20:22:51','2021-10-04 20:22:51'),(2681,'default','added',759,'App\\Contact',1,20,'App\\User','[]','2021-10-04 20:36:00','2021-10-04 20:36:00'),(2682,'default','added',760,'App\\Contact',1,20,'App\\User','[]','2021-10-04 20:51:19','2021-10-04 20:51:19'),(2683,'default','added',761,'App\\Contact',1,20,'App\\User','[]','2021-10-04 21:05:11','2021-10-04 21:05:11'),(2684,'default','added',762,'App\\Contact',1,20,'App\\User','[]','2021-10-04 21:08:31','2021-10-04 21:08:31'),(2685,'default','status_changed',745,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-04 21:16:41','2021-10-04 21:16:41'),(2686,'default','status_changed',746,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-04 21:16:52','2021-10-04 21:16:52'),(2687,'default','added',600,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-04 21:36:09','2021-10-04 21:36:09'),(2688,'default','added',601,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-04 21:36:50','2021-10-04 21:36:50'),(2689,'default','added',602,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-04 21:37:30','2021-10-04 21:37:30'),(2690,'default','status_changed',747,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-04 21:41:10','2021-10-04 21:41:10'),(2691,'default','added',603,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}','2021-10-04 21:42:07','2021-10-04 21:42:07'),(2692,'default','added',604,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":175}}','2021-10-04 21:46:50','2021-10-04 21:46:50'),(2693,'default','added',605,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-04 21:50:50','2021-10-04 21:50:50'),(2694,'default','status_changed',722,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-04 21:52:10','2021-10-04 21:52:10'),(2695,'default','added',606,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-10-04 22:02:41','2021-10-04 22:02:41'),(2696,'default','added',607,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-10-04 22:03:21','2021-10-04 22:03:21'),(2697,'default','added',608,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-10-04 22:05:43','2021-10-04 22:05:43'),(2698,'default','added',609,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-10-04 22:06:54','2021-10-04 22:06:54'),(2699,'default','status_changed',730,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-04 22:07:11','2021-10-04 22:07:11'),(2700,'default','edited',601,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"}}','2021-10-04 22:18:15','2021-10-04 22:18:15'),(2701,'default','added',610,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-04 22:19:53','2021-10-04 22:19:53'),(2702,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-05 12:21:20','2021-10-05 12:21:20'),(2703,'default','status_changed',743,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-05 12:36:02','2021-10-05 12:36:02'),(2704,'default','added',763,'App\\Contact',1,11,'App\\User','[]','2021-10-05 13:34:43','2021-10-05 13:34:43'),(2705,'default','added',764,'App\\Contact',1,11,'App\\User','[]','2021-10-05 13:35:41','2021-10-05 13:35:41'),(2706,'default','added',765,'App\\Contact',1,11,'App\\User','[]','2021-10-05 13:41:44','2021-10-05 13:41:44'),(2707,'default','added',766,'App\\Contact',1,11,'App\\User','[]','2021-10-05 13:42:35','2021-10-05 13:42:35'),(2708,'default','added',767,'App\\Contact',1,11,'App\\User','[]','2021-10-05 14:01:43','2021-10-05 14:01:43'),(2709,'default','added',768,'App\\Contact',1,11,'App\\User','[]','2021-10-05 14:06:50','2021-10-05 14:06:50'),(2710,'default','added',611,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1525}}','2021-10-05 14:16:33','2021-10-05 14:16:33'),(2711,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-05 14:51:11','2021-10-05 14:51:11'),(2712,'default','added',769,'App\\Contact',1,11,'App\\User','[]','2021-10-05 15:07:39','2021-10-05 15:07:39'),(2713,'default','added',770,'App\\Contact',1,11,'App\\User','[]','2021-10-05 15:19:35','2021-10-05 15:19:35'),(2714,'default','added',771,'App\\Contact',1,11,'App\\User','[]','2021-10-05 15:34:26','2021-10-05 15:34:26'),(2715,'default','added',772,'App\\Contact',1,11,'App\\User','[]','2021-10-05 15:41:54','2021-10-05 15:41:54'),(2716,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-05 15:51:28','2021-10-05 15:51:28'),(2717,'default','added',773,'App\\Contact',1,11,'App\\User','[]','2021-10-05 15:56:18','2021-10-05 15:56:18'),(2718,'default','added',612,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-10-05 15:58:01','2021-10-05 15:58:01'),(2719,'default','added',774,'App\\Contact',1,11,'App\\User','[]','2021-10-05 16:28:01','2021-10-05 16:28:01'),(2720,'default','added',775,'App\\Contact',1,11,'App\\User','[]','2021-10-05 16:29:51','2021-10-05 16:29:51'),(2721,'default','added',776,'App\\Contact',1,11,'App\\User','[]','2021-10-05 16:36:02','2021-10-05 16:36:02'),(2722,'default','status_changed',452,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-05 16:42:45','2021-10-05 16:42:45'),(2723,'default','status_changed',453,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-05 16:43:14','2021-10-05 16:43:14'),(2724,'default','added',777,'App\\Contact',1,11,'App\\User','[]','2021-10-05 16:45:38','2021-10-05 16:45:38'),(2725,'default','added',778,'App\\Contact',1,11,'App\\User','[]','2021-10-05 17:32:02','2021-10-05 17:32:02'),(2726,'default','added',613,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":475}}','2021-10-05 17:56:41','2021-10-05 17:56:41'),(2727,'default','added',779,'App\\Contact',1,11,'App\\User','[]','2021-10-05 18:19:22','2021-10-05 18:19:22'),(2728,'default','status_changed',666,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-05 18:33:56','2021-10-05 18:33:56'),(2729,'default','added',780,'App\\Contact',1,11,'App\\User','[]','2021-10-05 19:08:07','2021-10-05 19:08:07'),(2730,'default','added',781,'App\\Contact',1,11,'App\\User','[]','2021-10-05 19:27:09','2021-10-05 19:27:09'),(2731,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-05 19:28:40','2021-10-05 19:28:40'),(2732,'default','added',614,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-05 19:29:58','2021-10-05 19:29:58'),(2733,'default','added',615,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-05 19:31:03','2021-10-05 19:31:03'),(2734,'default','added',616,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-10-05 19:31:23','2021-10-05 19:31:23'),(2735,'default','status_changed',763,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-05 19:31:41','2021-10-05 19:31:41'),(2736,'default','added',617,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-05 19:32:02','2021-10-05 19:32:02'),(2737,'default','added',618,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-05 19:34:07','2021-10-05 19:34:07'),(2738,'default','added',619,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-05 19:39:00','2021-10-05 19:39:00'),(2739,'default','added',782,'App\\Contact',1,11,'App\\User','[]','2021-10-05 19:40:43','2021-10-05 19:40:43'),(2740,'default','added',783,'App\\Contact',1,11,'App\\User','[]','2021-10-05 19:45:06','2021-10-05 19:45:06'),(2741,'default','added',784,'App\\Contact',1,11,'App\\User','[]','2021-10-05 19:52:12','2021-10-05 19:52:12'),(2742,'default','added',785,'App\\Contact',1,11,'App\\User','[]','2021-10-05 20:07:43','2021-10-05 20:07:43'),(2743,'default','added',786,'App\\Contact',1,11,'App\\User','[]','2021-10-05 20:08:40','2021-10-05 20:08:40'),(2744,'default','added',787,'App\\Contact',1,11,'App\\User','[]','2021-10-05 20:10:11','2021-10-05 20:10:11'),(2745,'default','added',620,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-05 20:15:19','2021-10-05 20:15:19'),(2746,'default','added',621,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-05 20:16:09','2021-10-05 20:16:09'),(2747,'default','added',622,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-10-05 20:24:56','2021-10-05 20:24:56'),(2748,'default','status_changed',748,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-05 20:25:12','2021-10-05 20:25:12'),(2749,'default','added',623,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-10-05 20:25:52','2021-10-05 20:25:52'),(2750,'default','status_changed',754,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-05 20:26:15','2021-10-05 20:26:15'),(2751,'default','status_changed',701,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-05 20:26:58','2021-10-05 20:26:58'),(2752,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-05 20:42:39','2021-10-05 20:42:39'),(2753,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-05 20:42:53','2021-10-05 20:42:53'),(2754,'default','added',624,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-05 20:44:06','2021-10-05 20:44:06'),(2755,'default','added',625,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":100}}','2021-10-05 20:47:51','2021-10-05 20:47:51'),(2756,'default','status_changed',569,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-05 20:50:51','2021-10-05 20:50:51'),(2757,'default','added',788,'App\\Contact',1,4,'App\\User','[]','2021-10-05 20:52:01','2021-10-05 20:52:01'),(2758,'default','added',626,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-10-05 20:59:49','2021-10-05 20:59:49'),(2759,'default','added',627,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-10-05 21:00:37','2021-10-05 21:00:37'),(2760,'default','status_changed',750,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-05 21:01:06','2021-10-05 21:01:06'),(2761,'default','added',789,'App\\Contact',1,4,'App\\User','[]','2021-10-05 21:15:15','2021-10-05 21:15:15'),(2762,'default','added',790,'App\\Contact',1,4,'App\\User','[]','2021-10-05 21:49:14','2021-10-05 21:49:14'),(2763,'default','added',628,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-05 22:02:46','2021-10-05 22:02:46'),(2764,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-05 22:27:54','2021-10-05 22:27:54'),(2765,'default','added',791,'App\\Contact',1,4,'App\\User','[]','2021-10-05 22:35:15','2021-10-05 22:35:15'),(2766,'default','added',629,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-10-05 22:49:22','2021-10-05 22:49:22'),(2767,'default','status_changed',771,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-05 22:50:50','2021-10-05 22:50:50'),(2768,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-10-05 23:03:40','2021-10-05 23:03:40'),(2769,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-10-05 23:03:47','2021-10-05 23:03:47'),(2770,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-06 12:55:43','2021-10-06 12:55:43'),(2771,'default','added',792,'App\\Contact',1,11,'App\\User','[]','2021-10-06 13:04:58','2021-10-06 13:04:58'),(2772,'default','added',793,'App\\Contact',1,11,'App\\User','[]','2021-10-06 13:07:01','2021-10-06 13:07:01'),(2773,'default','added',794,'App\\Contact',1,11,'App\\User','[]','2021-10-06 13:14:40','2021-10-06 13:14:40'),(2774,'default','added',795,'App\\Contact',1,11,'App\\User','[]','2021-10-06 13:24:00','2021-10-06 13:24:00'),(2775,'default','added',796,'App\\Contact',1,11,'App\\User','[]','2021-10-06 13:37:30','2021-10-06 13:37:30'),(2776,'default','added',797,'App\\Contact',1,11,'App\\User','[]','2021-10-06 13:48:19','2021-10-06 13:48:19'),(2777,'default','added',630,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-10-06 14:05:19','2021-10-06 14:05:19'),(2778,'default','added',631,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-10-06 14:09:10','2021-10-06 14:09:10'),(2779,'default','status_changed',772,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-06 14:09:52','2021-10-06 14:09:52'),(2780,'default','added',798,'App\\Contact',1,11,'App\\User','[]','2021-10-06 14:15:28','2021-10-06 14:15:28'),(2781,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-06 14:22:07','2021-10-06 14:22:07'),(2782,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-06 14:40:05','2021-10-06 14:40:05'),(2783,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-06 14:40:14','2021-10-06 14:40:14'),(2784,'default','added',632,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-10-06 14:45:52','2021-10-06 14:45:52'),(2785,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-10-06 14:50:10','2021-10-06 14:50:10'),(2786,'default','added',633,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":200}}','2021-10-06 14:51:31','2021-10-06 14:51:31'),(2787,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-06 15:08:53','2021-10-06 15:08:53'),(2788,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-10-06 15:11:15','2021-10-06 15:11:15'),(2789,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-06 15:12:59','2021-10-06 15:12:59'),(2790,'default','added',634,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-10-06 15:23:04','2021-10-06 15:23:04'),(2791,'default','status_changed',752,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-06 15:23:32','2021-10-06 15:23:32'),(2792,'default','added',635,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-06 15:30:49','2021-10-06 15:30:49'),(2793,'default','edited',635,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"}}','2021-10-06 15:31:33','2021-10-06 15:31:33'),(2794,'default','added',636,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-06 15:40:34','2021-10-06 15:40:34'),(2795,'default','added',637,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-06 15:42:30','2021-10-06 15:42:30'),(2796,'default','added',638,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-06 15:47:17','2021-10-06 15:47:17'),(2797,'default','added',639,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-06 15:57:58','2021-10-06 15:57:58'),(2798,'default','added',640,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-06 16:01:55','2021-10-06 16:01:55'),(2799,'default','added',641,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-06 16:03:46','2021-10-06 16:03:46'),(2800,'default','added',642,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-06 16:08:43','2021-10-06 16:08:43'),(2801,'default','status_changed',773,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-06 16:11:20','2021-10-06 16:11:20'),(2802,'default','status_changed',755,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-10-06 16:15:09','2021-10-06 16:15:09'),(2803,'default','status_changed',778,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-06 16:19:08','2021-10-06 16:19:08'),(2804,'default','added',643,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":175}}','2021-10-06 16:27:03','2021-10-06 16:27:03'),(2805,'default','status_changed',773,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-06 16:27:18','2021-10-06 16:27:18'),(2806,'default','added',799,'App\\Contact',1,4,'App\\User','[]','2021-10-06 16:30:02','2021-10-06 16:30:02'),(2807,'default','status_changed',727,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-06 16:49:26','2021-10-06 16:49:26'),(2808,'default','status_changed',758,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-06 16:49:41','2021-10-06 16:49:41'),(2809,'default','added',644,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-06 16:59:19','2021-10-06 16:59:19'),(2810,'default','status_changed',777,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-06 17:23:59','2021-10-06 17:23:59'),(2811,'default','status_changed',757,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-06 17:24:44','2021-10-06 17:24:44'),(2812,'default','status_changed',776,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-06 17:25:04','2021-10-06 17:25:04'),(2813,'default','status_changed',769,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-06 17:26:40','2021-10-06 17:26:40'),(2814,'default','status_changed',757,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-06 17:27:09','2021-10-06 17:27:09'),(2815,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-06 17:52:13','2021-10-06 17:52:13'),(2816,'default','added',645,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-10-06 18:43:31','2021-10-06 18:43:31'),(2817,'default','status_changed',698,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-06 18:43:52','2021-10-06 18:43:52'),(2818,'default','added',800,'App\\Contact',1,4,'App\\User','[]','2021-10-06 18:45:53','2021-10-06 18:45:53'),(2819,'default','added',646,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-10-06 19:00:43','2021-10-06 19:00:43'),(2820,'default','status_changed',751,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-06 19:01:03','2021-10-06 19:01:03'),(2821,'default','added',647,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-06 19:04:29','2021-10-06 19:04:29'),(2822,'default','added',648,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-06 19:05:08','2021-10-06 19:05:08'),(2823,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-10-06 19:05:22','2021-10-06 19:05:22'),(2824,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-06 19:16:27','2021-10-06 19:16:27'),(2825,'default','added',801,'App\\Contact',1,11,'App\\User','[]','2021-10-06 19:31:40','2021-10-06 19:31:40'),(2826,'default','added',802,'App\\Contact',1,11,'App\\User','[]','2021-10-06 19:38:07','2021-10-06 19:38:07'),(2827,'default','added',649,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}','2021-10-06 19:50:37','2021-10-06 19:50:37'),(2828,'default','status_changed',287,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-06 19:50:52','2021-10-06 19:50:52'),(2829,'default','added',650,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}','2021-10-06 19:51:24','2021-10-06 19:51:24'),(2830,'default','status_changed',727,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-06 19:51:42','2021-10-06 19:51:42'),(2831,'default','added',651,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-10-06 19:55:09','2021-10-06 19:55:09'),(2832,'default','status_changed',734,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-06 19:55:23','2021-10-06 19:55:23'),(2833,'default','added',803,'App\\Contact',1,11,'App\\User','[]','2021-10-06 20:00:19','2021-10-06 20:00:19'),(2834,'default','added',652,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":160}}','2021-10-06 20:10:43','2021-10-06 20:10:43'),(2835,'default','status_changed',778,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-06 20:21:35','2021-10-06 20:21:35'),(2836,'default','status_changed',781,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-06 20:30:28','2021-10-06 20:30:28'),(2837,'default','status_changed',782,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-06 20:30:44','2021-10-06 20:30:44'),(2838,'default','status_changed',783,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-06 20:31:00','2021-10-06 20:31:00'),(2839,'default','added',804,'App\\Contact',1,11,'App\\User','[]','2021-10-06 20:31:36','2021-10-06 20:31:36'),(2840,'default','added',805,'App\\Contact',1,11,'App\\User','[]','2021-10-06 20:37:58','2021-10-06 20:37:58'),(2841,'default','status_changed',758,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-10-06 20:40:44','2021-10-06 20:40:44'),(2842,'default','status_changed',767,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-06 20:54:24','2021-10-06 20:54:24'),(2843,'default','status_changed',768,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-06 20:54:50','2021-10-06 20:54:50'),(2844,'default','added',806,'App\\Contact',1,11,'App\\User','[]','2021-10-06 20:58:46','2021-10-06 20:58:46'),(2845,'default','added',807,'App\\Contact',1,11,'App\\User','[]','2021-10-06 21:19:05','2021-10-06 21:19:05'),(2846,'default','added',808,'App\\Contact',1,11,'App\\User','[]','2021-10-06 21:31:19','2021-10-06 21:31:19'),(2847,'default','logout',20,'App\\User',1,20,'App\\User','[]','2021-10-06 21:33:26','2021-10-06 21:33:26'),(2848,'default','added',653,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2100}}','2021-10-06 21:39:30','2021-10-06 21:39:30'),(2849,'default','added',654,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-10-06 21:40:43','2021-10-06 21:40:43'),(2850,'default','status_changed',761,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-06 21:41:00','2021-10-06 21:41:00'),(2851,'default','added',655,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":350}}','2021-10-06 21:48:14','2021-10-06 21:48:14'),(2852,'default','added',656,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-06 21:53:07','2021-10-06 21:53:07'),(2853,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-06 21:53:36','2021-10-06 21:53:36'),(2854,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-06 21:53:42','2021-10-06 21:53:42'),(2855,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-06 21:56:55','2021-10-06 21:56:55'),(2856,'default','added',657,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-06 21:59:23','2021-10-06 21:59:23'),(2857,'default','added',809,'App\\Contact',1,11,'App\\User','[]','2021-10-06 21:59:52','2021-10-06 21:59:52'),(2858,'default','added',658,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-10-06 22:01:04','2021-10-06 22:01:04'),(2859,'default','status_changed',790,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-06 22:01:38','2021-10-06 22:01:38'),(2860,'default','added',659,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-06 22:13:30','2021-10-06 22:13:30'),(2861,'default','added',810,'App\\Contact',1,4,'App\\User','[]','2021-10-06 22:55:54','2021-10-06 22:55:54'),(2862,'default','status_changed',775,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-06 22:59:24','2021-10-06 22:59:24'),(2863,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-10-06 23:14:49','2021-10-06 23:14:49'),(2864,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-07 12:34:40','2021-10-07 12:34:40'),(2865,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-10-07 12:34:49','2021-10-07 12:34:49'),(2866,'default','added',660,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-10-07 13:47:47','2021-10-07 13:47:47'),(2867,'default','status_changed',776,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-07 13:48:19','2021-10-07 13:48:19'),(2868,'default','added',811,'App\\Contact',1,20,'App\\User','[]','2021-10-07 14:35:50','2021-10-07 14:35:50'),(2869,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-10-07 14:36:30','2021-10-07 14:36:30'),(2870,'default','status_changed',697,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-07 14:44:37','2021-10-07 14:44:37'),(2871,'default','logout',20,'App\\User',1,20,'App\\User','[]','2021-10-07 14:44:43','2021-10-07 14:44:43'),(2872,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-07 14:44:54','2021-10-07 14:44:54'),(2873,'default','added',812,'App\\Contact',1,4,'App\\User','[]','2021-10-07 15:01:43','2021-10-07 15:01:43'),(2874,'default','added',661,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-10-07 15:21:35','2021-10-07 15:21:35'),(2875,'default','status_changed',781,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-07 15:21:49','2021-10-07 15:21:49'),(2876,'default','added',662,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-07 15:26:31','2021-10-07 15:26:31'),(2877,'default','added',663,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-07 15:27:18','2021-10-07 15:27:18'),(2878,'default','added',813,'App\\Contact',1,4,'App\\User','[]','2021-10-07 15:28:32','2021-10-07 15:28:32'),(2879,'default','added',814,'App\\Contact',1,4,'App\\User','[]','2021-10-07 16:31:53','2021-10-07 16:31:53'),(2880,'default','added',664,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-10-07 16:37:49','2021-10-07 16:37:49'),(2881,'default','added',665,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-10-07 16:56:12','2021-10-07 16:56:12'),(2882,'default','status_changed',760,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-07 16:56:30','2021-10-07 16:56:30'),(2883,'default','added',815,'App\\Contact',1,4,'App\\User','[]','2021-10-07 17:12:43','2021-10-07 17:12:43'),(2884,'default','added',816,'App\\Contact',1,4,'App\\User','[]','2021-10-07 17:32:42','2021-10-07 17:32:42'),(2885,'default','added',817,'App\\Contact',1,4,'App\\User','[]','2021-10-07 18:21:56','2021-10-07 18:21:56'),(2886,'default','added',818,'App\\Contact',1,4,'App\\User','[]','2021-10-07 18:52:48','2021-10-07 18:52:48'),(2887,'default','added',666,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-10-07 18:54:52','2021-10-07 18:54:52'),(2888,'default','added',819,'App\\Contact',1,4,'App\\User','[]','2021-10-07 18:55:49','2021-10-07 18:55:49'),(2889,'default','added',820,'App\\Contact',1,11,'App\\User','[]','2021-10-07 18:56:56','2021-10-07 18:56:56'),(2890,'default','added',821,'App\\Contact',1,4,'App\\User','[]','2021-10-07 18:57:13','2021-10-07 18:57:13'),(2891,'default','added',822,'App\\Contact',1,4,'App\\User','[]','2021-10-07 18:57:13','2021-10-07 18:57:13'),(2892,'default','added',667,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":300}}','2021-10-07 19:04:59','2021-10-07 19:04:59'),(2893,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-07 19:06:57','2021-10-07 19:06:57'),(2894,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-07 19:07:37','2021-10-07 19:07:37'),(2895,'default','added',668,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-10-07 19:17:00','2021-10-07 19:17:00'),(2896,'default','added',669,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":375}}','2021-10-07 19:17:11','2021-10-07 19:17:11'),(2897,'default','added',670,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-10-07 19:17:40','2021-10-07 19:17:40'),(2898,'default','status_changed',764,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-07 19:18:07','2021-10-07 19:18:07'),(2899,'default','added',671,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}','2021-10-07 19:18:30','2021-10-07 19:18:30'),(2900,'default','status_changed',782,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-07 19:18:39','2021-10-07 19:18:39'),(2901,'default','status_changed',765,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-07 19:19:07','2021-10-07 19:19:07'),(2902,'default','added',672,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}','2021-10-07 19:19:16','2021-10-07 19:19:16'),(2903,'default','status_changed',604,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-07 19:19:33','2021-10-07 19:19:33'),(2904,'default','added',823,'App\\Contact',1,4,'App\\User','[]','2021-10-07 19:46:24','2021-10-07 19:46:24'),(2905,'default','added',824,'App\\Contact',1,4,'App\\User','[]','2021-10-07 19:47:00','2021-10-07 19:47:00'),(2906,'default','added',673,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-10-07 20:15:25','2021-10-07 20:15:25'),(2907,'default','status_changed',786,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-07 20:16:44','2021-10-07 20:16:44'),(2908,'default','added',674,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-10-07 20:19:02','2021-10-07 20:19:02'),(2909,'default','status_changed',798,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-07 20:29:50','2021-10-07 20:29:50'),(2910,'default','status_changed',802,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-07 20:29:58','2021-10-07 20:29:58'),(2911,'default','status_changed',784,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-07 20:30:07','2021-10-07 20:30:07'),(2912,'default','status_changed',783,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-07 20:30:56','2021-10-07 20:30:56'),(2913,'default','status_changed',783,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-07 20:31:02','2021-10-07 20:31:02'),(2914,'default','status_changed',769,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-07 20:31:54','2021-10-07 20:31:54'),(2915,'default','logout',20,'App\\User',1,20,'App\\User','[]','2021-10-07 20:35:02','2021-10-07 20:35:02'),(2916,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-07 20:35:10','2021-10-07 20:35:10'),(2917,'default','added',675,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-10-07 20:39:10','2021-10-07 20:39:10'),(2918,'default','added',676,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":850}}','2021-10-07 20:44:05','2021-10-07 20:44:05'),(2919,'default','status_changed',797,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-07 20:49:19','2021-10-07 20:49:19'),(2920,'default','status_changed',759,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-07 20:50:11','2021-10-07 20:50:11'),(2921,'default','status_changed',788,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-07 20:50:30','2021-10-07 20:50:30'),(2922,'default','added',677,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-10-07 20:52:36','2021-10-07 20:52:36'),(2923,'default','status_changed',800,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-07 20:53:06','2021-10-07 20:53:06'),(2924,'default','added',678,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-10-07 20:53:54','2021-10-07 20:53:54'),(2925,'default','status_changed',795,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-07 20:54:35','2021-10-07 20:54:35'),(2926,'default','added',679,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-07 21:00:17','2021-10-07 21:00:17'),(2927,'default','added',680,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-07 21:01:50','2021-10-07 21:01:50'),(2928,'default','added',681,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-07 21:02:16','2021-10-07 21:02:16'),(2929,'default','added',682,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-10-07 21:10:22','2021-10-07 21:10:22'),(2930,'default','status_changed',793,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-07 21:10:40','2021-10-07 21:10:40'),(2931,'default','added',825,'App\\Contact',1,4,'App\\User','[]','2021-10-07 21:57:05','2021-10-07 21:57:05'),(2932,'default','added',683,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-10-07 22:09:29','2021-10-07 22:09:29'),(2933,'default','status_changed',749,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-07 22:10:01','2021-10-07 22:10:01'),(2934,'default','added',684,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-10-07 22:10:56','2021-10-07 22:10:56'),(2935,'default','status_changed',758,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-07 22:11:31','2021-10-07 22:11:31'),(2936,'default','added',685,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-10-07 22:12:15','2021-10-07 22:12:15'),(2937,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-07 22:17:18','2021-10-07 22:17:18'),(2938,'default','added',686,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-07 22:19:16','2021-10-07 22:19:16'),(2939,'default','added',826,'App\\Contact',1,4,'App\\User','[]','2021-10-07 22:32:37','2021-10-07 22:32:37'),(2940,'default','added',827,'App\\Contact',1,4,'App\\User','[]','2021-10-07 22:35:21','2021-10-07 22:35:21'),(2941,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-08 01:03:05','2021-10-08 01:03:05'),(2942,'default','login',19,'App\\User',1,19,'App\\User','[]','2021-10-08 01:56:12','2021-10-08 01:56:12'),(2943,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-10-08 14:11:34','2021-10-08 14:11:34'),(2944,'default','added',828,'App\\Contact',1,20,'App\\User','[]','2021-10-08 14:46:13','2021-10-08 14:46:13'),(2945,'default','added',829,'App\\Contact',1,20,'App\\User','[]','2021-10-08 14:49:04','2021-10-08 14:49:04'),(2946,'default','added',830,'App\\Contact',1,20,'App\\User','[]','2021-10-08 15:33:58','2021-10-08 15:33:58'),(2947,'default','added',831,'App\\Contact',1,20,'App\\User','[]','2021-10-08 16:46:40','2021-10-08 16:46:40'),(2948,'default','added',832,'App\\Contact',1,20,'App\\User','[]','2021-10-08 17:08:49','2021-10-08 17:08:49'),(2949,'default','added',833,'App\\Contact',1,20,'App\\User','[]','2021-10-08 17:23:37','2021-10-08 17:23:37'),(2950,'default','added',834,'App\\Contact',1,20,'App\\User','[]','2021-10-08 17:29:32','2021-10-08 17:29:32'),(2951,'default','status_changed',263,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-08 17:57:47','2021-10-08 17:57:47'),(2952,'default','added',835,'App\\Contact',1,20,'App\\User','[]','2021-10-08 18:39:51','2021-10-08 18:39:51'),(2953,'default','added',836,'App\\Contact',1,20,'App\\User','[]','2021-10-08 18:47:42','2021-10-08 18:47:42'),(2954,'default','added',837,'App\\Contact',1,20,'App\\User','[]','2021-10-08 20:16:14','2021-10-08 20:16:14'),(2955,'default','added',838,'App\\Contact',1,20,'App\\User','[]','2021-10-08 20:48:32','2021-10-08 20:48:32'),(2956,'default','added',839,'App\\Contact',1,20,'App\\User','[]','2021-10-08 21:25:38','2021-10-08 21:25:38'),(2957,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-08 22:35:43','2021-10-08 22:35:43'),(2958,'default','edited',652,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":175},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"160.0000\"}}','2021-10-08 22:39:50','2021-10-08 22:39:50'),(2959,'default','edited',652,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":175},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"175.0000\"}}','2021-10-08 22:41:03','2021-10-08 22:41:03'),(2960,'default','payment_edited',652,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"175.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"175.0000\"}}','2021-10-08 22:41:42','2021-10-08 22:41:42'),(2961,'default','added',687,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":600}}','2021-10-08 22:43:05','2021-10-08 22:43:05'),(2962,'default','added',688,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":500}}','2021-10-08 22:44:19','2021-10-08 22:44:19'),(2963,'default','added',689,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-10-08 22:47:02','2021-10-08 22:47:02'),(2964,'default','added',690,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-08 22:47:48','2021-10-08 22:47:48'),(2965,'default','added',691,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-08 22:48:18','2021-10-08 22:48:18'),(2966,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-09 13:02:11','2021-10-09 13:02:11'),(2967,'default','added',840,'App\\Contact',1,11,'App\\User','[]','2021-10-09 13:31:58','2021-10-09 13:31:58'),(2968,'default','added',841,'App\\Contact',1,11,'App\\User','[]','2021-10-09 13:44:16','2021-10-09 13:44:16'),(2969,'default','added',842,'App\\Contact',1,11,'App\\User','[]','2021-10-09 14:17:27','2021-10-09 14:17:27'),(2970,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-10-09 14:22:46','2021-10-09 14:22:46'),(2971,'default','added',692,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-10-09 14:48:18','2021-10-09 14:48:18'),(2972,'default','status_changed',818,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-09 14:53:25','2021-10-09 14:53:25'),(2973,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-09 15:04:34','2021-10-09 15:04:34'),(2974,'default','edited',563,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":750},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"700.0000\"}}','2021-10-09 15:07:26','2021-10-09 15:07:26'),(2975,'default','status_changed',563,'App\\Transaction',1,1,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-09 15:09:32','2021-10-09 15:09:32'),(2976,'default','payment_edited',563,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"750.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"750.0000\"}}','2021-10-09 15:09:49','2021-10-09 15:09:49'),(2977,'default','logout',20,'App\\User',1,20,'App\\User','[]','2021-10-09 15:12:48','2021-10-09 15:12:48'),(2978,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-09 15:12:55','2021-10-09 15:12:55'),(2979,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-09 15:24:34','2021-10-09 15:24:34'),(2980,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-09 15:24:50','2021-10-09 15:24:50'),(2981,'default','added',693,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}','2021-10-09 15:41:36','2021-10-09 15:41:36'),(2982,'default','status_changed',792,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-09 15:42:08','2021-10-09 15:42:08'),(2983,'default','added',843,'App\\Contact',1,4,'App\\User','[]','2021-10-09 15:43:00','2021-10-09 15:43:00'),(2984,'default','added',694,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-09 16:04:48','2021-10-09 16:04:48'),(2985,'default','added',695,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-09 16:05:20','2021-10-09 16:05:20'),(2986,'default','added',696,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-10-09 16:11:54','2021-10-09 16:11:54'),(2987,'default','status_changed',809,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-09 16:12:25','2021-10-09 16:12:25'),(2988,'default','edited',676,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"850.0000\"}}','2021-10-09 16:39:29','2021-10-09 16:39:29'),(2989,'default','added',844,'App\\Contact',1,4,'App\\User','[]','2021-10-09 16:40:11','2021-10-09 16:40:11'),(2990,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-10-09 16:41:57','2021-10-09 16:41:57'),(2991,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-10-09 16:42:06','2021-10-09 16:42:06'),(2992,'default','added',845,'App\\Contact',1,4,'App\\User','[]','2021-10-09 16:53:05','2021-10-09 16:53:05'),(2993,'default','added',846,'App\\Contact',1,4,'App\\User','[]','2021-10-09 16:57:45','2021-10-09 16:57:45'),(2994,'default','status_changed',810,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-09 17:04:21','2021-10-09 17:04:21'),(2995,'default','status_changed',804,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-09 17:04:28','2021-10-09 17:04:28'),(2996,'default','status_changed',812,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-09 17:04:54','2021-10-09 17:04:54'),(2997,'default','status_changed',815,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-09 17:05:00','2021-10-09 17:05:00'),(2998,'default','added',847,'App\\Contact',1,4,'App\\User','[]','2021-10-09 17:16:10','2021-10-09 17:16:10'),(2999,'default','added',848,'App\\Contact',1,4,'App\\User','[]','2021-10-09 17:31:14','2021-10-09 17:31:14'),(3000,'default','added',697,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-10-09 17:36:58','2021-10-09 17:36:58'),(3001,'default','status_changed',762,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-09 17:37:26','2021-10-09 17:37:26'),(3002,'default','status_changed',806,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-09 17:38:06','2021-10-09 17:38:06'),(3003,'default','added',849,'App\\Contact',1,20,'App\\User','[]','2021-10-09 17:39:38','2021-10-09 17:39:38'),(3004,'default','added',698,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-10-09 18:01:07','2021-10-09 18:01:07'),(3005,'default','status_changed',785,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-10-09 18:01:43','2021-10-09 18:01:43'),(3006,'default','status_changed',785,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-09 18:01:52','2021-10-09 18:01:52'),(3007,'default','added',850,'App\\Contact',1,20,'App\\User','[]','2021-10-09 18:05:47','2021-10-09 18:05:47'),(3008,'default','added',851,'App\\Contact',1,20,'App\\User','[]','2021-10-09 18:10:13','2021-10-09 18:10:13'),(3009,'default','added',852,'App\\Contact',1,20,'App\\User','[]','2021-10-09 18:11:24','2021-10-09 18:11:24'),(3010,'default','added',699,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-10-09 18:13:00','2021-10-09 18:13:00'),(3011,'default','status_changed',697,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-09 18:13:14','2021-10-09 18:13:14'),(3012,'default','added',853,'App\\Contact',1,4,'App\\User','[]','2021-10-09 18:27:30','2021-10-09 18:27:30'),(3013,'default','added',854,'App\\Contact',1,20,'App\\User','[]','2021-10-09 18:32:17','2021-10-09 18:32:17'),(3014,'default','added',855,'App\\Contact',1,4,'App\\User','[]','2021-10-09 18:36:08','2021-10-09 18:36:08'),(3015,'default','added',856,'App\\Contact',1,20,'App\\User','[]','2021-10-09 18:44:40','2021-10-09 18:44:40'),(3016,'default','added',700,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}','2021-10-09 19:12:54','2021-10-09 19:12:54'),(3017,'default','status_changed',789,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-09 19:13:31','2021-10-09 19:13:31'),(3018,'default','added',857,'App\\Contact',1,4,'App\\User','[]','2021-10-09 19:19:45','2021-10-09 19:19:45'),(3019,'default','added',858,'App\\Contact',1,4,'App\\User','[]','2021-10-09 19:31:54','2021-10-09 19:31:54'),(3020,'default','added',859,'App\\Contact',1,20,'App\\User','[]','2021-10-09 19:32:47','2021-10-09 19:32:47'),(3021,'default','added',701,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-10-09 19:37:59','2021-10-09 19:37:59'),(3022,'default','status_changed',830,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-09 19:38:14','2021-10-09 19:38:14'),(3023,'default','added',702,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-10-09 19:39:29','2021-10-09 19:39:29'),(3024,'default','status_changed',811,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-09 19:39:55','2021-10-09 19:39:55'),(3025,'default','added',703,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-10-09 19:49:15','2021-10-09 19:49:15'),(3026,'default','status_changed',783,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-09 19:49:31','2021-10-09 19:49:31'),(3027,'default','added',704,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-10-09 20:01:40','2021-10-09 20:01:40'),(3028,'default','status_changed',805,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-09 20:01:55','2021-10-09 20:01:55'),(3029,'default','status_changed',695,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-10-09 20:29:59','2021-10-09 20:29:59'),(3030,'default','added',705,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-09 20:37:32','2021-10-09 20:37:32'),(3031,'default','added',706,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-09 20:39:38','2021-10-09 20:39:38'),(3032,'default','added',860,'App\\Contact',1,4,'App\\User','[]','2021-10-09 20:41:59','2021-10-09 20:41:59'),(3033,'default','added',861,'App\\Contact',1,4,'App\\User','[]','2021-10-09 20:53:19','2021-10-09 20:53:19'),(3034,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-09 20:54:05','2021-10-09 20:54:05'),(3035,'default','added',862,'App\\Contact',1,4,'App\\User','[]','2021-10-09 21:04:57','2021-10-09 21:04:57'),(3036,'default','added',863,'App\\Contact',1,4,'App\\User','[]','2021-10-09 21:16:21','2021-10-09 21:16:21'),(3037,'default','added',707,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-10-09 21:26:23','2021-10-09 21:26:23'),(3038,'default','status_changed',804,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-09 21:26:52','2021-10-09 21:26:52'),(3039,'default','added',708,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-10-09 21:27:43','2021-10-09 21:27:43'),(3040,'default','status_changed',810,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-09 21:28:01','2021-10-09 21:28:01'),(3041,'default','added',709,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-09 21:36:38','2021-10-09 21:36:38'),(3042,'default','added',710,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-09 21:45:14','2021-10-09 21:45:14'),(3043,'default','status_changed',826,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-09 21:50:20','2021-10-09 21:50:20'),(3044,'default','added',711,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-09 22:13:23','2021-10-09 22:13:23'),(3045,'default','added',712,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-09 22:13:58','2021-10-09 22:13:58'),(3046,'default','added',864,'App\\Contact',1,4,'App\\User','[]','2021-10-09 22:18:56','2021-10-09 22:18:56'),(3047,'default','added',713,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-10-09 22:29:35','2021-10-09 22:29:35'),(3048,'default','status_changed',834,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-09 22:30:42','2021-10-09 22:30:42'),(3049,'default','added',714,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-10-09 22:38:10','2021-10-09 22:38:10'),(3050,'default','added',715,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-10-09 22:39:07','2021-10-09 22:39:07'),(3051,'default','added',716,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-10-09 22:41:55','2021-10-09 22:41:55'),(3052,'default','status_changed',825,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-09 22:42:14','2021-10-09 22:42:14'),(3053,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-09 22:42:20','2021-10-09 22:42:20'),(3054,'default','added',717,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-09 22:45:06','2021-10-09 22:45:06'),(3055,'default','added',718,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}','2021-10-09 23:08:01','2021-10-09 23:08:01'),(3056,'default','added',719,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}','2021-10-09 23:28:05','2021-10-09 23:28:05'),(3057,'default','status_changed',839,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-09 23:28:22','2021-10-09 23:28:22'),(3058,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-10-09 23:38:49','2021-10-09 23:38:49'),(3059,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-10 12:39:39','2021-10-10 12:39:39'),(3060,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-10 12:49:43','2021-10-10 12:49:43'),(3061,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-10 12:57:34','2021-10-10 12:57:34'),(3062,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-10 13:00:14','2021-10-10 13:00:14'),(3063,'default','added',865,'App\\Contact',1,11,'App\\User','[]','2021-10-10 13:10:10','2021-10-10 13:10:10'),(3064,'default','added',866,'App\\Contact',1,11,'App\\User','[]','2021-10-10 14:44:52','2021-10-10 14:44:52'),(3065,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-10 14:55:50','2021-10-10 14:55:50'),(3066,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-10 14:56:03','2021-10-10 14:56:03'),(3067,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-10 15:46:44','2021-10-10 15:46:44'),(3068,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-10-10 15:52:09','2021-10-10 15:52:09'),(3069,'default','added',720,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-10-10 16:04:02','2021-10-10 16:04:02'),(3070,'default','status_changed',822,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-10 16:05:03','2021-10-10 16:05:03'),(3071,'default','added',721,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-10 16:15:09','2021-10-10 16:15:09'),(3072,'default','added',867,'App\\Contact',1,4,'App\\User','[]','2021-10-10 16:33:18','2021-10-10 16:33:18'),(3073,'default','added',868,'App\\Contact',1,4,'App\\User','[]','2021-10-10 16:48:54','2021-10-10 16:48:54'),(3074,'default','added',722,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-10-10 16:59:31','2021-10-10 16:59:31'),(3075,'default','added',723,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-10-10 17:08:29','2021-10-10 17:08:29'),(3076,'default','status_changed',823,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-10 17:08:49','2021-10-10 17:08:49'),(3077,'default','added',724,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-10-10 17:41:39','2021-10-10 17:41:39'),(3078,'default','status_changed',827,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-10 17:41:55','2021-10-10 17:41:55'),(3079,'default','added',725,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-10-10 18:03:33','2021-10-10 18:03:33'),(3080,'default','added',869,'App\\Contact',1,20,'App\\User','[]','2021-10-10 18:57:34','2021-10-10 18:57:34'),(3081,'default','status_changed',815,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-10 19:00:53','2021-10-10 19:00:53'),(3082,'default','status_changed',828,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-10 19:10:45','2021-10-10 19:10:45'),(3083,'default','added',726,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-10-10 19:11:18','2021-10-10 19:11:18'),(3084,'default','status_changed',829,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-10 19:22:32','2021-10-10 19:22:32'),(3085,'default','status_changed',832,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-10 19:25:46','2021-10-10 19:25:46'),(3086,'default','added',727,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-10 19:36:57','2021-10-10 19:36:57'),(3087,'default','added',728,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-10 19:38:09','2021-10-10 19:38:09'),(3088,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-10 19:53:41','2021-10-10 19:53:41'),(3089,'default','edited',689,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"100.0000\"}}','2021-10-10 19:55:28','2021-10-10 19:55:28'),(3090,'default','status_changed',689,'App\\Transaction',1,1,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-10 19:55:45','2021-10-10 19:55:45'),(3091,'default','edited',652,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"175.0000\"}}','2021-10-10 19:56:54','2021-10-10 19:56:54'),(3092,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-10-10 19:58:22','2021-10-10 19:58:22'),(3093,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-10 19:58:28','2021-10-10 19:58:28'),(3094,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-10-10 19:59:17','2021-10-10 19:59:17'),(3095,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-10 19:59:27','2021-10-10 19:59:27'),(3096,'default','payment_edited',687,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"600.0000\"}}','2021-10-10 20:00:00','2021-10-10 20:00:00'),(3097,'default','added',729,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-10 20:03:34','2021-10-10 20:03:34'),(3098,'default','added',730,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":850}}','2021-10-10 20:10:08','2021-10-10 20:10:08'),(3099,'default','status_changed',812,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-10 20:25:18','2021-10-10 20:25:18'),(3100,'default','added',731,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-10 20:28:18','2021-10-10 20:28:18'),(3101,'default','status_changed',678,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-10-10 20:37:51','2021-10-10 20:37:51'),(3102,'default','added',870,'App\\Contact',1,4,'App\\User','[]','2021-10-10 20:39:42','2021-10-10 20:39:42'),(3103,'default','added',732,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":6000}}','2021-10-10 20:56:21','2021-10-10 20:56:21'),(3104,'default','added',733,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}','2021-10-10 21:15:59','2021-10-10 21:15:59'),(3105,'default','status_changed',845,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-10 21:16:23','2021-10-10 21:16:23'),(3106,'default','added',734,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-10-10 21:22:38','2021-10-10 21:22:38'),(3107,'default','status_changed',842,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-10 21:22:55','2021-10-10 21:22:55'),(3108,'default','status_changed',785,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-10-10 21:37:47','2021-10-10 21:37:47'),(3109,'default','added',735,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-10 21:40:07','2021-10-10 21:40:07'),(3110,'default','logout',20,'App\\User',1,20,'App\\User','[]','2021-10-10 21:52:18','2021-10-10 21:52:18'),(3111,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-10 21:52:25','2021-10-10 21:52:25'),(3112,'default','added',871,'App\\Contact',1,4,'App\\User','[]','2021-10-10 21:52:54','2021-10-10 21:52:54'),(3113,'default','added',736,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}','2021-10-10 21:59:12','2021-10-10 21:59:12'),(3114,'default','added',737,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}','2021-10-10 21:59:37','2021-10-10 21:59:37'),(3115,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-10 21:59:48','2021-10-10 21:59:48'),(3116,'default','status_changed',848,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-10 21:59:50','2021-10-10 21:59:50'),(3117,'default','added',738,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":575}}','2021-10-10 21:59:53','2021-10-10 21:59:53'),(3118,'default','status_changed',798,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-10 22:00:04','2021-10-10 22:00:04'),(3119,'default','status_changed',838,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-10 22:00:15','2021-10-10 22:00:15'),(3120,'default','added',739,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-10 22:03:11','2021-10-10 22:03:11'),(3121,'default','added',740,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-10-10 22:04:12','2021-10-10 22:04:12'),(3122,'default','status_changed',836,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-10 22:05:05','2021-10-10 22:05:05'),(3123,'default','added',872,'App\\Contact',1,11,'App\\User','[]','2021-10-10 22:16:15','2021-10-10 22:16:15'),(3124,'default','added',873,'App\\Contact',1,4,'App\\User','[]','2021-10-10 22:22:02','2021-10-10 22:22:02'),(3125,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-10 22:23:36','2021-10-10 22:23:36'),(3126,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-10 22:27:21','2021-10-10 22:27:21'),(3127,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-10 22:37:58','2021-10-10 22:37:58'),(3128,'default','added',741,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-10 22:45:44','2021-10-10 22:45:44'),(3129,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-10 22:46:01','2021-10-10 22:46:01'),(3130,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-11 03:44:15','2021-10-11 03:44:15'),(3131,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-11 04:16:17','2021-10-11 04:16:17'),(3132,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-11 12:09:06','2021-10-11 12:09:06'),(3133,'default','added',874,'App\\Contact',1,11,'App\\User','[]','2021-10-11 12:28:40','2021-10-11 12:28:40'),(3134,'default','added',875,'App\\Contact',1,11,'App\\User','[]','2021-10-11 12:58:02','2021-10-11 12:58:02'),(3135,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-11 14:07:16','2021-10-11 14:07:16'),(3136,'default','added',876,'App\\Contact',1,11,'App\\User','[]','2021-10-11 14:16:47','2021-10-11 14:16:47'),(3137,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-11 14:20:43','2021-10-11 14:20:43'),(3138,'default','added',877,'App\\Contact',1,4,'App\\User','[]','2021-10-11 14:21:32','2021-10-11 14:21:32'),(3139,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-11 14:25:33','2021-10-11 14:25:33'),(3140,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-11 14:25:41','2021-10-11 14:25:41'),(3141,'default','added',878,'App\\Contact',1,4,'App\\User','[]','2021-10-11 14:39:25','2021-10-11 14:39:25'),(3142,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-11 14:48:03','2021-10-11 14:48:03'),(3143,'default','added',879,'App\\Contact',1,4,'App\\User','[]','2021-10-11 14:57:11','2021-10-11 14:57:11'),(3144,'default','added',880,'App\\Contact',1,4,'App\\User','[]','2021-10-11 15:07:19','2021-10-11 15:07:19'),(3145,'default','added',881,'App\\Contact',1,4,'App\\User','[]','2021-10-11 15:14:35','2021-10-11 15:14:35'),(3146,'default','added',882,'App\\Contact',1,4,'App\\User','[]','2021-10-11 15:16:34','2021-10-11 15:16:34'),(3147,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-11 15:52:24','2021-10-11 15:52:24'),(3148,'default','added',883,'App\\Contact',1,4,'App\\User','[]','2021-10-11 15:53:16','2021-10-11 15:53:16'),(3149,'default','added',884,'App\\Contact',1,4,'App\\User','[]','2021-10-11 15:58:02','2021-10-11 15:58:02'),(3150,'default','added',885,'App\\Contact',1,4,'App\\User','[]','2021-10-11 16:04:05','2021-10-11 16:04:05'),(3151,'default','added',886,'App\\Contact',1,4,'App\\User','[]','2021-10-11 16:17:48','2021-10-11 16:17:48'),(3152,'default','status_changed',860,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-11 17:04:42','2021-10-11 17:04:42'),(3153,'default','added',742,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-10-11 17:06:12','2021-10-11 17:06:12'),(3154,'default','status_changed',857,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-11 17:11:46','2021-10-11 17:11:46'),(3155,'default','status_changed',849,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-11 17:11:55','2021-10-11 17:11:55'),(3156,'default','added',743,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-11 17:13:03','2021-10-11 17:13:03'),(3157,'default','added',744,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-11 17:13:56','2021-10-11 17:13:56'),(3158,'default','status_changed',859,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-11 17:22:57','2021-10-11 17:22:57'),(3159,'default','added',887,'App\\Contact',1,4,'App\\User','[]','2021-10-11 17:48:50','2021-10-11 17:48:50'),(3160,'default','status_changed',794,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Finished\"}','2021-10-11 17:51:40','2021-10-11 17:51:40'),(3161,'default','added',745,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":75}}','2021-10-11 18:16:13','2021-10-11 18:16:13'),(3162,'default','added',746,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-10-11 18:19:36','2021-10-11 18:19:36'),(3163,'default','status_changed',863,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-11 18:23:08','2021-10-11 18:23:08'),(3164,'default','added',747,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-10-11 18:24:03','2021-10-11 18:24:03'),(3165,'default','status_changed',864,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-11 18:25:24','2021-10-11 18:25:24'),(3166,'default','added',748,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-10-11 18:25:43','2021-10-11 18:25:43'),(3167,'default','status_changed',831,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-11 18:26:07','2021-10-11 18:26:07'),(3168,'default','added',749,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":300}}','2021-10-11 18:27:48','2021-10-11 18:27:48'),(3169,'default','status_changed',785,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-10-11 18:29:16','2021-10-11 18:29:16'),(3170,'default','added',750,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-10-11 18:33:18','2021-10-11 18:33:18'),(3171,'default','status_changed',824,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-11 18:33:45','2021-10-11 18:33:45'),(3172,'default','added',751,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-11 18:35:10','2021-10-11 18:35:10'),(3173,'default','added',752,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-11 18:38:26','2021-10-11 18:38:26'),(3174,'default','added',753,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-10-11 18:42:29','2021-10-11 18:42:29'),(3175,'default','added',754,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":100}}','2021-10-11 18:46:40','2021-10-11 18:46:40'),(3176,'default','status_changed',837,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-11 18:48:03','2021-10-11 18:48:03'),(3177,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-11 18:54:18','2021-10-11 18:54:18'),(3178,'default','status_changed',713,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-11 18:58:59','2021-10-11 18:58:59'),(3179,'default','added',888,'App\\Contact',1,4,'App\\User','[]','2021-10-11 19:09:21','2021-10-11 19:09:21'),(3180,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-10-11 19:10:00','2021-10-11 19:10:00'),(3181,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-11 19:10:20','2021-10-11 19:10:20'),(3182,'default','payment_edited',745,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"75.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"75.0000\"}}','2021-10-11 19:11:51','2021-10-11 19:11:51'),(3183,'default','payment_edited',754,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"100.0000\"}}','2021-10-11 19:12:12','2021-10-11 19:12:12'),(3184,'default','status_changed',851,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-11 19:26:09','2021-10-11 19:26:09'),(3185,'default','status_changed',817,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-11 19:26:29','2021-10-11 19:26:29'),(3186,'default','status_changed',865,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-11 19:26:37','2021-10-11 19:26:37'),(3187,'default','added',889,'App\\Contact',1,4,'App\\User','[]','2021-10-11 19:36:25','2021-10-11 19:36:25'),(3188,'default','added',755,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-11 19:53:38','2021-10-11 19:53:38'),(3189,'default','added',890,'App\\Contact',1,4,'App\\User','[]','2021-10-11 19:55:53','2021-10-11 19:55:53'),(3190,'default','added',756,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-10-11 20:15:35','2021-10-11 20:15:35'),(3191,'default','status_changed',852,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-11 20:15:57','2021-10-11 20:15:57'),(3192,'default','edited',752,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"}}','2021-10-11 20:43:50','2021-10-11 20:43:50'),(3193,'default','payment_edited',752,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"},\"old\":{\"payment_status\":\"paid\"}}','2021-10-11 20:44:22','2021-10-11 20:44:22'),(3194,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-10-11 20:49:36','2021-10-11 20:49:36'),(3195,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-11 20:49:47','2021-10-11 20:49:47'),(3196,'default','added',757,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-11 21:01:58','2021-10-11 21:01:58'),(3197,'default','added',758,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":325}}','2021-10-11 21:04:18','2021-10-11 21:04:18'),(3198,'default','status_changed',855,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-11 21:10:12','2021-10-11 21:10:12'),(3199,'default','added',891,'App\\Contact',1,4,'App\\User','[]','2021-10-11 21:18:58','2021-10-11 21:18:58'),(3200,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-11 21:19:19','2021-10-11 21:19:19'),(3201,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-11 21:19:36','2021-10-11 21:19:36'),(3202,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-10-11 21:19:45','2021-10-11 21:19:45'),(3203,'default','payment_edited',758,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"325.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"325.0000\"}}','2021-10-11 21:20:26','2021-10-11 21:20:26'),(3204,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-10-11 21:22:20','2021-10-11 21:22:20'),(3205,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-11 21:22:36','2021-10-11 21:22:36'),(3206,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-11 21:24:02','2021-10-11 21:24:02'),(3207,'default','added',759,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-11 21:28:28','2021-10-11 21:28:28'),(3208,'default','added',760,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-11 21:28:58','2021-10-11 21:28:58'),(3209,'default','payment_edited',237,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"500.0000\"}}','2021-10-11 21:31:09','2021-10-11 21:31:09'),(3210,'default','payment_edited',237,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"500.0000\"}}','2021-10-11 21:33:55','2021-10-11 21:33:55'),(3211,'default','payment_edited',237,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"500.0000\"}}','2021-10-11 21:37:15','2021-10-11 21:37:15'),(3212,'default','payment_edited',42,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"400.0000\"}}','2021-10-11 21:37:46','2021-10-11 21:37:46'),(3213,'default','added',892,'App\\Contact',1,20,'App\\User','[]','2021-10-11 21:38:14','2021-10-11 21:38:14'),(3214,'default','added',761,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-10-11 21:52:30','2021-10-11 21:52:30'),(3215,'default','added',762,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-11 22:36:27','2021-10-11 22:36:27'),(3216,'default','added',893,'App\\Contact',1,4,'App\\User','[]','2021-10-11 22:41:13','2021-10-11 22:41:13'),(3217,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-12 11:54:18','2021-10-12 11:54:18'),(3218,'default','status_changed',695,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-10-12 12:05:45','2021-10-12 12:05:45'),(3219,'default','added',894,'App\\Contact',1,11,'App\\User','[]','2021-10-12 12:59:43','2021-10-12 12:59:43'),(3220,'default','added',895,'App\\Contact',1,11,'App\\User','[]','2021-10-12 13:13:40','2021-10-12 13:13:40'),(3221,'default','added',896,'App\\Contact',1,11,'App\\User','[]','2021-10-12 13:56:55','2021-10-12 13:56:55'),(3222,'default','added',763,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":1500}}','2021-10-12 14:11:08','2021-10-12 14:11:08'),(3223,'default','status_changed',654,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-12 14:19:41','2021-10-12 14:19:41'),(3224,'default','status_changed',770,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-12 14:22:23','2021-10-12 14:22:23'),(3225,'default','status_changed',816,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-12 14:26:31','2021-10-12 14:26:31'),(3226,'default','status_changed',746,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-12 14:29:18','2021-10-12 14:29:18'),(3227,'default','status_changed',858,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-12 14:36:23','2021-10-12 14:36:23'),(3228,'default','status_changed',385,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-12 14:44:03','2021-10-12 14:44:03'),(3229,'default','status_changed',862,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-12 14:44:43','2021-10-12 14:44:43'),(3230,'default','status_changed',769,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-12 14:45:01','2021-10-12 14:45:01'),(3231,'default','status_changed',719,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-12 14:45:35','2021-10-12 14:45:35'),(3232,'default','status_changed',508,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-12 14:46:10','2021-10-12 14:46:10'),(3233,'default','status_changed',688,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-12 14:46:43','2021-10-12 14:46:43'),(3234,'default','status_changed',491,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-12 14:47:21','2021-10-12 14:47:21'),(3235,'default','status_changed',480,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-12 14:49:08','2021-10-12 14:49:08'),(3236,'default','status_changed',466,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-12 14:50:30','2021-10-12 14:50:30'),(3237,'default','status_changed',116,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-12 14:51:58','2021-10-12 14:51:58'),(3238,'default','status_changed',592,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-12 14:52:49','2021-10-12 14:52:49'),(3239,'default','status_changed',720,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-12 14:53:59','2021-10-12 14:53:59'),(3240,'default','status_changed',787,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-12 14:54:18','2021-10-12 14:54:18'),(3241,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-12 15:17:11','2021-10-12 15:17:11'),(3242,'default','status_changed',876,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-12 15:18:26','2021-10-12 15:18:26'),(3243,'default','status_changed',871,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-12 15:18:37','2021-10-12 15:18:37'),(3244,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-12 15:22:29','2021-10-12 15:22:29'),(3245,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-12 15:22:40','2021-10-12 15:22:40'),(3246,'default','added',897,'App\\Contact',1,4,'App\\User','[]','2021-10-12 15:31:30','2021-10-12 15:31:30'),(3247,'default','added',898,'App\\Contact',1,4,'App\\User','[]','2021-10-12 16:02:05','2021-10-12 16:02:05'),(3248,'default','added',764,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-10-12 16:17:03','2021-10-12 16:17:03'),(3249,'default','status_changed',846,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-12 16:21:08','2021-10-12 16:21:08'),(3250,'default','status_changed',866,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-12 16:21:23','2021-10-12 16:21:23'),(3251,'default','added',765,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2}}','2021-10-12 16:30:18','2021-10-12 16:30:18'),(3252,'default','status_changed',849,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-10-12 16:43:39','2021-10-12 16:43:39'),(3253,'default','added',899,'App\\Contact',1,4,'App\\User','[]','2021-10-12 16:58:39','2021-10-12 16:58:39'),(3254,'default','added',766,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-10-12 17:45:53','2021-10-12 17:45:53'),(3255,'default','status_changed',840,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-12 17:46:08','2021-10-12 17:46:08'),(3256,'default','added',767,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-10-12 17:46:33','2021-10-12 17:46:33'),(3257,'default','status_changed',796,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-12 17:46:48','2021-10-12 17:46:48'),(3258,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-12 17:49:34','2021-10-12 17:49:34'),(3259,'default','payment_edited',633,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"200.0000\"}}','2021-10-12 17:50:22','2021-10-12 17:50:22'),(3260,'default','status_changed',774,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-12 17:51:30','2021-10-12 17:51:30'),(3261,'default','edited',765,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2.0000\"}}','2021-10-12 17:51:48','2021-10-12 17:51:48'),(3262,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-10-12 17:52:05','2021-10-12 17:52:05'),(3263,'default','edited',752,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"}}','2021-10-12 17:57:55','2021-10-12 17:57:55'),(3264,'default','payment_edited',752,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"},\"old\":{\"payment_status\":\"paid\"}}','2021-10-12 17:58:18','2021-10-12 17:58:18'),(3265,'default','added',768,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-12 18:01:03','2021-10-12 18:01:03'),(3266,'default','added',769,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-12 18:04:15','2021-10-12 18:04:15'),(3267,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-12 18:14:11','2021-10-12 18:14:11'),(3268,'default','added',900,'App\\Contact',1,4,'App\\User','[]','2021-10-12 18:14:44','2021-10-12 18:14:44'),(3269,'default','added',901,'App\\Contact',1,11,'App\\User','[]','2021-10-12 18:15:31','2021-10-12 18:15:31'),(3270,'default','added',902,'App\\Contact',1,4,'App\\User','[]','2021-10-12 18:18:31','2021-10-12 18:18:31'),(3271,'default','added',770,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":700}}','2021-10-12 18:18:58','2021-10-12 18:18:58'),(3272,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-12 18:19:07','2021-10-12 18:19:07'),(3273,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-12 18:19:14','2021-10-12 18:19:14'),(3274,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-12 18:26:00','2021-10-12 18:26:00'),(3275,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-12 19:17:07','2021-10-12 19:17:07'),(3276,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-12 19:17:07','2021-10-12 19:17:07'),(3277,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-12 19:17:29','2021-10-12 19:17:29'),(3278,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-12 19:20:32','2021-10-12 19:20:32'),(3279,'default','added',771,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-10-12 19:23:49','2021-10-12 19:23:49'),(3280,'default','status_changed',858,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-12 19:24:11','2021-10-12 19:24:11'),(3281,'default','added',772,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-12 19:26:54','2021-10-12 19:26:54'),(3282,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-12 19:37:47','2021-10-12 19:37:47'),(3283,'default','added',903,'App\\Contact',1,11,'App\\User','[]','2021-10-12 19:38:25','2021-10-12 19:38:25'),(3284,'default','added',904,'App\\Contact',1,11,'App\\User','[]','2021-10-12 19:43:43','2021-10-12 19:43:43'),(3285,'default','added',905,'App\\Contact',1,4,'App\\User','[]','2021-10-12 19:43:45','2021-10-12 19:43:45'),(3286,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-12 19:47:45','2021-10-12 19:47:45'),(3287,'default','status_changed',886,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-12 20:06:07','2021-10-12 20:06:07'),(3288,'default','status_changed',885,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-12 20:06:17','2021-10-12 20:06:17'),(3289,'default','added',773,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-10-12 20:35:43','2021-10-12 20:35:43'),(3290,'default','status_changed',869,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-12 20:37:34','2021-10-12 20:37:34'),(3291,'default','added',906,'App\\Contact',1,4,'App\\User','[]','2021-10-12 20:50:24','2021-10-12 20:50:24'),(3292,'default','added',907,'App\\Contact',1,4,'App\\User','[]','2021-10-12 21:00:23','2021-10-12 21:00:23'),(3293,'default','status_changed',835,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-12 21:05:07','2021-10-12 21:05:07'),(3294,'default','added',908,'App\\Contact',1,4,'App\\User','[]','2021-10-12 21:37:27','2021-10-12 21:37:27'),(3295,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-12 21:38:32','2021-10-12 21:38:32'),(3296,'default','added',774,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-10-12 21:41:09','2021-10-12 21:41:09'),(3297,'default','status_changed',877,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-12 21:41:38','2021-10-12 21:41:38'),(3298,'default','added',775,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-12 21:52:44','2021-10-12 21:52:44'),(3299,'default','added',909,'App\\Contact',1,11,'App\\User','[]','2021-10-12 21:52:57','2021-10-12 21:52:57'),(3300,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-12 21:57:52','2021-10-12 21:57:52'),(3301,'default','added',776,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-10-12 21:58:21','2021-10-12 21:58:21'),(3302,'default','status_changed',794,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Waiting for customer approve\"}','2021-10-12 22:00:54','2021-10-12 22:00:54'),(3303,'default','status_changed',871,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-12 22:01:44','2021-10-12 22:01:44'),(3304,'default','added',910,'App\\Contact',1,4,'App\\User','[]','2021-10-12 22:08:27','2021-10-12 22:08:27'),(3305,'default','added',777,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-10-12 22:14:26','2021-10-12 22:14:26'),(3306,'default','status_changed',872,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-12 22:14:41','2021-10-12 22:14:41'),(3307,'default','status_changed',876,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-12 22:18:00','2021-10-12 22:18:00'),(3308,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-12 22:18:12','2021-10-12 22:18:12'),(3309,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-12 22:33:00','2021-10-12 22:33:00'),(3310,'default','added',778,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-10-12 22:35:23','2021-10-12 22:35:23'),(3311,'default','status_changed',874,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-12 22:35:49','2021-10-12 22:35:49'),(3312,'default','added',779,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}','2021-10-12 22:36:08','2021-10-12 22:36:08'),(3313,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-13 12:04:09','2021-10-13 12:04:09'),(3314,'default','status_changed',785,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-13 13:00:25','2021-10-13 13:00:25'),(3315,'default','added',780,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-10-13 13:31:16','2021-10-13 13:31:16'),(3316,'default','status_changed',856,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-13 13:31:31','2021-10-13 13:31:31'),(3317,'default','added',911,'App\\Contact',1,11,'App\\User','[]','2021-10-13 13:47:54','2021-10-13 13:47:54'),(3318,'default','added',912,'App\\Contact',1,11,'App\\User','[]','2021-10-13 14:22:12','2021-10-13 14:22:12'),(3319,'default','added',913,'App\\Contact',1,11,'App\\User','[]','2021-10-13 14:35:04','2021-10-13 14:35:04'),(3320,'default','added',781,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2400}}','2021-10-13 14:42:48','2021-10-13 14:42:48'),(3321,'default','added',914,'App\\Contact',1,11,'App\\User','[]','2021-10-13 14:51:42','2021-10-13 14:51:42'),(3322,'default','added',915,'App\\Contact',1,11,'App\\User','[]','2021-10-13 15:14:57','2021-10-13 15:14:57'),(3323,'default','added',916,'App\\Contact',1,11,'App\\User','[]','2021-10-13 15:24:09','2021-10-13 15:24:09'),(3324,'default','added',782,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-10-13 15:38:28','2021-10-13 15:38:28'),(3325,'default','status_changed',859,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-13 15:39:07','2021-10-13 15:39:07'),(3326,'default','status_changed',878,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-13 15:43:51','2021-10-13 15:43:51'),(3327,'default','added',917,'App\\Contact',1,11,'App\\User','[]','2021-10-13 15:48:08','2021-10-13 15:48:08'),(3328,'default','added',918,'App\\Contact',1,11,'App\\User','[]','2021-10-13 15:52:09','2021-10-13 15:52:09'),(3329,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-13 15:58:42','2021-10-13 15:58:42'),(3330,'default','added',783,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":1400}}','2021-10-13 16:00:41','2021-10-13 16:00:41'),(3331,'default','status_changed',819,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-13 16:01:08','2021-10-13 16:01:08'),(3332,'default','status_changed',843,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-13 16:09:38','2021-10-13 16:09:38'),(3333,'default','status_changed',899,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-13 16:16:25','2021-10-13 16:16:25'),(3334,'default','status_changed',894,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-13 16:16:33','2021-10-13 16:16:33'),(3335,'default','status_changed',892,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-13 16:16:47','2021-10-13 16:16:47'),(3336,'default','status_changed',897,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-13 16:16:58','2021-10-13 16:16:58'),(3337,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-13 16:26:52','2021-10-13 16:26:52'),(3338,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-13 16:27:02','2021-10-13 16:27:02'),(3339,'default','added',919,'App\\Contact',1,4,'App\\User','[]','2021-10-13 17:00:56','2021-10-13 17:00:56'),(3340,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-10-13 17:17:34','2021-10-13 17:17:34'),(3341,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-13 17:17:54','2021-10-13 17:17:54'),(3342,'default','added',784,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1200}}','2021-10-13 18:02:22','2021-10-13 18:02:22'),(3343,'default','status_changed',857,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-13 18:02:35','2021-10-13 18:02:35'),(3344,'default','added',920,'App\\Contact',1,4,'App\\User','[]','2021-10-13 18:21:57','2021-10-13 18:21:57'),(3345,'default','added',921,'App\\Contact',1,4,'App\\User','[]','2021-10-13 19:17:28','2021-10-13 19:17:28'),(3346,'default','status_changed',896,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Waiting for customer approve\"}','2021-10-13 19:17:32','2021-10-13 19:17:32'),(3347,'default','status_changed',901,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"reject by customer\"}','2021-10-13 19:20:58','2021-10-13 19:20:58'),(3348,'default','status_changed',844,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-13 19:24:49','2021-10-13 19:24:49'),(3349,'default','added',922,'App\\Contact',1,4,'App\\User','[]','2021-10-13 19:53:52','2021-10-13 19:53:52'),(3350,'default','added',923,'App\\Contact',1,4,'App\\User','[]','2021-10-13 20:01:29','2021-10-13 20:01:29'),(3351,'default','status_changed',881,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-13 20:11:42','2021-10-13 20:11:42'),(3352,'default','added',924,'App\\Contact',1,4,'App\\User','[]','2021-10-13 20:21:38','2021-10-13 20:21:38'),(3353,'default','added',785,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-13 20:36:32','2021-10-13 20:36:32'),(3354,'default','added',786,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-10-13 20:53:53','2021-10-13 20:53:53'),(3355,'default','status_changed',906,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-13 20:54:14','2021-10-13 20:54:14'),(3356,'default','added',925,'App\\Contact',1,4,'App\\User','[]','2021-10-13 21:04:13','2021-10-13 21:04:13'),(3357,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-13 21:44:40','2021-10-13 21:44:40'),(3358,'default','added',787,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":850}}','2021-10-13 21:54:35','2021-10-13 21:54:35'),(3359,'default','status_changed',833,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-13 21:55:18','2021-10-13 21:55:18'),(3360,'default','added',788,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-10-13 21:55:54','2021-10-13 21:55:54'),(3361,'default','status_changed',890,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-13 21:56:11','2021-10-13 21:56:11'),(3362,'default','added',789,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-10-13 21:57:19','2021-10-13 21:57:19'),(3363,'default','added',790,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-10-13 21:58:19','2021-10-13 21:58:19'),(3364,'default','status_changed',820,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-13 21:58:41','2021-10-13 21:58:41'),(3365,'default','added',791,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-10-13 22:03:46','2021-10-13 22:03:46'),(3366,'default','added',792,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-13 22:18:43','2021-10-13 22:18:43'),(3367,'default','added',793,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-10-13 22:24:58','2021-10-13 22:24:58'),(3368,'default','status_changed',903,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-13 22:25:17','2021-10-13 22:25:17'),(3369,'default','added',794,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}','2021-10-13 22:37:08','2021-10-13 22:37:08'),(3370,'default','status_changed',884,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-13 22:38:06','2021-10-13 22:38:06'),(3371,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-14 12:05:20','2021-10-14 12:05:20'),(3372,'default','added',926,'App\\Contact',1,11,'App\\User','[]','2021-10-14 12:32:12','2021-10-14 12:32:12'),(3373,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-14 13:01:28','2021-10-14 13:01:28'),(3374,'default','added',927,'App\\Contact',1,1,'App\\User','[]','2021-10-14 13:02:16','2021-10-14 13:02:16'),(3375,'default','status_changed',670,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-10-14 13:06:09','2021-10-14 13:06:09'),(3376,'default','added',928,'App\\Contact',1,11,'App\\User','[]','2021-10-14 13:27:39','2021-10-14 13:27:39'),(3377,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-14 14:13:27','2021-10-14 14:13:27'),(3378,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-14 14:16:48','2021-10-14 14:16:48'),(3379,'default','status_changed',633,'App\\Transaction',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-14 14:20:18','2021-10-14 14:20:18'),(3380,'default','payment_edited',770,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"700.0000\"}}','2021-10-14 14:22:47','2021-10-14 14:22:47'),(3381,'default','payment_edited',732,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"6000.0000\"}}','2021-10-14 14:23:16','2021-10-14 14:23:16'),(3382,'default','added',929,'App\\Contact',1,4,'App\\User','[]','2021-10-14 14:28:58','2021-10-14 14:28:58'),(3383,'default','added',795,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":1500}}','2021-10-14 14:31:14','2021-10-14 14:31:14'),(3384,'default','edited',765,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}','2021-10-14 14:37:45','2021-10-14 14:37:45'),(3385,'default','status_changed',765,'App\\Transaction',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-14 14:38:34','2021-10-14 14:38:34'),(3386,'default','added',796,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-14 14:41:43','2021-10-14 14:41:43'),(3387,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-14 14:55:27','2021-10-14 14:55:27'),(3388,'default','status_changed',911,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-14 14:57:14','2021-10-14 14:57:14'),(3389,'default','status_changed',910,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-14 14:57:22','2021-10-14 14:57:22'),(3390,'default','added',797,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-10-14 15:04:43','2021-10-14 15:04:43'),(3391,'default','status_changed',892,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-10-14 15:21:44','2021-10-14 15:21:44'),(3392,'default','status_changed',885,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-10-14 15:23:48','2021-10-14 15:23:48'),(3393,'default','status_changed',897,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-10-14 15:25:40','2021-10-14 15:25:40'),(3394,'default','status_changed',894,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-10-14 15:29:02','2021-10-14 15:29:02'),(3395,'default','status_changed',784,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-10-14 15:29:13','2021-10-14 15:29:13'),(3396,'default','status_changed',888,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Waiting for customer approve\"}','2021-10-14 15:32:12','2021-10-14 15:32:12'),(3397,'default','status_changed',889,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Waiting for customer approve\"}','2021-10-14 15:32:21','2021-10-14 15:32:21'),(3398,'default','added',930,'App\\Contact',1,4,'App\\User','[]','2021-10-14 15:32:22','2021-10-14 15:32:22'),(3399,'default','added',931,'App\\Contact',1,11,'App\\User','[]','2021-10-14 15:50:41','2021-10-14 15:50:41'),(3400,'default','added',798,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-14 15:59:07','2021-10-14 15:59:07'),(3401,'default','added',932,'App\\Contact',1,4,'App\\User','[]','2021-10-14 16:09:17','2021-10-14 16:09:17'),(3402,'default','added',933,'App\\Contact',1,4,'App\\User','[]','2021-10-14 16:16:49','2021-10-14 16:16:49'),(3403,'default','added',934,'App\\Contact',1,4,'App\\User','[]','2021-10-14 16:32:56','2021-10-14 16:32:56'),(3404,'default','added',935,'App\\Contact',1,4,'App\\User','[]','2021-10-14 16:52:50','2021-10-14 16:52:50'),(3405,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-10-14 17:09:42','2021-10-14 17:09:42'),(3406,'default','added',936,'App\\Contact',1,4,'App\\User','[]','2021-10-14 17:25:48','2021-10-14 17:25:48'),(3407,'default','status_changed',695,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-10-14 18:01:40','2021-10-14 18:01:40'),(3408,'default','added',937,'App\\Contact',1,20,'App\\User','[]','2021-10-14 18:04:01','2021-10-14 18:04:01'),(3409,'default','added',938,'App\\Contact',1,20,'App\\User','[]','2021-10-14 18:08:57','2021-10-14 18:08:57'),(3410,'default','added',799,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-10-14 18:28:36','2021-10-14 18:28:36'),(3411,'default','status_changed',904,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-14 18:30:59','2021-10-14 18:30:59'),(3412,'default','added',800,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-10-14 18:31:24','2021-10-14 18:31:24'),(3413,'default','status_changed',893,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-14 18:31:41','2021-10-14 18:31:41'),(3414,'default','status_changed',920,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-14 18:56:23','2021-10-14 18:56:23'),(3415,'default','status_changed',905,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-14 18:57:54','2021-10-14 18:57:54'),(3416,'default','status_changed',889,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-14 18:58:14','2021-10-14 18:58:14'),(3417,'default','added',939,'App\\Contact',1,4,'App\\User','[]','2021-10-14 19:10:24','2021-10-14 19:10:24'),(3418,'default','added',940,'App\\Contact',1,4,'App\\User','[]','2021-10-14 19:27:48','2021-10-14 19:27:48'),(3419,'default','added',801,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}','2021-10-14 19:31:13','2021-10-14 19:31:13'),(3420,'default','status_changed',762,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-14 19:34:19','2021-10-14 19:34:19'),(3421,'default','added',941,'App\\Contact',1,4,'App\\User','[]','2021-10-14 19:41:37','2021-10-14 19:41:37'),(3422,'default','added',942,'App\\Contact',1,20,'App\\User','[]','2021-10-14 19:41:41','2021-10-14 19:41:41'),(3423,'default','added',802,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-10-14 19:50:45','2021-10-14 19:50:45'),(3424,'default','added',803,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-10-14 19:52:16','2021-10-14 19:52:16'),(3425,'default','status_changed',915,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-14 19:54:22','2021-10-14 19:54:22'),(3426,'default','status_changed',916,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-14 19:54:34','2021-10-14 19:54:34'),(3427,'default','status_changed',924,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-14 19:54:46','2021-10-14 19:54:46'),(3428,'default','status_changed',909,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-14 19:55:02','2021-10-14 19:55:02'),(3429,'default','added',804,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-10-14 20:06:49','2021-10-14 20:06:49'),(3430,'default','status_changed',897,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-14 20:07:16','2021-10-14 20:07:16'),(3431,'default','added',805,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}','2021-10-14 20:14:56','2021-10-14 20:14:56'),(3432,'default','status_changed',892,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-14 20:15:15','2021-10-14 20:15:15'),(3433,'default','added',806,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-10-14 20:16:56','2021-10-14 20:16:56'),(3434,'default','added',807,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-10-14 20:20:30','2021-10-14 20:20:30'),(3435,'default','status_changed',921,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-14 20:20:45','2021-10-14 20:20:45'),(3436,'default','added',808,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-14 20:27:32','2021-10-14 20:27:32'),(3437,'default','added',943,'App\\Contact',1,4,'App\\User','[]','2021-10-14 20:36:45','2021-10-14 20:36:45'),(3438,'default','status_changed',923,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-14 20:50:30','2021-10-14 20:50:30'),(3439,'default','status_changed',925,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-14 20:50:55','2021-10-14 20:50:55'),(3440,'default','added',809,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-10-14 20:56:36','2021-10-14 20:56:36'),(3441,'default','added',810,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-10-14 21:01:42','2021-10-14 21:01:42'),(3442,'default','added',811,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-10-14 21:02:11','2021-10-14 21:02:11'),(3443,'default','status_changed',882,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-14 21:02:19','2021-10-14 21:02:19'),(3444,'default','status_changed',885,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-14 21:02:33','2021-10-14 21:02:33'),(3445,'default','added',945,'App\\Contact',1,20,'App\\User','[]','2021-10-14 21:06:59','2021-10-14 21:06:59'),(3446,'default','added',944,'App\\Contact',1,20,'App\\User','[]','2021-10-14 21:06:59','2021-10-14 21:06:59'),(3447,'default','added',812,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-10-14 21:12:16','2021-10-14 21:12:16'),(3448,'default','added',946,'App\\Contact',1,4,'App\\User','[]','2021-10-14 21:14:43','2021-10-14 21:14:43'),(3449,'default','status_changed',920,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-14 21:24:27','2021-10-14 21:24:27'),(3450,'default','status_changed',907,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-14 21:25:04','2021-10-14 21:25:04'),(3451,'default','added',813,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-10-14 21:26:13','2021-10-14 21:26:13'),(3452,'default','added',814,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-14 21:29:31','2021-10-14 21:29:31'),(3453,'default','status_changed',925,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-10-14 21:30:50','2021-10-14 21:30:50'),(3454,'default','status_changed',926,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-14 21:31:22','2021-10-14 21:31:22'),(3455,'default','status_changed',928,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-14 21:31:35','2021-10-14 21:31:35'),(3456,'default','added',815,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-10-14 21:34:44','2021-10-14 21:34:44'),(3457,'default','added',816,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}','2021-10-14 21:39:17','2021-10-14 21:39:17'),(3458,'default','status_changed',886,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-14 21:39:32','2021-10-14 21:39:32'),(3459,'default','status_changed',922,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-14 21:44:43','2021-10-14 21:44:43'),(3460,'default','added',947,'App\\Contact',1,20,'App\\User','[]','2021-10-14 21:51:24','2021-10-14 21:51:24'),(3461,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-14 22:15:15','2021-10-14 22:15:15'),(3462,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-14 22:16:16','2021-10-14 22:16:16'),(3463,'default','status_changed',911,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-10-14 22:20:56','2021-10-14 22:20:56'),(3464,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-14 22:21:16','2021-10-14 22:21:16'),(3465,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-14 22:23:45','2021-10-14 22:23:45'),(3466,'default','added',817,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-10-14 22:24:51','2021-10-14 22:24:51'),(3467,'default','status_changed',753,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-14 22:25:27','2021-10-14 22:25:27'),(3468,'default','added',818,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-10-14 22:27:22','2021-10-14 22:27:22'),(3469,'default','status_changed',928,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-14 22:27:36','2021-10-14 22:27:36'),(3470,'default','added',819,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-10-14 22:29:47','2021-10-14 22:29:47'),(3471,'default','added',820,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1350}}','2021-10-14 22:33:06','2021-10-14 22:33:06'),(3472,'default','status_changed',923,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-14 22:33:29','2021-10-14 22:33:29'),(3473,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-14 22:36:26','2021-10-14 22:36:26'),(3474,'default','added',948,'App\\Contact',1,20,'App\\User','[]','2021-10-14 22:39:05','2021-10-14 22:39:05'),(3475,'default','logout',20,'App\\User',1,20,'App\\User','[]','2021-10-14 22:41:45','2021-10-14 22:41:45'),(3476,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-14 22:41:54','2021-10-14 22:41:54'),(3477,'default','added',821,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-14 22:42:19','2021-10-14 22:42:19'),(3478,'default','added',822,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-14 22:43:34','2021-10-14 22:43:34'),(3479,'default','added',823,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-14 22:44:12','2021-10-14 22:44:12'),(3480,'default','added',824,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-14 22:45:04','2021-10-14 22:45:04'),(3481,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-14 22:53:27','2021-10-14 22:53:27'),(3482,'default','added',825,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-14 22:54:47','2021-10-14 22:54:47'),(3483,'default','added',826,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-10-14 23:16:52','2021-10-14 23:16:52'),(3484,'default','status_changed',913,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-14 23:17:22','2021-10-14 23:17:22'),(3485,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-10-15 00:05:54','2021-10-15 00:05:54'),(3486,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-15 13:05:31','2021-10-15 13:05:31'),(3487,'default','added',949,'App\\Contact',1,11,'App\\User','[]','2021-10-15 13:33:55','2021-10-15 13:33:55'),(3488,'default','status_changed',926,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-10-15 14:02:37','2021-10-15 14:02:37'),(3489,'default','added',950,'App\\Contact',1,11,'App\\User','[]','2021-10-15 14:23:01','2021-10-15 14:23:01'),(3490,'default','added',827,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-10-15 16:42:25','2021-10-15 16:42:25'),(3491,'default','status_changed',701,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-15 16:42:45','2021-10-15 16:42:45'),(3492,'default','added',951,'App\\Contact',1,11,'App\\User','[]','2021-10-15 18:30:29','2021-10-15 18:30:29'),(3493,'default','added',952,'App\\Contact',1,11,'App\\User','[]','2021-10-15 18:48:51','2021-10-15 18:48:51'),(3494,'default','added',953,'App\\Contact',1,11,'App\\User','[]','2021-10-15 18:54:13','2021-10-15 18:54:13'),(3495,'default','added',828,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-10-15 19:27:45','2021-10-15 19:27:45'),(3496,'default','status_changed',926,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-15 19:27:59','2021-10-15 19:27:59'),(3497,'default','added',954,'App\\Contact',1,11,'App\\User','[]','2021-10-15 19:46:09','2021-10-15 19:46:09'),(3498,'default','added',955,'App\\Contact',1,11,'App\\User','[]','2021-10-15 20:15:20','2021-10-15 20:15:20'),(3499,'default','added',956,'App\\Contact',1,11,'App\\User','[]','2021-10-15 20:19:42','2021-10-15 20:19:42'),(3500,'default','status_changed',722,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":\"\\u062a\\u0645 \\u0627\\u0633\\u062a\\u0644\\u0627\\u0645 \\u0627\\u0644\\u062c\\u0647\\u0627\\u0632 \\u0645\\u0646 \\u0642\\u0628\\u0644 \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644\",\"updated_status\":\"Can\'t be repaired\"}','2021-10-15 21:02:51','2021-10-15 21:02:51'),(3501,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-16 11:33:38','2021-10-16 11:33:38'),(3502,'default','added',957,'App\\Contact',1,11,'App\\User','[]','2021-10-16 11:34:24','2021-10-16 11:34:24'),(3503,'default','added',958,'App\\Contact',1,11,'App\\User','[]','2021-10-16 12:48:45','2021-10-16 12:48:45'),(3504,'default','added',959,'App\\Contact',1,11,'App\\User','[]','2021-10-16 13:02:39','2021-10-16 13:02:39'),(3505,'default','added',960,'App\\Contact',1,11,'App\\User','[]','2021-10-16 13:11:52','2021-10-16 13:11:52'),(3506,'default','added',829,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-10-16 13:27:00','2021-10-16 13:27:00'),(3507,'default','status_changed',908,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-16 13:27:14','2021-10-16 13:27:14'),(3508,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-16 14:28:27','2021-10-16 14:28:27'),(3509,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-16 14:30:52','2021-10-16 14:30:52'),(3510,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-16 14:31:00','2021-10-16 14:31:00'),(3511,'default','added',830,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-16 14:35:53','2021-10-16 14:35:53'),(3512,'default','added',831,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-16 14:37:19','2021-10-16 14:37:19'),(3513,'default','added',832,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-16 14:38:00','2021-10-16 14:38:00'),(3514,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-16 14:39:43','2021-10-16 14:39:43'),(3515,'default','added',961,'App\\Contact',1,4,'App\\User','[]','2021-10-16 15:05:51','2021-10-16 15:05:51'),(3516,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-16 15:10:20','2021-10-16 15:10:20'),(3517,'default','added',962,'App\\Contact',1,4,'App\\User','[]','2021-10-16 15:12:46','2021-10-16 15:12:46'),(3518,'default','status_changed',932,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-16 15:28:37','2021-10-16 15:28:37'),(3519,'default','status_changed',929,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-16 15:30:32','2021-10-16 15:30:32'),(3520,'default','status_changed',938,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-16 15:30:48','2021-10-16 15:30:48'),(3521,'default','status_changed',937,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-16 15:30:56','2021-10-16 15:30:56'),(3522,'default','status_changed',875,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-16 15:31:04','2021-10-16 15:31:04'),(3523,'default','added',963,'App\\Contact',1,4,'App\\User','[]','2021-10-16 15:35:05','2021-10-16 15:35:05'),(3524,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-16 15:36:32','2021-10-16 15:36:32'),(3525,'default','added',964,'App\\Contact',1,11,'App\\User','[]','2021-10-16 15:37:25','2021-10-16 15:37:25'),(3526,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-16 15:40:57','2021-10-16 15:40:57'),(3527,'default','added',965,'App\\Contact',1,4,'App\\User','[]','2021-10-16 15:43:47','2021-10-16 15:43:47'),(3528,'default','status_changed',946,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-16 15:44:39','2021-10-16 15:44:39'),(3529,'default','status_changed',925,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Waiting for customer approve\"}','2021-10-16 15:45:10','2021-10-16 15:45:10'),(3530,'default','added',966,'App\\Contact',1,4,'App\\User','[]','2021-10-16 15:58:45','2021-10-16 15:58:45'),(3531,'default','added',833,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":75}}','2021-10-16 16:03:48','2021-10-16 16:03:48'),(3532,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-16 16:21:55','2021-10-16 16:21:55'),(3533,'default','payment_edited',783,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1400.0000\"}}','2021-10-16 16:22:45','2021-10-16 16:22:45'),(3534,'default','payment_edited',688,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"500.0000\"}}','2021-10-16 16:25:44','2021-10-16 16:25:44'),(3535,'default','payment_edited',763,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1500.0000\"}}','2021-10-16 16:26:35','2021-10-16 16:26:35'),(3536,'default','added',834,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-10-16 16:31:35','2021-10-16 16:31:35'),(3537,'default','added',835,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":250}}','2021-10-16 16:33:52','2021-10-16 16:33:52'),(3538,'default','added',967,'App\\Contact',1,4,'App\\User','[]','2021-10-16 16:54:04','2021-10-16 16:54:04'),(3539,'default','added',968,'App\\Contact',1,11,'App\\User','[]','2021-10-16 16:56:59','2021-10-16 16:56:59'),(3540,'default','added',836,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-10-16 17:00:32','2021-10-16 17:00:32'),(3541,'default','added',837,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}','2021-10-16 17:02:51','2021-10-16 17:02:51'),(3542,'default','status_changed',861,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-16 17:04:18','2021-10-16 17:04:18'),(3543,'default','added',838,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}','2021-10-16 17:38:41','2021-10-16 17:38:41'),(3544,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-10-16 17:46:14','2021-10-16 17:46:14'),(3545,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-16 17:46:20','2021-10-16 17:46:20'),(3546,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-16 17:47:07','2021-10-16 17:47:07'),(3547,'default','added',839,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-16 17:59:09','2021-10-16 17:59:09'),(3548,'default','added',969,'App\\Contact',1,4,'App\\User','[]','2021-10-16 18:09:28','2021-10-16 18:09:28'),(3549,'default','added',840,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":125}}','2021-10-16 18:31:56','2021-10-16 18:31:56'),(3550,'default','status_changed',945,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-16 18:32:53','2021-10-16 18:32:53'),(3551,'default','added',970,'App\\Contact',1,4,'App\\User','[]','2021-10-16 18:47:41','2021-10-16 18:47:41'),(3552,'default','added',971,'App\\Contact',1,4,'App\\User','[]','2021-10-16 18:53:04','2021-10-16 18:53:04'),(3553,'default','added',841,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-10-16 18:59:44','2021-10-16 18:59:44'),(3554,'default','status_changed',914,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-16 19:00:12','2021-10-16 19:00:12'),(3555,'default','added',972,'App\\Contact',1,4,'App\\User','[]','2021-10-16 19:07:50','2021-10-16 19:07:50'),(3556,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-10-16 19:12:22','2021-10-16 19:12:22'),(3557,'default','added',842,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-10-16 19:14:24','2021-10-16 19:14:24'),(3558,'default','status_changed',934,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-16 19:14:40','2021-10-16 19:14:40'),(3559,'default','status_changed',930,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-16 19:17:51','2021-10-16 19:17:51'),(3560,'default','added',843,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":50}}','2021-10-16 19:22:20','2021-10-16 19:22:20'),(3561,'default','added',973,'App\\Contact',1,4,'App\\User','[]','2021-10-16 19:33:20','2021-10-16 19:33:20'),(3562,'default','added',844,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-10-16 19:39:55','2021-10-16 19:39:55'),(3563,'default','added',974,'App\\Contact',1,4,'App\\User','[]','2021-10-16 19:41:34','2021-10-16 19:41:34'),(3564,'default','added',845,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-10-16 20:09:56','2021-10-16 20:09:56'),(3565,'default','status_changed',947,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-16 20:11:17','2021-10-16 20:11:17'),(3566,'default','added',975,'App\\Contact',1,4,'App\\User','[]','2021-10-16 20:13:00','2021-10-16 20:13:00'),(3567,'default','status_changed',936,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-16 20:32:44','2021-10-16 20:32:44'),(3568,'default','status_changed',948,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-16 20:37:21','2021-10-16 20:37:21'),(3569,'default','status_changed',949,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-16 20:37:48','2021-10-16 20:37:48'),(3570,'default','added',976,'App\\Contact',1,20,'App\\User','[]','2021-10-16 20:39:16','2021-10-16 20:39:16'),(3571,'default','added',846,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-16 20:53:28','2021-10-16 20:53:28'),(3572,'default','added',847,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-16 20:54:42','2021-10-16 20:54:42'),(3573,'default','added',848,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-16 20:55:24','2021-10-16 20:55:24'),(3574,'default','added',849,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-10-16 21:03:23','2021-10-16 21:03:23'),(3575,'default','status_changed',957,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-16 21:03:51','2021-10-16 21:03:51'),(3576,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-16 21:22:57','2021-10-16 21:22:57'),(3577,'default','added',850,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-10-16 21:34:18','2021-10-16 21:34:18'),(3578,'default','status_changed',938,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-16 21:34:43','2021-10-16 21:34:43'),(3579,'default','added',851,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-10-16 21:35:01','2021-10-16 21:35:01'),(3580,'default','status_changed',937,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-16 21:35:23','2021-10-16 21:35:23'),(3581,'default','added',852,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-16 21:38:19','2021-10-16 21:38:19'),(3582,'default','added',977,'App\\Contact',1,4,'App\\User','[]','2021-10-16 21:51:47','2021-10-16 21:51:47'),(3583,'default','added',978,'App\\Contact',1,4,'App\\User','[]','2021-10-16 22:12:17','2021-10-16 22:12:17'),(3584,'default','status_changed',911,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-16 22:19:04','2021-10-16 22:19:04'),(3585,'default','added',853,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-10-16 22:19:29','2021-10-16 22:19:29'),(3586,'default','status_changed',951,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-16 22:19:46','2021-10-16 22:19:46'),(3587,'default','added',854,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-10-16 22:20:19','2021-10-16 22:20:19'),(3588,'default','status_changed',958,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-16 22:20:40','2021-10-16 22:20:40'),(3589,'default','added',855,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-10-16 22:24:51','2021-10-16 22:24:51'),(3590,'default','status_changed',940,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-16 22:27:04','2021-10-16 22:27:04'),(3591,'default','added',979,'App\\Contact',1,4,'App\\User','[]','2021-10-16 22:28:05','2021-10-16 22:28:05'),(3592,'default','added',856,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-10-16 22:36:43','2021-10-16 22:36:43'),(3593,'default','status_changed',929,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-16 22:37:08','2021-10-16 22:37:08'),(3594,'default','added',857,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":300}}','2021-10-16 22:48:29','2021-10-16 22:48:29'),(3595,'default','added',858,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-10-16 22:49:53','2021-10-16 22:49:53'),(3596,'default','status_changed',794,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-16 22:50:16','2021-10-16 22:50:16'),(3597,'default','added',859,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-10-16 22:50:52','2021-10-16 22:50:52'),(3598,'default','status_changed',946,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-16 22:51:08','2021-10-16 22:51:08'),(3599,'default','added',860,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-16 22:52:51','2021-10-16 22:52:51'),(3600,'default','added',861,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-16 22:53:26','2021-10-16 22:53:26'),(3601,'default','added',862,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-10-16 23:46:39','2021-10-16 23:46:39'),(3602,'default','status_changed',918,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-16 23:46:57','2021-10-16 23:46:57'),(3603,'default','added',863,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-10-16 23:47:11','2021-10-16 23:47:11'),(3604,'default','status_changed',919,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-16 23:47:28','2021-10-16 23:47:28'),(3605,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-10-16 23:48:17','2021-10-16 23:48:17'),(3606,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-17 11:20:21','2021-10-17 11:20:21'),(3607,'default','added',980,'App\\Contact',1,11,'App\\User','[]','2021-10-17 11:49:30','2021-10-17 11:49:30'),(3608,'default','added',981,'App\\Contact',1,11,'App\\User','[]','2021-10-17 12:23:04','2021-10-17 12:23:04'),(3609,'default','added',982,'App\\Contact',1,11,'App\\User','[]','2021-10-17 12:36:37','2021-10-17 12:36:37'),(3610,'default','status_changed',883,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":\"\\u062a\\u0645 \\u0627\\u0633\\u062a\\u0644\\u0627\\u0645 \\u0627\\u0644\\u062c\\u0647\\u0627\\u0632 \\u0645\\u0646 \\u0642\\u0628\\u0644 \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644\",\"updated_status\":\"Can\'t be repaired\"}','2021-10-17 13:03:01','2021-10-17 13:03:01'),(3611,'default','status_changed',883,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-17 13:03:08','2021-10-17 13:03:08'),(3612,'default','added',983,'App\\Contact',1,11,'App\\User','[]','2021-10-17 13:36:15','2021-10-17 13:36:15'),(3613,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-17 14:33:09','2021-10-17 14:33:09'),(3614,'default','added',984,'App\\Contact',1,11,'App\\User','[]','2021-10-17 14:40:36','2021-10-17 14:40:36'),(3615,'default','added',985,'App\\Contact',1,4,'App\\User','[]','2021-10-17 14:40:47','2021-10-17 14:40:47'),(3616,'default','added',986,'App\\Contact',1,11,'App\\User','[]','2021-10-17 14:46:32','2021-10-17 14:46:32'),(3617,'default','added',987,'App\\Contact',1,4,'App\\User','[]','2021-10-17 14:53:06','2021-10-17 14:53:06'),(3618,'default','added',864,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-10-17 14:58:06','2021-10-17 14:58:06'),(3619,'default','status_changed',898,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-17 14:58:19','2021-10-17 14:58:19'),(3620,'default','added',865,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-10-17 14:58:40','2021-10-17 14:58:40'),(3621,'default','status_changed',912,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-17 14:58:52','2021-10-17 14:58:52'),(3622,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-17 14:59:30','2021-10-17 14:59:30'),(3623,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-17 15:09:42','2021-10-17 15:09:42'),(3624,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-17 15:13:19','2021-10-17 15:13:19'),(3625,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-17 15:13:42','2021-10-17 15:13:42'),(3626,'default','added',866,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":125}}','2021-10-17 15:14:12','2021-10-17 15:14:12'),(3627,'default','status_changed',933,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-17 15:14:28','2021-10-17 15:14:28'),(3628,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-17 15:14:36','2021-10-17 15:14:36'),(3629,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-17 15:23:30','2021-10-17 15:23:30'),(3630,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-17 15:37:23','2021-10-17 15:37:23'),(3631,'default','status_changed',952,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-17 15:42:14','2021-10-17 15:42:14'),(3632,'default','added',867,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-10-17 15:42:41','2021-10-17 15:42:41'),(3633,'default','status_changed',932,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-17 15:43:05','2021-10-17 15:43:05'),(3634,'default','status_changed',954,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-17 15:53:19','2021-10-17 15:53:19'),(3635,'default','status_changed',960,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-17 15:54:21','2021-10-17 15:54:21'),(3636,'default','status_changed',961,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-17 15:54:30','2021-10-17 15:54:30'),(3637,'default','status_changed',969,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-17 15:55:21','2021-10-17 15:55:21'),(3638,'default','added',868,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-10-17 16:09:13','2021-10-17 16:09:13'),(3639,'default','status_changed',942,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-17 16:09:27','2021-10-17 16:09:27'),(3640,'default','added',988,'App\\Contact',1,4,'App\\User','[]','2021-10-17 16:18:17','2021-10-17 16:18:17'),(3641,'default','added',989,'App\\Contact',1,4,'App\\User','[]','2021-10-17 16:32:07','2021-10-17 16:32:07'),(3642,'default','added',869,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-10-17 17:06:48','2021-10-17 17:06:48'),(3643,'default','status_changed',745,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-17 17:07:41','2021-10-17 17:07:41'),(3644,'default','added',870,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-10-17 17:11:06','2021-10-17 17:11:06'),(3645,'default','added',871,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":250}}','2021-10-17 17:12:21','2021-10-17 17:12:21'),(3646,'default','added',872,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":250}}','2021-10-17 17:20:09','2021-10-17 17:20:09'),(3647,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-17 17:21:59','2021-10-17 17:21:59'),(3648,'default','status_changed',965,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-17 17:56:18','2021-10-17 17:56:18'),(3649,'default','status_changed',895,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-17 18:01:42','2021-10-17 18:01:42'),(3650,'default','added',990,'App\\Contact',1,4,'App\\User','[]','2021-10-17 18:32:12','2021-10-17 18:32:12'),(3651,'default','added',991,'App\\Contact',1,4,'App\\User','[]','2021-10-17 18:41:40','2021-10-17 18:41:40'),(3652,'default','added',873,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-17 19:29:27','2021-10-17 19:29:27'),(3653,'default','added',874,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-17 19:30:24','2021-10-17 19:30:24'),(3654,'default','added',992,'App\\Contact',1,4,'App\\User','[]','2021-10-17 19:55:56','2021-10-17 19:55:56'),(3655,'default','added',875,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-10-17 20:06:13','2021-10-17 20:06:13'),(3656,'default','added',993,'App\\Contact',1,4,'App\\User','[]','2021-10-17 20:35:06','2021-10-17 20:35:06'),(3657,'default','added',876,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-10-17 20:42:58','2021-10-17 20:42:58'),(3658,'default','added',877,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-10-17 20:46:09','2021-10-17 20:46:09'),(3659,'default','status_changed',974,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-17 20:46:52','2021-10-17 20:46:52'),(3660,'default','added',878,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-17 20:49:40','2021-10-17 20:49:40'),(3661,'default','added',994,'App\\Contact',1,4,'App\\User','[]','2021-10-17 21:05:23','2021-10-17 21:05:23'),(3662,'default','added',879,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-17 21:11:45','2021-10-17 21:11:45'),(3663,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-17 21:12:01','2021-10-17 21:12:01'),(3664,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-10-17 21:15:21','2021-10-17 21:15:21'),(3665,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-17 21:15:36','2021-10-17 21:15:36'),(3666,'default','payment_edited',833,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"75.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"75.0000\"}}','2021-10-17 21:17:13','2021-10-17 21:17:13'),(3667,'default','payment_edited',843,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"50.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"50.0000\"}}','2021-10-17 21:17:46','2021-10-17 21:17:46'),(3668,'default','payment_edited',795,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1500.0000\"}}','2021-10-17 21:18:40','2021-10-17 21:18:40'),(3669,'default','payment_edited',781,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2400.0000\"}}','2021-10-17 21:19:59','2021-10-17 21:19:59'),(3670,'default','status_changed',894,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-17 21:20:13','2021-10-17 21:20:13'),(3671,'default','payment_edited',835,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"250.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"250.0000\"}}','2021-10-17 21:20:41','2021-10-17 21:20:41'),(3672,'default','payment_edited',857,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"300.0000\"}}','2021-10-17 21:23:15','2021-10-17 21:23:15'),(3673,'default','status_changed',962,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-17 21:24:14','2021-10-17 21:24:14'),(3674,'default','added',880,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":1000}}','2021-10-17 21:26:00','2021-10-17 21:26:00'),(3675,'default','added',995,'App\\Contact',1,4,'App\\User','[]','2021-10-17 21:34:17','2021-10-17 21:34:17'),(3676,'default','added',881,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-10-17 21:43:37','2021-10-17 21:43:37'),(3677,'default','added',882,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}','2021-10-17 22:06:22','2021-10-17 22:06:22'),(3678,'default','added',883,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-10-17 22:06:57','2021-10-17 22:06:57'),(3679,'default','added',884,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-17 22:10:08','2021-10-17 22:10:08'),(3680,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-10-17 23:00:03','2021-10-17 23:00:03'),(3681,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-18 11:13:06','2021-10-18 11:13:06'),(3682,'default','added',996,'App\\Contact',1,11,'App\\User','[]','2021-10-18 12:32:14','2021-10-18 12:32:14'),(3683,'default','added',997,'App\\Contact',1,11,'App\\User','[]','2021-10-18 12:55:42','2021-10-18 12:55:42'),(3684,'default','added',885,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-10-18 13:06:32','2021-10-18 13:06:32'),(3685,'default','status_changed',935,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-18 13:06:51','2021-10-18 13:06:51'),(3686,'default','added',998,'App\\Contact',1,11,'App\\User','[]','2021-10-18 13:16:58','2021-10-18 13:16:58'),(3687,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-18 14:00:42','2021-10-18 14:00:42'),(3688,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-18 14:00:51','2021-10-18 14:00:51'),(3689,'default','added',999,'App\\Contact',1,4,'App\\User','[]','2021-10-18 14:09:45','2021-10-18 14:09:45'),(3690,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-18 14:15:22','2021-10-18 14:15:22'),(3691,'default','added',1000,'App\\Contact',1,11,'App\\User','[]','2021-10-18 14:18:27','2021-10-18 14:18:27'),(3692,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-18 14:24:21','2021-10-18 14:24:21'),(3693,'default','added',886,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":500}}','2021-10-18 14:30:40','2021-10-18 14:30:40'),(3694,'default','added',887,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-10-18 14:39:13','2021-10-18 14:39:13'),(3695,'default','added',888,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-18 14:41:19','2021-10-18 14:41:19'),(3696,'default','added',889,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-18 14:42:55','2021-10-18 14:42:55'),(3697,'default','added',1001,'App\\Contact',1,4,'App\\User','[]','2021-10-18 14:54:21','2021-10-18 14:54:21'),(3698,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-18 14:55:51','2021-10-18 14:55:51'),(3699,'default','added',890,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-10-18 15:36:05','2021-10-18 15:36:05'),(3700,'default','status_changed',828,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-18 15:36:22','2021-10-18 15:36:22'),(3701,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-18 15:38:12','2021-10-18 15:38:12'),(3702,'default','added',1002,'App\\Contact',1,4,'App\\User','[]','2021-10-18 15:38:36','2021-10-18 15:38:36'),(3703,'default','added',1003,'App\\Contact',1,11,'App\\User','[]','2021-10-18 15:38:42','2021-10-18 15:38:42'),(3704,'default','added',891,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":200}}','2021-10-18 15:41:39','2021-10-18 15:41:39'),(3705,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-10-18 15:58:18','2021-10-18 15:58:18'),(3706,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-18 16:12:38','2021-10-18 16:12:38'),(3707,'default','added',1004,'App\\Contact',1,4,'App\\User','[]','2021-10-18 16:13:22','2021-10-18 16:13:22'),(3708,'default','added',1005,'App\\Contact',1,4,'App\\User','[]','2021-10-18 16:29:25','2021-10-18 16:29:25'),(3709,'default','added',1006,'App\\Contact',1,4,'App\\User','[]','2021-10-18 16:36:44','2021-10-18 16:36:44'),(3710,'default','added',892,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-10-18 16:46:47','2021-10-18 16:46:47'),(3711,'default','added',893,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-10-18 16:48:02','2021-10-18 16:48:02'),(3712,'default','added',1007,'App\\Contact',1,4,'App\\User','[]','2021-10-18 16:55:22','2021-10-18 16:55:22'),(3713,'default','status_changed',993,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-18 17:05:49','2021-10-18 17:05:49'),(3714,'default','added',1008,'App\\Contact',1,4,'App\\User','[]','2021-10-18 17:21:55','2021-10-18 17:21:55'),(3715,'default','added',894,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-18 17:53:46','2021-10-18 17:53:46'),(3716,'default','added',1009,'App\\Contact',1,4,'App\\User','[]','2021-10-18 17:59:46','2021-10-18 17:59:46'),(3717,'default','added',895,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-10-18 18:37:16','2021-10-18 18:37:16'),(3718,'default','status_changed',986,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-18 18:38:50','2021-10-18 18:38:50'),(3719,'default','status_changed',860,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-18 18:39:09','2021-10-18 18:39:09'),(3720,'default','status_changed',944,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-18 18:39:32','2021-10-18 18:39:32'),(3721,'default','added',1010,'App\\Contact',1,4,'App\\User','[]','2021-10-18 18:45:27','2021-10-18 18:45:27'),(3722,'default','added',1011,'App\\Contact',1,4,'App\\User','[]','2021-10-18 19:03:56','2021-10-18 19:03:56'),(3723,'default','status_changed',695,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-18 19:10:38','2021-10-18 19:10:38'),(3724,'default','status_changed',880,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-18 19:15:34','2021-10-18 19:15:34'),(3725,'default','status_changed',899,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-18 19:16:06','2021-10-18 19:16:06'),(3726,'default','status_changed',921,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-18 19:16:18','2021-10-18 19:16:18'),(3727,'default','status_changed',876,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-18 19:18:08','2021-10-18 19:18:08'),(3728,'default','status_changed',817,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-18 19:19:02','2021-10-18 19:19:02'),(3729,'default','status_changed',939,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-18 19:20:13','2021-10-18 19:20:13'),(3730,'default','status_changed',738,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-18 19:21:04','2021-10-18 19:21:04'),(3731,'default','status_changed',738,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-10-18 19:21:50','2021-10-18 19:21:50'),(3732,'default','status_changed',886,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-10-18 19:40:12','2021-10-18 19:40:12'),(3733,'default','added',1012,'App\\Contact',1,4,'App\\User','[]','2021-10-18 20:34:43','2021-10-18 20:34:43'),(3734,'default','added',1013,'App\\Contact',1,4,'App\\User','[]','2021-10-18 20:42:31','2021-10-18 20:42:31'),(3735,'default','added',1014,'App\\Contact',1,4,'App\\User','[]','2021-10-18 20:45:10','2021-10-18 20:45:10'),(3736,'default','added',1015,'App\\Contact',1,4,'App\\User','[]','2021-10-18 20:49:21','2021-10-18 20:49:21'),(3737,'default','added',1016,'App\\Contact',1,4,'App\\User','[]','2021-10-18 20:51:23','2021-10-18 20:51:23'),(3738,'default','added',896,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":300}}','2021-10-18 21:03:20','2021-10-18 21:03:20'),(3739,'default','added',897,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}','2021-10-18 21:06:34','2021-10-18 21:06:34'),(3740,'default','status_changed',959,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-18 21:06:46','2021-10-18 21:06:46'),(3741,'default','added',898,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-10-18 21:08:28','2021-10-18 21:08:28'),(3742,'default','status_changed',975,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-18 21:09:03','2021-10-18 21:09:03'),(3743,'default','added',899,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":650}}','2021-10-18 21:09:37','2021-10-18 21:09:37'),(3744,'default','status_changed',978,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-18 21:09:57','2021-10-18 21:09:57'),(3745,'default','added',900,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":125}}','2021-10-18 21:10:26','2021-10-18 21:10:26'),(3746,'default','status_changed',979,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-18 21:10:56','2021-10-18 21:10:56'),(3747,'default','added',901,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":500}}','2021-10-18 21:20:01','2021-10-18 21:20:01'),(3748,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-18 21:22:16','2021-10-18 21:22:16'),(3749,'default','added',902,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-10-18 21:22:49','2021-10-18 21:22:49'),(3750,'default','status_changed',905,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-18 21:23:07','2021-10-18 21:23:07'),(3751,'default','added',903,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-10-18 21:28:48','2021-10-18 21:28:48'),(3752,'default','status_changed',960,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-18 21:29:10','2021-10-18 21:29:10'),(3753,'default','added',904,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-18 21:33:08','2021-10-18 21:33:08'),(3754,'default','added',905,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-18 21:33:51','2021-10-18 21:33:51'),(3755,'default','added',906,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-18 21:39:41','2021-10-18 21:39:41'),(3756,'default','added',907,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-18 21:45:50','2021-10-18 21:45:50'),(3757,'default','added',908,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-10-18 21:55:12','2021-10-18 21:55:12'),(3758,'default','status_changed',1002,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-18 21:55:45','2021-10-18 21:55:45'),(3759,'default','added',909,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-18 21:59:33','2021-10-18 21:59:33'),(3760,'default','added',910,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-18 22:23:29','2021-10-18 22:23:29'),(3761,'default','added',911,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}','2021-10-18 22:26:50','2021-10-18 22:26:50'),(3762,'default','status_changed',969,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-18 22:27:26','2021-10-18 22:27:26'),(3763,'default','added',912,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-10-18 22:28:06','2021-10-18 22:28:06'),(3764,'default','added',913,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-10-18 22:28:45','2021-10-18 22:28:45'),(3765,'default','status_changed',984,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-18 22:29:17','2021-10-18 22:29:17'),(3766,'default','added',914,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-10-18 22:35:05','2021-10-18 22:35:05'),(3767,'default','status_changed',997,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-18 22:36:18','2021-10-18 22:36:18'),(3768,'default','added',915,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-10-18 22:59:20','2021-10-18 22:59:20'),(3769,'default','status_changed',982,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-18 22:59:43','2021-10-18 22:59:43'),(3770,'default','added',916,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-18 23:05:06','2021-10-18 23:05:06'),(3771,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-10-19 13:08:50','2021-10-19 13:08:50'),(3772,'default','added',1017,'App\\Contact',1,20,'App\\User','[]','2021-10-19 13:54:14','2021-10-19 13:54:14'),(3773,'default','status_changed',995,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-19 14:30:54','2021-10-19 14:30:54'),(3774,'default','added',1018,'App\\Contact',1,20,'App\\User','[]','2021-10-19 14:34:46','2021-10-19 14:34:46'),(3775,'default','added',917,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-10-19 14:48:24','2021-10-19 14:48:24'),(3776,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-19 14:49:22','2021-10-19 14:49:22'),(3777,'default','added',1019,'App\\Contact',1,4,'App\\User','[]','2021-10-19 14:50:25','2021-10-19 14:50:25'),(3778,'default','status_changed',986,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-10-19 15:02:48','2021-10-19 15:02:48'),(3779,'default','status_changed',994,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-19 15:46:03','2021-10-19 15:46:03'),(3780,'default','status_changed',932,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-10-19 15:49:33','2021-10-19 15:49:33'),(3781,'default','added',1020,'App\\Contact',1,20,'App\\User','[]','2021-10-19 15:53:55','2021-10-19 15:53:55'),(3782,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-10-19 15:57:56','2021-10-19 15:57:56'),(3783,'default','logout',20,'App\\User',1,20,'App\\User','[]','2021-10-19 16:11:09','2021-10-19 16:11:09'),(3784,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-19 16:11:17','2021-10-19 16:11:17'),(3785,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-10-19 16:11:27','2021-10-19 16:11:27'),(3786,'default','status_changed',777,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-19 16:14:41','2021-10-19 16:14:41'),(3787,'default','added',918,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-19 16:15:32','2021-10-19 16:15:32'),(3788,'default','added',1021,'App\\Contact',1,4,'App\\User','[]','2021-10-19 16:56:03','2021-10-19 16:56:03'),(3789,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-19 17:35:02','2021-10-19 17:35:02'),(3790,'default','payment_edited',872,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"250.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"250.0000\"}}','2021-10-19 17:36:39','2021-10-19 17:36:39'),(3791,'default','added',919,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-19 17:42:09','2021-10-19 17:42:09'),(3792,'default','edited',901,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":500},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"500.0000\"}}','2021-10-19 17:45:27','2021-10-19 17:45:27'),(3793,'default','payment_edited',880,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1000.0000\"}}','2021-10-19 17:47:17','2021-10-19 17:47:17'),(3794,'default','edited',901,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":1000},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"500.0000\"}}','2021-10-19 17:48:01','2021-10-19 17:48:01'),(3795,'default','added',1022,'App\\Contact',1,4,'App\\User','[]','2021-10-19 17:53:34','2021-10-19 17:53:34'),(3796,'default','payment_edited',880,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1000.0000\"}}','2021-10-19 17:54:47','2021-10-19 17:54:47'),(3797,'default','payment_edited',880,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1000.0000\"}}','2021-10-19 17:55:08','2021-10-19 17:55:08'),(3798,'default','payment_edited',901,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"1000.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"1000.0000\"}}','2021-10-19 17:55:21','2021-10-19 17:55:21'),(3799,'default','edited',901,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"1000.0000\"}}','2021-10-19 17:56:41','2021-10-19 17:56:41'),(3800,'default','payment_edited',901,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"0.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}','2021-10-19 17:57:09','2021-10-19 17:57:09'),(3801,'default','payment_edited',880,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1000.0000\"}}','2021-10-19 17:59:02','2021-10-19 17:59:02'),(3802,'default','added',1023,'App\\Contact',1,4,'App\\User','[]','2021-10-19 18:01:32','2021-10-19 18:01:32'),(3803,'default','edited',901,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":500},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"0.0000\"}}','2021-10-19 18:02:07','2021-10-19 18:02:07'),(3804,'default','added',921,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":575}}','2021-10-19 18:12:07','2021-10-19 18:12:07'),(3805,'default','status_changed',966,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-19 18:12:24','2021-10-19 18:12:24'),(3806,'default','added',922,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-10-19 18:21:33','2021-10-19 18:21:33'),(3807,'default','status_changed',925,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-19 18:22:34','2021-10-19 18:22:34'),(3808,'default','added',923,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-10-19 18:38:30','2021-10-19 18:38:30'),(3809,'default','status_changed',1008,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-19 18:38:48','2021-10-19 18:38:48'),(3810,'default','added',924,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-19 18:41:29','2021-10-19 18:41:29'),(3811,'default','status_changed',1003,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-19 18:43:08','2021-10-19 18:43:08'),(3812,'default','status_changed',1004,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-19 18:43:17','2021-10-19 18:43:17'),(3813,'default','status_changed',1005,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-19 18:44:27','2021-10-19 18:44:27'),(3814,'default','status_changed',896,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-19 18:44:35','2021-10-19 18:44:35'),(3815,'default','added',1024,'App\\Contact',1,4,'App\\User','[]','2021-10-19 18:53:51','2021-10-19 18:53:51'),(3816,'default','added',925,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-10-19 19:04:23','2021-10-19 19:04:23'),(3817,'default','status_changed',996,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-19 19:05:29','2021-10-19 19:05:29'),(3818,'default','added',926,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-10-19 19:22:55','2021-10-19 19:22:55'),(3819,'default','status_changed',1010,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-19 19:23:24','2021-10-19 19:23:24'),(3820,'default','added',927,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}','2021-10-19 19:31:52','2021-10-19 19:31:52'),(3821,'default','status_changed',990,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-19 19:32:38','2021-10-19 19:32:38'),(3822,'default','added',1025,'App\\Contact',1,4,'App\\User','[]','2021-10-19 19:38:31','2021-10-19 19:38:31'),(3823,'default','status_changed',986,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-19 19:47:29','2021-10-19 19:47:29'),(3824,'default','added',928,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1200}}','2021-10-19 19:52:33','2021-10-19 19:52:33'),(3825,'default','status_changed',282,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-19 19:52:54','2021-10-19 19:52:54'),(3826,'default','added',929,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-19 20:07:07','2021-10-19 20:07:07'),(3827,'default','added',930,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-19 20:08:06','2021-10-19 20:08:06'),(3828,'default','added',931,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-19 20:15:20','2021-10-19 20:15:20'),(3829,'default','added',932,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-10-19 20:21:24','2021-10-19 20:21:24'),(3830,'default','status_changed',963,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-19 20:22:04','2021-10-19 20:22:04'),(3831,'default','added',933,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":325}}','2021-10-19 20:46:04','2021-10-19 20:46:04'),(3832,'default','added',934,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-10-19 20:47:08','2021-10-19 20:47:08'),(3833,'default','status_changed',976,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-19 20:48:01','2021-10-19 20:48:01'),(3834,'default','status_changed',985,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-19 20:52:08','2021-10-19 20:52:08'),(3835,'default','added',935,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-10-19 21:14:41','2021-10-19 21:14:41'),(3836,'default','added',936,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-10-19 21:15:12','2021-10-19 21:15:12'),(3837,'default','added',937,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-10-19 21:34:25','2021-10-19 21:34:25'),(3838,'default','status_changed',999,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-19 21:34:40','2021-10-19 21:34:40'),(3839,'default','added',1026,'App\\Contact',1,4,'App\\User','[]','2021-10-19 21:37:56','2021-10-19 21:37:56'),(3840,'default','added',938,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-10-19 21:45:35','2021-10-19 21:45:35'),(3841,'default','status_changed',1006,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-19 21:45:51','2021-10-19 21:45:51'),(3842,'default','added',939,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-10-19 21:54:30','2021-10-19 21:54:30'),(3843,'default','status_changed',954,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-19 21:54:48','2021-10-19 21:54:48'),(3844,'default','added',940,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-10-19 22:26:40','2021-10-19 22:26:40'),(3845,'default','status_changed',1011,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-19 22:26:50','2021-10-19 22:26:50'),(3846,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-20 11:14:42','2021-10-20 11:14:42'),(3847,'default','added',1027,'App\\Contact',1,11,'App\\User','[]','2021-10-20 11:59:03','2021-10-20 11:59:03'),(3848,'default','added',941,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}','2021-10-20 12:54:54','2021-10-20 12:54:54'),(3849,'default','status_changed',1004,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-20 12:55:13','2021-10-20 12:55:13'),(3850,'default','added',942,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":175}}','2021-10-20 14:06:51','2021-10-20 14:06:51'),(3851,'default','status_changed',1007,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-20 14:07:05','2021-10-20 14:07:05'),(3852,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-20 14:41:54','2021-10-20 14:41:54'),(3853,'default','added',1028,'App\\Contact',1,4,'App\\User','[]','2021-10-20 14:44:52','2021-10-20 14:44:52'),(3854,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-20 14:49:58','2021-10-20 14:49:58'),(3855,'default','added',943,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}','2021-10-20 14:50:00','2021-10-20 14:50:00'),(3856,'default','status_changed',910,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-10-20 14:53:15','2021-10-20 14:53:15'),(3857,'default','added',944,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-20 15:00:48','2021-10-20 15:00:48'),(3858,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-20 15:01:14','2021-10-20 15:01:14'),(3859,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-20 15:02:28','2021-10-20 15:02:28'),(3860,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-10-20 15:02:29','2021-10-20 15:02:29'),(3861,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-20 15:02:56','2021-10-20 15:02:56'),(3862,'default','added',1029,'App\\Contact',1,4,'App\\User','[]','2021-10-20 15:28:53','2021-10-20 15:28:53'),(3863,'default','added',1030,'App\\Contact',1,4,'App\\User','[]','2021-10-20 15:41:35','2021-10-20 15:41:35'),(3864,'default','added',1031,'App\\Contact',1,4,'App\\User','[]','2021-10-20 16:09:40','2021-10-20 16:09:40'),(3865,'default','added',1032,'App\\Contact',1,4,'App\\User','[]','2021-10-20 16:19:23','2021-10-20 16:19:23'),(3866,'default','status_changed',932,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-10-20 16:47:56','2021-10-20 16:47:56'),(3867,'default','added',1033,'App\\Contact',1,4,'App\\User','[]','2021-10-20 16:50:10','2021-10-20 16:50:10'),(3868,'default','added',1034,'App\\Contact',1,4,'App\\User','[]','2021-10-20 17:16:39','2021-10-20 17:16:39'),(3869,'default','added',945,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-10-20 17:33:38','2021-10-20 17:33:38'),(3870,'default','status_changed',1021,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-20 17:33:52','2021-10-20 17:33:52'),(3871,'default','added',1035,'App\\Contact',1,4,'App\\User','[]','2021-10-20 17:33:55','2021-10-20 17:33:55'),(3872,'default','status_changed',1017,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-20 17:50:22','2021-10-20 17:50:22'),(3873,'default','status_changed',1019,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-20 17:50:32','2021-10-20 17:50:32'),(3874,'default','status_changed',1015,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-20 17:50:40','2021-10-20 17:50:40'),(3875,'default','status_changed',1014,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-20 17:50:48','2021-10-20 17:50:48'),(3876,'default','status_changed',1012,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-20 17:50:58','2021-10-20 17:50:58'),(3877,'default','added',1036,'App\\Contact',1,4,'App\\User','[]','2021-10-20 17:58:44','2021-10-20 17:58:44'),(3878,'default','added',946,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}','2021-10-20 18:03:56','2021-10-20 18:03:56'),(3879,'default','status_changed',980,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-20 18:10:04','2021-10-20 18:10:04'),(3880,'default','status_changed',932,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-20 18:11:00','2021-10-20 18:11:00'),(3881,'default','status_changed',973,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-20 18:12:56','2021-10-20 18:12:56'),(3882,'default','status_changed',955,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-20 18:14:25','2021-10-20 18:14:25'),(3883,'default','status_changed',762,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-20 18:30:18','2021-10-20 18:30:18'),(3884,'default','added',1037,'App\\Contact',1,4,'App\\User','[]','2021-10-20 18:35:08','2021-10-20 18:35:08'),(3885,'default','added',1038,'App\\Contact',1,4,'App\\User','[]','2021-10-20 19:29:57','2021-10-20 19:29:57'),(3886,'default','added',947,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-10-20 20:04:48','2021-10-20 20:04:48'),(3887,'default','status_changed',983,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-20 20:04:59','2021-10-20 20:04:59'),(3888,'default','added',948,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-20 20:15:37','2021-10-20 20:15:37'),(3889,'default','added',949,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-20 20:16:26','2021-10-20 20:16:26'),(3890,'default','added',950,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-20 20:17:04','2021-10-20 20:17:04'),(3891,'default','added',951,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-20 20:17:45','2021-10-20 20:17:45'),(3892,'default','added',952,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-20 20:18:43','2021-10-20 20:18:43'),(3893,'default','added',953,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-20 20:19:21','2021-10-20 20:19:21'),(3894,'default','added',1039,'App\\Contact',1,11,'App\\User','[]','2021-10-20 20:32:21','2021-10-20 20:32:21'),(3895,'default','added',954,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-10-20 20:39:14','2021-10-20 20:39:14'),(3896,'default','status_changed',1027,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-20 20:39:26','2021-10-20 20:39:26'),(3897,'default','status_changed',1009,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Check In Progress\"}','2021-10-20 20:46:09','2021-10-20 20:46:09'),(3898,'default','added',955,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-10-20 20:47:55','2021-10-20 20:47:55'),(3899,'default','status_changed',1013,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-20 20:48:13','2021-10-20 20:48:13'),(3900,'default','added',1040,'App\\Contact',1,4,'App\\User','[]','2021-10-20 20:54:07','2021-10-20 20:54:07'),(3901,'default','status_changed',970,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-20 21:00:24','2021-10-20 21:00:24'),(3902,'default','added',1041,'App\\Contact',1,4,'App\\User','[]','2021-10-20 21:04:06','2021-10-20 21:04:06'),(3903,'default','added',956,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-10-20 21:07:56','2021-10-20 21:07:56'),(3904,'default','added',957,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-20 21:25:05','2021-10-20 21:25:05'),(3905,'default','added',958,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-10-20 21:55:03','2021-10-20 21:55:03'),(3906,'default','status_changed',1026,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-20 21:55:24','2021-10-20 21:55:24'),(3907,'default','added',1042,'App\\Contact',1,4,'App\\User','[]','2021-10-20 21:59:08','2021-10-20 21:59:08'),(3908,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-20 22:08:06','2021-10-20 22:08:06'),(3909,'default','added',959,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-20 22:22:12','2021-10-20 22:22:12'),(3910,'default','added',960,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-10-20 22:51:36','2021-10-20 22:51:36'),(3911,'default','added',961,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-10-20 22:52:07','2021-10-20 22:52:07'),(3912,'default','status_changed',1019,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-10-20 22:58:40','2021-10-20 22:58:40'),(3913,'default','added',962,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-20 23:00:15','2021-10-20 23:00:15'),(3914,'default','added',963,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-10-20 23:13:20','2021-10-20 23:13:20'),(3915,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-10-20 23:47:58','2021-10-20 23:47:58'),(3916,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-10-20 23:48:10','2021-10-20 23:48:10'),(3917,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-21 11:32:48','2021-10-21 11:32:48'),(3918,'default','added',1043,'App\\Contact',1,11,'App\\User','[]','2021-10-21 12:09:53','2021-10-21 12:09:53'),(3919,'default','added',1044,'App\\Contact',1,11,'App\\User','[]','2021-10-21 12:22:16','2021-10-21 12:22:16'),(3920,'default','status_changed',773,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-10-21 12:27:06','2021-10-21 12:27:06'),(3921,'default','added',1045,'App\\Contact',1,11,'App\\User','[]','2021-10-21 13:14:59','2021-10-21 13:14:59'),(3922,'default','added',964,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":950}}','2021-10-21 13:38:03','2021-10-21 13:38:03'),(3923,'default','added',1046,'App\\Contact',1,11,'App\\User','[]','2021-10-21 14:50:56','2021-10-21 14:50:56'),(3924,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-21 15:26:02','2021-10-21 15:26:02'),(3925,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-21 15:26:11','2021-10-21 15:26:11'),(3926,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-10-21 15:35:33','2021-10-21 15:35:33'),(3927,'default','added',965,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-21 16:01:26','2021-10-21 16:01:26'),(3928,'default','status_changed',965,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-10-21 16:24:02','2021-10-21 16:24:02'),(3929,'default','added',966,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-21 16:25:00','2021-10-21 16:25:00'),(3930,'default','added',967,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-10-21 16:53:01','2021-10-21 16:53:01'),(3931,'default','status_changed',1025,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-21 17:43:45','2021-10-21 17:43:45'),(3932,'default','status_changed',1030,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-21 17:43:56','2021-10-21 17:43:56'),(3933,'default','status_changed',755,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-21 17:45:54','2021-10-21 17:45:54'),(3934,'default','status_changed',778,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-21 17:46:03','2021-10-21 17:46:03'),(3935,'default','status_changed',998,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-21 17:47:53','2021-10-21 17:47:53'),(3936,'default','status_changed',989,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-21 17:48:15','2021-10-21 17:48:15'),(3937,'default','added',968,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-10-21 18:09:58','2021-10-21 18:09:58'),(3938,'default','status_changed',1033,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-21 18:10:17','2021-10-21 18:10:17'),(3939,'default','added',1047,'App\\Contact',1,4,'App\\User','[]','2021-10-21 18:26:16','2021-10-21 18:26:16'),(3940,'default','added',1048,'App\\Contact',1,4,'App\\User','[]','2021-10-21 19:18:12','2021-10-21 19:18:12'),(3941,'default','added',1049,'App\\Contact',1,4,'App\\User','[]','2021-10-21 19:23:15','2021-10-21 19:23:15'),(3942,'default','status_changed',1039,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-21 19:33:03','2021-10-21 19:33:03'),(3943,'default','status_changed',1038,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-21 19:37:27','2021-10-21 19:37:27'),(3944,'default','status_changed',1037,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-21 19:37:52','2021-10-21 19:37:52'),(3945,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-21 19:38:37','2021-10-21 19:38:37'),(3946,'default','added',1050,'App\\Contact',1,4,'App\\User','[]','2021-10-21 19:39:20','2021-10-21 19:39:20'),(3947,'default','added',969,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-21 20:24:33','2021-10-21 20:24:33'),(3948,'default','added',970,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-21 20:25:28','2021-10-21 20:25:28'),(3949,'default','added',971,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-21 20:26:40','2021-10-21 20:26:40'),(3950,'default','added',972,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-10-21 20:38:15','2021-10-21 20:38:15'),(3951,'default','added',973,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-21 20:41:13','2021-10-21 20:41:13'),(3952,'default','status_changed',1036,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-21 20:41:55','2021-10-21 20:41:55'),(3953,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-10-21 20:42:03','2021-10-21 20:42:03'),(3954,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-21 20:45:15','2021-10-21 20:45:15'),(3955,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-21 20:46:27','2021-10-21 20:46:27'),(3956,'default','added',1051,'App\\Contact',1,11,'App\\User','[]','2021-10-21 20:47:43','2021-10-21 20:47:43'),(3957,'default','added',974,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-10-21 20:57:51','2021-10-21 20:57:51'),(3958,'default','status_changed',968,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-21 20:58:03','2021-10-21 20:58:03'),(3959,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-21 21:01:58','2021-10-21 21:01:58'),(3960,'default','added',1052,'App\\Contact',1,4,'App\\User','[]','2021-10-21 21:02:20','2021-10-21 21:02:20'),(3961,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-21 21:04:48','2021-10-21 21:04:48'),(3962,'default','added',975,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-10-21 21:11:56','2021-10-21 21:11:56'),(3963,'default','status_changed',1029,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-21 21:17:23','2021-10-21 21:17:23'),(3964,'default','added',976,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-21 21:27:06','2021-10-21 21:27:06'),(3965,'default','added',977,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-21 21:29:05','2021-10-21 21:29:05'),(3966,'default','logout',20,'App\\User',1,20,'App\\User','[]','2021-10-21 21:40:27','2021-10-21 21:40:27'),(3967,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-10-21 21:42:05','2021-10-21 21:42:05'),(3968,'default','status_changed',1042,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-21 21:46:25','2021-10-21 21:46:25'),(3969,'default','added',978,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-10-21 21:57:15','2021-10-21 21:57:15'),(3970,'default','status_changed',1038,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-21 21:57:31','2021-10-21 21:57:31'),(3971,'default','added',979,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-10-21 21:58:23','2021-10-21 21:58:23'),(3972,'default','status_changed',1041,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-21 21:58:34','2021-10-21 21:58:34'),(3973,'default','added',980,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":850}}','2021-10-21 22:00:03','2021-10-21 22:00:03'),(3974,'default','added',981,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-10-21 22:04:23','2021-10-21 22:04:23'),(3975,'default','status_changed',1039,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-21 22:04:36','2021-10-21 22:04:36'),(3976,'default','added',982,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-10-21 22:07:12','2021-10-21 22:07:12'),(3977,'default','status_changed',1014,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-21 22:07:28','2021-10-21 22:07:28'),(3978,'default','added',1053,'App\\Contact',1,4,'App\\User','[]','2021-10-21 22:22:45','2021-10-21 22:22:45'),(3979,'default','added',983,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":800}}','2021-10-21 22:31:35','2021-10-21 22:31:35'),(3980,'default','added',984,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1200}}','2021-10-21 22:34:44','2021-10-21 22:34:44'),(3981,'default','status_changed',1028,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-21 22:34:53','2021-10-21 22:34:53'),(3982,'default','added',985,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-21 22:38:44','2021-10-21 22:38:44'),(3983,'default','added',986,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-21 22:39:18','2021-10-21 22:39:18'),(3984,'default','added',987,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-21 22:39:59','2021-10-21 22:39:59'),(3985,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-10-21 22:41:28','2021-10-21 22:41:28'),(3986,'default','edited',985,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"}}','2021-10-21 22:41:55','2021-10-21 22:41:55'),(3987,'default','added',988,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-10-21 22:56:51','2021-10-21 22:56:51'),(3988,'default','added',989,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-21 22:58:45','2021-10-21 22:58:45'),(3989,'default','added',990,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-21 23:07:04','2021-10-21 23:07:04'),(3990,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-21 23:07:48','2021-10-21 23:07:48'),(3991,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-21 23:10:10','2021-10-21 23:10:10'),(3992,'default','added',991,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-21 23:24:42','2021-10-21 23:24:42'),(3993,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-10-21 23:33:56','2021-10-21 23:33:56'),(3994,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-22 13:19:55','2021-10-22 13:19:55'),(3995,'default','added',992,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}','2021-10-22 13:46:42','2021-10-22 13:46:42'),(3996,'default','status_changed',1018,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-22 13:46:56','2021-10-22 13:46:56'),(3997,'default','added',1054,'App\\Contact',1,11,'App\\User','[]','2021-10-22 14:41:42','2021-10-22 14:41:42'),(3998,'default','added',993,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}','2021-10-22 15:04:29','2021-10-22 15:04:29'),(3999,'default','status_changed',910,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-22 15:05:04','2021-10-22 15:05:04'),(4000,'default','added',1055,'App\\Contact',1,11,'App\\User','[]','2021-10-22 15:20:43','2021-10-22 15:20:43'),(4001,'default','added',1056,'App\\Contact',1,11,'App\\User','[]','2021-10-22 15:39:13','2021-10-22 15:39:13'),(4002,'default','added',1057,'App\\Contact',1,11,'App\\User','[]','2021-10-22 17:01:45','2021-10-22 17:01:45'),(4003,'default','added',1058,'App\\Contact',1,11,'App\\User','[]','2021-10-22 17:03:32','2021-10-22 17:03:32'),(4004,'default','added',1059,'App\\Contact',1,11,'App\\User','[]','2021-10-22 17:32:23','2021-10-22 17:32:23'),(4005,'default','added',1060,'App\\Contact',1,11,'App\\User','[]','2021-10-22 18:10:11','2021-10-22 18:10:11'),(4006,'default','status_changed',1012,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-10-22 18:20:55','2021-10-22 18:20:55'),(4007,'default','added',994,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":800}}','2021-10-22 18:21:51','2021-10-22 18:21:51'),(4008,'default','added',1061,'App\\Contact',1,11,'App\\User','[]','2021-10-22 19:17:20','2021-10-22 19:17:20'),(4009,'default','added',1062,'App\\Contact',1,11,'App\\User','[]','2021-10-22 19:23:56','2021-10-22 19:23:56'),(4010,'default','added',995,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":550}}','2021-10-22 19:40:31','2021-10-22 19:40:31'),(4011,'default','added',996,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":75}}','2021-10-22 19:44:39','2021-10-22 19:44:39'),(4012,'default','added',1063,'App\\Contact',1,11,'App\\User','[]','2021-10-22 20:18:13','2021-10-22 20:18:13'),(4013,'default','added',997,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":850}}','2021-10-22 22:37:55','2021-10-22 22:37:55'),(4014,'default','status_changed',988,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-22 22:42:23','2021-10-22 22:42:23'),(4015,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-22 23:18:19','2021-10-22 23:18:19'),(4016,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-23 00:32:07','2021-10-23 00:32:07'),(4017,'default','added',1064,'App\\Contact',1,1,'App\\User','[]','2021-10-23 00:34:52','2021-10-23 00:34:52'),(4018,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-23 11:38:50','2021-10-23 11:38:50'),(4019,'default','added',1065,'App\\Contact',1,11,'App\\User','[]','2021-10-23 12:07:07','2021-10-23 12:07:07'),(4020,'default','added',1066,'App\\Contact',1,11,'App\\User','[]','2021-10-23 12:17:47','2021-10-23 12:17:47'),(4021,'default','added',1067,'App\\Contact',1,11,'App\\User','[]','2021-10-23 13:47:18','2021-10-23 13:47:18'),(4022,'default','added',1068,'App\\Contact',1,11,'App\\User','[]','2021-10-23 14:08:01','2021-10-23 14:08:01'),(4023,'default','added',1069,'App\\Contact',1,11,'App\\User','[]','2021-10-23 14:13:08','2021-10-23 14:13:08'),(4024,'default','added',1070,'App\\Contact',1,11,'App\\User','[]','2021-10-23 14:20:09','2021-10-23 14:20:09'),(4025,'default','added',998,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-10-23 14:53:39','2021-10-23 14:53:39'),(4026,'default','added',1071,'App\\Contact',1,11,'App\\User','[]','2021-10-23 14:54:11','2021-10-23 14:54:11'),(4027,'default','status_changed',1015,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-23 14:57:34','2021-10-23 14:57:34'),(4028,'default','added',1072,'App\\Contact',1,11,'App\\User','[]','2021-10-23 15:21:50','2021-10-23 15:21:50'),(4029,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-23 15:48:25','2021-10-23 15:48:25'),(4030,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-23 15:48:35','2021-10-23 15:48:35'),(4031,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-10-23 15:57:29','2021-10-23 15:57:29'),(4032,'default','status_changed',1066,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-23 15:59:34','2021-10-23 15:59:34'),(4033,'default','status_changed',1067,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-23 15:59:44','2021-10-23 15:59:44'),(4034,'default','status_changed',1064,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-23 16:00:05','2021-10-23 16:00:05'),(4035,'default','status_changed',1065,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-23 16:00:15','2021-10-23 16:00:15'),(4036,'default','status_changed',1062,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-23 16:00:46','2021-10-23 16:00:46'),(4037,'default','status_changed',1061,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-23 16:01:05','2021-10-23 16:01:05'),(4038,'default','status_changed',1060,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-23 16:01:20','2021-10-23 16:01:20'),(4039,'default','status_changed',1054,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-23 16:02:14','2021-10-23 16:02:14'),(4040,'default','status_changed',1054,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-10-23 16:03:16','2021-10-23 16:03:16'),(4041,'default','status_changed',1063,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-23 16:03:37','2021-10-23 16:03:37'),(4042,'default','status_changed',1044,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-23 16:04:13','2021-10-23 16:04:13'),(4043,'default','logout',20,'App\\User',1,20,'App\\User','[]','2021-10-23 16:17:57','2021-10-23 16:17:57'),(4044,'default','added',1073,'App\\Contact',1,4,'App\\User','[]','2021-10-23 16:18:33','2021-10-23 16:18:33'),(4045,'default','logout',20,'App\\User',1,20,'App\\User','[]','2021-10-23 16:19:58','2021-10-23 16:19:58'),(4046,'default','logout',20,'App\\User',1,20,'App\\User','[]','2021-10-23 16:20:11','2021-10-23 16:20:11'),(4047,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-23 16:20:21','2021-10-23 16:20:21'),(4048,'default','status_changed',1046,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-23 16:25:16','2021-10-23 16:25:16'),(4049,'default','status_changed',1056,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-23 16:25:24','2021-10-23 16:25:24'),(4050,'default','status_changed',1068,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-23 16:25:31','2021-10-23 16:25:31'),(4051,'default','status_changed',1050,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-23 16:25:39','2021-10-23 16:25:39'),(4052,'default','status_changed',1043,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-23 16:25:46','2021-10-23 16:25:46'),(4053,'default','status_changed',1048,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-23 16:25:58','2021-10-23 16:25:58'),(4054,'default','added',1074,'App\\Contact',1,4,'App\\User','[]','2021-10-23 16:30:36','2021-10-23 16:30:36'),(4055,'default','added',1075,'App\\Contact',1,4,'App\\User','[]','2021-10-23 16:45:40','2021-10-23 16:45:40'),(4056,'default','status_changed',917,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-23 17:07:21','2021-10-23 17:07:21'),(4057,'default','edited',977,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"}}','2021-10-23 17:23:36','2021-10-23 17:23:36'),(4058,'default','added',999,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-10-23 17:44:40','2021-10-23 17:44:40'),(4059,'default','status_changed',1071,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-23 17:45:09','2021-10-23 17:45:09'),(4060,'default','status_changed',919,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-23 17:49:53','2021-10-23 17:49:53'),(4061,'default','added',1000,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-10-23 17:56:34','2021-10-23 17:56:34'),(4062,'default','status_changed',1072,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-23 17:57:32','2021-10-23 17:57:32'),(4063,'default','added',1076,'App\\Contact',1,4,'App\\User','[]','2021-10-23 18:03:11','2021-10-23 18:03:11'),(4064,'default','added',1077,'App\\Contact',1,11,'App\\User','[]','2021-10-23 18:16:14','2021-10-23 18:16:14'),(4065,'default','added',1078,'App\\Contact',1,4,'App\\User','[]','2021-10-23 18:19:06','2021-10-23 18:19:06'),(4066,'default','added',1079,'App\\Contact',1,4,'App\\User','[]','2021-10-23 18:20:35','2021-10-23 18:20:35'),(4067,'default','status_changed',1051,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-23 18:47:01','2021-10-23 18:47:01'),(4068,'default','status_changed',1052,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-23 18:47:10','2021-10-23 18:47:10'),(4069,'default','added',1001,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-23 18:55:58','2021-10-23 18:55:58'),(4070,'default','added',1002,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-23 18:56:38','2021-10-23 18:56:38'),(4071,'default','added',1003,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-23 19:01:18','2021-10-23 19:01:18'),(4072,'default','added',1004,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-23 19:01:55','2021-10-23 19:01:55'),(4073,'default','added',1080,'App\\Contact',1,4,'App\\User','[]','2021-10-23 19:11:38','2021-10-23 19:11:38'),(4074,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-23 19:37:26','2021-10-23 19:37:26'),(4075,'default','added',1005,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-10-23 19:40:35','2021-10-23 19:40:35'),(4076,'default','status_changed',1053,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-23 19:40:49','2021-10-23 19:40:49'),(4077,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-10-23 19:41:02','2021-10-23 19:41:02'),(4078,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-23 19:41:41','2021-10-23 19:41:41'),(4079,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-23 19:43:57','2021-10-23 19:43:57'),(4080,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-23 19:44:34','2021-10-23 19:44:34'),(4081,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-23 19:45:11','2021-10-23 19:45:11'),(4082,'default','added',1081,'App\\Contact',1,4,'App\\User','[]','2021-10-23 20:07:18','2021-10-23 20:07:18'),(4083,'default','status_changed',1050,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-23 20:29:38','2021-10-23 20:29:38'),(4084,'default','added',1006,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-10-23 20:56:53','2021-10-23 20:56:53'),(4085,'default','status_changed',987,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-23 20:57:15','2021-10-23 20:57:15'),(4086,'default','added',1007,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-10-23 20:58:41','2021-10-23 20:58:41'),(4087,'default','status_changed',1070,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-23 20:58:52','2021-10-23 20:58:52'),(4088,'default','added',1008,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-23 21:00:43','2021-10-23 21:00:43'),(4089,'default','added',1009,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-23 21:02:55','2021-10-23 21:02:55'),(4090,'default','added',1010,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-10-23 21:37:24','2021-10-23 21:37:24'),(4091,'default','status_changed',1054,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-23 21:37:36','2021-10-23 21:37:36'),(4092,'default','added',1011,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-10-23 21:38:44','2021-10-23 21:38:44'),(4093,'default','status_changed',1037,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-23 21:38:56','2021-10-23 21:38:56'),(4094,'default','edited',1001,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"}}','2021-10-23 22:06:27','2021-10-23 22:06:27'),(4095,'default','payment_edited',1001,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"},\"old\":{\"payment_status\":\"partial\"}}','2021-10-23 22:06:45','2021-10-23 22:06:45'),(4096,'default','added',1012,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-23 22:07:43','2021-10-23 22:07:43'),(4097,'default','added',1013,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-23 22:21:21','2021-10-23 22:21:21'),(4098,'default','added',1014,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-10-23 22:29:10','2021-10-23 22:29:10'),(4099,'default','status_changed',1023,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-23 22:29:25','2021-10-23 22:29:25'),(4100,'default','added',1015,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-10-23 22:30:22','2021-10-23 22:30:22'),(4101,'default','status_changed',1078,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-23 22:30:31','2021-10-23 22:30:31'),(4102,'default','status_changed',1043,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-23 23:10:32','2021-10-23 23:10:32'),(4103,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-10-23 23:13:38','2021-10-23 23:13:38'),(4104,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-24 11:31:59','2021-10-24 11:31:59'),(4105,'default','added',1016,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-10-24 13:51:11','2021-10-24 13:51:11'),(4106,'default','status_changed',993,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-24 13:51:32','2021-10-24 13:51:32'),(4107,'default','added',1017,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-10-24 14:43:47','2021-10-24 14:43:47'),(4108,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-24 15:15:20','2021-10-24 15:15:20'),(4109,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-24 15:15:29','2021-10-24 15:15:29'),(4110,'default','added',1018,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":200}}','2021-10-24 15:16:53','2021-10-24 15:16:53'),(4111,'default','status_changed',802,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-24 15:21:09','2021-10-24 15:21:09'),(4112,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-24 15:28:50','2021-10-24 15:28:50'),(4113,'default','added',1082,'App\\Contact',1,4,'App\\User','[]','2021-10-24 16:13:47','2021-10-24 16:13:47'),(4114,'default','added',1019,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-24 16:32:44','2021-10-24 16:32:44'),(4115,'default','added',1020,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-10-24 16:51:17','2021-10-24 16:51:17'),(4116,'default','status_changed',1068,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-24 16:55:01','2021-10-24 16:55:01'),(4117,'default','status_changed',1058,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-24 17:02:45','2021-10-24 17:02:45'),(4118,'default','added',1083,'App\\Contact',1,4,'App\\User','[]','2021-10-24 17:03:11','2021-10-24 17:03:11'),(4119,'default','added',1021,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-10-24 17:11:46','2021-10-24 17:11:46'),(4120,'default','status_changed',1073,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-24 17:11:59','2021-10-24 17:11:59'),(4121,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-24 17:26:27','2021-10-24 17:26:27'),(4122,'default','payment_edited',983,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"800.0000\"}}','2021-10-24 17:27:50','2021-10-24 17:27:50'),(4123,'default','added',1084,'App\\Contact',1,4,'App\\User','[]','2021-10-24 17:40:28','2021-10-24 17:40:28'),(4124,'default','added',1085,'App\\Contact',1,11,'App\\User','[]','2021-10-24 17:57:19','2021-10-24 17:57:19'),(4125,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-10-24 18:25:04','2021-10-24 18:25:04'),(4126,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-24 18:25:16','2021-10-24 18:25:16'),(4127,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-24 18:25:34','2021-10-24 18:25:34'),(4128,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-24 18:25:44','2021-10-24 18:25:44'),(4129,'default','added',1086,'App\\Contact',1,11,'App\\User','[]','2021-10-24 18:29:05','2021-10-24 18:29:05'),(4130,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-24 18:33:32','2021-10-24 18:33:32'),(4131,'default','status_changed',1003,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-24 18:42:05','2021-10-24 18:42:05'),(4132,'default','added',1022,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-24 18:44:02','2021-10-24 18:44:02'),(4133,'default','added',1023,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-10-24 19:03:44','2021-10-24 19:03:44'),(4134,'default','status_changed',1048,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-24 19:03:56','2021-10-24 19:03:56'),(4135,'default','added',1024,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-24 19:29:30','2021-10-24 19:29:30'),(4136,'default','added',1025,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-24 19:30:06','2021-10-24 19:30:06'),(4137,'default','added',1026,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-10-24 19:39:20','2021-10-24 19:39:20'),(4138,'default','status_changed',1084,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-24 19:39:31','2021-10-24 19:39:31'),(4139,'default','status_changed',919,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-24 19:45:06','2021-10-24 19:45:06'),(4140,'default','added',1027,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-10-24 19:47:07','2021-10-24 19:47:07'),(4141,'default','status_changed',1040,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-24 19:47:30','2021-10-24 19:47:30'),(4142,'default','added',1087,'App\\Contact',1,4,'App\\User','[]','2021-10-24 19:50:56','2021-10-24 19:50:56'),(4143,'default','added',1088,'App\\Contact',1,4,'App\\User','[]','2021-10-24 20:23:36','2021-10-24 20:23:36'),(4144,'default','status_changed',915,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-24 20:36:14','2021-10-24 20:36:14'),(4145,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-24 21:12:56','2021-10-24 21:12:56'),(4146,'default','added',1028,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-10-24 21:58:50','2021-10-24 21:58:50'),(4147,'default','status_changed',1079,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-24 21:59:20','2021-10-24 21:59:20'),(4148,'default','added',1029,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-10-24 22:25:13','2021-10-24 22:25:13'),(4149,'default','added',1030,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-24 22:31:02','2021-10-24 22:31:02'),(4150,'default','added',1031,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-24 22:31:37','2021-10-24 22:31:37'),(4151,'default','status_changed',1034,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-24 22:45:06','2021-10-24 22:45:06'),(4152,'default','added',1089,'App\\Contact',1,4,'App\\User','[]','2021-10-24 23:10:19','2021-10-24 23:10:19'),(4153,'default','added',1032,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-24 23:16:47','2021-10-24 23:16:47'),(4154,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-10-24 23:16:54','2021-10-24 23:16:54'),(4155,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-25 11:34:43','2021-10-25 11:34:43'),(4156,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-25 11:40:53','2021-10-25 11:40:53'),(4157,'default','added',1090,'App\\Contact',1,11,'App\\User','[]','2021-10-25 11:59:41','2021-10-25 11:59:41'),(4158,'default','added',1091,'App\\Contact',1,11,'App\\User','[]','2021-10-25 12:00:31','2021-10-25 12:00:31'),(4159,'default','added',1092,'App\\Contact',1,11,'App\\User','[]','2021-10-25 12:05:35','2021-10-25 12:05:35'),(4160,'default','added',1093,'App\\Contact',1,11,'App\\User','[]','2021-10-25 12:05:35','2021-10-25 12:05:35'),(4161,'default','status_changed',896,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-25 12:31:38','2021-10-25 12:31:38'),(4162,'default','added',1033,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}','2021-10-25 12:37:55','2021-10-25 12:37:55'),(4163,'default','status_changed',1056,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-25 12:38:28','2021-10-25 12:38:28'),(4164,'default','added',1094,'App\\Contact',1,11,'App\\User','[]','2021-10-25 13:01:21','2021-10-25 13:01:21'),(4165,'default','added',1034,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-10-25 13:16:00','2021-10-25 13:16:00'),(4166,'default','status_changed',1081,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-25 13:16:12','2021-10-25 13:16:12'),(4167,'default','added',1095,'App\\Contact',1,11,'App\\User','[]','2021-10-25 13:26:23','2021-10-25 13:26:23'),(4168,'default','added',1096,'App\\Contact',1,11,'App\\User','[]','2021-10-25 14:15:24','2021-10-25 14:15:24'),(4169,'default','added',1035,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-10-25 14:17:20','2021-10-25 14:17:20'),(4170,'default','status_changed',710,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-25 14:38:15','2021-10-25 14:38:15'),(4171,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-25 14:51:29','2021-10-25 14:51:29'),(4172,'default','payment_edited',896,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"300.0000\"}}','2021-10-25 14:52:57','2021-10-25 14:52:57'),(4173,'default','payment_edited',964,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"950.0000\"}}','2021-10-25 14:54:39','2021-10-25 14:54:39'),(4174,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-25 14:56:06','2021-10-25 14:56:06'),(4175,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-25 14:56:15','2021-10-25 14:56:15'),(4176,'default','added',1036,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-25 14:57:29','2021-10-25 14:57:29'),(4177,'default','added',1097,'App\\Contact',1,4,'App\\User','[]','2021-10-25 15:06:58','2021-10-25 15:06:58'),(4178,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-25 15:08:22','2021-10-25 15:08:22'),(4179,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-25 15:09:28','2021-10-25 15:09:28'),(4180,'default','added',1098,'App\\Contact',1,4,'App\\User','[]','2021-10-25 15:28:04','2021-10-25 15:28:04'),(4181,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-25 15:30:28','2021-10-25 15:30:28'),(4182,'default','added',1037,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-25 15:35:04','2021-10-25 15:35:04'),(4183,'default','added',1038,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-25 15:35:46','2021-10-25 15:35:46'),(4184,'default','status_changed',964,'App\\Transaction',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-25 15:42:04','2021-10-25 15:42:04'),(4185,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-25 15:45:41','2021-10-25 15:45:41'),(4186,'default','added',1039,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-25 15:46:12','2021-10-25 15:46:12'),(4187,'default','added',1099,'App\\Contact',1,4,'App\\User','[]','2021-10-25 16:07:09','2021-10-25 16:07:09'),(4188,'default','added',1040,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-10-25 16:07:40','2021-10-25 16:07:40'),(4189,'default','added',1100,'App\\Contact',1,4,'App\\User','[]','2021-10-25 16:41:03','2021-10-25 16:41:03'),(4190,'default','added',1101,'App\\Contact',1,4,'App\\User','[]','2021-10-25 16:43:35','2021-10-25 16:43:35'),(4191,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-10-25 17:00:08','2021-10-25 17:00:08'),(4192,'default','status_changed',1025,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-25 17:13:04','2021-10-25 17:13:04'),(4193,'default','status_changed',965,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-25 17:16:22','2021-10-25 17:16:22'),(4194,'default','added',1102,'App\\Contact',1,4,'App\\User','[]','2021-10-25 17:17:09','2021-10-25 17:17:09'),(4195,'default','status_changed',1093,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-25 17:17:50','2021-10-25 17:17:50'),(4196,'default','status_changed',1090,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-25 17:18:01','2021-10-25 17:18:01'),(4197,'default','status_changed',1091,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-25 17:18:09','2021-10-25 17:18:09'),(4198,'default','status_changed',1087,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-25 17:20:24','2021-10-25 17:20:24'),(4199,'default','added',1041,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-10-25 17:21:34','2021-10-25 17:21:34'),(4200,'default','added',1042,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-25 17:41:24','2021-10-25 17:41:24'),(4201,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-10-25 17:50:30','2021-10-25 17:50:30'),(4202,'default','status_changed',915,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-10-25 17:50:42','2021-10-25 17:50:42'),(4203,'default','status_changed',915,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-25 18:00:26','2021-10-25 18:00:26'),(4204,'default','added',1043,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-10-25 18:09:53','2021-10-25 18:09:53'),(4205,'default','status_changed',1055,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-25 18:10:07','2021-10-25 18:10:07'),(4206,'default','added',1044,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":175}}','2021-10-25 18:20:13','2021-10-25 18:20:13'),(4207,'default','status_changed',1090,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-25 18:21:02','2021-10-25 18:21:02'),(4208,'default','status_changed',1020,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-25 18:54:35','2021-10-25 18:54:35'),(4209,'default','edited',1044,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"175.0000\"}}','2021-10-25 18:56:29','2021-10-25 18:56:29'),(4210,'default','added',1103,'App\\Contact',1,4,'App\\User','[]','2021-10-25 19:00:44','2021-10-25 19:00:44'),(4211,'default','status_changed',1086,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-25 19:04:43','2021-10-25 19:04:43'),(4212,'default','status_changed',1089,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-25 19:14:19','2021-10-25 19:14:19'),(4213,'default','added',1045,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-25 19:17:27','2021-10-25 19:17:27'),(4214,'default','status_changed',1052,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-25 19:33:48','2021-10-25 19:33:48'),(4215,'default','status_changed',1100,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-25 19:44:51','2021-10-25 19:44:51'),(4216,'default','added',1046,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-25 19:46:26','2021-10-25 19:46:26'),(4217,'default','status_changed',1097,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-10-25 20:36:05','2021-10-25 20:36:05'),(4218,'default','status_changed',1012,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-25 21:05:00','2021-10-25 21:05:00'),(4219,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-25 21:09:22','2021-10-25 21:09:22'),(4220,'default','added',1104,'App\\Contact',1,11,'App\\User','[]','2021-10-25 21:10:06','2021-10-25 21:10:06'),(4221,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-25 21:14:13','2021-10-25 21:14:13'),(4222,'default','added',1105,'App\\Contact',1,4,'App\\User','[]','2021-10-25 21:23:28','2021-10-25 21:23:28'),(4223,'default','added',1047,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2500}}','2021-10-25 21:35:40','2021-10-25 21:35:40'),(4224,'default','status_changed',784,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-25 21:37:10','2021-10-25 21:37:10'),(4225,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-25 21:42:14','2021-10-25 21:42:14'),(4226,'default','added',1048,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-10-25 21:43:55','2021-10-25 21:43:55'),(4227,'default','status_changed',1096,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-25 21:44:06','2021-10-25 21:44:06'),(4228,'default','added',1049,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-10-25 21:44:46','2021-10-25 21:44:46'),(4229,'default','status_changed',1097,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-25 21:44:58','2021-10-25 21:44:58'),(4230,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-25 21:45:06','2021-10-25 21:45:06'),(4231,'default','added',1050,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-25 21:48:13','2021-10-25 21:48:13'),(4232,'default','status_changed',1045,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-25 21:51:27','2021-10-25 21:51:27'),(4233,'default','added',1051,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-25 21:54:27','2021-10-25 21:54:27'),(4234,'default','added',1052,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-25 21:55:03','2021-10-25 21:55:03'),(4235,'default','added',1053,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}','2021-10-25 22:10:09','2021-10-25 22:10:09'),(4236,'default','edited',1042,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"}}','2021-10-25 22:18:03','2021-10-25 22:18:03'),(4237,'default','payment_edited',1042,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"},\"old\":{\"payment_status\":\"partial\"}}','2021-10-25 22:18:23','2021-10-25 22:18:23'),(4238,'default','added',1054,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-25 22:27:01','2021-10-25 22:27:01'),(4239,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-26 11:04:51','2021-10-26 11:04:51'),(4240,'default','status_changed',1101,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-26 11:07:40','2021-10-26 11:07:40'),(4241,'default','added',1106,'App\\Contact',1,11,'App\\User','[]','2021-10-26 11:40:04','2021-10-26 11:40:04'),(4242,'default','status_changed',1000,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-26 12:37:05','2021-10-26 12:37:05'),(4243,'default','status_changed',1001,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-26 12:37:12','2021-10-26 12:37:12'),(4244,'default','status_changed',773,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-26 12:59:48','2021-10-26 12:59:48'),(4245,'default','added',1055,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-10-26 13:22:21','2021-10-26 13:22:21'),(4246,'default','status_changed',1032,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-26 13:22:40','2021-10-26 13:22:40'),(4247,'default','added',1107,'App\\Contact',1,11,'App\\User','[]','2021-10-26 13:45:29','2021-10-26 13:45:29'),(4248,'default','added',1108,'App\\Contact',1,11,'App\\User','[]','2021-10-26 13:49:53','2021-10-26 13:49:53'),(4249,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-26 14:27:50','2021-10-26 14:27:50'),(4250,'default','added',1056,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-10-26 14:43:41','2021-10-26 14:43:41'),(4251,'default','status_changed',1069,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-26 14:44:19','2021-10-26 14:44:19'),(4252,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-26 14:49:54','2021-10-26 14:49:54'),(4253,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-10-26 14:53:29','2021-10-26 14:53:29'),(4254,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-26 14:53:39','2021-10-26 14:53:39'),(4255,'default','added',1057,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-10-26 14:57:28','2021-10-26 14:57:28'),(4256,'default','status_changed',1044,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-26 15:01:43','2021-10-26 15:01:43'),(4257,'default','added',1058,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-26 15:07:12','2021-10-26 15:07:12'),(4258,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-26 15:15:47','2021-10-26 15:15:47'),(4259,'default','added',1059,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1200}}','2021-10-26 15:18:54','2021-10-26 15:18:54'),(4260,'default','status_changed',1074,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-26 15:19:22','2021-10-26 15:19:22'),(4261,'default','added',1060,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-26 15:22:38','2021-10-26 15:22:38'),(4262,'default','payment_edited',996,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"75.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"75.0000\"}}','2021-10-26 15:23:57','2021-10-26 15:23:57'),(4263,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-10-26 15:26:24','2021-10-26 15:26:24'),(4264,'default','added',1061,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-10-26 15:46:24','2021-10-26 15:46:24'),(4265,'default','status_changed',651,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-26 15:46:34','2021-10-26 15:46:34'),(4266,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-26 16:01:15','2021-10-26 16:01:15'),(4267,'default','added',1062,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-10-26 16:07:08','2021-10-26 16:07:08'),(4268,'default','status_changed',1075,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-26 16:07:21','2021-10-26 16:07:21'),(4269,'default','added',1063,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}','2021-10-26 16:07:41','2021-10-26 16:07:41'),(4270,'default','status_changed',1076,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-26 16:08:03','2021-10-26 16:08:03'),(4271,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-26 16:11:45','2021-10-26 16:11:45'),(4272,'default','added',1109,'App\\Contact',1,4,'App\\User','[]','2021-10-26 16:20:26','2021-10-26 16:20:26'),(4273,'default','status_changed',1104,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-26 16:21:15','2021-10-26 16:21:15'),(4274,'default','added',1110,'App\\Contact',1,4,'App\\User','[]','2021-10-26 16:24:14','2021-10-26 16:24:14'),(4275,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-10-26 16:26:39','2021-10-26 16:26:39'),(4276,'default','added',1111,'App\\Contact',1,20,'App\\User','[]','2021-10-26 16:30:41','2021-10-26 16:30:41'),(4277,'default','added',1112,'App\\Contact',1,4,'App\\User','[]','2021-10-26 16:32:14','2021-10-26 16:32:14'),(4278,'default','status_changed',1109,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-26 16:41:54','2021-10-26 16:41:54'),(4279,'default','status_changed',1110,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-26 16:42:04','2021-10-26 16:42:04'),(4280,'default','added',1064,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600}}','2021-10-26 17:15:01','2021-10-26 17:15:01'),(4281,'default','status_changed',1088,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-26 17:15:21','2021-10-26 17:15:21'),(4282,'default','added',1065,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-10-26 17:16:25','2021-10-26 17:16:25'),(4283,'default','status_changed',1094,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-26 17:16:36','2021-10-26 17:16:36'),(4284,'default','added',1066,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":175}}','2021-10-26 17:20:08','2021-10-26 17:20:08'),(4285,'default','status_changed',1091,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-26 17:20:31','2021-10-26 17:20:31'),(4286,'default','added',1113,'App\\Contact',1,4,'App\\User','[]','2021-10-26 17:33:19','2021-10-26 17:33:19'),(4287,'default','status_changed',1012,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-10-26 18:07:48','2021-10-26 18:07:48'),(4288,'default','added',1114,'App\\Contact',1,4,'App\\User','[]','2021-10-26 18:10:50','2021-10-26 18:10:50'),(4289,'default','added',1115,'App\\Contact',1,4,'App\\User','[]','2021-10-26 18:20:43','2021-10-26 18:20:43'),(4290,'default','added',1067,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-10-26 18:30:28','2021-10-26 18:30:28'),(4291,'default','added',1068,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-10-26 18:33:14','2021-10-26 18:33:14'),(4292,'default','status_changed',991,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-26 18:33:25','2021-10-26 18:33:25'),(4293,'default','status_changed',1101,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-26 18:42:25','2021-10-26 18:42:25'),(4294,'default','status_changed',1103,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-26 18:42:32','2021-10-26 18:42:32'),(4295,'default','status_changed',1104,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-26 18:42:40','2021-10-26 18:42:40'),(4296,'default','status_changed',1110,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-26 18:42:48','2021-10-26 18:42:48'),(4297,'default','status_changed',1109,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-26 18:43:03','2021-10-26 18:43:03'),(4298,'default','status_changed',1095,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-26 18:43:11','2021-10-26 18:43:11'),(4299,'default','status_changed',1098,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-26 18:43:18','2021-10-26 18:43:18'),(4300,'default','added',1069,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}','2021-10-26 18:51:25','2021-10-26 18:51:25'),(4301,'default','status_changed',1092,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-26 18:51:46','2021-10-26 18:51:46'),(4302,'default','added',1070,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}','2021-10-26 18:52:25','2021-10-26 18:52:25'),(4303,'default','status_changed',1035,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-26 18:52:39','2021-10-26 18:52:39'),(4304,'default','logout',20,'App\\User',1,20,'App\\User','[]','2021-10-26 18:53:43','2021-10-26 18:53:43'),(4305,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-26 18:53:55','2021-10-26 18:53:55'),(4306,'default','added',1071,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":300}}','2021-10-26 18:55:18','2021-10-26 18:55:18'),(4307,'default','added',1072,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-26 19:04:00','2021-10-26 19:04:00'),(4308,'default','added',1073,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-26 19:04:39','2021-10-26 19:04:39'),(4309,'default','status_changed',1047,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-26 19:05:36','2021-10-26 19:05:36'),(4310,'default','added',1074,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-26 19:07:10','2021-10-26 19:07:10'),(4311,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-10-26 19:07:37','2021-10-26 19:07:37'),(4312,'default','added',1075,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-26 19:12:23','2021-10-26 19:12:23'),(4313,'default','status_changed',1093,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-26 19:15:16','2021-10-26 19:15:16'),(4314,'default','status_changed',1035,'App\\Transaction',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-26 19:15:34','2021-10-26 19:15:34'),(4315,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-26 19:26:52','2021-10-26 19:26:52'),(4316,'default','added',1076,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-10-26 19:29:36','2021-10-26 19:29:36'),(4317,'default','status_changed',1099,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-26 19:32:33','2021-10-26 19:32:33'),(4318,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-26 19:33:56','2021-10-26 19:33:56'),(4319,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-26 19:34:09','2021-10-26 19:34:09'),(4320,'default','added',1077,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":625}}','2021-10-26 19:34:21','2021-10-26 19:34:21'),(4321,'default','status_changed',1098,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-26 19:34:50','2021-10-26 19:34:50'),(4322,'default','added',1116,'App\\Contact',1,4,'App\\User','[]','2021-10-26 20:12:17','2021-10-26 20:12:17'),(4323,'default','status_changed',1115,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-26 20:28:43','2021-10-26 20:28:43'),(4324,'default','status_changed',1116,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-26 20:28:57','2021-10-26 20:28:57'),(4325,'default','added',1117,'App\\Contact',1,4,'App\\User','[]','2021-10-26 20:32:42','2021-10-26 20:32:42'),(4326,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-26 20:33:07','2021-10-26 20:33:07'),(4327,'default','added',1078,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-10-26 20:38:02','2021-10-26 20:38:02'),(4328,'default','status_changed',1107,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-26 20:38:20','2021-10-26 20:38:20'),(4329,'default','added',1079,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":650}}','2021-10-26 20:39:01','2021-10-26 20:39:01'),(4330,'default','status_changed',1104,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-26 20:39:16','2021-10-26 20:39:16'),(4331,'default','added',1118,'App\\Contact',1,4,'App\\User','[]','2021-10-26 20:42:58','2021-10-26 20:42:58'),(4332,'default','added',1080,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-10-26 20:46:41','2021-10-26 20:46:41'),(4333,'default','added',1081,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-26 21:55:48','2021-10-26 21:55:48'),(4334,'default','added',1082,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}','2021-10-26 22:06:12','2021-10-26 22:06:12'),(4335,'default','status_changed',1012,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-26 22:07:11','2021-10-26 22:07:11'),(4336,'default','added',1083,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-26 22:12:24','2021-10-26 22:12:24'),(4337,'default','status_changed',1083,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-26 22:13:38','2021-10-26 22:13:38'),(4338,'default','added',1084,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-26 22:22:37','2021-10-26 22:22:37'),(4339,'default','added',1085,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-26 22:51:50','2021-10-26 22:51:50'),(4340,'default','added',1119,'App\\Contact',1,4,'App\\User','[]','2021-10-26 22:54:11','2021-10-26 22:54:11'),(4341,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-26 23:32:02','2021-10-26 23:32:02'),(4342,'default','added',1120,'App\\Contact',1,4,'App\\User','[]','2021-10-26 23:35:00','2021-10-26 23:35:00'),(4343,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-27 11:19:55','2021-10-27 11:19:55'),(4344,'default','added',1121,'App\\Contact',1,11,'App\\User','[]','2021-10-27 13:28:19','2021-10-27 13:28:19'),(4345,'default','added',1122,'App\\Contact',1,11,'App\\User','[]','2021-10-27 13:51:48','2021-10-27 13:51:48'),(4346,'default','added',1123,'App\\Contact',1,11,'App\\User','[]','2021-10-27 13:58:02','2021-10-27 13:58:02'),(4347,'default','added',1124,'App\\Contact',1,11,'App\\User','[]','2021-10-27 14:05:52','2021-10-27 14:05:52'),(4348,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-27 14:08:08','2021-10-27 14:08:08'),(4349,'default','added',1125,'App\\Contact',1,11,'App\\User','[]','2021-10-27 14:17:13','2021-10-27 14:17:13'),(4350,'default','added',1126,'App\\Contact',1,11,'App\\User','[]','2021-10-27 14:18:26','2021-10-27 14:18:26'),(4351,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-27 14:22:44','2021-10-27 14:22:44'),(4352,'default','added',1127,'App\\Contact',1,11,'App\\User','[]','2021-10-27 14:25:44','2021-10-27 14:25:44'),(4353,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-27 14:55:53','2021-10-27 14:55:53'),(4354,'default','status_changed',1124,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-27 14:56:12','2021-10-27 14:56:12'),(4355,'default','status_changed',1126,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-27 14:56:22','2021-10-27 14:56:22'),(4356,'default','status_changed',1125,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-27 14:59:28','2021-10-27 14:59:28'),(4357,'default','status_changed',1127,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-27 15:02:27','2021-10-27 15:02:27'),(4358,'default','status_changed',1115,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-27 15:10:49','2021-10-27 15:10:49'),(4359,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-27 15:14:47','2021-10-27 15:14:47'),(4360,'default','added',1128,'App\\Contact',1,4,'App\\User','[]','2021-10-27 15:15:45','2021-10-27 15:15:45'),(4361,'default','added',1086,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-10-27 15:26:37','2021-10-27 15:26:37'),(4362,'default','status_changed',1103,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-27 15:29:58','2021-10-27 15:29:58'),(4363,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-27 15:33:06','2021-10-27 15:33:06'),(4364,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-27 15:33:16','2021-10-27 15:33:16'),(4365,'default','added',1087,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-27 15:35:23','2021-10-27 15:35:23'),(4366,'default','added',1088,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-10-27 15:45:59','2021-10-27 15:45:59'),(4367,'default','status_changed',1108,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-27 15:46:13','2021-10-27 15:46:13'),(4368,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-27 16:43:09','2021-10-27 16:43:09'),(4369,'default','added',1089,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-10-27 17:20:11','2021-10-27 17:20:11'),(4370,'default','status_changed',1129,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-27 17:20:25','2021-10-27 17:20:25'),(4371,'default','status_changed',1115,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-27 17:44:08','2021-10-27 17:44:08'),(4372,'default','added',1090,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-27 17:58:24','2021-10-27 17:58:24'),(4373,'default','added',1091,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-27 17:59:47','2021-10-27 17:59:47'),(4374,'default','added',1129,'App\\Contact',1,4,'App\\User','[]','2021-10-27 18:21:30','2021-10-27 18:21:30'),(4375,'default','added',1130,'App\\Contact',1,4,'App\\User','[]','2021-10-27 18:29:32','2021-10-27 18:29:32'),(4376,'default','added',1092,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-27 18:34:22','2021-10-27 18:34:22'),(4377,'default','added',1093,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-27 18:35:32','2021-10-27 18:35:32'),(4378,'default','added',1131,'App\\Contact',1,4,'App\\User','[]','2021-10-27 18:47:54','2021-10-27 18:47:54'),(4379,'default','added',1094,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":700}}','2021-10-27 19:02:26','2021-10-27 19:02:26'),(4380,'default','added',1095,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-10-27 19:07:45','2021-10-27 19:07:45'),(4381,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-10-27 19:08:07','2021-10-27 19:08:07'),(4382,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-27 19:09:03','2021-10-27 19:09:03'),(4383,'default','status_changed',1135,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-10-27 19:12:40','2021-10-27 19:12:40'),(4384,'default','added',1096,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-10-27 19:24:06','2021-10-27 19:24:06'),(4385,'default','status_changed',1109,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-27 19:24:25','2021-10-27 19:24:25'),(4386,'default','added',1132,'App\\Contact',1,11,'App\\User','[]','2021-10-27 19:39:06','2021-10-27 19:39:06'),(4387,'default','added',1097,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}','2021-10-27 19:45:50','2021-10-27 19:45:50'),(4388,'default','status_changed',1120,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-27 19:46:01','2021-10-27 19:46:01'),(4389,'default','added',1098,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-10-27 19:47:48','2021-10-27 19:47:48'),(4390,'default','status_changed',1132,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-27 19:48:00','2021-10-27 19:48:00'),(4391,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-27 19:48:57','2021-10-27 19:48:57'),(4392,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-10-27 19:59:05','2021-10-27 19:59:05'),(4393,'default','added',1133,'App\\Contact',1,20,'App\\User','[]','2021-10-27 19:59:28','2021-10-27 19:59:28'),(4394,'default','added',1099,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-10-27 20:04:27','2021-10-27 20:04:27'),(4395,'default','status_changed',1106,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-27 20:15:47','2021-10-27 20:15:47'),(4396,'default','added',1100,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-10-27 20:17:19','2021-10-27 20:17:19'),(4397,'default','status_changed',1117,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-27 20:19:17','2021-10-27 20:19:17'),(4398,'default','status_changed',1047,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-27 20:20:15','2021-10-27 20:20:15'),(4399,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-27 20:24:23','2021-10-27 20:24:23'),(4400,'default','added',1101,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}','2021-10-27 20:47:30','2021-10-27 20:47:30'),(4401,'default','status_changed',994,'App\\Transaction',1,1,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-27 20:47:45','2021-10-27 20:47:45'),(4402,'default','status_changed',1110,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-27 20:47:46','2021-10-27 20:47:46'),(4403,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-27 21:12:36','2021-10-27 21:12:36'),(4404,'default','added',1102,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-10-27 21:16:40','2021-10-27 21:16:40'),(4405,'default','status_changed',1113,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-10-27 21:17:26','2021-10-27 21:17:26'),(4406,'default','added',1103,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-27 21:20:06','2021-10-27 21:20:06'),(4407,'default','added',1104,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-27 21:34:29','2021-10-27 21:34:29'),(4408,'default','status_changed',1113,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-27 21:36:47','2021-10-27 21:36:47'),(4409,'default','logout',20,'App\\User',1,20,'App\\User','[]','2021-10-27 21:50:44','2021-10-27 21:50:44'),(4410,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-27 21:57:23','2021-10-27 21:57:23'),(4411,'default','added',1105,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-27 22:01:49','2021-10-27 22:01:49'),(4412,'default','payment_edited',1071,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"partial\",\"final_total\":\"300.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"300.0000\"}}','2021-10-27 22:03:47','2021-10-27 22:03:47'),(4413,'default','added',1106,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-10-27 22:13:43','2021-10-27 22:13:43'),(4414,'default','status_changed',398,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-27 22:14:59','2021-10-27 22:14:59'),(4415,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-27 22:37:40','2021-10-27 22:37:40'),(4416,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-27 22:39:51','2021-10-27 22:39:51'),(4417,'default','added',1107,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-10-27 22:42:13','2021-10-27 22:42:13'),(4418,'default','status_changed',1123,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-27 22:43:06','2021-10-27 22:43:06'),(4419,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-27 22:47:50','2021-10-27 22:47:50'),(4420,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-27 22:55:12','2021-10-27 22:55:12'),(4421,'default','added',1108,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}','2021-10-27 22:56:46','2021-10-27 22:56:46'),(4422,'default','status_changed',1105,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-27 22:56:59','2021-10-27 22:56:59'),(4423,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-27 22:59:12','2021-10-27 22:59:12'),(4424,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-28 11:24:21','2021-10-28 11:24:21'),(4425,'default','added',1134,'App\\Contact',1,11,'App\\User','[]','2021-10-28 11:25:02','2021-10-28 11:25:02'),(4426,'default','added',1135,'App\\Contact',1,11,'App\\User','[]','2021-10-28 11:37:39','2021-10-28 11:37:39'),(4427,'default','added',1136,'App\\Contact',1,11,'App\\User','[]','2021-10-28 12:00:22','2021-10-28 12:00:22'),(4428,'default','added',1137,'App\\Contact',1,11,'App\\User','[]','2021-10-28 12:03:23','2021-10-28 12:03:23'),(4429,'default','status_changed',1128,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-28 13:06:24','2021-10-28 13:06:24'),(4430,'default','added',1138,'App\\Contact',1,11,'App\\User','[]','2021-10-28 13:15:40','2021-10-28 13:15:40'),(4431,'default','added',1139,'App\\Contact',1,11,'App\\User','[]','2021-10-28 13:26:46','2021-10-28 13:26:46'),(4432,'default','added',1109,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":850}}','2021-10-28 14:08:48','2021-10-28 14:08:48'),(4433,'default','status_changed',1095,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-28 14:08:59','2021-10-28 14:08:59'),(4434,'default','added',1110,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-28 14:23:17','2021-10-28 14:23:17'),(4435,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-28 14:30:55','2021-10-28 14:30:55'),(4436,'default','added',1111,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":325}}','2021-10-28 14:36:28','2021-10-28 14:36:28'),(4437,'default','status_changed',1143,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-28 14:36:50','2021-10-28 14:36:50'),(4438,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-28 14:37:35','2021-10-28 14:37:35'),(4439,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-28 14:43:18','2021-10-28 14:43:18'),(4440,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-28 15:01:07','2021-10-28 15:01:07'),(4441,'default','added',1112,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-28 15:06:51','2021-10-28 15:06:51'),(4442,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-28 15:14:19','2021-10-28 15:14:19'),(4443,'default','added',1113,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":950}}','2021-10-28 15:24:07','2021-10-28 15:24:07'),(4444,'default','status_changed',1125,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-28 15:24:22','2021-10-28 15:24:22'),(4445,'default','added',1114,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-10-28 15:45:15','2021-10-28 15:45:15'),(4446,'default','status_changed',1135,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-28 15:45:39','2021-10-28 15:45:39'),(4447,'default','added',1140,'App\\Contact',1,4,'App\\User','[]','2021-10-28 15:48:22','2021-10-28 15:48:22'),(4448,'default','added',1115,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":250}}','2021-10-28 15:57:00','2021-10-28 15:57:00'),(4449,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-10-28 16:24:13','2021-10-28 16:24:13'),(4450,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-10-28 16:24:30','2021-10-28 16:24:30'),(4451,'default','logout',20,'App\\User',1,20,'App\\User','[]','2021-10-28 16:25:31','2021-10-28 16:25:31'),(4452,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-28 16:27:41','2021-10-28 16:27:41'),(4453,'default','added',1141,'App\\Contact',1,4,'App\\User','[]','2021-10-28 16:28:17','2021-10-28 16:28:17'),(4454,'default','status_changed',1140,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Can\'t be repaired\"}','2021-10-28 16:37:36','2021-10-28 16:37:36'),(4455,'default','added',1142,'App\\Contact',1,4,'App\\User','[]','2021-10-28 16:52:08','2021-10-28 16:52:08'),(4456,'default','added',1143,'App\\Contact',1,4,'App\\User','[]','2021-10-28 17:14:18','2021-10-28 17:14:18'),(4457,'default','added',1144,'App\\Contact',1,4,'App\\User','[]','2021-10-28 17:31:25','2021-10-28 17:31:25'),(4458,'default','status_changed',233,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-28 17:39:51','2021-10-28 17:39:51'),(4459,'default','added',1116,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-28 17:41:56','2021-10-28 17:41:56'),(4460,'default','added',1117,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-28 17:43:00','2021-10-28 17:43:00'),(4461,'default','added',1118,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-28 17:43:29','2021-10-28 17:43:29'),(4462,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-28 18:02:00','2021-10-28 18:02:00'),(4463,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-10-28 18:02:09','2021-10-28 18:02:09'),(4464,'default','status_changed',1140,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-28 18:05:26','2021-10-28 18:05:26'),(4465,'default','status_changed',1141,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-28 18:05:33','2021-10-28 18:05:33'),(4466,'default','logout',20,'App\\User',1,20,'App\\User','[]','2021-10-28 18:26:03','2021-10-28 18:26:03'),(4467,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-28 18:26:31','2021-10-28 18:26:31'),(4468,'default','added',1145,'App\\Contact',1,4,'App\\User','[]','2021-10-28 18:28:39','2021-10-28 18:28:39'),(4469,'default','status_changed',1148,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-28 18:37:50','2021-10-28 18:37:50'),(4470,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-28 18:39:36','2021-10-28 18:39:36'),(4471,'default','status_changed',1149,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-10-28 18:42:00','2021-10-28 18:42:00'),(4472,'default','added',1119,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-10-28 18:47:59','2021-10-28 18:47:59'),(4473,'default','added',1146,'App\\Contact',1,4,'App\\User','[]','2021-10-28 18:59:10','2021-10-28 18:59:10'),(4474,'default','status_changed',681,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-28 19:07:07','2021-10-28 19:07:07'),(4475,'default','added',1120,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-10-28 19:13:20','2021-10-28 19:13:20'),(4476,'default','status_changed',1139,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-28 19:13:30','2021-10-28 19:13:30'),(4477,'default','added',1121,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-10-28 19:14:20','2021-10-28 19:14:20'),(4478,'default','status_changed',1050,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-28 20:25:34','2021-10-28 20:25:34'),(4479,'default','added',1122,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-28 20:26:55','2021-10-28 20:26:55'),(4480,'default','added',1123,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-28 20:29:37','2021-10-28 20:29:37'),(4481,'default','added',1124,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-28 20:43:11','2021-10-28 20:43:11'),(4482,'default','added',1125,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-28 20:43:42','2021-10-28 20:43:42'),(4483,'default','added',1126,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-28 20:44:27','2021-10-28 20:44:27'),(4484,'default','added',1147,'App\\Contact',1,4,'App\\User','[]','2021-10-28 21:15:47','2021-10-28 21:15:47'),(4485,'default','added',1148,'App\\Contact',1,1,'App\\User','[]','2021-10-28 21:41:15','2021-10-28 21:41:15'),(4486,'default','added',1149,'App\\Contact',1,4,'App\\User','[]','2021-10-28 21:48:58','2021-10-28 21:48:58'),(4487,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-28 21:53:19','2021-10-28 21:53:19'),(4488,'default','added',1127,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-10-28 21:56:39','2021-10-28 21:56:39'),(4489,'default','status_changed',1142,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-28 21:57:11','2021-10-28 21:57:11'),(4490,'default','added',1128,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-10-28 21:58:29','2021-10-28 21:58:29'),(4491,'default','status_changed',1131,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-28 21:58:37','2021-10-28 21:58:37'),(4492,'default','status_changed',1130,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-28 21:59:12','2021-10-28 21:59:12'),(4493,'default','added',1129,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":125}}','2021-10-28 22:02:51','2021-10-28 22:02:51'),(4494,'default','status_changed',1153,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-28 22:03:03','2021-10-28 22:03:03'),(4495,'default','added',1130,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-28 22:05:05','2021-10-28 22:05:05'),(4496,'default','edited',995,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"550.0000\"}}','2021-10-28 22:08:41','2021-10-28 22:08:41'),(4497,'default','edited',995,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":650},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"100.0000\"}}','2021-10-28 22:11:50','2021-10-28 22:11:50'),(4498,'default','status_changed',995,'App\\Transaction',1,1,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-28 22:12:24','2021-10-28 22:12:24'),(4499,'default','payment_edited',1071,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"300.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"partial\",\"final_total\":\"300.0000\"}}','2021-10-28 22:20:43','2021-10-28 22:20:43'),(4500,'default','payment_edited',994,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"800.0000\"}}','2021-10-28 22:21:15','2021-10-28 22:21:15'),(4501,'default','payment_edited',1071,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"300.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"300.0000\"}}','2021-10-28 22:22:29','2021-10-28 22:22:29'),(4502,'default','edited',994,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"800.0000\"}}','2021-10-28 22:24:01','2021-10-28 22:24:01'),(4503,'default','status_changed',1136,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-28 22:26:10','2021-10-28 22:26:10'),(4504,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-10-28 22:27:01','2021-10-28 22:27:01'),(4505,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-28 22:29:33','2021-10-28 22:29:33'),(4506,'default','added',1131,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}','2021-10-28 22:48:35','2021-10-28 22:48:35'),(4507,'default','status_changed',1146,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-28 22:49:30','2021-10-28 22:49:30'),(4508,'default','added',1132,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-10-28 22:58:49','2021-10-28 22:58:49'),(4509,'default','status_changed',1151,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-28 22:59:20','2021-10-28 22:59:20'),(4510,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-28 23:03:24','2021-10-28 23:03:24'),(4511,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-29 01:27:53','2021-10-29 01:27:53'),(4512,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-29 01:53:45','2021-10-29 01:53:45'),(4513,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-29 13:20:25','2021-10-29 13:20:25'),(4514,'default','added',1150,'App\\Contact',1,4,'App\\User','[]','2021-10-29 13:33:17','2021-10-29 13:33:17'),(4515,'default','added',1151,'App\\Contact',1,4,'App\\User','[]','2021-10-29 14:15:01','2021-10-29 14:15:01'),(4516,'default','added',1152,'App\\Contact',1,4,'App\\User','[]','2021-10-29 14:35:45','2021-10-29 14:35:45'),(4517,'default','added',1153,'App\\Contact',1,4,'App\\User','[]','2021-10-29 14:42:19','2021-10-29 14:42:19'),(4518,'default','added',1303,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-29 16:25:24','2021-10-29 16:25:24'),(4519,'default','added',1304,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-10-29 16:26:05','2021-10-29 16:26:05'),(4520,'default','status_changed',1116,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-29 16:26:18','2021-10-29 16:26:18'),(4521,'default','added',1154,'App\\Contact',1,4,'App\\User','[]','2021-10-29 17:03:23','2021-10-29 17:03:23'),(4522,'default','added',1155,'App\\Contact',1,4,'App\\User','[]','2021-10-29 17:42:22','2021-10-29 17:42:22'),(4523,'default','status_changed',1134,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-29 17:53:42','2021-10-29 17:53:42'),(4524,'default','added',1305,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-29 19:15:38','2021-10-29 19:15:38'),(4525,'default','added',1156,'App\\Contact',1,4,'App\\User','[]','2021-10-29 20:26:44','2021-10-29 20:26:44'),(4526,'default','added',1157,'App\\Contact',1,4,'App\\User','[]','2021-10-29 20:39:56','2021-10-29 20:39:56'),(4527,'default','added',1306,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-10-29 21:46:36','2021-10-29 21:46:36'),(4528,'default','added',1307,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-10-29 21:48:14','2021-10-29 21:48:14'),(4529,'default','status_changed',1137,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-29 21:48:26','2021-10-29 21:48:26'),(4530,'default','added',1308,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-10-29 21:49:45','2021-10-29 21:49:45'),(4531,'default','status_changed',1147,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-29 21:50:15','2021-10-29 21:50:15'),(4532,'default','added',1309,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-29 22:22:57','2021-10-29 22:22:57'),(4533,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-10-29 22:54:13','2021-10-29 22:54:13'),(4534,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-30 11:11:21','2021-10-30 11:11:21'),(4535,'default','added',1158,'App\\Contact',1,11,'App\\User','[]','2021-10-30 11:13:11','2021-10-30 11:13:11'),(4536,'default','added',1159,'App\\Contact',1,11,'App\\User','[]','2021-10-30 11:47:38','2021-10-30 11:47:38'),(4537,'default','added',1160,'App\\Contact',1,11,'App\\User','[]','2021-10-30 12:02:00','2021-10-30 12:02:00'),(4538,'default','added',1161,'App\\Contact',1,11,'App\\User','[]','2021-10-30 14:09:51','2021-10-30 14:09:51'),(4539,'default','added',1162,'App\\Contact',1,11,'App\\User','[]','2021-10-30 14:30:55','2021-10-30 14:30:55'),(4540,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-30 14:38:22','2021-10-30 14:38:22'),(4541,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-30 15:07:49','2021-10-30 15:07:49'),(4542,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-30 15:10:12','2021-10-30 15:10:12'),(4543,'default','added',1163,'App\\Contact',1,4,'App\\User','[]','2021-10-30 15:21:14','2021-10-30 15:21:14'),(4544,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-30 15:22:10','2021-10-30 15:22:10'),(4545,'default','added',1164,'App\\Contact',1,1,'App\\User','[]','2021-10-30 15:23:00','2021-10-30 15:23:00'),(4546,'default','added',1165,'App\\Contact',1,4,'App\\User','[]','2021-10-30 15:31:14','2021-10-30 15:31:14'),(4547,'default','added',1310,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":100}}','2021-10-30 15:36:58','2021-10-30 15:36:58'),(4548,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-30 15:39:18','2021-10-30 15:39:18'),(4549,'default','status_changed',1171,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-30 15:41:49','2021-10-30 15:41:49'),(4550,'default','added',1166,'App\\Contact',1,4,'App\\User','[]','2021-10-30 16:20:16','2021-10-30 16:20:16'),(4551,'default','added',1167,'App\\Contact',1,4,'App\\User','[]','2021-10-30 16:42:54','2021-10-30 16:42:54'),(4552,'default','added',1311,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-30 16:54:30','2021-10-30 16:54:30'),(4553,'default','added',1312,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-30 16:55:00','2021-10-30 16:55:00'),(4554,'default','added',1313,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-30 16:55:19','2021-10-30 16:55:19'),(4555,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-30 17:11:18','2021-10-30 17:11:18'),(4556,'default','added',1314,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-10-30 17:12:35','2021-10-30 17:12:35'),(4557,'default','status_changed',1169,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-30 17:12:50','2021-10-30 17:12:50'),(4558,'default','added',1315,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-10-30 17:17:47','2021-10-30 17:17:47'),(4559,'default','status_changed',1172,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-30 17:18:06','2021-10-30 17:18:06'),(4560,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-30 17:37:50','2021-10-30 17:37:50'),(4561,'default','added',1316,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-10-30 18:28:12','2021-10-30 18:28:12'),(4562,'default','status_changed',1166,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-30 18:29:01','2021-10-30 18:29:01'),(4563,'default','added',1168,'App\\Contact',1,4,'App\\User','[]','2021-10-30 18:48:25','2021-10-30 18:48:25'),(4564,'default','added',1169,'App\\Contact',1,4,'App\\User','[]','2021-10-30 18:49:25','2021-10-30 18:49:25'),(4565,'default','added',1317,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-10-30 19:05:51','2021-10-30 19:05:51'),(4566,'default','status_changed',1138,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-30 19:06:17','2021-10-30 19:06:17'),(4567,'default','status_changed',1077,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-10-30 19:13:26','2021-10-30 19:13:26'),(4568,'default','added',1170,'App\\Contact',1,4,'App\\User','[]','2021-10-30 19:49:08','2021-10-30 19:49:08'),(4569,'default','added',1318,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-10-30 19:59:57','2021-10-30 19:59:57'),(4570,'default','status_changed',1165,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-30 20:00:09','2021-10-30 20:00:09'),(4571,'default','added',1319,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":175}}','2021-10-30 20:01:08','2021-10-30 20:01:08'),(4572,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-30 20:01:13','2021-10-30 20:01:13'),(4573,'default','status_changed',1157,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-30 20:03:53','2021-10-30 20:03:53'),(4574,'default','added',1171,'App\\Contact',1,4,'App\\User','[]','2021-10-30 20:04:53','2021-10-30 20:04:53'),(4575,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-10-30 20:09:01','2021-10-30 20:09:01'),(4576,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-30 20:14:51','2021-10-30 20:14:51'),(4577,'default','status_changed',1070,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-10-30 20:15:39','2021-10-30 20:15:39'),(4578,'default','added',1172,'App\\Contact',1,4,'App\\User','[]','2021-10-30 20:15:45','2021-10-30 20:15:45'),(4579,'default','status_changed',1070,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-30 20:16:29','2021-10-30 20:16:29'),(4580,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-30 20:22:13','2021-10-30 20:22:13'),(4581,'default','added',1173,'App\\Contact',1,4,'App\\User','[]','2021-10-30 20:22:52','2021-10-30 20:22:52'),(4582,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-30 20:23:58','2021-10-30 20:23:58'),(4583,'default','added',1320,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-10-30 20:32:04','2021-10-30 20:32:04'),(4584,'default','status_changed',1156,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-30 20:32:16','2021-10-30 20:32:16'),(4585,'default','added',1174,'App\\Contact',1,4,'App\\User','[]','2021-10-30 20:35:51','2021-10-30 20:35:51'),(4586,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-30 20:40:50','2021-10-30 20:40:50'),(4587,'default','added',1175,'App\\Contact',1,4,'App\\User','[]','2021-10-30 20:42:51','2021-10-30 20:42:51'),(4588,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-30 20:43:42','2021-10-30 20:43:42'),(4589,'default','added',1176,'App\\Contact',1,4,'App\\User','[]','2021-10-30 21:30:42','2021-10-30 21:30:42'),(4590,'default','added',1321,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":350}}','2021-10-30 21:39:30','2021-10-30 21:39:30'),(4591,'default','added',1322,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":100}}','2021-10-30 21:39:43','2021-10-30 21:39:43'),(4592,'default','status_changed',1175,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-30 21:39:44','2021-10-30 21:39:44'),(4593,'default','added',1323,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-30 21:52:07','2021-10-30 21:52:07'),(4594,'default','added',1324,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-30 21:53:05','2021-10-30 21:53:05'),(4595,'default','added',1325,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-30 21:56:00','2021-10-30 21:56:00'),(4596,'default','added',1326,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-30 21:56:34','2021-10-30 21:56:34'),(4597,'default','added',1327,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-30 21:57:37','2021-10-30 21:57:37'),(4598,'default','edited',1327,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-30 21:58:57','2021-10-30 21:58:57'),(4599,'default','added',1328,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-30 21:59:46','2021-10-30 21:59:46'),(4600,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-30 22:15:11','2021-10-30 22:15:11'),(4601,'default','status_changed',1154,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-30 22:18:55','2021-10-30 22:18:55'),(4602,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-30 22:21:45','2021-10-30 22:21:45'),(4603,'default','status_changed',1181,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-30 22:29:17','2021-10-30 22:29:17'),(4604,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-30 22:29:49','2021-10-30 22:29:49'),(4605,'default','added',1329,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3450}}','2021-10-30 22:33:07','2021-10-30 22:33:07'),(4606,'default','status_changed',1152,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-30 22:33:18','2021-10-30 22:33:18'),(4607,'default','added',1330,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}','2021-10-30 22:38:06','2021-10-30 22:38:06'),(4608,'default','status_changed',1167,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-30 22:38:25','2021-10-30 22:38:25'),(4609,'default','added',1331,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-30 22:52:11','2021-10-30 22:52:11'),(4610,'default','added',1332,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-10-30 23:07:49','2021-10-30 23:07:49'),(4611,'default','status_changed',1178,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-30 23:08:03','2021-10-30 23:08:03'),(4612,'default','added',1333,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-30 23:19:00','2021-10-30 23:19:00'),(4613,'default','added',1334,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-10-30 23:19:53','2021-10-30 23:19:53'),(4614,'default','status_changed',1179,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-30 23:20:14','2021-10-30 23:20:14'),(4615,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-10-30 23:24:46','2021-10-30 23:24:46'),(4616,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-31 11:43:11','2021-10-31 11:43:11'),(4617,'default','added',1335,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-10-31 13:07:28','2021-10-31 13:07:28'),(4618,'default','status_changed',1164,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-31 13:08:05','2021-10-31 13:08:05'),(4619,'default','added',1336,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-10-31 13:12:09','2021-10-31 13:12:09'),(4620,'default','added',1337,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-10-31 13:19:25','2021-10-31 13:19:25'),(4621,'default','added',1177,'App\\Contact',1,11,'App\\User','[]','2021-10-31 13:19:54','2021-10-31 13:19:54'),(4622,'default','added',1338,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-10-31 13:32:57','2021-10-31 13:32:57'),(4623,'default','status_changed',875,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-31 13:33:10','2021-10-31 13:33:10'),(4624,'default','status_changed',1170,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-31 13:35:04','2021-10-31 13:35:04'),(4625,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-31 14:32:56','2021-10-31 14:32:56'),(4626,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-31 14:33:54','2021-10-31 14:33:54'),(4627,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-31 14:34:15','2021-10-31 14:34:15'),(4628,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-31 14:38:40','2021-10-31 14:38:40'),(4629,'default','status_changed',1171,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-31 14:40:06','2021-10-31 14:40:06'),(4630,'default','status_changed',738,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-31 14:45:04','2021-10-31 14:45:04'),(4631,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-31 14:51:48','2021-10-31 14:51:48'),(4632,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-31 15:00:58','2021-10-31 15:00:58'),(4633,'default','added',1339,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-10-31 15:08:46','2021-10-31 15:08:46'),(4634,'default','status_changed',1149,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-31 15:09:02','2021-10-31 15:09:02'),(4635,'default','added',1178,'App\\Contact',1,4,'App\\User','[]','2021-10-31 15:45:39','2021-10-31 15:45:39'),(4636,'default','added',1179,'App\\Contact',1,4,'App\\User','[]','2021-10-31 15:59:16','2021-10-31 15:59:16'),(4637,'default','added',1180,'App\\Contact',1,4,'App\\User','[]','2021-10-31 16:28:07','2021-10-31 16:28:07'),(4638,'default','added',1181,'App\\Contact',1,4,'App\\User','[]','2021-10-31 16:35:27','2021-10-31 16:35:27'),(4639,'default','added',1340,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":950}}','2021-10-31 16:48:01','2021-10-31 16:48:01'),(4640,'default','status_changed',927,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-31 16:49:57','2021-10-31 16:49:57'),(4641,'default','status_changed',1186,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-31 17:07:21','2021-10-31 17:07:21'),(4642,'default','added',1341,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}','2021-10-31 17:10:31','2021-10-31 17:10:31'),(4643,'default','status_changed',1127,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-31 17:11:01','2021-10-31 17:11:01'),(4644,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-10-31 17:42:11','2021-10-31 17:42:11'),(4645,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-10-31 17:42:17','2021-10-31 17:42:17'),(4646,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-31 17:42:33','2021-10-31 17:42:33'),(4647,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-31 17:52:40','2021-10-31 17:52:40'),(4648,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-31 18:06:48','2021-10-31 18:06:48'),(4649,'default','added',1182,'App\\Contact',1,4,'App\\User','[]','2021-10-31 18:08:11','2021-10-31 18:08:11'),(4650,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-31 18:12:24','2021-10-31 18:12:24'),(4651,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-10-31 18:24:19','2021-10-31 18:24:19'),(4652,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-31 18:26:08','2021-10-31 18:26:08'),(4653,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-31 18:40:04','2021-10-31 18:40:04'),(4654,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-31 18:40:36','2021-10-31 18:40:36'),(4655,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-31 18:42:58','2021-10-31 18:42:58'),(4656,'default','added',1183,'App\\Contact',1,4,'App\\User','[]','2021-10-31 18:48:02','2021-10-31 18:48:02'),(4657,'default','added',1342,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":250}}','2021-10-31 18:53:39','2021-10-31 18:53:39'),(4658,'default','added',1184,'App\\Contact',1,4,'App\\User','[]','2021-10-31 18:56:19','2021-10-31 18:56:19'),(4659,'default','added',1343,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-31 19:05:49','2021-10-31 19:05:49'),(4660,'default','added',1344,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-31 19:11:12','2021-10-31 19:11:12'),(4661,'default','added',1345,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-31 19:11:53','2021-10-31 19:11:53'),(4662,'default','added',1346,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-31 19:12:28','2021-10-31 19:12:28'),(4663,'default','added',1347,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-31 19:13:42','2021-10-31 19:13:42'),(4664,'default','added',1348,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-31 19:14:44','2021-10-31 19:14:44'),(4665,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-31 19:34:11','2021-10-31 19:34:11'),(4666,'default','added',1185,'App\\Contact',1,4,'App\\User','[]','2021-10-31 19:45:19','2021-10-31 19:45:19'),(4667,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-31 19:52:40','2021-10-31 19:52:40'),(4668,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-31 20:07:14','2021-10-31 20:07:14'),(4669,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-31 20:07:53','2021-10-31 20:07:53'),(4670,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-31 20:09:48','2021-10-31 20:09:48'),(4671,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-10-31 20:11:37','2021-10-31 20:11:37'),(4672,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-31 20:11:49','2021-10-31 20:11:49'),(4673,'default','added',1349,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-10-31 20:18:51','2021-10-31 20:18:51'),(4674,'default','status_changed',1191,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-31 20:19:07','2021-10-31 20:19:07'),(4675,'default','added',1350,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-10-31 20:19:45','2021-10-31 20:19:45'),(4676,'default','status_changed',1181,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-31 20:19:57','2021-10-31 20:19:57'),(4677,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-31 20:22:14','2021-10-31 20:22:14'),(4678,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-10-31 20:22:59','2021-10-31 20:22:59'),(4679,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-31 20:23:41','2021-10-31 20:23:41'),(4680,'default','added',1186,'App\\Contact',1,4,'App\\User','[]','2021-10-31 20:25:23','2021-10-31 20:25:23'),(4681,'default','added',1187,'App\\Contact',1,4,'App\\User','[]','2021-10-31 20:35:24','2021-10-31 20:35:24'),(4682,'default','added',1351,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-31 20:40:00','2021-10-31 20:40:00'),(4683,'default','status_changed',1196,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-10-31 20:42:13','2021-10-31 20:42:13'),(4684,'default','added',1352,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-10-31 20:45:31','2021-10-31 20:45:31'),(4685,'default','status_changed',1176,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-31 20:45:42','2021-10-31 20:45:42'),(4686,'default','status_changed',1190,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-31 20:49:01','2021-10-31 20:49:01'),(4687,'default','added',1353,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-10-31 20:53:51','2021-10-31 20:53:51'),(4688,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-31 20:57:18','2021-10-31 20:57:18'),(4689,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-10-31 21:02:05','2021-10-31 21:02:05'),(4690,'default','added',1188,'App\\Contact',1,11,'App\\User','[]','2021-10-31 21:03:06','2021-10-31 21:03:06'),(4691,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-10-31 21:05:40','2021-10-31 21:05:40'),(4692,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-10-31 21:11:07','2021-10-31 21:11:07'),(4693,'default','payment_edited',1094,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"700.0000\"}}','2021-10-31 21:12:17','2021-10-31 21:12:17'),(4694,'default','payment_edited',1047,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2500.0000\"}}','2021-10-31 21:12:57','2021-10-31 21:12:57'),(4695,'default','payment_edited',1321,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"350.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"350.0000\"}}','2021-10-31 21:13:20','2021-10-31 21:13:20'),(4696,'default','added',1354,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-10-31 21:24:27','2021-10-31 21:24:27'),(4697,'default','status_changed',1186,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-31 21:24:51','2021-10-31 21:24:51'),(4698,'default','payment_edited',886,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"500.0000\"}}','2021-10-31 21:34:33','2021-10-31 21:34:33'),(4699,'default','added',1355,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-31 21:35:05','2021-10-31 21:35:05'),(4700,'default','added',1356,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-31 21:35:27','2021-10-31 21:35:27'),(4701,'default','added',1357,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1150}}','2021-10-31 21:36:05','2021-10-31 21:36:05'),(4702,'default','status_changed',1174,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-31 21:36:14','2021-10-31 21:36:14'),(4703,'default','added',1358,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-10-31 21:47:09','2021-10-31 21:47:09'),(4704,'default','status_changed',1193,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-31 21:49:50','2021-10-31 21:49:50'),(4705,'default','added',1359,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-10-31 21:50:46','2021-10-31 21:50:46'),(4706,'default','status_changed',1194,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-31 21:51:04','2021-10-31 21:51:04'),(4707,'default','added',1360,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-10-31 21:52:27','2021-10-31 21:52:27'),(4708,'default','status_changed',1192,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-31 21:52:39','2021-10-31 21:52:39'),(4709,'default','added',1361,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-10-31 22:04:51','2021-10-31 22:04:51'),(4710,'default','status_changed',1189,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-31 22:05:05','2021-10-31 22:05:05'),(4711,'default','added',1189,'App\\Contact',1,4,'App\\User','[]','2021-10-31 22:06:18','2021-10-31 22:06:18'),(4712,'default','status_changed',1161,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-31 22:17:46','2021-10-31 22:17:46'),(4713,'default','added',1362,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-10-31 22:21:45','2021-10-31 22:21:45'),(4714,'default','status_changed',1180,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-10-31 22:22:48','2021-10-31 22:22:48'),(4715,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-10-31 23:12:10','2021-10-31 23:12:10'),(4716,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-01 11:26:35','2021-11-01 11:26:35'),(4717,'default','status_changed',1198,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-01 11:32:10','2021-11-01 11:32:10'),(4718,'default','status_changed',1199,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-01 11:32:18','2021-11-01 11:32:18'),(4719,'default','added',1190,'App\\Contact',1,11,'App\\User','[]','2021-11-01 12:27:43','2021-11-01 12:27:43'),(4720,'default','added',1191,'App\\Contact',1,11,'App\\User','[]','2021-11-01 12:28:42','2021-11-01 12:28:42'),(4721,'default','status_changed',1200,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-01 12:35:20','2021-11-01 12:35:20'),(4722,'default','added',1192,'App\\Contact',1,11,'App\\User','[]','2021-11-01 12:39:21','2021-11-01 12:39:21'),(4723,'default','added',1193,'App\\Contact',1,11,'App\\User','[]','2021-11-01 13:16:56','2021-11-01 13:16:56'),(4724,'default','added',1194,'App\\Contact',1,11,'App\\User','[]','2021-11-01 13:24:24','2021-11-01 13:24:24'),(4725,'default','status_changed',173,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-11-01 14:04:45','2021-11-01 14:04:45'),(4726,'default','status_changed',173,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-11-01 14:06:08','2021-11-01 14:06:08'),(4727,'default','added',1195,'App\\Contact',1,11,'App\\User','[]','2021-11-01 14:29:42','2021-11-01 14:29:42'),(4728,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-01 14:33:06','2021-11-01 14:33:06'),(4729,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-11-01 14:35:17','2021-11-01 14:35:17'),(4730,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-01 15:03:26','2021-11-01 15:03:26'),(4731,'default','added',1196,'App\\Contact',1,20,'App\\User','[]','2021-11-01 15:08:46','2021-11-01 15:08:46'),(4732,'default','added',1363,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":125}}','2021-11-01 15:20:53','2021-11-01 15:20:53'),(4733,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-11-01 15:26:45','2021-11-01 15:26:45'),(4734,'default','added',1197,'App\\Contact',1,20,'App\\User','[]','2021-11-01 15:27:27','2021-11-01 15:27:27'),(4735,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-11-01 15:28:40','2021-11-01 15:28:40'),(4736,'default','added',1364,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-01 15:36:44','2021-11-01 15:36:44'),(4737,'default','added',1198,'App\\Contact',1,20,'App\\User','[]','2021-11-01 16:06:12','2021-11-01 16:06:12'),(4738,'default','status_changed',1145,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-01 16:29:19','2021-11-01 16:29:19'),(4739,'default','added',1199,'App\\Contact',1,20,'App\\User','[]','2021-11-01 17:10:03','2021-11-01 17:10:03'),(4740,'default','added',1200,'App\\Contact',1,11,'App\\User','[]','2021-11-01 17:22:28','2021-11-01 17:22:28'),(4741,'default','added',1201,'App\\Contact',1,20,'App\\User','[]','2021-11-01 18:00:41','2021-11-01 18:00:41'),(4742,'default','added',1365,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-01 18:00:59','2021-11-01 18:00:59'),(4743,'default','added',1202,'App\\Contact',1,20,'App\\User','[]','2021-11-01 18:02:03','2021-11-01 18:02:03'),(4744,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-01 18:03:21','2021-11-01 18:03:21'),(4745,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-01 18:17:19','2021-11-01 18:17:19'),(4746,'default','added',1366,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}','2021-11-01 18:21:09','2021-11-01 18:21:09'),(4747,'default','status_changed',1114,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-01 18:21:57','2021-11-01 18:21:57'),(4748,'default','added',1367,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-01 18:22:31','2021-11-01 18:22:31'),(4749,'default','status_changed',1204,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Under Test\"}','2021-11-01 18:22:45','2021-11-01 18:22:45'),(4750,'default','added',1368,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-11-01 18:28:19','2021-11-01 18:28:19'),(4751,'default','status_changed',1158,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-01 18:28:36','2021-11-01 18:28:36'),(4752,'default','status_changed',1106,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-11-01 18:43:41','2021-11-01 18:43:41'),(4753,'default','added',1369,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-11-01 18:46:58','2021-11-01 18:46:58'),(4754,'default','status_changed',1208,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-01 18:47:18','2021-11-01 18:47:18'),(4755,'default','added',1370,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-01 18:50:54','2021-11-01 18:50:54'),(4756,'default','added',1203,'App\\Contact',1,20,'App\\User','[]','2021-11-01 19:07:49','2021-11-01 19:07:49'),(4757,'default','added',1371,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-01 19:20:16','2021-11-01 19:20:16'),(4758,'default','added',1372,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-01 19:22:15','2021-11-01 19:22:15'),(4759,'default','added',1373,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-01 19:29:15','2021-11-01 19:29:15'),(4760,'default','added',1374,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-11-01 19:35:39','2021-11-01 19:35:39'),(4761,'default','added',1375,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-01 19:36:25','2021-11-01 19:36:25'),(4762,'default','added',1376,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-11-01 19:37:48','2021-11-01 19:37:48'),(4763,'default','added',1377,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-11-01 19:39:59','2021-11-01 19:39:59'),(4764,'default','status_changed',1203,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-01 19:40:15','2021-11-01 19:40:15'),(4765,'default','added',1378,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-01 19:44:58','2021-11-01 19:44:58'),(4766,'default','added',1204,'App\\Contact',1,20,'App\\User','[]','2021-11-01 19:45:30','2021-11-01 19:45:30'),(4767,'default','added',1379,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-01 19:46:33','2021-11-01 19:46:33'),(4768,'default','status_changed',1210,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-01 19:47:46','2021-11-01 19:47:46'),(4769,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-01 19:50:51','2021-11-01 19:50:51'),(4770,'default','added',1380,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-11-01 19:57:22','2021-11-01 19:57:22'),(4771,'default','status_changed',1202,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-01 19:57:40','2021-11-01 19:57:40'),(4772,'default','added',1205,'App\\Contact',1,20,'App\\User','[]','2021-11-01 20:00:41','2021-11-01 20:00:41'),(4773,'default','status_changed',229,'Modules\\Repair\\Entities\\JobSheet',1,1,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-01 20:01:23','2021-11-01 20:01:23'),(4774,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-01 20:04:29','2021-11-01 20:04:29'),(4775,'default','added',1381,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-11-01 20:13:30','2021-11-01 20:13:30'),(4776,'default','status_changed',1211,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-01 20:13:51','2021-11-01 20:13:51'),(4777,'default','added',1206,'App\\Contact',1,20,'App\\User','[]','2021-11-01 20:19:15','2021-11-01 20:19:15'),(4778,'default','edited',1370,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"}}','2021-11-01 20:20:33','2021-11-01 20:20:33'),(4779,'default','edited',1371,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"}}','2021-11-01 20:20:58','2021-11-01 20:20:58'),(4780,'default','edited',1372,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"}}','2021-11-01 20:21:19','2021-11-01 20:21:19'),(4781,'default','edited',1365,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"}}','2021-11-01 20:22:03','2021-11-01 20:22:03'),(4782,'default','edited',1375,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"}}','2021-11-01 20:22:27','2021-11-01 20:22:27'),(4783,'default','edited',1379,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"}}','2021-11-01 20:23:04','2021-11-01 20:23:04'),(4784,'default','edited',1378,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"}}','2021-11-01 20:23:42','2021-11-01 20:23:42'),(4785,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-01 20:28:32','2021-11-01 20:28:32'),(4786,'default','added',1207,'App\\Contact',1,20,'App\\User','[]','2021-11-01 20:29:15','2021-11-01 20:29:15'),(4787,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-01 20:30:27','2021-11-01 20:30:27'),(4788,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-01 20:31:34','2021-11-01 20:31:34'),(4789,'default','added',1382,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-11-01 20:37:22','2021-11-01 20:37:22'),(4790,'default','status_changed',1199,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-01 20:37:41','2021-11-01 20:37:41'),(4791,'default','added',1383,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-01 20:42:49','2021-11-01 20:42:49'),(4792,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-01 20:45:08','2021-11-01 20:45:08'),(4793,'default','added',1384,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-01 20:45:20','2021-11-01 20:45:20'),(4794,'default','added',1385,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-01 20:47:04','2021-11-01 20:47:04'),(4795,'default','added',1208,'App\\Contact',1,20,'App\\User','[]','2021-11-01 20:53:58','2021-11-01 20:53:58'),(4796,'default','added',1209,'App\\Contact',1,20,'App\\User','[]','2021-11-01 21:05:32','2021-11-01 21:05:32'),(4797,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-01 21:12:06','2021-11-01 21:12:06'),(4798,'default','added',1386,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-11-01 21:16:13','2021-11-01 21:16:13'),(4799,'default','status_changed',1213,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-01 21:16:33','2021-11-01 21:16:33'),(4800,'default','added',1210,'App\\Contact',1,20,'App\\User','[]','2021-11-01 21:20:04','2021-11-01 21:20:04'),(4801,'default','added',1387,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-11-01 21:35:33','2021-11-01 21:35:33'),(4802,'default','status_changed',1212,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-01 21:35:52','2021-11-01 21:35:52'),(4803,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-01 21:37:14','2021-11-01 21:37:14'),(4804,'default','added',1388,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-01 21:42:18','2021-11-01 21:42:18'),(4805,'default','edited',1388,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"}}','2021-11-01 21:42:44','2021-11-01 21:42:44'),(4806,'default','added',1389,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-01 21:44:01','2021-11-01 21:44:01'),(4807,'default','status_changed',1059,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-01 21:45:03','2021-11-01 21:45:03'),(4808,'default','added',1390,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-01 21:47:35','2021-11-01 21:47:35'),(4809,'default','added',1211,'App\\Contact',1,20,'App\\User','[]','2021-11-01 21:53:02','2021-11-01 21:53:02'),(4810,'default','status_changed',1174,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-11-01 22:00:20','2021-11-01 22:00:20'),(4811,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-01 22:14:35','2021-11-01 22:14:35'),(4812,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-01 22:17:00','2021-11-01 22:17:00'),(4813,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-01 22:17:21','2021-11-01 22:17:21'),(4814,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-01 22:38:30','2021-11-01 22:38:30'),(4815,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-01 22:41:50','2021-11-01 22:41:50'),(4816,'default','added',1212,'App\\Contact',1,20,'App\\User','[]','2021-11-01 23:00:25','2021-11-01 23:00:25'),(4817,'default','added',1213,'App\\Contact',1,20,'App\\User','[]','2021-11-01 23:01:07','2021-11-01 23:01:07'),(4818,'default','added',1214,'App\\Contact',1,20,'App\\User','[]','2021-11-01 23:03:33','2021-11-01 23:03:33'),(4819,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-02 11:32:09','2021-11-02 11:32:09'),(4820,'default','status_changed',1223,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-02 11:35:32','2021-11-02 11:35:32'),(4821,'default','added',1391,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}','2021-11-02 11:51:15','2021-11-02 11:51:15'),(4822,'default','status_changed',1159,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-02 11:51:50','2021-11-02 11:51:50'),(4823,'default','added',1392,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-11-02 12:29:17','2021-11-02 12:29:17'),(4824,'default','status_changed',1218,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-02 12:29:33','2021-11-02 12:29:33'),(4825,'default','added',1393,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-11-02 12:51:04','2021-11-02 12:51:04'),(4826,'default','status_changed',1196,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-02 12:51:24','2021-11-02 12:51:24'),(4827,'default','status_changed',1183,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-02 12:52:17','2021-11-02 12:52:17'),(4828,'default','added',1215,'App\\Contact',1,11,'App\\User','[]','2021-11-02 13:08:45','2021-11-02 13:08:45'),(4829,'default','added',1216,'App\\Contact',1,11,'App\\User','[]','2021-11-02 13:43:20','2021-11-02 13:43:20'),(4830,'default','added',1217,'App\\Contact',1,11,'App\\User','[]','2021-11-02 13:46:52','2021-11-02 13:46:52'),(4831,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-02 14:06:35','2021-11-02 14:06:35'),(4832,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-02 14:12:38','2021-11-02 14:12:38'),(4833,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-02 15:02:28','2021-11-02 15:02:28'),(4834,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-02 15:03:13','2021-11-02 15:03:13'),(4835,'default','added',1394,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-02 15:04:52','2021-11-02 15:04:52'),(4836,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-02 15:05:09','2021-11-02 15:05:09'),(4837,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-11-02 15:17:46','2021-11-02 15:17:46'),(4838,'default','added',1218,'App\\Contact',1,20,'App\\User','[]','2021-11-02 15:18:40','2021-11-02 15:18:40'),(4839,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-11-02 15:18:47','2021-11-02 15:18:47'),(4840,'default','added',1219,'App\\Contact',1,4,'App\\User','[]','2021-11-02 15:19:31','2021-11-02 15:19:31'),(4841,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-02 15:20:01','2021-11-02 15:20:01'),(4842,'default','added',1395,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":75}}','2021-11-02 15:21:29','2021-11-02 15:21:29'),(4843,'default','added',1220,'App\\Contact',1,4,'App\\User','[]','2021-11-02 15:42:14','2021-11-02 15:42:14'),(4844,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-11-02 15:53:21','2021-11-02 15:53:21'),(4845,'default','added',1396,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-11-02 15:55:08','2021-11-02 15:55:08'),(4846,'default','status_changed',1188,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-02 15:55:35','2021-11-02 15:55:35'),(4847,'default','added',1221,'App\\Contact',1,4,'App\\User','[]','2021-11-02 16:08:16','2021-11-02 16:08:16'),(4848,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-02 16:10:34','2021-11-02 16:10:34'),(4849,'default','added',1397,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-11-02 16:15:52','2021-11-02 16:15:52'),(4850,'default','status_changed',1184,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-02 16:16:05','2021-11-02 16:16:05'),(4851,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-11-02 16:17:44','2021-11-02 16:17:44'),(4852,'default','added',1398,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-11-02 16:20:21','2021-11-02 16:20:21'),(4853,'default','status_changed',1216,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Check In Progress\"}','2021-11-02 16:29:00','2021-11-02 16:29:00'),(4854,'default','status_changed',1224,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Check In Progress\"}','2021-11-02 16:29:08','2021-11-02 16:29:08'),(4855,'default','status_changed',1222,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Check In Progress\"}','2021-11-02 16:29:19','2021-11-02 16:29:19'),(4856,'default','status_changed',1221,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Check In Progress\"}','2021-11-02 16:29:26','2021-11-02 16:29:26'),(4857,'default','status_changed',1230,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-11-02 16:30:18','2021-11-02 16:30:18'),(4858,'default','added',1399,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-02 16:39:25','2021-11-02 16:39:25'),(4859,'default','status_changed',1195,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Check In Progress\"}','2021-11-02 16:45:21','2021-11-02 16:45:21'),(4860,'default','status_changed',1223,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Check In Progress\"}','2021-11-02 16:48:24','2021-11-02 16:48:24'),(4861,'default','added',1222,'App\\Contact',1,4,'App\\User','[]','2021-11-02 16:49:39','2021-11-02 16:49:39'),(4862,'default','added',1223,'App\\Contact',1,4,'App\\User','[]','2021-11-02 17:02:32','2021-11-02 17:02:32'),(4863,'default','status_changed',1187,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-02 17:10:24','2021-11-02 17:10:24'),(4864,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-11-02 18:06:37','2021-11-02 18:06:37'),(4865,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-02 18:06:45','2021-11-02 18:06:45'),(4866,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-02 18:08:03','2021-11-02 18:08:03'),(4867,'default','edited',15,'App\\User',1,1,'App\\User','[]','2021-11-02 18:19:19','2021-11-02 18:19:19'),(4868,'default','logout',15,'App\\User',1,15,'App\\User','[]','2021-11-02 18:20:09','2021-11-02 18:20:09'),(4869,'default','login',15,'App\\User',1,15,'App\\User','[]','2021-11-02 18:20:43','2021-11-02 18:20:43'),(4870,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-02 18:34:52','2021-11-02 18:34:52'),(4871,'default','status_changed',1184,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-02 18:39:21','2021-11-02 18:39:21'),(4872,'default','added',1400,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-11-02 18:39:25','2021-11-02 18:39:25'),(4873,'default','status_changed',1209,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-02 18:40:17','2021-11-02 18:40:17'),(4874,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-02 18:40:20','2021-11-02 18:40:20'),(4875,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-11-02 18:42:52','2021-11-02 18:42:52'),(4876,'default','added',1401,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-11-02 18:44:19','2021-11-02 18:44:19'),(4877,'default','status_changed',1232,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-02 18:44:34','2021-11-02 18:44:34'),(4878,'default','added',1224,'App\\Contact',1,4,'App\\User','[]','2021-11-02 18:46:43','2021-11-02 18:46:43'),(4879,'default','added',1402,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-11-02 18:56:42','2021-11-02 18:56:42'),(4880,'default','status_changed',1233,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-02 18:56:53','2021-11-02 18:56:53'),(4881,'default','added',1403,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-02 19:15:39','2021-11-02 19:15:39'),(4882,'default','added',1404,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-11-02 19:22:07','2021-11-02 19:22:07'),(4883,'default','added',1405,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-02 19:23:18','2021-11-02 19:23:18'),(4884,'default','status_changed',1226,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-02 19:26:10','2021-11-02 19:26:10'),(4885,'default','status_changed',1227,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-02 19:27:02','2021-11-02 19:27:02'),(4886,'default','added',1225,'App\\Contact',1,4,'App\\User','[]','2021-11-02 19:28:22','2021-11-02 19:28:22'),(4887,'default','added',1226,'App\\Contact',1,4,'App\\User','[]','2021-11-02 19:35:06','2021-11-02 19:35:06'),(4888,'default','added',1406,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-11-02 19:43:08','2021-11-02 19:43:08'),(4889,'default','status_changed',1201,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-02 19:43:17','2021-11-02 19:43:17'),(4890,'default','added',1407,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-11-02 19:44:45','2021-11-02 19:44:45'),(4891,'default','status_changed',1177,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-02 19:45:04','2021-11-02 19:45:04'),(4892,'default','status_changed',1230,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-02 19:47:14','2021-11-02 19:47:14'),(4893,'default','added',1408,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-02 19:48:30','2021-11-02 19:48:30'),(4894,'default','added',1409,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-02 19:50:34','2021-11-02 19:50:34'),(4895,'default','status_changed',1235,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-11-02 19:53:56','2021-11-02 19:53:56'),(4896,'default','status_changed',1234,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-02 19:54:45','2021-11-02 19:54:45'),(4897,'default','added',1227,'App\\Contact',1,4,'App\\User','[]','2021-11-02 19:55:26','2021-11-02 19:55:26'),(4898,'default','added',1228,'App\\Contact',1,20,'App\\User','[]','2021-11-02 20:34:45','2021-11-02 20:34:45'),(4899,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-11-02 20:41:46','2021-11-02 20:41:46'),(4900,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-02 20:41:54','2021-11-02 20:41:54'),(4901,'default','added',1229,'App\\Contact',1,11,'App\\User','[]','2021-11-02 20:42:32','2021-11-02 20:42:32'),(4902,'default','logout',20,'App\\User',1,20,'App\\User','[]','2021-11-02 20:47:39','2021-11-02 20:47:39'),(4903,'default','added',1230,'App\\Contact',1,11,'App\\User','[]','2021-11-02 20:53:21','2021-11-02 20:53:21'),(4904,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-02 21:07:31','2021-11-02 21:07:31'),(4905,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-11-02 21:07:58','2021-11-02 21:07:58'),(4906,'default','added',1410,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-02 21:08:50','2021-11-02 21:08:50'),(4907,'default','added',1411,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-11-02 21:12:02','2021-11-02 21:12:02'),(4908,'default','status_changed',1236,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-02 21:12:22','2021-11-02 21:12:22'),(4909,'default','added',1412,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-11-02 21:13:08','2021-11-02 21:13:08'),(4910,'default','status_changed',1235,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-02 21:14:27','2021-11-02 21:14:27'),(4911,'default','added',1413,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":400}}','2021-11-02 21:15:54','2021-11-02 21:15:54'),(4912,'default','added',1414,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-11-02 21:17:27','2021-11-02 21:17:27'),(4913,'default','added',1415,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-11-02 21:20:03','2021-11-02 21:20:03'),(4914,'default','logout',20,'App\\User',1,20,'App\\User','[]','2021-11-02 21:36:45','2021-11-02 21:36:45'),(4915,'default','status_changed',1220,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-02 21:36:51','2021-11-02 21:36:51'),(4916,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-11-02 21:37:03','2021-11-02 21:37:03'),(4917,'default','payment_edited',1395,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"75.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"75.0000\"}}','2021-11-02 21:37:26','2021-11-02 21:37:26'),(4918,'default','status_changed',1202,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-02 21:38:11','2021-11-02 21:38:11'),(4919,'default','edited',1380,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"100.0000\"}}','2021-11-02 21:38:39','2021-11-02 21:38:39'),(4920,'default','added',1416,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-02 21:40:03','2021-11-02 21:40:03'),(4921,'default','added',1417,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-02 21:40:43','2021-11-02 21:40:43'),(4922,'default','added',1231,'App\\Contact',1,4,'App\\User','[]','2021-11-02 22:19:53','2021-11-02 22:19:53'),(4923,'default','added',1232,'App\\Contact',1,4,'App\\User','[]','2021-11-02 22:26:00','2021-11-02 22:26:00'),(4924,'default','added',1418,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-11-02 22:40:07','2021-11-02 22:40:07'),(4925,'default','status_changed',1217,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-02 22:41:25','2021-11-02 22:41:25'),(4926,'default','added',1419,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-02 22:42:55','2021-11-02 22:42:55'),(4927,'default','status_changed',1231,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-02 22:47:55','2021-11-02 22:47:55'),(4928,'default','added',1420,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-11-02 22:54:03','2021-11-02 22:54:03'),(4929,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-03 11:23:30','2021-11-03 11:23:30'),(4930,'default','added',1421,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-11-03 11:26:33','2021-11-03 11:26:33'),(4931,'default','status_changed',1229,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-03 11:26:46','2021-11-03 11:26:46'),(4932,'default','added',1233,'App\\Contact',1,11,'App\\User','[]','2021-11-03 11:59:02','2021-11-03 11:59:02'),(4933,'default','status_changed',751,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-11-03 12:06:26','2021-11-03 12:06:26'),(4934,'default','status_changed',882,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-11-03 12:08:51','2021-11-03 12:08:51'),(4935,'default','added',1422,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-11-03 12:44:29','2021-11-03 12:44:29'),(4936,'default','status_changed',1198,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-03 12:44:49','2021-11-03 12:44:49'),(4937,'default','status_changed',1231,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-11-03 12:45:41','2021-11-03 12:45:41'),(4938,'default','added',1423,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-03 13:04:18','2021-11-03 13:04:18'),(4939,'default','added',1234,'App\\Contact',1,11,'App\\User','[]','2021-11-03 13:40:04','2021-11-03 13:40:04'),(4940,'default','added',1235,'App\\Contact',1,11,'App\\User','[]','2021-11-03 13:40:55','2021-11-03 13:40:55'),(4941,'default','added',1424,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-11-03 13:47:29','2021-11-03 13:47:29'),(4942,'default','added',1236,'App\\Contact',1,11,'App\\User','[]','2021-11-03 14:18:36','2021-11-03 14:18:36'),(4943,'default','added',1237,'App\\Contact',1,11,'App\\User','[]','2021-11-03 14:40:57','2021-11-03 14:40:57'),(4944,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-11-03 14:44:47','2021-11-03 14:44:47'),(4945,'default','added',1238,'App\\Contact',1,11,'App\\User','[]','2021-11-03 14:47:31','2021-11-03 14:47:31'),(4946,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-03 14:55:53','2021-11-03 14:55:53'),(4947,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-11-03 14:58:40','2021-11-03 14:58:40'),(4948,'default','logout',20,'App\\User',1,20,'App\\User','[]','2021-11-03 15:01:19','2021-11-03 15:01:19'),(4949,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-11-03 15:01:43','2021-11-03 15:01:43'),(4950,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-11-03 15:03:25','2021-11-03 15:03:25'),(4951,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-03 15:05:36','2021-11-03 15:05:36'),(4952,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-03 15:10:09','2021-11-03 15:10:09'),(4953,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-11-03 15:10:18','2021-11-03 15:10:18'),(4954,'default','added',1239,'App\\Contact',1,4,'App\\User','[]','2021-11-03 15:23:17','2021-11-03 15:23:17'),(4955,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-11-03 15:50:49','2021-11-03 15:50:49'),(4956,'default','status_changed',1231,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-11-03 15:54:23','2021-11-03 15:54:23'),(4957,'default','status_changed',229,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-11-03 16:14:05','2021-11-03 16:14:05'),(4958,'default','status_changed',1227,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-11-03 16:14:48','2021-11-03 16:14:48'),(4959,'default','added',1240,'App\\Contact',1,4,'App\\User','[]','2021-11-03 16:43:30','2021-11-03 16:43:30'),(4960,'default','added',1425,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":900}}','2021-11-03 17:02:26','2021-11-03 17:02:26'),(4961,'default','added',1241,'App\\Contact',1,4,'App\\User','[]','2021-11-03 17:33:30','2021-11-03 17:33:30'),(4962,'default','added',1242,'App\\Contact',1,4,'App\\User','[]','2021-11-03 17:50:39','2021-11-03 17:50:39'),(4963,'default','added',1243,'App\\Contact',1,4,'App\\User','[]','2021-11-03 18:06:19','2021-11-03 18:06:19'),(4964,'default','added',1244,'App\\Contact',1,4,'App\\User','[]','2021-11-03 18:11:31','2021-11-03 18:11:31'),(4965,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-11-03 18:43:09','2021-11-03 18:43:09'),(4966,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-03 18:43:18','2021-11-03 18:43:18'),(4967,'default','added',1245,'App\\Contact',1,11,'App\\User','[]','2021-11-03 18:43:54','2021-11-03 18:43:54'),(4968,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-03 18:51:59','2021-11-03 18:51:59'),(4969,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-11-03 19:02:20','2021-11-03 19:02:20'),(4970,'default','added',1246,'App\\Contact',1,4,'App\\User','[]','2021-11-03 19:09:02','2021-11-03 19:09:02'),(4971,'default','status_changed',1246,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-11-03 19:13:38','2021-11-03 19:13:38'),(4972,'default','added',1247,'App\\Contact',1,4,'App\\User','[]','2021-11-03 19:28:59','2021-11-03 19:28:59'),(4973,'default','added',1426,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-11-03 19:30:44','2021-11-03 19:30:44'),(4974,'default','status_changed',1247,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-03 19:30:59','2021-11-03 19:30:59'),(4975,'default','added',1248,'App\\Contact',1,4,'App\\User','[]','2021-11-03 19:33:54','2021-11-03 19:33:54'),(4976,'default','added',1427,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":175}}','2021-11-03 19:47:30','2021-11-03 19:47:30'),(4977,'default','status_changed',1205,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-03 19:47:59','2021-11-03 19:47:59'),(4978,'default','added',1428,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250}}','2021-11-03 19:58:46','2021-11-03 19:58:46'),(4979,'default','added',1429,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-03 20:01:02','2021-11-03 20:01:02'),(4980,'default','added',1430,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-03 20:01:49','2021-11-03 20:01:49'),(4981,'default','added',1431,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-03 20:02:42','2021-11-03 20:02:42'),(4982,'default','added',1432,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-03 20:03:23','2021-11-03 20:03:23'),(4983,'default','status_changed',577,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Check In Progress\"}','2021-11-03 20:23:17','2021-11-03 20:23:17'),(4984,'default','status_changed',1087,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Check In Progress\"}','2021-11-03 20:23:26','2021-11-03 20:23:26'),(4985,'default','status_changed',1122,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Check In Progress\"}','2021-11-03 20:24:19','2021-11-03 20:24:19'),(4986,'default','added',1249,'App\\Contact',1,4,'App\\User','[]','2021-11-03 20:32:12','2021-11-03 20:32:12'),(4987,'default','added',1250,'App\\Contact',1,4,'App\\User','[]','2021-11-03 20:40:08','2021-11-03 20:40:08'),(4988,'default','added',1433,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-11-03 20:47:06','2021-11-03 20:47:06'),(4989,'default','status_changed',1262,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-03 20:47:24','2021-11-03 20:47:24'),(4990,'default','added',1434,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-11-03 20:57:20','2021-11-03 20:57:20'),(4991,'default','status_changed',1256,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-03 20:58:09','2021-11-03 20:58:09'),(4992,'default','added',1435,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":850}}','2021-11-03 20:58:37','2021-11-03 20:58:37'),(4993,'default','status_changed',1226,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-03 20:59:00','2021-11-03 20:59:00'),(4994,'default','added',1436,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-11-03 20:59:30','2021-11-03 20:59:30'),(4995,'default','status_changed',1227,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-03 21:00:06','2021-11-03 21:00:06'),(4996,'default','added',1251,'App\\Contact',1,4,'App\\User','[]','2021-11-03 21:06:07','2021-11-03 21:06:07'),(4997,'default','added',1437,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-11-03 21:15:48','2021-11-03 21:15:48'),(4998,'default','status_changed',1234,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-03 21:16:09','2021-11-03 21:16:09'),(4999,'default','added',1438,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-11-03 21:25:34','2021-11-03 21:25:34'),(5000,'default','added',1439,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-11-03 21:48:33','2021-11-03 21:48:33'),(5001,'default','added',1440,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-03 21:55:05','2021-11-03 21:55:05'),(5002,'default','added',1441,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-11-03 22:00:52','2021-11-03 22:00:52'),(5003,'default','status_changed',1266,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-03 22:01:08','2021-11-03 22:01:08'),(5004,'default','added',1442,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-11-03 22:06:13','2021-11-03 22:06:13'),(5005,'default','status_changed',1243,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-03 22:06:34','2021-11-03 22:06:34'),(5006,'default','added',1443,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-11-03 22:14:01','2021-11-03 22:14:01'),(5007,'default','status_changed',1239,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-03 22:14:14','2021-11-03 22:14:14'),(5008,'default','added',1444,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-03 22:58:30','2021-11-03 22:58:30'),(5009,'default','added',1445,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-03 22:59:19','2021-11-03 22:59:19'),(5010,'default','added',1446,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-03 23:00:45','2021-11-03 23:00:45'),(5011,'default','added',1447,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-03 23:02:07','2021-11-03 23:02:07'),(5012,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-11-03 23:11:11','2021-11-03 23:11:11'),(5013,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-11-03 23:20:32','2021-11-03 23:20:32'),(5014,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-11-03 23:20:49','2021-11-03 23:20:49'),(5015,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-04 11:38:31','2021-11-04 11:38:31'),(5016,'default','added',1252,'App\\Contact',1,11,'App\\User','[]','2021-11-04 12:51:01','2021-11-04 12:51:01'),(5017,'default','added',1448,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-11-04 14:02:10','2021-11-04 14:02:10'),(5018,'default','status_changed',1257,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-04 14:02:24','2021-11-04 14:02:24'),(5019,'default','added',1253,'App\\Contact',1,11,'App\\User','[]','2021-11-04 14:35:06','2021-11-04 14:35:06'),(5020,'default','added',1449,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-11-04 14:40:29','2021-11-04 14:40:29'),(5021,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-04 15:06:26','2021-11-04 15:06:26'),(5022,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-11-04 15:09:04','2021-11-04 15:09:04'),(5023,'default','added',1450,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-04 15:12:57','2021-11-04 15:12:57'),(5024,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-04 15:18:56','2021-11-04 15:18:56'),(5025,'default','added',1254,'App\\Contact',1,4,'App\\User','[]','2021-11-04 15:23:29','2021-11-04 15:23:29'),(5026,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-11-04 15:24:34','2021-11-04 15:24:34'),(5027,'default','status_changed',1245,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-04 15:35:38','2021-11-04 15:35:38'),(5028,'default','added',1255,'App\\Contact',1,4,'App\\User','[]','2021-11-04 15:36:42','2021-11-04 15:36:42'),(5029,'default','status_changed',1265,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-04 15:44:15','2021-11-04 15:44:15'),(5030,'default','added',1451,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-11-04 15:44:22','2021-11-04 15:44:22'),(5031,'default','status_changed',1267,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-04 15:44:22','2021-11-04 15:44:22'),(5032,'default','status_changed',1263,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-04 15:44:38','2021-11-04 15:44:38'),(5033,'default','added',1256,'App\\Contact',1,4,'App\\User','[]','2021-11-04 15:49:00','2021-11-04 15:49:00'),(5034,'default','status_changed',1249,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Waiting for customer approve\"}','2021-11-04 15:57:02','2021-11-04 15:57:02'),(5035,'default','added',1452,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-11-04 16:22:37','2021-11-04 16:22:37'),(5036,'default','status_changed',1248,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-04 16:22:49','2021-11-04 16:22:49'),(5037,'default','added',1453,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-11-04 16:23:50','2021-11-04 16:23:50'),(5038,'default','added',1257,'App\\Contact',1,4,'App\\User','[]','2021-11-04 16:24:34','2021-11-04 16:24:34'),(5039,'default','added',1258,'App\\Contact',1,4,'App\\User','[]','2021-11-04 16:31:34','2021-11-04 16:31:34'),(5040,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-04 17:03:08','2021-11-04 17:03:08'),(5041,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-11-04 17:03:20','2021-11-04 17:03:20'),(5042,'default','added',1259,'App\\Contact',1,4,'App\\User','[]','2021-11-04 17:05:48','2021-11-04 17:05:48'),(5043,'default','status_changed',1082,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-04 17:21:39','2021-11-04 17:21:39'),(5044,'default','added',1454,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}','2021-11-04 17:46:30','2021-11-04 17:46:30'),(5045,'default','status_changed',1215,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-04 17:47:33','2021-11-04 17:47:33'),(5046,'default','added',1455,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-11-04 18:13:03','2021-11-04 18:13:03'),(5047,'default','status_changed',1252,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-04 18:13:17','2021-11-04 18:13:17'),(5048,'default','added',1456,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-11-04 18:15:05','2021-11-04 18:15:05'),(5049,'default','status_changed',1254,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-04 18:15:21','2021-11-04 18:15:21'),(5050,'default','added',1260,'App\\Contact',1,4,'App\\User','[]','2021-11-04 18:22:33','2021-11-04 18:22:33'),(5051,'default','added',1261,'App\\Contact',1,4,'App\\User','[]','2021-11-04 18:34:32','2021-11-04 18:34:32'),(5052,'default','added',1457,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-11-04 18:40:27','2021-11-04 18:40:27'),(5053,'default','status_changed',1273,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-04 18:40:37','2021-11-04 18:40:37'),(5054,'default','status_changed',968,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-04 18:48:59','2021-11-04 18:48:59'),(5055,'default','status_changed',1259,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-04 18:57:55','2021-11-04 18:57:55'),(5056,'default','status_changed',1265,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-04 18:58:21','2021-11-04 18:58:21'),(5057,'default','added',1458,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-11-04 19:00:56','2021-11-04 19:00:56'),(5058,'default','added',1459,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-11-04 19:02:18','2021-11-04 19:02:18'),(5059,'default','added',1460,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-04 19:04:30','2021-11-04 19:04:30'),(5060,'default','added',1461,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-04 19:05:26','2021-11-04 19:05:26'),(5061,'default','added',1462,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-04 19:06:12','2021-11-04 19:06:12'),(5062,'default','added',1463,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-04 19:06:58','2021-11-04 19:06:58'),(5063,'default','added',1464,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-04 19:08:00','2021-11-04 19:08:00'),(5064,'default','added',1465,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-04 19:08:41','2021-11-04 19:08:41'),(5065,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-11-04 19:35:25','2021-11-04 19:35:25'),(5066,'default','login',15,'App\\User',1,15,'App\\User','[]','2021-11-04 19:37:18','2021-11-04 19:37:18'),(5067,'default','status_changed',1253,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-04 19:37:34','2021-11-04 19:37:34'),(5068,'default','payment_edited',1425,'App\\Transaction',1,15,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"900.0000\"}}','2021-11-04 19:39:12','2021-11-04 19:39:12'),(5069,'default','added',1262,'App\\Contact',1,20,'App\\User','[]','2021-11-04 19:45:13','2021-11-04 19:45:13'),(5070,'default','added',1466,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-04 19:45:25','2021-11-04 19:45:25'),(5071,'default','added',1467,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-11-04 19:51:26','2021-11-04 19:51:26'),(5072,'default','status_changed',1260,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-04 19:51:43','2021-11-04 19:51:43'),(5073,'default','added',1468,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1}}','2021-11-04 20:19:25','2021-11-04 20:19:25'),(5074,'default','status_changed',1277,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-04 20:19:35','2021-11-04 20:19:35'),(5075,'default','added',1469,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-04 20:36:17','2021-11-04 20:36:17'),(5076,'default','added',1470,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-04 20:38:36','2021-11-04 20:38:36'),(5077,'default','added',1263,'App\\Contact',1,4,'App\\User','[]','2021-11-04 20:54:50','2021-11-04 20:54:50'),(5078,'default','added',1471,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-04 21:12:28','2021-11-04 21:12:28'),(5079,'default','added',1472,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-04 21:34:44','2021-11-04 21:34:44'),(5080,'default','added',1473,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-11-04 21:35:15','2021-11-04 21:35:15'),(5081,'default','status_changed',1238,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-04 21:35:28','2021-11-04 21:35:28'),(5082,'default','added',1474,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-11-04 21:40:35','2021-11-04 21:40:35'),(5083,'default','status_changed',1278,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-04 21:40:59','2021-11-04 21:40:59'),(5084,'default','added',1475,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-11-04 21:57:10','2021-11-04 21:57:10'),(5085,'default','status_changed',1279,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-04 21:57:27','2021-11-04 21:57:27'),(5086,'default','added',1476,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-04 22:31:46','2021-11-04 22:31:46'),(5087,'default','added',1477,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-04 22:34:58','2021-11-04 22:34:58'),(5088,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-11-04 22:46:58','2021-11-04 22:46:58'),(5089,'default','edited',1468,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1.0000\"}}','2021-11-04 22:47:31','2021-11-04 22:47:31'),(5090,'default','payment_edited',1413,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"400.0000\"}}','2021-11-04 22:48:41','2021-11-04 22:48:41'),(5091,'default','logout',20,'App\\User',1,20,'App\\User','[]','2021-11-04 23:27:18','2021-11-04 23:27:18'),(5092,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-11-05 13:06:30','2021-11-05 13:06:30'),(5093,'default','status_changed',1122,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-05 13:09:07','2021-11-05 13:09:07'),(5094,'default','added',1478,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-05 13:16:17','2021-11-05 13:16:17'),(5095,'default','added',1264,'App\\Contact',1,4,'App\\User','[]','2021-11-05 16:54:39','2021-11-05 16:54:39'),(5096,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-11-05 18:20:01','2021-11-05 18:20:01'),(5097,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-05 18:50:56','2021-11-05 18:50:56'),(5098,'default','added',1265,'App\\Contact',1,11,'App\\User','[]','2021-11-05 18:52:00','2021-11-05 18:52:00'),(5099,'default','added',1266,'App\\Contact',1,11,'App\\User','[]','2021-11-05 19:03:38','2021-11-05 19:03:38'),(5100,'default','added',1267,'App\\Contact',1,11,'App\\User','[]','2021-11-05 19:11:38','2021-11-05 19:11:38'),(5101,'default','added',1268,'App\\Contact',1,11,'App\\User','[]','2021-11-05 19:17:16','2021-11-05 19:17:16'),(5102,'default','status_changed',1238,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-11-05 19:49:39','2021-11-05 19:49:39'),(5103,'default','added',1269,'App\\Contact',1,11,'App\\User','[]','2021-11-05 20:05:16','2021-11-05 20:05:16'),(5104,'default','added',1270,'App\\Contact',1,11,'App\\User','[]','2021-11-05 21:17:01','2021-11-05 21:17:01'),(5105,'default','added',1271,'App\\Contact',1,11,'App\\User','[]','2021-11-05 21:21:54','2021-11-05 21:21:54'),(5106,'default','added',1479,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-11-05 21:40:00','2021-11-05 21:40:00'),(5107,'default','status_changed',1219,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-05 21:40:13','2021-11-05 21:40:13'),(5108,'default','added',1272,'App\\Contact',1,11,'App\\User','[]','2021-11-05 22:22:34','2021-11-05 22:22:34'),(5109,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-06 12:09:04','2021-11-06 12:09:04'),(5110,'default','added',1480,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-11-06 12:13:40','2021-11-06 12:13:40'),(5111,'default','status_changed',1228,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-06 12:13:58','2021-11-06 12:13:58'),(5112,'default','added',1273,'App\\Contact',1,11,'App\\User','[]','2021-11-06 12:21:44','2021-11-06 12:21:44'),(5113,'default','added',1274,'App\\Contact',1,11,'App\\User','[]','2021-11-06 12:28:21','2021-11-06 12:28:21'),(5114,'default','added',1275,'App\\Contact',1,11,'App\\User','[]','2021-11-06 12:29:11','2021-11-06 12:29:11'),(5115,'default','login',19,'App\\User',1,19,'App\\User','[]','2021-11-06 13:02:03','2021-11-06 13:02:03'),(5116,'default','login',19,'App\\User',1,19,'App\\User','[]','2021-11-06 13:03:21','2021-11-06 13:03:21'),(5117,'default','added',1276,'App\\Contact',1,11,'App\\User','[]','2021-11-06 13:06:08','2021-11-06 13:06:08'),(5118,'default','added',1277,'App\\Contact',1,11,'App\\User','[]','2021-11-06 13:06:56','2021-11-06 13:06:56'),(5119,'default','added',1481,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-11-06 13:15:13','2021-11-06 13:15:13'),(5120,'default','added',1278,'App\\Contact',1,11,'App\\User','[]','2021-11-06 13:34:22','2021-11-06 13:34:22'),(5121,'default','added',1279,'App\\Contact',1,11,'App\\User','[]','2021-11-06 14:05:37','2021-11-06 14:05:37'),(5122,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-06 14:10:52','2021-11-06 14:10:52'),(5123,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-11-06 14:11:25','2021-11-06 14:11:25'),(5124,'default','added',1482,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-06 14:13:59','2021-11-06 14:13:59'),(5125,'default','added',1483,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-06 14:15:46','2021-11-06 14:15:46'),(5126,'default','added',1484,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-06 14:17:27','2021-11-06 14:17:27'),(5127,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-11-06 14:41:34','2021-11-06 14:41:34'),(5128,'default','added',1485,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-11-06 14:51:17','2021-11-06 14:51:17'),(5129,'default','added',1280,'App\\Contact',1,4,'App\\User','[]','2021-11-06 14:57:37','2021-11-06 14:57:37'),(5130,'default','added',1281,'App\\Contact',1,4,'App\\User','[]','2021-11-06 14:58:18','2021-11-06 14:58:18'),(5131,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-11-06 15:35:32','2021-11-06 15:35:32'),(5132,'default','status_changed',1258,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-11-06 16:00:04','2021-11-06 16:00:04'),(5133,'default','added',1486,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-06 16:01:31','2021-11-06 16:01:31'),(5134,'default','status_changed',233,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-06 16:02:13','2021-11-06 16:02:13'),(5135,'default','status_changed',1208,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-06 16:02:22','2021-11-06 16:02:22'),(5136,'default','status_changed',1238,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-11-06 16:02:36','2021-11-06 16:02:36'),(5137,'default','status_changed',1293,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-11-06 16:02:52','2021-11-06 16:02:52'),(5138,'default','added',1282,'App\\Contact',1,4,'App\\User','[]','2021-11-06 16:03:46','2021-11-06 16:03:46'),(5139,'default','status_changed',1281,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-11-06 16:03:52','2021-11-06 16:03:52'),(5140,'default','status_changed',1290,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-11-06 16:04:30','2021-11-06 16:04:30'),(5141,'default','status_changed',1291,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-11-06 16:04:50','2021-11-06 16:04:50'),(5142,'default','status_changed',1282,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-06 16:05:02','2021-11-06 16:05:02'),(5143,'default','status_changed',1287,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-06 16:05:24','2021-11-06 16:05:24'),(5144,'default','status_changed',1294,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-06 16:05:40','2021-11-06 16:05:40'),(5145,'default','status_changed',1289,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-06 16:05:48','2021-11-06 16:05:48'),(5146,'default','status_changed',1284,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-06 16:05:57','2021-11-06 16:05:57'),(5147,'default','status_changed',1252,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-06 16:17:02','2021-11-06 16:17:02'),(5148,'default','added',1283,'App\\Contact',1,4,'App\\User','[]','2021-11-06 16:17:33','2021-11-06 16:17:33'),(5149,'default','status_changed',1291,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-06 16:43:34','2021-11-06 16:43:34'),(5150,'default','added',1284,'App\\Contact',1,4,'App\\User','[]','2021-11-06 18:37:57','2021-11-06 18:37:57'),(5151,'default','logout',20,'App\\User',1,20,'App\\User','[]','2021-11-06 19:06:42','2021-11-06 19:06:42'),(5152,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-06 19:07:02','2021-11-06 19:07:02'),(5153,'default','added',1487,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}','2021-11-06 19:12:55','2021-11-06 19:12:55'),(5154,'default','status_changed',1046,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-06 19:14:33','2021-11-06 19:14:33'),(5155,'default','added',1285,'App\\Contact',1,4,'App\\User','[]','2021-11-06 19:22:48','2021-11-06 19:22:48'),(5156,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-11-06 19:26:14','2021-11-06 19:26:14'),(5157,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-06 19:26:22','2021-11-06 19:26:22'),(5158,'default','added',1488,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-11-06 19:29:23','2021-11-06 19:29:23'),(5159,'default','status_changed',1284,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-06 19:32:54','2021-11-06 19:32:54'),(5160,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-06 19:34:15','2021-11-06 19:34:15'),(5161,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-11-06 19:37:55','2021-11-06 19:37:55'),(5162,'default','added',1489,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-11-06 19:39:45','2021-11-06 19:39:45'),(5163,'default','status_changed',1293,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-06 19:40:03','2021-11-06 19:40:03'),(5164,'default','added',1490,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-11-06 19:41:40','2021-11-06 19:41:40'),(5165,'default','status_changed',1290,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-06 19:41:52','2021-11-06 19:41:52'),(5166,'default','added',1491,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-11-06 19:42:50','2021-11-06 19:42:50'),(5167,'default','status_changed',1295,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-06 19:43:00','2021-11-06 19:43:00'),(5168,'default','added',1286,'App\\Contact',1,20,'App\\User','[]','2021-11-06 20:17:24','2021-11-06 20:17:24'),(5169,'default','added',1492,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}','2021-11-06 20:35:54','2021-11-06 20:35:54'),(5170,'default','status_changed',1281,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-06 20:36:16','2021-11-06 20:36:16'),(5171,'default','added',1287,'App\\Contact',1,20,'App\\User','[]','2021-11-06 20:45:25','2021-11-06 20:45:25'),(5172,'default','added',1288,'App\\Contact',1,20,'App\\User','[]','2021-11-06 20:56:36','2021-11-06 20:56:36'),(5173,'default','added',1493,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-11-06 21:21:03','2021-11-06 21:21:03'),(5174,'default','status_changed',1301,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-06 21:21:51','2021-11-06 21:21:51'),(5175,'default','status_changed',1144,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-06 21:34:05','2021-11-06 21:34:05'),(5176,'default','added',1289,'App\\Contact',1,20,'App\\User','[]','2021-11-06 21:40:32','2021-11-06 21:40:32'),(5177,'default','status_changed',1303,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Deliverd\"}','2021-11-06 21:48:10','2021-11-06 21:48:10'),(5178,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-06 21:48:11','2021-11-06 21:48:11'),(5179,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-11-06 21:48:23','2021-11-06 21:48:23'),(5180,'default','added',1494,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-06 21:58:38','2021-11-06 21:58:38'),(5181,'default','added',1495,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-06 21:59:28','2021-11-06 21:59:28'),(5182,'default','added',1496,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-06 22:00:25','2021-11-06 22:00:25'),(5183,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-11-06 22:07:03','2021-11-06 22:07:03'),(5184,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-11-06 22:07:17','2021-11-06 22:07:17'),(5185,'default','payment_edited',1115,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"250.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"250.0000\"}}','2021-11-06 22:14:02','2021-11-06 22:14:02'),(5186,'default','added',1497,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}','2021-11-06 22:18:05','2021-11-06 22:18:05'),(5187,'default','status_changed',1174,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-06 22:18:22','2021-11-06 22:18:22'),(5188,'default','added',1498,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}','2021-11-06 22:18:59','2021-11-06 22:18:59'),(5189,'default','status_changed',968,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-06 22:19:09','2021-11-06 22:19:09'),(5190,'default','logout',20,'App\\User',1,20,'App\\User','[]','2021-11-06 22:21:28','2021-11-06 22:21:28'),(5191,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-11-06 22:21:37','2021-11-06 22:21:37'),(5192,'default','added',1499,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-06 22:22:22','2021-11-06 22:22:22'),(5193,'default','added',1500,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-06 22:35:09','2021-11-06 22:35:09'),(5194,'default','added',1501,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-06 22:44:27','2021-11-06 22:44:27'),(5195,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-11-07 12:16:07','2021-11-07 12:16:07'),(5196,'default','added',1290,'App\\Contact',1,20,'App\\User','[]','2021-11-07 12:38:07','2021-11-07 12:38:07'),(5197,'default','added',1291,'App\\Contact',1,20,'App\\User','[]','2021-11-07 12:51:50','2021-11-07 12:51:50'),(5198,'default','added',1292,'App\\Contact',1,20,'App\\User','[]','2021-11-07 12:58:19','2021-11-07 12:58:19'),(5199,'default','added',1293,'App\\Contact',1,20,'App\\User','[]','2021-11-07 13:09:57','2021-11-07 13:09:57'),(5200,'default','added',1294,'App\\Contact',1,20,'App\\User','[]','2021-11-07 13:44:10','2021-11-07 13:44:10'),(5201,'default','status_changed',1308,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-07 13:57:27','2021-11-07 13:57:27'),(5202,'default','status_changed',1302,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-11-07 13:58:43','2021-11-07 13:58:43'),(5203,'default','status_changed',1208,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-11-07 13:59:27','2021-11-07 13:59:27'),(5204,'default','status_changed',1252,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-11-07 13:59:50','2021-11-07 13:59:50'),(5205,'default','status_changed',1282,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-11-07 14:00:28','2021-11-07 14:00:28'),(5206,'default','status_changed',1287,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-11-07 14:00:37','2021-11-07 14:00:37'),(5207,'default','status_changed',1294,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-11-07 14:00:44','2021-11-07 14:00:44'),(5208,'default','status_changed',1296,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-11-07 14:00:53','2021-11-07 14:00:53'),(5209,'default','status_changed',882,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-11-07 14:01:02','2021-11-07 14:01:02'),(5210,'default','status_changed',1163,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-11-07 14:01:08','2021-11-07 14:01:08'),(5211,'default','status_changed',1268,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-07 14:17:01','2021-11-07 14:17:01'),(5212,'default','added',1295,'App\\Contact',1,20,'App\\User','[]','2021-11-07 14:29:39','2021-11-07 14:29:39'),(5213,'default','added',1296,'App\\Contact',1,20,'App\\User','[]','2021-11-07 14:32:29','2021-11-07 14:32:29'),(5214,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-11-07 14:55:14','2021-11-07 14:55:14'),(5215,'default','added',1502,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":225}}','2021-11-07 15:21:31','2021-11-07 15:21:31'),(5216,'default','added',1503,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":325}}','2021-11-07 15:22:15','2021-11-07 15:22:15'),(5217,'default','status_changed',1309,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-07 15:22:41','2021-11-07 15:22:41'),(5218,'default','status_changed',1310,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-07 15:22:51','2021-11-07 15:22:51'),(5219,'default','status_changed',1286,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-11-07 15:24:56','2021-11-07 15:24:56'),(5220,'default','added',1297,'App\\Contact',1,20,'App\\User','[]','2021-11-07 15:26:33','2021-11-07 15:26:33'),(5221,'default','status_changed',1288,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-11-07 15:32:12','2021-11-07 15:32:12'),(5222,'default','status_changed',740,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-11-07 15:37:33','2021-11-07 15:37:33'),(5223,'default','added',1298,'App\\Contact',1,20,'App\\User','[]','2021-11-07 16:23:30','2021-11-07 16:23:30'),(5224,'default','status_changed',740,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-11-07 16:34:55','2021-11-07 16:34:55'),(5225,'default','added',1299,'App\\Contact',1,20,'App\\User','[]','2021-11-07 16:38:21','2021-11-07 16:38:21'),(5226,'default','added',1300,'App\\Contact',1,20,'App\\User','[]','2021-11-07 16:47:08','2021-11-07 16:47:08'),(5227,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-07 16:48:10','2021-11-07 16:48:10'),(5228,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-07 16:48:35','2021-11-07 16:48:35'),(5229,'default','added',1504,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-11-07 16:54:34','2021-11-07 16:54:34'),(5230,'default','status_changed',1299,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-07 16:55:19','2021-11-07 16:55:19'),(5231,'default','added',1505,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-11-07 17:14:24','2021-11-07 17:14:24'),(5232,'default','status_changed',1294,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-07 17:14:59','2021-11-07 17:14:59'),(5233,'default','added',1506,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-07 17:16:10','2021-11-07 17:16:10'),(5234,'default','added',1507,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-07 17:16:38','2021-11-07 17:16:38'),(5235,'default','added',1508,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-07 17:17:54','2021-11-07 17:17:54'),(5236,'default','added',1509,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-07 17:19:58','2021-11-07 17:19:58'),(5237,'default','added',1301,'App\\Contact',1,20,'App\\User','[]','2021-11-07 17:27:27','2021-11-07 17:27:27'),(5238,'default','added',1510,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-11-07 17:36:26','2021-11-07 17:36:26'),(5239,'default','status_changed',1315,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-07 17:36:41','2021-11-07 17:36:41'),(5240,'default','status_changed',1150,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Not Started\"}','2021-11-07 17:39:44','2021-11-07 17:39:44'),(5241,'default','status_changed',740,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-11-07 18:14:19','2021-11-07 18:14:19'),(5242,'default','added',1302,'App\\Contact',1,20,'App\\User','[]','2021-11-07 18:29:22','2021-11-07 18:29:22'),(5243,'default','added',1511,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-11-07 18:38:15','2021-11-07 18:38:15'),(5244,'default','status_changed',1304,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-07 18:38:26','2021-11-07 18:38:26'),(5245,'default','status_changed',1305,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-07 18:38:39','2021-11-07 18:38:39'),(5246,'default','added',1303,'App\\Contact',1,20,'App\\User','[]','2021-11-07 19:22:20','2021-11-07 19:22:20'),(5247,'default','added',1304,'App\\Contact',1,20,'App\\User','[]','2021-11-07 19:28:22','2021-11-07 19:28:22'),(5248,'default','added',1512,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-11-07 19:36:21','2021-11-07 19:36:21'),(5249,'default','status_changed',1318,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-07 19:36:31','2021-11-07 19:36:31'),(5250,'default','added',1513,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-11-07 19:43:53','2021-11-07 19:43:53'),(5251,'default','status_changed',69,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-07 19:44:03','2021-11-07 19:44:03'),(5252,'default','added',1514,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-11-07 19:46:13','2021-11-07 19:46:13'),(5253,'default','status_changed',1296,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-07 19:46:22','2021-11-07 19:46:22'),(5254,'default','added',1515,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-11-07 20:06:08','2021-11-07 20:06:08'),(5255,'default','added',1516,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}','2021-11-07 20:06:41','2021-11-07 20:06:41'),(5256,'default','status_changed',1287,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-07 20:06:51','2021-11-07 20:06:51'),(5257,'default','status_changed',1286,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-07 20:06:58','2021-11-07 20:06:58'),(5258,'default','added',1517,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-11-07 20:10:36','2021-11-07 20:10:36'),(5259,'default','status_changed',1302,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-07 20:10:45','2021-11-07 20:10:45'),(5260,'default','added',1518,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}','2021-11-07 20:17:42','2021-11-07 20:17:42'),(5261,'default','status_changed',1289,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-07 20:19:47','2021-11-07 20:19:47'),(5262,'default','added',1305,'App\\Contact',1,20,'App\\User','[]','2021-11-07 20:35:24','2021-11-07 20:35:24'),(5263,'default','status_changed',1314,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-07 20:41:22','2021-11-07 20:41:22'),(5264,'default','added',1519,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-07 20:48:02','2021-11-07 20:48:02'),(5265,'default','added',1520,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-07 20:48:23','2021-11-07 20:48:23'),(5266,'default','added',1521,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}','2021-11-07 20:50:27','2021-11-07 20:50:27'),(5267,'default','status_changed',1282,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-07 20:50:37','2021-11-07 20:50:37'),(5268,'default','added',1522,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-07 20:53:01','2021-11-07 20:53:01'),(5269,'default','added',1306,'App\\Contact',1,20,'App\\User','[]','2021-11-07 21:07:12','2021-11-07 21:07:12'),(5270,'default','logout',20,'App\\User',1,20,'App\\User','[]','2021-11-07 21:21:33','2021-11-07 21:21:33'),(5271,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-07 21:21:42','2021-11-07 21:21:42'),(5272,'default','status_changed',1208,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-07 21:24:35','2021-11-07 21:24:35'),(5273,'default','status_changed',1237,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-07 21:24:54','2021-11-07 21:24:54'),(5274,'default','added',1307,'App\\Contact',1,11,'App\\User','[]','2021-11-07 21:50:23','2021-11-07 21:50:23'),(5275,'default','added',1523,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-11-07 22:19:23','2021-11-07 22:19:23'),(5276,'default','status_changed',1307,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-07 22:20:13','2021-11-07 22:20:13'),(5277,'default','added',1524,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2300}}','2021-11-07 22:52:39','2021-11-07 22:52:39'),(5278,'default','status_changed',1163,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-07 22:52:54','2021-11-07 22:52:54'),(5279,'default','added',1525,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-11-07 23:01:22','2021-11-07 23:01:22'),(5280,'default','status_changed',1311,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-07 23:01:35','2021-11-07 23:01:35'),(5281,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-07 23:02:21','2021-11-07 23:02:21'),(5282,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-08 11:36:15','2021-11-08 11:36:15'),(5283,'default','added',1308,'App\\Contact',1,11,'App\\User','[]','2021-11-08 13:16:49','2021-11-08 13:16:49'),(5284,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-11-08 14:05:49','2021-11-08 14:05:49'),(5285,'default','added',1526,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-11-08 14:07:12','2021-11-08 14:07:12'),(5286,'default','status_changed',1271,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-08 14:07:27','2021-11-08 14:07:27'),(5287,'default','added',1527,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-11-08 14:08:29','2021-11-08 14:08:29'),(5288,'default','status_changed',1270,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-08 14:08:53','2021-11-08 14:08:53'),(5289,'default','added',1309,'App\\Contact',1,11,'App\\User','[]','2021-11-08 14:20:11','2021-11-08 14:20:11'),(5290,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-08 14:26:40','2021-11-08 14:26:40'),(5291,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-08 14:36:04','2021-11-08 14:36:04'),(5292,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-11-08 14:36:51','2021-11-08 14:36:51'),(5293,'default','status_changed',1267,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-08 14:37:59','2021-11-08 14:37:59'),(5294,'default','added',1528,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-11-08 14:54:57','2021-11-08 14:54:57'),(5295,'default','status_changed',1252,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-08 14:55:13','2021-11-08 14:55:13'),(5296,'default','added',1310,'App\\Contact',1,4,'App\\User','[]','2021-11-08 15:52:56','2021-11-08 15:52:56'),(5297,'default','added',1529,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-11-08 16:00:31','2021-11-08 16:00:31'),(5298,'default','added',1530,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":300}}','2021-11-08 16:01:38','2021-11-08 16:01:38'),(5299,'default','added',1531,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":675}}','2021-11-08 16:03:01','2021-11-08 16:03:01'),(5300,'default','added',1311,'App\\Contact',1,4,'App\\User','[]','2021-11-08 16:16:58','2021-11-08 16:16:58'),(5301,'default','added',1312,'App\\Contact',1,4,'App\\User','[]','2021-11-08 16:29:39','2021-11-08 16:29:39'),(5302,'default','added',1532,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-11-08 16:53:41','2021-11-08 16:53:41'),(5303,'default','added',1533,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-08 16:57:17','2021-11-08 16:57:17'),(5304,'default','added',1313,'App\\Contact',1,11,'App\\User','[]','2021-11-08 17:03:25','2021-11-08 17:03:25'),(5305,'default','status_changed',1008,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-11-08 17:04:07','2021-11-08 17:04:07'),(5306,'default','added',1534,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-11-08 17:04:43','2021-11-08 17:04:43'),(5307,'default','status_changed',1298,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-08 17:04:57','2021-11-08 17:04:57'),(5308,'default','added',1314,'App\\Contact',1,11,'App\\User','[]','2021-11-08 17:06:47','2021-11-08 17:06:47'),(5309,'default','added',1535,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":200}}','2021-11-08 17:06:55','2021-11-08 17:06:55'),(5310,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-11-08 17:07:34','2021-11-08 17:07:34'),(5311,'default','added',1536,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-11-08 17:36:53','2021-11-08 17:36:53'),(5312,'default','status_changed',1327,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-08 17:37:40','2021-11-08 17:37:40'),(5313,'default','added',1315,'App\\Contact',1,4,'App\\User','[]','2021-11-08 17:45:40','2021-11-08 17:45:40'),(5314,'default','added',1316,'App\\Contact',1,4,'App\\User','[]','2021-11-08 17:51:53','2021-11-08 17:51:53'),(5315,'default','added',1537,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1200}}','2021-11-08 17:57:36','2021-11-08 17:57:36'),(5316,'default','status_changed',1330,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-08 18:12:43','2021-11-08 18:12:43'),(5317,'default','added',1317,'App\\Contact',1,4,'App\\User','[]','2021-11-08 18:18:04','2021-11-08 18:18:04'),(5318,'default','added',1538,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-11-08 18:23:24','2021-11-08 18:23:24'),(5319,'default','status_changed',1329,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-08 18:23:36','2021-11-08 18:23:36'),(5320,'default','status_changed',1332,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-08 18:31:48','2021-11-08 18:31:48'),(5321,'default','added',1539,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-11-08 18:40:27','2021-11-08 18:40:27'),(5322,'default','status_changed',1331,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-08 18:40:41','2021-11-08 18:40:41'),(5323,'default','added',1540,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-08 18:42:57','2021-11-08 18:42:57'),(5324,'default','added',1541,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-08 18:44:13','2021-11-08 18:44:13'),(5325,'default','added',1542,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-08 18:45:02','2021-11-08 18:45:02'),(5326,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-11-08 18:45:25','2021-11-08 18:45:25'),(5327,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-11-08 19:07:04','2021-11-08 19:07:04'),(5328,'default','added',1543,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-11-08 19:12:46','2021-11-08 19:12:46'),(5329,'default','status_changed',1238,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-08 19:13:00','2021-11-08 19:13:00'),(5330,'default','added',1318,'App\\Contact',1,4,'App\\User','[]','2021-11-08 19:25:53','2021-11-08 19:25:53'),(5331,'default','status_changed',1313,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-08 19:32:23','2021-11-08 19:32:23'),(5332,'default','added',1319,'App\\Contact',1,4,'App\\User','[]','2021-11-08 19:33:55','2021-11-08 19:33:55'),(5333,'default','status_changed',661,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-08 19:44:09','2021-11-08 19:44:09'),(5334,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-11-08 19:52:27','2021-11-08 19:52:27'),(5335,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-08 20:07:47','2021-11-08 20:07:47'),(5336,'default','added',1320,'App\\Contact',1,11,'App\\User','[]','2021-11-08 20:21:49','2021-11-08 20:21:49'),(5337,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-08 20:27:08','2021-11-08 20:27:08'),(5338,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-08 20:28:30','2021-11-08 20:28:30'),(5339,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-08 20:29:58','2021-11-08 20:29:58'),(5340,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-08 20:40:28','2021-11-08 20:40:28'),(5341,'default','added',1544,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}','2021-11-08 20:41:49','2021-11-08 20:41:49'),(5342,'default','status_changed',1316,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-08 20:42:00','2021-11-08 20:42:00'),(5343,'default','status_changed',1008,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-08 20:48:20','2021-11-08 20:48:20'),(5344,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-08 20:48:24','2021-11-08 20:48:24'),(5345,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-11-08 20:52:36','2021-11-08 20:52:36'),(5346,'default','added',1545,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-11-08 20:54:41','2021-11-08 20:54:41'),(5347,'default','status_changed',1312,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-08 20:55:53','2021-11-08 20:55:53'),(5348,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-08 21:05:20','2021-11-08 21:05:20'),(5349,'default','added',1546,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-08 21:24:16','2021-11-08 21:24:16'),(5350,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-08 21:28:54','2021-11-08 21:28:54'),(5351,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-08 21:30:48','2021-11-08 21:30:48'),(5352,'default','added',1547,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":800}}','2021-11-08 21:31:40','2021-11-08 21:31:40'),(5353,'default','status_changed',1323,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-08 21:31:52','2021-11-08 21:31:52'),(5354,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-11-08 22:36:38','2021-11-08 22:36:38'),(5355,'default','added',1321,'App\\Contact',1,4,'App\\User','[]','2021-11-08 22:37:20','2021-11-08 22:37:20'),(5356,'default','added',1548,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-11-08 23:04:51','2021-11-08 23:04:51'),(5357,'default','status_changed',1333,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-08 23:05:10','2021-11-08 23:05:10'),(5358,'default','added',1549,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-11-08 23:25:58','2021-11-08 23:25:58'),(5359,'default','status_changed',1106,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-08 23:26:07','2021-11-08 23:26:07'),(5360,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-11-08 23:42:44','2021-11-08 23:42:44'),(5361,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-09 11:14:27','2021-11-09 11:14:27'),(5362,'default','added',1322,'App\\Contact',1,11,'App\\User','[]','2021-11-09 11:25:02','2021-11-09 11:25:02'),(5363,'default','added',1323,'App\\Contact',1,11,'App\\User','[]','2021-11-09 13:29:34','2021-11-09 13:29:34'),(5364,'default','added',1550,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}','2021-11-09 14:12:45','2021-11-09 14:12:45'),(5365,'default','status_changed',1221,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-09 14:12:57','2021-11-09 14:12:57'),(5366,'default','status_changed',1222,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-09 14:13:10','2021-11-09 14:13:10'),(5367,'default','added',1551,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-11-09 14:13:30','2021-11-09 14:13:30'),(5368,'default','status_changed',1224,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-09 14:13:41','2021-11-09 14:13:41'),(5369,'default','added',1552,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3100}}','2021-11-09 14:14:04','2021-11-09 14:14:04'),(5370,'default','status_changed',1223,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-09 14:14:15','2021-11-09 14:14:15'),(5371,'default','added',1553,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-11-09 14:19:16','2021-11-09 14:19:16'),(5372,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-09 14:25:21','2021-11-09 14:25:21'),(5373,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-11-09 15:33:21','2021-11-09 15:33:21'),(5374,'default','added',1324,'App\\Contact',1,4,'App\\User','[]','2021-11-09 15:34:13','2021-11-09 15:34:13'),(5375,'default','added',1325,'App\\Contact',1,4,'App\\User','[]','2021-11-09 16:11:16','2021-11-09 16:11:16'),(5376,'default','added',1326,'App\\Contact',1,4,'App\\User','[]','2021-11-09 16:17:12','2021-11-09 16:17:12'),(5377,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-09 16:21:15','2021-11-09 16:21:15'),(5378,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-09 16:55:49','2021-11-09 16:55:49'),(5379,'default','added',1327,'App\\Contact',1,4,'App\\User','[]','2021-11-09 17:01:43','2021-11-09 17:01:43'),(5380,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-09 17:02:22','2021-11-09 17:02:22'),(5381,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-09 17:08:10','2021-11-09 17:08:10'),(5382,'default','added',1554,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-11-09 17:11:26','2021-11-09 17:11:26'),(5383,'default','status_changed',1155,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-09 17:11:42','2021-11-09 17:11:42'),(5384,'default','added',1555,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}','2021-11-09 17:16:56','2021-11-09 17:16:56'),(5385,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-11-09 17:19:44','2021-11-09 17:19:44'),(5386,'default','added',1328,'App\\Contact',1,4,'App\\User','[]','2021-11-09 17:42:21','2021-11-09 17:42:21'),(5387,'default','logout',20,'App\\User',1,20,'App\\User','[]','2021-11-09 18:00:54','2021-11-09 18:00:54'),(5388,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-09 18:01:04','2021-11-09 18:01:04'),(5389,'default','status_changed',1341,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-09 18:01:35','2021-11-09 18:01:35'),(5390,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-09 18:06:02','2021-11-09 18:06:02'),(5391,'default','added',1329,'App\\Contact',1,4,'App\\User','[]','2021-11-09 18:07:11','2021-11-09 18:07:11'),(5392,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-09 18:11:27','2021-11-09 18:11:27'),(5393,'default','added',1556,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-11-09 18:18:27','2021-11-09 18:18:27'),(5394,'default','status_changed',1338,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-09 18:18:44','2021-11-09 18:18:44'),(5395,'default','added',1330,'App\\Contact',1,4,'App\\User','[]','2021-11-09 18:30:58','2021-11-09 18:30:58'),(5396,'default','added',1331,'App\\Contact',1,4,'App\\User','[]','2021-11-09 18:45:43','2021-11-09 18:45:43'),(5397,'default','added',1332,'App\\Contact',1,4,'App\\User','[]','2021-11-09 18:52:36','2021-11-09 18:52:36'),(5398,'default','status_changed',1328,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-09 18:57:39','2021-11-09 18:57:39'),(5399,'default','added',1333,'App\\Contact',1,11,'App\\User','[]','2021-11-09 19:19:31','2021-11-09 19:19:31'),(5400,'default','status_changed',1332,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-11-09 19:46:24','2021-11-09 19:46:24'),(5401,'default','added',1557,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-11-09 19:49:29','2021-11-09 19:49:29'),(5402,'default','status_changed',1335,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-09 19:49:42','2021-11-09 19:49:42'),(5403,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-11-09 19:50:09','2021-11-09 19:50:09'),(5404,'default','status_changed',877,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-09 19:55:57','2021-11-09 19:55:57'),(5405,'default','added',1558,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-11-09 20:09:51','2021-11-09 20:09:51'),(5406,'default','status_changed',1349,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-09 20:10:01','2021-11-09 20:10:01'),(5407,'default','added',1559,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-11-09 20:12:49','2021-11-09 20:12:49'),(5408,'default','status_changed',1288,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-09 20:13:08','2021-11-09 20:13:08'),(5409,'default','added',1560,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-11-09 20:30:42','2021-11-09 20:30:42'),(5410,'default','status_changed',1317,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-09 20:30:57','2021-11-09 20:30:57'),(5411,'default','added',1561,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-09 20:34:06','2021-11-09 20:34:06'),(5412,'default','added',1562,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-09 20:35:55','2021-11-09 20:35:55'),(5413,'default','added',1563,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-09 20:36:44','2021-11-09 20:36:44'),(5414,'default','added',1564,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-09 20:37:41','2021-11-09 20:37:41'),(5415,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-09 20:41:39','2021-11-09 20:41:39'),(5416,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-09 20:42:06','2021-11-09 20:42:06'),(5417,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-09 20:42:50','2021-11-09 20:42:50'),(5418,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-11-09 20:55:46','2021-11-09 20:55:46'),(5419,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-09 20:55:54','2021-11-09 20:55:54'),(5420,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-11-09 21:09:06','2021-11-09 21:09:06'),(5421,'default','added',1334,'App\\Contact',1,4,'App\\User','[]','2021-11-09 21:10:15','2021-11-09 21:10:15'),(5422,'default','added',1335,'App\\Contact',1,4,'App\\User','[]','2021-11-09 21:10:15','2021-11-09 21:10:15'),(5423,'default','added',1565,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-11-09 21:14:29','2021-11-09 21:14:29'),(5424,'default','status_changed',1337,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-09 21:14:43','2021-11-09 21:14:43'),(5425,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-09 21:17:48','2021-11-09 21:17:48'),(5426,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-09 21:20:27','2021-11-09 21:20:27'),(5427,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-11-09 21:35:21','2021-11-09 21:35:21'),(5428,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-09 21:38:42','2021-11-09 21:38:42'),(5429,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-11-09 21:59:00','2021-11-09 21:59:00'),(5430,'default','added',1566,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":250}}','2021-11-09 21:59:53','2021-11-09 21:59:53'),(5431,'default','added',1567,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-09 22:14:00','2021-11-09 22:14:00'),(5432,'default','added',1568,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-11-09 22:29:13','2021-11-09 22:29:13'),(5433,'default','status_changed',1344,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-09 22:29:51','2021-11-09 22:29:51'),(5434,'default','added',1569,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-09 22:32:56','2021-11-09 22:32:56'),(5435,'default','status_changed',1346,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-09 22:37:22','2021-11-09 22:37:22'),(5436,'default','added',1570,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":400}}','2021-11-09 22:45:54','2021-11-09 22:45:54'),(5437,'default','added',1571,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-11-09 23:25:47','2021-11-09 23:25:47'),(5438,'default','status_changed',1347,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-09 23:26:00','2021-11-09 23:26:00'),(5439,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-11-09 23:26:42','2021-11-09 23:26:42'),(5440,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-11-10 12:16:22','2021-11-10 12:16:22'),(5441,'default','added',1336,'App\\Contact',1,4,'App\\User','[]','2021-11-10 12:28:08','2021-11-10 12:28:08'),(5442,'default','added',1337,'App\\Contact',1,4,'App\\User','[]','2021-11-10 13:04:57','2021-11-10 13:04:57'),(5443,'default','added',1338,'App\\Contact',1,4,'App\\User','[]','2021-11-10 15:01:52','2021-11-10 15:01:52'),(5444,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-10 15:14:22','2021-11-10 15:14:22'),(5445,'default','status_changed',1350,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-10 15:15:58','2021-11-10 15:15:58'),(5446,'default','added',1339,'App\\Contact',1,4,'App\\User','[]','2021-11-10 15:22:10','2021-11-10 15:22:10'),(5447,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-11-10 15:46:56','2021-11-10 15:46:56'),(5448,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-11-10 16:06:24','2021-11-10 16:06:24'),(5449,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-11-10 16:12:29','2021-11-10 16:12:29'),(5450,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-11-10 16:12:55','2021-11-10 16:12:55'),(5451,'default','status_changed',1342,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-10 16:15:25','2021-11-10 16:15:25'),(5452,'default','added',1572,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-11-10 16:32:59','2021-11-10 16:32:59'),(5453,'default','status_changed',1332,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-10 16:34:03','2021-11-10 16:34:03'),(5454,'default','added',1573,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-11-10 16:34:44','2021-11-10 16:34:44'),(5455,'default','status_changed',1345,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-10 16:34:55','2021-11-10 16:34:55'),(5456,'default','logout',20,'App\\User',1,20,'App\\User','[]','2021-11-10 16:35:10','2021-11-10 16:35:10'),(5457,'default','added',1574,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-11-10 16:35:29','2021-11-10 16:35:29'),(5458,'default','added',1575,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-11-10 16:36:03','2021-11-10 16:36:03'),(5459,'default','status_changed',1325,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-10 16:36:18','2021-11-10 16:36:18'),(5460,'default','added',1576,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":400}}','2021-11-10 16:36:53','2021-11-10 16:36:53'),(5461,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-11-10 16:57:03','2021-11-10 16:57:03'),(5462,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-11-10 16:57:14','2021-11-10 16:57:14'),(5463,'default','added',1340,'App\\Contact',1,20,'App\\User','[]','2021-11-10 17:20:13','2021-11-10 17:20:13'),(5464,'default','added',1577,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}','2021-11-10 18:04:57','2021-11-10 18:04:57'),(5465,'default','status_changed',1126,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-10 18:05:23','2021-11-10 18:05:23'),(5466,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-11-10 19:21:57','2021-11-10 19:21:57'),(5467,'default','added',1341,'App\\Contact',1,20,'App\\User','[]','2021-11-10 19:28:22','2021-11-10 19:28:22'),(5468,'default','logout',20,'App\\User',1,20,'App\\User','[]','2021-11-10 19:38:31','2021-11-10 19:38:31'),(5469,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-11-10 19:38:41','2021-11-10 19:38:41'),(5470,'default','added',1578,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-10 19:57:39','2021-11-10 19:57:39'),(5471,'default','added',1579,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-10 19:58:53','2021-11-10 19:58:53'),(5472,'default','added',1580,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-11-10 20:03:18','2021-11-10 20:03:18'),(5473,'default','status_changed',1080,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-10 20:03:39','2021-11-10 20:03:39'),(5474,'default','added',1581,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-11-10 20:04:53','2021-11-10 20:04:53'),(5475,'default','status_changed',1352,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-10 20:05:15','2021-11-10 20:05:15'),(5476,'default','added',1342,'App\\Contact',1,4,'App\\User','[]','2021-11-10 21:07:17','2021-11-10 21:07:17'),(5477,'default','added',1343,'App\\Contact',1,4,'App\\User','[]','2021-11-10 21:30:15','2021-11-10 21:30:15'),(5478,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-11-10 21:37:54','2021-11-10 21:37:54'),(5479,'default','added',1582,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-10 22:00:43','2021-11-10 22:00:43'),(5480,'default','added',1583,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-10 22:01:31','2021-11-10 22:01:31'),(5481,'default','added',1584,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-10 22:02:22','2021-11-10 22:02:22'),(5482,'default','added',1585,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-10 22:02:57','2021-11-10 22:02:57'),(5483,'default','added',1586,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-10 22:03:48','2021-11-10 22:03:48'),(5484,'default','added',1587,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-10 22:04:21','2021-11-10 22:04:21'),(5485,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-10 22:52:58','2021-11-10 22:52:58'),(5486,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-11-10 22:54:51','2021-11-10 22:54:51'),(5487,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-10 22:55:00','2021-11-10 22:55:00'),(5488,'default','added',1344,'App\\Contact',1,11,'App\\User','[]','2021-11-10 22:56:28','2021-11-10 22:56:28'),(5489,'default','added',1588,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-11-10 23:04:05','2021-11-10 23:04:05'),(5490,'default','status_changed',1348,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-10 23:04:52','2021-11-10 23:04:52'),(5491,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-10 23:09:52','2021-11-10 23:09:52'),(5492,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-11 11:48:27','2021-11-11 11:48:27'),(5493,'default','added',1345,'App\\Contact',1,11,'App\\User','[]','2021-11-11 11:49:15','2021-11-11 11:49:15'),(5494,'default','added',1346,'App\\Contact',1,11,'App\\User','[]','2021-11-11 14:56:04','2021-11-11 14:56:04'),(5495,'default','added',1347,'App\\Contact',1,11,'App\\User','[]','2021-11-11 15:00:09','2021-11-11 15:00:09'),(5496,'default','added',1348,'App\\Contact',1,11,'App\\User','[]','2021-11-11 15:02:50','2021-11-11 15:02:50'),(5497,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-11-11 15:12:43','2021-11-11 15:12:43'),(5498,'default','added',1349,'App\\Contact',1,4,'App\\User','[]','2021-11-11 15:15:15','2021-11-11 15:15:15'),(5499,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-11 15:25:26','2021-11-11 15:25:26'),(5500,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-11-11 15:29:04','2021-11-11 15:29:04'),(5501,'default','added',1589,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-11-11 15:32:50','2021-11-11 15:32:50'),(5502,'default','status_changed',1306,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-11 15:33:00','2021-11-11 15:33:00'),(5503,'default','added',1590,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-11-11 15:33:29','2021-11-11 15:33:29'),(5504,'default','status_changed',1340,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-11 15:33:44','2021-11-11 15:33:44'),(5505,'default','added',1591,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-11-11 15:34:12','2021-11-11 15:34:12'),(5506,'default','status_changed',1339,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-11 15:34:26','2021-11-11 15:34:26'),(5507,'default','status_changed',1353,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-11 15:34:37','2021-11-11 15:34:37'),(5508,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-11 15:39:53','2021-11-11 15:39:53'),(5509,'default','added',1350,'App\\Contact',1,4,'App\\User','[]','2021-11-11 17:04:21','2021-11-11 17:04:21'),(5510,'default','added',1592,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-11-11 17:10:49','2021-11-11 17:10:49'),(5511,'default','status_changed',1356,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-11 17:11:01','2021-11-11 17:11:01'),(5512,'default','status_changed',1227,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-11-11 17:14:37','2021-11-11 17:14:37'),(5513,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-11-11 17:57:36','2021-11-11 17:57:36'),(5514,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-11-11 17:58:44','2021-11-11 17:58:44'),(5515,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-11 17:58:51','2021-11-11 17:58:51'),(5516,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-11 18:00:37','2021-11-11 18:00:37'),(5517,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-11-11 18:12:40','2021-11-11 18:12:40'),(5518,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-11-11 18:46:49','2021-11-11 18:46:49'),(5519,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-11 18:46:57','2021-11-11 18:46:57'),(5520,'default','added',1593,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-11-11 18:47:47','2021-11-11 18:47:47'),(5521,'default','status_changed',1364,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-11 18:48:03','2021-11-11 18:48:03'),(5522,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-11 18:49:26','2021-11-11 18:49:26'),(5523,'default','added',1351,'App\\Contact',1,4,'App\\User','[]','2021-11-11 19:19:59','2021-11-11 19:19:59'),(5524,'default','added',1352,'App\\Contact',1,4,'App\\User','[]','2021-11-11 19:27:30','2021-11-11 19:27:30'),(5525,'default','added',1353,'App\\Contact',1,4,'App\\User','[]','2021-11-11 19:32:55','2021-11-11 19:32:55'),(5526,'default','added',1354,'App\\Contact',1,4,'App\\User','[]','2021-11-11 19:45:47','2021-11-11 19:45:47'),(5527,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-11-11 19:55:55','2021-11-11 19:55:55'),(5528,'default','added',1594,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-11-11 19:57:35','2021-11-11 19:57:35'),(5529,'default','added',1355,'App\\Contact',1,4,'App\\User','[]','2021-11-11 20:29:56','2021-11-11 20:29:56'),(5530,'default','status_changed',1365,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-11 20:54:50','2021-11-11 20:54:50'),(5531,'default','added',1595,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-11-11 21:37:31','2021-11-11 21:37:31'),(5532,'default','status_changed',1216,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-11 21:37:53','2021-11-11 21:37:53'),(5533,'default','added',1596,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-11 22:15:45','2021-11-11 22:15:45'),(5534,'default','added',1597,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-11 22:17:11','2021-11-11 22:17:11'),(5535,'default','added',1598,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-11 22:18:37','2021-11-11 22:18:37'),(5536,'default','added',1599,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-11 22:19:18','2021-11-11 22:19:18'),(5537,'default','added',1600,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-11 22:20:52','2021-11-11 22:20:52'),(5538,'default','added',1601,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-11 22:21:38','2021-11-11 22:21:38'),(5539,'default','added',1602,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-11 22:25:04','2021-11-11 22:25:04'),(5540,'default','added',1603,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":125}}','2021-11-11 22:45:21','2021-11-11 22:45:21'),(5541,'default','status_changed',1371,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-11 22:45:43','2021-11-11 22:45:43'),(5542,'default','added',1604,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-11 23:11:12','2021-11-11 23:11:12'),(5543,'default','added',1605,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-11 23:12:03','2021-11-11 23:12:03'),(5544,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-11-12 13:25:03','2021-11-12 13:25:03'),(5545,'default','status_changed',1368,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-12 13:25:44','2021-11-12 13:25:44'),(5546,'default','status_changed',1367,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-12 13:25:56','2021-11-12 13:25:56'),(5547,'default','status_changed',1249,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"reject by customer\"}','2021-11-12 14:47:29','2021-11-12 14:47:29'),(5548,'default','added',1356,'App\\Contact',1,20,'App\\User','[]','2021-11-12 14:54:23','2021-11-12 14:54:23'),(5549,'default','added',1357,'App\\Contact',1,20,'App\\User','[]','2021-11-12 15:25:41','2021-11-12 15:25:41'),(5550,'default','added',1358,'App\\Contact',1,20,'App\\User','[]','2021-11-12 15:49:10','2021-11-12 15:49:10'),(5551,'default','added',1359,'App\\Contact',1,20,'App\\User','[]','2021-11-12 15:57:39','2021-11-12 15:57:39'),(5552,'default','added',1360,'App\\Contact',1,20,'App\\User','[]','2021-11-12 17:50:47','2021-11-12 17:50:47'),(5553,'default','added',1606,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-11-12 18:30:22','2021-11-12 18:30:22'),(5554,'default','status_changed',1343,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-12 18:31:37','2021-11-12 18:31:37'),(5555,'default','added',1607,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-11-12 19:34:02','2021-11-12 19:34:02'),(5556,'default','status_changed',1351,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-12 19:35:31','2021-11-12 19:35:31'),(5557,'default','added',1361,'App\\Contact',1,20,'App\\User','[]','2021-11-12 20:27:08','2021-11-12 20:27:08'),(5558,'default','added',1608,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-12 21:47:18','2021-11-12 21:47:18'),(5559,'default','added',1609,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-12 21:47:56','2021-11-12 21:47:56'),(5560,'default','logout',20,'App\\User',1,20,'App\\User','[]','2021-11-12 22:17:25','2021-11-12 22:17:25'),(5561,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-13 11:25:45','2021-11-13 11:25:45'),(5562,'default','added',1362,'App\\Contact',1,11,'App\\User','[]','2021-11-13 12:14:05','2021-11-13 12:14:05'),(5563,'default','added',1363,'App\\Contact',1,11,'App\\User','[]','2021-11-13 12:34:28','2021-11-13 12:34:28'),(5564,'default','added',1364,'App\\Contact',1,11,'App\\User','[]','2021-11-13 12:55:08','2021-11-13 12:55:08'),(5565,'default','status_changed',1115,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-11-13 13:39:38','2021-11-13 13:39:38'),(5566,'default','added',1365,'App\\Contact',1,11,'App\\User','[]','2021-11-13 13:50:07','2021-11-13 13:50:07'),(5567,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-13 14:25:31','2021-11-13 14:25:31'),(5568,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-11-13 14:50:59','2021-11-13 14:50:59'),(5569,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-13 14:57:38','2021-11-13 14:57:38'),(5570,'default','status_changed',1378,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-13 15:39:57','2021-11-13 15:39:57'),(5571,'default','status_changed',1377,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-13 15:40:27','2021-11-13 15:40:27'),(5572,'default','status_changed',1375,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-13 15:40:36','2021-11-13 15:40:36'),(5573,'default','status_changed',1381,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-13 15:40:44','2021-11-13 15:40:44'),(5574,'default','status_changed',1372,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-13 15:40:51','2021-11-13 15:40:51'),(5575,'default','status_changed',1369,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-13 15:40:59','2021-11-13 15:40:59'),(5576,'default','status_changed',1115,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-13 15:42:45','2021-11-13 15:42:45'),(5577,'default','status_changed',740,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-13 15:42:52','2021-11-13 15:42:52'),(5578,'default','added',1366,'App\\Contact',1,4,'App\\User','[]','2021-11-13 17:12:59','2021-11-13 17:12:59'),(5579,'default','status_changed',111,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-11-13 17:14:10','2021-11-13 17:14:10'),(5580,'default','added',1367,'App\\Contact',1,4,'App\\User','[]','2021-11-13 17:28:37','2021-11-13 17:28:37'),(5581,'default','status_changed',1227,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-11-13 17:32:31','2021-11-13 17:32:31'),(5582,'default','added',1368,'App\\Contact',1,4,'App\\User','[]','2021-11-13 17:38:27','2021-11-13 17:38:27'),(5583,'default','added',25,'App\\User',1,1,'App\\User','[]','2021-11-13 18:00:14','2021-11-13 18:00:14'),(5584,'default','status_changed',740,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-11-13 18:17:25','2021-11-13 18:17:25'),(5585,'default','status_changed',1319,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"reject by customer\"}','2021-11-13 18:25:29','2021-11-13 18:25:29'),(5586,'default','status_changed',1369,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-11-13 18:27:04','2021-11-13 18:27:04'),(5587,'default','status_changed',1377,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-11-13 18:27:11','2021-11-13 18:27:11'),(5588,'default','status_changed',1375,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-11-13 18:27:19','2021-11-13 18:27:19'),(5589,'default','status_changed',1381,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-11-13 18:27:28','2021-11-13 18:27:28'),(5590,'default','status_changed',1378,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-11-13 18:27:36','2021-11-13 18:27:36'),(5591,'default','status_changed',1372,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-11-13 18:27:43','2021-11-13 18:27:43'),(5592,'default','status_changed',1115,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-11-13 18:27:52','2021-11-13 18:27:52'),(5593,'default','added',1369,'App\\Contact',1,4,'App\\User','[]','2021-11-13 18:40:04','2021-11-13 18:40:04'),(5594,'default','added',1610,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}','2021-11-13 18:44:54','2021-11-13 18:44:54'),(5595,'default','status_changed',1319,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-13 18:45:03','2021-11-13 18:45:03'),(5596,'default','status_changed',1115,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-11-13 18:55:37','2021-11-13 18:55:37'),(5597,'default','added',1611,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-11-13 18:57:27','2021-11-13 18:57:27'),(5598,'default','status_changed',1359,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-13 18:57:34','2021-11-13 18:57:34'),(5599,'default','added',1612,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-11-13 19:09:06','2021-11-13 19:09:06'),(5600,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-11-13 19:09:10','2021-11-13 19:09:10'),(5601,'default','status_changed',1379,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-13 19:09:46','2021-11-13 19:09:46'),(5602,'default','added',1370,'App\\Contact',1,4,'App\\User','[]','2021-11-13 19:09:48','2021-11-13 19:09:48'),(5603,'default','added',1371,'App\\Contact',1,4,'App\\User','[]','2021-11-13 19:12:33','2021-11-13 19:12:33'),(5604,'default','added',1372,'App\\Contact',1,4,'App\\User','[]','2021-11-13 19:21:18','2021-11-13 19:21:18'),(5605,'default','added',1373,'App\\Contact',1,4,'App\\User','[]','2021-11-13 19:27:53','2021-11-13 19:27:53'),(5606,'default','added',1374,'App\\Contact',1,4,'App\\User','[]','2021-11-13 19:37:31','2021-11-13 19:37:31'),(5607,'default','status_changed',740,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Ready for client\"}','2021-11-13 19:43:48','2021-11-13 19:43:48'),(5608,'default','added',1613,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-11-13 19:59:07','2021-11-13 19:59:07'),(5609,'default','status_changed',1372,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-13 19:59:16','2021-11-13 19:59:16'),(5610,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-13 20:00:47','2021-11-13 20:00:47'),(5611,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-13 20:27:17','2021-11-13 20:27:17'),(5612,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-13 20:42:31','2021-11-13 20:42:31'),(5613,'default','added',1375,'App\\Contact',1,4,'App\\User','[]','2021-11-13 20:51:07','2021-11-13 20:51:07'),(5614,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-13 20:52:34','2021-11-13 20:52:34'),(5615,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-13 20:53:15','2021-11-13 20:53:15'),(5616,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-13 20:53:29','2021-11-13 20:53:29'),(5617,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-13 21:05:54','2021-11-13 21:05:54'),(5618,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-13 21:06:40','2021-11-13 21:06:40'),(5619,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-13 21:07:29','2021-11-13 21:07:29'),(5620,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-13 21:08:02','2021-11-13 21:08:02'),(5621,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-13 21:10:23','2021-11-13 21:10:23'),(5622,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-13 21:11:39','2021-11-13 21:11:39'),(5623,'default','added',1614,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-11-13 21:27:37','2021-11-13 21:27:37'),(5624,'default','status_changed',1390,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-13 21:27:55','2021-11-13 21:27:55'),(5625,'default','added',1615,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-13 21:29:10','2021-11-13 21:29:10'),(5626,'default','added',1616,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-13 21:29:53','2021-11-13 21:29:53'),(5627,'default','added',1617,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-13 21:33:51','2021-11-13 21:33:51'),(5628,'default','added',1618,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-13 21:34:49','2021-11-13 21:34:49'),(5629,'default','added',1619,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-13 21:35:28','2021-11-13 21:35:28'),(5630,'default','added',1620,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-13 21:36:11','2021-11-13 21:36:11'),(5631,'default','added',1621,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-13 21:37:06','2021-11-13 21:37:06'),(5632,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-13 21:37:11','2021-11-13 21:37:11'),(5633,'default','added',1376,'App\\Contact',1,4,'App\\User','[]','2021-11-13 21:44:21','2021-11-13 21:44:21'),(5634,'default','added',1377,'App\\Contact',1,4,'App\\User','[]','2021-11-13 21:52:17','2021-11-13 21:52:17'),(5635,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-13 22:19:48','2021-11-13 22:19:48'),(5636,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-13 22:24:14','2021-11-13 22:24:14'),(5637,'default','added',1622,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-11-13 22:25:36','2021-11-13 22:25:36'),(5638,'default','status_changed',1384,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-13 22:26:29','2021-11-13 22:26:29'),(5639,'default','added',1623,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-11-13 22:27:14','2021-11-13 22:27:14'),(5640,'default','status_changed',1387,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-13 22:27:28','2021-11-13 22:27:28'),(5641,'default','added',1624,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1100}}','2021-11-13 22:28:11','2021-11-13 22:28:11'),(5642,'default','status_changed',1381,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-13 22:28:25','2021-11-13 22:28:25'),(5643,'default','added',1378,'App\\Contact',1,4,'App\\User','[]','2021-11-13 22:57:38','2021-11-13 22:57:38'),(5644,'default','added',1379,'App\\Contact',1,4,'App\\User','[]','2021-11-13 22:57:38','2021-11-13 22:57:38'),(5645,'default','added',1625,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-11-13 23:03:17','2021-11-13 23:03:17'),(5646,'default','status_changed',1385,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-13 23:03:37','2021-11-13 23:03:37'),(5647,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-14 11:38:59','2021-11-14 11:38:59'),(5648,'default','added',1380,'App\\Contact',1,11,'App\\User','[]','2021-11-14 12:07:12','2021-11-14 12:07:12'),(5649,'default','added',1381,'App\\Contact',1,11,'App\\User','[]','2021-11-14 12:08:00','2021-11-14 12:08:00'),(5650,'default','added',1626,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-11-14 12:48:26','2021-11-14 12:48:26'),(5651,'default','status_changed',1382,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-14 12:48:43','2021-11-14 12:48:43'),(5652,'default','added',1627,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":800}}','2021-11-14 12:50:15','2021-11-14 12:50:15'),(5653,'default','added',1382,'App\\Contact',1,11,'App\\User','[]','2021-11-14 13:33:37','2021-11-14 13:33:37'),(5654,'default','status_changed',1115,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-14 13:41:10','2021-11-14 13:41:10'),(5655,'default','status_changed',1204,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-14 13:48:39','2021-11-14 13:48:39'),(5656,'default','added',1383,'App\\Contact',1,11,'App\\User','[]','2021-11-14 13:55:23','2021-11-14 13:55:23'),(5657,'default','added',1628,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-11-14 14:23:39','2021-11-14 14:23:39'),(5658,'default','status_changed',1380,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-14 14:23:52','2021-11-14 14:23:52'),(5659,'default','added',1629,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-11-14 14:30:50','2021-11-14 14:30:50'),(5660,'default','status_changed',1361,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-14 14:31:06','2021-11-14 14:31:06'),(5661,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-14 14:35:48','2021-11-14 14:35:48'),(5662,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-11-14 14:40:13','2021-11-14 14:40:13'),(5663,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-14 14:43:19','2021-11-14 14:43:19'),(5664,'default','status_changed',1383,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-14 14:55:19','2021-11-14 14:55:19'),(5665,'default','status_changed',1397,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-14 14:56:47','2021-11-14 14:56:47'),(5666,'default','added',1630,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}','2021-11-14 15:06:47','2021-11-14 15:06:47'),(5667,'default','status_changed',1389,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-14 15:07:05','2021-11-14 15:07:05'),(5668,'default','added',1631,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-14 15:08:13','2021-11-14 15:08:13'),(5669,'default','added',1384,'App\\Contact',1,4,'App\\User','[]','2021-11-14 15:25:04','2021-11-14 15:25:04'),(5670,'default','added',1632,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-11-14 15:29:35','2021-11-14 15:29:35'),(5671,'default','status_changed',1369,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-14 15:29:50','2021-11-14 15:29:50'),(5672,'default','status_changed',1373,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-14 15:33:15','2021-11-14 15:33:15'),(5673,'default','added',1385,'App\\Contact',1,11,'App\\User','[]','2021-11-14 15:44:05','2021-11-14 15:44:05'),(5674,'default','added',1386,'App\\Contact',1,11,'App\\User','[]','2021-11-14 15:46:22','2021-11-14 15:46:22'),(5675,'default','added',1387,'App\\Contact',1,11,'App\\User','[]','2021-11-14 15:47:03','2021-11-14 15:47:03'),(5676,'default','added',1388,'App\\Contact',1,11,'App\\User','[]','2021-11-14 15:47:57','2021-11-14 15:47:57'),(5677,'default','status_changed',740,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-14 15:57:52','2021-11-14 15:57:52'),(5678,'default','added',1389,'App\\Contact',1,4,'App\\User','[]','2021-11-14 15:59:42','2021-11-14 15:59:42'),(5679,'default','added',1390,'App\\Contact',1,4,'App\\User','[]','2021-11-14 16:20:13','2021-11-14 16:20:13'),(5680,'default','added',1391,'App\\Contact',1,4,'App\\User','[]','2021-11-14 16:20:19','2021-11-14 16:20:19'),(5681,'default','added',1392,'App\\Contact',1,4,'App\\User','[]','2021-11-14 16:20:28','2021-11-14 16:20:28'),(5682,'default','added',1393,'App\\Contact',1,4,'App\\User','[]','2021-11-14 16:20:28','2021-11-14 16:20:28'),(5683,'default','added',1633,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-11-14 16:26:03','2021-11-14 16:26:03'),(5684,'default','status_changed',1375,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-14 16:26:16','2021-11-14 16:26:16'),(5685,'default','added',1634,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-11-14 16:26:38','2021-11-14 16:26:38'),(5686,'default','status_changed',1376,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-14 16:26:49','2021-11-14 16:26:49'),(5687,'default','added',1394,'App\\Contact',1,4,'App\\User','[]','2021-11-14 16:35:59','2021-11-14 16:35:59'),(5688,'default','added',1395,'App\\Contact',1,11,'App\\User','[]','2021-11-14 17:12:07','2021-11-14 17:12:07'),(5689,'default','added',1635,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}','2021-11-14 17:19:12','2021-11-14 17:19:12'),(5690,'default','status_changed',1392,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-14 17:19:22','2021-11-14 17:19:22'),(5691,'default','added',1636,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-11-14 17:20:10','2021-11-14 17:20:10'),(5692,'default','status_changed',1377,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-14 17:20:46','2021-11-14 17:20:46'),(5693,'default','added',1637,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}','2021-11-14 17:33:56','2021-11-14 17:33:56'),(5694,'default','added',1638,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1200}}','2021-11-14 17:45:35','2021-11-14 17:45:35'),(5695,'default','status_changed',1388,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-14 17:46:04','2021-11-14 17:46:04'),(5696,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-14 17:49:47','2021-11-14 17:49:47'),(5697,'default','added',1396,'App\\Contact',1,4,'App\\User','[]','2021-11-14 17:56:41','2021-11-14 17:56:41'),(5698,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-11-14 17:58:17','2021-11-14 17:58:17'),(5699,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-14 18:03:18','2021-11-14 18:03:18'),(5700,'default','added',1639,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-11-14 18:35:40','2021-11-14 18:35:40'),(5701,'default','added',1397,'App\\Contact',1,4,'App\\User','[]','2021-11-14 18:35:48','2021-11-14 18:35:48'),(5702,'default','status_changed',1386,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-14 18:35:52','2021-11-14 18:35:52'),(5703,'default','added',1640,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-11-14 18:44:00','2021-11-14 18:44:00'),(5704,'default','added',1398,'App\\Contact',1,4,'App\\User','[]','2021-11-14 18:51:21','2021-11-14 18:51:21'),(5705,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-14 18:57:17','2021-11-14 18:57:17'),(5706,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-14 19:10:01','2021-11-14 19:10:01'),(5707,'default','added',1641,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":175}}','2021-11-14 19:28:16','2021-11-14 19:28:16'),(5708,'default','status_changed',1396,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-14 19:28:32','2021-11-14 19:28:32'),(5709,'default','added',1642,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-11-14 19:51:04','2021-11-14 19:51:04'),(5710,'default','status_changed',1334,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-14 19:51:20','2021-11-14 19:51:20'),(5711,'default','added',1399,'App\\Contact',1,4,'App\\User','[]','2021-11-14 20:03:43','2021-11-14 20:03:43'),(5712,'default','added',1643,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-11-14 20:09:37','2021-11-14 20:09:37'),(5713,'default','added',1644,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-11-14 20:19:00','2021-11-14 20:19:00'),(5714,'default','status_changed',1182,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-14 20:19:17','2021-11-14 20:19:17'),(5715,'default','added',1400,'App\\Contact',1,4,'App\\User','[]','2021-11-14 20:30:10','2021-11-14 20:30:10'),(5716,'default','added',1401,'App\\Contact',1,4,'App\\User','[]','2021-11-14 20:34:50','2021-11-14 20:34:50'),(5717,'default','added',1645,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-11-14 20:43:20','2021-11-14 20:43:20'),(5718,'default','status_changed',1366,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-14 20:44:01','2021-11-14 20:44:01'),(5719,'default','added',1646,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-11-14 20:46:26','2021-11-14 20:46:26'),(5720,'default','status_changed',1378,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-14 20:46:40','2021-11-14 20:46:40'),(5721,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-14 20:48:18','2021-11-14 20:48:18'),(5722,'default','added',1647,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":650}}','2021-11-14 20:48:39','2021-11-14 20:48:39'),(5723,'default','status_changed',1403,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-14 20:48:47','2021-11-14 20:48:47'),(5724,'default','added',1402,'App\\Contact',1,4,'App\\User','[]','2021-11-14 20:49:35','2021-11-14 20:49:35'),(5725,'default','added',1648,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70}}','2021-11-14 20:58:49','2021-11-14 20:58:49'),(5726,'default','added',1649,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}','2021-11-14 21:03:18','2021-11-14 21:03:18'),(5727,'default','status_changed',1412,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-14 21:03:59','2021-11-14 21:03:59'),(5728,'default','added',1650,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-11-14 21:04:04','2021-11-14 21:04:04'),(5729,'default','status_changed',1394,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-14 21:04:37','2021-11-14 21:04:37'),(5730,'default','added',1651,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":175}}','2021-11-14 21:07:22','2021-11-14 21:07:22'),(5731,'default','status_changed',1407,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-14 21:07:31','2021-11-14 21:07:31'),(5732,'default','added',1652,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-11-14 21:09:16','2021-11-14 21:09:16'),(5733,'default','status_changed',1413,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-14 21:09:26','2021-11-14 21:09:26'),(5734,'default','added',1653,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-14 21:19:17','2021-11-14 21:19:17'),(5735,'default','added',1654,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-11-14 21:19:19','2021-11-14 21:19:19'),(5736,'default','status_changed',1414,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-14 21:19:26','2021-11-14 21:19:26'),(5737,'default','added',1655,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-14 21:21:47','2021-11-14 21:21:47'),(5738,'default','added',1403,'App\\Contact',1,4,'App\\User','[]','2021-11-14 21:25:37','2021-11-14 21:25:37'),(5739,'default','added',1656,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-14 21:30:02','2021-11-14 21:30:02'),(5740,'default','added',1657,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-14 21:31:22','2021-11-14 21:31:22'),(5741,'default','added',1404,'App\\Contact',1,4,'App\\User','[]','2021-11-14 22:03:24','2021-11-14 22:03:24'),(5742,'default','added',1405,'App\\Contact',1,4,'App\\User','[]','2021-11-14 22:07:51','2021-11-14 22:07:51'),(5743,'default','added',1658,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-14 22:08:07','2021-11-14 22:08:07'),(5744,'default','added',1659,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-14 22:23:39','2021-11-14 22:23:39'),(5745,'default','added',1660,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-11-14 22:26:12','2021-11-14 22:26:12'),(5746,'default','status_changed',1391,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-14 22:26:36','2021-11-14 22:26:36'),(5747,'default','added',1661,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-11-14 22:27:14','2021-11-14 22:27:14'),(5748,'default','status_changed',1411,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-14 22:27:28','2021-11-14 22:27:28'),(5749,'default','added',1662,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-11-14 22:29:02','2021-11-14 22:29:02'),(5750,'default','status_changed',1420,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-14 22:29:36','2021-11-14 22:29:36'),(5751,'default','added',1663,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}','2021-11-14 22:54:19','2021-11-14 22:54:19'),(5752,'default','status_changed',1400,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-14 22:54:29','2021-11-14 22:54:29'),(5753,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-15 11:12:22','2021-11-15 11:12:22'),(5754,'default','added',1406,'App\\Contact',1,11,'App\\User','[]','2021-11-15 11:22:12','2021-11-15 11:22:12'),(5755,'default','added',1407,'App\\Contact',1,11,'App\\User','[]','2021-11-15 12:22:06','2021-11-15 12:22:06'),(5756,'default','added',1408,'App\\Contact',1,11,'App\\User','[]','2021-11-15 12:35:21','2021-11-15 12:35:21'),(5757,'default','added',1409,'App\\Contact',1,11,'App\\User','[]','2021-11-15 12:47:03','2021-11-15 12:47:03'),(5758,'default','added',1664,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}','2021-11-15 13:15:11','2021-11-15 13:15:11'),(5759,'default','added',1410,'App\\Contact',1,11,'App\\User','[]','2021-11-15 13:48:00','2021-11-15 13:48:00'),(5760,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-15 14:57:49','2021-11-15 14:57:49'),(5761,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-15 15:16:36','2021-11-15 15:16:36'),(5762,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-11-15 15:44:22','2021-11-15 15:44:22'),(5763,'default','status_changed',229,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-15 15:58:07','2021-11-15 15:58:07'),(5764,'default','added',1411,'App\\Contact',1,4,'App\\User','[]','2021-11-15 16:01:10','2021-11-15 16:01:10'),(5765,'default','status_changed',751,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-15 16:18:51','2021-11-15 16:18:51'),(5766,'default','added',1412,'App\\Contact',1,4,'App\\User','[]','2021-11-15 16:24:29','2021-11-15 16:24:29'),(5767,'default','added',1413,'App\\Contact',1,4,'App\\User','[]','2021-11-15 16:42:41','2021-11-15 16:42:41'),(5768,'default','added',1414,'App\\Contact',1,4,'App\\User','[]','2021-11-15 17:09:35','2021-11-15 17:09:35'),(5769,'default','added',1415,'App\\Contact',1,4,'App\\User','[]','2021-11-15 17:39:12','2021-11-15 17:39:12'),(5770,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-11-15 18:05:22','2021-11-15 18:05:22'),(5771,'default','status_changed',1404,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-15 18:18:51','2021-11-15 18:18:51'),(5772,'default','added',1665,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-11-15 18:23:05','2021-11-15 18:23:05'),(5773,'default','status_changed',1427,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-15 18:23:19','2021-11-15 18:23:19'),(5774,'default','added',1416,'App\\Contact',1,4,'App\\User','[]','2021-11-15 18:55:43','2021-11-15 18:55:43'),(5775,'default','added',1417,'App\\Contact',1,4,'App\\User','[]','2021-11-15 19:21:02','2021-11-15 19:21:02'),(5776,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-15 20:14:56','2021-11-15 20:14:56'),(5777,'default','added',1666,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-11-15 20:18:36','2021-11-15 20:18:36'),(5778,'default','status_changed',1358,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-15 20:18:52','2021-11-15 20:18:52'),(5779,'default','added',1667,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-11-15 20:42:09','2021-11-15 20:42:09'),(5780,'default','status_changed',1430,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-15 20:42:24','2021-11-15 20:42:24'),(5781,'default','added',1668,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-15 20:48:56','2021-11-15 20:48:56'),(5782,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-15 20:50:08','2021-11-15 20:50:08'),(5783,'default','added',1669,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-15 20:50:48','2021-11-15 20:50:48'),(5784,'default','added',1670,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-15 20:51:48','2021-11-15 20:51:48'),(5785,'default','added',1671,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-15 20:53:59','2021-11-15 20:53:59'),(5786,'default','added',1672,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-15 20:54:52','2021-11-15 20:54:52'),(5787,'default','added',1673,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-15 20:55:42','2021-11-15 20:55:42'),(5788,'default','added',1674,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-11-15 20:57:29','2021-11-15 20:57:29'),(5789,'default','status_changed',1431,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-15 20:57:40','2021-11-15 20:57:40'),(5790,'default','added',1675,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-15 20:59:52','2021-11-15 20:59:52'),(5791,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-15 21:04:50','2021-11-15 21:04:50'),(5792,'default','added',1676,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-11-15 21:27:17','2021-11-15 21:27:17'),(5793,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-11-15 21:27:59','2021-11-15 21:27:59'),(5794,'default','logout',20,'App\\User',1,20,'App\\User','[]','2021-11-15 21:43:55','2021-11-15 21:43:55'),(5795,'default','added',1677,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-11-15 21:49:48','2021-11-15 21:49:48'),(5796,'default','status_changed',1425,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-15 21:50:04','2021-11-15 21:50:04'),(5797,'default','added',1678,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-11-15 22:15:23','2021-11-15 22:15:23'),(5798,'default','status_changed',1415,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-15 22:15:32','2021-11-15 22:15:32'),(5799,'default','added',1679,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-11-15 22:27:04','2021-11-15 22:27:04'),(5800,'default','status_changed',1426,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-15 22:27:48','2021-11-15 22:27:48'),(5801,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-11-16 00:11:32','2021-11-16 00:11:32'),(5802,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-16 11:08:25','2021-11-16 11:08:25'),(5803,'default','added',1418,'App\\Contact',1,11,'App\\User','[]','2021-11-16 11:44:04','2021-11-16 11:44:04'),(5804,'default','added',1419,'App\\Contact',1,11,'App\\User','[]','2021-11-16 11:46:45','2021-11-16 11:46:45'),(5805,'default','added',1420,'App\\Contact',1,11,'App\\User','[]','2021-11-16 13:05:05','2021-11-16 13:05:05'),(5806,'default','added',1680,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}','2021-11-16 13:40:47','2021-11-16 13:40:47'),(5807,'default','status_changed',1398,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-16 13:41:04','2021-11-16 13:41:04'),(5808,'default','added',1421,'App\\Contact',1,11,'App\\User','[]','2021-11-16 14:11:51','2021-11-16 14:11:51'),(5809,'default','added',1681,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-11-16 14:27:34','2021-11-16 14:27:34'),(5810,'default','status_changed',1424,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-16 14:28:01','2021-11-16 14:28:01'),(5811,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-16 14:30:21','2021-11-16 14:30:21'),(5812,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-11-16 14:31:48','2021-11-16 14:31:48'),(5813,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-16 14:47:09','2021-11-16 14:47:09'),(5814,'default','added',1422,'App\\Contact',1,4,'App\\User','[]','2021-11-16 14:52:23','2021-11-16 14:52:23'),(5815,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-16 14:55:13','2021-11-16 14:55:13'),(5816,'default','added',1423,'App\\Contact',1,4,'App\\User','[]','2021-11-16 14:56:08','2021-11-16 14:56:08'),(5817,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-11-16 14:56:52','2021-11-16 14:56:52'),(5818,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-11-16 15:24:33','2021-11-16 15:24:33'),(5819,'default','logout',20,'App\\User',1,20,'App\\User','[]','2021-11-16 15:25:05','2021-11-16 15:25:05'),(5820,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-16 15:25:15','2021-11-16 15:25:15'),(5821,'default','login',15,'App\\User',1,15,'App\\User','[]','2021-11-16 16:02:51','2021-11-16 16:02:51'),(5822,'default','added',1424,'App\\Contact',1,4,'App\\User','[]','2021-11-16 16:09:46','2021-11-16 16:09:46'),(5823,'default','added',1425,'App\\Contact',1,4,'App\\User','[]','2021-11-16 16:40:16','2021-11-16 16:40:16'),(5824,'default','added',1682,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-11-16 17:12:26','2021-11-16 17:12:26'),(5825,'default','status_changed',1439,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-16 17:12:40','2021-11-16 17:12:40'),(5826,'default','added',1683,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-16 17:13:33','2021-11-16 17:13:33'),(5827,'default','added',1426,'App\\Contact',1,4,'App\\User','[]','2021-11-16 17:28:19','2021-11-16 17:28:19'),(5828,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-16 17:47:08','2021-11-16 17:47:08'),(5829,'default','added',1684,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-11-16 18:47:08','2021-11-16 18:47:08'),(5830,'default','status_changed',1432,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-16 18:47:22','2021-11-16 18:47:22'),(5831,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-16 19:06:57','2021-11-16 19:06:57'),(5832,'default','added',1427,'App\\Contact',1,4,'App\\User','[]','2021-11-16 19:21:04','2021-11-16 19:21:04'),(5833,'default','added',1685,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-11-16 19:40:36','2021-11-16 19:40:36'),(5834,'default','added',1686,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1100}}','2021-11-16 19:41:11','2021-11-16 19:41:11'),(5835,'default','status_changed',1321,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-16 19:41:26','2021-11-16 19:41:26'),(5836,'default','added',1428,'App\\Contact',1,4,'App\\User','[]','2021-11-16 20:34:35','2021-11-16 20:34:35'),(5837,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-16 20:57:30','2021-11-16 20:57:30'),(5838,'default','added',1687,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":125}}','2021-11-16 21:07:16','2021-11-16 21:07:16'),(5839,'default','added',1688,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":325}}','2021-11-16 21:08:25','2021-11-16 21:08:25'),(5840,'default','status_changed',1419,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-16 21:09:17','2021-11-16 21:09:17'),(5841,'default','added',1689,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":125}}','2021-11-16 21:09:29','2021-11-16 21:09:29'),(5842,'default','status_changed',1441,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-16 21:09:51','2021-11-16 21:09:51'),(5843,'default','added',1690,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-11-16 21:22:39','2021-11-16 21:22:39'),(5844,'default','status_changed',1433,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-16 21:22:55','2021-11-16 21:22:55'),(5845,'default','added',1691,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-11-16 21:23:49','2021-11-16 21:23:49'),(5846,'default','status_changed',1434,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-16 21:24:13','2021-11-16 21:24:13'),(5847,'default','added',1692,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-11-16 21:42:55','2021-11-16 21:42:55'),(5848,'default','status_changed',1197,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-16 21:43:53','2021-11-16 21:43:53'),(5849,'default','status_changed',1444,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-16 21:45:29','2021-11-16 21:45:29'),(5850,'default','added',1693,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-11-16 22:20:15','2021-11-16 22:20:15'),(5851,'default','status_changed',1435,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-16 22:20:39','2021-11-16 22:20:39'),(5852,'default','added',1694,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-11-16 22:24:13','2021-11-16 22:24:13'),(5853,'default','added',1695,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}','2021-11-16 22:29:18','2021-11-16 22:29:18'),(5854,'default','added',1696,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}','2021-11-16 22:34:33','2021-11-16 22:34:33'),(5855,'default','status_changed',1429,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-16 22:35:03','2021-11-16 22:35:03'),(5856,'default','logout',20,'App\\User',1,20,'App\\User','[]','2021-11-16 22:36:03','2021-11-16 22:36:03'),(5857,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-11-16 22:36:12','2021-11-16 22:36:12'),(5858,'default','added',1697,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-16 22:37:30','2021-11-16 22:37:30'),(5859,'default','added',1698,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-16 22:38:19','2021-11-16 22:38:19'),(5860,'default','added',1699,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-16 22:39:11','2021-11-16 22:39:11'),(5861,'default','added',1700,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-16 22:40:27','2021-11-16 22:40:27'),(5862,'default','added',1701,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-16 22:47:29','2021-11-16 22:47:29'),(5863,'default','added',1702,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-16 22:49:03','2021-11-16 22:49:03'),(5864,'default','added',1703,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-16 22:50:40','2021-11-16 22:50:40'),(5865,'default','added',1704,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-16 22:51:51','2021-11-16 22:51:51'),(5866,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-11-16 23:23:25','2021-11-16 23:23:25'),(5867,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-11-16 23:23:40','2021-11-16 23:23:40'),(5868,'default','added',1705,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":500}}','2021-11-16 23:27:17','2021-11-16 23:27:17'),(5869,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-11-16 23:34:38','2021-11-16 23:34:38'),(5870,'default','logout',1,'App\\User',1,1,'App\\User','[]','2021-11-16 23:35:11','2021-11-16 23:35:11'),(5871,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-11-17 01:32:29','2021-11-17 01:32:29'),(5872,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-17 11:16:27','2021-11-17 11:16:27'),(5873,'default','added',1429,'App\\Contact',1,11,'App\\User','[]','2021-11-17 11:35:36','2021-11-17 11:35:36'),(5874,'default','added',1430,'App\\Contact',1,11,'App\\User','[]','2021-11-17 12:00:37','2021-11-17 12:00:37'),(5875,'default','added',1431,'App\\Contact',1,11,'App\\User','[]','2021-11-17 12:10:29','2021-11-17 12:10:29'),(5876,'default','added',1706,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}','2021-11-17 12:15:04','2021-11-17 12:15:04'),(5877,'default','status_changed',1443,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-17 12:15:16','2021-11-17 12:15:16'),(5878,'default','added',1432,'App\\Contact',1,11,'App\\User','[]','2021-11-17 13:23:47','2021-11-17 13:23:47'),(5879,'default','status_changed',1252,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-11-17 13:38:53','2021-11-17 13:38:53'),(5880,'default','added',1707,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-11-17 14:03:19','2021-11-17 14:03:19'),(5881,'default','status_changed',1416,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-17 14:03:33','2021-11-17 14:03:33'),(5882,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-17 14:04:47','2021-11-17 14:04:47'),(5883,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-17 14:25:36','2021-11-17 14:25:36'),(5884,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-11-17 15:02:32','2021-11-17 15:02:32'),(5885,'default','added',1433,'App\\Contact',1,20,'App\\User','[]','2021-11-17 15:03:09','2021-11-17 15:03:09'),(5886,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-11-17 15:07:08','2021-11-17 15:07:08'),(5887,'default','added',1434,'App\\Contact',1,4,'App\\User','[]','2021-11-17 15:08:41','2021-11-17 15:08:41'),(5888,'default','added',1435,'App\\Contact',1,20,'App\\User','[]','2021-11-17 15:20:10','2021-11-17 15:20:10'),(5889,'default','added',1436,'App\\Contact',1,20,'App\\User','[]','2021-11-17 16:17:31','2021-11-17 16:17:31'),(5890,'default','added',1437,'App\\Contact',1,20,'App\\User','[]','2021-11-17 16:46:32','2021-11-17 16:46:32'),(5891,'default','added',1708,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":200}}','2021-11-17 17:12:19','2021-11-17 17:12:19'),(5892,'default','status_changed',1397,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-17 17:13:09','2021-11-17 17:13:09'),(5893,'default','added',1709,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-11-17 17:15:41','2021-11-17 17:15:41'),(5894,'default','status_changed',1453,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-17 17:15:52','2021-11-17 17:15:52'),(5895,'default','added',1438,'App\\Contact',1,20,'App\\User','[]','2021-11-17 17:36:35','2021-11-17 17:36:35'),(5896,'default','added',1710,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-11-17 18:41:23','2021-11-17 18:41:23'),(5897,'default','status_changed',1449,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-17 18:41:35','2021-11-17 18:41:35'),(5898,'default','added',1711,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":175}}','2021-11-17 18:52:22','2021-11-17 18:52:22'),(5899,'default','status_changed',1447,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-17 18:52:32','2021-11-17 18:52:32'),(5900,'default','added',1439,'App\\Contact',1,20,'App\\User','[]','2021-11-17 19:26:18','2021-11-17 19:26:18'),(5901,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-11-17 19:35:08','2021-11-17 19:35:08'),(5902,'default','added',1440,'App\\Contact',1,20,'App\\User','[]','2021-11-17 19:40:23','2021-11-17 19:40:23'),(5903,'default','added',1441,'App\\Contact',1,20,'App\\User','[]','2021-11-17 20:09:31','2021-11-17 20:09:31'),(5904,'default','added',1712,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-11-17 20:19:57','2021-11-17 20:19:57'),(5905,'default','status_changed',1436,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-17 20:20:14','2021-11-17 20:20:14'),(5906,'default','added',1713,'App\\Transaction',1,20,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}','2021-11-17 20:21:10','2021-11-17 20:21:10'),(5907,'default','status_changed',1448,'Modules\\Repair\\Entities\\JobSheet',1,20,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-17 20:21:27','2021-11-17 20:21:27'),(5908,'default','logout',20,'App\\User',1,20,'App\\User','[]','2021-11-17 20:21:36','2021-11-17 20:21:36'),(5909,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-11-17 20:21:45','2021-11-17 20:21:45'),(5910,'default','added',1714,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}','2021-11-17 20:24:14','2021-11-17 20:24:14'),(5911,'default','status_changed',1452,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-17 20:24:27','2021-11-17 20:24:27'),(5912,'default','added',1715,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-17 20:34:09','2021-11-17 20:34:09'),(5913,'default','added',1716,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-17 20:35:31','2021-11-17 20:35:31'),(5914,'default','added',1717,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-11-17 20:47:00','2021-11-17 20:47:00'),(5915,'default','status_changed',1454,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-17 20:47:11','2021-11-17 20:47:11'),(5916,'default','added',1718,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25}}','2021-11-17 20:58:01','2021-11-17 20:58:01'),(5917,'default','status_changed',1456,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-17 20:58:41','2021-11-17 20:58:41'),(5918,'default','added',1442,'App\\Contact',1,4,'App\\User','[]','2021-11-17 21:52:41','2021-11-17 21:52:41'),(5919,'default','added',1443,'App\\Contact',1,4,'App\\User','[]','2021-11-17 22:10:25','2021-11-17 22:10:25'),(5920,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-17 22:19:55','2021-11-17 22:19:55'),(5921,'default','added',1719,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}','2021-11-17 22:41:22','2021-11-17 22:41:22'),(5922,'default','status_changed',1461,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-17 22:41:38','2021-11-17 22:41:38'),(5923,'default','added',1720,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-17 22:46:23','2021-11-17 22:46:23'),(5924,'default','added',1721,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-17 22:47:22','2021-11-17 22:47:22'),(5925,'default','added',1722,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-17 22:50:43','2021-11-17 22:50:43'),(5926,'default','added',1723,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}','2021-11-17 23:09:15','2021-11-17 23:09:15'),(5927,'default','status_changed',1462,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-17 23:09:33','2021-11-17 23:09:33'),(5928,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-11-17 23:10:12','2021-11-17 23:10:12'),(5929,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-11-17 23:22:24','2021-11-17 23:22:24'),(5930,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-11-17 23:24:48','2021-11-17 23:24:48'),(5931,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-11-17 23:40:04','2021-11-17 23:40:04'),(5932,'default','added',1444,'App\\Contact',1,4,'App\\User','[]','2021-11-17 23:41:00','2021-11-17 23:41:00'),(5933,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-11-17 23:47:13','2021-11-17 23:47:13'),(5934,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-18 11:28:19','2021-11-18 11:28:19'),(5935,'default','added',1445,'App\\Contact',1,11,'App\\User','[]','2021-11-18 12:24:32','2021-11-18 12:24:32'),(5936,'default','status_changed',1252,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-18 13:08:36','2021-11-18 13:08:36'),(5937,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-11-18 13:51:52','2021-11-18 13:51:52'),(5938,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-18 14:21:34','2021-11-18 14:21:34'),(5939,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-11-18 14:43:01','2021-11-18 14:43:01'),(5940,'default','status_changed',1370,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-18 15:02:30','2021-11-18 15:02:30'),(5941,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-18 15:14:42','2021-11-18 15:14:42'),(5942,'default','added',1446,'App\\Contact',1,4,'App\\User','[]','2021-11-18 17:00:53','2021-11-18 17:00:53'),(5943,'default','added',1724,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-11-18 17:05:15','2021-11-18 17:05:15'),(5944,'default','status_changed',1459,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-18 17:05:28','2021-11-18 17:05:28'),(5945,'default','added',1725,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-18 17:17:55','2021-11-18 17:17:55'),(5946,'default','added',1726,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-18 17:18:30','2021-11-18 17:18:30'),(5947,'default','added',1447,'App\\Contact',1,4,'App\\User','[]','2021-11-18 17:52:42','2021-11-18 17:52:42'),(5948,'default','added',1727,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-11-18 19:03:12','2021-11-18 19:03:12'),(5949,'default','status_changed',1468,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-18 19:03:37','2021-11-18 19:03:37'),(5950,'default','added',1448,'App\\Contact',1,4,'App\\User','[]','2021-11-18 19:35:28','2021-11-18 19:35:28'),(5951,'default','added',1449,'App\\Contact',1,4,'App\\User','[]','2021-11-18 19:44:38','2021-11-18 19:44:38'),(5952,'default','added',1728,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":450}}','2021-11-18 19:59:05','2021-11-18 19:59:05'),(5953,'default','added',1729,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-11-18 20:00:13','2021-11-18 20:00:13'),(5954,'default','status_changed',1467,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-18 20:00:49','2021-11-18 20:00:49'),(5955,'default','added',1450,'App\\Contact',1,4,'App\\User','[]','2021-11-18 20:06:41','2021-11-18 20:06:41'),(5956,'default','added',1451,'App\\Contact',1,4,'App\\User','[]','2021-11-18 20:36:31','2021-11-18 20:36:31'),(5957,'default','added',1452,'App\\Contact',1,4,'App\\User','[]','2021-11-18 20:45:57','2021-11-18 20:45:57'),(5958,'default','added',1730,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-11-18 21:03:52','2021-11-18 21:03:52'),(5959,'default','status_changed',1458,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-18 21:08:02','2021-11-18 21:08:02'),(5960,'default','added',1731,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-11-18 21:10:02','2021-11-18 21:10:02'),(5961,'default','status_changed',1457,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-18 21:10:12','2021-11-18 21:10:12'),(5962,'default','added',1453,'App\\Contact',1,4,'App\\User','[]','2021-11-18 21:34:28','2021-11-18 21:34:28'),(5963,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-18 21:44:46','2021-11-18 21:44:46'),(5964,'default','added',1732,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}','2021-11-18 21:48:15','2021-11-18 21:48:15'),(5965,'default','status_changed',1418,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-18 21:48:57','2021-11-18 21:48:57'),(5966,'default','added',1733,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-18 21:50:08','2021-11-18 21:50:08'),(5967,'default','added',1734,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-18 21:50:44','2021-11-18 21:50:44'),(5968,'default','added',1735,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-18 21:51:15','2021-11-18 21:51:15'),(5969,'default','added',1736,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-18 21:51:43','2021-11-18 21:51:43'),(5970,'default','added',1737,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":125}}','2021-11-18 22:07:57','2021-11-18 22:07:57'),(5971,'default','status_changed',1473,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-18 22:08:10','2021-11-18 22:08:10'),(5972,'default','added',1738,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-18 22:15:13','2021-11-18 22:15:13'),(5973,'default','added',1739,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-18 22:16:23','2021-11-18 22:16:23'),(5974,'default','logout',4,'App\\User',1,4,'App\\User','[]','2021-11-18 22:48:26','2021-11-18 22:48:26'),(5975,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-19 13:56:27','2021-11-19 13:56:27'),(5976,'default','added',1740,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":875}}','2021-11-19 13:59:57','2021-11-19 13:59:57'),(5977,'default','status_changed',1460,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-19 14:00:11','2021-11-19 14:00:11'),(5978,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-19 14:18:58','2021-11-19 14:18:58'),(5979,'default','added',1454,'App\\Contact',1,11,'App\\User','[]','2021-11-19 14:19:27','2021-11-19 14:19:27'),(5980,'default','added',1455,'App\\Contact',1,11,'App\\User','[]','2021-11-19 15:07:20','2021-11-19 15:07:20'),(5981,'default','added',1456,'App\\Contact',1,11,'App\\User','[]','2021-11-19 15:25:47','2021-11-19 15:25:47'),(5982,'default','added',1457,'App\\Contact',1,11,'App\\User','[]','2021-11-19 15:52:58','2021-11-19 15:52:58'),(5983,'default','added',1458,'App\\Contact',1,11,'App\\User','[]','2021-11-19 16:14:38','2021-11-19 16:14:38'),(5984,'default','added',1459,'App\\Contact',1,11,'App\\User','[]','2021-11-19 17:03:38','2021-11-19 17:03:38'),(5985,'default','added',1460,'App\\Contact',1,11,'App\\User','[]','2021-11-19 18:14:26','2021-11-19 18:14:26'),(5986,'default','added',1461,'App\\Contact',1,11,'App\\User','[]','2021-11-19 19:38:59','2021-11-19 19:38:59'),(5987,'default','added',1741,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-11-19 20:35:29','2021-11-19 20:35:29'),(5988,'default','added',1742,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-11-19 20:35:51','2021-11-19 20:35:51'),(5989,'default','status_changed',1437,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-19 20:36:04','2021-11-19 20:36:04'),(5990,'default','status_changed',1451,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-19 20:36:14','2021-11-19 20:36:14'),(5991,'default','added',1462,'App\\Contact',1,11,'App\\User','[]','2021-11-19 21:44:14','2021-11-19 21:44:14'),(5992,'default','status_changed',1479,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-19 21:57:18','2021-11-19 21:57:18'),(5993,'default','status_changed',1478,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-19 21:57:25','2021-11-19 21:57:25'),(5994,'default','status_changed',1475,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-19 21:57:35','2021-11-19 21:57:35'),(5995,'default','status_changed',1483,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-19 21:57:45','2021-11-19 21:57:45'),(5996,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-19 22:53:31','2021-11-19 22:53:31'),(5997,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-20 11:23:47','2021-11-20 11:23:47'),(5998,'default','added',1463,'App\\Contact',1,11,'App\\User','[]','2021-11-20 11:26:07','2021-11-20 11:26:07'),(5999,'default','added',1743,'App\\Transaction',1,11,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-11-20 12:09:06','2021-11-20 12:09:06'),(6000,'default','status_changed',1464,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-20 12:10:53','2021-11-20 12:10:53'),(6001,'default','added',1464,'App\\Contact',1,11,'App\\User','[]','2021-11-20 13:02:47','2021-11-20 13:02:47'),(6002,'default','status_changed',1455,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-20 13:22:00','2021-11-20 13:22:00'),(6003,'default','status_changed',1483,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-20 13:22:06','2021-11-20 13:22:06'),(6004,'default','status_changed',1479,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-20 13:22:13','2021-11-20 13:22:13'),(6005,'default','status_changed',1478,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-20 13:22:19','2021-11-20 13:22:19'),(6006,'default','status_changed',1475,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-20 13:22:26','2021-11-20 13:22:26'),(6007,'default','status_changed',1480,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-20 13:22:37','2021-11-20 13:22:37'),(6008,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-20 14:15:09','2021-11-20 14:15:09'),(6009,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-11-20 14:15:20','2021-11-20 14:15:20'),(6010,'default','added',1744,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-20 14:16:20','2021-11-20 14:16:20'),(6011,'default','added',1745,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-20 14:17:25','2021-11-20 14:17:25'),(6012,'default','added',1465,'App\\Contact',1,4,'App\\User','[]','2021-11-20 14:41:22','2021-11-20 14:41:22'),(6013,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-20 14:48:50','2021-11-20 14:48:50'),(6014,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-11-20 15:02:30','2021-11-20 15:02:30'),(6015,'default','added',1466,'App\\Contact',1,4,'App\\User','[]','2021-11-20 15:05:52','2021-11-20 15:05:52'),(6016,'default','added',1746,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-11-20 15:11:58','2021-11-20 15:11:58'),(6017,'default','added',1747,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-11-20 15:19:46','2021-11-20 15:19:46'),(6018,'default','status_changed',1470,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-20 15:19:55','2021-11-20 15:19:55'),(6019,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-11-20 15:37:28','2021-11-20 15:37:28'),(6020,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-20 15:48:24','2021-11-20 15:48:24'),(6021,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-11-20 15:50:48','2021-11-20 15:50:48'),(6022,'default','added',1748,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-11-20 15:53:33','2021-11-20 15:53:33'),(6023,'default','status_changed',1466,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-20 15:53:46','2021-11-20 15:53:46'),(6024,'default','added',1749,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-11-20 15:54:14','2021-11-20 15:54:14'),(6025,'default','status_changed',1486,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-20 15:54:28','2021-11-20 15:54:28'),(6026,'default','added',1467,'App\\Contact',1,4,'App\\User','[]','2021-11-20 16:47:35','2021-11-20 16:47:35'),(6027,'default','added',1468,'App\\Contact',1,4,'App\\User','[]','2021-11-20 17:17:10','2021-11-20 17:17:10'),(6028,'default','added',1469,'App\\Contact',1,4,'App\\User','[]','2021-11-20 17:46:26','2021-11-20 17:46:26'),(6029,'default','added',1470,'App\\Contact',1,4,'App\\User','[]','2021-11-20 18:00:17','2021-11-20 18:00:17'),(6030,'default','logout',20,'App\\User',1,20,'App\\User','[]','2021-11-20 18:27:14','2021-11-20 18:27:14'),(6031,'default','login',11,'App\\User',1,11,'App\\User','[]','2021-11-20 18:27:29','2021-11-20 18:27:29'),(6032,'default','added',1471,'App\\Contact',1,4,'App\\User','[]','2021-11-20 18:31:42','2021-11-20 18:31:42'),(6033,'default','status_changed',1485,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-11-20 18:35:14','2021-11-20 18:35:14'),(6034,'default','status_changed',1475,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-11-20 18:35:25','2021-11-20 18:35:25'),(6035,'default','status_changed',1479,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-11-20 18:35:33','2021-11-20 18:35:33'),(6036,'default','status_changed',1478,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-11-20 18:35:42','2021-11-20 18:35:42'),(6037,'default','status_changed',1491,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Wating for spare part\"}','2021-11-20 18:43:05','2021-11-20 18:43:05'),(6038,'default','status_changed',1438,'Modules\\Repair\\Entities\\JobSheet',1,11,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-11-20 18:45:07','2021-11-20 18:45:07'),(6039,'default','added',1472,'App\\Contact',1,4,'App\\User','[]','2021-11-20 19:04:37','2021-11-20 19:04:37'),(6040,'default','added',1750,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}','2021-11-20 19:12:17','2021-11-20 19:12:17'),(6041,'default','status_changed',1481,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-20 19:12:54','2021-11-20 19:12:54'),(6042,'default','status_changed',1365,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"Repair in progress\"}','2021-11-20 19:17:01','2021-11-20 19:17:01'),(6043,'default','added',1751,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}','2021-11-20 19:44:13','2021-11-20 19:44:13'),(6044,'default','status_changed',1479,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-20 19:44:24','2021-11-20 19:44:24'),(6045,'default','added',1752,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":550}}','2021-11-20 20:15:29','2021-11-20 20:15:29'),(6046,'default','status_changed',1475,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-20 20:15:51','2021-11-20 20:15:51'),(6047,'default','added',1753,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}','2021-11-20 20:29:34','2021-11-20 20:29:34'),(6048,'default','status_changed',1480,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-20 20:29:47','2021-11-20 20:29:47'),(6049,'default','logout',11,'App\\User',1,11,'App\\User','[]','2021-11-20 21:05:06','2021-11-20 21:05:06'),(6050,'default','added',1754,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}','2021-11-20 21:46:59','2021-11-20 21:46:59'),(6051,'default','status_changed',1489,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-20 21:47:09','2021-11-20 21:47:09'),(6052,'default','added',1755,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}','2021-11-20 21:48:25','2021-11-20 21:48:25'),(6053,'default','status_changed',1490,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-20 21:50:06','2021-11-20 21:50:06'),(6054,'default','added',1756,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}','2021-11-20 21:51:14','2021-11-20 21:51:14'),(6055,'default','status_changed',1485,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-20 21:51:26','2021-11-20 21:51:26'),(6056,'default','added',1757,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-20 21:53:21','2021-11-20 21:53:21'),(6057,'default','added',1758,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-20 21:54:03','2021-11-20 21:54:03'),(6058,'default','added',1759,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-20 21:54:40','2021-11-20 21:54:40'),(6059,'default','added',1760,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-20 21:55:11','2021-11-20 21:55:11'),(6060,'default','added',1761,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-20 21:56:00','2021-11-20 21:56:00'),(6061,'default','added',1762,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-20 21:57:03','2021-11-20 21:57:03'),(6062,'default','status_changed',1249,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-20 22:03:30','2021-11-20 22:03:30'),(6063,'default','status_changed',1251,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-20 22:03:38','2021-11-20 22:03:38'),(6064,'default','status_changed',1406,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-20 22:10:42','2021-11-20 22:10:42'),(6065,'default','status_changed',1422,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-20 22:10:54','2021-11-20 22:10:54'),(6066,'default','status_changed',1231,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-20 22:12:12','2021-11-20 22:12:12'),(6067,'default','status_changed',1227,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-20 22:13:20','2021-11-20 22:13:20'),(6068,'default','status_changed',1230,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-20 22:14:16','2021-11-20 22:14:16'),(6069,'default','login',4,'App\\User',1,4,'App\\User','[]','2021-11-21 12:17:56','2021-11-21 12:17:56'),(6070,'default','added',1763,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}','2021-11-21 12:26:44','2021-11-21 12:26:44'),(6071,'default','status_changed',1484,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-21 12:27:18','2021-11-21 12:27:18'),(6072,'default','added',1473,'App\\Contact',1,4,'App\\User','[]','2021-11-21 13:38:08','2021-11-21 13:38:08'),(6073,'default','login',20,'App\\User',1,20,'App\\User','[]','2021-11-21 15:56:03','2021-11-21 15:56:03'),(6074,'default','status_changed',1463,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-21 15:58:17','2021-11-21 15:58:17'),(6075,'default','added',1474,'App\\Contact',1,4,'App\\User','[]','2021-11-21 16:07:45','2021-11-21 16:07:45'),(6076,'default','added',1764,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-11-21 16:17:23','2021-11-21 16:17:23'),(6077,'default','status_changed',1478,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-21 16:18:04','2021-11-21 16:18:04'),(6078,'default','added',1765,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-21 16:23:44','2021-11-21 16:23:44'),(6079,'default','added',1766,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}','2021-11-21 17:13:35','2021-11-21 17:13:35'),(6080,'default','status_changed',1488,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-21 17:13:52','2021-11-21 17:13:52'),(6081,'default','added',1475,'App\\Contact',1,4,'App\\User','[]','2021-11-21 17:45:41','2021-11-21 17:45:41'),(6082,'default','added',1767,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}','2021-11-21 19:04:10','2021-11-21 19:04:10'),(6083,'default','status_changed',1049,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-21 19:28:34','2021-11-21 19:28:34'),(6084,'default','added',1768,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-21 19:54:54','2021-11-21 19:54:54'),(6085,'default','added',1769,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-21 19:56:56','2021-11-21 19:56:56'),(6086,'default','added',1770,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-21 19:57:25','2021-11-21 19:57:25'),(6087,'default','added',1771,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-21 19:58:07','2021-11-21 19:58:07'),(6088,'default','added',1772,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-21 19:58:49','2021-11-21 19:58:49'),(6089,'default','added',1773,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}','2021-11-21 19:59:22','2021-11-21 19:59:22'),(6090,'default','added',1774,'App\\Transaction',1,4,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}','2021-11-21 20:00:50','2021-11-21 20:00:50'),(6091,'default','status_changed',1494,'Modules\\Repair\\Entities\\JobSheet',1,4,'App\\User','{\"update_note\":null,\"updated_status\":\"DELIVERED\"}','2021-11-21 20:01:02','2021-11-21 20:01:02'),(6092,'default','logout',20,'App\\User',1,20,'App\\User','[]','2021-11-21 20:05:28','2021-11-21 20:05:28'),(6093,'default','login',1,'App\\User',1,1,'App\\User','[]','2021-11-21 20:05:42','2021-11-21 20:05:42'),(6094,'default','payment_edited',1752,'App\\Transaction',1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"550.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"550.0000\"}}','2021-11-21 20:07:03','2021-11-21 20:07:03'),(6095,'default','added',1476,'App\\Contact',1,4,'App\\User','[]','2021-11-21 20:17:42','2021-11-21 20:17:42'),(6096,'default','edited',1773,'App\\Transaction',1,4,'App\\User','